# coding: utf-8

from typing import Dict, List  # noqa: F401
import importlib
import pkgutil

from openapi_server_v2.apis.completions_api_base import BaseCompletionsApi
import impl

from fastapi import (  # noqa: F401
    APIRouter,
    Body,
    Cookie,
    Depends,
    Form,
    Header,
    Path,
    Query,
    Response,
    Security,
    status,
)

from openapi_server_v2.models.extra_models import TokenModel  # noqa: F401
from openapi_server_v2.models.create_completion_request import CreateCompletionRequest
from openapi_server_v2.models.create_completion_response import CreateCompletionResponse
from openapi_server_v2.security_api import get_token_ApiKeyAuth

router = APIRouter()

ns_pkg = impl
for _, name, _ in pkgutil.iter_modules(ns_pkg.__path__, ns_pkg.__name__ + "."):
    importlib.import_module(name)


@router.post(
    "/completions",
    responses={
        200: {"model": CreateCompletionResponse, "description": "OK"},
    },
    tags=["Completions"],
    summary="Creates a completion for the provided prompt and parameters.",
    response_model_by_alias=True,
)
async def create_completion(
    create_completion_request: CreateCompletionRequest = Body(None, description="")
,
    token_ApiKeyAuth: TokenModel = Security(
        get_token_ApiKeyAuth
    ),
) -> CreateCompletionResponse:
    ...
