# coding: utf-8

"""
    OpenAI API

    The OpenAI REST API. Please see https://platform.openai.com/docs/api-reference for more details.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from openapi_server.models.assistant_object_tools_inner import AssistantObjectToolsInner
from openapi_server.models.run_completion_usage import RunCompletionUsage
from openapi_server.models.run_object_last_error import RunObjectLastError
from openapi_server.models.run_object_required_action import RunObjectRequiredAction
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class RunObject(BaseModel):
    """
    Represents an execution run on a [thread](/docs/api-reference/threads).
    """ # noqa: E501
    id: StrictStr = Field(description="The identifier, which can be referenced in API endpoints.")
    object: StrictStr = Field(description="The object type, which is always `thread.run`.")
    created_at: StrictInt = Field(description="The Unix timestamp (in seconds) for when the run was created.")
    thread_id: StrictStr = Field(description="The ID of the [thread](/docs/api-reference/threads) that was executed on as a part of this run.")
    assistant_id: StrictStr = Field(description="The ID of the [assistant](/docs/api-reference/assistants) used for execution of this run.")
    status: StrictStr = Field(description="The status of the run, which can be either `queued`, `in_progress`, `requires_action`, `cancelling`, `cancelled`, `failed`, `completed`, or `expired`.")
    required_action: Optional[RunObjectRequiredAction]
    last_error: Optional[RunObjectLastError]
    expires_at: StrictInt = Field(description="The Unix timestamp (in seconds) for when the run will expire.")
    started_at: Optional[StrictInt] = Field(description="The Unix timestamp (in seconds) for when the run was started.")
    cancelled_at: Optional[StrictInt] = Field(description="The Unix timestamp (in seconds) for when the run was cancelled.")
    failed_at: Optional[StrictInt] = Field(description="The Unix timestamp (in seconds) for when the run failed.")
    completed_at: Optional[StrictInt] = Field(description="The Unix timestamp (in seconds) for when the run was completed.")
    model: StrictStr = Field(description="The model that the [assistant](/docs/api-reference/assistants) used for this run.")
    instructions: StrictStr = Field(description="The instructions that the [assistant](/docs/api-reference/assistants) used for this run.")
    tools: Annotated[List[AssistantObjectToolsInner], Field(max_length=20)] = Field(description="The list of tools that the [assistant](/docs/api-reference/assistants) used for this run.")
    file_ids: List[StrictStr] = Field(description="The list of [File](/docs/api-reference/files) IDs the [assistant](/docs/api-reference/assistants) used for this run.")
    metadata: Optional[Dict[str, Any]] = Field(description="metadata_description")
    usage: Optional[RunCompletionUsage]
    __properties: ClassVar[List[str]] = ["id", "object", "created_at", "thread_id", "assistant_id", "status", "required_action", "last_error", "expires_at", "started_at", "cancelled_at", "failed_at", "completed_at", "model", "instructions", "tools", "file_ids", "metadata", "usage"]

    @field_validator('object')
    def object_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('thread.run'):
            raise ValueError("must be one of enum values ('thread.run')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('queued', 'in_progress', 'requires_action', 'cancelling', 'cancelled', 'failed', 'completed', 'expired', 'generating'):
            raise ValueError("must be one of enum values ('queued', 'in_progress', 'requires_action', 'cancelling', 'cancelled', 'failed', 'completed', 'expired', 'generating')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of RunObject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of required_action
        if self.required_action:
            _dict['required_action'] = self.required_action.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_error
        if self.last_error:
            _dict['last_error'] = self.last_error.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tools (list)
        _items = []
        if self.tools:
            for _item in self.tools:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tools'] = _items
        # override the default output from pydantic by calling `to_dict()` of usage
        if self.usage:
            _dict['usage'] = self.usage.to_dict()
        # set to None if required_action (nullable) is None
        # and model_fields_set contains the field
        if self.required_action is None and "required_action" in self.model_fields_set:
            _dict['required_action'] = None

        # set to None if last_error (nullable) is None
        # and model_fields_set contains the field
        if self.last_error is None and "last_error" in self.model_fields_set:
            _dict['last_error'] = None

        # set to None if started_at (nullable) is None
        # and model_fields_set contains the field
        if self.started_at is None and "started_at" in self.model_fields_set:
            _dict['started_at'] = None

        # set to None if cancelled_at (nullable) is None
        # and model_fields_set contains the field
        if self.cancelled_at is None and "cancelled_at" in self.model_fields_set:
            _dict['cancelled_at'] = None

        # set to None if failed_at (nullable) is None
        # and model_fields_set contains the field
        if self.failed_at is None and "failed_at" in self.model_fields_set:
            _dict['failed_at'] = None

        # set to None if completed_at (nullable) is None
        # and model_fields_set contains the field
        if self.completed_at is None and "completed_at" in self.model_fields_set:
            _dict['completed_at'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if usage (nullable) is None
        # and model_fields_set contains the field
        if self.usage is None and "usage" in self.model_fields_set:
            _dict['usage'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of RunObject from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "created_at": obj.get("created_at"),
            "thread_id": obj.get("thread_id"),
            "assistant_id": obj.get("assistant_id"),
            "status": obj.get("status"),
            "required_action": RunObjectRequiredAction.from_dict(obj.get("required_action")) if obj.get("required_action") is not None else None,
            "last_error": RunObjectLastError.from_dict(obj.get("last_error")) if obj.get("last_error") is not None else None,
            "expires_at": obj.get("expires_at"),
            "started_at": obj.get("started_at"),
            "cancelled_at": obj.get("cancelled_at"),
            "failed_at": obj.get("failed_at"),
            "completed_at": obj.get("completed_at"),
            "model": obj.get("model"),
            "instructions": obj.get("instructions"),
            "tools": [AssistantObjectToolsInner.from_dict(_item) for _item in obj.get("tools")] if obj.get("tools") is not None else None,
            "file_ids": obj.get("file_ids"),
            "metadata": obj.get("metadata"),
            "usage": RunCompletionUsage.from_dict(obj.get("usage")) if obj.get("usage") is not None else None
        })
        return _obj


