# coding: utf-8

"""
    OpenAI API

    The OpenAI REST API. Please see https://platform.openai.com/docs/api-reference for more details.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from openapi_server.models.chat_completion_functions import ChatCompletionFunctions
from openapi_server.models.chat_completion_request_message import ChatCompletionRequestMessage
from openapi_server.models.chat_completion_tool import ChatCompletionTool
from openapi_server.models.chat_completion_tool_choice_option import ChatCompletionToolChoiceOption
from openapi_server.models.create_chat_completion_request_function_call import CreateChatCompletionRequestFunctionCall
from openapi_server.models.create_chat_completion_request_model import CreateChatCompletionRequestModel
from openapi_server.models.create_chat_completion_request_response_format import CreateChatCompletionRequestResponseFormat
from openapi_server.models.create_chat_completion_request_stop import CreateChatCompletionRequestStop
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class CreateChatCompletionRequest(BaseModel):
    """
    CreateChatCompletionRequest
    """ # noqa: E501
    messages: Annotated[List[ChatCompletionRequestMessage], Field(min_length=1)] = Field(description="A list of messages comprising the conversation so far. [Example Python code](https://cookbook.openai.com/examples/how_to_format_inputs_to_chatgpt_models).")
    model: CreateChatCompletionRequestModel
    frequency_penalty: Optional[Union[Annotated[float, Field(le=2, strict=True, ge=-2)], Annotated[int, Field(le=2, strict=True, ge=-2)]]] = Field(default=0, description="completions_frequency_penalty_description")
    logit_bias: Optional[Dict[str, StrictInt]] = Field(default=None, description="Modify the likelihood of specified tokens appearing in the completion.  Accepts a JSON object that maps tokens (specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token. ")
    logprobs: Optional[StrictBool] = Field(default=False, description="Whether to return log probabilities of the output tokens or not. If true, returns the log probabilities of each output token returned in the `content` of `message`. This option is currently not available on the `gpt-4-vision-preview` model.")
    top_logprobs: Optional[Annotated[int, Field(le=5, strict=True, ge=0)]] = Field(default=None, description="An integer between 0 and 5 specifying the number of most likely tokens to return at each token position, each with an associated log probability. `logprobs` must be set to `true` if this parameter is used.")
    max_tokens: Optional[StrictInt] = Field(default=None, description="The maximum number of [tokens](/tokenizer) that can be generated in the chat completion.  The total length of input tokens and generated tokens is limited by the model's context length. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens. ")
    n: Optional[Annotated[int, Field(le=128, strict=True, ge=1)]] = Field(default=1, description="How many chat completion choices to generate for each input message. Note that you will be charged based on the number of generated tokens across all of the choices. Keep `n` as `1` to minimize costs.")
    presence_penalty: Optional[Union[Annotated[float, Field(le=2, strict=True, ge=-2)], Annotated[int, Field(le=2, strict=True, ge=-2)]]] = Field(default=0, description="completions_presence_penalty_description")
    response_format: Optional[CreateChatCompletionRequestResponseFormat] = None
    seed: Optional[Annotated[int, Field(le=9223372036854775807, strict=True, ge=-9223372036854775808)]] = Field(default=None, description="This feature is in Beta. If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same `seed` and parameters should return the same result. Determinism is not guaranteed, and you should refer to the `system_fingerprint` response parameter to monitor changes in the backend. ")
    stop: Optional[CreateChatCompletionRequestStop] = None
    stream: Optional[StrictBool] = Field(default=False, description="If set, partial message deltas will be sent, like in ChatGPT. Tokens will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available, with the stream terminated by a `data: [DONE]` message. [Example Python code](https://cookbook.openai.com/examples/how_to_stream_completions). ")
    temperature: Optional[Union[Annotated[float, Field(le=2, strict=True, ge=0)], Annotated[int, Field(le=2, strict=True, ge=0)]]] = Field(default=1, description="completions_temperature_description")
    top_p: Optional[Union[Annotated[float, Field(le=1, strict=True, ge=0)], Annotated[int, Field(le=1, strict=True, ge=0)]]] = Field(default=1, description="completions_top_p_description")
    tools: Optional[List[ChatCompletionTool]] = Field(default=None, description="A list of tools the model may call. Currently, only functions are supported as a tool. Use this to provide a list of functions the model may generate JSON inputs for. ")
    tool_choice: Optional[ChatCompletionToolChoiceOption] = None
    function_call: Optional[CreateChatCompletionRequestFunctionCall] = None
    functions: Optional[Annotated[List[ChatCompletionFunctions], Field(min_length=1, max_length=128)]] = Field(default=None, description="Deprecated in favor of `tools`.  A list of functions the model may generate JSON inputs for. ")
    __properties: ClassVar[List[str]] = ["messages", "model", "frequency_penalty", "logit_bias", "logprobs", "top_logprobs", "max_tokens", "n", "presence_penalty", "response_format", "seed", "stop", "stream", "temperature", "top_p", "tools", "tool_choice", "function_call", "functions"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CreateChatCompletionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in messages (list)
        _items = []
        if self.messages:
            for _item in self.messages:
                if _item:
                    _items.append(_item.to_dict())
            _dict['messages'] = _items
        # override the default output from pydantic by calling `to_dict()` of model
        if self.model:
            _dict['model'] = self.model.to_dict()
        # override the default output from pydantic by calling `to_dict()` of response_format
        if self.response_format:
            _dict['response_format'] = self.response_format.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stop
        if self.stop:
            _dict['stop'] = self.stop.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tools (list)
        _items = []
        if self.tools:
            for _item in self.tools:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tools'] = _items
        # override the default output from pydantic by calling `to_dict()` of tool_choice
        if self.tool_choice:
            _dict['tool_choice'] = self.tool_choice.to_dict()
        # override the default output from pydantic by calling `to_dict()` of function_call
        if self.function_call:
            _dict['function_call'] = self.function_call.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in functions (list)
        _items = []
        if self.functions:
            for _item in self.functions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['functions'] = _items
        # set to None if frequency_penalty (nullable) is None
        # and model_fields_set contains the field
        if self.frequency_penalty is None and "frequency_penalty" in self.model_fields_set:
            _dict['frequency_penalty'] = None

        # set to None if logit_bias (nullable) is None
        # and model_fields_set contains the field
        if self.logit_bias is None and "logit_bias" in self.model_fields_set:
            _dict['logit_bias'] = None

        # set to None if logprobs (nullable) is None
        # and model_fields_set contains the field
        if self.logprobs is None and "logprobs" in self.model_fields_set:
            _dict['logprobs'] = None

        # set to None if top_logprobs (nullable) is None
        # and model_fields_set contains the field
        if self.top_logprobs is None and "top_logprobs" in self.model_fields_set:
            _dict['top_logprobs'] = None

        # set to None if max_tokens (nullable) is None
        # and model_fields_set contains the field
        if self.max_tokens is None and "max_tokens" in self.model_fields_set:
            _dict['max_tokens'] = None

        # set to None if n (nullable) is None
        # and model_fields_set contains the field
        if self.n is None and "n" in self.model_fields_set:
            _dict['n'] = None

        # set to None if presence_penalty (nullable) is None
        # and model_fields_set contains the field
        if self.presence_penalty is None and "presence_penalty" in self.model_fields_set:
            _dict['presence_penalty'] = None

        # set to None if seed (nullable) is None
        # and model_fields_set contains the field
        if self.seed is None and "seed" in self.model_fields_set:
            _dict['seed'] = None

        # set to None if stream (nullable) is None
        # and model_fields_set contains the field
        if self.stream is None and "stream" in self.model_fields_set:
            _dict['stream'] = None

        # set to None if temperature (nullable) is None
        # and model_fields_set contains the field
        if self.temperature is None and "temperature" in self.model_fields_set:
            _dict['temperature'] = None

        # set to None if top_p (nullable) is None
        # and model_fields_set contains the field
        if self.top_p is None and "top_p" in self.model_fields_set:
            _dict['top_p'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of CreateChatCompletionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "messages": [ChatCompletionRequestMessage.from_dict(_item) for _item in obj.get("messages")] if obj.get("messages") is not None else None,
            "model": CreateChatCompletionRequestModel.from_dict(obj.get("model")) if obj.get("model") is not None else None,
            "frequency_penalty": obj.get("frequency_penalty") if obj.get("frequency_penalty") is not None else 0,
            "logit_bias": obj.get("logit_bias"),
            "logprobs": obj.get("logprobs") if obj.get("logprobs") is not None else False,
            "top_logprobs": obj.get("top_logprobs"),
            "max_tokens": obj.get("max_tokens"),
            "n": obj.get("n") if obj.get("n") is not None else 1,
            "presence_penalty": obj.get("presence_penalty") if obj.get("presence_penalty") is not None else 0,
            "response_format": CreateChatCompletionRequestResponseFormat.from_dict(obj.get("response_format")) if obj.get("response_format") is not None else None,
            "seed": obj.get("seed"),
            "stop": CreateChatCompletionRequestStop.from_dict(obj.get("stop")) if obj.get("stop") is not None else None,
            "stream": obj.get("stream") if obj.get("stream") is not None else False,
            "temperature": obj.get("temperature") if obj.get("temperature") is not None else 1,
            "top_p": obj.get("top_p") if obj.get("top_p") is not None else 1,
            "tools": [ChatCompletionTool.from_dict(_item) for _item in obj.get("tools")] if obj.get("tools") is not None else None,
            "tool_choice": ChatCompletionToolChoiceOption.from_dict(obj.get("tool_choice")) if obj.get("tool_choice") is not None else None,
            "function_call": CreateChatCompletionRequestFunctionCall.from_dict(obj.get("function_call")) if obj.get("function_call") is not None else None,
            "functions": [ChatCompletionFunctions.from_dict(_item) for _item in obj.get("functions")] if obj.get("functions") is not None else None
        })
        return _obj


