# coding: utf-8

from __future__ import annotations
from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, Field, validator  # noqa: F401
from openapi_server.models.chat_completion_message_tool_call import ChatCompletionMessageToolCall
from openapi_server.models.chat_completion_request_assistant_message import ChatCompletionRequestAssistantMessage
from openapi_server.models.chat_completion_request_assistant_message_function_call import ChatCompletionRequestAssistantMessageFunctionCall
from openapi_server.models.chat_completion_request_function_message import ChatCompletionRequestFunctionMessage
from openapi_server.models.chat_completion_request_system_message import ChatCompletionRequestSystemMessage
from openapi_server.models.chat_completion_request_tool_message import ChatCompletionRequestToolMessage
from openapi_server.models.chat_completion_request_user_message import ChatCompletionRequestUserMessage


class ChatCompletionRequestMessage(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    ChatCompletionRequestMessage - a model defined in OpenAPI

        content: The content of this ChatCompletionRequestMessage.
        role: The role of this ChatCompletionRequestMessage.
        name: The name of this ChatCompletionRequestMessage.
        tool_calls: The tool_calls of this ChatCompletionRequestMessage [Optional].
        function_call: The function_call of this ChatCompletionRequestMessage [Optional].
        tool_call_id: The tool_call_id of this ChatCompletionRequestMessage.
    """

    content: Optional[str] = Field(alias="content")
    role: str = Field(alias="role")
    name: Optional[str] = Field(alias="name", default=None)
    tool_calls: Optional[List[ChatCompletionMessageToolCall]] = Field(alias="tool_calls", default=None)
    function_call: Optional[ChatCompletionRequestAssistantMessageFunctionCall] = Field(alias="function_call", default=None)
    tool_call_id: Optional[str] = Field(alias="tool_call_id", default=None)

ChatCompletionRequestMessage.update_forward_refs()