# README: Project-Portfolio-Indian Accident Data Analysis with Power BI and SQL

## Overview

This repository contains a data analysis project focused on Indian accident data. The analysis is performed using Power BI for visualization and SQL for data manipulation and querying.

## Dataset

The dataset used for this analysis consists of accident data from India, including information such as date, time, location, severity, and other relevant factors related to accidents.

## Tools Used

- **Power BI**: Power BI is used for data visualization and creating interactive dashboards to gain insights from the accident data.
- **SQL**: SQL (Structured Query Language) is utilized for data manipulation, querying, and data preparation tasks.

## Files

- **data**: This directory contains the raw data files used for the analysis.
- **scripts**: This directory contains SQL scripts used for data preprocessing and manipulation.
- **reports**: This directory contains Power BI report files (.pbix) generated as a result of the analysis.

## Analysis Process

1. **Data Import**: The raw data is imported into SQL Server for data preprocessing and manipulation.
2. **Data Cleaning and Preparation**: SQL scripts are used to clean and prepare the data for analysis. This may include tasks such as handling missing values, data normalization, and creating new derived variables.
3. **Data Analysis and Visualization**: Power BI is used to create visualizations, charts, and dashboards to explore and analyze the accident data. Various insights such as trends, patterns, and correlations are discovered during this phase.
4. **Insights and Interpretation**: Based on the visualizations and analysis results, insights are drawn regarding factors contributing to accidents, high-risk areas, time trends, etc.
5. **Report Generation**: Power BI reports are generated to present the findings of the analysis in a clear and interactive manner.

## Usage

1. Clone the repository to your local machine:

   ```
   git clone (https://github.com/datasqlsantosh/-Project-Portfolio-Indian-accident-data-Analysis)
   ```

2. Import the dataset into your SQL Server environment using the provided data files.
3. Execute the SQL scripts in the `scripts` directory to preprocess and manipulate the data.
4. Open the Power BI report files in the `reports` directory using Power BI Desktop to explore the analysis results and visualizations.

## Contributors

- [Santosh](https://github.com/datasqlsantosh))

## Feedback and Contributions

Feedback, bug reports, and contributions are welcome. Please feel free to open an issue or submit a pull request if you have any suggestions or improvements for this project.

## Acknowledgments

Special thanks to [[source of dataset](https://www.kaggle.com/datasets/shalininair13/study-of-road-accidents-in-india20172019?select=Mode-2017.csv)https://www.kaggle.com/datasets/shalininair13/study-of-road-accidents-in-india20172019?select=Mode-2017.csv] for providing the accident data used in this analysis.

Happy analyzing!
