<?php
/**
 * Copyright (c) 2018 Callan Peter Milne
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

add_filter(
  'datastudio_build_web_service_as_spec_openapi_v3_output',
  'datastudio_build_web_service_as_spec_openapi_v3_output',
  10,
  3
);

add_filter(
  'datastudio_build_web_service_as_spec_openapi_v3_output_content_type',
  'datastudio_build_web_service_as_spec_openapi_v3_output_content_type',
  10,
  3
);

add_filter(
  'datastudio_build_web_service_as_plaintext_output',
  'datastudio_build_web_service_as_plaintext_output',
  10,
  3
);

add_filter(
  'datastudio_build_web_service_as_plaintext_output_content_type',
  'datastudio_build_web_service_as_plaintext_output_content_type',
  10,
  3
);

class DSOAPIOTools {
  public static function pathParametersIn ( $uri ) {
    $path_params = [];
    $path_parts = explode( "/", $uri );
    if ( count( $path_parts ) > 0 ) {
      foreach ( $path_parts as $path_part ) {
        $path_part_is_param = '{' === substr( $path_part, 0, 1 );
        if ($path_part_is_param) {
          $path_params[] = substr( $path_part, 1, -1);
        }
      }
    }
    return $path_params;
  }
}

function datastudio_build_web_service_as_spec_openapi_v3_output ( $output, $web_service_id ) {
  $output = array(
    'info' => [
      'title' => 'Data Studio by Eviratec OAS',
      'description' => 'This is an OAS specification generated by Data Studio by Eviratec',
      'termsOfService' => 'https://www.datastudio.xyz/terms-of-use/',
      'contact' => [
        'name' => 'Data Studio by Eviratec Information',
        'url' => 'https://www.datastudio.xyz/',
        'email' => 'info@datastudio.xyz'
      ],
      'license' => [
        'name' => 'MIT'
      ],
      'version' => '0.0.1'
    ],
    'paths' => [
      '/status' => [
        'get' => [
          'summary' => '',
          'operationId' => '_getServiceStatus',
          'responses' => [
            '200' => [
              'description' => 'OK',
              'schema' => [
                'type' => 'array',
                'items' => [
                  '$ref' => '#/definitions/StatusObject'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'definitions' => [
      'DefaultResponseObject' => [
        'type' => 'object',
        'properties' => [
          'ID' => [
            'type' => 'string',
            'format' => 'uuid',
            'description' => 'Unique identifier for object',
            'example' => '869fb14f-a6d1-47cf-8dbd-36c88b19f0fa'
          ]
        ]
      ],
      'StatusObject' => [
        'type' => 'object',
        'properties' => [
          'ID' => [
            'type' => 'string',
            'format' => 'uuid',
            'description' => 'Unique identifier for object',
            'example' => '869fb14f-a6d1-47cf-8dbd-36c88b19f0fa'
          ]
        ]
      ],
      'SubmissionObject' => [
        'type' => 'object',
        'properties' => [
          'AuthorName' => [
            'type' => 'string',
            'description' => 'Submission author name',
            'example' => 'John Smith'
          ]
        ]
      ]
    ]
  );
  $paths = DataStudioQuery::getPathsByWebService( $web_service_id );
  if ( $paths->have_posts() ) {
    while ( $paths->have_posts() ) {
      $paths->the_post();
      $path_id = get_the_ID();
      $path_uri = get_field( 'path_uri', $path_id );
      $output['paths'][$path_uri] = [];
      $path_parameters = DSOAPIOTools::pathParametersIn( $path_uri );
      if ( count( $path_parameters ) > 0 ) {
        $output['paths'][$path_uri]['parameters'] = [];
        foreach ( $path_parameters as $param_name ) {
          $output['paths'][$path_uri]['parameters'][] = [
            'in' => 'path',
            'name' => $param_name,
            'type' => 'string',
            'description' => '',
            'required' => true
          ];
        }
      }
      $operations = DataStudioQuery::getOperationsByPath( $path_id );
      if ( $operations->have_posts() ) {
        while ( $operations->have_posts() ) {
          $operations->the_post();
          $operation_id = get_the_ID();
          $operation_type = get_field( 'operation_type', $operation_id );
          $operation_name = get_field( 'operation_name', $operation_id );
          $output['paths'][$path_uri][strtolower($operation_type)] = [
            'summary' => '',
            'operationId' => $operation_name,
            'responses' => [
              '200' => [
                'description' => 'OK',
                'schema' => [
                  '$ref' => '#/definitions/DefaultResponseObject'
                ]
              ]
            ]
          ];
          if ( 'post' === strtolower($operation_type) ) {
            $output['paths'][$path_uri][strtolower($operation_type)]['parameters'] = [
              [
                'in' => 'body',
                'name' => 'submission',
                'schema' => [
                  '$ref' => '#/definitions/SubmissionObject'
                ]
              ]
            ];
          }
        }
      }
    }
  }
  return json_encode( $output );
  // return yaml_emit( $output ); // requires php yaml extension
}

function datastudio_build_web_service_as_spec_openapi_v3_output_content_type ( $output, $web_service_id ) {
  return 'application/json';
}

function datastudio_build_web_service_as_plaintext_output ( $output, $web_service_id ) {
  return sprintf( 'webservice<%s> as plaintext', $web_service_id );
}

function datastudio_build_web_service_as_plaintext_output_content_type ( $output, $web_service_id ) {
  return 'text/plain';
}
