# Data Studio by Eviratec

WP export in: `./doc/db/datastudiobyeviratec...xml`

## Special notes, further reading, and thanks to ...

Please note **this project is in NO WAY affiliated with; or supported, or endorsed by; any of the following people or organisations.**

They have special mention here as I feel they deserve it :)

### CQRS

Command Query Responsibility Segregation

- [Martin Fowler](https://martinfowler.com) for this guide on [CQRS](https://martinfowler.com/bliki/CQRS.html)
- [Greg Young](https://twitter.com/gregyoung) as he is mentioned on https://martinfowler.com/bliki/CQRS.html
- [Douglas Reith](https://www.linkedin.com/in/douglas-reith/) for introducing me to CQRS and explaining it in a way I could understand

### OpenAPI

- [OpenAPI Initiative](https://github.com/OAI): https://openapis.org and it's contributors.

### Missing someone/something?

Let me know :)

## Models

```
app           App           Apps           app           apps
logic_group   LogicGroup    Logic Groups   logic group   logic groups
model         Model         Models         model         models
attribute     Attribute     Attributes     attribute     attributes
command       Command       Commands       command       commands
query         Query         Queries        query         queries
```

## Query

```
getApp
getLogicGroup
getModel
getAttribute
getCommand
getQuery

getApps
getLogicGroupsByApp
getModelsByLogicGroup
getAttributesByModel
getCommandsByLogicGroup
getQueriesByLogicGroup
```

## CMD

```
createApp
createLogicGroup
createModel
createAttribute
createCommand
createQuery

deleteApp
deleteLogicGroup
deleteModel
deleteAttribute
deleteCommand
deleteQuery

updateAppName
updateLogicGroupName
updateModelName
updateAttributeName
updateCommandName
updateQueryName
```

### Requires WordPress Plugins
- Advanced Custom Fields
- Profile Builder

## Based on [HTML5 Blank](http://html5blank.com)

HTML5 Blank is a powerful shell for rapidly deploying your WordPress projects.

* Project: [github.com/toddmotto/html5blank](https://github.com/toddmotto/html5blank)
* Website: [html5blank.com](http://html5blank.com)
* Twitter: [@html5blank](http://twitter.com/html5blank)
* Author : [Todd Motto](http://toddmotto.com) // [@toddmotto](http://twitter.com/toddmotto)

### Contributors (in order of pull request)
[David Munn](https://github.com/Munnday), [Patrick Zeinert](https://github.com/CoeusCC), [J-Rabe](https://github.com/J-Rabe), [Steve Steiner](https://github.com/ssteinerx), [Kyle Hudson](https://github.com/diskhub), [chrisdl](https://github.com/chrisdl), [Marcel Miranda](https://github.com/reaktivo), [Fx Bénard](https://github.com/fxbenard), Ioan Virag, [Mohamed Elkebir](https://github.com/elkebirmed), [lregla](https://github.com/lregla), Carlos Pinar, [Joshua Lyman](https://github.com/jlyman), [Kevin Plattret](https://github.com/kevinplattret), [Wesllei Henrique](https://github.com/wesllei), [Stacey Cordoni](https://github.com/staceycordoni).

## More info about HTML5 Blank

Download the latest version from [html5blank.com](http://html5blank.com), or [github.com/toddmotto/html5blank](https://github.com/toddmotto/html5blank).

## MIT License

Copyright &copy; 2018 Callan Peter Milne

Built by Callan Milne // @eviratec
Based on work ([HTML5 Blank](http://html5blank.com)) by Todd Motto // @toddmotto

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
