## Classes

<dl>
<dt><a href="#Controller">Controller</a></dt>
<dd><p>Class to connect identity with custom functions (Class <a href="#Functions">Functions</a>) in order to avoid code
repetitions</p>
</dd>
<dt><a href="#Identity">Identity</a></dt>
<dd><p>Used Identity for automation</p>
</dd>
<dt><a href="#SearchQueryEvaluators">SearchQueryEvaluators</a></dt>
<dd><p>Class which includes example evaluators which can be used with
<a href="#SearchQueries.getQuery">getQuery</a></p>
</dd>
<dt><a href="#SearchQueries">SearchQueries</a></dt>
<dd><p>Includes functions which return generated search queries.
Uses <a href="#SearchQueryGenerator">SearchQueryGenerator</a>.</p>
</dd>
<dt><a href="#SearchQueryGenerator">SearchQueryGenerator</a></dt>
<dd><p>Class for the generic search query generator</p>
</dd>
<dt><a href="#Functions">Functions</a></dt>
<dd><p>Custom functions which enhance the Puppeteer standard functionality</p>
</dd>
</dl>

<a name="Controller"></a>

## Controller
Class to connect identity with custom functions (Class [Functions](#Functions)) in order to avoid code
repetitions

**Kind**: global class  

* [Controller](#Controller)
    * [new Controller(identity, endpoint)](#new_Controller_new)
    * [.typeSearchQuery(selector, generatorName)](#Controller+typeSearchQuery) ⇒ <code>void</code>
    * [.getRandomTime(time, random)](#Controller+getRandomTime) ⇒ <code>number</code>
    * [.getRandomNumber(to, from)](#Controller+getRandomNumber) ⇒ <code>number</code>
    * [.getRandomBoolean(truePercent)](#Controller+getRandomBoolean) ⇒ <code>Boolean</code>
    * [.getPage()](#Controller+getPage) ⇒ <code>page</code>
    * [.getIdentity()](#Controller+getIdentity) ⇒ [<code>Identity</code>](#Identity)
    * _async_
        * [.init(executablePath)](#Controller+init) ⇒ <code>void</code>
        * [.focusPage(url)](#Controller+focusPage) ⇒ <code>boolean</code>
        * [.newPage(url)](#Controller+newPage) ⇒ <code>void</code>
        * [.closePage(url)](#Controller+closePage) ⇒ <code>void</code>
        * [.focusFrame(url)](#Controller+focusFrame) ⇒ <code>boolean</code>
        * [.type(selector, text)](#Controller+type) ⇒ <code>void</code>
        * [.typeFrame(selector, text)](#Controller+typeFrame) ⇒ <code>void</code>
        * [.typeEnter()](#Controller+typeEnter) ⇒ <code>void</code>
        * [.typeTab()](#Controller+typeTab) ⇒ <code>void</code>
        * [.typeEsc()](#Controller+typeEsc) ⇒ <code>type</code>
        * [.click(selector, delay, tap, topRight, doTrigger)](#Controller+click) ⇒ <code>void</code>
        * [.clickFrame(selector)](#Controller+clickFrame) ⇒ <code>void</code>
        * [.hover(page, selector)](#Controller+hover) ⇒ <code>void</code>
        * [.waitForSelector(selector, doThrow)](#Controller+waitForSelector) ⇒ <code>void</code>
        * [.select(selector, value)](#Controller+select) ⇒ <code>void</code>
        * [.selectFrame(selector, value)](#Controller+selectFrame) ⇒ <code>void</code>
        * [.goto(url)](#Controller+goto) ⇒ <code>void</code>
        * [.randomWait(time, random)](#Controller+randomWait) ⇒ <code>void</code>
        * [.waitForNavigation()](#Controller+waitForNavigation) ⇒ <code>void</code>
        * [.logScreenshot(page, text)](#Controller+logScreenshot) ⇒ <code>void</code>
        * [.isSelectorVisible(selector)](#Controller+isSelectorVisible) ⇒ <code>Boolean</code>
        * [.scrollToSelector(stopSelector, wait)](#Controller+scrollToSelector) ⇒ <code>void</code>
        * [.scrollToBottom()](#Controller+scrollToBottom) ⇒ <code>type</code>
        * [.scrollUp(stopSelector, wait, press, minScrolls, maxScrolls)](#Controller+scrollUp) ⇒ <code>void</code>
        * [.scrollDown(stopSelector, wait, press, minScrolls, maxScrolls, minIterations)](#Controller+scrollDown) ⇒ <code>void</code>
        * [.setValue(selector, text)](#Controller+setValue) ⇒ <code>void</code>
        * [.deactivateLink(selector)](#Controller+deactivateLink) ⇒ <code>void</code>
        * [.getHref(selector)](#Controller+getHref) ⇒ <code>string</code>
        * [.goBack()](#Controller+goBack) ⇒ <code>void</code>
        * [.solveCaptcha(selector)](#Controller+solveCaptcha) ⇒ <code>string</code>
        * [.solveRecaptcha(selector)](#Controller+solveRecaptcha) ⇒ <code>string</code>

<a name="new_Controller_new"></a>

### new Controller(identity, endpoint)
constructor


| Param | Type | Default | Description |
| --- | --- | --- | --- |
| identity | [<code>Identity</code>](#Identity) |  | Identity to use |
| endpoint | <code>String</code> | <code></code> | WebSocket-Endpoint |

<a name="Controller+typeSearchQuery"></a>

### controller.typeSearchQuery(selector, generatorName) ⇒ <code>void</code>
Types a search query generated by the given search query generator
inside the target input element inside the current tab with
randomized typing delays defined by the identity

**Kind**: instance method of [<code>Controller</code>](#Controller)  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| selector | <code>string</code> |  | Selector ot the target input element. If the selector is not given, the typing events will be executed without focusing the input element. |
| generatorName | <code>string</code> | <code>&quot;\&quot;default\&quot;&quot;</code> | Name of the search query generator defined in the settings which should be used. Default values can be found inside include/settings.js |

<a name="Controller+getRandomTime"></a>

### controller.getRandomTime(time, random) ⇒ <code>number</code>
Return random time

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Returns**: <code>number</code> - Random number inside range [time +/- random]  

| Param | Type | Description |
| --- | --- | --- |
| time | <code>number</code> | Average time in milliseconds |
| random | <code>number</code> | Maximum deviation from average time in milliseconds |

<a name="Controller+getRandomNumber"></a>

### controller.getRandomNumber(to, from) ⇒ <code>number</code>
Return random number with seedrandom library

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Returns**: <code>number</code> - Random number inside range [from-to]  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| to | <code>number</code> |  | To |
| from | <code>number</code> | <code>0</code> | From |

<a name="Controller+getRandomBoolean"></a>

### controller.getRandomBoolean(truePercent) ⇒ <code>Boolean</code>
Return random boolean value

**Kind**: instance method of [<code>Controller</code>](#Controller)  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| truePercent | <code>Number</code> | <code>0.5</code> | Probability for returning true (comma value between 0 and 1) |

<a name="Controller+getPage"></a>

### controller.getPage() ⇒ <code>page</code>
getPage - Returns current page tab

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Returns**: <code>page</code> - Page-Object  
<a name="Controller+getIdentity"></a>

### controller.getIdentity() ⇒ [<code>Identity</code>](#Identity)
Returns the identity used in this controller

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Returns**: [<code>Identity</code>](#Identity) - Identity  
<a name="Controller+init"></a>

### controller.init(executablePath) ⇒ <code>void</code>
Initiate browser and open new tab. The tab is focused.

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| executablePath | <code>string</code> | <code>&quot;\&quot;\&quot;&quot;</code> | Path to a Chromium or Chrome executable to run instead of the standard Chromium included in Puppeteer. Normal bundled version will be started, if not set. |

<a name="Controller+focusPage"></a>

### controller.focusPage(url) ⇒ <code>boolean</code>
Searches Tab with given URL and focuses this tab.
The old Tab will stay focused if no Tab with the URL has been matched.

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Returns**: <code>boolean</code> - True: Tab found, False: Tab not found  
**Category**: async  

| Param | Type | Description |
| --- | --- | --- |
| url | <code>String</code> | Beginning of URL of targeted Page tab |

<a name="Controller+newPage"></a>

### controller.newPage(url) ⇒ <code>void</code>
Opens new Page tab and opens the given url inside the tab. The new tab
is focused afterwards.

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| url | <code>string</code> | <code>&quot;\&quot;\&quot;&quot;</code> | URL to be loaded. No page will be loaded if the string is empty. |

<a name="Controller+closePage"></a>

### controller.closePage(url) ⇒ <code>void</code>
Closes page with given URL. Current open Tab is closed,
if no URL is given. The last known open Tab will selected after closing.

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| url | <code>String</code> | <code>&quot;&quot;</code> | Beginning of URL of targeted Tab |

<a name="Controller+focusFrame"></a>

### controller.focusFrame(url) ⇒ <code>boolean</code>
Searches for inline frame with given URL start in the current
tab and focuses it for following events (typeFrame or clickFrame)

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Returns**: <code>boolean</code> - True: Frame has been found, False: Frame has not been found  
**Category**: async  

| Param | Type | Description |
| --- | --- | --- |
| url | <code>String</code> | Beginning of URL of targeted iFrame inside the current page tab |

<a name="Controller+type"></a>

### controller.type(selector, text) ⇒ <code>void</code>
Types inside the target input element inside the current tab with
randomized typing delays defined by the identity

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  

| Param | Type | Description |
| --- | --- | --- |
| selector | <code>string</code> | Selector ot the target input element. If the selector is not given, the typing events will be executed without focusing the input element. |
| text | <code>string</code> | Text which should be entered |

<a name="Controller+typeFrame"></a>

### controller.typeFrame(selector, text) ⇒ <code>void</code>
Types inside the target input element inside the current selected frame
with randomized typing delays defined by the identity

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  

| Param | Type | Description |
| --- | --- | --- |
| selector | <code>string</code> | Selector ot the target input element. If the selector is not given, the typing events will be executed without focusing the input element. |
| text | <code>string</code> | Text which should be entered |

<a name="Controller+typeEnter"></a>

### controller.typeEnter() ⇒ <code>void</code>
Presses Enter button on current tab with random press and release time

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  
<a name="Controller+typeTab"></a>

### controller.typeTab() ⇒ <code>void</code>
Presses Tab button on current tab

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  
<a name="Controller+typeEsc"></a>

### controller.typeEsc() ⇒ <code>type</code>
Presses ESC button

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  
<a name="Controller+click"></a>

### controller.click(selector, delay, tap, topRight, doTrigger) ⇒ <code>void</code>
Click on target element with random deviation around the click position
and error handling. Every click is saved as a screenshot.

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| selector | <code>string</code> |  | Selector of target element |
| delay | <code>number</code> | <code>true</code> | Random delay between MouseDown und MouseUp event |
| tap | <code>Boolean</code> | <code>false</code> | Send touchscreen tap instead of MouseClick event |
| topRight | <code>Boolean</code> | <code>false</code> | Click inside of the top right corner instead of the element's center. |
| doTrigger | <code>Boolean</code> | <code>false</code> | Manually trigger the click event via JavaScript if error occurred (can happen, if Dropdown menu closed before the click has been executed) |

<a name="Controller+clickFrame"></a>

### controller.clickFrame(selector) ⇒ <code>void</code>
Click on target element of selected frame with error handling.
Version for iFrame.

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  

| Param | Type | Description |
| --- | --- | --- |
| selector | <code>string</code> | Selector of target element |

<a name="Controller+hover"></a>

### controller.hover(page, selector) ⇒ <code>void</code>
Hover over targeted element

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  

| Param | Type | Description |
| --- | --- | --- |
| page | <code>Page</code> | Page object |
| selector | <code>string</code> | Selector of target element |

<a name="Controller+waitForSelector"></a>

### controller.waitForSelector(selector, doThrow) ⇒ <code>void</code>
Wait for visibility of selector on current tab with error error handling

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| selector | <code>string</code> |  | Selector of target element |
| doThrow | <code>boolean</code> | <code>false</code> | throws an error instead of invoking the internal errorHandling function |

<a name="Controller+select"></a>

### controller.select(selector, value) ⇒ <code>void</code>
Selects value of dropdown list inside the current tab with error handling.

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  

| Param | Type | Description |
| --- | --- | --- |
| selector | <code>string</code> | Selector of target element |
| value | <code>string</code> | Selection value of target value (value="VALUE") |

<a name="Controller+selectFrame"></a>

### controller.selectFrame(selector, value) ⇒ <code>void</code>
Selects value of dropdown list inside the selected frame with error handling.

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  

| Param | Type | Description |
| --- | --- | --- |
| selector | <code>string</code> | Selector of target element |
| value | <code>string</code> | Selection value of target value (value="VALUE") |

<a name="Controller+goto"></a>

### controller.goto(url) ⇒ <code>void</code>
Opens URL in current tab

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  

| Param | Type | Description |
| --- | --- | --- |
| url | <code>string</code> | URL |

<a name="Controller+randomWait"></a>

### controller.randomWait(time, random) ⇒ <code>void</code>
Waits for random time range

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| time | <code>number</code> | <code>2000</code> | Average waiting time in milliseconds |
| random | <code>number</code> | <code>1000</code> | Maximum deviation from average waiting time in milliseconds |

<a name="Controller+waitForNavigation"></a>

### controller.waitForNavigation() ⇒ <code>void</code>
async waitForNavigation - description

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Returns**: <code>void</code> - description  
**Category**: async  
<a name="Controller+logScreenshot"></a>

### controller.logScreenshot(page, text) ⇒ <code>void</code>
Create screenshot of page and save it inside the log

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  

| Param | Type | Description |
| --- | --- | --- |
| page | <code>Object</code> | Element from which the screenshot should be taken from [Page, Element, Frame] |
| text | <code>string</code> | Text for the log entry |

<a name="Controller+isSelectorVisible"></a>

### controller.isSelectorVisible(selector) ⇒ <code>Boolean</code>
Check if selector is visible on page

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Returns**: <code>Boolean</code> - true: visible, false: not visible  
**Category**: async  

| Param | Type | Description |
| --- | --- | --- |
| selector | <code>String</code> | Selector of target |

<a name="Controller+scrollToSelector"></a>

### controller.scrollToSelector(stopSelector, wait) ⇒ <code>void</code>
Scrolls to given selector

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| stopSelector | <code>String</code> |  | Selector to which the function should scroll |
| wait | <code>Boolean</code> | <code>true</code> | Wait after half of page is scrolled |

<a name="Controller+scrollToBottom"></a>

### controller.scrollToBottom() ⇒ <code>type</code>
async scrollToBottom - Scrolls to Bottom of current page (last div-Element).

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Returns**: <code>type</code> - description  
**Category**: async  
<a name="Controller+scrollUp"></a>

### controller.scrollUp(stopSelector, wait, press, minScrolls, maxScrolls) ⇒ <code>void</code>
Scrolls page up until the selector is visible

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| stopSelector | <code>string</code> |  | Selector to which the function should scroll up |
| wait | <code>boolean</code> | <code>true</code> | Wait after half of page is scrolled |
| press | <code>boolean</code> | <code>false</code> | true: Scrolling is achieved with long button press of page down-button, false: Scrolling is achieved with several short arrow down button presses |
| minScrolls | <code>number</code> | <code>11</code> | Minimum number of keyboard presses for scrolling (if press=false) |
| maxScrolls | <code>number</code> | <code>15</code> | Maximum number of keyboard presses for scrolling (if press=false) |

<a name="Controller+scrollDown"></a>

### controller.scrollDown(stopSelector, wait, press, minScrolls, maxScrolls, minIterations) ⇒ <code>void</code>
Scrolls page down until the selector is visible

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| stopSelector | <code>string</code> |  | Selector to which the function should scroll up |
| wait | <code>boolean</code> | <code>true</code> | Wait after half of page is scrolled |
| press | <code>boolean</code> | <code>false</code> | true: Scrolling is achieved with long button press of page down-button, false: Scrolling is achieved with several short arrow down button presses |
| minScrolls | <code>number</code> | <code>11</code> | Minimum number of keyboard presses for scrolling (if press=false) |
| maxScrolls | <code>number</code> | <code>15</code> | Maximum number of keyboard presses for scrolling (if press=false) |
| minIterations | <code>number</code> | <code>0</code> | Minimum number of how many iterations this scrolling have to be repeated (even if element has already been scrolled by) |

<a name="Controller+setValue"></a>

### controller.setValue(selector, text) ⇒ <code>void</code>
Change HTML-DOM value (z.B. Textarea elements)

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  

| Param | Type | Description |
| --- | --- | --- |
| selector | <code>string</code> | Selektor of target |
| text | <code>Sting</code> | Value text to which the selected element should be changed |

<a name="Controller+deactivateLink"></a>

### controller.deactivateLink(selector) ⇒ <code>void</code>
Deactivate link invocation behavior inside the browser page with injection
of JavaScript

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  

| Param | Type | Description |
| --- | --- | --- |
| selector | <code>string</code> | Target selector of link which should be deactivated |

<a name="Controller+getHref"></a>

### controller.getHref(selector) ⇒ <code>string</code>
Get Href (link) content of targeted DOM element

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Returns**: <code>string</code> - Href content  
**Category**: async  

| Param | Type | Description |
| --- | --- | --- |
| selector | <code>string</code> | Selector of target |

<a name="Controller+goBack"></a>

### controller.goBack() ⇒ <code>void</code>
async goBack - Open prior page in browser history of current tab

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Category**: async  
<a name="Controller+solveCaptcha"></a>

### controller.solveCaptcha(selector) ⇒ <code>string</code>
Solve image captcha inside the page with the help of the Anti-Captcha service.
Needs anti-captcha library to work. Library can be downloaded at
https://github.com/AdminAnticaptcha/anticaptcha-nodejs/blob/master/anticaptcha.js
and the file has to be put into the "lib"-folder of this project.

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Returns**: <code>string</code> - Submitted solution of the Captcha  
**Category**: async  

| Param | Type | Description |
| --- | --- | --- |
| selector | <code>string</code> | Selector of the Captcha |

<a name="Controller+solveRecaptcha"></a>

### controller.solveRecaptcha(selector) ⇒ <code>string</code>
Solve reCAPTCHA inside iFrame with the help of the Anti-Captcha service
Needs anti-captcha library to work. Library can be downloaded at
https://github.com/AdminAnticaptcha/anticaptcha-nodejs/blob/master/anticaptcha.js
and the file has to be put into the "lib"-folder of this project.

**Kind**: instance method of [<code>Controller</code>](#Controller)  
**Returns**: <code>string</code> - reCAPTCHA solution string which has to be injected
into hidden textarea element before submission of the form.  
**Category**: async  

| Param | Type | Description |
| --- | --- | --- |
| selector | <code>string</code> | Selector to the reCAPTCHA iframe included inside the given frame element (needs to have URL to reCAPTCHA inside the HTML DOM attribute "src"). |

<a name="Identity"></a>

## Identity
Used Identity for automation

**Kind**: global class  

* [Identity](#Identity)
    * [new Identity(firstname, lastname, birthday, email, password, company, position, typespeed, random, gender)](#new_Identity_new)
    * [.isMale()](#Identity+isMale) ⇒ <code>boolean</code>
    * [.getBirthdayString()](#Identity+getBirthdayString) ⇒ <code>String</code>

<a name="new_Identity_new"></a>

### new Identity(firstname, lastname, birthday, email, password, company, position, typespeed, random, gender)
Constructor


| Param | Type | Default | Description |
| --- | --- | --- | --- |
| firstname | <code>string</code> |  | First name |
| lastname | <code>string</code> |  | Last name |
| birthday | <code>Date</code> |  | Birthday |
| email | <code>string</code> |  | Email address |
| password | <code>string</code> |  | password |
| company | <code>string</code> |  | Conpany |
| position | <code>string</code> | <code>&quot;\&quot;Employee\&quot;&quot;</code> | Position in company |
| typespeed | <code>number</code> | <code>456</code> | Average typing speed |
| random | <code>number</code> | <code>265</code> | Random deviation from average typing speed |
| gender | <code>number</code> | <code>global.GENDER_MALE</code> | Gender |

<a name="Identity+isMale"></a>

### identity.isMale() ⇒ <code>boolean</code>
Returns if identity is of male gender

**Kind**: instance method of [<code>Identity</code>](#Identity)  
<a name="Identity+getBirthdayString"></a>

### identity.getBirthdayString() ⇒ <code>String</code>
Returns a formatted String of the Identity-Birthday

**Kind**: instance method of [<code>Identity</code>](#Identity)  
**Returns**: <code>String</code> - Birthday as a String  
<a name="SearchQueryEvaluators"></a>

## SearchQueryEvaluators
Class which includes example evaluators which can be used with
[getQuery](#SearchQueries.getQuery)

**Kind**: global class  

* [SearchQueryEvaluators](#SearchQueryEvaluators)
    * [.evaluateNormal(item)](#SearchQueryEvaluators.evaluateNormal) ⇒ <code>String</code>
    * [.evaluateSPON(item)](#SearchQueryEvaluators.evaluateSPON) ⇒ <code>String</code>

<a name="SearchQueryEvaluators.evaluateNormal"></a>

### SearchQueryEvaluators.evaluateNormal(item) ⇒ <code>String</code>
Evaluation function for a normal RSS feed: Takes the item -> title object
of the feed and returns it in lowercase

**Kind**: static method of [<code>SearchQueryEvaluators</code>](#SearchQueryEvaluators)  
**Returns**: <code>String</code> - Lowercase string of item title  

| Param | Type | Description |
| --- | --- | --- |
| item | <code>Item</code> | Single item of parsed feed |

<a name="SearchQueryEvaluators.evaluateSPON"></a>

### SearchQueryEvaluators.evaluateSPON(item) ⇒ <code>String</code>
Evaluation function for the use case of Spiegel Online headlines

**Kind**: static method of [<code>SearchQueryEvaluators</code>](#SearchQueryEvaluators)  
**Returns**: <code>String</code> - Generated search query out of the single item  

| Param | Type | Description |
| --- | --- | --- |
| item | <code>Item</code> | Single item of parsed feed |

<a name="SearchQueries"></a>

## SearchQueries
Includes functions which return generated search queries.
Uses [SearchQueryGenerator](#SearchQueryGenerator).

**Kind**: global class  

* [SearchQueries](#SearchQueries)
    * [.getRandomQuery()](#SearchQueries.getRandomQuery) ⇒ <code>String</code>
    * [.getFacebookQuery()](#SearchQueries.getFacebookQuery) ⇒ <code>String</code>
    * [.getQuery(generatorName)](#SearchQueries.getQuery) ⇒ <code>String</code>

<a name="SearchQueries.getRandomQuery"></a>

### SearchQueries.getRandomQuery() ⇒ <code>String</code>
Returns search query generated of the spiegelonline evaluator
(see [SearchQueryEvaluators](#SearchQueryEvaluators) for details)

**Kind**: static method of [<code>SearchQueries</code>](#SearchQueries)  
**Returns**: <code>String</code> - Search query  
<a name="SearchQueries.getFacebookQuery"></a>

### SearchQueries.getFacebookQuery() ⇒ <code>String</code>
Returns search query generated of the facebook evaluator
(see [searchQueryEvaluators](searchQueryEvaluators) for details)

**Kind**: static method of [<code>SearchQueries</code>](#SearchQueries)  
**Returns**: <code>String</code> - Search query  
<a name="SearchQueries.getQuery"></a>

### SearchQueries.getQuery(generatorName) ⇒ <code>String</code>
Returns search query generated of the a given search query evaluator
(see [searchQueryEvaluators](searchQueryEvaluators) for details)

**Kind**: static method of [<code>SearchQueries</code>](#SearchQueries)  
**Returns**: <code>String</code> - Search query randomly selected of returned
array of the called search query generator  

| Param | Type | Description |
| --- | --- | --- |
| generatorName | <code>String</code> | Name of the search query generator defined inside the Framework Settings (for default values see include/settings.js). The function SearchQueryGenerator.getQueries is called with the parameters defined in the settings. |

<a name="SearchQueryGenerator"></a>

## SearchQueryGenerator
Class for the generic search query generator

**Kind**: global class  
<a name="SearchQueryGenerator.getQueries"></a>

### SearchQueryGenerator.getQueries(rssFeedURL, cacheFileName, queryArrayObject, evaluationFunction) ⇒ <code>Array</code>
Fetch RSS and generate an array containing generated search queries
out of the feed with its evaluationFunction.

**Kind**: static method of [<code>SearchQueryGenerator</code>](#SearchQueryGenerator)  
**Returns**: <code>Array</code> - Array with generated search queries  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| rssFeedURL | <code>String</code> |  | URL of RSS feed which should be parsed |
| cacheFileName | <code>String</code> |  | File name of the cache file which is generated inside the tmp-folder of the project |
| queryArrayObject | <code>Object</code> |  | Array object which should contain the contents of the generated array. The contents will be written to this object. |
| evaluationFunction | <code>function</code> | <code>evaluateNormal</code> | Function which should evaluate every single item of the RSS feed. The function has to return a string of the generated search query out of the item. Function has to be: Function(item) -> string |

<a name="Functions"></a>

## Functions
Custom functions which enhance the Puppeteer standard functionality

**Kind**: global class  

* [Functions](#Functions)
    * [.getRandomTime(time, random)](#Functions.getRandomTime) ⇒ <code>number</code>
    * [.getRandomNumber(to, from)](#Functions.getRandomNumber) ⇒ <code>number</code>
    * [.getRandomBoolean(truePercent)](#Functions.getRandomBoolean) ⇒ <code>Boolean</code>
    * _static async_
        * [.getPage(browser, url)](#Functions.getPage) ⇒ <code>Page</code>
        * [.closePage(browser, url)](#Functions.closePage) ⇒ <code>void</code>
        * [.newPage(browser, url)](#Functions.newPage) ⇒ <code>Page</code>
        * [._enableCamouflage(page)](#Functions._enableCamouflage) ⇒ <code>void</code>
        * [.getFrame(page, url)](#Functions.getFrame) ⇒ <code>Frame</code>
        * [.bringToFront(page)](#Functions.bringToFront) ⇒ <code>void</code>
        * [.init(puppeteer, endpoint, executablePath)](#Functions.init) ⇒ <code>Object</code>
        * [.getBottomSelector(page)](#Functions.getBottomSelector) ⇒ <code>string</code>
        * [.getHref(page, selector)](#Functions.getHref) ⇒ <code>string</code>
        * [.hover(page, selector)](#Functions.hover) ⇒ <code>void</code>
        * [.click(page, selector, delay, tap, topRight, doTrigger)](#Functions.click) ⇒ <code>void</code>
        * [.clickFrame(frame, selector)](#Functions.clickFrame) ⇒ <code>void</code>
        * [.exit()](#Functions.exit) ⇒ <code>void</code>
        * [.waitForSelector(page, selector, doThrow)](#Functions.waitForSelector) ⇒ <code>void</code>
        * [.select(page, selector, value)](#Functions.select) ⇒ <code>void</code>
        * [.selectFrame(frame, selector, value)](#Functions.selectFrame) ⇒ <code>void</code>
        * [.type(page, selector, text, time, random)](#Functions.type) ⇒ <code>void</code>
        * [.typeFrame(Frame, selector, text, time, random)](#Functions.typeFrame) ⇒ <code>void</code>
        * [.typeEnter(page)](#Functions.typeEnter) ⇒ <code>void</code>
        * [.typeTab(page)](#Functions.typeTab) ⇒ <code>void</code>
        * [.typeEsc(page)](#Functions.typeEsc) ⇒ <code>type</code>
        * [.typeUp(page, pageUp)](#Functions.typeUp) ⇒ <code>void</code>
        * [.typeDown(page, pageDown)](#Functions.typeDown) ⇒ <code>void</code>
        * [.scrollToSelector(page, stopSelector, wait)](#Functions.scrollToSelector) ⇒ <code>void</code>
        * [.scrollUp(page, stopSelector, wait, press, minScrolls, maxScrolls)](#Functions.scrollUp) ⇒ <code>void</code>
        * [.scrollDown(page, stopSelector, wait, press, minScrolls, maxScrolls, minIterations)](#Functions.scrollDown) ⇒ <code>void</code>
        * [.setValue(page, selector, text)](#Functions.setValue) ⇒ <code>void</code>
        * [.deactivateLink(page, selector)](#Functions.deactivateLink) ⇒ <code>void</code>
        * [.triggerClick(page, selector)](#Functions.triggerClick) ⇒ <code>void</code>
        * [.randomWait(page, time, random)](#Functions.randomWait) ⇒ <code>void</code>
        * [.randomTimeout(time, random)](#Functions.randomTimeout) ⇒ <code>void</code>
        * [.controlStatus(browser, page, searchURL, timeout)](#Functions.controlStatus) ⇒ <code>void</code>
        * [.errorHandling(page, e, doScreenshot)](#Functions.errorHandling) ⇒ <code>type</code>
        * [.getScreenshot(page, fullPage)](#Functions.getScreenshot) ⇒ <code>String</code>
        * [.logScreenshot(page, text)](#Functions.logScreenshot) ⇒ <code>void</code>
        * [.isSelectorVisible(page, selector)](#Functions.isSelectorVisible) ⇒ <code>Boolean</code>
        * [.isInViewport(page, selector, scrollDown)](#Functions.isInViewport) ⇒ <code>Boolean</code>
        * [.getScrollY(page, selector)](#Functions.getScrollY) ⇒ <code>number</code>
        * [.debugLog(key, value, imageData)](#Functions.debugLog) ⇒ <code>void</code>
        * [.solveCaptcha(page, selector)](#Functions.solveCaptcha) ⇒ <code>string</code>
        * [.solveRecaptcha(iframe, selector)](#Functions.solveRecaptcha) ⇒ <code>string</code>

<a name="Functions.getRandomTime"></a>

### Functions.getRandomTime(time, random) ⇒ <code>number</code>
Return random time

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Returns**: <code>number</code> - Random number inside range [time +/- random]  

| Param | Type | Description |
| --- | --- | --- |
| time | <code>number</code> | Average time in milliseconds |
| random | <code>number</code> | Maximum deviation from average time in milliseconds |

<a name="Functions.getRandomNumber"></a>

### Functions.getRandomNumber(to, from) ⇒ <code>number</code>
Return random number with seedrandom library

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Returns**: <code>number</code> - Random number inside range [from-to]  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| to | <code>number</code> |  | To |
| from | <code>number</code> | <code>0</code> | From |

<a name="Functions.getRandomBoolean"></a>

### Functions.getRandomBoolean(truePercent) ⇒ <code>Boolean</code>
Return random boolean value

**Kind**: static method of [<code>Functions</code>](#Functions)  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| truePercent | <code>Number</code> | <code>0.5</code> | Probability for returning true (comma value between 0 and 1) |

<a name="Functions.getPage"></a>

### Functions.getPage(browser, url) ⇒ <code>Page</code>
Searches tab with given url and returns this tab

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Returns**: <code>Page</code> - Seite  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| browser | <code>Browser</code> | Browser element |
| url | <code>string</code> | Beginning of URL of targeted Tab |

<a name="Functions.closePage"></a>

### Functions.closePage(browser, url) ⇒ <code>void</code>
Searches tab with given URL and closes this tab

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| browser | <code>Browser</code> | Browser-Element |
| url | <code>string</code> | Beginning of URL of targeted Page tab |

<a name="Functions.newPage"></a>

### Functions.newPage(browser, url) ⇒ <code>Page</code>
Opens new Page tab and opens the given url inside the tab. The new tab
is focused afterwards.

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Returns**: <code>Page</code> - The new Page tab  
**Category**: static async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| browser | <code>Browser</code> |  | Browser object |
| url | <code>string</code> | <code>&quot;\&quot;\&quot;&quot;</code> | URL to be loaded. No page will be loaded if the string is empty. |

<a name="Functions._enableCamouflage"></a>

### Functions._enableCamouflage(page) ⇒ <code>void</code>
Enables additional protection mechanisms for the given page to reduce
possibilities for services to identify the headless browser

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| page | <code>Page</code> | Page object for which the mechanisms should be enabled |

<a name="Functions.getFrame"></a>

### Functions.getFrame(page, url) ⇒ <code>Frame</code>
Searches for inline frame with given URL start and returns the frame

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Returns**: <code>Frame</code> - Frame element  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| page | <code>Page</code> | Page element |
| url | <code>string</code> | Beginning of URL of targeted iFrame inside the current page tab |

<a name="Functions.bringToFront"></a>

### Functions.bringToFront(page) ⇒ <code>void</code>
Brings page to front (activates page tab)

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| page | <code>Page</code> | Page-Object |

<a name="Functions.init"></a>

### Functions.init(puppeteer, endpoint, executablePath) ⇒ <code>Object</code>
Initialize Browser session or connects to active browser session
and opens new tab. Browser will be started in normal mode instead
of the headless mode.

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Returns**: <code>Object</code> - Initialisiierungselemente [Page, Browser]  
**Category**: static async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| puppeteer | <code>Puppeteer</code> |  | Puppeteer element |
| endpoint | <code>string</code> |  | Websocket-Endpoint. Browser session will be initialized, if not set. |
| executablePath | <code>string</code> | <code>&quot;\&quot;\&quot;&quot;</code> | Path to a Chromium or Chrome executable to run instead of the standard Chromium included in Puppeteer. Normal bundled version will be started, if not set. |

<a name="Functions.getBottomSelector"></a>

### Functions.getBottomSelector(page) ⇒ <code>string</code>
Get selector of last visible Div-element
on the page

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Returns**: <code>string</code> - Bottom selector  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| page | <code>Page</code> | Page object |

<a name="Functions.getHref"></a>

### Functions.getHref(page, selector) ⇒ <code>string</code>
Get Href (link) content of targeted DOM element

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Returns**: <code>string</code> - Href content  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| page | <code>Page</code> | page object |
| selector | <code>string</code> | Selector of target |

<a name="Functions.hover"></a>

### Functions.hover(page, selector) ⇒ <code>void</code>
Hover over targeted element

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| page | <code>Page</code> | Page object |
| selector | <code>string</code> | Selector of target element |

<a name="Functions.click"></a>

### Functions.click(page, selector, delay, tap, topRight, doTrigger) ⇒ <code>void</code>
Click on target element with random deviation around the click position
and error handling. Every click is saved as a screenshot.

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| page | <code>Page</code> |  | Page element |
| selector | <code>string</code> |  | Selector of target element |
| delay | <code>number</code> | <code>true</code> | Random delay between MouseDown und MouseUp event |
| tap | <code>Boolean</code> | <code>false</code> | Send touchscreen tap instead of MouseClick event |
| topRight | <code>Boolean</code> | <code>false</code> | Click inside of the top right corner instead of the element's center. |
| doTrigger | <code>Boolean</code> | <code>false</code> | Manually trigger the click event via JavaScript if error occurred (can happen, if Dropdown menu closed before the click has been executed) |

<a name="Functions.clickFrame"></a>

### Functions.clickFrame(frame, selector) ⇒ <code>void</code>
Click on target element with error handling. Version for iFrame.

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| frame | <code>Frame</code> | Frame element |
| selector | <code>string</code> | Selector of target element |

<a name="Functions.exit"></a>

### Functions.exit() ⇒ <code>void</code>
Exit program without error

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  
<a name="Functions.waitForSelector"></a>

### Functions.waitForSelector(page, selector, doThrow) ⇒ <code>void</code>
Wait for visibility of selector with error error handling

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| page | <code>Page</code> |  | Page element |
| selector | <code>string</code> |  | Selector of target element |
| doThrow | <code>boolean</code> | <code>false</code> | throws an error instead of invoking the internal errorHandling function |

<a name="Functions.select"></a>

### Functions.select(page, selector, value) ⇒ <code>void</code>
Selects value of dropdown list with error handling

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| page | <code>Page</code> | Page element |
| selector | <code>string</code> | Selector of target element |
| value | <code>string</code> | Selection value of target value (value="VALUE") |

<a name="Functions.selectFrame"></a>

### Functions.selectFrame(frame, selector, value) ⇒ <code>void</code>
Selects value of dropdown list with error handling
Version for iFrames

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| frame | <code>Frame</code> | Frame element |
| selector | <code>string</code> | Selector of target element |
| value | <code>string</code> | Selection value of target value (value="VALUE") |

<a name="Functions.type"></a>

### Functions.type(page, selector, text, time, random) ⇒ <code>void</code>
Types inside the target input element with randomized typing delays

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| page | <code>Page</code> |  | Page element |
| selector | <code>string</code> |  | Selector ot the target input element. If the selector is not given, the typing events will be executed without focusing the input element. |
| text | <code>string</code> |  | Text which should be entered |
| time | <code>number</code> | <code>456</code> | Average typing delay in milliseconds |
| random | <code>number</code> | <code>265</code> | Random deviation from average typing delay in milliseconds |

<a name="Functions.typeFrame"></a>

### Functions.typeFrame(Frame, selector, text, time, random) ⇒ <code>void</code>
Types inside the target input element with randomized typing delays
Version for iFrames

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| Frame | <code>Frame</code> |  | Frame element |
| selector | <code>string</code> |  | Selector ot the target input element. If the selector is not given, the typing events will be executed without focusing the input element. |
| text | <code>string</code> |  | Text which should be entered |
| time | <code>number</code> | <code>456</code> | Average typing delay in milliseconds |
| random | <code>number</code> | <code>265</code> | Random deviation from average typing delay |

<a name="Functions.typeEnter"></a>

### Functions.typeEnter(page) ⇒ <code>void</code>
Presses Enter button with random press and release time

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| page | <code>Page</code> | Page element |

<a name="Functions.typeTab"></a>

### Functions.typeTab(page) ⇒ <code>void</code>
Presses Tab button

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| page | <code>Page</code> | Page element |

<a name="Functions.typeEsc"></a>

### Functions.typeEsc(page) ⇒ <code>type</code>
Presses ESC button

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| page | <code>Page</code> | Page element |

<a name="Functions.typeUp"></a>

### Functions.typeUp(page, pageUp) ⇒ <code>void</code>
Presses ArrowUp or PageUp button with random delay

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| page | <code>Page</code> |  | Page element |
| pageUp | <code>boolean</code> | <code>false</code> | Presses PageUp button |

<a name="Functions.typeDown"></a>

### Functions.typeDown(page, pageDown) ⇒ <code>void</code>
Presses ArrowDown or PageDown button with random delay

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| page | <code>Page</code> |  | Page element |
| pageDown | <code>boolean</code> | <code>false</code> | Presses PageDown button |

<a name="Functions.scrollToSelector"></a>

### Functions.scrollToSelector(page, stopSelector, wait) ⇒ <code>void</code>
Scrolls to given selector

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| page | <code>Page</code> |  | Page object |
| stopSelector | <code>string</code> |  | Selector to which the function should scroll |
| wait | <code>boolean</code> | <code>true</code> | Wait after half of page is scrolled |

<a name="Functions.scrollUp"></a>

### Functions.scrollUp(page, stopSelector, wait, press, minScrolls, maxScrolls) ⇒ <code>void</code>
Scrolls page up until the selector is visible

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| page | <code>Page</code> |  | Page object |
| stopSelector | <code>string</code> |  | Selector to which the function should scroll up |
| wait | <code>boolean</code> | <code>true</code> | Wait after half of page is scrolled |
| press | <code>boolean</code> | <code>false</code> | true: Scrolling is achieved with long button press of page up-button, false: Scrolling is achieved with several short arrow up button presses |
| minScrolls | <code>number</code> | <code>11</code> | Minimum number of keyboard presses for scrolling (if press=false) |
| maxScrolls | <code>number</code> | <code>15</code> | Maximum number of keyboard presses for scrolling (if press=false) |

<a name="Functions.scrollDown"></a>

### Functions.scrollDown(page, stopSelector, wait, press, minScrolls, maxScrolls, minIterations) ⇒ <code>void</code>
Scrolls page down until the selector is visible

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| page | <code>Page</code> |  | Page object |
| stopSelector | <code>string</code> |  | Selector to which the function should scroll up |
| wait | <code>boolean</code> | <code>true</code> | Wait after half of page is scrolled |
| press | <code>boolean</code> | <code>false</code> | true: Scrolling is achieved with long button press of page down-button, false: Scrolling is achieved with several short arrow down button presses |
| minScrolls | <code>number</code> | <code>11</code> | Minimum number of keyboard presses for scrolling (if press=false) |
| maxScrolls | <code>number</code> | <code>15</code> | Maximum number of keyboard presses for scrolling (if press=false) |
| minIterations | <code>number</code> | <code>0</code> | Minimum number of how many iterations this scrolling have to be repeated (even if element has already been scrolled by) |

<a name="Functions.setValue"></a>

### Functions.setValue(page, selector, text) ⇒ <code>void</code>
Change HTML-DOM value (z.B. Textarea elements)

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| page | <code>Page</code> | Page or frame element |
| selector | <code>string</code> | Selektor of target |
| text | <code>Sting</code> | Value text to which the selected element should be changed |

<a name="Functions.deactivateLink"></a>

### Functions.deactivateLink(page, selector) ⇒ <code>void</code>
Deactivate link invocation behavior inside the browser page with injection
of JavaScript

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| page | <code>Page</code> | Page-Element |
| selector | <code>string</code> | Target selector of link which should be deactivated |

<a name="Functions.triggerClick"></a>

### Functions.triggerClick(page, selector) ⇒ <code>void</code>
Trigger click event manually via JavaScript code injection
(element does not have to be visible inside the browser)

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| page | <code>Page</code> | Page element |
| selector | <code>string</code> | Target selector to the (link/button) element which should be triggered by the function |

<a name="Functions.randomWait"></a>

### Functions.randomWait(page, time, random) ⇒ <code>void</code>
Waits for random time range

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| page | <code>Page</code> |  | Page element |
| time | <code>number</code> | <code>2000</code> | Average waiting time in milliseconds |
| random | <code>number</code> | <code>1000</code> | Maximum deviation from average waiting time in milliseconds |

<a name="Functions.randomTimeout"></a>

### Functions.randomTimeout(time, random) ⇒ <code>void</code>
Waits for a random time (alternate implementation to the randomWait function
without page element)

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| time | <code>number</code> | <code>2000</code> | Average waiting time in milliseconds |
| random | <code>number</code> | <code>1000</code> | Maximum deviation from average waiting time |

<a name="Functions.controlStatus"></a>

### Functions.controlStatus(browser, page, searchURL, timeout) ⇒ <code>void</code>
Bring page tab to the front every time after the timeout. Function is
used for several services which are known for opening extra tabs which
might crash functionality in the "headfull" mode (since the tab is not
focused anymore).

You need to set global.controlStatusRunning=true before starting this
function in order to work. Function will stop when controlStatusRunning
is set to false.

WARNING: Never use this function with "await" since it will never stop.

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| browser | <code>Browser</code> |  | Browser element |
| page | <code>Page</code> |  | Page element |
| searchURL | <code>string</code> |  | URL to search for the defined tab |
| timeout | <code>number</code> | <code>60000</code> | Timeout in milliseconds |

<a name="Functions.errorHandling"></a>

### Functions.errorHandling(page, e, doScreenshot) ⇒ <code>type</code>
Error handling function: Creates screenshot, creates log entry with it
and exits the program

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| page | <code>Page</code> |  | Page element |
| e | <code>Error</code> |  | Error element |
| doScreenshot | <code>type</code> | <code>true</code> | Create screenshot of page |

<a name="Functions.getScreenshot"></a>

### Functions.getScreenshot(page, fullPage) ⇒ <code>String</code>
Creates screenshot and returns it as a Base64 encoded string

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Returns**: <code>String</code> - Base64-encoded string of screenshot  
**Category**: static async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| page | <code>Page</code> |  | Page object |
| fullPage | <code>boolean</code> | <code>false</code> | Create screenshot of full page |

<a name="Functions.logScreenshot"></a>

### Functions.logScreenshot(page, text) ⇒ <code>void</code>
Create screenshot and save it inside the log

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| page | <code>Object</code> | Element from which the screenshot should be taken from [Page, Element, Frame] |
| text | <code>string</code> | Text for the log entry |

<a name="Functions.isSelectorVisible"></a>

### Functions.isSelectorVisible(page, selector) ⇒ <code>Boolean</code>
Check if selector is visible on page

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Returns**: <code>Boolean</code> - true: visible, false: not visible  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| page | <code>Page</code> | Page-Element |
| selector | <code>string</code> | Selector of target |

<a name="Functions.isInViewport"></a>

### Functions.isInViewport(page, selector, scrollDown) ⇒ <code>Boolean</code>
Check if selector is visible inside the browser window or has been
overscrolled before.

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Returns**: <code>Boolean</code> - true: visible, false: not visible  
**Category**: static async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| page | <code>Page</code> |  | Page element |
| selector | <code>string</code> |  | Target selector |
| scrollDown | <code>Boolean</code> | <code>true</code> | Scrolling direction (true: downwards,  false: upwards) |

<a name="Functions.getScrollY"></a>

### Functions.getScrollY(page, selector) ⇒ <code>number</code>
Get horizontal scroll variable

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Returns**: <code>number</code> - Y-scroll position  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| page | <code>Page</code> | Page object |
| selector | <code>string</code> | Selector of target |

<a name="Functions.debugLog"></a>

### Functions.debugLog(key, value, imageData) ⇒ <code>void</code>
Creates debug output in console and writes the log entry into
the database. The constant DEBUG inside settings.js has to be set to
true to see the log entries. The object global.logger of type [Logger](Logger)
(class/logger.js) has to be defined and initialized to enable database
logging. Log entries will be created in the Database if the value is set.

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Category**: static async  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| key | <code>string</code> |  | Text which should be outputted |
| value | <code>type</code> | <code>&quot;&quot;</code> | Second text which should be outputted. If this values is unequal to "", the log entry will be logged into the database. |
| imageData | <code>type</code> | <code>&quot;&quot;</code> | Base64 encoded imagedata |

<a name="Functions.solveCaptcha"></a>

### Functions.solveCaptcha(page, selector) ⇒ <code>string</code>
Solve image captcha with the help of the Anti-Captcha service. Needs
anti-captcha library to work. Library can be downloaded at
https://github.com/AdminAnticaptcha/anticaptcha-nodejs/blob/master/anticaptcha.js
and the file has to be put into the "lib"-folder of this project.

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Returns**: <code>string</code> - Submitted solution of the Captcha  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| page | <code>Page</code> | Page element |
| selector | <code>string</code> | Selector of the Captcha |

<a name="Functions.solveRecaptcha"></a>

### Functions.solveRecaptcha(iframe, selector) ⇒ <code>string</code>
Solve reCAPTCHA with the help of the Anti-Captcha service. Needs
anti-captcha library to work. Library can be downloaded at
https://github.com/AdminAnticaptcha/anticaptcha-nodejs/blob/master/anticaptcha.js
and the file has to be put into the "lib"-folder of this project.

**Kind**: static method of [<code>Functions</code>](#Functions)  
**Returns**: <code>string</code> - reCAPTCHA solution string which has to be injected
into hidden textarea element before submission of the form.  
**Category**: static async  

| Param | Type | Description |
| --- | --- | --- |
| iframe | <code>Frame</code> | Frame element (page element could be possible, but not tested) |
| selector | <code>string</code> | Selector to the reCAPTCHA iframe included inside the given frame element (needs to have URL to reCAPTCHA inside the HTML DOM attribute "src"). |

