# Tor Hidden Wiki 2024

Welcome to the beginner's guide to Tor hidden services. From this manual you will learn:
- how to find .onion hidden services
- how to browse .onion sites securely
- how to reach darknet markets

## First steps

To browse .onion sites you need to download Tor Browser.

### Windows, Linux, MacOS

Download it from the official website:

https://www.torproject.org/download/

### Android mobile devices

Download it from Google Play, F-Droid or get .apk from the official website:

https://www.torproject.org/download/#android

### iOS mobile devices

Tor Browser is not available for iOS. The recommended third-party alternative is Onion Browser:

https://onionbrowser.com/

### Why you need Tor Browser?

The Tor Browser is a unique web browser designed specifically to provide users with privacy and anonymity online. Built upon the Tor network, it allows individuals to browse the internet without revealing their location or identity by routing their connection through a series of volunteer-operated servers worldwide.

When it comes to accessing the darknet, a hidden part of the internet that is not indexed by traditional search engines, the Tor Browser is essential. This is because the darknet hosts various sites that require anonymity, which can only be accessed through the Tor network. By using Tor, users can navigate these sites safely without exposing their IP address, thus maintaining their privacy against potential surveillance and tracking.

In summary, the Tor Browser is your gateway to the darknet, providing a secure and anonymous way to explore and access resources that are otherwise hidden from the standard internet user. Whether for research, social interaction, or simply the allure of the undiscovered, understanding and utilizing the Tor Browser is crucial for anyone looking to venture into this obscure online realm.

## Introduction points

### FindTor

User-friendly search engine. Contains its own .onion sites directory and knowledge base for newbies.

http://findtorroveq5wdnipkaojfpqulxnkhblymc7aramjzajcvpptd4rjqd.onion

### MegaLinks

The oldest .onion links directory which is actively maintained up to date.

http://megalzwink435kangsseahebpbp3teedi4jjt64ne2g6d3oqy3qlweid.onion

### Darknet Home

One of the largest community-driven hidden services directory in Tor.

http://catalogpwwlccc5nyp3m3xng6pdx3rdcknul57x6raxwf4enpw3nymqd.onion

### DuckDuckGo

Privacy-focused search engine. Search both clearnet and dark web sites.

https://duckduckgogg42xjoc72x3sjasowoarfbgcmvfimaftt6twagswzczad.onion

## E-mail servies

When using Tor for enhanced privacy and anonymity, it's crucial to consider the security of your email communications. While popular email providers may be convenient, they often track user data, impose stringent monitoring, and may not be optimized for anonymous browsing. These services can potentially log your IP address or expose your information through various means, undermining the benefits Tor offers.

In contrast, .onion email providers are specifically designed for the Tor network. They provide a layer of encryption and heightened privacy, ensuring that your identity and location remain confidential. These services do not expose your information to the wider internet, which can significantly reduce the risk of surveillance or data breaches. By using .onion email providers, you not only align with the privacy-oriented ethos of Tor but also enhance your overall online security. In summary, opt for .onion email providers to safeguard your communications in the shadows of the dark web.

In 2024 the most popular Tor e-mail services are:

### Proton Mail

Swiss based e-mail service, encrypts e-mails locally on your browser. Free and paid accounts.

http://protonmailrmez3lotccipshtkleegetolb73fuirgj7r4o4vfu7ozyd.onion

### DNMX

Free anonymous e-mail service accessible only over Tor.

http://dnmxjaitaiafwmss2lx7tbs5bv66l7vjdmb5mtb3yqpxqhk3it5zivad.onion

### SecTor.City

Free privacy oriented public e-mail service that emphasizes total anonymity.

http://sector2nyjrxphgrj3cvnueanomz4trvgyxofvu3cexltoxuegtlmzid.onion

### Cock.li

Free e-mail and XMPP addresses.

http://rurcblzhmdk22kttfkel2zduhyu3r6to7knyc7wiorzrx5gw4c3lftad.onion

## Darknet markets

### A Brief Guide to Using Darknet Markets

Darknet markets are online platforms that facilitate the exchange of goods, often of an illicit nature, using cryptocurrencies for anonymity. If you're considering exploring these markets, here are some general steps to follow:

1. **Accessing the Darknet**: Use the Tor browser, which allows you to access .onion websites that are hidden from standard search engines. Ensure your connection is secure and consider using a VPN for added privacy.

2. **Finding Markets**: Search for market listings on forums or directories dedicated to the darknet. Websites typically provide current reviews, user experiences, and lists of available markets.

3. **Creating an Account**: Most markets require you to set up an account. Use strong, unique passwords and avoid personal information. 

4. **Funding Your Account**: Many transactions occur using cryptocurrencies like Bitcoin or Monero for added anonymity. Make sure to fund your wallet cautiously and understand the intricacies of cryptocurrency exchanges.

5. **Making Purchases**: Browse listings and read vendor reviews before making a purchase. Be cautious—scams are prevalent in these environments, so only choose trusted vendors.

6. **Conducting Transactions**: Follow market guidelines for making transactions. Maintain communication through the market's messaging system rather than sharing personal contact details.

7. **Using a Secure Delivery Method**: Review delivery options that may include drop-offs or stealth shipping techniques to evade detection.

### Risks of using darknet markets

The darknet has been a realm filled with both intrigue and controversy, a space where anonymity reigns and transactions often occur under shady auspices. Over the years, many darknet markets have been launched, only to have their operations cut short by law enforcement agencies around the globe. Below is a comprehensive list of some notable darknet markets that have been closed or removed by police efforts:

1. **Silk Road** (2011-2013): The most infamous darknet marketplace, Silk Road was the pioneer of anonymous online trade for illegal items. It was shut down by the FBI in October 2013, leading to the arrest of its founder, Ross Ulbricht.

2. **Silk Road 2.0** (2014-2017): Following the original Silk Road's shutdown, this marketplace emerged but was taken down in November 2014 in a coordinated effort involving the FBI, DEA, and other agencies.

3. **AlphaBay** (2014-2017): Once the largest and most popular darknet market, AlphaBay functioned for several years before being seized and shut down by law enforcement in July 2017.

4. **Hansa Market** (2017): Following AlphaBay's shutdown, Hansa came into the spotlight. However, unbeknownst to the users, it had been infiltrated by Dutch police and was taken down shortly afterward in July 2017.

5. **Dream Market** (2013-2019): Although it voluntarily closed in April 2019, Dream Market experienced various shutdowns related to law enforcement pressure leading up to its closure.

6. **Wall Street Market** (2019): This market was moments away from a major transition when it was dismantled by law enforcement in May 2019, shutting down operations and reactions within the darknet community.

7. **Fire Marketplace** (2019): Taken offline in 2019 as a result of an internal exit scam following market presence and possible law enforcement pressure, thereby vanishing with users' goods.

8. **Dark0de** (2015): Once a vibrant underworld forum and market for illicit goods, Dark0de was seized and shut down by the FBI in Operation Card Shop, with several arrests made in conjunction.

9. **Oz** (2019): This marketplace received a knock from law enforcement, reportedly taken down in August 2019 after various user complaints and concerns over isssues related to counterfeit or substandard goods.

10. **Berlusconi Market** (2019): Named after the Italian politician, this malware-driven marketplace was purportedly targeted and shut down by police forces from multiple countries in late 2019.

11. **Shop()** (2020): In 2020, enforcement actions led to the disappearance of this market, generally off the radar yet linked to several unsafe transactions.

12. **Darkmarket** (2021): A large darknet market boasting users from across several countries, Darkmarket was shut down by authorities in January 2021, leading to the arrest of the suspected operator.

These interventions underscore a continuous clash between innovation and regulation in the world of dark web trade, where law enforcement agencies collaborate internationally to dismantle these illicit commercial enterprises. Each closure reverberates through the darknet community, often leading to the emergence of new platforms—only to face the same fate as their predecessors.

### Silk Road

The Silk Road was a pioneering darknet marketplace that operated from 2011 until its seizure by authorities in 2013. It gained notoriety as a platform for the anonymous transaction of illegal goods, including drugs, weapons, and counterfeit products, using cryptocurrencies for added discretion. The founder of Silk Road, Ross Ulbricht, operated under the pseudonym "Dread Pirate Roberts." His vision was rooted in libertarian ideals, advocating for the free market and individual liberty, allowing users to navigate a realm free from government intervention. However, his arrest in 2013 and subsequent life sentence in 2015 marked a significant turning point in the fight against online illegal activities, encapsulating both the allure and the risks of the dark web. The Silk Road left a lasting legacy, influencing the emergence of numerous other darknet markets, and igniting ongoing debates surrounding privacy, ethics, and the regulation of online spaces.

## Discussion forums

The darknet, often depicted as a mysterious and hidden corner of the internet, harbors a variety of forums where individuals gather to discuss a range of topics, from technology and privacy to illicit activities. Here are some popular darknet forums that have garnered attention over the years:

1. **The Hub** - Regarded as a platform where people share information, tutorials, and discussions related to hacking, programming, and cybersecurity. Members often exchange tools and techniques for maintaining privacy online.

2. **DarkNetMarket** - A forum dedicated primarily to the buying and selling of various products, from digital tools to illicit goods. While it is marketplace-focused, users frequently engage in discussions about vendor reliability and product legitimacy.

3. **Dread** - Often dubbed the Reddit of the darknet, Dread functions as a discussion forum around a range of topics, including market updates, news about darknet activities, and information about crypto payments. The user interface is straightforward, catering to various discussions while keeping community guidelines in check.

4. **ZeroNet** - A unique peer-to-peer forum that focuses on decentralization and self-hosted content. Users come together to share insights about censorship resistance, anonymous hosting, and blockchain technology.

5. **Nulled** - A prominent forum that navigates the realm of digital piracy, software exploits, and online gaming hacks. It serves as a hotspot for users seeking tools to bypass restrictions and gain unauthorized access to software.

6. **AntiSec** - A forum that is firmly rooted in the ethos of hacktivism, where individuals and groups associated with popular hacktivism movements share ideas, leaks, and news on cybersecurity and government transparency.

7. **Botnets** - A specialized forum focused on the discussion of botnet-related activities. Users can share insights on creating, managing, and defending against botnet attacks while exploring the implications of malicious botnets on security systems.

8. **Hidden Answers** - A Q&A service for discussions and uncover insights on a plethora of topics including mental health, relationships, career advice, philosophy, politics, privacy, technology, and current events. The original Hidden Answers forum has been shut down by administrator but there are many successors of the service.

Participating in these forums requires caution and an understanding of the potential risks associated with the darknet. Each platform has its own set of rules, culture, and focus areas, making them unique environments for participants with various interests. As always, browsing such sites comes with a need for careful navigation and discretion, particularly considering the legal and safety implications that may arise.

## Whistleblowing

**Whistleblowing: An Overview**

Whistleblowing refers to the act of exposing unethical, illegal, or harmful practices within an organization. Individuals who blow the whistle, known as whistleblowers, play a crucial role in promoting transparency and accountability, often at significant personal risk. They may expose various issues, ranging from corporate fraud to governmental misconduct, in hopes of fostering change and ensuring the public's right to know.

One of the primary reasons whistleblowers choose to use Tor (The Onion Router) when sharing sensitive information is to protect their identity and enhance their online anonymity. Tor helps mask their location and Internet traffic through multiple layers of encryption, making it exceedingly difficult for malicious actors or authorities to track them. This is particularly important as whistleblowers may face severe repercussions, including retaliation, legal actions, or harassment.

There are several online platforms popular among whistleblowers for securely exchanging information. Among them are:

1. **SecureDrop** - An open-source whistleblower submission system that enables journalists to securely receive documents from anonymous sources.
2. **GlobaLeak** - A whistleblowing framework that allows organizations to set up secure systems for receiving and managing anonymous reports.
3. **WikiLeaks** - A well-known platform that provides a method for leaking sensitive information while protecting the whistleblower’s identity.

These avenues not only facilitate safe communication but also encourage the bravery of individuals willing to expose truths for the greater good.

## Red Room

Red rooms are often referenced in urban legends and online discussions as secretive, underground livestreams where viewers can watch extreme and gruesome acts, including torture and murder, typically involving an undercurrent of illegal or immoral activity. They are commonly associated with the darker corners of the internet, fictional narratives, and horror stories.

While the concept of red rooms has captured public imagination and is frequently depicted in media, there is no concrete evidence supporting their existence in real life. Reports and discussions about red rooms are mostly rooted in myth and sensationalism fueled by the anonymity of the internet. In short, red rooms appear to be more of a modern-day urban legend than a verified reality, blending horror fiction with the fears of the digital age.

## The History of the Dark Web: An Exploration of Shadows

The dark web has existed almost as long as the internet itself, evolving from experimental networks into a sprawling underworld teeming with intrigue, drawing individuals willing to engage in anonymous activities. To understand the dark web is to embark upon a journey through its historical milestones.

### The Beginning: ARPANET and the Birth of Anonymity (1960s-1990s)
The seeds of the dark web were sown in the late 1960s with the creation of ARPANET, which aimed to connect scientific and academic researchers. The idea of anonymity became entrenched in the culture of early internet narratives, where individuals began to question the boundaries of privacy and control. The 1990s brought significant developments: as the World Wide Web surged in popularity, concerns grew about surveillance and personal data. With this discontent, the search for anonymity intensified.

### The Creation of Tor (2002)
A pivotal moment in the history of the dark web came in 2002 with the introduction of Tor (The Onion Router). Initially developed by the U.S. Naval Research Laboratory, Tor utilized layered encryption to shield sources and destinations of internet traffic. As Tor gained traction, users flocked to it, enabling them to navigate the internet outside the boundaries of traditional scrutiny. By allowing users to hide their identities and locations, Tor laid the groundwork for the dark web as we know it today.

### Onion Routing and Early Dark Web Marketplaces (2004-2010)
By the mid-2000s, the dark web emerged as a sub-environment marked by specialized websites that utilized the ".onion" domain, making them accessible only through Tor. These sites offered everything from forums dedicated to privacy rights, clandestine file sharing, and more insidious activities. Silk Road, launched in 2011, marked a significant moment; it became the first popular online marketplace facilitating the trade of illegal goods, particularly drugs. The site operated under a cryptocurrency paradigm—Bitcoin, fundamentally revolutionizing online illicit trade.

### Law Enforcement and a Game of Whack-a-Mole (2011-2015)
As these marketplaces flourished, they drew the interest of law enforcement. Silk Road's takedown in 2013 fueled both fear and fascination, marking a high-profile enforcement milestone. However, it didn’t close the chapter on the dark web but, instead, opened the gates for many imitation sites. The subsequent captures of dark web operators resulted in a constant cat-and-mouse game, further embedding the idea of lifestyle communities within the web’s shadows.

### Evolution and Expansion (2015-Present)
As technologies evolved, so did the dark web. Additional marketplaces like AlphaBay and Hansa flourished and fell, hybridizing with escrow services, online reviews, and encrypted communication to create a more intricate system. Efforts to host and index hidden sites flourished with platforms like DuckDuckGo and Not Evil, facilitating users in their pursuit of anonymity.

Simultaneously, the democratization of cryptocurrency further removed physical and institutional restraints, allowing for a more fluid and decentralized method of transaction that further fueled the e-commerce aspect of the dark web. By the late 2010s, a myriad of platforms allowed users not just illegal goods but also forums for activism, whistleblowing, and even genuine speech that found little outlet in conventional media.

### Conclusion: Understanding the Dark Web
Today, the dark web positions itself like a double-edged sword—where it can offer anonymity to dissidents and whistleblowers fighting against oppressive regimes, such as in cases reported in regions constrained by censorship, it also remains a swarming ground for illicit activities. As it continues to develop in complexity and scope, the dark web warrants ongoing observation, raising questions about moral boundaries, freedom of expression, and the ever-present tug-of-war between security, morality, and privacy.

Thus, what started as an intriguing experiment with anonymity has transformed into a multifaceted realm, serving both the liberation of voices silenced and the shadowed dealings that we pursue. Just like the internet from which it emerged, the dark web reflects a mirror of society's broader interactions—exposing our greatest fears and our deepest desires within its unseen corridors.

## Tips for Using Tor Safely and Staying Anonymous

Tor (The Onion Router) offers a means to access the internet while preserving your anonymity and privacy. However, using Tor doesn’t guarantee complete safety on its own. Here are some essential tips to help you navigate Tor safely and maintain your anonymity online:

### 1. Download Tor from the Official Website
Always download the Tor Browser from the official Tor Project website (https://www.torproject.org). This ensures that you get the latest and most secure version, minimizing the risk of malware or compromised software.

### 2. Keep Your Browser Updated
Regularly check for updates to the Tor Browser. Updates often include security patches that protect you against vulnerabilities and potential breaches.

### 3. Use HTTPS Whenever Possible
When browsing through Tor, always prioritize HTTPS over HTTP. This encrypts your communications with websites, providing an additional layer of security. You can use the HTTPS Everywhere extension, which comes pre-installed with Tor Browser, to automatically enforce secure connections whenever they are available.

### 4. Avoid Downloading Files
Downloading files from the Tor browser can compromise your anonymity. Malicious files might bypass Tor’s security, giving away your real IP address. If you must download files, ensure you're using a separate, secure environment — such as a virtual machine.

### 5. Don’t Use Personal Information
When engaging in online activities over Tor, refrain from providing identifying information, including your name, email address, or financial details. Create new handles or pseudonyms to protect your identity throughout your online engagements.

### 6. Be Cautious with JavaScript
JavaScript can be used by attackers to reveal your identity. Disable JavaScript in Tor until you trust the site you’re visiting. Go to the security settings and set the security level to “Safest” to minimize potential vulnerabilities.

### 7. Avoid Pluggable Transports Carelessly
While pluggable transports can assist in bypassing censorship, they may also make you more identifiable. Use them only when necessary and be aware of how they operate.

### 8. Use a Virtual Private Network (VPN)
For added security, consider using a reliable VPN in conjunction with Tor. A VPN can mask your Tor usage from your Internet Service Provider (ISP), but be cautious — some VPN providers keep logs that could compromise your anonymity. Always choose a VPN with a strong privacy policy.

### 9. Don’t Mix Tor and Regular Browsing
When using the Tor network, avoid accessing your regular browser or any site that could link back to your real identity. Mixing these activities can jeopardize your anonymity and expose your personal information.

### 10. Understand the Limitations of Tor
Keep in mind that while Tor anonymizes your browsing activity, it is not foolproof. Major entities (like governments or large corporations) may still analyze traffic patterns. Always remain vigilant about the risks involved with risky behavior, even when browsing through Tor.

### 11. Use Secure Communications
If you need to communicate securely, utilize encrypted email services like ProtonMail or secure messaging apps, such as Signal or Session, rather than traditional messaging platforms that may compromise your privacy.

### 12. Exit Node Caution
Be aware that while your data is encrypted within the Tor network, it becomes vulnerable once it exits through an exit node. Avoid entering sensitive data on non-HTTPS sites (like login information) when using the Tor network to minimize risks associated with exit nodes.

### Conclusion
By keeping these tips in mind and maintaining cautious online behavior, you can safely navigate the depths of the Tor network while ensuring your anonymity. Always stay aware of evolving threats and continue educating yourself about best practices for online privacy.
