# Instructions for Translation

Write a prompt that is mindful of the nuances in the language with respect to its English counterpart, which serves as the baseline for translations. Here are the comparisons between the language translations and their English counterparts:


- **com_ui_examples**:
  - **english**: Examples
  - **translated**: 範例

- **com_ui_new_chat**:
  - **english**: New chat
  - **translated**: 新對話

- **com_ui_happy_birthday**:
  - **english**: It's my 1st birthday!
  - **translated**: 這是我的第一個生日！

- **com_ui_example_quantum_computing**:
  - **english**: Explain quantum computing in simple terms
  - **translated**: 用簡單的方式解釋量子計算

- **com_ui_example_10_year_old_b_day**:
  - **english**: Got any creative ideas for a 10 year old's birthday?
  - **translated**: 有沒有創意十足的十歲生日派對點子？

- **com_ui_example_http_in_js**:
  - **english**: How do I make an HTTP request in Javascript?
  - **translated**: 如何在 JavaScript 中發起 HTTP 請求？

- **com_ui_capabilities**:
  - **english**: Capabilities
  - **translated**: 功能

- **com_ui_capability_remember**:
  - **english**: Remembers what user said earlier in the conversation
  - **translated**: 能記得先前在對話中提到的內容

- **com_ui_capability_correction**:
  - **english**: Allows user to provide follow-up corrections
  - **translated**: 允許使用者提供後續的修正

- **com_ui_capability_decline_requests**:
  - **english**: Trained to decline inappropriate requests
  - **translated**: 訓練有素以拒絕不適當的請求

- **com_ui_limitations**:
  - **english**: Limitations
  - **translated**: 限制

- **com_ui_limitation_incorrect_info**:
  - **english**: May occasionally generate incorrect information
  - **translated**: 有時可能會產生不正確的資訊

- **com_ui_limitation_harmful_biased**:
  - **english**: May occasionally produce harmful instructions or biased content
  - **translated**: 有時可能會產生有害的指示或帶有偏見的內容

- **com_ui_limitation_limited_2021**:
  - **english**: Limited knowledge of world and events after 2021
  - **translated**: 對於 2021 年後的世界和事件的知識有限

- **com_ui_input**:
  - **english**: Input
  - **translated**: 輸入

- **com_ui_close**:
  - **english**: Close
  - **translated**: 關閉

- **com_ui_model**:
  - **english**: Model
  - **translated**: 模型

- **com_ui_select_model**:
  - **english**: Select a model
  - **translated**: 選擇模型

- **com_ui_use_prompt**:
  - **english**: Use prompt
  - **translated**: 使用提示

- **com_ui_prev**:
  - **english**: Prev
  - **translated**: 上一個

- **com_ui_next**:
  - **english**: Next
  - **translated**: 下一個

- **com_ui_prompt_templates**:
  - **english**: Prompt Templates
  - **translated**: 提示範本

- **com_ui_hide_prompt_templates**:
  - **english**: Hide Prompt Templates
  - **translated**: 隱藏提示範本

- **com_ui_showing**:
  - **english**: Showing
  - **translated**: 顯示

- **com_ui_of**:
  - **english**: of
  - **translated**: 的

- **com_ui_entries**:
  - **english**: Entries
  - **translated**: 條目

- **com_ui_pay_per_call**:
  - **english**: All AI conversations in one place. Pay per call and not per month
  - **translated**: 將所有 AI 對話都在集中在一處，按用量付費而非固定月費

- **com_ui_enter**:
  - **english**: Enter
  - **translated**: 輸入

- **com_ui_submit**:
  - **english**: Submit
  - **translated**: 送出

- **com_ui_upload_success**:
  - **english**: Successfully uploaded file
  - **translated**: 檔案上傳成功

- **com_ui_upload_invalid**:
  - **english**: Invalid file for upload. Must be an image not exceeding 2 MB
  - **translated**: 上傳檔案無效

- **com_ui_cancel**:
  - **english**: Cancel
  - **translated**: 取消

- **com_ui_save**:
  - **english**: Save
  - **translated**: 儲存

- **com_ui_copy_to_clipboard**:
  - **english**: Copy to clipboard
  - **translated**: 複製到剪貼簿

- **com_ui_copied_to_clipboard**:
  - **english**: Copied to clipboard
  - **translated**: 已複製到剪貼簿

- **com_ui_regenerate**:
  - **english**: Regenerate
  - **translated**: 重新生成

- **com_ui_continue**:
  - **english**: Continue
  - **translated**: 繼續

- **com_ui_edit**:
  - **english**: Edit
  - **translated**: 編輯

- **com_ui_success**:
  - **english**: Success
  - **translated**: 成功

- **com_ui_all**:
  - **english**: all
  - **translated**: 全部

- **com_ui_clear**:
  - **english**: Clear
  - **translated**: 清除

- **com_ui_revoke**:
  - **english**: Revoke
  - **translated**: 撤銷

- **com_ui_revoke_info**:
  - **english**: Revoke all user provided credentials
  - **translated**: 撤銷所有使用者提供的憑證。

- **com_ui_import_conversation**:
  - **english**: Import
  - **translated**: 導入

- **com_ui_import_conversation_info**:
  - **english**: Import conversations from a JSON file
  - **translated**: 從JSON文件導入對話

- **com_ui_import_conversation_success**:
  - **english**: Conversations imported successfully
  - **translated**: 對話導入成功

- **com_ui_import_conversation_error**:
  - **english**: There was an error importing your conversations
  - **translated**: 導入對話時發生錯誤

- **com_ui_confirm_action**:
  - **english**: Confirm Action
  - **translated**: 確認操作

- **com_ui_chats**:
  - **english**: chats
  - **translated**: 對話

- **com_ui_delete**:
  - **english**: Delete
  - **translated**: 刪除

- **com_ui_delete_conversation**:
  - **english**: Delete chat?
  - **translated**: 刪除對話？

- **com_ui_delete_confirm**:
  - **english**: This will delete
  - **translated**: 這將刪除

- **com_ui_rename**:
  - **english**: Rename
  - **translated**: 重新命名

- **com_ui_archive**:
  - **english**: Archive
  - **translated**: 封存

- **com_ui_archive_error**:
  - **english**: Failed to archive conversation
  - **translated**: 封存對話時發生錯誤

- **com_ui_unarchive**:
  - **english**: Unarchive
  - **translated**: 取消封存

- **com_ui_unarchive_error**:
  - **english**: Failed to unarchive conversation
  - **translated**: 取消封存對話時發生錯誤

- **com_ui_more_options**:
  - **english**: More
  - **translated**: 更多

- **com_auth_error_login**:
  - **english**: Unable to login with the information provided. Please check your credentials and try again.
  - **translated**: 無法使用提供的資訊登入。請檢查您的登入資訊後重試。

- **com_auth_error_login_rl**:
  - **english**: Too many login attempts in a short amount of time. Please try again later.
  - **translated**: 短時間內嘗試登入的次數過多。請稍後再試。

- **com_auth_error_login_ban**:
  - **english**: Your account has been temporarily banned due to violations of our service.
  - **translated**: 由於違反我們的服務條款，您的帳號已被暫時停用。

- **com_auth_error_login_server**:
  - **english**: There was an internal server error. Please wait a few moments and try again.
  - **translated**: 發生內部伺服器錯誤。請稍候片刻，然後重試。

- **com_auth_no_account**:
  - **english**: Don't have an account?
  - **translated**: 還沒有帳號？

- **com_auth_sign_up**:
  - **english**: Sign up
  - **translated**: 註冊

- **com_auth_sign_in**:
  - **english**: Sign in
  - **translated**: 登入

- **com_auth_google_login**:
  - **english**: Continue with Google
  - **translated**: 使用 Google 登入

- **com_auth_facebook_login**:
  - **english**: Continue with Facebook
  - **translated**: 使用 Facebook 登入

- **com_auth_github_login**:
  - **english**: Continue with Github
  - **translated**: 使用 GitHub 登入

- **com_auth_discord_login**:
  - **english**: Continue with Discord
  - **translated**: 使用 Discord 登入

- **com_auth_email**:
  - **english**: Email
  - **translated**: 電子郵件

- **com_auth_email_required**:
  - **english**: Email is required
  - **translated**: 電子郵件必填

- **com_auth_email_min_length**:
  - **english**: Email must be at least 6 characters
  - **translated**: 電子郵件長度必須至少有 6 個字元

- **com_auth_email_max_length**:
  - **english**: Email should not be longer than 120 characters
  - **translated**: 電子郵件不應超過 120 個字元

- **com_auth_email_pattern**:
  - **english**: You must enter a valid email address
  - **translated**: 您必須輸入有效的電子郵件地址

- **com_auth_email_address**:
  - **english**: Email address
  - **translated**: 電子郵件地址

- **com_auth_password**:
  - **english**: Password
  - **translated**: 密碼

- **com_auth_password_required**:
  - **english**: Password is required
  - **translated**: 密碼必填

- **com_auth_password_min_length**:
  - **english**: Password must be at least 8 characters
  - **translated**: 密碼長度必須至少有 8 個字元

- **com_auth_password_max_length**:
  - **english**: Password must be less than 128 characters
  - **translated**: 密碼長度必須少於 128 個字元

- **com_auth_password_forgot**:
  - **english**: Forgot Password?
  - **translated**: 忘記密碼？

- **com_auth_password_confirm**:
  - **english**: Confirm password
  - **translated**: 確認密碼

- **com_auth_password_not_match**:
  - **english**: Passwords do not match
  - **translated**: 密碼不符

- **com_auth_continue**:
  - **english**: Continue
  - **translated**: 繼續

- **com_auth_create_account**:
  - **english**: Create your account
  - **translated**: 建立您的帳號

- **com_nav_auto_scroll**:
  - **english**: Auto-scroll to Newest on Open
  - **translated**: 開啟時自動捲動至最新內容

- **com_auth_error_create**:
  - **english**: There was an error attempting to register your account. Please try again.
  - **translated**: 嘗試註冊您的帳號時發生錯誤。請重試。

- **com_auth_full_name**:
  - **english**: Full name
  - **translated**: 全名

- **com_auth_name_required**:
  - **english**: Name is required
  - **translated**: 名稱必填

- **com_auth_name_min_length**:
  - **english**: Name must be at least 3 characters
  - **translated**: 名稱長度必須至少有 3 個字元

- **com_auth_name_max_length**:
  - **english**: Name must be less than 80 characters
  - **translated**: 名稱長度長度必須少於 80 個字元

- **com_auth_username**:
  - **english**: Username (optional)
  - **translated**: 使用者名稱（選填）

- **com_auth_username_required**:
  - **english**: Username is required
  - **translated**: 使用者名稱必填

- **com_auth_username_min_length**:
  - **english**: Username must be at least 2 characters
  - **translated**: 使用者名稱長度必須至少有 2 個字元

- **com_auth_username_max_length**:
  - **english**: Username must be less than 20 characters
  - **translated**: 使用者名稱長度必須少於 20 個字元

- **com_auth_already_have_account**:
  - **english**: Already have an account?
  - **translated**: 已經有帳號了？

- **com_auth_login**:
  - **english**: Login
  - **translated**: 登入

- **com_auth_reset_password**:
  - **english**: Reset your password
  - **translated**: 重設密碼

- **com_auth_click**:
  - **english**: Click
  - **translated**: 點選

- **com_auth_here**:
  - **english**: HERE
  - **translated**: 這裡

- **com_auth_to_reset_your_password**:
  - **english**: to reset your password.
  - **translated**: 重設您的密碼。

- **com_auth_reset_password_link_sent**:
  - **english**: Email Sent
  - **translated**: 電子郵件已傳送

- **com_auth_reset_password_email_sent**:
  - **english**: An email has been sent to you with further instructions to reset your password.
  - **translated**: 已向您傳送電子郵件，其中包含進一步重設密碼的操作說明。

- **com_auth_error_reset_password**:
  - **english**: There was a problem resetting your password. There was no user found with the email address provided. Please try again.
  - **translated**: 重設密碼時出現問題。找不到使用提供的電子郵件地址的使用者。請重試。

- **com_auth_reset_password_success**:
  - **english**: Password Reset Success
  - **translated**: 密碼重設成功

- **com_auth_login_with_new_password**:
  - **english**: You may now login with your new password.
  - **translated**: 您現在可以使用新密碼登入。

- **com_auth_error_invalid_reset_token**:
  - **english**: This password reset token is no longer valid.
  - **translated**: 此密碼重設令牌已無效。

- **com_auth_click_here**:
  - **english**: Click here
  - **translated**: 點選這裡

- **com_auth_to_try_again**:
  - **english**: to try again.
  - **translated**: 重試。

- **com_auth_submit_registration**:
  - **english**: Submit registration
  - **translated**: 送出

- **com_auth_welcome_back**:
  - **english**: Welcome back
  - **translated**: 歡迎回來

- **com_endpoint_open_menu**:
  - **english**: Open Menu
  - **translated**: 開啟選單

- **com_endpoint_bing_enable_sydney**:
  - **english**: Enable Sydney
  - **translated**: Sydney

- **com_endpoint_bing_to_enable_sydney**:
  - **english**: To enable Sydney
  - **translated**: 啟用 Sydney

- **com_endpoint_bing_jailbreak**:
  - **english**: Jailbreak
  - **translated**: 越獄

- **com_endpoint_bing_context_placeholder**:
  - **english**: Bing can use up to 7k tokens for 'context', which it can reference for the conversation. The specific limit is not known but may run into errors exceeding 7k tokens
  - **translated**: Bing 可以使用多達 7k 個 token 作為「前後文」，並在對話中引用。具體限制不詳，但可能會在超過 7k token 時出現錯誤

- **com_endpoint_bing_system_message_placeholder**:
  - **english**: WARNING: Misuse of this feature can get you BANNED from using Bing! Click on 'System Message' for full instructions and the default message if omitted, which is the 'Sydney' preset that is considered safe.
  - **translated**: 警告：不當使用此功能可能會導致您被禁止使用 Bing！如需完整指引和預設訊息（若未設定），請點選「系統訊息」，這是被認為安全的「Sydney」預設值。

- **com_endpoint_system_message**:
  - **english**: System Message
  - **translated**: 系統訊息

- **com_endpoint_default_blank**:
  - **english**: default: blank
  - **translated**: 預設：空白

- **com_endpoint_default_false**:
  - **english**: default: false
  - **translated**: 預設：否

- **com_endpoint_default_creative**:
  - **english**: default: creative
  - **translated**: 預設：創意

- **com_endpoint_default_empty**:
  - **english**: default: empty
  - **translated**: 預設：空

- **com_endpoint_default_with_num**:
  - **english**: default: {0}
  - **translated**: 預設：{0}

- **com_endpoint_context**:
  - **english**: Context
  - **translated**: 前後文

- **com_endpoint_tone_style**:
  - **english**: Tone Style
  - **translated**: 語氣風格

- **com_endpoint_token_count**:
  - **english**: Token count
  - **translated**: token 數量

- **com_endpoint_output**:
  - **english**: Output
  - **translated**: 輸出

- **com_endpoint_google_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: 較高的值表示更隨機，而較低的值表示更集中和確定。我們建議修改這個或 Top P，但不建議兩者都修改。

- **com_endpoint_google_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p 調整模型在輸出 token 時的選擇機制。從最可能的 K（見 topK 參數）開始選擇 token，直到它們的機率之和達到 top-p 值。

- **com_endpoint_google_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k 調整模型如何選取輸出的 token。當 Top-k 設為 1 時，模型會選取在其詞彙庫中機率最高的 token 進行輸出（這也被稱為貪婪解碼）。相對地，當 Top-k 設為 3 時，模型會從機率最高的三個 token 中選取下一個輸出 token（這會涉及到所謂的「溫度」調整）

- **com_endpoint_google_maxoutputtokens**:
  - **english**:  	Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: 設定回應中可生成的最大 token 數。若希望回應簡短，請設定較低的數值；若需較長的回應，則設定較高的數值。

- **com_endpoint_google_custom_name_placeholder**:
  - **english**: Set a custom name for Google
  - **translated**: 為 Google 設定自定義名稱

- **com_endpoint_prompt_prefix_placeholder**:
  - **english**: Set custom instructions or context. Ignored if empty.
  - **translated**: 設定自定義提示或前後文。如果為空則忽略。

- **com_endpoint_custom_name**:
  - **english**: Custom Name
  - **translated**: 自定義名稱

- **com_endpoint_prompt_prefix**:
  - **english**: Custom Instructions
  - **translated**: 提示起始字串

- **com_endpoint_temperature**:
  - **english**: Temperature
  - **translated**: 溫度

- **com_endpoint_default**:
  - **english**: default
  - **translated**: 預設

- **com_endpoint_top_p**:
  - **english**: Top P
  - **translated**: Top P

- **com_endpoint_top_k**:
  - **english**: Top K
  - **translated**: Top K

- **com_endpoint_max_output_tokens**:
  - **english**: Max Output Tokens
  - **translated**: 最大輸出 token 數

- **com_endpoint_openai_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: 較高的值表示更隨機，而較低的值表示更集中和確定。我們建議修改這個或 Top P，但不建議兩者都修改。

- **com_endpoint_openai_max**:
  - **english**: The max tokens to generate. The total length of input tokens and generated tokens is limited by the model's context length.
  - **translated**: 要生成的最大 token 數。輸入 token 和生成 token 的總長度受到模型前後文長度的限制。

- **com_endpoint_openai_topp**:
  - **english**: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We recommend altering this or temperature but not both.
  - **translated**: 與溫度取樣的替代方法，稱為核心取樣，其中模型考慮 top_p 機率質量的 token 結果。所以 0.1 表示只考慮佔 top 10% 機率質量的 token 。我們建議修改這個或溫度，但不建議兩者都修改。

- **com_endpoint_openai_freq**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
  - **translated**: 數值範圍介於 -2.0 和 2.0 之間。正值會根據該 token 在目前的文字中出現的頻率進行懲罰，減少模型產生重複內容的可能性。

- **com_endpoint_openai_pres**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
  - **translated**: 數值範圍介於 -2.0 和 2.0 之間。正值會根據該 token 是否在目前的文字中出現來進行懲罰，增加模型談及新主題的可能性。

- **com_endpoint_openai_custom_name_placeholder**:
  - **english**: Set a custom name for the AI
  - **translated**: 為 ChatGPT 設定自定義名稱

- **com_endpoint_openai_prompt_prefix_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: 在系統訊息中設定自定義提示。

- **com_endpoint_anthropic_temp**:
  - **english**: Ranges from 0 to 1. Use temp closer to 0 for analytical / multiple choice, and closer to 1 for creative and generative tasks. We recommend altering this or Top P but not both.
  - **translated**: 範圍從 0 到 1。對於分析/多選題，使用接近 0 的溫度，對於創意和生成式任務，使用接近 1 的溫度。我們建議修改這個或 Top P，但不建議兩者都修改。

- **com_endpoint_anthropic_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p 改變模型選擇輸出 token 的方式。從最可能的 K（見 topK 參數）開始選擇 token，直到它們的機率之和達到 top-p 值。

- **com_endpoint_anthropic_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k 改變模型選擇輸出 token 的方式。Top-k 為 1 表示所選 token 在模型詞彙表中所有 token 中最可能（也稱為貪婪解碼），而 Top-k 為 3 表示下一個 token 從最可能的 3 個 token 中選擇（使用溫度）。

- **com_endpoint_anthropic_maxoutputtokens**:
  - **english**: Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: 設定回應中可生成的最大 token 數。若希望回應簡短，請設定較低的數值；若需較長的回應，則設定較高的數值。

- **com_endpoint_anthropic_custom_name_placeholder**:
  - **english**: Set a custom name for Anthropic
  - **translated**: 為 Anthropic 設定自定義名稱

- **com_endpoint_frequency_penalty**:
  - **english**: Frequency Penalty
  - **translated**: 頻率懲罰

- **com_endpoint_presence_penalty**:
  - **english**: Presence Penalty
  - **translated**: 出現懲罰

- **com_endpoint_plug_use_functions**:
  - **english**: Use Functions
  - **translated**: 使用外掛作為 OpenAI 函式

- **com_endpoint_plug_skip_completion**:
  - **english**: Skip Completion
  - **translated**: 跳過完成步驟

- **com_endpoint_disabled_with_tools**:
  - **english**: disabled with tools
  - **translated**: 與工具一起停用

- **com_endpoint_disabled_with_tools_placeholder**:
  - **english**: Disabled with Tools Selected
  - **translated**: 選擇工具時停用

- **com_endpoint_plug_set_custom_instructions_for_gpt_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: 在系統訊息中新增自定義提示。

- **com_endpoint_import**:
  - **english**: Import
  - **translated**: 匯入

- **com_endpoint_set_custom_name**:
  - **english**: Set a custom name, in case you can find this preset
  - **translated**: 設定自定義名稱，以便您找到此預設設定

- **com_endpoint_preset**:
  - **english**: preset
  - **translated**: 預設設定

- **com_endpoint_presets**:
  - **english**: presets
  - **translated**: 預設設定

- **com_endpoint_preset_name**:
  - **english**: Preset Name
  - **translated**: 名稱

- **com_endpoint_new_topic**:
  - **english**: New Topic
  - **translated**: 新主題

- **com_endpoint**:
  - **english**: Endpoint
  - **translated**: 選項

- **com_endpoint_hide**:
  - **english**: Hide
  - **translated**: 隱藏

- **com_endpoint_show**:
  - **english**: Show
  - **translated**: 顯示

- **com_endpoint_examples**:
  - **english**:  Presets
  - **translated**: 預設設定

- **com_endpoint_completion**:
  - **english**: Completion
  - **translated**: 完成

- **com_endpoint_agent**:
  - **english**: Agent
  - **translated**: 代理

- **com_endpoint_show_what_settings**:
  - **english**: Show {0} Settings
  - **translated**: 顯示 {0} 設定

- **com_endpoint_export**:
  - **english**: Export
  - **translated**: 匯出

- **com_endpoint_save_as_preset**:
  - **english**: Save As Preset
  - **translated**: 另存為預設設定

- **com_endpoint_presets_clear_warning**:
  - **english**: Are you sure you want to clear all presets? This is irreversible.
  - **translated**: 您確定要清除所有預設設定嗎？此操作無法復原。

- **com_endpoint_not_implemented**:
  - **english**: Not implemented
  - **translated**: 尚未實做

- **com_endpoint_no_presets**:
  - **english**: No presets yet, use the settings button to create one
  - **translated**: 尚無預設設定

- **com_endpoint_not_available**:
  - **english**: No endpoint available
  - **translated**: 無可用選項

- **com_endpoint_view_options**:
  - **english**: View Options
  - **translated**: 檢視選項

- **com_endpoint_save_convo_as_preset**:
  - **english**: Save Conversation as Preset
  - **translated**: 將對話另存為預設設定

- **com_endpoint_my_preset**:
  - **english**: My Preset
  - **translated**: 我的預設設定

- **com_endpoint_agent_model**:
  - **english**: Agent Model (Recommended: GPT-3.5)
  - **translated**: 代理模型（建議：GPT-3.5）

- **com_endpoint_completion_model**:
  - **english**: Completion Model (Recommended: GPT-4)
  - **translated**: 完成模型（建議：GPT-4）

- **com_endpoint_func_hover**:
  - **english**: Enable use of Plugins as OpenAI Functions
  - **translated**: 啟用將外掛用作 OpenAI 函式

- **com_endpoint_skip_hover**:
  - **english**: Enable skipping the completion step, which reviews the final answer and generated steps
  - **translated**: 啟用跳過完成步驟，評估最終答案和生成步驟

- **com_endpoint_config_key**:
  - **english**: Set API Key
  - **translated**: 設定 API 金鑰

- **com_endpoint_config_key_for**:
  - **english**: Set API Key for
  - **translated**: 設定 API 金鑰給

- **com_endpoint_config_key_name**:
  - **english**: Key
  - **translated**: 金鑰

- **com_endpoint_config_value**:
  - **english**: Enter value for
  - **translated**: 輸入

- **com_endpoint_config_key_name_placeholder**:
  - **english**: Set API key first
  - **translated**: 請先設定 API 金鑰

- **com_endpoint_config_key_encryption**:
  - **english**: Your key will be encrypted and deleted at
  - **translated**: 您的金鑰將被加密並在此到期時間刪除：

- **com_endpoint_config_key_expiry**:
  - **english**: the expiry time
  - **translated**: 到期時刪除

- **com_endpoint_config_key_import_json_key**:
  - **english**: Import Service Account JSON Key.
  - **translated**: 匯入服務帳戶 JSON 金鑰。

- **com_endpoint_config_key_import_json_key_success**:
  - **english**: Successfully Imported Service Account JSON Key
  - **translated**: 成功匯入服務帳戶 JSON 金鑰

- **com_endpoint_config_key_import_json_key_invalid**:
  - **english**: Invalid Service Account JSON Key, Did you import the correct file?
  - **translated**: 無效的服務帳戶 JSON 金鑰，您是否匯入了正確的檔案？

- **com_endpoint_config_key_get_edge_key**:
  - **english**: To get your Access token for Bing, login to
  - **translated**: 要取得 Bing 的存取權杖，請登入到

- **com_endpoint_config_key_get_edge_key_dev_tool**:
  - **english**: Use dev tools or an extension while logged into the site to copy the content of the _U cookie. If this fails, follow these
  - **translated**: 使用開發工具或擴充套件在登入網站時複製 _U cookie 的內容。如果此方法失敗，請按照這些

- **com_endpoint_config_key_edge_instructions**:
  - **english**: instructions
  - **translated**: 說明

- **com_endpoint_config_key_edge_full_key_string**:
  - **english**: to provide the full cookie strings.
  - **translated**: 提供完整的 cookie 字串。

- **com_endpoint_config_key_chatgpt**:
  - **english**: To get your Access token For ChatGPT 'Free Version', login to
  - **translated**: 要取得 ChatGPT '免費版' 的存取權杖，請登入到

- **com_endpoint_config_key_chatgpt_then_visit**:
  - **english**: then visit
  - **translated**: 然後造訪

- **com_endpoint_config_key_chatgpt_copy_token**:
  - **english**: Copy access token.
  - **translated**: 複製存取權杖。

- **com_endpoint_config_key_google_need_to**:
  - **english**: You need to
  - **translated**: 您需要

- **com_endpoint_config_key_google_vertex_ai**:
  - **english**: Enable Vertex AI
  - **translated**: 在 Google Cloud 上啟用 Vertex AI

- **com_endpoint_config_key_google_vertex_api**:
  - **english**: API on Google Cloud, then
  - **translated**: API，然後

- **com_endpoint_config_key_google_service_account**:
  - **english**: Create a Service Account
  - **translated**: 建立一個服務帳戶

- **com_endpoint_config_key_google_vertex_api_role**:
  - **english**: Make sure to click 'Create and Continue' to give at least the 'Vertex AI User' role. Lastly, create a JSON key to import here.
  - **translated**: 確保點選「建立並繼續」並至少給予「Vertex AI 使用者」角色。最後，建立一個 JSON 金鑰以在此處匯入。

- **com_nav_plugin_store**:
  - **english**: Plugin store
  - **translated**: 外掛商店

- **com_nav_plugin_search**:
  - **english**: Search plugins
  - **translated**: 搜尋外掛

- **com_nav_plugin_auth_error**:
  - **english**: There was an error attempting to authenticate this plugin. Please try again.
  - **translated**: 嘗試驗證此外掛時發生錯誤。請重試。

- **com_nav_export_filename**:
  - **english**: Filename
  - **translated**: 檔名

- **com_nav_export_filename_placeholder**:
  - **english**: Set the filename
  - **translated**: 設定檔案名稱

- **com_nav_export_type**:
  - **english**: Type
  - **translated**: 類型

- **com_nav_export_include_endpoint_options**:
  - **english**: Include endpoint options
  - **translated**: 包含 AI 選項

- **com_nav_enabled**:
  - **english**: Enabled
  - **translated**: 已啟用

- **com_nav_not_supported**:
  - **english**: Not Supported
  - **translated**: 不支援

- **com_nav_export_all_message_branches**:
  - **english**: Export all message branches
  - **translated**: 匯出所有訊息分支

- **com_nav_export_recursive_or_sequential**:
  - **english**: Recursive or sequential?
  - **translated**: 遞迴還是序列？

- **com_nav_export_recursive**:
  - **english**: Recursive
  - **translated**: 遞迴

- **com_nav_export_conversation**:
  - **english**: Export conversation
  - **translated**: 匯出對話

- **com_nav_theme**:
  - **english**: Theme
  - **translated**: 主題

- **com_nav_theme_system**:
  - **english**: System
  - **translated**: 跟隨系統設定

- **com_nav_theme_dark**:
  - **english**: Dark
  - **translated**: 深色

- **com_nav_theme_light**:
  - **english**: Light
  - **translated**: 淺色

- **com_nav_clear_all_chats**:
  - **english**: Clear all chats
  - **translated**: 清除所有對話

- **com_nav_confirm_clear**:
  - **english**: Confirm Clear
  - **translated**: 確認清除

- **com_nav_close_sidebar**:
  - **english**: Close sidebar
  - **translated**: 關閉側邊選單

- **com_nav_open_sidebar**:
  - **english**: Open sidebar
  - **translated**: 開啟側邊選單

- **com_nav_send_message**:
  - **english**: Send message
  - **translated**: 傳送訊息

- **com_nav_log_out**:
  - **english**: Log out
  - **translated**: 登出

- **com_nav_user**:
  - **english**: USER
  - **translated**: 使用者

- **com_nav_archived_chats**:
  - **english**: Archived chats
  - **translated**: 封存的對話

- **com_nav_archived_chats_manage**:
  - **english**: Manage
  - **translated**: 管理

- **com_nav_archived_chats_empty**:
  - **english**: You have no archived conversations.
  - **translated**: 您沒有任何封存的對話。

- **com_nav_archive_all_chats**:
  - **english**: Archive all chats
  - **translated**: 封存所有對話

- **com_nav_archive_all**:
  - **english**: Archive all
  - **translated**: 封存所有

- **com_nav_archive_name**:
  - **english**: Name
  - **translated**: 名稱

- **com_nav_archive_created_at**:
  - **english**: DateCreated
  - **translated**: 建立時間

- **com_nav_clear_conversation**:
  - **english**: Clear conversations
  - **translated**: 清除對話

- **com_nav_clear_conversation_confirm_message**:
  - **english**: Are you sure you want to clear all conversations? This is irreversible.
  - **translated**: 您確定要清除所有對話嗎？此操作無法復原。

- **com_nav_help_faq**:
  - **english**: Help & FAQ
  - **translated**: 說明與常見問題

- **com_nav_settings**:
  - **english**: Settings
  - **translated**: 設定

- **com_nav_search_placeholder**:
  - **english**: Search messages
  - **translated**: 搜尋訊息

- **com_nav_setting_general**:
  - **english**: General
  - **translated**: 一般

- **com_nav_setting_data**:
  - **english**: Data controls
  - **translated**: 資料控制

Please consider the above comparisons to enhance understanding and guide improvements in translations.

Provide insights or suggestions that could help refine the translation process, focusing on cultural and contextual relevance.

Please craft a prompt that can be used to better inform future translations to this language.

Write this prompt in the translated language, with all its nuances detected, not in the English.
