# Instructions for Translation

Write a prompt that is mindful of the nuances in the language with respect to its English counterpart, which serves as the baseline for translations. Here are the comparisons between the language translations and their English counterparts:


- **com_files_no_results**:
  - **english**: No results.
  - **translated**: 无结果。

- **com_files_filter**:
  - **english**: Filter files...
  - **translated**: 筛选文件...

- **com_files_number_selected**:
  - **english**: {0} of {1} file(s) selected
  - **translated**: 已选择 {0} 个文件（共 {1} 个文件）

- **com_sidepanel_select_assistant**:
  - **english**: Select an Assistant
  - **translated**: 选择助手

- **com_sidepanel_assistant_builder**:
  - **english**: Assistant Builder
  - **translated**: 助手生成器

- **com_sidepanel_hide_panel**:
  - **english**: Hide Panel
  - **translated**: 隐藏侧边栏

- **com_sidepanel_attach_files**:
  - **english**: Attach Files
  - **translated**: 附加文件

- **com_sidepanel_manage_files**:
  - **english**: Manage Files
  - **translated**: 管理文件

- **com_assistants_capabilities**:
  - **english**: Capabilities
  - **translated**: 功能

- **com_assistants_knowledge**:
  - **english**: Knowledge
  - **translated**: 知识

- **com_assistants_knowledge_info**:
  - **english**: If you upload files under Knowledge, conversations with your Assistant may include file contents.
  - **translated**: 如果您在“知识”中上传文件，与助手的对话可能包括文件内容。

- **com_assistants_knowledge_disabled**:
  - **english**: Assistant must be created, and Code Interpreter or Retrieval must be enabled and saved before uploading files as Knowledge.
  - **translated**: 必须创建助手，且启用并保存代码解释器或检索，才能将文件作为知识上传。

- **com_assistants_image_vision**:
  - **english**: Image Vision
  - **translated**: 识图

- **com_assistants_code_interpreter**:
  - **english**: Code Interpreter
  - **translated**: 代码解释器

- **com_assistants_code_interpreter_files**:
  - **english**: The following files are only available for Code Interpreter:
  - **translated**: 以下文件仅适用于代码解释器：

- **com_assistants_retrieval**:
  - **english**: Retrieval
  - **translated**: 检索

- **com_assistants_search_name**:
  - **english**: Search assistants by name
  - **translated**: 按名称搜索助手

- **com_ui_tools**:
  - **english**: Tools
  - **translated**: 工具

- **com_assistants_actions**:
  - **english**: Actions
  - **translated**: 操作

- **com_assistants_add_tools**:
  - **english**: Add Tools
  - **translated**: 添加工具

- **com_assistants_add_actions**:
  - **english**: Add Actions
  - **translated**: 添加操作

- **com_assistants_available_actions**:
  - **english**: Available Actions
  - **translated**: 可用操作

- **com_assistants_running_action**:
  - **english**: Running action
  - **translated**: 正在运行操作

- **com_assistants_completed_action**:
  - **english**: Talked to {0}
  - **translated**: 与 {0} 聊天

- **com_assistants_completed_function**:
  - **english**: Ran {0}
  - **translated**: 运行 {0}

- **com_assistants_function_use**:
  - **english**: Assistant used {0}
  - **translated**: 助手使用了 {0}

- **com_assistants_domain_info**:
  - **english**: Assistant sent this info to {0}
  - **translated**: 助手将此信息发送到了 {0}

- **com_assistants_delete_actions_success**:
  - **english**: Successfully deleted Action from Assistant
  - **translated**: 已成功从助手删除操作

- **com_assistants_update_actions_success**:
  - **english**: Successfully created or updated Action
  - **translated**: 已成功创建或更新操作

- **com_assistants_update_actions_error**:
  - **english**: There was an error creating or updating the action.
  - **translated**: 创建或更新操作时出错。

- **com_assistants_delete_actions_error**:
  - **english**: There was an error deleting the action.
  - **translated**: 删除操作时出错。

- **com_assistants_actions_info**:
  - **english**: Let your Assistant retrieve information or take actions via API's
  - **translated**: 让您的助手通过 API 检索信息或执行操作

- **com_assistants_name_placeholder**:
  - **english**: Optional: The name of the assistant
  - **translated**: （选填）助手的名称

- **com_assistants_instructions_placeholder**:
  - **english**: The system instructions that the assistant uses
  - **translated**: 助手使用的系统指令

- **com_assistants_description_placeholder**:
  - **english**: Optional: Describe your Assistant here
  - **translated**: （选填）在此处描述您的助手

- **com_assistants_actions_disabled**:
  - **english**: You need to create an assistant before adding actions.
  - **translated**: 您需要先创建助手，然后才能添加操作。

- **com_assistants_update_success**:
  - **english**: Successfully updated
  - **translated**: 更新成功

- **com_assistants_update_error**:
  - **english**: There was an error updating your assistant.
  - **translated**: 更新助手时出错。

- **com_assistants_create_success**:
  - **english**: Successfully created
  - **translated**: 已成功创建

- **com_assistants_create_error**:
  - **english**: There was an error creating your assistant.
  - **translated**: 创建助手时出错。

- **com_ui_field_required**:
  - **english**: This field is required
  - **translated**: 此字段为必填项

- **com_ui_download_error**:
  - **english**: Error downloading file. The file may have been deleted.
  - **translated**: 下载文件时出错，该文件可能已被删除。

- **com_ui_attach_error_type**:
  - **english**: Unsupported file type for endpoint:
  - **translated**: 渠道不支持的文件类型:

- **com_ui_attach_error_size**:
  - **english**: File size limit exceeded for endpoint:
  - **translated**: 超出渠道规定的文件大小:

- **com_ui_attach_error**:
  - **english**: Cannot attach file. Create or select a conversation, or try refreshing the page.
  - **translated**: 无法附加文件，请创建或选择一个对话，或尝试刷新页面。

- **com_ui_examples**:
  - **english**: Examples
  - **translated**: 示例

- **com_ui_new_chat**:
  - **english**: New chat
  - **translated**: 创建新对话

- **com_ui_happy_birthday**:
  - **english**: It's my 1st birthday!
  - **translated**: 这是我的第一个生日！

- **com_ui_example_quantum_computing**:
  - **english**: Explain quantum computing in simple terms
  - **translated**: 如何给7岁小孩讲解量子计算？

- **com_ui_example_10_year_old_b_day**:
  - **english**: Got any creative ideas for a 10 year old's birthday?
  - **translated**: 如何举办生日宴才能耳目一新？

- **com_ui_example_http_in_js**:
  - **english**: How do I make an HTTP request in Javascript?
  - **translated**: 如何在Python中实现HTTP请求？

- **com_ui_capabilities**:
  - **english**: Capabilities
  - **translated**: 功能

- **com_ui_capability_remember**:
  - **english**: Remembers what user said earlier in the conversation
  - **translated**: 记忆历史对话

- **com_ui_capability_correction**:
  - **english**: Allows user to provide follow-up corrections
  - **translated**: 允许更正内容

- **com_ui_capability_decline_requests**:
  - **english**: Trained to decline inappropriate requests
  - **translated**: 限制不当信息

- **com_ui_limitations**:
  - **english**: Limitations
  - **translated**: 局限性

- **com_ui_limitation_incorrect_info**:
  - **english**: May occasionally generate incorrect information
  - **translated**: 可能会不时出现错误信息

- **com_ui_limitation_harmful_biased**:
  - **english**: May occasionally produce harmful instructions or biased content
  - **translated**: 可能会提供有害指示或者偏见

- **com_ui_limitation_limited_2021**:
  - **english**: Limited knowledge of world and events after 2021
  - **translated**: 基于2021年以前信息训练

- **com_ui_experimental**:
  - **english**: Experimental Features
  - **translated**: 实验性

- **com_ui_ascending**:
  - **english**: Asc
  - **translated**: 升序

- **com_ui_descending**:
  - **english**: Desc
  - **translated**: 降序

- **com_ui_show_all**:
  - **english**: Show All
  - **translated**: 展开全部

- **com_ui_name**:
  - **english**: Name
  - **translated**: 名称

- **com_ui_date**:
  - **english**: Date
  - **translated**: 日期

- **com_ui_storage**:
  - **english**: Storage
  - **translated**: 存储

- **com_ui_context**:
  - **english**: Context
  - **translated**: 上下文

- **com_ui_size**:
  - **english**: Size
  - **translated**: 大小

- **com_ui_host**:
  - **english**: Host
  - **translated**: 主机

- **com_ui_update**:
  - **english**: Update
  - **translated**: 更新

- **com_ui_authentication**:
  - **english**: Authentication
  - **translated**: 认证

- **com_ui_instructions**:
  - **english**: Instructions
  - **translated**: 指令

- **com_ui_description**:
  - **english**: Description
  - **translated**: 描述

- **com_ui_error**:
  - **english**: Error
  - **translated**: 错误

- **com_ui_select**:
  - **english**: Select
  - **translated**: 选择

- **com_ui_input**:
  - **english**: Input
  - **translated**: 输入

- **com_ui_close**:
  - **english**: Close
  - **translated**: 关闭

- **com_ui_model**:
  - **english**: Model
  - **translated**: 模型

- **com_ui_select_model**:
  - **english**: Select a model
  - **translated**: 模型选择

- **com_ui_select_search_model**:
  - **english**: Search model by name
  - **translated**: 以名称搜索模型

- **com_ui_select_search_plugin**:
  - **english**: Search plugin by name
  - **translated**: 以名称搜索插件

- **com_ui_use_prompt**:
  - **english**: Use prompt
  - **translated**: 使用提示词

- **com_ui_prev**:
  - **english**: Prev
  - **translated**: 上一页

- **com_ui_next**:
  - **english**: Next
  - **translated**: 下一页

- **com_ui_stop**:
  - **english**: Stop
  - **translated**: 停止

- **com_ui_upload_files**:
  - **english**: Upload files
  - **translated**: 上传文件

- **com_ui_prompt_templates**:
  - **english**: Prompt Templates
  - **translated**: 对话模板

- **com_ui_hide_prompt_templates**:
  - **english**: Hide Prompt Templates
  - **translated**: 隐藏对话模板

- **com_ui_showing**:
  - **english**: Showing
  - **translated**: 显示

- **com_ui_of**:
  - **english**: of
  - **translated**: /

- **com_ui_entries**:
  - **english**: Entries
  - **translated**: 项

- **com_ui_pay_per_call**:
  - **english**: All AI conversations in one place. Pay per call and not per month
  - **translated**: 所有对话都将集中在一处。按会话次数计费，而不是按月付费

- **com_ui_new_footer**:
  - **english**: All AI conversations in one place.
  - **translated**: 所有对话都将集中在一处。

- **com_ui_enter**:
  - **english**: Enter
  - **translated**: 进入

- **com_ui_submit**:
  - **english**: Submit
  - **translated**: 提交

- **com_ui_upload_success**:
  - **english**: Successfully uploaded file
  - **translated**: 上传文件成功

- **com_ui_upload_error**:
  - **english**: There was an error uploading your file
  - **translated**: 上传文件错误

- **com_ui_upload_invalid**:
  - **english**: Invalid file for upload. Must be an image not exceeding 2 MB
  - **translated**: 无效的上传文件，请上传不超过2M大小的图片

- **com_ui_cancel**:
  - **english**: Cancel
  - **translated**: 取消

- **com_ui_save**:
  - **english**: Save
  - **translated**: 保存

- **com_ui_save_submit**:
  - **english**: Save & Submit
  - **translated**: 保存并提交

- **com_user_message**:
  - **english**: You
  - **translated**: You

- **com_ui_copy_to_clipboard**:
  - **english**: Copy to clipboard
  - **translated**: 复制到剪贴板

- **com_ui_copied_to_clipboard**:
  - **english**: Copied to clipboard
  - **translated**: 已复制到剪贴板

- **com_ui_regenerate**:
  - **english**: Regenerate
  - **translated**: 重新生成

- **com_ui_continue**:
  - **english**: Continue
  - **translated**: 继续

- **com_ui_edit**:
  - **english**: Edit
  - **translated**: 编辑

- **com_ui_success**:
  - **english**: Success
  - **translated**: 成功

- **com_ui_all**:
  - **english**: all
  - **translated**: 所有

- **com_ui_clear**:
  - **english**: Clear
  - **translated**: 清除

- **com_ui_revoke**:
  - **english**: Revoke
  - **translated**: 撤销

- **com_ui_revoke_info**:
  - **english**: Revoke all user provided credentials
  - **translated**: 撤销所有用户提供的凭据

- **com_ui_import_conversation**:
  - **english**: Import
  - **translated**: 导入

- **com_ui_import_conversation_info**:
  - **english**: Import conversations from a JSON file
  - **translated**: 从JSON文件导入对话

- **com_ui_import_conversation_success**:
  - **english**: Conversations imported successfully
  - **translated**: 对话导入成功

- **com_ui_import_conversation_error**:
  - **english**: There was an error importing your conversations
  - **translated**: 导入对话时发生错误

- **com_ui_confirm_action**:
  - **english**: Confirm Action
  - **translated**: 确认执行

- **com_ui_chats**:
  - **english**: chats
  - **translated**: 聊天

- **com_ui_avatar**:
  - **english**: Avatar
  - **translated**: 头像

- **com_ui_unknown**:
  - **english**: Unknown
  - **translated**: 未知

- **com_ui_result**:
  - **english**: Result
  - **translated**: 结果

- **com_ui_image_gen**:
  - **english**: Image Gen
  - **translated**: 图片生成

- **com_ui_assistant**:
  - **english**: Assistant
  - **translated**: 助手

- **com_ui_assistants**:
  - **english**: Assistants
  - **translated**: 助手

- **com_ui_attachment**:
  - **english**: Attachment
  - **translated**: 附件

- **com_ui_assistants_output**:
  - **english**: Assistants Output
  - **translated**: 助手输出

- **com_ui_delete**:
  - **english**: Delete
  - **translated**: 删除

- **com_ui_create**:
  - **english**: Create
  - **translated**: 创建

- **com_ui_delete_conversation**:
  - **english**: Delete chat?
  - **translated**: 删除对话？

- **com_ui_delete_confirm**:
  - **english**: This will delete
  - **translated**: 这将删除

- **com_ui_delete_assistant_confirm**:
  - **english**: Are you sure you want to delete this Assistant? This cannot be undone.
  - **translated**: 确定要删除此助手吗？该操作无法撤销。

- **com_ui_rename**:
  - **english**: Rename
  - **translated**: 重命名

- **com_ui_archive**:
  - **english**: Archive
  - **translated**: 归档

- **com_ui_archive_error**:
  - **english**: Failed to archive conversation
  - **translated**: 归档对话失败

- **com_ui_unarchive**:
  - **english**: Unarchive
  - **translated**: 取消归档

- **com_ui_unarchive_error**:
  - **english**: Failed to unarchive conversation
  - **translated**: 取消归档对话失败

- **com_ui_more_options**:
  - **english**: More
  - **translated**: 更多

- **com_ui_preview**:
  - **english**: Preview
  - **translated**: 预览

- **com_ui_upload**:
  - **english**: Upload
  - **translated**: 上传

- **com_ui_connect**:
  - **english**: Connect
  - **translated**: 连接

- **com_ui_upload_delay**:
  - **english**: Uploading "{0}" is taking more time than anticipated. Please wait while the file finishes indexing for retrieval.
  - **translated**: 上传 "{0}" 时比预期花了更长时间。 文件正在进行检索索引，请稍候。

- **com_ui_privacy_policy**:
  - **english**: Privacy policy
  - **translated**: 隐私政策

- **com_ui_terms_of_service**:
  - **english**: Terms of service
  - **translated**: 服务政策

- **com_auth_error_login**:
  - **english**: Unable to login with the information provided. Please check your credentials and try again.
  - **translated**: 无法登录，请确认提供的账户密码正确，并重新尝试。

- **com_auth_error_login_rl**:
  - **english**: Too many login attempts in a short amount of time. Please try again later.
  - **translated**: 尝试登录次数过多，请稍后再试。

- **com_auth_error_login_ban**:
  - **english**: Your account has been temporarily banned due to violations of our service.
  - **translated**: 根据我们的服务规则，您的帐号被暂时禁用。

- **com_auth_error_login_server**:
  - **english**: There was an internal server error. Please wait a few moments and try again.
  - **translated**: 内部服务器错误，请稍后再试。

- **com_auth_no_account**:
  - **english**: Don't have an account?
  - **translated**: 新用户注册

- **com_auth_sign_up**:
  - **english**: Sign up
  - **translated**: 注册

- **com_auth_sign_in**:
  - **english**: Sign in
  - **translated**: 登录

- **com_auth_google_login**:
  - **english**: Continue with Google
  - **translated**: 使用 Google 登录

- **com_auth_facebook_login**:
  - **english**: Continue with Facebook
  - **translated**: 使用 Facebook 登录

- **com_auth_github_login**:
  - **english**: Continue with Github
  - **translated**: 使用 GitHub 登录

- **com_auth_discord_login**:
  - **english**: Continue with Discord
  - **translated**: 使用 Discord 登录

- **com_auth_email**:
  - **english**: Email
  - **translated**: 电子邮箱

- **com_auth_email_required**:
  - **english**: Email is required
  - **translated**: 邮箱为必填项

- **com_auth_email_min_length**:
  - **english**: Email must be at least 6 characters
  - **translated**: 邮箱地址至少6个字符

- **com_auth_email_max_length**:
  - **english**: Email should not be longer than 120 characters
  - **translated**: 邮箱地址最多120个字符

- **com_auth_email_pattern**:
  - **english**: You must enter a valid email address
  - **translated**: 请输入正确的电子邮箱格式

- **com_auth_email_address**:
  - **english**: Email address
  - **translated**: 电子邮箱地址

- **com_auth_password**:
  - **english**: Password
  - **translated**: 密码

- **com_auth_password_required**:
  - **english**: Password is required
  - **translated**: 密码为必填项

- **com_auth_password_min_length**:
  - **english**: Password must be at least 8 characters
  - **translated**: 密码至少8个字符

- **com_auth_password_max_length**:
  - **english**: Password must be less than 128 characters
  - **translated**: 密码最多128个字符

- **com_auth_password_forgot**:
  - **english**: Forgot Password?
  - **translated**: 忘记密码?

- **com_auth_password_confirm**:
  - **english**: Confirm password
  - **translated**: 确认密码

- **com_auth_password_not_match**:
  - **english**: Passwords do not match
  - **translated**: 密码不一致

- **com_auth_continue**:
  - **english**: Continue
  - **translated**: 继续

- **com_auth_create_account**:
  - **english**: Create your account
  - **translated**: 创建账号

- **com_auth_error_create**:
  - **english**: There was an error attempting to register your account. Please try again.
  - **translated**: 注册账户过程中出现错误，请重试。

- **com_auth_full_name**:
  - **english**: Full name
  - **translated**: 姓名

- **com_auth_name_required**:
  - **english**: Name is required
  - **translated**: 姓名为必填项

- **com_auth_name_min_length**:
  - **english**: Name must be at least 3 characters
  - **translated**: 姓名至少3个字符

- **com_auth_name_max_length**:
  - **english**: Name must be less than 80 characters
  - **translated**: 姓名最多80个字符

- **com_auth_username**:
  - **english**: Username (optional)
  - **translated**: 用户名（可选）

- **com_auth_username_required**:
  - **english**: Username is required
  - **translated**: 用户名为必填项

- **com_auth_username_min_length**:
  - **english**: Username must be at least 2 characters
  - **translated**: 用户名至少3个字符

- **com_auth_username_max_length**:
  - **english**: Username must be less than 20 characters
  - **translated**: 用户名最多20个字符

- **com_auth_already_have_account**:
  - **english**: Already have an account?
  - **translated**: 已有账号

- **com_auth_login**:
  - **english**: Login
  - **translated**: 登录

- **com_auth_reset_password**:
  - **english**: Reset your password
  - **translated**: 重置密码

- **com_auth_click**:
  - **english**: Click
  - **translated**: 点击

- **com_auth_here**:
  - **english**: HERE
  - **translated**: 这里

- **com_auth_to_reset_your_password**:
  - **english**: to reset your password.
  - **translated**: 重置密码。

- **com_auth_reset_password_link_sent**:
  - **english**: Email Sent
  - **translated**: 重置密码链接已发送至邮箱

- **com_auth_reset_password_email_sent**:
  - **english**: An email has been sent to you with further instructions to reset your password.
  - **translated**: 重置密码邮件已发送至邮箱

- **com_auth_error_reset_password**:
  - **english**: There was a problem resetting your password. There was no user found with the email address provided. Please try again.
  - **translated**: 重置密码出现错误，未找到对应的邮箱地址，请重新输入。

- **com_auth_reset_password_success**:
  - **english**: Password Reset Success
  - **translated**: 密码重置成功

- **com_auth_login_with_new_password**:
  - **english**: You may now login with your new password.
  - **translated**: 现在你可以使用你的新密码登录。

- **com_auth_error_invalid_reset_token**:
  - **english**: This password reset token is no longer valid.
  - **translated**: 重置密码的密钥已失效。

- **com_auth_click_here**:
  - **english**: Click here
  - **translated**: 点击这里

- **com_auth_to_try_again**:
  - **english**: to try again.
  - **translated**: 再试一次。

- **com_auth_submit_registration**:
  - **english**: Submit registration
  - **translated**: 注册提交

- **com_auth_welcome_back**:
  - **english**: Welcome back
  - **translated**: 欢迎

- **com_auth_back_to_login**:
  - **english**: Back to Login
  - **translated**: 返回登录

- **com_endpoint_open_menu**:
  - **english**: Open Menu
  - **translated**: 打开菜单

- **com_endpoint_bing_enable_sydney**:
  - **english**: Enable Sydney
  - **translated**: 启用 Sydney

- **com_endpoint_bing_to_enable_sydney**:
  - **english**: To enable Sydney
  - **translated**: 启用 Sydney

- **com_endpoint_bing_jailbreak**:
  - **english**: Jailbreak
  - **translated**: 越狱

- **com_endpoint_bing_context_placeholder**:
  - **english**: Bing can use up to 7k tokens for 'context', which it can reference for the conversation. The specific limit is not known but may run into errors exceeding 7k tokens
  - **translated**: 必应可以使用多达7000个词元作为“上下文（context）”，参照这些内容进行对话。其具体限制并不清楚，但可能会在超过7000个词元时出现错误

- **com_endpoint_bing_system_message_placeholder**:
  - **english**: WARNING: Misuse of this feature can get you BANNED from using Bing! Click on 'System Message' for full instructions and the default message if omitted, which is the 'Sydney' preset that is considered safe.
  - **translated**: 警告：滥用此功能可能导致你被禁止使用必应！点击“系统消息”查看完整的使用指南，如果你忽略了默认消息，那么将会使用被视为安全的“Sydney”预设。

- **com_endpoint_system_message**:
  - **english**: System Message
  - **translated**: 系统消息

- **com_endpoint_message**:
  - **english**: Message
  - **translated**: 发送消息给

- **com_endpoint_message_not_appendable**:
  - **english**: Edit your message or Regenerate.
  - **translated**: 编辑您的消息内容或重新生成

- **com_endpoint_default_blank**:
  - **english**: default: blank
  - **translated**: 初始值: 空白

- **com_endpoint_default_false**:
  - **english**: default: false
  - **translated**: 初始值: 否

- **com_endpoint_default_creative**:
  - **english**: default: creative
  - **translated**: 初始值: 创意

- **com_endpoint_default_empty**:
  - **english**: default: empty
  - **translated**: 初始值: 空

- **com_endpoint_default_with_num**:
  - **english**: default: {0}
  - **translated**: 初始值: {0}

- **com_endpoint_context**:
  - **english**: Context
  - **translated**: 上下文

- **com_endpoint_tone_style**:
  - **english**: Tone Style
  - **translated**: 语气

- **com_endpoint_token_count**:
  - **english**: Token count
  - **translated**: 词元数

- **com_endpoint_output**:
  - **english**: Output
  - **translated**: 输出

- **com_endpoint_google_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: 值越高表示输出越随机，值越低表示输出越确定。建议不要同时改变此值和Top-p。

- **com_endpoint_google_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p（核采样）会改变模型选择输出词的方式。从概率最大的K（参见topK参数）向最小的K选择，直到它们的概率之和等于top-p值

- **com_endpoint_google_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k 会改变模型选择输出词的方式。top-k为1意味着所选词是模型词汇中概率最大的（也称为贪心解码），而top-k为3意味着下一个词是从3个概率最大的词中选出的（使用随机性）。

- **com_endpoint_google_maxoutputtokens**:
  - **english**:  	Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**:  	响应生成中可以使用的最大词元数。指定较低的值会得到更短的响应，而指定较高的值则会得到更长的响应。

- **com_endpoint_google_custom_name_placeholder**:
  - **english**: Set a custom name for Google
  - **translated**: 为Google设置一个名称

- **com_endpoint_prompt_prefix_placeholder**:
  - **english**: Set custom instructions or context. Ignored if empty.
  - **translated**: 自定义提示词和上下文，默认为空

- **com_endpoint_instructions_assistants_placeholder**:
  - **english**: Overrides the instructions of the assistant. This is useful for modifying the behavior on a per-run basis.
  - **translated**: 覆盖助手的指令。这对于需要逐次修改行为非常有用。

- **com_endpoint_prompt_prefix_assistants_placeholder**:
  - **english**: Set additional instructions or context on top of the Assistant's main instructions. Ignored if empty.
  - **translated**: 在助手的主要指令之上设置额外的指令或上下文。如果为空，则忽略。

- **com_endpoint_custom_name**:
  - **english**: Custom Name
  - **translated**: 自定义名称

- **com_endpoint_prompt_prefix**:
  - **english**: Custom Instructions
  - **translated**: 自定义指令

- **com_endpoint_prompt_prefix_assistants**:
  - **english**: Additional Instructions
  - **translated**: 额外命令

- **com_endpoint_instructions_assistants**:
  - **english**: Override Instructions
  - **translated**: 覆写命令

- **com_endpoint_temperature**:
  - **english**: Temperature
  - **translated**: 温度

- **com_endpoint_default**:
  - **english**: default
  - **translated**: 初始值

- **com_endpoint_top_p**:
  - **english**: Top P
  - **translated**: Top P

- **com_endpoint_top_k**:
  - **english**: Top K
  - **translated**: Top K

- **com_endpoint_max_output_tokens**:
  - **english**: Max Output Tokens
  - **translated**: 最大输出词元数

- **com_endpoint_openai_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: 值越高表示输出越随机，值越低表示输出越确定。建议不要同时改变此值和Top P。

- **com_endpoint_openai_max**:
  - **english**: The max tokens to generate. The total length of input tokens and generated tokens is limited by the model's context length.
  - **translated**: 最大生成词元数。输入词元长度由模型的上下文长度决定。

- **com_endpoint_openai_topp**:
  - **english**: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We recommend altering this or temperature but not both.
  - **translated**: 相较于随机性的另一个取样方法，称为核采样，模型选取输出词元中大于P值（概率密度在整个概率分布中的比例）的结果。比如 top_p=0.1 表示只有概率占比为前10%的词元才会被考虑作为输出。建议不要同时改变此值和随机性。

- **com_endpoint_openai_freq**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
  - **translated**: 值介于-2.0到2.0之间。正值将惩罚当前已频繁使用的词元，从而降低重复用词的可能性。

- **com_endpoint_openai_pres**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
  - **translated**: 值介于-2.0到2.0之间。正值将惩罚当前已经使用的词元，从而增加讨论新话题的可能性。

- **com_endpoint_openai_resend**:
  - **english**: Resend all previously attached images. Note: this can significantly increase token cost and you may experience errors with many image attachments.
  - **translated**: 重新发送所有先前附加的图像。(注意：这会显着增加Token成本，并且可能会遇到很多关于图像附件的错误。)

- **com_endpoint_openai_resend_files**:
  - **english**: Resend all previously attached files. Note: this will increase token cost and you may experience errors with many attachments.
  - **translated**: 重新发送所有先前附加的文件。(注意：这会显着增加Token成本，并且可能会遇到很多关于图像附件的错误。)

- **com_endpoint_openai_detail**:
  - **english**: The resolution for Vision requests. "Low" is cheaper and faster, "High" is more detailed and expensive, and "Auto" will automatically choose between the two based on the image resolution.
  - **translated**: 发送给Vision的图像分辨率。 “Low”更便宜且更快，“High”更详细但更昂贵，“Auto”将基于图像分辨率自动在两者之间进行选择。

- **com_endpoint_openai_custom_name_placeholder**:
  - **english**: Set a custom name for the AI
  - **translated**: 为ChatGPT设置一个名称

- **com_endpoint_openai_prompt_prefix_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: 在消息开头添加系统级提示词，默认为空

- **com_endpoint_anthropic_temp**:
  - **english**: Ranges from 0 to 1. Use temp closer to 0 for analytical / multiple choice, and closer to 1 for creative and generative tasks. We recommend altering this or Top P but not both.
  - **translated**: 值介于0到1之间。 对于分析性/选择性任务，值应更接近0；对于创造性和生成性任务，值应更接近1。我们建议更改该参数或Top-p，但不要同时更改这两个参数。

- **com_endpoint_anthropic_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p（核采样）会改变模型选择输出词元的方式。从概率最大的K（参见topK参数）向最小的K选择，直到它们的概率之和等于top-p值。

- **com_endpoint_anthropic_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k 会改变模型选择输出词元的方式。top-k为1意味着所选词是模型词汇中概率最大的（也称为贪心解码），而top-k为3意味着下一个词是从3个概率最大的词中选出的（使用随机性）。

- **com_endpoint_anthropic_maxoutputtokens**:
  - **english**: Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: 响应中可生成的最大词元数。指定较低的值会得到更短的响应，而指定较高的值则会得到更长的响应。

- **com_endpoint_anthropic_custom_name_placeholder**:
  - **english**: Set a custom name for Anthropic
  - **translated**: 为Anthropic设置一个名称

- **com_endpoint_frequency_penalty**:
  - **english**: Frequency Penalty
  - **translated**: 频率惩罚度

- **com_endpoint_presence_penalty**:
  - **english**: Presence Penalty
  - **translated**: 话题新鲜度

- **com_endpoint_plug_use_functions**:
  - **english**: Use Functions
  - **translated**: 使用函数

- **com_endpoint_plug_resend_files**:
  - **english**: Resend Files
  - **translated**: 重发文件

- **com_endpoint_plug_resend_images**:
  - **english**: Resend Images
  - **translated**: 重发图片

- **com_endpoint_plug_image_detail**:
  - **english**: Image Detail
  - **translated**: 图片细节

- **com_endpoint_plug_skip_completion**:
  - **english**: Skip Completion
  - **translated**: 跳过补全

- **com_endpoint_disabled_with_tools**:
  - **english**: disabled with tools
  - **translated**: 系统禁用

- **com_endpoint_disabled_with_tools_placeholder**:
  - **english**: Disabled with Tools Selected
  - **translated**: 系统禁用

- **com_endpoint_plug_set_custom_instructions_for_gpt_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: 在消息开头添加系统级提示词，默认为空

- **com_endpoint_import**:
  - **english**: Import
  - **translated**: 导入

- **com_endpoint_set_custom_name**:
  - **english**: Set a custom name, in case you can find this preset
  - **translated**: 设置一个自定义名，以便您检索此预设

- **com_endpoint_preset_delete_confirm**:
  - **english**: Are you sure you want to delete this preset?
  - **translated**: 确定删除此预设？

- **com_endpoint_preset_clear_all_confirm**:
  - **english**: Are you sure you want to delete all of your presets?
  - **translated**: 确定删除所有预设？

- **com_endpoint_preset_import**:
  - **english**: Preset Imported!
  - **translated**: 成功导入预设！

- **com_endpoint_preset_import_error**:
  - **english**: There was an error importing your preset. Please try again.
  - **translated**: 导入预设时发生错误，请重试。

- **com_endpoint_preset_save_error**:
  - **english**: There was an error saving your preset. Please try again.
  - **translated**: 保存预设时发生错误，请重试。

- **com_endpoint_preset_delete_error**:
  - **english**: There was an error deleting your preset. Please try again.
  - **translated**: 删除预设时发生错误，请重试。

- **com_endpoint_preset_default_removed**:
  - **english**: is no longer the default preset.
  - **translated**: 不再是默认预设。

- **com_endpoint_preset_default_item**:
  - **english**: Default:
  - **translated**: 默认：

- **com_endpoint_preset_default_none**:
  - **english**: No default preset active.
  - **translated**: 无默认预设可用。

- **com_endpoint_preset_title**:
  - **english**: Preset
  - **translated**: 预设

- **com_endpoint_preset_saved**:
  - **english**: Saved!
  - **translated**: 保存成功！

- **com_endpoint_preset_default**:
  - **english**: is now the default preset.
  - **translated**: 现在是默认预设。

- **com_endpoint_preset**:
  - **english**: preset
  - **translated**: 预设

- **com_endpoint_presets**:
  - **english**: presets
  - **translated**: 预设

- **com_endpoint_preset_selected**:
  - **english**: Preset Active!
  - **translated**: 预设可用！

- **com_endpoint_preset_selected_title**:
  - **english**: Active!
  - **translated**: 可用！

- **com_endpoint_preset_name**:
  - **english**: Preset Name
  - **translated**: 预设名

- **com_endpoint_new_topic**:
  - **english**: New Topic
  - **translated**: 新主题

- **com_endpoint**:
  - **english**: Endpoint
  - **translated**: 渠道

- **com_endpoint_hide**:
  - **english**: Hide
  - **translated**: 隐藏

- **com_endpoint_show**:
  - **english**: Show
  - **translated**: 显示

- **com_endpoint_examples**:
  - **english**:  Presets
  - **translated**:  预设

- **com_endpoint_completion**:
  - **english**: Completion
  - **translated**: 补全

- **com_endpoint_agent**:
  - **english**: Agent
  - **translated**: 代理

- **com_endpoint_show_what_settings**:
  - **english**: Show {0} Settings
  - **translated**: 显示{0}设置

- **com_endpoint_export**:
  - **english**: Export
  - **translated**: 导出

- **com_endpoint_assistant**:
  - **english**: Assistant
  - **translated**: 助手

- **com_endpoint_use_active_assistant**:
  - **english**: Use Active Assistant
  - **translated**: 使用激活的助手

- **com_endpoint_assistant_model**:
  - **english**: Assistant Model
  - **translated**: 助手模型

- **com_endpoint_save_as_preset**:
  - **english**: Save As Preset
  - **translated**: 保存为预设

- **com_endpoint_presets_clear_warning**:
  - **english**: Are you sure you want to clear all presets? This is irreversible.
  - **translated**: 确定要清除所有预设吗？此操作不可逆。

- **com_endpoint_not_implemented**:
  - **english**: Not implemented
  - **translated**: 未实现功能

- **com_endpoint_no_presets**:
  - **english**: No presets yet, use the settings button to create one
  - **translated**: 暂无预设，使用设置按钮创建一个。

- **com_endpoint_not_available**:
  - **english**: No endpoint available
  - **translated**: 无可用渠道

- **com_endpoint_view_options**:
  - **english**: View Options
  - **translated**: 查看选项

- **com_endpoint_save_convo_as_preset**:
  - **english**: Save Conversation as Preset
  - **translated**: 保存对话为预设

- **com_endpoint_my_preset**:
  - **english**: My Preset
  - **translated**: 我的预设

- **com_endpoint_agent_model**:
  - **english**: Agent Model (Recommended: GPT-3.5)
  - **translated**: 代理模型 (推荐: GPT-3.5)

- **com_endpoint_completion_model**:
  - **english**: Completion Model (Recommended: GPT-4)
  - **translated**: 补全模型 (推荐: GPT-4)

- **com_endpoint_func_hover**:
  - **english**: Enable use of Plugins as OpenAI Functions
  - **translated**: 将插件作为OpenAI函数使用

- **com_endpoint_skip_hover**:
  - **english**: Enable skipping the completion step, which reviews the final answer and generated steps
  - **translated**: 跳过补全步骤， 检查最终答案和生成步骤

- **com_endpoint_config_key**:
  - **english**: Set API Key
  - **translated**: 设置API Key

- **com_endpoint_assistant_placeholder**:
  - **english**: Please select an Assistant from the right-hand Side Panel
  - **translated**: 请从右侧面板中选择助手

- **com_endpoint_config_placeholder**:
  - **english**: Set your Key in the Header menu to chat.
  - **translated**: 在顶部菜单设置API KEY

- **com_endpoint_config_key_for**:
  - **english**: Set API Key for
  - **translated**: 设置API Key：

- **com_endpoint_config_key_name**:
  - **english**: Key
  - **translated**: 密钥

- **com_endpoint_config_value**:
  - **english**: Enter value for
  - **translated**: 输入值：

- **com_endpoint_config_key_name_placeholder**:
  - **english**: Set API key first
  - **translated**: 请先设置API key

- **com_endpoint_config_key_encryption**:
  - **english**: Your key will be encrypted and deleted at
  - **translated**: 您的密钥将被加密并删除于：

- **com_endpoint_config_key_expiry**:
  - **english**: the expiry time
  - **translated**: 过期时间

- **com_endpoint_config_click_here**:
  - **english**: Click Here
  - **translated**: 点击此处

- **com_endpoint_config_google_service_key**:
  - **english**: Google Service Account Key
  - **translated**: Google服务账号密钥

- **com_endpoint_config_google_cloud_platform**:
  - **english**: (from Google Cloud Platform)
  - **translated**: （从谷歌云平台）

- **com_endpoint_config_google_api_key**:
  - **english**: Google API Key
  - **translated**: Google API密钥

- **com_endpoint_config_google_gemini_api**:
  - **english**: (Gemini API)
  - **translated**: (Gemini API)

- **com_endpoint_config_google_api_info**:
  - **english**: To get your Generative Language API key (for Gemini),
  - **translated**: 获取您的生成式语言API密钥(Gemini),

- **com_endpoint_config_key_import_json_key**:
  - **english**: Import Service Account JSON Key.
  - **translated**: 导入服务账号JSON密钥

- **com_endpoint_config_key_import_json_key_success**:
  - **english**: Successfully Imported Service Account JSON Key
  - **translated**: 成功导入服务账号JSON密钥

- **com_endpoint_config_key_import_json_key_invalid**:
  - **english**: Invalid Service Account JSON Key, Did you import the correct file?
  - **translated**: 无效的服务账号JSON密钥，您是否导入正确的文件？

- **com_endpoint_config_key_get_edge_key**:
  - **english**: To get your Access token for Bing, login to
  - **translated**: 为获得Bing访问凭证（Access token），请登录：

- **com_endpoint_config_key_get_edge_key_dev_tool**:
  - **english**: Use dev tools or an extension while logged into the site to copy the content of the _U cookie. If this fails, follow these
  - **translated**: 登录网站后，使用开发工具或扩展程序复制 _U cookie 的内容。如果失败，请按照以下步骤操作：

- **com_endpoint_config_key_edge_instructions**:
  - **english**: instructions
  - **translated**: 说明

- **com_endpoint_config_key_edge_full_key_string**:
  - **english**: to provide the full cookie strings.
  - **translated**: 提供完整的cookie字符串。

- **com_endpoint_config_key_chatgpt**:
  - **english**: To get your Access token For ChatGPT 'Free Version', login to
  - **translated**: 为获得ChatGPT的访问凭证（Access token）, 请登录：

- **com_endpoint_config_key_chatgpt_then_visit**:
  - **english**: then visit
  - **translated**: 然后访问

- **com_endpoint_config_key_chatgpt_copy_token**:
  - **english**: Copy access token.
  - **translated**: 复制access token。

- **com_endpoint_config_key_google_need_to**:
  - **english**: You need to
  - **translated**: 您需要

- **com_endpoint_config_key_google_vertex_ai**:
  - **english**: Enable Vertex AI
  - **translated**: 在Google Cloud上启用Vertex AI

- **com_endpoint_config_key_google_vertex_api**:
  - **english**: API on Google Cloud, then
  - **translated**: API，然后

- **com_endpoint_config_key_google_service_account**:
  - **english**: Create a Service Account
  - **translated**: 创建一个服务账号

- **com_endpoint_config_key_google_vertex_api_role**:
  - **english**: Make sure to click 'Create and Continue' to give at least the 'Vertex AI User' role. Lastly, create a JSON key to import here.
  - **translated**: 确保单击“创建并继续”以至少授予“Vertex AI 用户”角色。最后，创建一个要在此处导入的JSON密钥。

- **com_nav_welcome_assistant**:
  - **english**: Please Select an Assistant
  - **translated**: 请选择助手

- **com_nav_welcome_message**:
  - **english**: How can I help you today?
  - **translated**: 我今天能帮你做什么？

- **com_nav_auto_scroll**:
  - **english**: Auto-scroll to Newest on Open
  - **translated**: 打开时自动滚动到最新内容

- **com_nav_hide_panel**:
  - **english**: Hide Right-most Side Panel
  - **translated**: 隐藏最右侧面板

- **com_nav_modular_chat**:
  - **english**: Enable switching Endpoints mid-conversation
  - **translated**: 启用对话中切换渠道

- **com_nav_latex_parsing**:
  - **english**: Parsing LaTeX in messages (may affect performance)
  - **translated**: 解析消息中的 LaTeX（可能会影响性能）

- **com_nav_profile_picture**:
  - **english**: Profile Picture
  - **translated**: 个人资料头像

- **com_nav_change_picture**:
  - **english**: Change picture
  - **translated**: 修改头像

- **com_nav_plugin_store**:
  - **english**: Plugin store
  - **translated**: 插件商店

- **com_nav_plugin_install**:
  - **english**: Install
  - **translated**: 安装

- **com_nav_plugin_uninstall**:
  - **english**: Uninstall
  - **translated**: 卸载

- **com_ui_add**:
  - **english**: Add
  - **translated**: 添加

- **com_nav_tool_remove**:
  - **english**: Remove
  - **translated**: 移除

- **com_nav_tool_dialog**:
  - **english**: Assistant Tools
  - **translated**: 助手工具

- **com_nav_tool_dialog_description**:
  - **english**: Assistant must be saved to persist tool selections.
  - **translated**: 必须保存助手才能保留工具选择。

- **com_show_agent_settings**:
  - **english**: Show Agent Settings
  - **translated**: 显示Agent设置

- **com_show_completion_settings**:
  - **english**: Show Completion Settings
  - **translated**: 显示Completion设置

- **com_hide_examples**:
  - **english**: Hide Examples
  - **translated**: 隐藏样例

- **com_show_examples**:
  - **english**: Show Examples
  - **translated**: 显示样例

- **com_nav_plugin_search**:
  - **english**: Search plugins
  - **translated**: 搜索插件

- **com_nav_tool_search**:
  - **english**: Search tools
  - **translated**: 搜索工具

- **com_nav_plugin_auth_error**:
  - **english**: There was an error attempting to authenticate this plugin. Please try again.
  - **translated**: 尝试验证此插件时出错。请重试。

- **com_nav_export_filename**:
  - **english**: Filename
  - **translated**: 文件名

- **com_nav_export_filename_placeholder**:
  - **english**: Set the filename
  - **translated**: 设置文件名

- **com_nav_export_type**:
  - **english**: Type
  - **translated**: 类型

- **com_nav_export_include_endpoint_options**:
  - **english**: Include endpoint options
  - **translated**: 包含配置信息

- **com_nav_enabled**:
  - **english**: Enabled
  - **translated**: 启用

- **com_nav_not_supported**:
  - **english**: Not Supported
  - **translated**: 未支持

- **com_nav_export_all_message_branches**:
  - **english**: Export all message branches
  - **translated**: 导出所有对话

- **com_nav_export_recursive_or_sequential**:
  - **english**: Recursive or sequential?
  - **translated**: 递归或顺序？

- **com_nav_export_recursive**:
  - **english**: Recursive
  - **translated**: 递归

- **com_nav_export_conversation**:
  - **english**: Export conversation
  - **translated**: 导出对话

- **com_nav_my_files**:
  - **english**: My Files
  - **translated**: 我的文件

- **com_nav_theme**:
  - **english**: Theme
  - **translated**: 主题

- **com_nav_theme_system**:
  - **english**: System
  - **translated**: 跟随系统设置

- **com_nav_theme_dark**:
  - **english**: Dark
  - **translated**: 暗色主题

- **com_nav_theme_light**:
  - **english**: Light
  - **translated**: 亮色主题

- **com_nav_user_name_display**:
  - **english**: Display username in messages
  - **translated**: 在消息中显示用户名

- **com_nav_show_code**:
  - **english**: Always show code when using code interpreter
  - **translated**: 使用代码解释器时始终显示代码

- **com_nav_clear_all_chats**:
  - **english**: Clear all chats
  - **translated**: 清空所有对话

- **com_nav_confirm_clear**:
  - **english**: Confirm Clear
  - **translated**: 确认清空

- **com_nav_close_sidebar**:
  - **english**: Close sidebar
  - **translated**: 关闭侧边栏

- **com_nav_open_sidebar**:
  - **english**: Open sidebar
  - **translated**: 打开侧边栏

- **com_nav_send_message**:
  - **english**: Send message
  - **translated**: 发送消息

- **com_nav_log_out**:
  - **english**: Log out
  - **translated**: 注销

- **com_nav_user**:
  - **english**: USER
  - **translated**: 默认用户

- **com_nav_archived_chats**:
  - **english**: Archived chats
  - **translated**: 归档的对话

- **com_nav_archived_chats_manage**:
  - **english**: Manage
  - **translated**: 管理

- **com_nav_archived_chats_empty**:
  - **english**: You have no archived conversations.
  - **translated**: 您没有归档的对话。

- **com_nav_archive_all_chats**:
  - **english**: Archive all chats
  - **translated**: 归档所有对话

- **com_nav_archive_all**:
  - **english**: Archive all
  - **translated**: 归档所有

- **com_nav_archive_name**:
  - **english**: Name
  - **translated**: 名称

- **com_nav_archive_created_at**:
  - **english**: DateCreated
  - **translated**: 创建时间

- **com_nav_clear_conversation**:
  - **english**: Clear conversations
  - **translated**: 清空对话

- **com_nav_clear_conversation_confirm_message**:
  - **english**: Are you sure you want to clear all conversations? This is irreversible.
  - **translated**: 请是否清空所有对话？该操作无法撤销

- **com_nav_help_faq**:
  - **english**: Help & FAQ
  - **translated**: 帮助

- **com_nav_settings**:
  - **english**: Settings
  - **translated**: 设置

- **com_nav_search_placeholder**:
  - **english**: Search messages
  - **translated**: 搜索对话及对话内容

- **com_nav_setting_general**:
  - **english**: General
  - **translated**: 通用

- **com_nav_setting_beta**:
  - **english**: Beta features
  - **translated**: 实验特性

- **com_nav_setting_data**:
  - **english**: Data controls
  - **translated**: 数据管理

- **com_nav_setting_account**:
  - **english**: Account
  - **translated**: 账户

Please consider the above comparisons to enhance understanding and guide improvements in translations.

Provide insights or suggestions that could help refine the translation process, focusing on cultural and contextual relevance.

Please craft a prompt that can be used to better inform future translations to this language.

Write this prompt in the translated language, with all its nuances detected, not in the English.
