# Instructions for Translation

Write a prompt that is mindful of the nuances in the language with respect to its English counterpart, which serves as the baseline for translations. Here are the comparisons between the language translations and their English counterparts:


- **com_ui_examples**:
  - **english**: Examples
  - **translated**: Exempel

- **com_ui_new_chat**:
  - **english**: New chat
  - **translated**: Ny chatt

- **com_ui_happy_birthday**:
  - **english**: It's my 1st birthday!
  - **translated**: Det är min första födelsedag!

- **com_ui_example_quantum_computing**:
  - **english**: Explain quantum computing in simple terms
  - **translated**: Förklara kvantberäkning på enkla termer

- **com_ui_example_10_year_old_b_day**:
  - **english**: Got any creative ideas for a 10 year old's birthday?
  - **translated**: Har du några kreativa idéer till ett 10-årings födelsedag?

- **com_ui_example_http_in_js**:
  - **english**: How do I make an HTTP request in Javascript?
  - **translated**: Hur gör jag en HTTP-förfrågan i Javascript?

- **com_ui_capabilities**:
  - **english**: Capabilities
  - **translated**: Möjligheter

- **com_ui_capability_remember**:
  - **english**: Remembers what user said earlier in the conversation
  - **translated**: Kommer ihåg vad användaren sa tidigare i konversationen

- **com_ui_capability_correction**:
  - **english**: Allows user to provide follow-up corrections
  - **translated**: Tillåter användaren att ge uppföljande rättelser

- **com_ui_capability_decline_requests**:
  - **english**: Trained to decline inappropriate requests
  - **translated**: Tränad för att avvisa olämpliga förfrågningar

- **com_ui_limitations**:
  - **english**: Limitations
  - **translated**: Begränsningar

- **com_ui_limitation_incorrect_info**:
  - **english**: May occasionally generate incorrect information
  - **translated**: Kan ibland generera felaktig information

- **com_ui_limitation_harmful_biased**:
  - **english**: May occasionally produce harmful instructions or biased content
  - **translated**: Kan ibland producera skadliga instruktioner eller snedvridet innehåll

- **com_ui_limitation_limited_2021**:
  - **english**: Limited knowledge of world and events after 2021
  - **translated**: Begränsad kunskap om världen och händelser efter 2021

- **com_ui_input**:
  - **english**: Input
  - **translated**: Inmatning

- **com_ui_close**:
  - **english**: Close
  - **translated**: Stäng

- **com_ui_model**:
  - **english**: Model
  - **translated**: Modell

- **com_ui_select_model**:
  - **english**: Select a model
  - **translated**: Välj en modell

- **com_ui_use_prompt**:
  - **english**: Use prompt
  - **translated**: Använd prompt

- **com_ui_prev**:
  - **english**: Prev
  - **translated**: Föregående

- **com_ui_next**:
  - **english**: Next
  - **translated**: Nästa

- **com_ui_prompt_templates**:
  - **english**: Prompt Templates
  - **translated**: Prompt Mallar

- **com_ui_hide_prompt_templates**:
  - **english**: Hide Prompt Templates
  - **translated**: Dölj Prompt Mallar

- **com_ui_showing**:
  - **english**: Showing
  - **translated**: Visar

- **com_ui_of**:
  - **english**: of
  - **translated**: av

- **com_ui_entries**:
  - **english**: Entries
  - **translated**: Inlägg

- **com_ui_pay_per_call**:
  - **english**: All AI conversations in one place. Pay per call and not per month
  - **translated**: Alla AI-konversationer på ett ställe. Betala per anrop och inte per månad

- **com_ui_enter**:
  - **english**: Enter
  - **translated**: Ange

- **com_ui_submit**:
  - **english**: Submit
  - **translated**: Skicka

- **com_ui_upload_success**:
  - **english**: Successfully uploaded file
  - **translated**: Uppladdningen av filen lyckades

- **com_ui_upload_invalid**:
  - **english**: Invalid file for upload. Must be an image not exceeding 2 MB
  - **translated**: Ogiltig fil för uppladdning

- **com_ui_cancel**:
  - **english**: Cancel
  - **translated**: Avbryt

- **com_ui_save**:
  - **english**: Save
  - **translated**: Spara

- **com_ui_copy_to_clipboard**:
  - **english**: Copy to clipboard
  - **translated**: Kopiera till urklipp

- **com_ui_copied_to_clipboard**:
  - **english**: Copied to clipboard
  - **translated**: Kopierat till urklipp

- **com_ui_regenerate**:
  - **english**: Regenerate
  - **translated**: Återskapa

- **com_ui_continue**:
  - **english**: Continue
  - **translated**: Fortsätt

- **com_ui_edit**:
  - **english**: Edit
  - **translated**: Redigera

- **com_ui_success**:
  - **english**: Success
  - **translated**: Lyckades

- **com_ui_all**:
  - **english**: all
  - **translated**: alla

- **com_ui_clear**:
  - **english**: Clear
  - **translated**: Rensa

- **com_ui_revoke**:
  - **english**: Revoke
  - **translated**: Återkalla

- **com_ui_revoke_info**:
  - **english**: Revoke all user provided credentials
  - **translated**: Återkalla alla användaruppgifter.

- **com_ui_import_conversation**:
  - **english**: Import
  - **translated**: Importera

- **com_ui_import_conversation_info**:
  - **english**: Import conversations from a JSON file
  - **translated**: Importera konversationer från en JSON-fil

- **com_ui_import_conversation_success**:
  - **english**: Conversations imported successfully
  - **translated**: Konversationer har importerats framgångsrikt

- **com_ui_import_conversation_error**:
  - **english**: There was an error importing your conversations
  - **translated**: Det uppstod ett fel vid import av dina konversationer

- **com_ui_confirm_action**:
  - **english**: Confirm Action
  - **translated**: Bekräfta åtgärd

- **com_ui_chats**:
  - **english**: chats
  - **translated**: chattar

- **com_ui_delete**:
  - **english**: Delete
  - **translated**: Radera

- **com_ui_delete_conversation**:
  - **english**: Delete chat?
  - **translated**: Radera chatt?

- **com_ui_delete_confirm**:
  - **english**: This will delete
  - **translated**: Detta kommer att radera

- **com_ui_rename**:
  - **english**: Rename
  - **translated**: byta namn på

- **com_ui_archive**:
  - **english**: Archive
  - **translated**: Arkiv

- **com_ui_archive_error**:
  - **english**: Failed to archive conversation
  - **translated**: Kunde inte arkivera chatt

- **com_ui_unarchive**:
  - **english**: Unarchive
  - **translated**: Avarkivera

- **com_ui_unarchive_error**:
  - **english**: Failed to unarchive conversation
  - **translated**: Kunde inte avarkivera chatt

- **com_ui_more_options**:
  - **english**: More
  - **translated**: Mer

- **com_auth_error_login**:
  - **english**: Unable to login with the information provided. Please check your credentials and try again.
  - **translated**: Kunde inte logga in med den angivna informationen. Kontrollera dina uppgifter och försök igen.

- **com_auth_error_login_rl**:
  - **english**: Too many login attempts in a short amount of time. Please try again later.
  - **translated**: För många inloggningsförsök från den här IP-adressen på kort tid. Vänligen försök igen senare.

- **com_auth_no_account**:
  - **english**: Don't have an account?
  - **translated**: Har du inget konto?

- **com_auth_sign_up**:
  - **english**: Sign up
  - **translated**: Registrera dig

- **com_auth_sign_in**:
  - **english**: Sign in
  - **translated**: Logga in

- **com_auth_google_login**:
  - **english**: Continue with Google
  - **translated**: Logga in med Google

- **com_auth_facebook_login**:
  - **english**: Continue with Facebook
  - **translated**: Logga in med Facebook

- **com_auth_github_login**:
  - **english**: Continue with Github
  - **translated**: Logga in med Github

- **com_auth_discord_login**:
  - **english**: Continue with Discord
  - **translated**: Logga in med Discord

- **com_auth_email**:
  - **english**: Email
  - **translated**: E-post

- **com_auth_email_required**:
  - **english**: Email is required
  - **translated**: E-post krävs

- **com_auth_email_min_length**:
  - **english**: Email must be at least 6 characters
  - **translated**: E-post måste vara minst 6 tecken

- **com_auth_email_max_length**:
  - **english**: Email should not be longer than 120 characters
  - **translated**: E-post får inte vara längre än 120 tecken

- **com_auth_email_pattern**:
  - **english**: You must enter a valid email address
  - **translated**: Du måste ange en giltig e-postadress

- **com_auth_email_address**:
  - **english**: Email address
  - **translated**: E-postadress

- **com_auth_password**:
  - **english**: Password
  - **translated**: Lösenord

- **com_auth_password_required**:
  - **english**: Password is required
  - **translated**: Lösenord krävs

- **com_auth_password_min_length**:
  - **english**: Password must be at least 8 characters
  - **translated**: Lösenordet måste vara minst 8 tecken

- **com_auth_password_max_length**:
  - **english**: Password must be less than 128 characters
  - **translated**: Lösenordet får inte vara längre än 128 tecken

- **com_auth_password_forgot**:
  - **english**: Forgot Password?
  - **translated**: Glömt lösenord?

- **com_auth_password_confirm**:
  - **english**: Confirm password
  - **translated**: Bekräfta lösenord

- **com_auth_password_not_match**:
  - **english**: Passwords do not match
  - **translated**: Lösenorden matchar inte

- **com_auth_continue**:
  - **english**: Continue
  - **translated**: Fortsätt

- **com_auth_create_account**:
  - **english**: Create your account
  - **translated**: Skapa ditt konto

- **com_auth_error_create**:
  - **english**: There was an error attempting to register your account. Please try again.
  - **translated**: Det uppstod ett fel när du försökte registrera ditt konto. Vänligen försök igen.

- **com_auth_full_name**:
  - **english**: Full name
  - **translated**: Fullständigt namn

- **com_auth_name_required**:
  - **english**: Name is required
  - **translated**: Namn krävs

- **com_auth_name_min_length**:
  - **english**: Name must be at least 3 characters
  - **translated**: Namnet måste vara minst 3 tecken

- **com_auth_name_max_length**:
  - **english**: Name must be less than 80 characters
  - **translated**: Namnet får inte vara längre än 80 tecken

- **com_auth_username**:
  - **english**: Username (optional)
  - **translated**: Användarnamn (valfritt)

- **com_auth_username_required**:
  - **english**: Username is required
  - **translated**: Användarnamn krävs

- **com_auth_username_min_length**:
  - **english**: Username must be at least 2 characters
  - **translated**: Användarnamnet måste vara minst 2 tecken

- **com_auth_username_max_length**:
  - **english**: Username must be less than 20 characters
  - **translated**: Användarnamnet får inte vara längre än 20 tecken

- **com_auth_already_have_account**:
  - **english**: Already have an account?
  - **translated**: Har du redan ett konto?

- **com_auth_login**:
  - **english**: Login
  - **translated**: Logga in

- **com_auth_reset_password**:
  - **english**: Reset your password
  - **translated**: Återställ ditt lösenord

- **com_auth_click**:
  - **english**: Click
  - **translated**: Klicka

- **com_auth_here**:
  - **english**: HERE
  - **translated**: HÄR

- **com_auth_to_reset_your_password**:
  - **english**: to reset your password.
  - **translated**: för att återställa ditt lösenord.

- **com_auth_reset_password_link_sent**:
  - **english**: Email Sent
  - **translated**: E-post skickad

- **com_auth_reset_password_email_sent**:
  - **english**: An email has been sent to you with further instructions to reset your password.
  - **translated**: Ett e-postmeddelande har skickats till dig med ytterligare instruktioner för att återställa ditt lösenord.

- **com_auth_error_reset_password**:
  - **english**: There was a problem resetting your password. There was no user found with the email address provided. Please try again.
  - **translated**: Det uppstod ett problem med att återställa ditt lösenord. Ingen användare hittades med den angivna e-postadressen. Vänligen försök igen.

- **com_auth_reset_password_success**:
  - **english**: Password Reset Success
  - **translated**: Lösenordsåterställning lyckades

- **com_auth_login_with_new_password**:
  - **english**: You may now login with your new password.
  - **translated**: Du kan nu logga in med ditt nya lösenord.

- **com_auth_error_invalid_reset_token**:
  - **english**: This password reset token is no longer valid.
  - **translated**: Detta lösenordsåterställningsnyckel är inte längre giltigt.

- **com_auth_click_here**:
  - **english**: Click here
  - **translated**: Klicka här

- **com_auth_to_try_again**:
  - **english**: to try again.
  - **translated**: för att försöka igen.

- **com_auth_submit_registration**:
  - **english**: Submit registration
  - **translated**: Skicka registrering

- **com_auth_welcome_back**:
  - **english**: Welcome back
  - **translated**: Välkommen tillbaka

- **com_endpoint_open_menu**:
  - **english**: Open Menu
  - **translated**: Öppna meny

- **com_endpoint_bing_enable_sydney**:
  - **english**: Enable Sydney
  - **translated**: Aktivera Sydney

- **com_endpoint_bing_to_enable_sydney**:
  - **english**: To enable Sydney
  - **translated**: För att aktivera Sydney

- **com_endpoint_bing_jailbreak**:
  - **english**: Jailbreak
  - **translated**: Jailbreak

- **com_endpoint_bing_context_placeholder**:
  - **english**: Bing can use up to 7k tokens for 'context', which it can reference for the conversation. The specific limit is not known but may run into errors exceeding 7k tokens
  - **translated**: Bing kan använda upp till 7k tokens för "kontext", som den kan referera till under konversationen. Den specifika gränsen är inte känd men kan stöta på fel om den överstiger 7k tokens

- **com_endpoint_bing_system_message_placeholder**:
  - **english**: WARNING: Misuse of this feature can get you BANNED from using Bing! Click on 'System Message' for full instructions and the default message if omitted, which is the 'Sydney' preset that is considered safe.
  - **translated**: VARNING: Otillåten användning av denna funktion kan få dig BANNAD från att använda Bing! Klicka på "Systemmeddelande" för fullständiga instruktioner och standardmeddelandet om det utelämnas, vilket är "Sydney"-förinställningen som anses vara säker.

- **com_endpoint_system_message**:
  - **english**: System Message
  - **translated**: Systemmeddelande

- **com_endpoint_default_blank**:
  - **english**: default: blank
  - **translated**: standard: tom

- **com_endpoint_default_false**:
  - **english**: default: false
  - **translated**: standard: falsk

- **com_endpoint_default_creative**:
  - **english**: default: creative
  - **translated**: standard: kreativ

- **com_endpoint_default_empty**:
  - **english**: default: empty
  - **translated**: standard: tom

- **com_endpoint_default_with_num**:
  - **english**: default: {0}
  - **translated**: standard: {0}

- **com_endpoint_context**:
  - **english**: Context
  - **translated**: Kontext

- **com_endpoint_tone_style**:
  - **english**: Tone Style
  - **translated**: Tonstil

- **com_endpoint_token_count**:
  - **english**: Token count
  - **translated**: Antal tokens

- **com_endpoint_output**:
  - **english**: Output
  - **translated**: Utdata

- **com_endpoint_google_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: Högre värden = mer slumpmässigt, medan lägre värden = mer fokuserat och bestämt. Vi rekommenderar att ändra detta eller Top P men inte båda.

- **com_endpoint_google_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p ändrar hur modellen väljer tokens för utdata. Tokens väljs från de mest K (se topK-parameter) sannolika till de minst tills summan av deras sannolikheter når top-p-värdet.

- **com_endpoint_google_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k ändrar hur modellen väljer tokens för utdata. Ett top-k av 1 innebär att den valda token är den mest sannolika bland alla tokens i modellens vokabulär (kallas också girig avkodning), medan ett top-k av 3 innebär att nästa token väljs bland de 3 mest sannolika tokens (med temperatur).

- **com_endpoint_google_maxoutputtokens**:
  - **english**:  	Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: Maximalt antal tokens som kan genereras i svaret. Ange ett lägre värde för kortare svar och ett högre värde för längre svar.

- **com_endpoint_google_custom_name_placeholder**:
  - **english**: Set a custom name for Google
  - **translated**: Ange ett anpassat namn för Google

- **com_endpoint_prompt_prefix_placeholder**:
  - **english**: Set custom instructions or context. Ignored if empty.
  - **translated**: Ange anpassade instruktioner eller kontext. Ignoreras om tom.

- **com_endpoint_custom_name**:
  - **english**: Custom Name
  - **translated**: Anpassat namn

- **com_endpoint_prompt_prefix**:
  - **english**: Custom Instructions
  - **translated**: Uppmaningsprefix

- **com_endpoint_temperature**:
  - **english**: Temperature
  - **translated**: Temperatur

- **com_endpoint_default**:
  - **english**: default
  - **translated**: standard

- **com_endpoint_top_p**:
  - **english**: Top P
  - **translated**: Top P

- **com_endpoint_top_k**:
  - **english**: Top K
  - **translated**: Top K

- **com_endpoint_max_output_tokens**:
  - **english**: Max Output Tokens
  - **translated**: Max utdatatokens

- **com_endpoint_openai_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: Högre värden = mer slumpmässigt, medan lägre värden = mer fokuserat och bestämt. Vi rekommenderar att ändra detta eller Top P men inte båda.

- **com_endpoint_openai_max**:
  - **english**: The max tokens to generate. The total length of input tokens and generated tokens is limited by the model's context length.
  - **translated**: Max tokens att generera. Den totala längden på tokens för inmatning och svar är begränsad av modellen som används.

- **com_endpoint_openai_topp**:
  - **english**: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We recommend altering this or temperature but not both.
  - **translated**: Ett alternativ till temperatur, kallat kärnprovtagning, där modellen beaktar resultaten av tokens med top_p-sannolikhetsmassa. Så 0,1 innebär att endast de tokens som utgör den översta 10% sannolikhetsmassan beaktas. Vi rekommenderar att ändra detta eller temperaturen men inte båda.

- **com_endpoint_openai_freq**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
  - **translated**: Nummer mellan -2,0 och 2,0. Positiva värden minskar nya tokens baserat på deras befintliga frekvens i texten hittills, vilket minskar modellens sannolikhet att upprepa samma rad ordagrant.

- **com_endpoint_openai_pres**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
  - **translated**: Nummer mellan -2,0 och 2,0. Positiva värden minskar nya tokens baserat på om de förekommer i texten hittills, vilket ökar modellens sannolikhet att prata om nya ämnen.

- **com_endpoint_openai_custom_name_placeholder**:
  - **english**: Set a custom name for the AI
  - **translated**: Ange ett eget namn för ChatGPT

- **com_endpoint_openai_prompt_prefix_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: Ange anpassade instruktioner att inkludera i Systemmeddelande. Standard: inga

- **com_endpoint_anthropic_temp**:
  - **english**: Ranges from 0 to 1. Use temp closer to 0 for analytical / multiple choice, and closer to 1 for creative and generative tasks. We recommend altering this or Top P but not both.
  - **translated**: Varierar mellan 0 och 1. Använd temp närmare 0 för analytiska/flervalsfrågor och närmare 1 för kreativa och generativa uppgifter. Vi rekommenderar att ändra detta eller Top P men inte båda.

- **com_endpoint_anthropic_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p ändrar hur modellen väljer tokens för utdata. Tokens väljs från de mest K (se topK-parameter) sannolika till de minst tills summan av deras sannolikheter når top-p-värdet.

- **com_endpoint_anthropic_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k ändrar hur modellen väljer tokens för utdata. Ett top-k av 1 innebär att den valda token är den mest sannolika bland alla tokens i modellens vokabulär (kallas också girig avkodning), medan ett top-k av 3 innebär att nästa token väljs bland de 3 mest sannolika tokens (med temperatur).

- **com_endpoint_anthropic_maxoutputtokens**:
  - **english**: Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: Maximalt antal tokens som kan genereras i svaret. Ange ett lägre värde för kortare svar och ett högre värde för längre svar.

- **com_endpoint_anthropic_custom_name_placeholder**:
  - **english**: Set a custom name for Anthropic
  - **translated**: Ange ett anpassat namn för Anthropic

- **com_endpoint_frequency_penalty**:
  - **english**: Frequency Penalty
  - **translated**: Frekvensstraff

- **com_endpoint_presence_penalty**:
  - **english**: Presence Penalty
  - **translated**: Närvarostraff

- **com_endpoint_plug_use_functions**:
  - **english**: Use Functions
  - **translated**: Använd funktioner

- **com_endpoint_plug_skip_completion**:
  - **english**: Skip Completion
  - **translated**: Hoppa över komplettering

- **com_endpoint_disabled_with_tools**:
  - **english**: disabled with tools
  - **translated**: inaktiverad med verktyg

- **com_endpoint_disabled_with_tools_placeholder**:
  - **english**: Disabled with Tools Selected
  - **translated**: Inaktiverad med valda verktyg

- **com_endpoint_plug_set_custom_instructions_for_gpt_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: Ange anpassade instruktioner att inkludera i systemmeddelande. Standard: inga

- **com_endpoint_import**:
  - **english**: Import
  - **translated**: Importera

- **com_endpoint_set_custom_name**:
  - **english**: Set a custom name, in case you can find this preset
  - **translated**: Ange ett eget namn, om du kan hitta denna förinställning

- **com_endpoint_preset**:
  - **english**: preset
  - **translated**: förinställning

- **com_endpoint_presets**:
  - **english**: presets
  - **translated**: förinställningar

- **com_endpoint_preset_name**:
  - **english**: Preset Name
  - **translated**: Förinställningsnamn

- **com_endpoint_new_topic**:
  - **english**: New Topic
  - **translated**: Nytt ämne

- **com_endpoint**:
  - **english**: Endpoint
  - **translated**: Slutpunkt

- **com_endpoint_hide**:
  - **english**: Hide
  - **translated**: Dölj

- **com_endpoint_show**:
  - **english**: Show
  - **translated**: Visa

- **com_endpoint_examples**:
  - **english**:  Presets
  - **translated**:  Förinställningar

- **com_endpoint_completion**:
  - **english**: Completion
  - **translated**: Komplettering

- **com_endpoint_agent**:
  - **english**: Agent
  - **translated**: Agent

- **com_endpoint_show_what_settings**:
  - **english**: Show {0} Settings
  - **translated**: Visa {0} inställningar

- **com_endpoint_export**:
  - **english**: Export
  - **translated**: Exportera

- **com_endpoint_save_as_preset**:
  - **english**: Save As Preset
  - **translated**: Spara som förinställning

- **com_endpoint_presets_clear_warning**:
  - **english**: Are you sure you want to clear all presets? This is irreversible.
  - **translated**: Är du säker på att du vill rensa alla förinställningar? Detta går inte att ångra.

- **com_endpoint_not_implemented**:
  - **english**: Not implemented
  - **translated**: Ej implementerad

- **com_endpoint_no_presets**:
  - **english**: No presets yet, use the settings button to create one
  - **translated**: Ingen förinställning ännu

- **com_endpoint_not_available**:
  - **english**: No endpoint available
  - **translated**: Ingen slutpunkt tillgänglig

- **com_endpoint_view_options**:
  - **english**: View Options
  - **translated**: Visa alternativ

- **com_endpoint_save_convo_as_preset**:
  - **english**: Save Conversation as Preset
  - **translated**: Spara konversation som förinställning

- **com_endpoint_my_preset**:
  - **english**: My Preset
  - **translated**: Min förinställning

- **com_endpoint_agent_model**:
  - **english**: Agent Model (Recommended: GPT-3.5)
  - **translated**: Agentmodell (Rekommenderad: GPT-3.5)

- **com_endpoint_completion_model**:
  - **english**: Completion Model (Recommended: GPT-4)
  - **translated**: Kompletteringsmodell (Rekommenderad: GPT-4)

- **com_endpoint_func_hover**:
  - **english**: Enable use of Plugins as OpenAI Functions
  - **translated**: Aktivera användning av tillägg som OpenAI-funktioner

- **com_endpoint_skip_hover**:
  - **english**: Enable skipping the completion step, which reviews the final answer and generated steps
  - **translated**: Aktivera att hoppa över kompletteringssteg, som granskar det slutliga svaret och genererade steg

- **com_endpoint_config_key**:
  - **english**: Set API Key
  - **translated**: Ange API-nyckel

- **com_endpoint_config_key_for**:
  - **english**: Set API Key for
  - **translated**: Ange API-nyckel för

- **com_endpoint_config_key_name**:
  - **english**: Key
  - **translated**: Nyckel

- **com_endpoint_config_value**:
  - **english**: Enter value for
  - **translated**: Ange värde för

- **com_endpoint_config_key_name_placeholder**:
  - **english**: Set API key first
  - **translated**: Ange API-nyckel först

- **com_endpoint_config_key_encryption**:
  - **english**: Your key will be encrypted and deleted at
  - **translated**: Din nyckel kommer att krypteras och raderas vid

- **com_endpoint_config_key_expiry**:
  - **english**: the expiry time
  - **translated**: utgångstiden

- **com_endpoint_config_key_import_json_key**:
  - **english**: Import Service Account JSON Key.
  - **translated**: Importera JSON-nyckel för kontot.

- **com_endpoint_config_key_import_json_key_success**:
  - **english**: Successfully Imported Service Account JSON Key
  - **translated**: Lyckades importera JSON-nyckel för kontot

- **com_endpoint_config_key_import_json_key_invalid**:
  - **english**: Invalid Service Account JSON Key, Did you import the correct file?
  - **translated**: Ogiltig JSON-nyckel för konto, importerade du rätt fil?

- **com_endpoint_config_key_get_edge_key**:
  - **english**: To get your Access token for Bing, login to
  - **translated**: För att få din åtkomstnyckel för Bing, logga in på

- **com_endpoint_config_key_get_edge_key_dev_tool**:
  - **english**: Use dev tools or an extension while logged into the site to copy the content of the _U cookie. If this fails, follow these
  - **translated**: Använd utvecklingsverktyg eller ett tillägg när du är inloggad på webbplatsen för att kopiera innehållet i _U-cookien. Om detta misslyckas, följ dessa

- **com_endpoint_config_key_edge_instructions**:
  - **english**: instructions
  - **translated**: instruktioner

- **com_endpoint_config_key_edge_full_key_string**:
  - **english**: to provide the full cookie strings.
  - **translated**: för att tillhandahålla hela cookie-strängarna.

- **com_endpoint_config_key_chatgpt**:
  - **english**: To get your Access token For ChatGPT 'Free Version', login to
  - **translated**: För att få din åtkomstnyckel för ChatGPT "Gratisversion", logga in på

- **com_endpoint_config_key_chatgpt_then_visit**:
  - **english**: then visit
  - **translated**: sedan besök

- **com_endpoint_config_key_chatgpt_copy_token**:
  - **english**: Copy access token.
  - **translated**: Kopiera åtkomstnyckel.

- **com_endpoint_config_key_google_need_to**:
  - **english**: You need to
  - **translated**: Du behöver

- **com_endpoint_config_key_google_vertex_ai**:
  - **english**: Enable Vertex AI
  - **translated**: Aktivera Vertex AI

- **com_endpoint_config_key_google_vertex_api**:
  - **english**: API on Google Cloud, then
  - **translated**: API på Google Cloud, sedan

- **com_endpoint_config_key_google_service_account**:
  - **english**: Create a Service Account
  - **translated**: Skapa ett tjänstekonto

- **com_endpoint_config_key_google_vertex_api_role**:
  - **english**: Make sure to click 'Create and Continue' to give at least the 'Vertex AI User' role. Lastly, create a JSON key to import here.
  - **translated**: Se till att klicka på "Skapa och fortsätt" för att ge åtminstone rollen "Vertex AI-användare". Skapa slutligen en JSON-nyckel att importera här.

- **com_nav_plugin_store**:
  - **english**: Plugin store
  - **translated**: Pluginbutik

- **com_nav_plugin_search**:
  - **english**: Search plugins
  - **translated**: Sök efter plugins

- **com_nav_plugin_auth_error**:
  - **english**: There was an error attempting to authenticate this plugin. Please try again.
  - **translated**: Det uppstod ett fel när försöket att autentisera denna plugin gjordes. Försök igen.

- **com_nav_export_filename**:
  - **english**: Filename
  - **translated**: Filnamn

- **com_nav_export_filename_placeholder**:
  - **english**: Set the filename
  - **translated**: Ange filnamnet

- **com_nav_export_type**:
  - **english**: Type
  - **translated**: Typ

- **com_nav_export_include_endpoint_options**:
  - **english**: Include endpoint options
  - **translated**: Inkludera slutpunktsalternativ

- **com_nav_enabled**:
  - **english**: Enabled
  - **translated**: Aktiverad

- **com_nav_not_supported**:
  - **english**: Not Supported
  - **translated**: Stöds ej

- **com_nav_export_all_message_branches**:
  - **english**: Export all message branches
  - **translated**: Exportera alla grenar för meddelanden

- **com_nav_export_recursive_or_sequential**:
  - **english**: Recursive or sequential?
  - **translated**: Rekursiv eller sekventiell?

- **com_nav_export_recursive**:
  - **english**: Recursive
  - **translated**: Rekursiv

- **com_nav_export_conversation**:
  - **english**: Export conversation
  - **translated**: Exportera konversation

- **com_nav_theme**:
  - **english**: Theme
  - **translated**: Tema

- **com_nav_theme_system**:
  - **english**: System
  - **translated**: System

- **com_nav_theme_dark**:
  - **english**: Dark
  - **translated**: Mörkt

- **com_nav_theme_light**:
  - **english**: Light
  - **translated**: Ljust

- **com_nav_clear_all_chats**:
  - **english**: Clear all chats
  - **translated**: Rensa alla chattar

- **com_nav_confirm_clear**:
  - **english**: Confirm Clear
  - **translated**: Bekräfta rensning

- **com_nav_close_sidebar**:
  - **english**: Close sidebar
  - **translated**: Stäng sidofält

- **com_nav_open_sidebar**:
  - **english**: Open sidebar
  - **translated**: Öppna sidofält

- **com_nav_send_message**:
  - **english**: Send message
  - **translated**: Skicka meddelande

- **com_nav_log_out**:
  - **english**: Log out
  - **translated**: Logga ut

- **com_nav_user**:
  - **english**: USER
  - **translated**: ANVÄNDARE

- **com_nav_archived_chats**:
  - **english**: Archived chats
  - **translated**: Arkiverade chattar

- **com_nav_archived_chats_manage**:
  - **english**: Manage
  - **translated**: Hantera

- **com_nav_archived_chats_empty**:
  - **english**: You have no archived conversations.
  - **translated**: Du har inga arkiverade chattar.

- **com_nav_archive_all_chats**:
  - **english**: Archive all chats
  - **translated**: Arkivera alla chattar

- **com_nav_archive_all**:
  - **english**: Archive all
  - **translated**: Arkivera alla

- **com_nav_archive_name**:
  - **english**: Name
  - **translated**: Namn

- **com_nav_archive_created_at**:
  - **english**: DateCreated
  - **translated**: Skapad

- **com_nav_clear_conversation**:
  - **english**: Clear conversations
  - **translated**: Rensa konversationer

- **com_nav_clear_conversation_confirm_message**:
  - **english**: Are you sure you want to clear all conversations? This is irreversible.
  - **translated**: Är du säker på att du vill rensa alla konversationer? Detta går inte att ångra.

- **com_nav_help_faq**:
  - **english**: Help & FAQ
  - **translated**: Hjälp & Vanliga frågor

- **com_nav_settings**:
  - **english**: Settings
  - **translated**: Inställningar

- **com_nav_search_placeholder**:
  - **english**: Search messages
  - **translated**: Sök meddelanden

- **com_nav_setting_general**:
  - **english**: General
  - **translated**: Allmänt

- **com_nav_setting_data**:
  - **english**: Data controls
  - **translated**: Datakontroller

Please consider the above comparisons to enhance understanding and guide improvements in translations.

Provide insights or suggestions that could help refine the translation process, focusing on cultural and contextual relevance.

Please craft a prompt that can be used to better inform future translations to this language.

Write this prompt in the translated language, with all its nuances detected, not in the English.
