# Instructions for Translation

Write a prompt that is mindful of the nuances in the language with respect to its English counterpart, which serves as the baseline for translations. Here are the comparisons between the language translations and their English counterparts:


- **com_sidepanel_select_assistant**:
  - **english**: Select an Assistant
  - **translated**: Выбрать Ассистента

- **com_sidepanel_assistant_builder**:
  - **english**: Assistant Builder
  - **translated**: Конструктор Ассистента

- **com_sidepanel_attach_files**:
  - **english**: Attach Files
  - **translated**: Прикрепить файлы

- **com_sidepanel_manage_files**:
  - **english**: Manage Files
  - **translated**: Управление файлами

- **com_assistants_code_interpreter**:
  - **english**: Code Interpreter
  - **translated**: Интерпретатор кода

- **com_assistants_code_interpreter_files**:
  - **english**: The following files are only available for Code Interpreter:
  - **translated**: Следующие файлы доступны только для Интерпретатора кода:

- **com_ui_examples**:
  - **english**: Examples
  - **translated**: Примеры

- **com_ui_new_chat**:
  - **english**: New chat
  - **translated**: Создать чат

- **com_ui_happy_birthday**:
  - **english**: It's my 1st birthday!
  - **translated**: Это мой первый день рождения!

- **com_ui_example_quantum_computing**:
  - **english**: Explain quantum computing in simple terms
  - **translated**: Объясни квантовые вычисления простыми словами

- **com_ui_example_10_year_old_b_day**:
  - **english**: Got any creative ideas for a 10 year old's birthday?
  - **translated**: У тебя есть креативные идеи для дня рождения 10-летнего ребенка?

- **com_ui_example_http_in_js**:
  - **english**: How do I make an HTTP request in Javascript?
  - **translated**: Как мне сделать HTTP-запрос в JavaScript?

- **com_ui_capabilities**:
  - **english**: Capabilities
  - **translated**: Возможности

- **com_ui_capability_remember**:
  - **english**: Remembers what user said earlier in the conversation
  - **translated**: Запоминает, что пользователь говорил ранее в разговоре

- **com_ui_capability_correction**:
  - **english**: Allows user to provide follow-up corrections
  - **translated**: Позволяет пользователю вносить корректировки после ответа

- **com_ui_capability_decline_requests**:
  - **english**: Trained to decline inappropriate requests
  - **translated**: Обучен отклонять неподходящие запросы

- **com_ui_limitations**:
  - **english**: Limitations
  - **translated**: Ограничения

- **com_ui_limitation_incorrect_info**:
  - **english**: May occasionally generate incorrect information
  - **translated**: Иногда может генерировать некорректную информацию

- **com_ui_limitation_harmful_biased**:
  - **english**: May occasionally produce harmful instructions or biased content
  - **translated**: Иногда может создавать вредные инструкции или предвзятое содержимое

- **com_ui_limitation_limited_2021**:
  - **english**: Limited knowledge of world and events after 2021
  - **translated**: Ограниченные знания о мире и событиях после 2021 года

- **com_ui_experimental**:
  - **english**: Experimental Features
  - **translated**: Экспериментальный

- **com_ui_input**:
  - **english**: Input
  - **translated**: Ввод

- **com_ui_close**:
  - **english**: Close
  - **translated**: Закрыть

- **com_ui_model**:
  - **english**: Model
  - **translated**: Модель

- **com_ui_select_model**:
  - **english**: Select a model
  - **translated**: Выберите модель

- **com_ui_use_prompt**:
  - **english**: Use prompt
  - **translated**: Использовать промт

- **com_ui_prev**:
  - **english**: Prev
  - **translated**: Предыдущий

- **com_ui_next**:
  - **english**: Next
  - **translated**: Следующий

- **com_ui_stop**:
  - **english**: Stop
  - **translated**: Остановить генерацию

- **com_ui_prompt_templates**:
  - **english**: Prompt Templates
  - **translated**: Шаблоны промтов

- **com_ui_hide_prompt_templates**:
  - **english**: Hide Prompt Templates
  - **translated**: Скрыть шаблоны промтов

- **com_ui_showing**:
  - **english**: Showing
  - **translated**: Показано

- **com_ui_of**:
  - **english**: of
  - **translated**: из

- **com_ui_entries**:
  - **english**: Entries
  - **translated**: записей

- **com_ui_pay_per_call**:
  - **english**: All AI conversations in one place. Pay per call and not per month
  - **translated**: Все AI-разговоры в одном месте. Оплачивайте за вызовы, а не за месяц

- **com_ui_new_footer**:
  - **english**: All AI conversations in one place.
  - **translated**: Все AI-разговоры в одном месте.

- **com_ui_enter**:
  - **english**: Enter
  - **translated**: Ввести

- **com_ui_submit**:
  - **english**: Submit
  - **translated**: Отправить

- **com_ui_upload_success**:
  - **english**: Successfully uploaded file
  - **translated**: Файл успешно загружен

- **com_ui_upload_invalid**:
  - **english**: Invalid file for upload. Must be an image not exceeding 2 MB
  - **translated**: Недопустимый файл для загрузки

- **com_ui_cancel**:
  - **english**: Cancel
  - **translated**: Отмена

- **com_ui_save**:
  - **english**: Save
  - **translated**: Сохранить

- **com_ui_save_submit**:
  - **english**: Save & Submit
  - **translated**: Сохранить и отправить

- **com_ui_copy_to_clipboard**:
  - **english**: Copy to clipboard
  - **translated**: Копировать в буфер обмена

- **com_ui_copied_to_clipboard**:
  - **english**: Copied to clipboard
  - **translated**: Скопировано в буфер обмена

- **com_ui_regenerate**:
  - **english**: Regenerate
  - **translated**: Повторная генерация

- **com_ui_continue**:
  - **english**: Continue
  - **translated**: Продолжить

- **com_ui_edit**:
  - **english**: Edit
  - **translated**: Редактировать

- **com_ui_success**:
  - **english**: Success
  - **translated**: Успешно

- **com_ui_all**:
  - **english**: all
  - **translated**: все

- **com_ui_clear**:
  - **english**: Clear
  - **translated**: Удалить

- **com_ui_revoke**:
  - **english**: Revoke
  - **translated**: Отозвать

- **com_ui_revoke_info**:
  - **english**: Revoke all user provided credentials
  - **translated**: Отозвать все предоставленные пользователем учетные данные

- **com_ui_import_conversation**:
  - **english**: Import
  - **translated**: Импортировать

- **com_ui_import_conversation_info**:
  - **english**: Import conversations from a JSON file
  - **translated**: Импортировать беседы из файла JSON

- **com_ui_import_conversation_success**:
  - **english**: Conversations imported successfully
  - **translated**: Беседы успешно импортированы

- **com_ui_import_conversation_error**:
  - **english**: There was an error importing your conversations
  - **translated**: При импорте бесед произошла ошибка

- **com_ui_confirm_action**:
  - **english**: Confirm Action
  - **translated**: Подтвердить действие

- **com_ui_chats**:
  - **english**: chats
  - **translated**: чаты

- **com_ui_delete**:
  - **english**: Delete
  - **translated**: Удалить

- **com_ui_preview**:
  - **english**: Preview
  - **translated**: Предпросмотр

- **com_ui_upload**:
  - **english**: Upload
  - **translated**: Загрузить

- **com_ui_connect**:
  - **english**: Connect
  - **translated**: Подключить

- **com_ui_delete_conversation**:
  - **english**: Delete chat?
  - **translated**: Удалить чат?

- **com_ui_delete_confirm**:
  - **english**: This will delete
  - **translated**: Будет удален следующий чат: 

- **com_ui_rename**:
  - **english**: Rename
  - **translated**: Переименовать

- **com_ui_archive**:
  - **english**: Archive
  - **translated**: Архивировать

- **com_ui_archive_error**:
  - **english**: Failed to archive conversation
  - **translated**: Nie udało się archiwizować rozmowy

- **com_ui_unarchive**:
  - **english**: Unarchive
  - **translated**: разархивировать

- **com_ui_unarchive_error**:
  - **english**: Failed to unarchive conversation
  - **translated**: Nie udało się odtworzyć rozmowy z archiwum

- **com_ui_more_options**:
  - **english**: More
  - **translated**: Еще

- **com_auth_error_login**:
  - **english**: Unable to login with the information provided. Please check your credentials and try again.
  - **translated**: Не удалось войти с предоставленной информацией. Пожалуйста, проверьте ваши учетные данные и попробуйте снова.

- **com_auth_error_login_rl**:
  - **english**: Too many login attempts in a short amount of time. Please try again later.
  - **translated**: Слишком много попыток входа в систему за короткий промежуток времени. Пожалуйста, повторите попытку позже.

- **com_auth_error_login_ban**:
  - **english**: Your account has been temporarily banned due to violations of our service.
  - **translated**: Ваша учетная запись была временно заблокирована в связи с нарушениями нашего сервиса.

- **com_auth_error_login_server**:
  - **english**: There was an internal server error. Please wait a few moments and try again.
  - **translated**: Произошла внутренняя ошибка сервера. Пожалуйста, подождите несколько минут и повторите попытку.

- **com_auth_no_account**:
  - **english**: Don't have an account?
  - **translated**: Еще не зарегистрированы?

- **com_auth_sign_up**:
  - **english**: Sign up
  - **translated**: Зарегистрироваться

- **com_auth_sign_in**:
  - **english**: Sign in
  - **translated**: Войти

- **com_auth_google_login**:
  - **english**: Continue with Google
  - **translated**: Войти с помощью Google

- **com_auth_facebook_login**:
  - **english**: Continue with Facebook
  - **translated**: Войти с помощью Facebook

- **com_auth_github_login**:
  - **english**: Continue with Github
  - **translated**: Войти с помощью Github

- **com_auth_discord_login**:
  - **english**: Continue with Discord
  - **translated**: Войти с помощью Discord

- **com_auth_email**:
  - **english**: Email
  - **translated**: Email

- **com_auth_email_required**:
  - **english**: Email is required
  - **translated**: Email обязателен

- **com_auth_email_min_length**:
  - **english**: Email must be at least 6 characters
  - **translated**: Email должен содержать не менее 6 символов

- **com_auth_email_max_length**:
  - **english**: Email should not be longer than 120 characters
  - **translated**: Email не может быть длиннее 120 символов

- **com_auth_email_pattern**:
  - **english**: You must enter a valid email address
  - **translated**: Вы должны ввести действительный адрес электронной почты

- **com_auth_email_address**:
  - **english**: Email address
  - **translated**: Адрес электронной почты

- **com_auth_password**:
  - **english**: Password
  - **translated**: Пароль

- **com_auth_password_required**:
  - **english**: Password is required
  - **translated**: Пароль обязателен

- **com_auth_password_min_length**:
  - **english**: Password must be at least 8 characters
  - **translated**: Пароль должен содержать не менее 8 символов

- **com_auth_password_max_length**:
  - **english**: Password must be less than 128 characters
  - **translated**: Пароль должен быть не более 128 символов

- **com_auth_password_forgot**:
  - **english**: Forgot Password?
  - **translated**: Забыли пароль?

- **com_auth_password_confirm**:
  - **english**: Confirm password
  - **translated**: Подтвердите пароль

- **com_auth_password_not_match**:
  - **english**: Passwords do not match
  - **translated**: Пароли не совпадают

- **com_auth_continue**:
  - **english**: Continue
  - **translated**: Продолжить

- **com_auth_create_account**:
  - **english**: Create your account
  - **translated**: Создать аккаунт

- **com_auth_error_create**:
  - **english**: There was an error attempting to register your account. Please try again.
  - **translated**: Возникла ошибка при попытке зарегистрировать ваш аккаунт. Пожалуйста, попробуйте еще раз.

- **com_auth_full_name**:
  - **english**: Full name
  - **translated**: Полное имя

- **com_auth_name_required**:
  - **english**: Name is required
  - **translated**: Имя обязательно

- **com_auth_name_min_length**:
  - **english**: Name must be at least 3 characters
  - **translated**: Имя должно содержать не менее 3 символов

- **com_auth_name_max_length**:
  - **english**: Name must be less than 80 characters
  - **translated**: Имя должно быть короче 80 символов

- **com_auth_username**:
  - **english**: Username (optional)
  - **translated**: Имя пользователя (необязательно)

- **com_auth_username_required**:
  - **english**: Username is required
  - **translated**: Имя пользователя обязательно

- **com_auth_username_min_length**:
  - **english**: Username must be at least 2 characters
  - **translated**: Имя пользователя должно содержать не менее 2 символов

- **com_auth_username_max_length**:
  - **english**: Username must be less than 20 characters
  - **translated**: Имя пользователя должно быть не более 20 символов

- **com_auth_already_have_account**:
  - **english**: Already have an account?
  - **translated**: Уже зарегистрированы?

- **com_auth_login**:
  - **english**: Login
  - **translated**: Войти

- **com_auth_reset_password**:
  - **english**: Reset your password
  - **translated**: Сбросить пароль

- **com_auth_click**:
  - **english**: Click
  - **translated**: Нажмите

- **com_auth_here**:
  - **english**: HERE
  - **translated**: ЗДЕСЬ

- **com_auth_to_reset_your_password**:
  - **english**: to reset your password.
  - **translated**: чтобы сбросить ваш пароль.

- **com_auth_reset_password_link_sent**:
  - **english**: Email Sent
  - **translated**: Письмо отправлено

- **com_auth_reset_password_email_sent**:
  - **english**: An email has been sent to you with further instructions to reset your password.
  - **translated**: На вашу почту было отправлено письмо с дальнейшими инструкциями по сбросу пароля.

- **com_auth_error_reset_password**:
  - **english**: There was a problem resetting your password. There was no user found with the email address provided. Please try again.
  - **translated**: При сбросе пароля возникла проблема. Пользователь с указанным адресом электронной почты не найден. Пожалуйста, попробуйте еще раз.

- **com_auth_reset_password_success**:
  - **english**: Password Reset Success
  - **translated**: Сброс пароля успешно выполнен

- **com_auth_login_with_new_password**:
  - **english**: You may now login with your new password.
  - **translated**: Теперь вы можете войти с новым паролем.

- **com_auth_error_invalid_reset_token**:
  - **english**: This password reset token is no longer valid.
  - **translated**: Этот токен сброса пароля больше не действителен.

- **com_auth_click_here**:
  - **english**: Click here
  - **translated**: Нажмите здесь

- **com_auth_to_try_again**:
  - **english**: to try again.
  - **translated**: чтобы попробовать снова.

- **com_auth_submit_registration**:
  - **english**: Submit registration
  - **translated**: Отправить регистрацию

- **com_auth_welcome_back**:
  - **english**: Welcome back
  - **translated**: Добро пожаловать

- **com_auth_back_to_login**:
  - **english**: Back to Login
  - **translated**: Вернуться к авторизации

- **com_endpoint_open_menu**:
  - **english**: Open Menu
  - **translated**: Открыть меню

- **com_endpoint_bing_enable_sydney**:
  - **english**: Enable Sydney
  - **translated**: Включить Sydney

- **com_endpoint_bing_to_enable_sydney**:
  - **english**: To enable Sydney
  - **translated**: Чтобы включить Sydney

- **com_endpoint_bing_jailbreak**:
  - **english**: Jailbreak
  - **translated**: Jailbreak

- **com_endpoint_bing_context_placeholder**:
  - **english**: Bing can use up to 7k tokens for 'context', which it can reference for the conversation. The specific limit is not known but may run into errors exceeding 7k tokens
  - **translated**: Bing может использовать до 7 тысяч токенов для "контекста", на который он может ссылаться в разговоре. Точный предел неизвестен, но превышение 7 тысяч токенов может вызвать ошибки.

- **com_endpoint_bing_system_message_placeholder**:
  - **english**: WARNING: Misuse of this feature can get you BANNED from using Bing! Click on 'System Message' for full instructions and the default message if omitted, which is the 'Sydney' preset that is considered safe.
  - **translated**: ПРЕДУПРЕЖДЕНИЕ: Неправильное использование этой функции может привести к БАНУ на использование Bing! Нажмите на "Системное сообщение" для получения полных инструкций и значения по умолчанию, которое является предустановкой "Sydney", считающейся безопасной.

- **com_endpoint_system_message**:
  - **english**: System Message
  - **translated**: Системное сообщение

- **com_endpoint_message**:
  - **english**: Message
  - **translated**: Сообщение

- **com_endpoint_message_not_appendable**:
  - **english**: Edit your message or Regenerate.
  - **translated**: Отредактируйте свое сообщение или перегенерируйте.

- **com_endpoint_default_blank**:
  - **english**: default: blank
  - **translated**: по умолчанию: пусто

- **com_endpoint_default_false**:
  - **english**: default: false
  - **translated**: по умолчанию: false

- **com_endpoint_default_creative**:
  - **english**: default: creative
  - **translated**: по умолчанию: креативный

- **com_endpoint_default_empty**:
  - **english**: default: empty
  - **translated**: по умолчанию: пусто

- **com_endpoint_default_with_num**:
  - **english**: default: {0}
  - **translated**: по умолчанию: {0}

- **com_endpoint_context**:
  - **english**: Context
  - **translated**: Контекст

- **com_endpoint_tone_style**:
  - **english**: Tone Style
  - **translated**: Стиль тона

- **com_endpoint_token_count**:
  - **english**: Token count
  - **translated**: Количество токенов

- **com_endpoint_output**:
  - **english**: Output
  - **translated**: Вывод

- **com_endpoint_google_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: Более высокие значения = более случайные результаты, более низкие значения = более фокусированные и детерминированные результаты. Мы рекомендуем изменять это или Top P, но не оба значения одновременно.

- **com_endpoint_google_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p изменяет то, как модель выбирает токены для вывода. Токены выбираются из наиболее вероятных K (см. параметр topK) до наименее вероятных, пока сумма их вероятностей не достигнет значения top-p.

- **com_endpoint_google_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k изменяет то, как модель выбирает токены для вывода. Top-k равное 1 означает, что выбирается наиболее вероятный токен из всего словаря модели (так называемое жадное декодирование), а Top-k равное 3 означает, что следующий токен выбирается из трех наиболее вероятных токенов (с использованием температуры).

- **com_endpoint_google_maxoutputtokens**:
  - **english**:  	Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**:  	Максимальное количество токенов, которые могут быть сгенерированы в ответе. Укажите меньшее значение для более коротких ответов и большее значение для более длинных ответов.

- **com_endpoint_google_custom_name_placeholder**:
  - **english**: Set a custom name for Google
  - **translated**: Задайте кастомное имя для Google

- **com_endpoint_prompt_prefix_placeholder**:
  - **english**: Set custom instructions or context. Ignored if empty.
  - **translated**: Задайте пользовательские инструкции или контекст. Игнорируется, если пусто.

- **com_endpoint_custom_name**:
  - **english**: Custom Name
  - **translated**: Кастомное имя

- **com_endpoint_prompt_prefix**:
  - **english**: Custom Instructions
  - **translated**: Префикс промта

- **com_endpoint_temperature**:
  - **english**: Temperature
  - **translated**: Температура

- **com_endpoint_default**:
  - **english**: default
  - **translated**: по умолчанию

- **com_endpoint_top_p**:
  - **english**: Top P
  - **translated**: Top P

- **com_endpoint_top_k**:
  - **english**: Top K
  - **translated**: Top K

- **com_endpoint_max_output_tokens**:
  - **english**: Max Output Tokens
  - **translated**: Максимальное количество выводимых токенов

- **com_endpoint_openai_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: Более высокие значения = более случайные результаты, более низкие значения = более фокусированные и детерминированные результаты. Мы рекомендуем изменять это или Top P, но не оба значения одновременно.

- **com_endpoint_openai_max**:
  - **english**: The max tokens to generate. The total length of input tokens and generated tokens is limited by the model's context length.
  - **translated**: Максимальное количество генерируемых токенов. Общая длина входных токенов и сгенерированных токенов ограничена длиной контекста модели.

- **com_endpoint_openai_topp**:
  - **english**: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We recommend altering this or temperature but not both.
  - **translated**: Альтернатива выбору с использованием температуры, называемая выбором по ядру, при которой модель учитывает результаты токенов с наибольшей вероятностью top_p. Таким образом, значение 0,1 означает, что рассматриваются только токены, составляющие верхние 10% вероятностной массы. Мы рекомендуем изменять это или температуру, но не оба значения одновременно.

- **com_endpoint_openai_freq**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
  - **translated**: Число от -2.0 до 2.0. Положительные значения штрафуют новые токены на основе их частоты в тексте до сих пор, уменьшая вероятность модели повторить ту же строку дословно.

- **com_endpoint_openai_pres**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
  - **translated**: Число от -2.0 до 2.0. Положительные значения штрафуют новые токены на основе того, появляются ли они в тексте до сих пор, увеличивая вероятность модели говорить о новых темах.

- **com_endpoint_openai_custom_name_placeholder**:
  - **english**: Set a custom name for the AI
  - **translated**: Задайте кастомное имя для ChatGPT

- **com_endpoint_openai_prompt_prefix_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: Задайте кастомные промты для включения в системное сообщение. По умолчанию: нет

- **com_endpoint_anthropic_temp**:
  - **english**: Ranges from 0 to 1. Use temp closer to 0 for analytical / multiple choice, and closer to 1 for creative and generative tasks. We recommend altering this or Top P but not both.
  - **translated**: Диапазон значений от 0 до 1. Используйте значение temp ближе к 0 для аналитических / множественного выбора и ближе к 1 для креативных и генеративных задач. Мы рекомендуем изменять это или Top P, но не оба значения одновременно.

- **com_endpoint_anthropic_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top P изменяет то, как модель выбирает токены для вывода. Токены выбираются из наиболее вероятных (см. параметр topK) до наименее вероятных, пока сумма их вероятностей не достигнет значения top-p.

- **com_endpoint_anthropic_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top K изменяет то, как модель выбирает токены для вывода. Top K равное 1 означает, что выбирается наиболее вероятный токен из всего словаря модели (так называемое жадное декодирование), а Top K равное 3 означает, что следующий токен выбирается из трех наиболее вероятных токенов (с использованием температуры).

- **com_endpoint_anthropic_maxoutputtokens**:
  - **english**: Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: Максимальное количество токенов, которые могут быть сгенерированы в ответе. Укажите меньшее значение для более коротких ответов и большее значение для более длинных ответов.

- **com_endpoint_anthropic_custom_name_placeholder**:
  - **english**: Set a custom name for Anthropic
  - **translated**: Задайте кастомное имя для Anthropic

- **com_endpoint_frequency_penalty**:
  - **english**: Frequency Penalty
  - **translated**: Штраф за частоту

- **com_endpoint_presence_penalty**:
  - **english**: Presence Penalty
  - **translated**: Штраф за присутствие

- **com_endpoint_plug_use_functions**:
  - **english**: Use Functions
  - **translated**: Использовать функции

- **com_endpoint_plug_skip_completion**:
  - **english**: Skip Completion
  - **translated**: Пропустить завершение

- **com_endpoint_disabled_with_tools**:
  - **english**: disabled with tools
  - **translated**: отключено с плагинами

- **com_endpoint_disabled_with_tools_placeholder**:
  - **english**: Disabled with Tools Selected
  - **translated**: Отключено при включённых плагинах

- **com_endpoint_plug_set_custom_instructions_for_gpt_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: Задайте кастомные инструкции для включения в системное сообщение. По умолчанию: нет

- **com_endpoint_import**:
  - **english**: Import
  - **translated**: Импорт

- **com_endpoint_set_custom_name**:
  - **english**: Set a custom name, in case you can find this preset
  - **translated**: Задайте кастомное имя на случай, если вы сможете найти эту предустановку :)

- **com_endpoint_preset_delete_confirm**:
  - **english**: Are you sure you want to delete this preset?
  - **translated**: Вы уверены, что хотите удалить этот пресет?

- **com_endpoint_preset_clear_all_confirm**:
  - **english**: Are you sure you want to delete all of your presets?
  - **translated**: Вы уверены, что хотите удалить все ваши пресеты?

- **com_endpoint_preset_import**:
  - **english**: Preset Imported!
  - **translated**: Пресет Импортирован!

- **com_endpoint_preset_import_error**:
  - **english**: There was an error importing your preset. Please try again.
  - **translated**: Произошла ошибка при импорте вашего пресета. Пожалуйста, попробуйте еще раз.

- **com_endpoint_preset_save_error**:
  - **english**: There was an error saving your preset. Please try again.
  - **translated**: Произошла ошибка при сохранении вашего пресета. Пожалуйста, попробуйте еще раз.

- **com_endpoint_preset_delete_error**:
  - **english**: There was an error deleting your preset. Please try again.
  - **translated**: Произошла ошибка при удалении вашего пресета. Пожалуйста, попробуйте еще раз.

- **com_endpoint_preset_default_removed**:
  - **english**: is no longer the default preset.
  - **translated**: больше не пресет по умолчанию.

- **com_endpoint_preset_default_item**:
  - **english**: Default:
  - **translated**: По умолчанию:

- **com_endpoint_preset_default_none**:
  - **english**: No default preset active.
  - **translated**: Активных пресетов по умолчанию нет.

- **com_endpoint_preset_title**:
  - **english**: Preset
  - **translated**: Пресет

- **com_endpoint_preset_saved**:
  - **english**: Saved!
  - **translated**: Сохранено!

- **com_endpoint_preset_default**:
  - **english**: is now the default preset.
  - **translated**: теперь пресет По умолчаанию.

- **com_endpoint_preset**:
  - **english**: preset
  - **translated**: пресет

- **com_endpoint_presets**:
  - **english**: presets
  - **translated**: пресеты

- **com_endpoint_preset_selected**:
  - **english**: Preset Active!
  - **translated**: Пресет Активирован!

- **com_endpoint_preset_selected_title**:
  - **english**: Active!
  - **translated**: Активирован!

- **com_endpoint_preset_name**:
  - **english**: Preset Name
  - **translated**: Имя пресета

- **com_endpoint_new_topic**:
  - **english**: New Topic
  - **translated**: Новая тема

- **com_endpoint**:
  - **english**: Endpoint
  - **translated**: Эндпоинт

- **com_endpoint_hide**:
  - **english**: Hide
  - **translated**: Скрыть

- **com_endpoint_show**:
  - **english**: Show
  - **translated**: Показать

- **com_endpoint_examples**:
  - **english**:  Presets
  - **translated**: Примеры

- **com_endpoint_completion**:
  - **english**: Completion
  - **translated**: Завершение

- **com_endpoint_agent**:
  - **english**: Agent
  - **translated**: Агент

- **com_endpoint_show_what_settings**:
  - **english**: Show {0} Settings
  - **translated**: Показать настройки {0}

- **com_endpoint_export**:
  - **english**: Export
  - **translated**: Экспорт

- **com_endpoint_save_as_preset**:
  - **english**: Save As Preset
  - **translated**: Сохранить как Пресет

- **com_endpoint_presets_clear_warning**:
  - **english**: Are you sure you want to clear all presets? This is irreversible.
  - **translated**: Вы уверены, что хотите удалить все пресеты? Это действие необратимо и восстановление невозможно.

- **com_endpoint_not_implemented**:
  - **english**: Not implemented
  - **translated**: Не реализовано

- **com_endpoint_no_presets**:
  - **english**: No presets yet, use the settings button to create one
  - **translated**: Пока нет пресетов, используйте кнопку настроек чтобы создать его

- **com_endpoint_not_available**:
  - **english**: No endpoint available
  - **translated**: Нет доступных эндпоинтов

- **com_endpoint_view_options**:
  - **english**: View Options
  - **translated**: Просмотреть Настройки

- **com_endpoint_save_convo_as_preset**:
  - **english**: Save Conversation as Preset
  - **translated**: Сохранить текущий разговор как Пресет

- **com_endpoint_my_preset**:
  - **english**: My Preset
  - **translated**: Мой Пресет

- **com_endpoint_agent_model**:
  - **english**: Agent Model (Recommended: GPT-3.5)
  - **translated**: Модель агента (Рекомендуется: GPT-3.5)

- **com_endpoint_completion_model**:
  - **english**: Completion Model (Recommended: GPT-4)
  - **translated**: Модель завершения (Рекомендуется: GPT-4)

- **com_endpoint_func_hover**:
  - **english**: Enable use of Plugins as OpenAI Functions
  - **translated**: Включить использование плагинов как функции OpenAI

- **com_endpoint_skip_hover**:
  - **english**: Enable skipping the completion step, which reviews the final answer and generated steps
  - **translated**: Пропустить этап завершения, который проверяет окончательный ответ и сгенерированные шаги

- **com_endpoint_config_key**:
  - **english**: Set API Key
  - **translated**: Указать ключ к API

- **com_endpoint_config_placeholder**:
  - **english**: Set your Key in the Header menu to chat.
  - **translated**: Укажите ваш ключ к API в меню сверху для начала разговора.

- **com_endpoint_config_key_for**:
  - **english**: Set API Key for
  - **translated**: Установить ключ к API для

- **com_endpoint_config_key_name**:
  - **english**: Key
  - **translated**: Ключ

- **com_endpoint_config_value**:
  - **english**: Enter value for
  - **translated**: Введите значение для

- **com_endpoint_config_key_name_placeholder**:
  - **english**: Set API key first
  - **translated**: Сначала укажите ключ к API

- **com_endpoint_config_key_encryption**:
  - **english**: Your key will be encrypted and deleted at
  - **translated**: Ваш ключ зашифрован и будет удалён

- **com_endpoint_config_key_expiry**:
  - **english**: the expiry time
  - **translated**: срок действия

- **com_endpoint_config_click_here**:
  - **english**: Click Here
  - **translated**: Нажми Здесь

- **com_endpoint_config_google_service_key**:
  - **english**: Google Service Account Key
  - **translated**: Google Service Account Key

- **com_endpoint_config_google_cloud_platform**:
  - **english**: (from Google Cloud Platform)
  - **translated**: (из Google Cloud Platform)

- **com_endpoint_config_google_api_key**:
  - **english**: Google API Key
  - **translated**: Google API Key

- **com_endpoint_config_google_gemini_api**:
  - **english**: (Gemini API)
  - **translated**: (Gemini API)

- **com_endpoint_config_google_api_info**:
  - **english**: To get your Generative Language API key (for Gemini),
  - **translated**: Чтобы получить ключ к API Generative Language (для Gemini),

- **com_endpoint_config_key_import_json_key**:
  - **english**: Import Service Account JSON Key.
  - **translated**: Импортировать Service Account JSON Key.

- **com_endpoint_config_key_import_json_key_success**:
  - **english**: Successfully Imported Service Account JSON Key
  - **translated**: Успешно Импортирован Service Account JSON Key

- **com_endpoint_config_key_import_json_key_invalid**:
  - **english**: Invalid Service Account JSON Key, Did you import the correct file?
  - **translated**: Некорректный Service Account JSON Key, Вы импортировали верный файл?

- **com_endpoint_config_key_get_edge_key**:
  - **english**: To get your Access token for Bing, login to
  - **translated**: Чтобы получить ваш токен доступа к Bing, войдите в

- **com_endpoint_config_key_get_edge_key_dev_tool**:
  - **english**: Use dev tools or an extension while logged into the site to copy the content of the _U cookie. If this fails, follow these
  - **translated**: Пока вы на сайте, используйте dev tools или расширение чтобы скопировать содержимое куки _U. Если не получается, следуйте этим

- **com_endpoint_config_key_edge_instructions**:
  - **english**: instructions
  - **translated**: инструкциям

- **com_endpoint_config_key_edge_full_key_string**:
  - **english**: to provide the full cookie strings.
  - **translated**: чтобы получить все строки cookie.

- **com_endpoint_config_key_chatgpt**:
  - **english**: To get your Access token For ChatGPT 'Free Version', login to
  - **translated**: Чтобы получить токен доступа к "Бесплатной Версии" ChatGPT, войдите в

- **com_endpoint_config_key_chatgpt_then_visit**:
  - **english**: then visit
  - **translated**: затем посетите

- **com_endpoint_config_key_chatgpt_copy_token**:
  - **english**: Copy access token.
  - **translated**: Скопируйте токен доступа.

- **com_endpoint_config_key_google_need_to**:
  - **english**: You need to
  - **translated**: Вам нужно

- **com_endpoint_config_key_google_vertex_ai**:
  - **english**: Enable Vertex AI
  - **translated**: Активировать Vertex AI

- **com_endpoint_config_key_google_vertex_api**:
  - **english**: API on Google Cloud, then
  - **translated**: API в Google Cloud, после

- **com_endpoint_config_key_google_service_account**:
  - **english**: Create a Service Account
  - **translated**: Создать Service Account

- **com_endpoint_config_key_google_vertex_api_role**:
  - **english**: Make sure to click 'Create and Continue' to give at least the 'Vertex AI User' role. Lastly, create a JSON key to import here.
  - **translated**: Убедитесь что нажали на 'Create and Continue' чтобы получить как минимум 'Vertex AI User'. Наконец, создайте JSON-ключ чтобы импортировать его сюда.

- **com_nav_welcome_message**:
  - **english**: How can I help you today?
  - **translated**: Чем я могу помочь вам сегодня?

- **com_nav_auto_scroll**:
  - **english**: Auto-scroll to Newest on Open
  - **translated**: Автоматически проматывать к самым новым сообщениям при открытии

- **com_nav_hide_panel**:
  - **english**: Hide Right-most Side Panel
  - **translated**: Скрыть правую боковую панель

- **com_nav_modular_chat**:
  - **english**: Enable switching Endpoints mid-conversation
  - **translated**: Разрешить менять точки подключения в середине разговора

- **com_nav_latex_parsing**:
  - **english**: Parsing LaTeX in messages (may affect performance)
  - **translated**: Обработка LaTeX в сообщениях (может повлиять на производительность)

- **com_nav_plugin_store**:
  - **english**: Plugin store
  - **translated**: Магазин плагинов

- **com_nav_plugin_search**:
  - **english**: Search plugins
  - **translated**: Поиск плагинов

- **com_nav_plugin_auth_error**:
  - **english**: There was an error attempting to authenticate this plugin. Please try again.
  - **translated**: При попытке аутентификации этого плагина произошла ошибка. Пожалуйста, попробуйте еще раз.

- **com_nav_export_filename**:
  - **english**: Filename
  - **translated**: Имя файла

- **com_nav_export_filename_placeholder**:
  - **english**: Set the filename
  - **translated**: Задайте имя файла

- **com_nav_export_type**:
  - **english**: Type
  - **translated**: Тип

- **com_nav_export_include_endpoint_options**:
  - **english**: Include endpoint options
  - **translated**: Включить параметры эндпоинта

- **com_nav_enabled**:
  - **english**: Enabled
  - **translated**: Включено

- **com_nav_not_supported**:
  - **english**: Not Supported
  - **translated**: Не поддерживается

- **com_nav_export_all_message_branches**:
  - **english**: Export all message branches
  - **translated**: Экспортировать все ветки сообщений

- **com_nav_export_recursive_or_sequential**:
  - **english**: Recursive or sequential?
  - **translated**: Рекурсивно или последовательно?

- **com_nav_export_recursive**:
  - **english**: Recursive
  - **translated**: Рекурсивно

- **com_nav_export_conversation**:
  - **english**: Export conversation
  - **translated**: Экспортировать разговор

- **com_nav_my_files**:
  - **english**: My Files
  - **translated**: Мои файлы

- **com_nav_theme**:
  - **english**: Theme
  - **translated**: Тема

- **com_nav_theme_system**:
  - **english**: System
  - **translated**: Системная

- **com_nav_theme_dark**:
  - **english**: Dark
  - **translated**: Темная

- **com_nav_theme_light**:
  - **english**: Light
  - **translated**: Светлая

- **com_nav_user_name_display**:
  - **english**: Display username in messages
  - **translated**: Отображать имя пользователя в сообщениях

- **com_nav_language**:
  - **english**: Language
  - **translated**: Локализация

- **com_nav_setting_account**:
  - **english**: Account
  - **translated**: Аккаунт

- **com_nav_profile_picture**:
  - **english**: Profile Picture
  - **translated**: Изображение профиля

- **com_nav_change_picture**:
  - **english**: Change picture
  - **translated**: Изменить изображение

- **com_nav_lang_auto**:
  - **english**: Auto detect
  - **translated**: Автоопределение

- **com_nav_clear_all_chats**:
  - **english**: Clear all chats
  - **translated**: Удалить все чаты

- **com_nav_confirm_clear**:
  - **english**: Confirm Clear
  - **translated**: Подтвердить удаление

- **com_nav_close_sidebar**:
  - **english**: Close sidebar
  - **translated**: Закрыть боковую панель

- **com_nav_open_sidebar**:
  - **english**: Open sidebar
  - **translated**: Открыть боковую панель

- **com_nav_send_message**:
  - **english**: Send message
  - **translated**: Отправить сообщение

- **com_nav_log_out**:
  - **english**: Log out
  - **translated**: Выйти

- **com_nav_user**:
  - **english**: USER
  - **translated**: ПОЛЬЗОВАТЕЛЬ

- **com_nav_archived_chats**:
  - **english**: Archived chats
  - **translated**: Архивированные чаты

- **com_nav_archived_chats_manage**:
  - **english**: Manage
  - **translated**: Управление

- **com_nav_archived_chats_empty**:
  - **english**: You have no archived conversations.
  - **translated**: У вас нет архивированных разговоров.

- **com_nav_archive_all_chats**:
  - **english**: Archive all chats
  - **translated**: Архивировать все чаты

- **com_nav_archive_all**:
  - **english**: Archive all
  - **translated**: Архивировать все

- **com_nav_archive_name**:
  - **english**: Name
  - **translated**: Имя

- **com_nav_archive_created_at**:
  - **english**: DateCreated
  - **translated**: Дата создания

- **com_nav_clear_conversation**:
  - **english**: Clear conversations
  - **translated**: Удалить разговоры

- **com_nav_clear_conversation_confirm_message**:
  - **english**: Are you sure you want to clear all conversations? This is irreversible.
  - **translated**: Вы уверены, что хотите удалить все разговоры? Это действие нельзя отменить.

- **com_nav_help_faq**:
  - **english**: Help & FAQ
  - **translated**: Помощь и Вопросы

- **com_nav_settings**:
  - **english**: Settings
  - **translated**: Настройки

- **com_nav_search_placeholder**:
  - **english**: Search messages
  - **translated**: Поиск сообщений

- **com_nav_setting_general**:
  - **english**: General
  - **translated**: Общие

- **com_nav_setting_beta**:
  - **english**: Beta features
  - **translated**: Бета-функции

- **com_nav_setting_data**:
  - **english**: Data controls
  - **translated**: Управление данными

- **com_assistants_knowledge**:
  - **english**: Knowledge
  - **translated**: База знаний

- **com_assistants_knowledge_info**:
  - **english**: If you upload files under Knowledge, conversations with your Assistant may include file contents.
  - **translated**: Если вы загрузите файлы в раздел Знания, разговоры с вашим ассистентом могут включать содержимое файлов.

- **com_assistants_knowledge_disabled**:
  - **english**: Assistant must be created, and Code Interpreter or Retrieval must be enabled and saved before uploading files as Knowledge.
  - **translated**: Ассистент должен быть сохранён, и Интерпретатор кода (Code Interpreter) или Поиск (Retrieval) должны быть включены и сохранены перед загрузкой файлов к Базе Знаний.

- **com_assistants_retrieval**:
  - **english**: Retrieval
  - **translated**: Поиск (Retrieval)

- **com_assistants_name_placeholder**:
  - **english**: Optional: The name of the assistant
  - **translated**: Необязательно: имя ассистента

- **com_assistants_instructions_placeholder**:
  - **english**: The system instructions that the assistant uses
  - **translated**: Системные инструкции, которые использует ассистент

- **com_assistants_description_placeholder**:
  - **english**: Optional: Describe your Assistant here
  - **translated**: Необязательно: описание вашего ассистента

- **com_assistants_actions_disabled**:
  - **english**: You need to create an assistant before adding actions.
  - **translated**: Вам нужно сохранить ассистента, прежде чем добавлять Actions.

- **com_assistants_update_success**:
  - **english**: Successfully updated
  - **translated**: Успешно обновлено

- **com_assistants_update_error**:
  - **english**: There was an error updating your assistant.
  - **translated**: Произошла ошибка при обновлении вашего ассистента.

- **com_assistants_create_success**:
  - **english**: Successfully created
  - **translated**: Успешно сохранено

- **com_assistants_create_error**:
  - **english**: There was an error creating your assistant.
  - **translated**: Произошла ошибка при сохранении вашего ассистента.

- **com_ui_attach_error_type**:
  - **english**: Unsupported file type for endpoint:
  - **translated**: Неподдерживаемый тип файла для этого режима:

- **com_ui_attach_error_size**:
  - **english**: File size limit exceeded for endpoint:
  - **translated**: Превышен лимит размера файла для этого режима:

- **com_ui_attach_error**:
  - **english**: Cannot attach file. Create or select a conversation, or try refreshing the page.
  - **translated**: Невозможно прикрепить файл. Создайте новый или выберите разговор, или попробуйте обновить страницу.

- **com_ui_name**:
  - **english**: Name
  - **translated**: Имя

- **com_ui_instructions**:
  - **english**: Instructions
  - **translated**: Инструкции

- **com_ui_description**:
  - **english**: Description
  - **translated**: Описание

- **com_ui_error**:
  - **english**: Error
  - **translated**: Ошибка

- **com_ui_select**:
  - **english**: Select
  - **translated**: Выбрать

- **com_ui_upload_files**:
  - **english**: Upload files
  - **translated**: Загрузить файлы

- **com_ui_upload_error**:
  - **english**: There was an error uploading your file
  - **translated**: Произошла ошибка при загрузке вашего файла

- **com_user_message**:
  - **english**: You
  - **translated**: Вы

Please consider the above comparisons to enhance understanding and guide improvements in translations.

Provide insights or suggestions that could help refine the translation process, focusing on cultural and contextual relevance.

Please craft a prompt that can be used to better inform future translations to this language.

Write this prompt in the translated language, with all its nuances detected, not in the English.
