# Instructions for Translation

Write a prompt that is mindful of the nuances in the language with respect to its English counterpart, which serves as the baseline for translations. Here are the comparisons between the language translations and their English counterparts:


- **com_ui_examples**:
  - **english**: Examples
  - **translated**: Przykłady

- **com_ui_new_chat**:
  - **english**: New chat
  - **translated**: Nowy czat

- **com_ui_happy_birthday**:
  - **english**: It's my 1st birthday!
  - **translated**: To moje pierwsze urodziny!

- **com_ui_example_quantum_computing**:
  - **english**: Explain quantum computing in simple terms
  - **translated**: Wyjaśnij obliczenia kwantowe w prostych słowach

- **com_ui_example_10_year_old_b_day**:
  - **english**: Got any creative ideas for a 10 year old's birthday?
  - **translated**: Masz jakieś kreatywne pomysły na dziesiąte urodziny?

- **com_ui_example_http_in_js**:
  - **english**: How do I make an HTTP request in Javascript?
  - **translated**: Jak wykonać żądanie HTTP w JavaScript?

- **com_ui_capabilities**:
  - **english**: Capabilities
  - **translated**: Możliwości

- **com_ui_capability_remember**:
  - **english**: Remembers what user said earlier in the conversation
  - **translated**: Pamięta to, co użytkownik powiedział wcześniej w rozmowie

- **com_ui_capability_correction**:
  - **english**: Allows user to provide follow-up corrections
  - **translated**: Pozwala użytkownikowi wprowadzać poprawki do dalszej rozmowy

- **com_ui_capability_decline_requests**:
  - **english**: Trained to decline inappropriate requests
  - **translated**: Szkolony do odrzucania nieodpowiednich żądań

- **com_ui_limitations**:
  - **english**: Limitations
  - **translated**: Ograniczenia

- **com_ui_limitation_incorrect_info**:
  - **english**: May occasionally generate incorrect information
  - **translated**: Czasami może podać nieprawidłowe informacje

- **com_ui_limitation_harmful_biased**:
  - **english**: May occasionally produce harmful instructions or biased content
  - **translated**: Czasami może generować szkodliwe instrukcje lub stronniczą treść

- **com_ui_limitation_limited_2021**:
  - **english**: Limited knowledge of world and events after 2021
  - **translated**: Ograniczona świadomość świata i wydarzeń po roku 2021

- **com_ui_select_model**:
  - **english**: Select a model
  - **translated**: Wybierz model

- **com_ui_use_prompt**:
  - **english**: Use prompt
  - **translated**: Użyj podpowiedzi

- **com_ui_prev**:
  - **english**: Prev
  - **translated**: Poprzedni

- **com_ui_next**:
  - **english**: Next
  - **translated**: Następny

- **com_ui_prompt_templates**:
  - **english**: Prompt Templates
  - **translated**: Szablony podpowiedzi

- **com_ui_hide_prompt_templates**:
  - **english**: Hide Prompt Templates
  - **translated**: Ukryj szablony podpowiedzi

- **com_ui_showing**:
  - **english**: Showing
  - **translated**: Pokazuje

- **com_ui_of**:
  - **english**: of
  - **translated**: z

- **com_ui_entries**:
  - **english**: Entries
  - **translated**: wpisów

- **com_ui_pay_per_call**:
  - **english**: All AI conversations in one place. Pay per call and not per month
  - **translated**: Wszystkie rozmowy z AI w jednym miejscu. Płatność za połączenie, a nie za miesiąc

- **com_ui_rename**:
  - **english**: Rename
  - **translated**: Zmień nazwę

- **com_ui_archive**:
  - **english**: Archive
  - **translated**: Archiwum

- **com_ui_archive_error**:
  - **english**: Failed to archive conversation
  - **translated**: Nie udało się archiwizować rozmowy

- **com_ui_unarchive**:
  - **english**: Unarchive
  - **translated**: Przywróć z archiwum

- **com_ui_unarchive_error**:
  - **english**: Failed to unarchive conversation
  - **translated**: Nie udało się odtworzyć rozmowy z archiwum

- **com_ui_more_options**:
  - **english**: More
  - **translated**: Więcej

- **com_auth_error_login**:
  - **english**: Unable to login with the information provided. Please check your credentials and try again.
  - **translated**: Nie udało się zalogować przy użyciu podanych danych. Sprawdź swoje dane logowania i spróbuj ponownie.

- **com_auth_no_account**:
  - **english**: Don't have an account?
  - **translated**: Nie masz konta?

- **com_auth_sign_up**:
  - **english**: Sign up
  - **translated**: Zarejestruj się

- **com_auth_sign_in**:
  - **english**: Sign in
  - **translated**: Zaloguj się

- **com_auth_google_login**:
  - **english**: Continue with Google
  - **translated**: Zaloguj się przez Google

- **com_auth_facebook_login**:
  - **english**: Continue with Facebook
  - **translated**: Zaloguj się przez Facebooka

- **com_auth_github_login**:
  - **english**: Continue with Github
  - **translated**: Zaloguj się przez Githuba

- **com_auth_discord_login**:
  - **english**: Continue with Discord
  - **translated**: Zaloguj się przez Discorda

- **com_auth_email**:
  - **english**: Email
  - **translated**: Email

- **com_auth_email_required**:
  - **english**: Email is required
  - **translated**: Wymagane jest podanie adresu email.

- **com_auth_email_min_length**:
  - **english**: Email must be at least 6 characters
  - **translated**: Adres email musi mieć co najmniej 6 znaków.

- **com_auth_email_max_length**:
  - **english**: Email should not be longer than 120 characters
  - **translated**: Adres email nie może być dłuższy niż 120 znaków.

- **com_auth_email_pattern**:
  - **english**: You must enter a valid email address
  - **translated**: Wprowadź poprawny adres e-mail

- **com_auth_email_address**:
  - **english**: Email address
  - **translated**: Adres e-mail

- **com_auth_password**:
  - **english**: Password
  - **translated**: Hasło

- **com_auth_password_required**:
  - **english**: Password is required
  - **translated**: Wymagane jest podanie hasła

- **com_auth_password_min_length**:
  - **english**: Password must be at least 8 characters
  - **translated**: Hasło musi mieć co najmniej 8 znaków

- **com_auth_password_max_length**:
  - **english**: Password must be less than 128 characters
  - **translated**: Hasło musi mieć mniej niż 128 znaków

- **com_auth_password_forgot**:
  - **english**: Forgot Password?
  - **translated**: Zapomniałeś hasła?

- **com_auth_password_confirm**:
  - **english**: Confirm password
  - **translated**: Potwierdź hasło

- **com_auth_password_not_match**:
  - **english**: Passwords do not match
  - **translated**: Hasła nie są zgodne

- **com_auth_continue**:
  - **english**: Continue
  - **translated**: Kontynuuj

- **com_auth_create_account**:
  - **english**: Create your account
  - **translated**: Utwórz konto

- **com_auth_error_create**:
  - **english**: There was an error attempting to register your account. Please try again.
  - **translated**: Wystąpił błąd podczas tworzenia konta. Spróbuj ponownie.

- **com_auth_full_name**:
  - **english**: Full name
  - **translated**: Pełne imię

- **com_auth_name_required**:
  - **english**: Name is required
  - **translated**: Imię jest wymagane

- **com_auth_name_min_length**:
  - **english**: Name must be at least 3 characters
  - **translated**: Imię musi zawierać co najmniej 3 znaki

- **com_auth_name_max_length**:
  - **english**: Name must be less than 80 characters
  - **translated**: Imię nie może zawierać więcej niż 80 znaków

- **com_auth_username**:
  - **english**: Username (optional)
  - **translated**: Nazwa użytkownika (opcjonalnie)

- **com_auth_username_required**:
  - **english**: Username is required
  - **translated**: Nazwa użytkownika jest wymagana

- **com_auth_username_min_length**:
  - **english**: Username must be at least 2 characters
  - **translated**: Nazwa użytkownika musi zawierać co najmniej 2 znaki

- **com_auth_username_max_length**:
  - **english**: Username must be less than 20 characters
  - **translated**: Nazwa użytkownika nie może zawierać więcej niż 20 znaków

- **com_auth_already_have_account**:
  - **english**: Already have an account?
  - **translated**: Masz już konto?

- **com_auth_login**:
  - **english**: Login
  - **translated**: Zaloguj się

- **com_auth_reset_password**:
  - **english**: Reset your password
  - **translated**: Zresetuj hasło

- **com_auth_click**:
  - **english**: Click
  - **translated**: Kliknij

- **com_auth_here**:
  - **english**: HERE
  - **translated**: TUTAJ

- **com_auth_to_reset_your_password**:
  - **english**: to reset your password.
  - **translated**: aby zresetować hasło.

- **com_auth_reset_password_link_sent**:
  - **english**: Email Sent
  - **translated**: Link do resetowania hasła został wysłany

- **com_auth_reset_password_email_sent**:
  - **english**: An email has been sent to you with further instructions to reset your password.
  - **translated**: Na podany adres e-mail wysłano wiadomość z instrukcjami dotyczącymi resetowania hasła.

- **com_auth_error_reset_password**:
  - **english**: There was a problem resetting your password. There was no user found with the email address provided. Please try again.
  - **translated**: Wystąpił problem z resetowaniem hasła. Nie znaleziono użytkownika o podanym adresie e-mail. Spróbuj ponownie.

- **com_auth_reset_password_success**:
  - **english**: Password Reset Success
  - **translated**: Hasło zostało pomyślnie zresetowane

- **com_auth_login_with_new_password**:
  - **english**: You may now login with your new password.
  - **translated**: Teraz możesz zalogować się, używając nowego hasła.

- **com_auth_error_invalid_reset_token**:
  - **english**: This password reset token is no longer valid.
  - **translated**: Ten token do resetowania hasła jest już nieważny.

- **com_auth_click_here**:
  - **english**: Click here
  - **translated**: Kliknij tutaj

- **com_auth_to_try_again**:
  - **english**: to try again.
  - **translated**: aby spróbować ponownie.

- **com_auth_submit_registration**:
  - **english**: Submit registration
  - **translated**: Zarejestruj się

- **com_auth_welcome_back**:
  - **english**: Welcome back
  - **translated**: Witamy z powrotem

- **com_endpoint_open_menu**:
  - **english**: Open Menu
  - **translated**: Otwórz menu

- **com_endpoint_bing_enable_sydney**:
  - **english**: Enable Sydney
  - **translated**: Aktywuj Sydney

- **com_endpoint_bing_to_enable_sydney**:
  - **english**: To enable Sydney
  - **translated**: Aby aktywować Sydney

- **com_endpoint_bing_jailbreak**:
  - **english**: Jailbreak
  - **translated**: Odblokuj

- **com_endpoint_bing_context_placeholder**:
  - **english**: Bing can use up to 7k tokens for 'context', which it can reference for the conversation. The specific limit is not known but may run into errors exceeding 7k tokens
  - **translated**: Bing może użyć do 7k tokenów dla 'kontekstu', które mogą odnosić się do rozmowy.  Dokładny limit nie jest znany, ale przekroczenie 7 tysięcy tokenów może prowadzić do błędów.

- **com_endpoint_bing_system_message_placeholder**:
  - **english**: WARNING: Misuse of this feature can get you BANNED from using Bing! Click on 'System Message' for full instructions and the default message if omitted, which is the 'Sydney' preset that is considered safe.
  - **translated**: OSTRZEŻENIE: Nadużywanie tej funkcji może skutkować ZAKAZEM korzystania z Bing! Kliknij na 'Wiadomość systemowa' , aby uzyskać pełne instrukcje oraz domyślną wiadomość, jeśli zostanie pominięta, co jest predefiniowaną opcją 'Sydney', uważaną za bezpieczną.

- **com_endpoint_system_message**:
  - **english**: System Message
  - **translated**: Wiadomość systemowa

- **com_endpoint_default_blank**:
  - **english**: default: blank
  - **translated**: domyślnie: puste

- **com_endpoint_default_false**:
  - **english**: default: false
  - **translated**: domyślnie: fałsz

- **com_endpoint_default_creative**:
  - **english**: default: creative
  - **translated**: domyślnie: kreatywny

- **com_endpoint_default_empty**:
  - **english**: default: empty
  - **translated**: domyślnie: puste

- **com_endpoint_default_with_num**:
  - **english**: default: {0}
  - **translated**: domyślnie: {0}

- **com_endpoint_context**:
  - **english**: Context
  - **translated**: Kontekst

- **com_endpoint_tone_style**:
  - **english**: Tone Style
  - **translated**: Styl tonu

- **com_endpoint_token_count**:
  - **english**: Token count
  - **translated**: Liczba tokenów

- **com_endpoint_output**:
  - **english**: Output
  - **translated**: Wyjście

- **com_endpoint_google_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: Wyższe wartości oznaczają większą losowość, natomiast niższe wartości prowadzą do bardziej skoncentrowanych i deterministycznych wyników. Zalecamy dostosowanie tej wartości lub Top P, ale nie obu jednocześnie.

- **com_endpoint_google_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p wpływa na sposób, w jaki model wybiera tokeny do wygenerowania odpowiedzi. Tokeny są wybierane od najbardziej prawdopodobnych do najmniej, aż suma ich prawdopodobieństw osiągnie wartość top-p.

- **com_endpoint_google_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k wpływa na sposób, w jaki model wybiera tokeny do wygenerowania odpowiedzi. Top-k 1 oznacza, że wybrany token jest najbardziej prawdopodobny spośród wszystkich tokenów w słowniku modelu (nazywane też dekodowaniem zachłannym), podczas gdy top-k 3 oznacza, że następny token jest wybierany spośród 3 najbardziej prawdopodobnych tokenów (z uwzględnieniem temperatury).

- **com_endpoint_google_maxoutputtokens**:
  - **english**:  	Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: Maksymalna liczba tokenów, które mogą być wygenerowane w odpowiedzi. Wybierz niższą wartość dla krótszych odpowiedzi i wyższą wartość dla dłuższych odpowiedzi.

- **com_endpoint_google_custom_name_placeholder**:
  - **english**: Set a custom name for Google
  - **translated**: Ustaw niestandardową nazwę dla Google

- **com_endpoint_custom_name**:
  - **english**: Custom Name
  - **translated**: Niestandardowa nazwa

- **com_endpoint_prompt_prefix**:
  - **english**: Custom Instructions
  - **translated**: Prefiks promptu

- **com_endpoint_temperature**:
  - **english**: Temperature
  - **translated**: Temperatura

- **com_endpoint_default**:
  - **english**: default
  - **translated**: domyślnie

- **com_endpoint_top_p**:
  - **english**: Top P
  - **translated**: Top P

- **com_endpoint_top_k**:
  - **english**: Top K
  - **translated**: Top K

- **com_endpoint_max_output_tokens**:
  - **english**: Max Output Tokens
  - **translated**: Maksymalna liczba tokenów wyjściowych

- **com_endpoint_openai_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: Wyższe wartości oznaczają większą losowość, natomiast niższe wartości prowadzą do bardziej skoncentrowanych i deterministycznych wyników. Zalecamy dostosowanie tej wartości lub Top P, ale nie obu jednocześnie.

- **com_endpoint_openai_max**:
  - **english**: The max tokens to generate. The total length of input tokens and generated tokens is limited by the model's context length.
  - **translated**: Maksymalna liczba tokenów do wygenerowania. Łączna długość tokenów wejściowych i wygenerowanych tokenów jest ograniczona długością kontekstu modelu.

- **com_endpoint_openai_topp**:
  - **english**: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We recommend altering this or temperature but not both.
  - **translated**: Alternatywa dla próbkowania z temperaturą, nazywana próbkowaniem jądra, gdzie model rozważa wyniki tokenów z prawdopodobieństwem top_p. Przykładowo, 0,1 oznacza, że tylko tokeny składające się z 10% najwyższego prawdopodobieństwa są rozważane. Zalecamy dostosowanie tej wartości lub temperatury, ale nie obu jednocześnie.

- **com_endpoint_openai_freq**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
  - **translated**: Liczba pomiędzy -2,0 a 2,0. Dodatnie wartości karzą nowe tokeny w oparciu o ich dotychczasową częstotliwość występowania w tekście, co zmniejsza tendencję modelu do powtarzania tej samej linii dosłownie.

- **com_endpoint_openai_pres**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
  - **translated**: Liczba pomiędzy -2,0 a 2,0. Dodatnie wartości karzą nowe tokeny w oparciu o to, czy pojawiły się już w tekście, co zwiększa tendencję modelu do poruszania nowych tematów.

- **com_endpoint_openai_custom_name_placeholder**:
  - **english**: Set a custom name for the AI
  - **translated**: Ustaw własną nazwę dla ChatGPT

- **com_endpoint_openai_prompt_prefix_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: Ustaw własne instrukcje do umieszczenia w systemowej wiadomości. Domyślnie: brak

- **com_endpoint_anthropic_temp**:
  - **english**: Ranges from 0 to 1. Use temp closer to 0 for analytical / multiple choice, and closer to 1 for creative and generative tasks. We recommend altering this or Top P but not both.
  - **translated**: Zakres od 0 do 1. Użyj wartości bliżej 0 dla analizy/wyboru wielokrotnego, a bliżej 1 dla zadań twórczych i generatywnych. Zalecamy dostosowanie tej wartości lub Top P, ale nie obu jednocześnie.

- **com_endpoint_anthropic_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-P wpływa na sposób wyboru tokenów przez model. Tokeny wybierane są od najbardziej prawdopodobnych do najmniej prawdopodobnych, aż suma ich prawdopodobieństw osiągnie wartość top-P.

- **com_endpoint_anthropic_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-K wpływa na sposób wyboru tokenów przez model. Top-K równa 1 oznacza, że wybrany token jest najbardziej prawdopodobny spośród wszystkich tokenów w słowniku modelu (tzw. dekodowanie zachłanne), podczas gdy top-K równa 3 oznacza, że następny token zostaje wybrany spośród 3 najbardziej prawdopodobnych tokenów (za pomocą temperatury).

- **com_endpoint_anthropic_maxoutputtokens**:
  - **english**: Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: Maksymalna liczba tokenów, która może zostać wygenerowana w odpowiedzi. Wybierz mniejszą wartość dla krótszych odpowiedzi i większą wartość dla dłuższych odpowiedzi.

- **com_endpoint_frequency_penalty**:
  - **english**: Frequency Penalty
  - **translated**: Kara za częstotliwość

- **com_endpoint_presence_penalty**:
  - **english**: Presence Penalty
  - **translated**: Kara za obecność

- **com_endpoint_plug_use_functions**:
  - **english**: Use Functions
  - **translated**: Użyj funkcji

- **com_endpoint_plug_skip_completion**:
  - **english**: Skip Completion
  - **translated**: Pomiń uzupełnienie

- **com_endpoint_disabled_with_tools**:
  - **english**: disabled with tools
  - **translated**: wyłączony z narzędziami

- **com_endpoint_disabled_with_tools_placeholder**:
  - **english**: Disabled with Tools Selected
  - **translated**: Wyłączony z wybranymi narzędziami

- **com_endpoint_plug_set_custom_instructions_for_gpt_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: Ustaw własne instrukcje do umieszczenia w systemowej wiadomości. Domyślnie: brak

- **com_endpoint_set_custom_name**:
  - **english**: Set a custom name, in case you can find this preset
  - **translated**: Ustaw własną nazwę, w razie potrzeby odszukania tego ustawienia

- **com_endpoint_preset_name**:
  - **english**: Preset Name
  - **translated**: Nazwa ustawienia

- **com_endpoint_new_topic**:
  - **english**: New Topic
  - **translated**: Nowy temat

- **com_endpoint**:
  - **english**: Endpoint
  - **translated**: Punkt końcowy

- **com_endpoint_hide**:
  - **english**: Hide
  - **translated**: Ukryj

- **com_endpoint_show**:
  - **english**: Show
  - **translated**: Pokaż

- **com_endpoint_examples**:
  - **english**:  Presets
  - **translated**: Przykłady

- **com_endpoint_completion**:
  - **english**: Completion
  - **translated**: Uzupełnienie

- **com_endpoint_agent**:
  - **english**: Agent
  - **translated**: Agent

- **com_endpoint_show_what_settings**:
  - **english**: Show {0} Settings
  - **translated**: Pokaż ustawienia {0}

- **com_endpoint_export**:
  - **english**: Export
  - **translated**: Eksportuj

- **com_endpoint_save_as_preset**:
  - **english**: Save As Preset
  - **translated**: Zapisz jako predefiniowane ustawienie

- **com_endpoint_not_implemented**:
  - **english**: Not implemented
  - **translated**: Nie zaimplementowano

- **com_endpoint_no_presets**:
  - **english**: No presets yet, use the settings button to create one
  - **translated**: Brak zapisanych predefiniowanych ustawień

- **com_endpoint_not_available**:
  - **english**: No endpoint available
  - **translated**: Punkt końcowy niedostępny

- **com_endpoint_view_options**:
  - **english**: View Options
  - **translated**: Pokaż opcje

- **com_endpoint_save_convo_as_preset**:
  - **english**: Save Conversation as Preset
  - **translated**: Zapisz konwersację jako predefiniowane ustawienie

- **com_endpoint_my_preset**:
  - **english**: My Preset
  - **translated**: Moje predefiniowane ustawienie

- **com_endpoint_agent_model**:
  - **english**: Agent Model (Recommended: GPT-3.5)
  - **translated**: Model agenta (zalecany: GPT-3.5)

- **com_endpoint_completion_model**:
  - **english**: Completion Model (Recommended: GPT-4)
  - **translated**: Model uzupełnienia (zalecany: GPT-4)

- **com_endpoint_func_hover**:
  - **english**: Enable use of Plugins as OpenAI Functions
  - **translated**: Aktywuj wtyczki jako funkcje OpenAI

- **com_endpoint_skip_hover**:
  - **english**: Enable skipping the completion step, which reviews the final answer and generated steps
  - **translated**: Omijaj etap uzupełnienia sprawdzający ostateczną odpowiedź i generowane kroki

- **com_nav_plugin_store**:
  - **english**: Plugin store
  - **translated**: Sklep z wtyczkami

- **com_nav_plugin_search**:
  - **english**: Search plugins
  - **translated**: Wyszukiwanie wtyczek

- **com_nav_plugin_auth_error**:
  - **english**: There was an error attempting to authenticate this plugin. Please try again.
  - **translated**: Wystąpił błąd podczas próby uwierzytelnienia tej wtyczki. Proszę spróbować ponownie.

- **com_nav_export_filename**:
  - **english**: Filename
  - **translated**: Nazwa pliku

- **com_nav_export_filename_placeholder**:
  - **english**: Set the filename
  - **translated**: Podaj nazwę pliku

- **com_nav_export_type**:
  - **english**: Type
  - **translated**: Typ

- **com_nav_export_include_endpoint_options**:
  - **english**: Include endpoint options
  - **translated**: Dołącz opcje punktu końcowego

- **com_nav_enabled**:
  - **english**: Enabled
  - **translated**: Włączone

- **com_nav_not_supported**:
  - **english**: Not Supported
  - **translated**: Nieobsługiwane

- **com_nav_export_all_message_branches**:
  - **english**: Export all message branches
  - **translated**: Eksportuj wszystkie gałęzie wiadomości

- **com_nav_export_recursive_or_sequential**:
  - **english**: Recursive or sequential?
  - **translated**: Rekurencyjny czy sekwencyjny?

- **com_nav_export_recursive**:
  - **english**: Recursive
  - **translated**: Rekurencyjny

- **com_nav_export_conversation**:
  - **english**: Export conversation
  - **translated**: Eksportuj konwersację

- **com_nav_theme**:
  - **english**: Theme
  - **translated**: Motyw

- **com_nav_theme_system**:
  - **english**: System
  - **translated**: Domyślny

- **com_nav_theme_dark**:
  - **english**: Dark
  - **translated**: Ciemny

- **com_nav_theme_light**:
  - **english**: Light
  - **translated**: Jasny

- **com_nav_clear_all_chats**:
  - **english**: Clear all chats
  - **translated**: Usuń wszystkie konwersacje

- **com_nav_confirm_clear**:
  - **english**: Confirm Clear
  - **translated**: Potwierdź usunięcie

- **com_nav_close_sidebar**:
  - **english**: Close sidebar
  - **translated**: Zamknij pasek boczny

- **com_nav_open_sidebar**:
  - **english**: Open sidebar
  - **translated**: Otwórz pasek boczny

- **com_nav_send_message**:
  - **english**: Send message
  - **translated**: Wyślij wiadomość

- **com_nav_log_out**:
  - **english**: Log out
  - **translated**: Wyloguj

- **com_nav_user**:
  - **english**: USER
  - **translated**: Użytkownik

- **com_nav_archived_chats**:
  - **english**: Archived chats
  - **translated**: Zarchiwizowane rozmowy

- **com_nav_archived_chats_manage**:
  - **english**: Manage
  - **translated**: Zarządzaj

- **com_nav_archived_chats_empty**:
  - **english**: You have no archived conversations.
  - **translated**: Nie masz żadnych zarchiwizowanych rozmów.

- **com_nav_archive_all_chats**:
  - **english**: Archive all chats
  - **translated**: Archiwizuj wszystkie rozmowy

- **com_nav_archive_all**:
  - **english**: Archive all
  - **translated**: Archiwizuj wszystkie

- **com_nav_archive_name**:
  - **english**: Name
  - **translated**: Nazwa

- **com_nav_archive_created_at**:
  - **english**: DateCreated
  - **translated**: Utworzono

- **com_nav_clear_conversation**:
  - **english**: Clear conversations
  - **translated**: Wyczyść rozmowę

- **com_nav_clear_conversation_confirm_message**:
  - **english**: Are you sure you want to clear all conversations? This is irreversible.
  - **translated**: Czy na pewno chcesz usunąć wszystkie konwersacje? Tej operacji nie można cofnąć.

- **com_nav_help_faq**:
  - **english**: Help & FAQ
  - **translated**: Pomoc i często zadawane pytania

- **com_nav_settings**:
  - **english**: Settings
  - **translated**: Ustawienia

- **com_nav_search_placeholder**:
  - **english**: Search messages
  - **translated**: Szukaj wiadomości

- **com_nav_setting_general**:
  - **english**: General
  - **translated**: Ogólne

- **com_ui_import_conversation**:
  - **english**: Import
  - **translated**: Importuj

- **com_ui_import_conversation_info**:
  - **english**: Import conversations from a JSON file
  - **translated**: Importuj konwersacje z pliku JSON

- **com_ui_import_conversation_success**:
  - **english**: Conversations imported successfully
  - **translated**: Konwersacje zostały pomyślnie zaimportowane

- **com_ui_import_conversation_error**:
  - **english**: There was an error importing your conversations
  - **translated**: Wystąpił błąd podczas importowania konwersacji

Please consider the above comparisons to enhance understanding and guide improvements in translations.

Provide insights or suggestions that could help refine the translation process, focusing on cultural and contextual relevance.

Please craft a prompt that can be used to better inform future translations to this language.

Write this prompt in the translated language, with all its nuances detected, not in the English.
