# Instructions for Translation

Write a prompt that is mindful of the nuances in the language with respect to its English counterpart, which serves as the baseline for translations. Here are the comparisons between the language translations and their English counterparts:


- **com_ui_examples**:
  - **english**: Examples
  - **translated**: Voorbeelden

- **com_ui_new_chat**:
  - **english**: New chat
  - **translated**: Nieuwe chat

- **com_ui_happy_birthday**:
  - **english**: It's my 1st birthday!
  - **translated**: Het is mijn eerste verjaardag!

- **com_ui_example_quantum_computing**:
  - **english**: Explain quantum computing in simple terms
  - **translated**: Leg quantumcomputing in eenvoudige termen uit

- **com_ui_example_10_year_old_b_day**:
  - **english**: Got any creative ideas for a 10 year old's birthday?
  - **translated**: Heb je creatieve ideeën voor de verjaardag van een 10-jarige?

- **com_ui_example_http_in_js**:
  - **english**: How do I make an HTTP request in Javascript?
  - **translated**: Hoe maak ik een HTTP-aanvraag in Javascript?

- **com_ui_capabilities**:
  - **english**: Capabilities
  - **translated**: Mogelijkheden

- **com_ui_capability_remember**:
  - **english**: Remembers what user said earlier in the conversation
  - **translated**: Onthoudt wat de gebruiker eerder in het gesprek heeft gezegd

- **com_ui_capability_correction**:
  - **english**: Allows user to provide follow-up corrections
  - **translated**: Staat de gebruiker toe om vervolgcorrigeringen te geven

- **com_ui_capability_decline_requests**:
  - **english**: Trained to decline inappropriate requests
  - **translated**: Getraind om ongepaste verzoeken te weigeren

- **com_ui_limitations**:
  - **english**: Limitations
  - **translated**: Beperkingen

- **com_ui_limitation_incorrect_info**:
  - **english**: May occasionally generate incorrect information
  - **translated**: Kan af en toe onjuiste informatie genereren

- **com_ui_limitation_harmful_biased**:
  - **english**: May occasionally produce harmful instructions or biased content
  - **translated**: Kan af en toe schadelijke instructies of bevooroordeelde inhoud produceren

- **com_ui_limitation_limited_2021**:
  - **english**: Limited knowledge of world and events after 2021
  - **translated**: Beperkte kennis van de wereld en gebeurtenissen na 2021

- **com_ui_input**:
  - **english**: Input
  - **translated**: Invoer

- **com_ui_close**:
  - **english**: Close
  - **translated**: Sluiten

- **com_ui_model**:
  - **english**: Model
  - **translated**: Model

- **com_ui_select_model**:
  - **english**: Select a model
  - **translated**: Selecteer een model

- **com_ui_use_prompt**:
  - **english**: Use prompt
  - **translated**: Gebruik prompt

- **com_ui_prev**:
  - **english**: Prev
  - **translated**: Vorige

- **com_ui_next**:
  - **english**: Next
  - **translated**: Volgende

- **com_ui_stop**:
  - **english**: Stop
  - **translated**: Stop

- **com_ui_prompt_templates**:
  - **english**: Prompt Templates
  - **translated**: Prompt-sjablonen

- **com_ui_hide_prompt_templates**:
  - **english**: Hide Prompt Templates
  - **translated**: Prompt-sjablonen verbergen

- **com_ui_showing**:
  - **english**: Showing
  - **translated**: Tonen

- **com_ui_of**:
  - **english**: of
  - **translated**: van

- **com_ui_entries**:
  - **english**: Entries
  - **translated**: Items

- **com_ui_pay_per_call**:
  - **english**: All AI conversations in one place. Pay per call and not per month
  - **translated**: Alle AI-gesprekken op één plek. Betaal per gesprek en niet per maand

- **com_ui_new_footer**:
  - **english**: All AI conversations in one place.
  - **translated**: Alle AI-gesprekken op één plek.

- **com_ui_enter**:
  - **english**: Enter
  - **translated**: Invoeren

- **com_ui_submit**:
  - **english**: Submit
  - **translated**: Indienen

- **com_ui_upload_success**:
  - **english**: Successfully uploaded file
  - **translated**: Bestand succesvol geüpload

- **com_ui_upload_invalid**:
  - **english**: Invalid file for upload. Must be an image not exceeding 2 MB
  - **translated**: Ongeldig bestand voor uploaden

- **com_ui_cancel**:
  - **english**: Cancel
  - **translated**: Annuleren

- **com_ui_save**:
  - **english**: Save
  - **translated**: Opslaan

- **com_ui_copy_to_clipboard**:
  - **english**: Copy to clipboard
  - **translated**: Kopiëren naar klembord

- **com_ui_copied_to_clipboard**:
  - **english**: Copied to clipboard
  - **translated**: Gekopieerd naar klembord

- **com_ui_regenerate**:
  - **english**: Regenerate
  - **translated**: Opnieuw genereren

- **com_ui_continue**:
  - **english**: Continue
  - **translated**: Doorgaan

- **com_ui_edit**:
  - **english**: Edit
  - **translated**: Bewerken

- **com_ui_success**:
  - **english**: Success
  - **translated**: Succes

- **com_ui_all**:
  - **english**: all
  - **translated**: alle

- **com_ui_clear**:
  - **english**: Clear
  - **translated**: Wissen

- **com_ui_revoke**:
  - **english**: Revoke
  - **translated**: Intrekken

- **com_ui_revoke_info**:
  - **english**: Revoke all user provided credentials
  - **translated**: Trek alle door de gebruiker verstrekte referenties in

- **com_ui_import_conversation**:
  - **english**: Import
  - **translated**: Importeren

- **com_ui_import_conversation_info**:
  - **english**: Import conversations from a JSON file
  - **translated**: Gesprekken importeren vanuit een JSON-bestand

- **com_ui_import_conversation_success**:
  - **english**: Conversations imported successfully
  - **translated**: Gesprekken succesvol geïmporteerd

- **com_ui_import_conversation_error**:
  - **english**: There was an error importing your conversations
  - **translated**: Er is een fout opgetreden bij het importeren van je gesprekken

- **com_ui_confirm_action**:
  - **english**: Confirm Action
  - **translated**: Bevestig actie

- **com_ui_chats**:
  - **english**: chats
  - **translated**: chats

- **com_ui_delete**:
  - **english**: Delete
  - **translated**: Verwijderen

- **com_ui_delete_conversation**:
  - **english**: Delete chat?
  - **translated**: Chat verwijderen?

- **com_ui_delete_confirm**:
  - **english**: This will delete
  - **translated**: Hiermee wordt

- **com_ui_rename**:
  - **english**: Rename
  - **translated**: Hernoemen

- **com_ui_archive**:
  - **english**: Archive
  - **translated**: Archiveren

- **com_ui_archive_error**:
  - **english**: Failed to archive conversation
  - **translated**: Kan conversatie niet archiveren

- **com_ui_unarchive**:
  - **english**: Unarchive
  - **translated**: Uit archiveren

- **com_ui_unarchive_error**:
  - **english**: Failed to unarchive conversation
  - **translated**: Kan conversatie niet uit archiveren

- **com_ui_more_options**:
  - **english**: More
  - **translated**: Meer

- **com_auth_error_login**:
  - **english**: Unable to login with the information provided. Please check your credentials and try again.
  - **translated**: Kan niet inloggen met de verstrekte informatie. Controleer uw referenties en probeer het opnieuw.

- **com_auth_error_login_rl**:
  - **english**: Too many login attempts in a short amount of time. Please try again later.
  - **translated**: Te veel inlogpogingen in een korte tijd. Probeer het later nog eens.

- **com_auth_error_login_ban**:
  - **english**: Your account has been temporarily banned due to violations of our service.
  - **translated**: Uw account is tijdelijk verbannen vanwege schendingen van onze service.

- **com_auth_error_login_server**:
  - **english**: There was an internal server error. Please wait a few moments and try again.
  - **translated**: Er was een interne serverfout. Wacht een paar momenten en probeer het opnieuw.

- **com_auth_no_account**:
  - **english**: Don't have an account?
  - **translated**: Heb je geen account?

- **com_auth_sign_up**:
  - **english**: Sign up
  - **translated**: Aanmelden

- **com_auth_sign_in**:
  - **english**: Sign in
  - **translated**: Inloggen

- **com_auth_google_login**:
  - **english**: Continue with Google
  - **translated**: Inloggen met Google

- **com_auth_facebook_login**:
  - **english**: Continue with Facebook
  - **translated**: Inloggen met Facebook

- **com_auth_github_login**:
  - **english**: Continue with Github
  - **translated**: Inloggen met Github

- **com_auth_discord_login**:
  - **english**: Continue with Discord
  - **translated**: Inloggen met Discord

- **com_auth_email**:
  - **english**: Email
  - **translated**: E-mailadres

- **com_auth_email_required**:
  - **english**: Email is required
  - **translated**: E-mailadres is verplicht

- **com_auth_email_min_length**:
  - **english**: Email must be at least 6 characters
  - **translated**: E-mailadres moet minstens 6 tekens bevatten

- **com_auth_email_max_length**:
  - **english**: Email should not be longer than 120 characters
  - **translated**: E-mailadres mag niet langer zijn dan 120 tekens

- **com_auth_email_pattern**:
  - **english**: You must enter a valid email address
  - **translated**: Je moet een geldig e-mailadres invoeren

- **com_auth_email_address**:
  - **english**: Email address
  - **translated**: E-mailadres

- **com_auth_password**:
  - **english**: Password
  - **translated**: Wachtwoord

- **com_auth_password_required**:
  - **english**: Password is required
  - **translated**: Wachtwoord is verplicht

- **com_auth_password_min_length**:
  - **english**: Password must be at least 8 characters
  - **translated**: Wachtwoord moet minstens 8 tekens bevatten

- **com_auth_password_max_length**:
  - **english**: Password must be less than 128 characters
  - **translated**: Wachtwoord moet minder dan 128 tekens bevatten

- **com_auth_password_forgot**:
  - **english**: Forgot Password?
  - **translated**: Wachtwoord vergeten?

- **com_auth_password_confirm**:
  - **english**: Confirm password
  - **translated**: Bevestig wachtwoord

- **com_auth_password_not_match**:
  - **english**: Passwords do not match
  - **translated**: Wachtwoorden komen niet overeen

- **com_auth_continue**:
  - **english**: Continue
  - **translated**: Doorgaan

- **com_auth_create_account**:
  - **english**: Create your account
  - **translated**: Maak uw account aan

- **com_auth_error_create**:
  - **english**: There was an error attempting to register your account. Please try again.
  - **translated**: Er is een fout opgetreden bij het registreren van uw account. Probeer het opnieuw.

- **com_auth_full_name**:
  - **english**: Full name
  - **translated**: Volledige naam

- **com_auth_name_required**:
  - **english**: Name is required
  - **translated**: Naam is verplicht

- **com_auth_name_min_length**:
  - **english**: Name must be at least 3 characters
  - **translated**: Naam moet minstens 3 tekens bevatten

- **com_auth_name_max_length**:
  - **english**: Name must be less than 80 characters
  - **translated**: Naam mag niet langer zijn dan 80 tekens

- **com_auth_username**:
  - **english**: Username (optional)
  - **translated**: Gebruikersnaam (optioneel)

- **com_auth_username_required**:
  - **english**: Username is required
  - **translated**: Gebruikersnaam is verplicht

- **com_auth_username_min_length**:
  - **english**: Username must be at least 2 characters
  - **translated**: Gebruikersnaam moet minstens 2 tekens bevatten

- **com_auth_username_max_length**:
  - **english**: Username must be less than 20 characters
  - **translated**: Gebruikersnaam mag niet langer zijn dan 20 tekens

- **com_auth_already_have_account**:
  - **english**: Already have an account?
  - **translated**: Heb je al een account?

- **com_auth_login**:
  - **english**: Login
  - **translated**: Inloggen

- **com_auth_reset_password**:
  - **english**: Reset your password
  - **translated**: Stel uw wachtwoord opnieuw in

- **com_auth_click**:
  - **english**: Click
  - **translated**: Klik

- **com_auth_here**:
  - **english**: HERE
  - **translated**: HIER

- **com_auth_to_reset_your_password**:
  - **english**: to reset your password.
  - **translated**: om uw wachtwoord opnieuw in te stellen.

- **com_auth_reset_password_link_sent**:
  - **english**: Email Sent
  - **translated**: E-mail verzonden

- **com_auth_reset_password_email_sent**:
  - **english**: An email has been sent to you with further instructions to reset your password.
  - **translated**: Er is een e-mail naar je verzonden met verdere instructies om je wachtwoord opnieuw in te stellen.

- **com_auth_error_reset_password**:
  - **english**: There was a problem resetting your password. There was no user found with the email address provided. Please try again.
  - **translated**: Er was een probleem met het opnieuw instellen van uw wachtwoord. Er is geen gebruiker gevonden met het opgegeven e-mailadres. Probeer het opnieuw.

- **com_auth_reset_password_success**:
  - **english**: Password Reset Success
  - **translated**: Wachtwoord opnieuw ingesteld

- **com_auth_login_with_new_password**:
  - **english**: You may now login with your new password.
  - **translated**: Je kunt nu inloggen met je nieuwe wachtwoord.

- **com_auth_error_invalid_reset_token**:
  - **english**: This password reset token is no longer valid.
  - **translated**: Dit wachtwoord resettoken is niet langer geldig.

- **com_auth_click_here**:
  - **english**: Click here
  - **translated**: Klik hier

- **com_auth_to_try_again**:
  - **english**: to try again.
  - **translated**: om het opnieuw te proberen.

- **com_auth_submit_registration**:
  - **english**: Submit registration
  - **translated**: Registratie indienen

- **com_auth_welcome_back**:
  - **english**: Welcome back
  - **translated**: Welkom terug

- **com_endpoint_open_menu**:
  - **english**: Open Menu
  - **translated**: Open menu

- **com_endpoint_bing_enable_sydney**:
  - **english**: Enable Sydney
  - **translated**: Schakel Sydney in

- **com_endpoint_bing_to_enable_sydney**:
  - **english**: To enable Sydney
  - **translated**: Om Sydney in te schakelen

- **com_endpoint_bing_jailbreak**:
  - **english**: Jailbreak
  - **translated**: Jailbreak

- **com_endpoint_bing_context_placeholder**:
  - **english**: Bing can use up to 7k tokens for 'context', which it can reference for the conversation. The specific limit is not known but may run into errors exceeding 7k tokens
  - **translated**: Bing kan maximaal 7k tokens voor 'context' gebruiken, waarnaar het kan verwijzen voor het gesprek. De specifieke limiet is niet bekend, maar kan fouten opleveren bij meer dan 7k tokens

- **com_endpoint_bing_system_message_placeholder**:
  - **english**: WARNING: Misuse of this feature can get you BANNED from using Bing! Click on 'System Message' for full instructions and the default message if omitted, which is the 'Sydney' preset that is considered safe.
  - **translated**: WAARSCHUWING: Misbruik van deze functie kan ertoe leiden dat je VERBANNEN wordt van het gebruik van Bing! Klik op 'Systeembericht' voor volledige instructies en het standaardbericht indien weggelaten, wat de 'Sydney'-voorinstelling is die veilig wordt geacht.

- **com_endpoint_system_message**:
  - **english**: System Message
  - **translated**: Systeembericht

- **com_endpoint_default_blank**:
  - **english**: default: blank
  - **translated**: standaard: leeg

- **com_endpoint_default_false**:
  - **english**: default: false
  - **translated**: standaard: onwaar

- **com_endpoint_default_creative**:
  - **english**: default: creative
  - **translated**: standaard: creatief

- **com_endpoint_default_empty**:
  - **english**: default: empty
  - **translated**: standaard: leeg

- **com_endpoint_default_with_num**:
  - **english**: default: {0}
  - **translated**: standaard: {0}

- **com_endpoint_context**:
  - **english**: Context
  - **translated**: Context

- **com_endpoint_tone_style**:
  - **english**: Tone Style
  - **translated**: Toonstijl

- **com_endpoint_token_count**:
  - **english**: Token count
  - **translated**: Aantal tokens

- **com_endpoint_output**:
  - **english**: Output
  - **translated**: Uitvoer

- **com_endpoint_google_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: Hogere waarden = meer willekeurig, terwijl lagere waarden = meer gericht en deterministisch. We raden aan dit of Top P te wijzigen, maar niet beide.

- **com_endpoint_google_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p verandert hoe het model tokens selecteert voor uitvoer. Tokens worden geselecteerd van meest K (zie topK-parameter) waarschijnlijk tot minst waarschijnlijk totdat de som van hun kansen gelijk is aan de top-p-waarde.

- **com_endpoint_google_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k verandert hoe het model tokens selecteert voor uitvoer. Een top-k van 1 betekent dat het geselecteerde token het meest waarschijnlijk is van alle tokens in de vocabulaire van het model (ook wel 'greedy decoding' genoemd), terwijl een top-k van 3 betekent dat het volgende token wordt geselecteerd uit de 3 meest waarschijnlijke tokens (met behulp van temperatuur).

- **com_endpoint_google_maxoutputtokens**:
  - **english**:  	Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: 	Maximum aantal tokens dat kan worden gegenereerd in de reactie. Geef een lagere waarde op voor kortere reacties en een hogere waarde voor langere reacties.

- **com_endpoint_google_custom_name_placeholder**:
  - **english**: Set a custom name for Google
  - **translated**: Stel een aangepaste naam in voor Google

- **com_endpoint_prompt_prefix_placeholder**:
  - **english**: Set custom instructions or context. Ignored if empty.
  - **translated**: Stel aangepaste instructies of context in. Wordt genegeerd indien leeg.

- **com_endpoint_custom_name**:
  - **english**: Custom Name
  - **translated**: Aangepaste naam

- **com_endpoint_prompt_prefix**:
  - **english**: Custom Instructions
  - **translated**: Prompt-voorvoegsel

- **com_endpoint_temperature**:
  - **english**: Temperature
  - **translated**: Temperatuur

- **com_endpoint_default**:
  - **english**: default
  - **translated**: standaard

- **com_endpoint_top_p**:
  - **english**: Top P
  - **translated**: Top P

- **com_endpoint_top_k**:
  - **english**: Top K
  - **translated**: Top K

- **com_endpoint_max_output_tokens**:
  - **english**: Max Output Tokens
  - **translated**: Max. uitvoertokens

- **com_endpoint_openai_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: Hogere waarden = meer willekeurig, terwijl lagere waarden = meer gericht en deterministisch. We raden aan dit of Top P te wijzigen, maar niet beide.

- **com_endpoint_openai_max**:
  - **english**: The max tokens to generate. The total length of input tokens and generated tokens is limited by the model's context length.
  - **translated**: Het max. aantal tokens dat kan worden gegenereerd. De totale lengte van invoer-tokens en gegenereerde tokens is beperkt door de contextlengte van het model.

- **com_endpoint_openai_topp**:
  - **english**: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We recommend altering this or temperature but not both.
  - **translated**: Een alternatief voor sampling met temperatuur, genaamd nucleus sampling, waarbij het model de resultaten van de tokens met de top_p waarschijnlijkheidsmassa in overweging neemt. Dus 0,1 betekent dat alleen de tokens die de bovenste 10% waarschijnlijkheidsmassa omvatten, in overweging worden genomen. We raden aan dit of temperatuur te wijzigen, maar niet beide.

- **com_endpoint_openai_freq**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
  - **translated**: Getal tussen -2,0 en 2,0. Positieve waarden straffen nieuwe tokens op basis van hun bestaande frequentie in de tekst tot nu toe, waardoor de kans dat het model dezelfde regel letterlijk herhaalt, afneemt.

- **com_endpoint_openai_pres**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
  - **translated**: Getal tussen -2,0 en 2,0. Positieve waarden straffen nieuwe tokens op basis van of ze al voorkomen in de tekst tot nu toe, waardoor de kans dat het model over nieuwe onderwerpen praat toeneemt.

- **com_endpoint_openai_custom_name_placeholder**:
  - **english**: Set a custom name for the AI
  - **translated**: Stel een aangepaste naam in voor ChatGPT

- **com_endpoint_openai_prompt_prefix_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: Stel aangepaste instructies in om op te nemen in Systeembericht. Standaard: geen

- **com_endpoint_anthropic_temp**:
  - **english**: Ranges from 0 to 1. Use temp closer to 0 for analytical / multiple choice, and closer to 1 for creative and generative tasks. We recommend altering this or Top P but not both.
  - **translated**: Varieert van 0 tot 1. Gebruik een lagere temp voor analytische / meerkeuze taken en een hogere temp voor creatieve en generatieve taken. We raden aan dit of Top P te wijzigen, maar niet beide.

- **com_endpoint_anthropic_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p verandert hoe het model tokens selecteert voor uitvoer. Tokens worden geselecteerd van meest K (zie topK-parameter) waarschijnlijk tot minst waarschijnlijk totdat de som van hun kansen gelijk is aan de top-p-waarde.

- **com_endpoint_anthropic_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k verandert hoe het model tokens selecteert voor uitvoer. Een top-k van 1 betekent dat het geselecteerde token het meest waarschijnlijk is van alle tokens in de vocabulaire van het model (ook wel 'greedy decoding' genoemd), terwijl een top-k van 3 betekent dat het volgende token wordt geselecteerd uit de 3 meest waarschijnlijke tokens (met behulp van temperatuur).

- **com_endpoint_anthropic_maxoutputtokens**:
  - **english**: Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: Maximum aantal tokens dat kan worden gegenereerd in de reactie. Geef een lagere waarde op voor kortere reacties en een hogere waarde voor langere reacties.

- **com_endpoint_anthropic_custom_name_placeholder**:
  - **english**: Set a custom name for Anthropic
  - **translated**: Stel een aangepaste naam in voor Anthropic

- **com_endpoint_frequency_penalty**:
  - **english**: Frequency Penalty
  - **translated**: Frequentiestraf

- **com_endpoint_presence_penalty**:
  - **english**: Presence Penalty
  - **translated**: Aanwezigheidsstraf

- **com_endpoint_plug_use_functions**:
  - **english**: Use Functions
  - **translated**: Gebruik functies inschakelen

- **com_endpoint_plug_skip_completion**:
  - **english**: Skip Completion
  - **translated**: Voltooiing overslaan

- **com_endpoint_disabled_with_tools**:
  - **english**: disabled with tools
  - **translated**: uitgeschakeld met tools

- **com_endpoint_disabled_with_tools_placeholder**:
  - **english**: Disabled with Tools Selected
  - **translated**: Uitgeschakeld met geselecteerde tools

- **com_endpoint_plug_set_custom_instructions_for_gpt_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: Stel aangepaste instructies in om op te nemen in Systeembericht. Standaard: geen

- **com_endpoint_import**:
  - **english**: Import
  - **translated**: Importeren

- **com_endpoint_set_custom_name**:
  - **english**: Set a custom name, in case you can find this preset
  - **translated**: Stel een aangepaste naam in, voor het geval je deze voorinstelling kunt vinden

- **com_endpoint_preset**:
  - **english**: preset
  - **translated**: voorinstelling

- **com_endpoint_presets**:
  - **english**: presets
  - **translated**: voorinstellingen

- **com_endpoint_preset_selected**:
  - **english**: Preset Active!
  - **translated**: Voorinstelling actief!

- **com_endpoint_preset_name**:
  - **english**: Preset Name
  - **translated**: Naam voorinstelling

- **com_endpoint_new_topic**:
  - **english**: New Topic
  - **translated**: Nieuw onderwerp

- **com_endpoint**:
  - **english**: Endpoint
  - **translated**: Eindpunt

- **com_endpoint_hide**:
  - **english**: Hide
  - **translated**: Verbergen

- **com_endpoint_show**:
  - **english**: Show
  - **translated**: Weergeven

- **com_endpoint_examples**:
  - **english**:  Presets
  - **translated**:  Voorinstellingen

- **com_endpoint_completion**:
  - **english**: Completion
  - **translated**: Voltooiing

- **com_endpoint_agent**:
  - **english**: Agent
  - **translated**: Agent

- **com_endpoint_show_what_settings**:
  - **english**: Show {0} Settings
  - **translated**: {0} instellingen weergeven

- **com_endpoint_export**:
  - **english**: Export
  - **translated**: Exporteren

- **com_endpoint_save_as_preset**:
  - **english**: Save As Preset
  - **translated**: Opslaan als voorinstelling

- **com_endpoint_presets_clear_warning**:
  - **english**: Are you sure you want to clear all presets? This is irreversible.
  - **translated**: Weet u zeker dat u alle voorinstellingen wilt wissen? Dit is onomkeerbaar.

- **com_endpoint_not_implemented**:
  - **english**: Not implemented
  - **translated**: Niet geïmplementeerd

- **com_endpoint_no_presets**:
  - **english**: No presets yet, use the settings button to create one
  - **translated**: Nog geen voorinstellingen, gebruik de instellingenknop om er een te maken

- **com_endpoint_not_available**:
  - **english**: No endpoint available
  - **translated**: Geen eindpunt beschikbaar

- **com_endpoint_view_options**:
  - **english**: View Options
  - **translated**: Weergaveopties

- **com_endpoint_save_convo_as_preset**:
  - **english**: Save Conversation as Preset
  - **translated**: Conversatie opslaan als voorinstelling

- **com_endpoint_my_preset**:
  - **english**: My Preset
  - **translated**: Mijn voorinstelling

- **com_endpoint_agent_model**:
  - **english**: Agent Model (Recommended: GPT-3.5)
  - **translated**: Agentmodel (Aanbevolen: GPT-3,5)

- **com_endpoint_completion_model**:
  - **english**: Completion Model (Recommended: GPT-4)
  - **translated**: Voltooiingsmodel (Aanbevolen: GPT-4)

- **com_endpoint_func_hover**:
  - **english**: Enable use of Plugins as OpenAI Functions
  - **translated**: Schakel het gebruik van plug-ins als OpenAI-functies in

- **com_endpoint_skip_hover**:
  - **english**: Enable skipping the completion step, which reviews the final answer and generated steps
  - **translated**: Schakel het overslaan van de voltooiingsstap in, die het definitieve antwoord en gegenereerde stappen beoordeelt

- **com_endpoint_config_key**:
  - **english**: Set API Key
  - **translated**: API-sleutel instellen

- **com_endpoint_config_key_for**:
  - **english**: Set API Key for
  - **translated**: API-sleutel instellen voor

- **com_endpoint_config_key_name**:
  - **english**: Key
  - **translated**: Sleutel

- **com_endpoint_config_value**:
  - **english**: Enter value for
  - **translated**: Voer waarde in voor

- **com_endpoint_config_key_name_placeholder**:
  - **english**: Set API key first
  - **translated**: Stel eerst API-sleutel in

- **com_endpoint_config_key_encryption**:
  - **english**: Your key will be encrypted and deleted at
  - **translated**: Uw sleutel wordt versleuteld en verwijderd op

- **com_endpoint_config_key_expiry**:
  - **english**: the expiry time
  - **translated**: het vervaltijdstip

- **com_endpoint_config_key_import_json_key**:
  - **english**: Import Service Account JSON Key.
  - **translated**: Serviceaccount-JSON-sleutel importeren.

- **com_endpoint_config_key_import_json_key_success**:
  - **english**: Successfully Imported Service Account JSON Key
  - **translated**: Serviceaccount-JSON-sleutel succesvol geïmporteerd

- **com_endpoint_config_key_import_json_key_invalid**:
  - **english**: Invalid Service Account JSON Key, Did you import the correct file?
  - **translated**: Ongeldige Serviceaccount-JSON-sleutel, heb je het juiste bestand geïmporteerd?

- **com_endpoint_config_key_get_edge_key**:
  - **english**: To get your Access token for Bing, login to
  - **translated**: Om uw toegangstoken voor Bing te krijgen, logt u in op

- **com_endpoint_config_key_get_edge_key_dev_tool**:
  - **english**: Use dev tools or an extension while logged into the site to copy the content of the _U cookie. If this fails, follow these
  - **translated**: Gebruik ontwikkelhulpmiddelen of een extensie terwijl u bent ingelogd op de site om de inhoud van de _U-cookie te kopiëren. Als dit mislukt, volg dan deze

- **com_endpoint_config_key_edge_instructions**:
  - **english**: instructions
  - **translated**: instructies

- **com_endpoint_config_key_edge_full_key_string**:
  - **english**: to provide the full cookie strings.
  - **translated**: om de volledige cookie-tekenreeksen te verstrekken.

- **com_endpoint_config_key_chatgpt**:
  - **english**: To get your Access token For ChatGPT 'Free Version', login to
  - **translated**: Om uw toegangstoken voor ChatGPT 'Gratis versie' te krijgen, logt u in op

- **com_endpoint_config_key_chatgpt_then_visit**:
  - **english**: then visit
  - **translated**: ga vervolgens naar

- **com_endpoint_config_key_chatgpt_copy_token**:
  - **english**: Copy access token.
  - **translated**: Kopieer toegangstoken.

- **com_endpoint_config_key_google_need_to**:
  - **english**: You need to
  - **translated**: U moet

- **com_endpoint_config_key_google_vertex_ai**:
  - **english**: Enable Vertex AI
  - **translated**: Vertex AI inschakelen

- **com_endpoint_config_key_google_vertex_api**:
  - **english**: API on Google Cloud, then
  - **translated**: API op Google Cloud, dan

- **com_endpoint_config_key_google_service_account**:
  - **english**: Create a Service Account
  - **translated**: Maak een serviceaccount

- **com_endpoint_config_key_google_vertex_api_role**:
  - **english**: Make sure to click 'Create and Continue' to give at least the 'Vertex AI User' role. Lastly, create a JSON key to import here.
  - **translated**: Zorg ervoor dat u op 'Maken en doorgaan' klikt om ten minste de 'Vertex AI-gebruiker'-rol te geven. Maak ten slotte een JSON-sleutel aan om hier te importeren.

- **com_nav_auto_scroll**:
  - **english**: Auto-scroll to Newest on Open
  - **translated**: Automatisch scrollen naar Nieuwste bij openen

- **com_nav_plugin_store**:
  - **english**: Plugin store
  - **translated**: Plugin-opslag

- **com_nav_plugin_search**:
  - **english**: Search plugins
  - **translated**: Plugins zoeken

- **com_nav_plugin_auth_error**:
  - **english**: There was an error attempting to authenticate this plugin. Please try again.
  - **translated**: Er trad een fout op bij het authenticeren van deze plugin. Probeer het opnieuw.

- **com_nav_export_filename**:
  - **english**: Filename
  - **translated**: Bestandsnaam

- **com_nav_export_filename_placeholder**:
  - **english**: Set the filename
  - **translated**: Stel de bestandsnaam in

- **com_nav_export_type**:
  - **english**: Type
  - **translated**: Type

- **com_nav_export_include_endpoint_options**:
  - **english**: Include endpoint options
  - **translated**: Eindpuntopties opnemen

- **com_nav_enabled**:
  - **english**: Enabled
  - **translated**: Ingeschakeld

- **com_nav_not_supported**:
  - **english**: Not Supported
  - **translated**: Niet ondersteund

- **com_nav_export_all_message_branches**:
  - **english**: Export all message branches
  - **translated**: Alle berichtvertakkingen exporteren

- **com_nav_export_recursive_or_sequential**:
  - **english**: Recursive or sequential?
  - **translated**: Recursief of sequentieel?

- **com_nav_export_recursive**:
  - **english**: Recursive
  - **translated**: Recursief

- **com_nav_export_conversation**:
  - **english**: Export conversation
  - **translated**: Conversatie exporteren

- **com_nav_theme**:
  - **english**: Theme
  - **translated**: Thema

- **com_nav_theme_system**:
  - **english**: System
  - **translated**: Systeem

- **com_nav_theme_dark**:
  - **english**: Dark
  - **translated**: Donker

- **com_nav_theme_light**:
  - **english**: Light
  - **translated**: Licht

- **com_nav_clear_all_chats**:
  - **english**: Clear all chats
  - **translated**: Alle chats wissen

- **com_nav_confirm_clear**:
  - **english**: Confirm Clear
  - **translated**: Wissen bevestigen

- **com_nav_close_sidebar**:
  - **english**: Close sidebar
  - **translated**: Zijbalk sluiten

- **com_nav_open_sidebar**:
  - **english**: Open sidebar
  - **translated**: Zijbalk openen

- **com_nav_send_message**:
  - **english**: Send message
  - **translated**: Bericht verzenden

- **com_nav_log_out**:
  - **english**: Log out
  - **translated**: Uitloggen

- **com_nav_user**:
  - **english**: USER
  - **translated**: GEBRUIKER

- **com_nav_archived_chats**:
  - **english**: Archived chats
  - **translated**: Gearchiveerde chats

- **com_nav_archived_chats_manage**:
  - **english**: Manage
  - **translated**: Beheren

- **com_nav_archived_chats_empty**:
  - **english**: You have no archived conversations.
  - **translated**: Geen gearchiveerde chats

- **com_nav_archive_all_chats**:
  - **english**: Archive all chats
  - **translated**: Alle chats archiveren

- **com_nav_archive_all**:
  - **english**: Archive all
  - **translated**: Alle archiveren

- **com_nav_archive_name**:
  - **english**: Name
  - **translated**: Naam

- **com_nav_archive_created_at**:
  - **english**: DateCreated
  - **translated**: Gemaakt op

- **com_nav_clear_conversation**:
  - **english**: Clear conversations
  - **translated**: Conversaties wissen

- **com_nav_clear_conversation_confirm_message**:
  - **english**: Are you sure you want to clear all conversations? This is irreversible.
  - **translated**: Weet u zeker dat u alle conversaties wilt wissen? Dit is onomkeerbaar.

- **com_nav_help_faq**:
  - **english**: Help & FAQ
  - **translated**: Help & FAQ

- **com_nav_settings**:
  - **english**: Settings
  - **translated**: Instellingen

- **com_nav_search_placeholder**:
  - **english**: Search messages
  - **translated**: Berichten doorzoeken

- **com_nav_setting_general**:
  - **english**: General
  - **translated**: Algemeen

- **com_nav_setting_data**:
  - **english**: Data controls
  - **translated**: Gegevensbesturing

Please consider the above comparisons to enhance understanding and guide improvements in translations.

Provide insights or suggestions that could help refine the translation process, focusing on cultural and contextual relevance.

Please craft a prompt that can be used to better inform future translations to this language.

Write this prompt in the translated language, with all its nuances detected, not in the English.
