# Instructions for Translation

Write a prompt that is mindful of the nuances in the language with respect to its English counterpart, which serves as the baseline for translations. Here are the comparisons between the language translations and their English counterparts:


- **com_ui_examples**:
  - **english**: Examples
  - **translated**: 예시

- **com_ui_new_chat**:
  - **english**: New chat
  - **translated**: 새 채팅

- **com_ui_happy_birthday**:
  - **english**: It's my 1st birthday!
  - **translated**: 내 첫 생일이야!

- **com_ui_example_quantum_computing**:
  - **english**: Explain quantum computing in simple terms
  - **translated**: 양자 컴퓨팅을 간단하게 설명해줄래?

- **com_ui_example_10_year_old_b_day**:
  - **english**: Got any creative ideas for a 10 year old's birthday?
  - **translated**: 10살 아이 생일 파티를 위한 참신한 아이디어 있을까?

- **com_ui_example_http_in_js**:
  - **english**: How do I make an HTTP request in Javascript?
  - **translated**: 자바스크립트에서 HTTP 요청을 어떻게 만드나요?

- **com_ui_capabilities**:
  - **english**: Capabilities
  - **translated**: 기능

- **com_ui_capability_remember**:
  - **english**: Remembers what user said earlier in the conversation
  - **translated**: 대화 중 사용자가 이전에 말한 것을 기억해요.

- **com_ui_capability_correction**:
  - **english**: Allows user to provide follow-up corrections
  - **translated**: 사용자가 수정 사항을 제공할 수 있어요.

- **com_ui_capability_decline_requests**:
  - **english**: Trained to decline inappropriate requests
  - **translated**: 부적절한 요청을 거부하도록 훈련되었어요.

- **com_ui_limitations**:
  - **english**: Limitations
  - **translated**: 제한사항

- **com_ui_limitation_incorrect_info**:
  - **english**: May occasionally generate incorrect information
  - **translated**: 간혹 잘못된 정보를 생성할 수 있습니다.

- **com_ui_limitation_harmful_biased**:
  - **english**: May occasionally produce harmful instructions or biased content
  - **translated**: 간혹 해로운 지시나 편향된 내용을 제공할 수 있습니다.

- **com_ui_limitation_limited_2021**:
  - **english**: Limited knowledge of world and events after 2021
  - **translated**: 2021년 이후의 세계 및 이벤트에 대한 지식이 제한적입니다.

- **com_ui_input**:
  - **english**: Input
  - **translated**: 입력

- **com_ui_close**:
  - **english**: Close
  - **translated**: 닫기

- **com_ui_model**:
  - **english**: Model
  - **translated**: 모델

- **com_ui_select_model**:
  - **english**: Select a model
  - **translated**: 모델 선택

- **com_ui_use_prompt**:
  - **english**: Use prompt
  - **translated**: 프롬프트 사용

- **com_ui_prev**:
  - **english**: Prev
  - **translated**: 이전

- **com_ui_next**:
  - **english**: Next
  - **translated**: 다음

- **com_ui_prompt_templates**:
  - **english**: Prompt Templates
  - **translated**: 프롬프트 템플릿

- **com_ui_hide_prompt_templates**:
  - **english**: Hide Prompt Templates
  - **translated**: 프롬프트 템플릿 숨기기

- **com_ui_showing**:
  - **english**: Showing
  - **translated**: 표시 중

- **com_ui_of**:
  - **english**: of
  - **translated**: /

- **com_ui_entries**:
  - **english**: Entries
  - **translated**: 개

- **com_ui_pay_per_call**:
  - **english**: All AI conversations in one place. Pay per call and not per month
  - **translated**: 모든 AI 대화를 한 곳에서. 월별이 아닌 호출 당 지불

- **com_ui_enter**:
  - **english**: Enter
  - **translated**: Enter

- **com_ui_submit**:
  - **english**: Submit
  - **translated**: 제출

- **com_ui_upload_success**:
  - **english**: Successfully uploaded file
  - **translated**: 파일 업로드 성공

- **com_ui_upload_invalid**:
  - **english**: Invalid file for upload. Must be an image not exceeding 2 MB
  - **translated**: 잘못된 파일입니다

- **com_ui_cancel**:
  - **english**: Cancel
  - **translated**: 취소

- **com_ui_save**:
  - **english**: Save
  - **translated**: 저장

- **com_ui_copy_to_clipboard**:
  - **english**: Copy to clipboard
  - **translated**: 클립보드에 복사

- **com_ui_copied_to_clipboard**:
  - **english**: Copied to clipboard
  - **translated**: 클립보드에 복사되었습니다

- **com_ui_regenerate**:
  - **english**: Regenerate
  - **translated**: 재생성

- **com_ui_continue**:
  - **english**: Continue
  - **translated**: 계속

- **com_ui_edit**:
  - **english**: Edit
  - **translated**: 편집

- **com_ui_success**:
  - **english**: Success
  - **translated**: 성공

- **com_ui_all**:
  - **english**: all
  - **translated**: 전체

- **com_ui_clear**:
  - **english**: Clear
  - **translated**: 지우기

- **com_ui_revoke**:
  - **english**: Revoke
  - **translated**: 취소

- **com_ui_revoke_info**:
  - **english**: Revoke all user provided credentials
  - **translated**: 사용자가 제공한 자격 증명을 모두 취소합니다.

- **com_ui_import_conversation**:
  - **english**: Import
  - **translated**: 가져오기

- **com_ui_import_conversation_info**:
  - **english**: Import conversations from a JSON file
  - **translated**: JSON 파일에서 대화 가져오기

- **com_ui_import_conversation_success**:
  - **english**: Conversations imported successfully
  - **translated**: 대화가 성공적으로 가져와졌습니다

- **com_ui_import_conversation_error**:
  - **english**: There was an error importing your conversations
  - **translated**: 대화를 가져오는 동안 오류가 발생했습니다

- **com_ui_confirm_action**:
  - **english**: Confirm Action
  - **translated**: 작업 확인

- **com_ui_chats**:
  - **english**: chats
  - **translated**: 채팅

- **com_ui_delete**:
  - **english**: Delete
  - **translated**: 삭제

- **com_ui_delete_conversation**:
  - **english**: Delete chat?
  - **translated**: 채팅을 삭제하시겠습니까?

- **com_ui_delete_confirm**:
  - **english**: This will delete
  - **translated**: 이 채팅이 삭제됩니다

- **com_ui_rename**:
  - **english**: Rename
  - **translated**: 이름 바꾸기

- **com_ui_archive**:
  - **english**: Archive
  - **translated**: 아카이브

- **com_ui_archive_error**:
  - **english**: Failed to archive conversation
  - **translated**: 대화 아카이브 실패

- **com_ui_unarchive**:
  - **english**: Unarchive
  - **translated**: 아카이브 해제

- **com_ui_unarchive_error**:
  - **english**: Failed to unarchive conversation
  - **translated**: 대화 아카이브 해제 실패

- **com_ui_more_options**:
  - **english**: More
  - **translated**: 더 보기

- **com_auth_error_login**:
  - **english**: Unable to login with the information provided. Please check your credentials and try again.
  - **translated**: 제공된 정보로 로그인할 수 없습니다. 자격 증명을 확인하고 다시 시도하세요.

- **com_auth_no_account**:
  - **english**: Don't have an account?
  - **translated**: 계정이 없으신가요?

- **com_auth_sign_up**:
  - **english**: Sign up
  - **translated**: 가입하기

- **com_auth_sign_in**:
  - **english**: Sign in
  - **translated**: 로그인

- **com_auth_google_login**:
  - **english**: Continue with Google
  - **translated**: Google로 로그인

- **com_auth_facebook_login**:
  - **english**: Continue with Facebook
  - **translated**: Facebook으로 로그인

- **com_auth_github_login**:
  - **english**: Continue with Github
  - **translated**: Github으로 로그인

- **com_auth_discord_login**:
  - **english**: Continue with Discord
  - **translated**: Discord로 로그인

- **com_auth_email**:
  - **english**: Email
  - **translated**: 이메일

- **com_auth_email_required**:
  - **english**: Email is required
  - **translated**: 이메일은 필수입니다

- **com_auth_email_min_length**:
  - **english**: Email must be at least 6 characters
  - **translated**: 이메일은 최소 6자 이상이어야 합니다

- **com_auth_email_max_length**:
  - **english**: Email should not be longer than 120 characters
  - **translated**: 이메일은 120자를 넘을 수 없습니다

- **com_auth_email_pattern**:
  - **english**: You must enter a valid email address
  - **translated**: 유효한 이메일 주소를 입력하세요

- **com_auth_email_address**:
  - **english**: Email address
  - **translated**: 이메일 주소

- **com_auth_password**:
  - **english**: Password
  - **translated**: 비밀번호

- **com_auth_password_required**:
  - **english**: Password is required
  - **translated**: 비밀번호는 필수입니다

- **com_auth_password_min_length**:
  - **english**: Password must be at least 8 characters
  - **translated**: 비밀번호는 최소 8자 이상이어야 합니다

- **com_auth_password_max_length**:
  - **english**: Password must be less than 128 characters
  - **translated**: 비밀번호는 128자를 넘을 수 없습니다

- **com_auth_password_forgot**:
  - **english**: Forgot Password?
  - **translated**: 비밀번호를 잊으셨나요?

- **com_auth_password_confirm**:
  - **english**: Confirm password
  - **translated**: 비밀번호 확인

- **com_auth_password_not_match**:
  - **english**: Passwords do not match
  - **translated**: 비밀번호가 일치하지 않습니다

- **com_auth_continue**:
  - **english**: Continue
  - **translated**: 계속

- **com_auth_create_account**:
  - **english**: Create your account
  - **translated**: 계정 만들기

- **com_auth_error_create**:
  - **english**: There was an error attempting to register your account. Please try again.
  - **translated**: 계정을 등록하는 중에 오류가 발생했습니다. 다시 시도하세요.

- **com_auth_full_name**:
  - **english**: Full name
  - **translated**: 이름

- **com_auth_name_required**:
  - **english**: Name is required
  - **translated**: 이름은 필수입니다

- **com_auth_name_min_length**:
  - **english**: Name must be at least 3 characters
  - **translated**: 이름은 최소 3자 이상이어야 합니다

- **com_auth_name_max_length**:
  - **english**: Name must be less than 80 characters
  - **translated**: 이름은 80자를 초과할 수 없습니다

- **com_auth_username**:
  - **english**: Username (optional)
  - **translated**: 사용자명

- **com_auth_username_required**:
  - **english**: Username is required
  - **translated**: 사용자명이 필요합니다

- **com_auth_username_min_length**:
  - **english**: Username must be at least 2 characters
  - **translated**: 사용자명은 최소 2자 이상이어야 합니다

- **com_auth_username_max_length**:
  - **english**: Username must be less than 20 characters
  - **translated**: 사용자명은 20자를 초과할 수 없습니다

- **com_auth_already_have_account**:
  - **english**: Already have an account?
  - **translated**: 이미 계정이 있으신가요?

- **com_auth_login**:
  - **english**: Login
  - **translated**: 로그인

- **com_auth_reset_password**:
  - **english**: Reset your password
  - **translated**: 비밀번호 재설정

- **com_auth_click**:
  - **english**: Click
  - **translated**: 클릭

- **com_auth_here**:
  - **english**: HERE
  - **translated**: 여기

- **com_auth_to_reset_your_password**:
  - **english**: to reset your password.
  - **translated**: 비밀번호를 재설정하려면

- **com_auth_reset_password_link_sent**:
  - **english**: Email Sent
  - **translated**: 이메일 전송

- **com_auth_reset_password_email_sent**:
  - **english**: An email has been sent to you with further instructions to reset your password.
  - **translated**: 비밀번호 재설정에 대한 지침이 포함된 이메일이 전송되었습니다.

- **com_auth_error_reset_password**:
  - **english**: There was a problem resetting your password. There was no user found with the email address provided. Please try again.
  - **translated**: 비밀번호 재설정 중에 문제가 발생했습니다. 제공된 이메일 주소로 사용자를 찾을 수 없습니다. 다시 시도하세요.

- **com_auth_reset_password_success**:
  - **english**: Password Reset Success
  - **translated**: 비밀번호 재설정 성공

- **com_auth_login_with_new_password**:
  - **english**: You may now login with your new password.
  - **translated**: 새로운 비밀번호로 로그인할 수 있습니다.

- **com_auth_error_invalid_reset_token**:
  - **english**: This password reset token is no longer valid.
  - **translated**: 이 비밀번호 재설정 토큰은 더 이상 유효하지 않습니다.

- **com_auth_click_here**:
  - **english**: Click here
  - **translated**: 여기를 클릭하세요

- **com_auth_to_try_again**:
  - **english**: to try again.
  - **translated**: 다시 시도하세요.

- **com_auth_submit_registration**:
  - **english**: Submit registration
  - **translated**: 등록하기

- **com_auth_welcome_back**:
  - **english**: Welcome back
  - **translated**: 다시 오신 것을 환영합니다

- **com_endpoint_open_menu**:
  - **english**: Open Menu
  - **translated**: 메뉴 열기

- **com_endpoint_bing_enable_sydney**:
  - **english**: Enable Sydney
  - **translated**: 시드니 활성화

- **com_endpoint_bing_to_enable_sydney**:
  - **english**: To enable Sydney
  - **translated**: 시드니를 활성화하려면

- **com_endpoint_bing_jailbreak**:
  - **english**: Jailbreak
  - **translated**: Jailbreak

- **com_endpoint_bing_context_placeholder**:
  - **english**: Bing can use up to 7k tokens for 'context', which it can reference for the conversation. The specific limit is not known but may run into errors exceeding 7k tokens
  - **translated**: Bing은 '컨텍스트'로 최대 7,000개의 토큰을 사용할 수 있으며, 대화에서 참조할 수 있습니다. 구체적인 제한은 알려져 있지 않지만, 7,000개의 토큰을 초과하면 오류가 발생할 수 있습니다.

- **com_endpoint_bing_system_message_placeholder**:
  - **english**: WARNING: Misuse of this feature can get you BANNED from using Bing! Click on 'System Message' for full instructions and the default message if omitted, which is the 'Sydney' preset that is considered safe.
  - **translated**: 경고: 이 기능의 오용으로 인해 Bing의 사용이 '금지'될 수 있습니다. 모든 내용을 보려면 '시스템 메시지'를 클릭하세요. 생략된 경우 '시드니' 프리셋이 사용됩니다.

- **com_endpoint_system_message**:
  - **english**: System Message
  - **translated**: 시스템 메시지

- **com_endpoint_default_blank**:
  - **english**: default: blank
  - **translated**: 기본값: 공백

- **com_endpoint_default_false**:
  - **english**: default: false
  - **translated**: 기본값: false

- **com_endpoint_default_creative**:
  - **english**: default: creative
  - **translated**: 기본값: 창의적

- **com_endpoint_default_empty**:
  - **english**: default: empty
  - **translated**: 기본값: 비어 있음

- **com_endpoint_default_with_num**:
  - **english**: default: {0}
  - **translated**: 기본값: {0}

- **com_endpoint_context**:
  - **english**: Context
  - **translated**: 컨텍스트

- **com_endpoint_tone_style**:
  - **english**: Tone Style
  - **translated**: 톤 스타일

- **com_endpoint_token_count**:
  - **english**: Token count
  - **translated**: 토큰 수

- **com_endpoint_output**:
  - **english**: Output
  - **translated**: 출력

- **com_endpoint_google_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: 높은 값 = 더 무작위, 낮은 값 = 더 집중적이고 결정적입니다. 이 값을 변경하거나 Top P 중 하나만 변경하는 것을 권장합니다.

- **com_endpoint_google_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p는 모델이 출력에 사용할 토큰을 선택하는 방식을 변경합니다. 토큰은 가장 높은 확률부터 가장 낮은 확률까지 선택됩니다. 선택된 토큰의 확률의 합이 top-p 값과 같아질 때까지 선택됩니다.

- **com_endpoint_google_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k는 모델이 출력에 사용할 토큰을 선택하는 방식을 변경합니다. top-k가 1인 경우 모델의 어휘 중 가장 확률이 높은 토큰이 선택됩니다(greedy decoding). top-k가 3인 경우 다음 토큰은 가장 확률이 높은 3개의 토큰 중에서 선택됩니다(temperature 사용).

- **com_endpoint_google_maxoutputtokens**:
  - **english**:  	Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: 응답에서 생성할 수 있는 최대 토큰 수입니다. 짧은 응답에는 낮은 값을, 긴 응답에는 높은 값을 지정하세요.

- **com_endpoint_google_custom_name_placeholder**:
  - **english**: Set a custom name for Google
  - **translated**: Google에 대한 사용자 정의 이름 설정

- **com_endpoint_prompt_prefix_placeholder**:
  - **english**: Set custom instructions or context. Ignored if empty.
  - **translated**: 사용자 정의 지시사항 또는 컨텍스트를 설정하세요. 비어 있으면 무시됩니다.

- **com_endpoint_custom_name**:
  - **english**: Custom Name
  - **translated**: 사용자 정의 이름

- **com_endpoint_prompt_prefix**:
  - **english**: Custom Instructions
  - **translated**: 프롬프트 접두사

- **com_endpoint_temperature**:
  - **english**: Temperature
  - **translated**: 온도

- **com_endpoint_default**:
  - **english**: default
  - **translated**: 기본값

- **com_endpoint_top_p**:
  - **english**: Top P
  - **translated**: Top P

- **com_endpoint_top_k**:
  - **english**: Top K
  - **translated**: Top K

- **com_endpoint_max_output_tokens**:
  - **english**: Max Output Tokens
  - **translated**: 최대 출력 토큰 수

- **com_endpoint_openai_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: 높은 값 = 더 무작위, 낮은 값 = 더 집중적이고 결정적입니다. 이 값을 변경하거나 Top P 중 하나만 변경하는 것을 권장합니다.

- **com_endpoint_openai_max**:
  - **english**: The max tokens to generate. The total length of input tokens and generated tokens is limited by the model's context length.
  - **translated**: 생성할 최대 토큰 수입니다. 입력 토큰과 생성된 토큰의 총 길이는 모델의 컨텍스트 길이로 제한됩니다.

- **com_endpoint_openai_topp**:
  - **english**: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We recommend altering this or temperature but not both.
  - **translated**: 온도를 사용한 샘플링 대신, top_p 확률 질량을 고려하는 nucleus 샘플링입니다. 따라서 0.1은 상위 10% 확률 질량을 구성하는 토큰만 고려합니다. 이 값을 변경하거나 온도를 변경하는 것을 권장하지만, 둘 다 변경하지는 마세요.

- **com_endpoint_openai_freq**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
  - **translated**: 텍스트에서 토큰의 빈도수에 따라 새로운 토큰에 패널티를 부여합니다. 이전에 나온 텍스트의 빈도수에 따라 새로운 토큰의 확률이 감소하여 동일한 문장을 반복할 가능성을 줄입니다.

- **com_endpoint_openai_pres**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
  - **translated**: 텍스트에서 토큰이 나타나는지 여부에 따라 새로운 토큰에 패널티를 부여합니다. 이전에 나온 텍스트에 나타나는 토큰에 대한 패널티를 증가시켜 새로운 주제에 대해 이야기할 가능성을 높입니다.

- **com_endpoint_openai_custom_name_placeholder**:
  - **english**: Set a custom name for the AI
  - **translated**: ChatGPT에 대한 사용자 정의 이름을 설정하세요.

- **com_endpoint_openai_prompt_prefix_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: 시스템 메시지에 포함할 사용자 정의 지시사항을 설정하세요. 기본값: 없음

- **com_endpoint_anthropic_temp**:
  - **english**: Ranges from 0 to 1. Use temp closer to 0 for analytical / multiple choice, and closer to 1 for creative and generative tasks. We recommend altering this or Top P but not both.
  - **translated**: 0에서 1 사이의 값으로, 분석/다중 선택에는 0에 가까운 값을 사용하고, 창의적이고 생성적인 작업에는 1에 가까운 값을 사용하세요. 이 값을 변경하거나 Top P 중 하나만 변경하는 것을 권장합니다.

- **com_endpoint_anthropic_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p는 모델이 출력에 사용할 토큰을 선택하는 방식을 변경합니다. 토큰은 가장 높은 확률부터 가장 낮은 확률까지 선택됩니다. 선택된 토큰의 확률의 합이 top-p 값과 같아질 때까지 선택됩니다.

- **com_endpoint_anthropic_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k는 모델이 출력에 사용할 토큰을 선택하는 방식을 변경합니다. top-k가 1인 경우 모델의 어휘 중 가장 확률이 높은 토큰이 선택됩니다(greedy decoding). top-k가 3인 경우 다음 토큰은 가장 확률이 높은 3개의 토큰 중에서 선택됩니다(temperature 사용).

- **com_endpoint_anthropic_maxoutputtokens**:
  - **english**: Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: 응답에서 생성할 수 있는 최대 토큰 수입니다. 짧은 응답에는 낮은 값을, 긴 응답에는 높은 값을 지정하세요.

- **com_endpoint_anthropic_custom_name_placeholder**:
  - **english**: Set a custom name for Anthropic
  - **translated**: Anthropic에 대한 사용자 정의 이름 설정

- **com_endpoint_frequency_penalty**:
  - **english**: Frequency Penalty
  - **translated**: 빈도 패널티

- **com_endpoint_presence_penalty**:
  - **english**: Presence Penalty
  - **translated**: 존재 패널티

- **com_endpoint_plug_use_functions**:
  - **english**: Use Functions
  - **translated**: 함수 사용

- **com_endpoint_plug_skip_completion**:
  - **english**: Skip Completion
  - **translated**: 완료 단계 건너뛰기

- **com_endpoint_disabled_with_tools**:
  - **english**: disabled with tools
  - **translated**: 도구 사용 불가

- **com_endpoint_disabled_with_tools_placeholder**:
  - **english**: Disabled with Tools Selected
  - **translated**: 도구 선택 시 사용 불가

- **com_endpoint_plug_set_custom_instructions_for_gpt_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: 시스템 메시지에 포함할 사용자 정의 지시사항을 설정하세요. 기본값: 없음

- **com_endpoint_import**:
  - **english**: Import
  - **translated**: 가져오기

- **com_endpoint_set_custom_name**:
  - **english**: Set a custom name, in case you can find this preset
  - **translated**: 프리셋을 쉽게 찾을 수 있도록 사용자 정의 이름을 설정하세요

- **com_endpoint_preset**:
  - **english**: preset
  - **translated**: 프리셋

- **com_endpoint_presets**:
  - **english**: presets
  - **translated**: 프리셋

- **com_endpoint_preset_name**:
  - **english**: Preset Name
  - **translated**: 프리셋 이름

- **com_endpoint_new_topic**:
  - **english**: New Topic
  - **translated**: 새로운 주제

- **com_endpoint**:
  - **english**: Endpoint
  - **translated**: 엔드포인트

- **com_endpoint_hide**:
  - **english**: Hide
  - **translated**: 숨기기

- **com_endpoint_show**:
  - **english**: Show
  - **translated**: 표시

- **com_endpoint_examples**:
  - **english**:  Presets
  - **translated**:  프리셋

- **com_endpoint_completion**:
  - **english**: Completion
  - **translated**: 완료

- **com_endpoint_agent**:
  - **english**: Agent
  - **translated**: 에이전트

- **com_endpoint_show_what_settings**:
  - **english**: Show {0} Settings
  - **translated**: {0} 설정 표시

- **com_endpoint_export**:
  - **english**: Export
  - **translated**: 내보내기

- **com_endpoint_save_as_preset**:
  - **english**: Save As Preset
  - **translated**: 프리셋으로 저장

- **com_endpoint_presets_clear_warning**:
  - **english**: Are you sure you want to clear all presets? This is irreversible.
  - **translated**: 모든 프리셋을 삭제하시겠습니까? 이 작업은 되돌릴 수 없습니다.

- **com_endpoint_not_implemented**:
  - **english**: Not implemented
  - **translated**: 구현되지 않았습니다

- **com_endpoint_no_presets**:
  - **english**: No presets yet, use the settings button to create one
  - **translated**: 아직 프리셋이 없습니다

- **com_endpoint_not_available**:
  - **english**: No endpoint available
  - **translated**: 사용할 수 없는 엔드포인트입니다

- **com_endpoint_view_options**:
  - **english**: View Options
  - **translated**: 옵션 보기

- **com_endpoint_save_convo_as_preset**:
  - **english**: Save Conversation as Preset
  - **translated**: 대화를 프리셋으로 저장

- **com_endpoint_my_preset**:
  - **english**: My Preset
  - **translated**: 내 프리셋

- **com_endpoint_agent_model**:
  - **english**: Agent Model (Recommended: GPT-3.5)
  - **translated**: 에이전트 모델 (권장: GPT-3.5)

- **com_endpoint_completion_model**:
  - **english**: Completion Model (Recommended: GPT-4)
  - **translated**: 완료 모델 (권장: GPT-4)

- **com_endpoint_func_hover**:
  - **english**: Enable use of Plugins as OpenAI Functions
  - **translated**: 플러그인을 OpenAI 함수로 사용할 수 있도록 합니다.

- **com_endpoint_skip_hover**:
  - **english**: Enable skipping the completion step, which reviews the final answer and generated steps
  - **translated**: 완료 단계를 건너뛰도록 합니다. 최종 답변과 생성된 단계를 검토하는 단계입니다.

- **com_endpoint_config_key**:
  - **english**: Set API Key
  - **translated**: API 키 설정

- **com_endpoint_config_key_for**:
  - **english**: Set API Key for
  - **translated**: API 키 설정: 

- **com_endpoint_config_key_name**:
  - **english**: Key
  - **translated**: 키

- **com_endpoint_config_value**:
  - **english**: Enter value for
  - **translated**: 값 입력

- **com_endpoint_config_key_name_placeholder**:
  - **english**: Set API key first
  - **translated**: 먼저 API 키를 설정하세요

- **com_endpoint_config_key_encryption**:
  - **english**: Your key will be encrypted and deleted at
  - **translated**: 키는 암호화되어 저장되며, 만료 시간에 삭제됩니다

- **com_endpoint_config_key_expiry**:
  - **english**: the expiry time
  - **translated**: 만료 시간

- **com_endpoint_config_key_import_json_key**:
  - **english**: Import Service Account JSON Key.
  - **translated**: 서비스 계정 JSON 키 가져오기

- **com_endpoint_config_key_import_json_key_success**:
  - **english**: Successfully Imported Service Account JSON Key
  - **translated**: 서비스 계정 JSON 키 가져오기 성공

- **com_endpoint_config_key_import_json_key_invalid**:
  - **english**: Invalid Service Account JSON Key, Did you import the correct file?
  - **translated**: 유효하지 않은 서비스 계정 JSON 키입니다. 올바른 파일을 가져왔는지 확인하세요

- **com_endpoint_config_key_get_edge_key**:
  - **english**: To get your Access token for Bing, login to
  - **translated**: Bing 액세스 토큰을 얻으려면 다음 사이트에 로그인하세요

- **com_endpoint_config_key_get_edge_key_dev_tool**:
  - **english**: Use dev tools or an extension while logged into the site to copy the content of the _U cookie. If this fails, follow these
  - **translated**: 로그인한 상태에서 개발 도구 또는 확장 프로그램을 사용하여 _U 쿠키의 내용을 복사합니다. 실패하는 경우 다음

- **com_endpoint_config_key_edge_instructions**:
  - **english**: instructions
  - **translated**: 지침

- **com_endpoint_config_key_edge_full_key_string**:
  - **english**: to provide the full cookie strings.
  - **translated**: 전체 쿠키 문자열을 제공하세요

- **com_nav_plugin_store**:
  - **english**: Plugin store
  - **translated**: 플러그인 스토어

- **com_nav_plugin_search**:
  - **english**: Search plugins
  - **translated**: 플러그인 검색

- **com_nav_plugin_auth_error**:
  - **english**: There was an error attempting to authenticate this plugin. Please try again.
  - **translated**: 이 플러그인을 인증하려는 중에 오류가 발생했습니다. 다시 시도해주세요.

- **com_nav_export_filename**:
  - **english**: Filename
  - **translated**: 파일 이름

- **com_nav_export_filename_placeholder**:
  - **english**: Set the filename
  - **translated**: 파일 이름을 설정하세요

- **com_nav_export_type**:
  - **english**: Type
  - **translated**: 유형

- **com_nav_export_include_endpoint_options**:
  - **english**: Include endpoint options
  - **translated**: 엔드포인트 옵션 포함

- **com_nav_enabled**:
  - **english**: Enabled
  - **translated**: 활성화됨

- **com_nav_not_supported**:
  - **english**: Not Supported
  - **translated**: 지원되지 않음

- **com_nav_export_all_message_branches**:
  - **english**: Export all message branches
  - **translated**: 모든 메시지 브랜치 내보내기

- **com_nav_export_recursive_or_sequential**:
  - **english**: Recursive or sequential?
  - **translated**: 재귀적 또는 순차적?

- **com_nav_export_recursive**:
  - **english**: Recursive
  - **translated**: 재귀적

- **com_nav_export_conversation**:
  - **english**: Export conversation
  - **translated**: 대화 내보내기

- **com_nav_theme**:
  - **english**: Theme
  - **translated**: 테마

- **com_nav_theme_system**:
  - **english**: System
  - **translated**: 시스템

- **com_nav_theme_dark**:
  - **english**: Dark
  - **translated**: 다크

- **com_nav_theme_light**:
  - **english**: Light
  - **translated**: 라이트

- **com_nav_clear_all_chats**:
  - **english**: Clear all chats
  - **translated**: 모든 채팅 지우기

- **com_nav_confirm_clear**:
  - **english**: Confirm Clear
  - **translated**: 지우기 확인

- **com_nav_close_sidebar**:
  - **english**: Close sidebar
  - **translated**: 사이드바 닫기

- **com_nav_open_sidebar**:
  - **english**: Open sidebar
  - **translated**: 사이드바 열기

- **com_nav_send_message**:
  - **english**: Send message
  - **translated**: 메시지 보내기

- **com_nav_log_out**:
  - **english**: Log out
  - **translated**: 로그아웃

- **com_nav_user**:
  - **english**: USER
  - **translated**: 사용자

- **com_nav_archived_chats**:
  - **english**: Archived chats
  - **translated**: 아카이브된 채팅

- **com_nav_archived_chats_manage**:
  - **english**: Manage
  - **translated**: 관리

- **com_nav_archived_chats_empty**:
  - **english**: You have no archived conversations.
  - **translated**: 아카이브된 채팅이 없습니다

- **com_nav_archive_all_chats**:
  - **english**: Archive all chats
  - **translated**: 모든 채팅 아카이브

- **com_nav_archive_all**:
  - **english**: Archive all
  - **translated**: 모든 채팅 아카이브

- **com_nav_archive_name**:
  - **english**: Name
  - **translated**: 이름

- **com_nav_archive_created_at**:
  - **english**: DateCreated
  - **translated**: 생성 날짜

- **com_nav_clear_conversation**:
  - **english**: Clear conversations
  - **translated**: 대화 지우기

- **com_nav_clear_conversation_confirm_message**:
  - **english**: Are you sure you want to clear all conversations? This is irreversible.
  - **translated**: 모든 대화를 지우시겠습니까? 이 작업은 되돌릴 수 없습니다.

- **com_nav_help_faq**:
  - **english**: Help & FAQ
  - **translated**: 도움말 및 FAQ

- **com_nav_settings**:
  - **english**: Settings
  - **translated**: 설정

- **com_nav_search_placeholder**:
  - **english**: Search messages
  - **translated**: 메시지 검색

- **com_nav_setting_general**:
  - **english**: General
  - **translated**: 일반

- **com_nav_setting_data**:
  - **english**: Data controls
  - **translated**: 데이터 제어

Please consider the above comparisons to enhance understanding and guide improvements in translations.

Provide insights or suggestions that could help refine the translation process, focusing on cultural and contextual relevance.

Please craft a prompt that can be used to better inform future translations to this language.

Write this prompt in the translated language, with all its nuances detected, not in the English.
