# Instructions for Translation

Write a prompt that is mindful of the nuances in the language with respect to its English counterpart, which serves as the baseline for translations. Here are the comparisons between the language translations and their English counterparts:


- **com_error_moderation**:
  - **english**: It appears that the content submitted has been flagged by our moderation system for not aligning with our community guidelines. We're unable to proceed with this specific topic. If you have any other questions or topics you'd like to explore, please edit your message, or create a new conversation.
  - **translated**: 送信されたコンテンツは、コミュニティガイドラインに準拠していないとして、投稿監視システムによって検知されました。この特定のトピックについては処理を続行できません。他に質問や調べたいトピックがある場合は、メッセージを編集するか、新しい会話を作成してください。

- **com_error_no_user_key**:
  - **english**: No key found. Please provide a key and try again.
  - **translated**: キーが見つかりません。キーを入力して再試行してください。

- **com_error_no_base_url**:
  - **english**: No base URL found. Please provide one and try again.
  - **translated**: ベースURLが見つかりません。ベースURLを入力して再試行してください。

- **com_error_expired_user_key**:
  - **english**: Provided key for {0} expired at {1}. Please provide a key and try again.
  - **translated**: {0}の提供されたキーは{1}で期限切れです。キーを入力して再試行してください。

- **com_files_no_results**:
  - **english**: No results.
  - **translated**: 結果がありません。

- **com_files_filter**:
  - **english**: Filter files...
  - **translated**: ファイルをフィルタリング...

- **com_files_number_selected**:
  - **english**: {0} of {1} file(s) selected
  - **translated**: {0} of {1} ファイルが選択されました

- **com_sidepanel_select_assistant**:
  - **english**: Select an Assistant
  - **translated**: Assistantを選択

- **com_sidepanel_parameters**:
  - **english**: Parameters
  - **translated**: パラメータ

- **com_sidepanel_assistant_builder**:
  - **english**: Assistant Builder
  - **translated**: Assistant Builder

- **com_sidepanel_hide_panel**:
  - **english**: Hide Panel
  - **translated**: パネルを隠す

- **com_sidepanel_attach_files**:
  - **english**: Attach Files
  - **translated**: ファイルを添付する

- **com_sidepanel_manage_files**:
  - **english**: Manage Files
  - **translated**: ファイルを管理

- **com_assistants_capabilities**:
  - **english**: Capabilities
  - **translated**: Capabilities

- **com_assistants_knowledge**:
  - **english**: Knowledge
  - **translated**: ナレッジ

- **com_assistants_knowledge_info**:
  - **english**: If you upload files under Knowledge, conversations with your Assistant may include file contents.
  - **translated**: ナレッジの下でファイルをアップロードする場合、アシスタントとの会話にファイルの内容が含まれる場合があります。

- **com_assistants_knowledge_disabled**:
  - **english**: Assistant must be created, and Code Interpreter or Retrieval must be enabled and saved before uploading files as Knowledge.
  - **translated**: ファイルをナレッジとしてアップロードする前に、アシスタントを作成し、Code InterpreterまたはRetrievalを有効にして保存する必要があります。

- **com_assistants_image_vision**:
  - **english**: Image Vision
  - **translated**: Image Vision

- **com_assistants_code_interpreter**:
  - **english**: Code Interpreter
  - **translated**: Code Interpreter

- **com_assistants_code_interpreter_files**:
  - **english**: The following files are only available for Code Interpreter:
  - **translated**: 次のファイルはCode Interpreterでのみ使用できます。

- **com_assistants_retrieval**:
  - **english**: Retrieval
  - **translated**: Retrieval

- **com_assistants_search_name**:
  - **english**: Search assistants by name
  - **translated**: Assistantの名前で検索

- **com_ui_tools**:
  - **english**: Tools
  - **translated**: Tools

- **com_assistants_actions**:
  - **english**: Actions
  - **translated**: Actions

- **com_assistants_add_tools**:
  - **english**: Add Tools
  - **translated**: Toolsを追加

- **com_assistants_add_actions**:
  - **english**: Add Actions
  - **translated**: アクションを追加

- **com_assistants_available_actions**:
  - **english**: Available Actions
  - **translated**: 利用可能なActions

- **com_assistants_running_action**:
  - **english**: Running action
  - **translated**: アクションを実行

- **com_assistants_completed_action**:
  - **english**: Talked to {0}
  - **translated**: Talked to {0}

- **com_assistants_completed_function**:
  - **english**: Ran {0}
  - **translated**: Ran {0}

- **com_assistants_function_use**:
  - **english**: Assistant used {0}
  - **translated**: アシスタントが {0} を使用しました

- **com_assistants_domain_info**:
  - **english**: Assistant sent this info to {0}
  - **translated**: アシスタントがこの情報を {0} に送信しました

- **com_assistants_delete_actions_success**:
  - **english**: Successfully deleted Action from Assistant
  - **translated**: アシスタントからアクションが削除されました

- **com_assistants_update_actions_success**:
  - **english**: Successfully created or updated Action
  - **translated**: アクションが作成または更新されました

- **com_assistants_update_actions_error**:
  - **english**: There was an error creating or updating the action.
  - **translated**: アクションの作成または更新中にエラーが発生しました。

- **com_assistants_delete_actions_error**:
  - **english**: There was an error deleting the action.
  - **translated**: アクションの削除中にエラーが発生しました。

- **com_assistants_actions_info**:
  - **english**: Let your Assistant retrieve information or take actions via API's
  - **translated**: アシスタントが API を介して情報を取得したり、アクションを実行したりできるようにします's

- **com_assistants_name_placeholder**:
  - **english**: Optional: The name of the assistant
  - **translated**: オプション: アシスタントの名前

- **com_assistants_instructions_placeholder**:
  - **english**: The system instructions that the assistant uses
  - **translated**: アシスタントが使用するシステム指示

- **com_assistants_description_placeholder**:
  - **english**: Optional: Describe your Assistant here
  - **translated**: オプション: ここにアシスタントについて説明します

- **com_assistants_actions_disabled**:
  - **english**: You need to create an assistant before adding actions.
  - **translated**: アクションを追加する前にアシスタントを作成する必要があります。

- **com_assistants_update_success**:
  - **english**: Successfully updated
  - **translated**: アップデートに成功しました

- **com_assistants_update_error**:
  - **english**: There was an error updating your assistant.
  - **translated**: アシスタントの更新中にエラーが発生しました。

- **com_assistants_create_success**:
  - **english**: Successfully created
  - **translated**: アシスタントが正常に作成されました。

- **com_assistants_create_error**:
  - **english**: There was an error creating your assistant.
  - **translated**: アシスタントの作成中にエラーが発生しました。

- **com_ui_field_required**:
  - **english**: This field is required
  - **translated**: 必須入力項目です

- **com_ui_download_error**:
  - **english**: Error downloading file. The file may have been deleted.
  - **translated**: ファイルのダウンロード中にエラーが発生しました。ファイルが削除された可能性があります。

- **com_ui_attach_error_type**:
  - **english**: Unsupported file type for endpoint:
  - **translated**: エンドポイントでサポートされていないファイル タイプ:

- **com_ui_attach_error_size**:
  - **english**: File size limit exceeded for endpoint:
  - **translated**: エンドポイントのファイル サイズ制限を超えました:

- **com_ui_attach_error**:
  - **english**: Cannot attach file. Create or select a conversation, or try refreshing the page.
  - **translated**: ファイルを添付できません。会話を作成または選択するか、ページを更新してみてください。

- **com_ui_examples**:
  - **english**: Examples
  - **translated**: 例

- **com_ui_new_chat**:
  - **english**: New chat
  - **translated**: 新規チャット

- **com_ui_happy_birthday**:
  - **english**: It's my 1st birthday!
  - **translated**: 初めての誕生日です！

- **com_ui_example_quantum_computing**:
  - **english**: Explain quantum computing in simple terms
  - **translated**: 量子コンピュータを簡潔に説明してください

- **com_ui_example_10_year_old_b_day**:
  - **english**: Got any creative ideas for a 10 year old's birthday?
  - **translated**: 10歳の誕生日で行うクリエイティブなアイデアはありますか？

- **com_ui_example_http_in_js**:
  - **english**: How do I make an HTTP request in Javascript?
  - **translated**: JavascriptでHTTPリクエストを作成するにはどうすればよいですか？

- **com_ui_capabilities**:
  - **english**: Capabilities
  - **translated**: 能力(機能)

- **com_ui_capability_remember**:
  - **english**: Remembers what user said earlier in the conversation
  - **translated**: ユーザと話した以前の会話の内容を参照します

- **com_ui_capability_correction**:
  - **english**: Allows user to provide follow-up corrections
  - **translated**: ユーザーの追加の質問を許可する

- **com_ui_capability_decline_requests**:
  - **english**: Trained to decline inappropriate requests
  - **translated**: 不適切な要求を拒否するように学習されています

- **com_ui_limitations**:
  - **english**: Limitations
  - **translated**: 制限事項

- **com_ui_limitation_incorrect_info**:
  - **english**: May occasionally generate incorrect information
  - **translated**: 誤った情報を生成することがあります

- **com_ui_limitation_harmful_biased**:
  - **english**: May occasionally produce harmful instructions or biased content
  - **translated**: 有害な指示や偏った内容を生成する可能性があります

- **com_ui_limitation_limited_2021**:
  - **english**: Limited knowledge of world and events after 2021
  - **translated**: 2021年以降の出来事に関しては知識に制限があります

- **com_ui_experimental**:
  - **english**: Experimental Features
  - **translated**: Experimental

- **com_ui_on**:
  - **english**: On
  - **translated**: On

- **com_ui_off**:
  - **english**: Off
  - **translated**: Off

- **com_ui_yes**:
  - **english**: Yes
  - **translated**: はい

- **com_ui_no**:
  - **english**: No
  - **translated**: いいえ

- **com_ui_ascending**:
  - **english**: Asc
  - **translated**: 昇順

- **com_ui_descending**:
  - **english**: Desc
  - **translated**: 降順

- **com_ui_show_all**:
  - **english**: Show All
  - **translated**: すべて表示

- **com_ui_name**:
  - **english**: Name
  - **translated**: 名前

- **com_ui_date**:
  - **english**: Date
  - **translated**: 日付

- **com_ui_storage**:
  - **english**: Storage
  - **translated**: Storage

- **com_ui_context**:
  - **english**: Context
  - **translated**: Context

- **com_ui_size**:
  - **english**: Size
  - **translated**: サイズ

- **com_ui_host**:
  - **english**: Host
  - **translated**: ホスト

- **com_ui_update**:
  - **english**: Update
  - **translated**: Update

- **com_ui_authentication**:
  - **english**: Authentication
  - **translated**: 認証

- **com_ui_instructions**:
  - **english**: Instructions
  - **translated**: 指示文

- **com_ui_description**:
  - **english**: Description
  - **translated**: 概要

- **com_ui_error**:
  - **english**: Error
  - **translated**: エラー

- **com_ui_select**:
  - **english**: Select
  - **translated**: 選択

- **com_ui_input**:
  - **english**: Input
  - **translated**: 入力

- **com_ui_close**:
  - **english**: Close
  - **translated**: 閉じる

- **com_ui_model**:
  - **english**: Model
  - **translated**: モデル

- **com_ui_select_model**:
  - **english**: Select a model
  - **translated**: モデル選択

- **com_ui_select_search_model**:
  - **english**: Search model by name
  - **translated**: モデル名で検索

- **com_ui_select_search_plugin**:
  - **english**: Search plugin by name
  - **translated**: プラグイン名で検索

- **com_ui_use_prompt**:
  - **english**: Use prompt
  - **translated**: プロンプトの利用

- **com_ui_prev**:
  - **english**: Prev
  - **translated**: 前

- **com_ui_next**:
  - **english**: Next
  - **translated**: 次

- **com_ui_stop**:
  - **english**: Stop
  - **translated**: 止める

- **com_ui_upload_files**:
  - **english**: Upload files
  - **translated**: ファイルをアップロード

- **com_ui_prompt_templates**:
  - **english**: Prompt Templates
  - **translated**: プロンプトテンプレート

- **com_ui_hide_prompt_templates**:
  - **english**: Hide Prompt Templates
  - **translated**: プロンプトテンプレートを非表示

- **com_ui_showing**:
  - **english**: Showing
  - **translated**: 表示

- **com_ui_of**:
  - **english**: of
  - **translated**: of

- **com_ui_entries**:
  - **english**: Entries
  - **translated**: エントリー

- **com_ui_pay_per_call**:
  - **english**: All AI conversations in one place. Pay per call and not per month
  - **translated**: すべてのAIモデルを1つの場所で。支払いは使った分だけ

- **com_ui_new_footer**:
  - **english**: All AI conversations in one place.
  - **translated**: すべてのAIモデルを1つの場所で。

- **com_ui_enter**:
  - **english**: Enter
  - **translated**: Enter

- **com_ui_submit**:
  - **english**: Submit
  - **translated**: 送信する

- **com_ui_upload_success**:
  - **english**: Successfully uploaded file
  - **translated**: アップロード成功

- **com_ui_upload_error**:
  - **english**: There was an error uploading your file
  - **translated**: ファイルのアップロード中にエラーが発生しました。

- **com_ui_upload_invalid**:
  - **english**: Invalid file for upload. Must be an image not exceeding 2 MB
  - **translated**: 不正なファイルです

- **com_ui_cancel**:
  - **english**: Cancel
  - **translated**: キャンセル

- **com_ui_save**:
  - **english**: Save
  - **translated**: 保存

- **com_ui_save_submit**:
  - **english**: Save & Submit
  - **translated**: 保存 & 送信

- **com_user_message**:
  - **english**: You
  - **translated**: あなた

- **com_ui_copy_to_clipboard**:
  - **english**: Copy to clipboard
  - **translated**: クリップボードへコピー

- **com_ui_copied_to_clipboard**:
  - **english**: Copied to clipboard
  - **translated**: コピーしました

- **com_ui_regenerate**:
  - **english**: Regenerate
  - **translated**: 再度 生成する

- **com_ui_continue**:
  - **english**: Continue
  - **translated**: 続きを生成する

- **com_ui_edit**:
  - **english**: Edit
  - **translated**: 編集

- **com_ui_success**:
  - **english**: Success
  - **translated**: 成功

- **com_ui_all**:
  - **english**: all
  - **translated**: すべて

- **com_ui_clear**:
  - **english**: Clear
  - **translated**: 削除する

- **com_ui_revoke**:
  - **english**: Revoke
  - **translated**: 無効にする

- **com_ui_revoke_info**:
  - **english**: Revoke all user provided credentials
  - **translated**: ユーザへ発行した認証情報をすべて無効にする。

- **com_ui_import_conversation**:
  - **english**: Import
  - **translated**: インポート

- **com_ui_import_conversation_info**:
  - **english**: Import conversations from a JSON file
  - **translated**: JSONファイルから会話をインポートする

- **com_ui_import_conversation_success**:
  - **english**: Conversations imported successfully
  - **translated**: 会話のインポートに成功しました

- **com_ui_import_conversation_error**:
  - **english**: There was an error importing your conversations
  - **translated**: 会話のインポート時にエラーが発生しました

- **com_ui_confirm_action**:
  - **english**: Confirm Action
  - **translated**: 実行する

- **com_ui_chats**:
  - **english**: chats
  - **translated**: チャット

- **com_ui_avatar**:
  - **english**: Avatar
  - **translated**: アバター

- **com_ui_unknown**:
  - **english**: Unknown
  - **translated**: 不明

- **com_ui_result**:
  - **english**: Result
  - **translated**: 結果

- **com_ui_image_gen**:
  - **english**: Image Gen
  - **translated**: 画像生成

- **com_ui_assistant**:
  - **english**: Assistant
  - **translated**: Assistant

- **com_ui_assistants**:
  - **english**: Assistants
  - **translated**: Assistants

- **com_ui_attachment**:
  - **english**: Attachment
  - **translated**: 添付ファイル

- **com_ui_assistants_output**:
  - **english**: Assistants Output
  - **translated**: Assistantsの出力

- **com_ui_delete**:
  - **english**: Delete
  - **translated**: 削除

- **com_ui_create**:
  - **english**: Create
  - **translated**: 作成

- **com_ui_delete_conversation**:
  - **english**: Delete chat?
  - **translated**: チャットを削除しますか？

- **com_ui_delete_confirm**:
  - **english**: This will delete
  - **translated**: このチャットは削除されます。

- **com_ui_delete_assistant_confirm**:
  - **english**: Are you sure you want to delete this Assistant? This cannot be undone.
  - **translated**: このアシスタントを削除しますか？ この操作は元に戻せません。

- **com_ui_rename**:
  - **english**: Rename
  - **translated**: タイトル変更

- **com_ui_archive**:
  - **english**: Archive
  - **translated**: アーカイブ

- **com_ui_archive_error**:
  - **english**: Failed to archive conversation
  - **translated**: アーカイブに失敗しました。

- **com_ui_unarchive**:
  - **english**: Unarchive
  - **translated**: アーカイブ解除

- **com_ui_unarchive_error**:
  - **english**: Failed to unarchive conversation
  - **translated**: アーカイブ解除に失敗しました。

- **com_ui_more_options**:
  - **english**: More
  - **translated**: More

- **com_ui_preview**:
  - **english**: Preview
  - **translated**: プレビュー

- **com_ui_upload**:
  - **english**: Upload
  - **translated**: アップロード

- **com_ui_connect**:
  - **english**: Connect
  - **translated**: 接続

- **com_ui_upload_delay**:
  - **english**: Uploading "{0}" is taking more time than anticipated. Please wait while the file finishes indexing for retrieval.
  - **translated**: ファイル "{0}"のアップロードに時間がかかっています。ファイルの検索のためのインデックス作成が完了するまでお待ちください。

- **com_ui_privacy_policy**:
  - **english**: Privacy policy
  - **translated**: プライバシーポリシー

- **com_ui_terms_of_service**:
  - **english**: Terms of service
  - **translated**: 利用規約

- **com_ui_min_tags**:
  - **english**: Cannot remove more values, a minimum of {0} are required.
  - **translated**: これ以上の値を削除できません。少なくとも {0} が必要です。

- **com_ui_max_tags**:
  - **english**: Maximum number allowed is {0}, using latest values.
  - **translated**: 最新の値を使用した場合、許可される最大数は {0} です。

- **com_auth_error_login**:
  - **english**: Unable to login with the information provided. Please check your credentials and try again.
  - **translated**: 入力された情報ではログインできませんでした。認証情報を確認した上で再度お試しください。

- **com_auth_error_login_rl**:
  - **english**: Too many login attempts in a short amount of time. Please try again later.
  - **translated**: お使いのIPアドレスから短時間に多数のログイン試行がありました。しばらくしてから再度お試しください。

- **com_auth_error_login_ban**:
  - **english**: Your account has been temporarily banned due to violations of our service.
  - **translated**: 本サービスの利用規約違反のため、一時的にアカウントを停止しました。

- **com_auth_error_login_server**:
  - **english**: There was an internal server error. Please wait a few moments and try again.
  - **translated**: サーバーエラーが発生しています。。しばらくしてから再度お試しください。

- **com_auth_no_account**:
  - **english**: Don't have an account?
  - **translated**: アカウントをお持ちでない場合はこちら

- **com_auth_sign_up**:
  - **english**: Sign up
  - **translated**: 新規登録

- **com_auth_sign_in**:
  - **english**: Sign in
  - **translated**: ログイン

- **com_auth_google_login**:
  - **english**: Continue with Google
  - **translated**: Googleでログイン

- **com_auth_facebook_login**:
  - **english**: Continue with Facebook
  - **translated**: Facebookでログイン

- **com_auth_github_login**:
  - **english**: Continue with Github
  - **translated**: Githubでログイン

- **com_auth_discord_login**:
  - **english**: Continue with Discord
  - **translated**: Discordでログイン

- **com_auth_email**:
  - **english**: Email
  - **translated**: メール

- **com_auth_email_required**:
  - **english**: Email is required
  - **translated**: メールアドレスは必須です

- **com_auth_email_min_length**:
  - **english**: Email must be at least 6 characters
  - **translated**: メールアドレスは最低6文字で入力してください

- **com_auth_email_max_length**:
  - **english**: Email should not be longer than 120 characters
  - **translated**: メールアドレスは最大120文字で入力してください

- **com_auth_email_pattern**:
  - **english**: You must enter a valid email address
  - **translated**: 有効なメールアドレスを入力してください

- **com_auth_email_address**:
  - **english**: Email address
  - **translated**: メールアドレス

- **com_auth_password**:
  - **english**: Password
  - **translated**: パスワード

- **com_auth_password_required**:
  - **english**: Password is required
  - **translated**: パスワードは必須です

- **com_auth_password_min_length**:
  - **english**: Password must be at least 8 characters
  - **translated**: パスワードは最低8文字で入力してください

- **com_auth_password_max_length**:
  - **english**: Password must be less than 128 characters
  - **translated**: パスワードは最大128文字で入力してください

- **com_auth_password_forgot**:
  - **english**: Forgot Password?
  - **translated**: パスワードを忘れた場合はこちら

- **com_auth_password_confirm**:
  - **english**: Confirm password
  - **translated**: 確認用パスワード

- **com_auth_password_not_match**:
  - **english**: Passwords do not match
  - **translated**: パスワードが一致しません

- **com_auth_continue**:
  - **english**: Continue
  - **translated**: 続ける

- **com_auth_create_account**:
  - **english**: Create your account
  - **translated**: アカウント登録

- **com_auth_error_create**:
  - **english**: There was an error attempting to register your account. Please try again.
  - **translated**: アカウント登録に失敗しました。もう一度お試しください。

- **com_auth_full_name**:
  - **english**: Full name
  - **translated**: フルネーム

- **com_auth_name_required**:
  - **english**: Name is required
  - **translated**: フルネームは必須です

- **com_auth_name_min_length**:
  - **english**: Name must be at least 3 characters
  - **translated**: フルネームは最低3文字で入力してください

- **com_auth_name_max_length**:
  - **english**: Name must be less than 80 characters
  - **translated**: フルネームは最大80文字で入力してください

- **com_auth_username**:
  - **english**: Username (optional)
  - **translated**: ユーザ名 (オプション)

- **com_auth_username_required**:
  - **english**: Username is required
  - **translated**: ユーザー名は必須です

- **com_auth_username_min_length**:
  - **english**: Username must be at least 2 characters
  - **translated**: ユーザ名は最低2文字で入力してください

- **com_auth_username_max_length**:
  - **english**: Username must be less than 20 characters
  - **translated**: ユーザ名は最大20文字で入力してください

- **com_auth_already_have_account**:
  - **english**: Already have an account?
  - **translated**: 既にアカウントがある場合はこちら

- **com_auth_login**:
  - **english**: Login
  - **translated**: ログイン

- **com_auth_reset_password**:
  - **english**: Reset your password
  - **translated**: パスワードをリセット

- **com_auth_click**:
  - **english**: Click
  - **translated**: クリック

- **com_auth_here**:
  - **english**: HERE
  - **translated**: こちら

- **com_auth_to_reset_your_password**:
  - **english**: to reset your password.
  - **translated**: to reset your password.

- **com_auth_reset_password_link_sent**:
  - **english**: Email Sent
  - **translated**: メールを送信

- **com_auth_reset_password_email_sent**:
  - **english**: An email has been sent to you with further instructions to reset your password.
  - **translated**: パスワードのリセット方法を記載したメールを送信しました。

- **com_auth_error_reset_password**:
  - **english**: There was a problem resetting your password. There was no user found with the email address provided. Please try again.
  - **translated**: パスワードのリセット中に問題が発生しました。指定されたメールアドレスのユーザは存在しません。別のメールアドレスでもう一度お試しください。

- **com_auth_reset_password_success**:
  - **english**: Password Reset Success
  - **translated**: パスワードのリセットに成功しました

- **com_auth_login_with_new_password**:
  - **english**: You may now login with your new password.
  - **translated**: 新しいパスワードでログインをお試しください。

- **com_auth_error_invalid_reset_token**:
  - **english**: This password reset token is no longer valid.
  - **translated**: 無効なパスワードリセットトークンです。

- **com_auth_click_here**:
  - **english**: Click here
  - **translated**: ここをクリック

- **com_auth_to_try_again**:
  - **english**: to try again.
  - **translated**: 再認証する

- **com_auth_submit_registration**:
  - **english**: Submit registration
  - **translated**: 登録をする

- **com_auth_welcome_back**:
  - **english**: Welcome back
  - **translated**: おかえりなさい

- **com_auth_back_to_login**:
  - **english**: Back to Login
  - **translated**: ログイン画面に戻る

- **com_endpoint_open_menu**:
  - **english**: Open Menu
  - **translated**: メニューを開く

- **com_endpoint_bing_enable_sydney**:
  - **english**: Enable Sydney
  - **translated**: Sydney有効化

- **com_endpoint_bing_to_enable_sydney**:
  - **english**: To enable Sydney
  - **translated**: (Sydneyを利用する)

- **com_endpoint_bing_jailbreak**:
  - **english**: Jailbreak
  - **translated**: ジェイルブレイク

- **com_endpoint_bing_context_placeholder**:
  - **english**: Bing can use up to 7k tokens for 'context', which it can reference for the conversation. The specific limit is not known but may run into errors exceeding 7k tokens
  - **translated**: Bingは最大7kトークンの「コンテキスト」を参照できます。具体的な上限は不明ですが、7kトークンを超えるとエラーになる可能性があります。

- **com_endpoint_bing_system_message_placeholder**:
  - **english**: WARNING: Misuse of this feature can get you BANNED from using Bing! Click on 'System Message' for full instructions and the default message if omitted, which is the 'Sydney' preset that is considered safe.
  - **translated**: 警告: この機能を悪用するとBingの利用を「制限」される可能性があります。すべての内容を表示するには「System Message」をクリックしてください。省略された場合は、安全と考えられる「Sydney」プリセットが使われます

- **com_endpoint_system_message**:
  - **english**: System Message
  - **translated**: システムメッセージ

- **com_endpoint_message**:
  - **english**: Message
  - **translated**: メッセージ

- **com_endpoint_message_not_appendable**:
  - **english**: Edit your message or Regenerate.
  - **translated**: メッセージを編集、再入力してください。

- **com_endpoint_default_blank**:
  - **english**: default: blank
  - **translated**: デフォルト: 空

- **com_endpoint_default_false**:
  - **english**: default: false
  - **translated**: デフォルト: false

- **com_endpoint_default_creative**:
  - **english**: default: creative
  - **translated**: デフォルト: 創造的

- **com_endpoint_default_empty**:
  - **english**: default: empty
  - **translated**: デフォルト: 空

- **com_endpoint_default_with_num**:
  - **english**: default: {0}
  - **translated**: デフォルト: {0}

- **com_endpoint_context**:
  - **english**: Context
  - **translated**: コンテキスト

- **com_endpoint_tone_style**:
  - **english**: Tone Style
  - **translated**: トーンスタイル

- **com_endpoint_token_count**:
  - **english**: Token count
  - **translated**: トークン数

- **com_endpoint_output**:
  - **english**: Output
  - **translated**: 出力

- **com_endpoint_google_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: 大きい値 = ランダム性が増します。低い値 = より決定論的になります。この値を変更するか、Top P の変更をおすすめしますが、両方を変更はおすすめしません。

- **com_endpoint_google_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p はモデルがトークンをどのように選択して出力するかを変更します。K(topKを参照)の確率の合計がtop-pの確率と等しくなるまでのトークンが選択されます。

- **com_endpoint_google_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k はモデルがトークンをどのように選択して出力するかを変更します。top-kが1の場合はモデルの語彙に含まれるすべてのトークンの中で最も確率が高い1つが選択されます(greedy decodingと呼ばれている)。top-kが3の場合は上位3つのトークンの中から選択されます。(temperatureを使用)

- **com_endpoint_google_maxoutputtokens**:
  - **english**:  	Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**:  	生成されるレスポンスの最大トークン数。短いレスポンスには低い値を、長いレスポンスには高い値を指定します。

- **com_endpoint_google_custom_name_placeholder**:
  - **english**: Set a custom name for Google
  - **translated**: Googleのカスタム名を設定する

- **com_endpoint_prompt_prefix_placeholder**:
  - **english**: Set custom instructions or context. Ignored if empty.
  - **translated**: custom instructions か context を設定する。空の場合は無視されます。

- **com_endpoint_custom_name**:
  - **english**: Custom Name
  - **translated**: プリセット名

- **com_endpoint_prompt_prefix**:
  - **english**: Custom Instructions
  - **translated**: プロンプトの先頭

- **com_endpoint_instructions_assistants_placeholder**:
  - **english**: Overrides the instructions of the assistant. This is useful for modifying the behavior on a per-run basis.
  - **translated**: アシスタントの指示を上書きします。これは、実行ごとに動作を変更する場合に便利です。

- **com_endpoint_prompt_prefix_assistants_placeholder**:
  - **english**: Set additional instructions or context on top of the Assistant's main instructions. Ignored if empty.
  - **translated**: アシスタントの主な指示に加えて、追加の指示やコンテキストを設定します。空欄の場合は無視されます。

- **com_endpoint_temperature**:
  - **english**: Temperature
  - **translated**: Temperature

- **com_endpoint_default**:
  - **english**: default
  - **translated**: デフォルト

- **com_endpoint_top_p**:
  - **english**: Top P
  - **translated**: Top P

- **com_endpoint_top_k**:
  - **english**: Top K
  - **translated**: Top K

- **com_endpoint_max_output_tokens**:
  - **english**: Max Output Tokens
  - **translated**: 最大出力トークン数

- **com_endpoint_openai_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: 大きい値 = ランダム性が増します。低い値 = より決定論的になります。この値を変更するか、Top P の変更をおすすめしますが、両方を変更はおすすめしません。

- **com_endpoint_openai_max**:
  - **english**: The max tokens to generate. The total length of input tokens and generated tokens is limited by the model's context length.
  - **translated**: 生成されるトークンの最大値。入力トークンと出力トークンの長さの合計は、モデルのコンテキスト長によって制限されます。

- **com_endpoint_openai_topp**:
  - **english**: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We recommend altering this or temperature but not both.
  - **translated**: nucleus sampling と呼ばれるtemperatureを使用したサンプリングの代わりに、top_p確率質量のトークンの結果を考慮します。つまり、0.1とすると確率質量の上位10%を構成するトークンのみが考慮されます。この値かtemperatureの変更をおすすめしますが、両方を変更はおすすめしません。

- **com_endpoint_openai_freq**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
  - **translated**: -2.0から2.0の値。正の値を入力すると、テキストの繰り返し頻度に基づいたペナルティを課し、文字通り「同じ文言」を繰り返す可能性を減少させる。

- **com_endpoint_openai_pres**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
  - **translated**: -2.0から2.0の値。正の値は入力すると、新規トークンの出現に基づいたペナルティを課し、新しいトピックについて話す可能性を高める。

- **com_endpoint_openai_resend**:
  - **english**: Resend all previously attached images. Note: this can significantly increase token cost and you may experience errors with many image attachments.
  - **translated**: これまでに添付した画像を全て再送信します。注意：トークン数が大幅に増加したり、多くの画像を添付するとエラーが発生する可能性があります。

- **com_endpoint_openai_resend_files**:
  - **english**: Resend all previously attached files. Note: this will increase token cost and you may experience errors with many attachments.
  - **translated**: 以前に添付されたすべてのファイルを再送信します。注意：これにより、トークンのコストが増加し、多くの添付ファイルでエラーが発生する可能性があります。

- **com_endpoint_openai_detail**:
  - **english**: The resolution for Vision requests. "Low" is cheaper and faster, "High" is more detailed and expensive, and "Auto" will automatically choose between the two based on the image resolution.
  - **translated**: Visionリクエストの解像度を選択します。"Low"はコストが安くて低解像度、"Highは"コストが高くて高解像度"、"Auto"は画像の解像度に基づいて自動的に選択します。

- **com_endpoint_openai_custom_name_placeholder**:
  - **english**: Set a custom name for the AI
  - **translated**: ChatGPTのカスタム名を設定する

- **com_endpoint_openai_prompt_prefix_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: システムメッセージに含める Custom Instructions。デフォルト: none

- **com_endpoint_anthropic_temp**:
  - **english**: Ranges from 0 to 1. Use temp closer to 0 for analytical / multiple choice, and closer to 1 for creative and generative tasks. We recommend altering this or Top P but not both.
  - **translated**: 0から1の値。分析的・多岐の選択になる課題には0に近い値を入力する。創造的・生成的な課題には1に近い値を入力する。この値か Top P の変更をおすすめしますが、両方の変更はおすすめしません。

- **com_endpoint_anthropic_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p はモデルがトークンをどのように選択して出力するかを変更する。K(topKを参照)の確率の合計がtop-pの確率と等しくなるまでのトークンが選択される。

- **com_endpoint_anthropic_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k はモデルがトークンをどのように選択して出力するかを変更する。top-kが1の場合はモデルの語彙に含まれるすべてのトークンの中で最も確率が高い1つが選択される(greedy decodingと呼ばれている)。top-kが3の場合は上位3つのトークンの中から選択される。(temperatureを使用)

- **com_endpoint_anthropic_maxoutputtokens**:
  - **english**: Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: 生成されるレスポンスの最大トークン数。短いレスポンスには低い値を、長いレスポンスには高い値を指定する。

- **com_endpoint_anthropic_custom_name_placeholder**:
  - **english**: Set a custom name for Anthropic
  - **translated**: Anthropicのカスタム名を設定する

- **com_endpoint_frequency_penalty**:
  - **english**: Frequency Penalty
  - **translated**: 頻度によるペナルティ

- **com_endpoint_presence_penalty**:
  - **english**: Presence Penalty
  - **translated**: 既存性によるペナルティ

- **com_endpoint_plug_use_functions**:
  - **english**: Use Functions
  - **translated**: Functionsを使用

- **com_endpoint_plug_resend_files**:
  - **english**: Resend Files
  - **translated**: ファイルを再送

- **com_endpoint_plug_resend_images**:
  - **english**: Resend Images
  - **translated**: 画像の再送信

- **com_endpoint_plug_image_detail**:
  - **english**: Image Detail
  - **translated**: 画像の詳細

- **com_endpoint_plug_skip_completion**:
  - **english**: Skip Completion
  - **translated**: Skip Completion

- **com_endpoint_disabled_with_tools**:
  - **english**: disabled with tools
  - **translated**: disabled with tools

- **com_endpoint_disabled_with_tools_placeholder**:
  - **english**: Disabled with Tools Selected
  - **translated**: Disabled with Tools Selected

- **com_endpoint_plug_set_custom_instructions_for_gpt_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: システムメッセージに含める Custom Instructions。デフォルト: none

- **com_endpoint_import**:
  - **english**: Import
  - **translated**: インポート

- **com_endpoint_set_custom_name**:
  - **english**: Set a custom name, in case you can find this preset
  - **translated**: このプリセットを見つけやすいように名前を設定する。

- **com_endpoint_preset_delete_confirm**:
  - **english**: Are you sure you want to delete this preset?
  - **translated**: 本当にこのプリセットを削除しますか？

- **com_endpoint_preset_clear_all_confirm**:
  - **english**: Are you sure you want to delete all of your presets?
  - **translated**: 本当にすべてのプリセットを削除しますか？

- **com_endpoint_preset_import**:
  - **english**: Preset Imported!
  - **translated**: プリセットのインポートが完了しました

- **com_endpoint_preset_import_error**:
  - **english**: There was an error importing your preset. Please try again.
  - **translated**: プリセットのインポートに失敗しました。もう一度お試し下さい。

- **com_endpoint_preset_save_error**:
  - **english**: There was an error saving your preset. Please try again.
  - **translated**: プリセットの保存に失敗しました。もう一度お試し下さい。

- **com_endpoint_preset_delete_error**:
  - **english**: There was an error deleting your preset. Please try again.
  - **translated**: プリセットの削除に失敗しました。もう一度お試し下さい。

- **com_endpoint_preset_default_removed**:
  - **english**: is no longer the default preset.
  - **translated**: が無効化されました。

- **com_endpoint_preset_default_item**:
  - **english**: Default:
  - **translated**: デフォルト:

- **com_endpoint_preset_default_none**:
  - **english**: No default preset active.
  - **translated**: 現在有効なプリセットはありません。

- **com_endpoint_preset_title**:
  - **english**: Preset
  - **translated**: プリセット

- **com_endpoint_preset_saved**:
  - **english**: Saved!
  - **translated**: 保存しました!

- **com_endpoint_preset_default**:
  - **english**: is now the default preset.
  - **translated**: が有効化されました。

- **com_endpoint_preset**:
  - **english**: preset
  - **translated**: プリセット

- **com_endpoint_presets**:
  - **english**: presets
  - **translated**: プリセット

- **com_endpoint_preset_selected**:
  - **english**: Preset Active!
  - **translated**: プリセットが有効化されました!

- **com_endpoint_preset_selected_title**:
  - **english**: Active!
  - **translated**: 有効化

- **com_endpoint_preset_name**:
  - **english**: Preset Name
  - **translated**: プリセット名

- **com_endpoint_new_topic**:
  - **english**: New Topic
  - **translated**: 新規トピック

- **com_endpoint**:
  - **english**: Endpoint
  - **translated**: エンドポイント

- **com_endpoint_hide**:
  - **english**: Hide
  - **translated**: 非表示

- **com_endpoint_show**:
  - **english**: Show
  - **translated**: 表示

- **com_endpoint_examples**:
  - **english**:  Presets
  - **translated**:  プリセット名

- **com_endpoint_completion**:
  - **english**: Completion
  - **translated**: コンプリーション

- **com_endpoint_agent**:
  - **english**: Agent
  - **translated**: エージェント

- **com_endpoint_show_what_settings**:
  - **english**: Show {0} Settings
  - **translated**: 設定 {0} を表示する

- **com_endpoint_export**:
  - **english**: Export
  - **translated**: エクスポート

- **com_endpoint_assistant**:
  - **english**: Assistant
  - **translated**: アシスタント

- **com_endpoint_use_active_assistant**:
  - **english**: Use Active Assistant
  - **translated**: アクティブなアシスタントを使用

- **com_endpoint_assistant_model**:
  - **english**: Assistant Model
  - **translated**: アシスタント モデル

- **com_endpoint_save_as_preset**:
  - **english**: Save As Preset
  - **translated**: プリセットとして保存する

- **com_endpoint_presets_clear_warning**:
  - **english**: Are you sure you want to clear all presets? This is irreversible.
  - **translated**: 本当にすべてのプリセットを削除しますか？ この操作は元に戻せません。

- **com_endpoint_not_implemented**:
  - **english**: Not implemented
  - **translated**: まだ実装されていません

- **com_endpoint_no_presets**:
  - **english**: No presets yet, use the settings button to create one
  - **translated**: プリセットがありません

- **com_endpoint_not_available**:
  - **english**: No endpoint available
  - **translated**: エンドポイントは利用できません

- **com_endpoint_view_options**:
  - **english**: View Options
  - **translated**: オプションを見る

- **com_endpoint_save_convo_as_preset**:
  - **english**: Save Conversation as Preset
  - **translated**: 会話をプリセットとして保存する

- **com_endpoint_my_preset**:
  - **english**: My Preset
  - **translated**: Myプリセット

- **com_endpoint_agent_model**:
  - **english**: Agent Model (Recommended: GPT-3.5)
  - **translated**: エージェントモデル (推奨: GPT-3.5)

- **com_endpoint_completion_model**:
  - **english**: Completion Model (Recommended: GPT-4)
  - **translated**: コンプリーションモデル (推奨: GPT-4)

- **com_endpoint_func_hover**:
  - **english**: Enable use of Plugins as OpenAI Functions
  - **translated**: プラグインをOpenAIの関数として使えるようにする

- **com_endpoint_skip_hover**:
  - **english**: Enable skipping the completion step, which reviews the final answer and generated steps
  - **translated**: コンプリーションのステップをスキップする。(最終的な回答と生成されたステップをレビューする機能)

- **com_endpoint_stop**:
  - **english**: Stop Sequences
  - **translated**: シーケンスを停止

- **com_endpoint_stop_placeholder**:
  - **english**: Separate values by pressing `Enter`
  - **translated**: Enterキー押下で値を区切ります

- **com_endpoint_openai_stop**:
  - **english**: Up to 4 sequences where the API will stop generating further tokens.
  - **translated**: APIがさらにトークンを生成するのを止めるため、最大で4つのシーケンスを設定可能

- **com_endpoint_config_key**:
  - **english**: Set API Key
  - **translated**: API Keyを設定

- **com_endpoint_assistant_placeholder**:
  - **english**: Please select an Assistant from the right-hand Side Panel
  - **translated**: 右側のサイドパネルからアシスタントを選択してください

- **com_endpoint_config_placeholder**:
  - **english**: Set your Key in the Header menu to chat.
  - **translated**: ヘッダーメニューからAPI Keyを設定してください。

- **com_endpoint_config_key_for**:
  - **english**: Set API Key for
  - **translated**: API Key の設定: 

- **com_endpoint_config_key_name**:
  - **english**: Key
  - **translated**: Key

- **com_endpoint_config_value**:
  - **english**: Enter value for
  - **translated**: 値を入力してください

- **com_endpoint_config_key_name_placeholder**:
  - **english**: Set API key first
  - **translated**: API key を入力してください

- **com_endpoint_config_key_encryption**:
  - **english**: Your key will be encrypted and deleted at
  - **translated**: 鍵は暗号化されます。削除予定日:

- **com_endpoint_config_key_expiry**:
  - **english**: the expiry time
  - **translated**: すでに有効期限切れです

- **com_endpoint_config_click_here**:
  - **english**: Click Here
  - **translated**: ここをクリック

- **com_endpoint_config_google_service_key**:
  - **english**: Google Service Account Key
  - **translated**: Google Service Account Key

- **com_endpoint_config_google_cloud_platform**:
  - **english**: (from Google Cloud Platform)
  - **translated**: (from Google Cloud Platform)

- **com_endpoint_config_google_api_key**:
  - **english**: Google API Key
  - **translated**: Google API Key

- **com_endpoint_config_google_gemini_api**:
  - **english**: (Gemini API)
  - **translated**: (Gemini API)

- **com_endpoint_config_google_api_info**:
  - **english**: To get your Generative Language API key (for Gemini),
  - **translated**: Gemeni用のGenerative Language API keyを取得するには

- **com_endpoint_config_key_import_json_key**:
  - **english**: Import Service Account JSON Key.
  - **translated**: Service Account JSON Key をインポートする。

- **com_endpoint_config_key_import_json_key_success**:
  - **english**: Successfully Imported Service Account JSON Key
  - **translated**: Service Account JSON Keyのインポートに成功しました。

- **com_endpoint_config_key_import_json_key_invalid**:
  - **english**: Invalid Service Account JSON Key, Did you import the correct file?
  - **translated**: 無効なService Account JSON Keyです。正しいファイルかどうか確認してください。

- **com_endpoint_config_key_get_edge_key**:
  - **english**: To get your Access token for Bing, login to
  - **translated**: Bing用のアクセストークンを取得するためにログインをしてください: 

- **com_endpoint_config_key_get_edge_key_dev_tool**:
  - **english**: Use dev tools or an extension while logged into the site to copy the content of the _U cookie. If this fails, follow these
  - **translated**: サイトにログインした状態で、開発ツールまたは拡張機能を使用して、_U クッキーの内容をコピーします。もし失敗する場合は次の手順に従ってください。

- **com_endpoint_config_key_edge_instructions**:
  - **english**: instructions
  - **translated**: 手順

- **com_endpoint_config_key_edge_full_key_string**:
  - **english**: to provide the full cookie strings.
  - **translated**: to provide the full cookie strings.

- **com_endpoint_config_key_chatgpt**:
  - **english**: To get your Access token For ChatGPT 'Free Version', login to
  - **translated**: ChatGPTの「無料版」のアクセストークンを入手するためにへログインをしてください:

- **com_endpoint_config_key_chatgpt_then_visit**:
  - **english**: then visit
  - **translated**: つぎに、ここへアクセスしてください:

- **com_endpoint_config_key_chatgpt_copy_token**:
  - **english**: Copy access token.
  - **translated**: トークンをコピーしてください。

- **com_endpoint_config_key_google_need_to**:
  - **english**: You need to
  - **translated**: こちらを有効化する必要があります:

- **com_endpoint_config_key_google_vertex_ai**:
  - **english**: Enable Vertex AI
  - **translated**: Vertex AI を有効化

- **com_endpoint_config_key_google_vertex_api**:
  - **english**: API on Google Cloud, then
  - **translated**: API (Google Cloud) 次に、

- **com_endpoint_config_key_google_service_account**:
  - **english**: Create a Service Account
  - **translated**: サービスアカウントを作成する

- **com_endpoint_config_key_google_vertex_api_role**:
  - **english**: Make sure to click 'Create and Continue' to give at least the 'Vertex AI User' role. Lastly, create a JSON key to import here.
  - **translated**: 必ず「作成して続行」をクリックして、少なくとも「Vertex AI ユーザー」権限を与えてください。最後にここにインポートするJSONキーを作成してください。

- **com_nav_welcome_message**:
  - **english**: How can I help you today?
  - **translated**: How can I help you today?

- **com_nav_auto_scroll**:
  - **english**: Auto-scroll to Newest on Open
  - **translated**: チャットを開いたときに最新まで自動でスクロール

- **com_nav_hide_panel**:
  - **english**: Hide Right-most Side Panel
  - **translated**: 右側のパネルを非表示

- **com_nav_modular_chat**:
  - **english**: Enable switching Endpoints mid-conversation
  - **translated**: 会話の途中でのエンドポイント切替を有効化

- **com_nav_latex_parsing**:
  - **english**: Parsing LaTeX in messages (may affect performance)
  - **translated**: メッセージ内の LaTeX の構文解析 (パフォーマンスに影響する可能性があります。)

- **com_nav_profile_picture**:
  - **english**: Profile Picture
  - **translated**: プロフィール画像

- **com_nav_change_picture**:
  - **english**: Change picture
  - **translated**: 画像を変更

- **com_nav_plugin_search**:
  - **english**: Search plugins
  - **translated**: プラグイン検索

- **com_nav_plugin_store**:
  - **english**: Plugin store
  - **translated**: プラグインストア

- **com_nav_plugin_install**:
  - **english**: Install
  - **translated**: インストール

- **com_nav_plugin_uninstall**:
  - **english**: Uninstall
  - **translated**: アンインストール

- **com_ui_add**:
  - **english**: Add
  - **translated**: 追加

- **com_nav_tool_dialog**:
  - **english**: Assistant Tools
  - **translated**: アシスタントツール

- **com_nav_tool_dialog_description**:
  - **english**: Assistant must be saved to persist tool selections.
  - **translated**: ツールの選択を維持するには、アシスタントを保存する必要があります。

- **com_nav_tool_remove**:
  - **english**: Remove
  - **translated**: 削除

- **com_nav_tool_search**:
  - **english**: Search tools
  - **translated**: ツールを検索

- **com_show_agent_settings**:
  - **english**: Show Agent Settings
  - **translated**: エージェント設定を表示

- **com_show_completion_settings**:
  - **english**: Show Completion Settings
  - **translated**: コンプリーション設定を表示

- **com_hide_examples**:
  - **english**: Hide Examples
  - **translated**: 例を非表示

- **com_show_examples**:
  - **english**: Show Examples
  - **translated**: 例を表示

- **com_nav_plugin_auth_error**:
  - **english**: There was an error attempting to authenticate this plugin. Please try again.
  - **translated**: このプラグインの認証中にエラーが発生しました。もう一度お試しください。

- **com_nav_export_filename**:
  - **english**: Filename
  - **translated**: ファイル名

- **com_nav_export_filename_placeholder**:
  - **english**: Set the filename
  - **translated**: ファイル名を入力してください

- **com_nav_export_type**:
  - **english**: Type
  - **translated**: 形式

- **com_nav_export_include_endpoint_options**:
  - **english**: Include endpoint options
  - **translated**: エンドポイントのオプションを含める

- **com_nav_enabled**:
  - **english**: Enabled
  - **translated**: 有効化

- **com_nav_not_supported**:
  - **english**: Not Supported
  - **translated**: サポートされていません

- **com_nav_export_all_message_branches**:
  - **english**: Export all message branches
  - **translated**: すべての子メッセージを含める

- **com_nav_export_recursive_or_sequential**:
  - **english**: Recursive or sequential?
  - **translated**: 再帰的? or 順次的?

- **com_nav_export_recursive**:
  - **english**: Recursive
  - **translated**: 再帰的

- **com_nav_export_conversation**:
  - **english**: Export conversation
  - **translated**: 会話をエクスポートする

- **com_nav_my_files**:
  - **english**: My Files
  - **translated**: My Files

- **com_nav_theme**:
  - **english**: Theme
  - **translated**: テーマ

- **com_nav_theme_system**:
  - **english**: System
  - **translated**: システム

- **com_nav_theme_dark**:
  - **english**: Dark
  - **translated**: ダーク

- **com_nav_theme_light**:
  - **english**: Light
  - **translated**: ライト

- **com_nav_enter_to_send**:
  - **english**: Press Enter to send messages
  - **translated**: Enterキーでメッセージを送信する

- **com_nav_user_name_display**:
  - **english**: Display username in messages
  - **translated**: メッセージにユーザー名を表示する

- **com_nav_show_code**:
  - **english**: Always show code when using code interpreter
  - **translated**: Code Interpreter を使用する際は常にコードを表示する

- **com_nav_clear_all_chats**:
  - **english**: Clear all chats
  - **translated**: すべてのチャットを削除する

- **com_nav_confirm_clear**:
  - **english**: Confirm Clear
  - **translated**: 削除を確定

- **com_nav_close_sidebar**:
  - **english**: Close sidebar
  - **translated**: サイドバーを閉じる

- **com_nav_open_sidebar**:
  - **english**: Open sidebar
  - **translated**: サイドバーを開く

- **com_nav_send_message**:
  - **english**: Send message
  - **translated**: メッセージを送信する

- **com_nav_log_out**:
  - **english**: Log out
  - **translated**: ログアウト

- **com_nav_user**:
  - **english**: USER
  - **translated**: ユーザー

- **com_nav_archived_chats**:
  - **english**: Archived chats
  - **translated**: アーカイブされたチャット

- **com_nav_archived_chats_manage**:
  - **english**: Manage
  - **translated**: 管理

- **com_nav_archived_chats_empty**:
  - **english**: You have no archived conversations.
  - **translated**: アーカイブされたチャットはありません

- **com_nav_archive_all_chats**:
  - **english**: Archive all chats
  - **translated**: すべてのチャットをアーカイブ

- **com_nav_archive_all**:
  - **english**: Archive all
  - **translated**: すべてアーカイブする

- **com_nav_archive_name**:
  - **english**: Name
  - **translated**: 名前

- **com_nav_archive_created_at**:
  - **english**: DateCreated
  - **translated**: 作成日

- **com_nav_clear_conversation**:
  - **english**: Clear conversations
  - **translated**: 会話を削除する

- **com_nav_clear_conversation_confirm_message**:
  - **english**: Are you sure you want to clear all conversations? This is irreversible.
  - **translated**: 本当にすべての会話を削除しますか？ この操作は取り消せません。

- **com_nav_help_faq**:
  - **english**: Help & FAQ
  - **translated**: ヘルプ & FAQ

- **com_nav_settings**:
  - **english**: Settings
  - **translated**: 設定

- **com_nav_search_placeholder**:
  - **english**: Search messages
  - **translated**: メッセージ検索

- **com_nav_setting_general**:
  - **english**: General
  - **translated**: 一般

- **com_nav_setting_beta**:
  - **english**: Beta features
  - **translated**: ベータ版の機能

- **com_nav_setting_data**:
  - **english**: Data controls
  - **translated**: データ管理

- **com_nav_setting_account**:
  - **english**: Account
  - **translated**: アカウント

Please consider the above comparisons to enhance understanding and guide improvements in translations.

Provide insights or suggestions that could help refine the translation process, focusing on cultural and contextual relevance.

Please craft a prompt that can be used to better inform future translations to this language.

Write this prompt in the translated language, with all its nuances detected, not in the English.
