# Instructions for Translation

Write a prompt that is mindful of the nuances in the language with respect to its English counterpart, which serves as the baseline for translations. Here are the comparisons between the language translations and their English counterparts:


- **com_error_moderation**:
  - **english**: It appears that the content submitted has been flagged by our moderation system for not aligning with our community guidelines. We're unable to proceed with this specific topic. If you have any other questions or topics you'd like to explore, please edit your message, or create a new conversation.
  - **translated**: Sembra che il contenuto inviato sia stato contrassegnato dal nostro sistema di moderazione per non essere allineato con le nostre linee guida della community. Non possiamo procedere con questo argomento specifico. Se hai altre domande o argomenti che vorresti esplorare, modifica il tuo messaggio o crea una nuova conversazione.

- **com_error_no_user_key**:
  - **english**: No key found. Please provide a key and try again.
  - **translated**: Nessuna chiave trovata. Fornisci una chiave e riprova.

- **com_error_no_base_url**:
  - **english**: No base URL found. Please provide one and try again.
  - **translated**: Nessun URL base trovato. Forniscine uno e riprova.

- **com_error_invalid_user_key**:
  - **english**: Invalid key provided. Please provide a key and try again.
  - **translated**: Chiave fornita non valida. Fornisci una chiave e riprova.

- **com_error_expired_user_key**:
  - **english**: Provided key for {0} expired at {1}. Please provide a key and try again.
  - **translated**: La chiave fornita per {0} è scaduta il {1}. Fornisci una chiave e riprova.

- **com_files_no_results**:
  - **english**: No results.
  - **translated**: Nessun risultato.

- **com_files_filter**:
  - **english**: Filter files...
  - **translated**: Filtra file...

- **com_files_number_selected**:
  - **english**: {0} of {1} file(s) selected
  - **translated**: {0} di {1} file selezionati

- **com_sidepanel_select_assistant**:
  - **english**: Select an Assistant
  - **translated**: Seleziona un Assistente

- **com_sidepanel_parameters**:
  - **english**: Parameters
  - **translated**: Parametri

- **com_sidepanel_assistant_builder**:
  - **english**: Assistant Builder
  - **translated**: Costruttore Assistente

- **com_sidepanel_hide_panel**:
  - **english**: Hide Panel
  - **translated**: Nascondi Pannello

- **com_sidepanel_attach_files**:
  - **english**: Attach Files
  - **translated**: Allega File

- **com_sidepanel_manage_files**:
  - **english**: Manage Files
  - **translated**: Gestisci File

- **com_assistants_capabilities**:
  - **english**: Capabilities
  - **translated**: Capacità

- **com_assistants_knowledge**:
  - **english**: Knowledge
  - **translated**: Conoscenza

- **com_assistants_knowledge_info**:
  - **english**: If you upload files under Knowledge, conversations with your Assistant may include file contents.
  - **translated**: Se carichi file sotto Conoscenza, le conversazioni con il tuo Assistente potrebbero includere i contenuti dei file.

- **com_assistants_knowledge_disabled**:
  - **english**: Assistant must be created, and Code Interpreter or Retrieval must be enabled and saved before uploading files as Knowledge.
  - **translated**: L'Assistente deve essere creato, e Code Interpreter o Retrieval devono essere abilitati e salvati prima di caricare file come Conoscenza.

- **com_assistants_image_vision**:
  - **english**: Image Vision
  - **translated**: Visione Immagine

- **com_assistants_code_interpreter**:
  - **english**: Code Interpreter
  - **translated**: Interprete Codice

- **com_assistants_code_interpreter_files**:
  - **english**: The following files are only available for Code Interpreter:
  - **translated**: I seguenti file sono disponibili solo per Code Interpreter:

- **com_assistants_retrieval**:
  - **english**: Retrieval
  - **translated**: Retrival

- **com_assistants_search_name**:
  - **english**: Search assistants by name
  - **translated**: Cerca assistenti per nome

- **com_ui_tools**:
  - **english**: Tools
  - **translated**: Strumenti

- **com_assistants_actions**:
  - **english**: Actions
  - **translated**: Azioni

- **com_assistants_add_tools**:
  - **english**: Add Tools
  - **translated**: Aggiungi Strumenti

- **com_assistants_add_actions**:
  - **english**: Add Actions
  - **translated**: Aggiungi Azioni

- **com_assistants_available_actions**:
  - **english**: Available Actions
  - **translated**: Azioni Disponibili

- **com_assistants_running_action**:
  - **english**: Running action
  - **translated**: Azione in corso

- **com_assistants_completed_action**:
  - **english**: Talked to {0}
  - **translated**: Parlato con {0}

- **com_assistants_completed_function**:
  - **english**: Ran {0}
  - **translated**: Eseguito {0}

- **com_assistants_function_use**:
  - **english**: Assistant used {0}
  - **translated**: L'Assistente ha usato {0}

- **com_assistants_domain_info**:
  - **english**: Assistant sent this info to {0}
  - **translated**: L'Assistente ha inviato queste informazioni a {0}

- **com_assistants_delete_actions_success**:
  - **english**: Successfully deleted Action from Assistant
  - **translated**: Azione eliminata dall'Assistente con successo

- **com_assistants_update_actions_success**:
  - **english**: Successfully created or updated Action
  - **translated**: Azione creata o aggiornata con successo

- **com_assistants_update_actions_error**:
  - **english**: There was an error creating or updating the action.
  - **translated**: Si è verificato un errore durante la creazione o l'aggiornamento dell'azione.

- **com_assistants_delete_actions_error**:
  - **english**: There was an error deleting the action.
  - **translated**: Si è verificato un errore durante l'eliminazione dell'azione.

- **com_assistants_actions_info**:
  - **english**: Let your Assistant retrieve information or take actions via API's
  - **translated**: Permetti al tuo Assistente di recuperare informazioni o eseguire azioni tramite API

- **com_assistants_name_placeholder**:
  - **english**: Optional: The name of the assistant
  - **translated**: Opzionale: Il nome dell'assistente

- **com_assistants_instructions_placeholder**:
  - **english**: The system instructions that the assistant uses
  - **translated**: Le istruzioni di sistema che l'assistente utilizza

- **com_assistants_description_placeholder**:
  - **english**: Optional: Describe your Assistant here
  - **translated**: Opzionale: Descrivi qui il tuo Assistente

- **com_assistants_actions_disabled**:
  - **english**: You need to create an assistant before adding actions.
  - **translated**: Devi prima creare un assistente prima di aggiungere azioni.

- **com_assistants_update_success**:
  - **english**: Successfully updated
  - **translated**: Aggiornamento avvenuto con successo

- **com_assistants_update_error**:
  - **english**: There was an error updating your assistant.
  - **translated**: Si è verificato un errore durante l'aggiornamento del tuo assistente.

- **com_assistants_create_success**:
  - **english**: Successfully created
  - **translated**: Creazione avvenuta con successo

- **com_assistants_create_error**:
  - **english**: There was an error creating your assistant.
  - **translated**: Si è verificato un errore durante la creazione del tuo assistente.

- **com_ui_field_required**:
  - **english**: This field is required
  - **translated**: Questo campo è obbligatorio

- **com_ui_download_error**:
  - **english**: Error downloading file. The file may have been deleted.
  - **translated**: Errore durante il download del file. Il file potrebbe essere stato eliminato.

- **com_ui_attach_error_type**:
  - **english**: Unsupported file type for endpoint:
  - **translated**: Tipo di file non supportato per l'endpoint:

- **com_ui_attach_error_size**:
  - **english**: File size limit exceeded for endpoint:
  - **translated**: Limite dimensione file superato per l'endpoint:

- **com_ui_attach_error**:
  - **english**: Cannot attach file. Create or select a conversation, or try refreshing the page.
  - **translated**: Impossibile allegare il file. Crea o seleziona una conversazione, oppure prova a ricaricare la pagina.

- **com_ui_examples**:
  - **english**: Examples
  - **translated**: Esempi

- **com_ui_new_chat**:
  - **english**: New chat
  - **translated**: Nuova chat

- **com_ui_happy_birthday**:
  - **english**: It's my 1st birthday!
  - **translated**: È il mio 1° compleanno!

- **com_ui_example_quantum_computing**:
  - **english**: Explain quantum computing in simple terms
  - **translated**: Spiega l'informatica quantistica in termini semplici

- **com_ui_example_10_year_old_b_day**:
  - **english**: Got any creative ideas for a 10 year old's birthday?
  - **translated**: Hai qualche idea creativa per il compleanno di un bambino di 10 anni?

- **com_ui_example_http_in_js**:
  - **english**: How do I make an HTTP request in Javascript?
  - **translated**: Come faccio a fare una richiesta HTTP in Javascript?

- **com_ui_capabilities**:
  - **english**: Capabilities
  - **translated**: Capacità

- **com_ui_capability_remember**:
  - **english**: Remembers what user said earlier in the conversation
  - **translated**: Ricorda ciò che l'utente ha detto prima nella conversazione

- **com_ui_capability_correction**:
  - **english**: Allows user to provide follow-up corrections
  - **translated**: Permette all'utente di fornire correzioni successive

- **com_ui_capability_decline_requests**:
  - **english**: Trained to decline inappropriate requests
  - **translated**: Addestrato a rifiutare richieste inappropriate

- **com_ui_limitations**:
  - **english**: Limitations
  - **translated**: Limitazioni

- **com_ui_limitation_incorrect_info**:
  - **english**: May occasionally generate incorrect information
  - **translated**: Potrebbe occasionalmente generare informazioni non corrette

- **com_ui_limitation_harmful_biased**:
  - **english**: May occasionally produce harmful instructions or biased content
  - **translated**: Potrebbe occasionalmente produrre istruzioni dannose o contenuti di parte

- **com_ui_limitation_limited_2021**:
  - **english**: Limited knowledge of world and events after 2021
  - **translated**: Conoscenza limitata del mondo e degli eventi dopo il 2021

- **com_ui_experimental**:
  - **english**: Experimental Features
  - **translated**: Funzionalità Sperimentali

- **com_ui_on**:
  - **english**: On
  - **translated**: Attivo

- **com_ui_off**:
  - **english**: Off
  - **translated**: Disattivo

- **com_ui_yes**:
  - **english**: Yes
  - **translated**: Sì

- **com_ui_no**:
  - **english**: No
  - **translated**: No

- **com_ui_ascending**:
  - **english**: Asc
  - **translated**: Crescente

- **com_ui_descending**:
  - **english**: Desc
  - **translated**: Decrescente

- **com_ui_show_all**:
  - **english**: Show All
  - **translated**: Mostra Tutto

- **com_ui_name**:
  - **english**: Name
  - **translated**: Nome

- **com_ui_date**:
  - **english**: Date
  - **translated**: Data

- **com_ui_storage**:
  - **english**: Storage
  - **translated**: Archiviazione

- **com_ui_context**:
  - **english**: Context
  - **translated**: Contesto

- **com_ui_size**:
  - **english**: Size
  - **translated**: Dimensione

- **com_ui_host**:
  - **english**: Host
  - **translated**: Host

- **com_ui_update**:
  - **english**: Update
  - **translated**: Aggiorna

- **com_ui_authentication**:
  - **english**: Authentication
  - **translated**: Autenticazione

- **com_ui_instructions**:
  - **english**: Instructions
  - **translated**: Istruzioni

- **com_ui_description**:
  - **english**: Description
  - **translated**: Descrizione

- **com_ui_error**:
  - **english**: Error
  - **translated**: Errore

- **com_ui_select**:
  - **english**: Select
  - **translated**: Seleziona

- **com_ui_input**:
  - **english**: Input
  - **translated**: Input

- **com_ui_close**:
  - **english**: Close
  - **translated**: Chiudi

- **com_ui_model**:
  - **english**: Model
  - **translated**: Modello

- **com_ui_select_model**:
  - **english**: Select a model
  - **translated**: Seleziona un modello

- **com_ui_select_search_model**:
  - **english**: Search model by name
  - **translated**: Cerca modello per nome

- **com_ui_select_search_plugin**:
  - **english**: Search plugin by name
  - **translated**: Cerca plugin per nome

- **com_ui_use_prompt**:
  - **english**: Use prompt
  - **translated**: Usa prompt

- **com_ui_prev**:
  - **english**: Prev
  - **translated**: Prec

- **com_ui_next**:
  - **english**: Next
  - **translated**: Succ

- **com_ui_stop**:
  - **english**: Stop
  - **translated**: Ferma

- **com_ui_upload_files**:
  - **english**: Upload files
  - **translated**: Carica file

- **com_ui_prompt_templates**:
  - **english**: Prompt Templates
  - **translated**: Modelli di prompt

- **com_ui_hide_prompt_templates**:
  - **english**: Hide Prompt Templates
  - **translated**: Nascondi modelli di prompt

- **com_ui_showing**:
  - **english**: Showing
  - **translated**: Mostrando

- **com_ui_of**:
  - **english**: of
  - **translated**: di

- **com_ui_entries**:
  - **english**: Entries
  - **translated**: Voci

- **com_ui_pay_per_call**:
  - **english**: All AI conversations in one place. Pay per call and not per month
  - **translated**: Tutte le conversazioni AI in un unico posto. Paga a chiamata e non a mese

- **com_ui_new_footer**:
  - **english**: All AI conversations in one place.
  - **translated**: Tutte le conversazioni AI in un unico posto.

- **com_ui_enter**:
  - **english**: Enter
  - **translated**: Invio

- **com_ui_submit**:
  - **english**: Submit
  - **translated**: Invia

- **com_ui_none_selected**:
  - **english**: None selected
  - **translated**: Nessuna selezionata

- **com_ui_upload_success**:
  - **english**: Successfully uploaded file
  - **translated**: File caricato con successo

- **com_ui_upload_error**:
  - **english**: There was an error uploading your file
  - **translated**: Si è verificato un errore durante il caricamento del file

- **com_ui_upload_invalid**:
  - **english**: Invalid file for upload. Must be an image not exceeding 2 MB
  - **translated**: File non valido per il caricamento. Deve essere un'immagine non superiore a 2 MB

- **com_ui_cancel**:
  - **english**: Cancel
  - **translated**: Annulla

- **com_ui_save**:
  - **english**: Save
  - **translated**: Salva

- **com_ui_save_submit**:
  - **english**: Save & Submit
  - **translated**: Salva e Invia

- **com_ui_copy_to_clipboard**:
  - **english**: Copy to clipboard
  - **translated**: Copia negli appunti

- **com_ui_copied_to_clipboard**:
  - **english**: Copied to clipboard
  - **translated**: Copiato negli appunti

- **com_ui_fork_info_1**:
  - **english**: Use this setting to fork messages with the desired behavior.
  - **translated**: Usa questa impostazione per duplicare i messaggi con il comportamento desiderato.

- **com_ui_fork_info_2**:
  - **english**: "Forking" refers to creating a new conversation that start/end from specific messages in the current conversation, creating a copy according to the options selected.
  - **translated**: "Duplicare" si riferisce alla creazione di una nuova conversazione che inizia/termina dai messaggi specifici nella conversazione corrente, creando una copia in base alle opzioni selezionate.

- **com_ui_fork_info_3**:
  - **english**: The "target message" refers to either the message this popup was opened from, or, if you check "{0}", the latest message in the conversation.
  - **translated**: Il "messaggio di destinazione" si riferisce al messaggio dal quale è stato aperto questo popup, oppure, se selezioni "{0}", all'ultimo messaggio della conversazione.

- **com_ui_fork_info_visible**:
  - **english**: This option forks only the visible messages; in other words, the direct path to the target message, without any branches.
  - **translated**: Questa opzione duplica solo i messaggi visibili; in altre parole, il percorso diretto al messaggio di destinazione, senza alcun ramo.

- **com_ui_fork_info_branches**:
  - **english**: This option forks the visible messages, along with related branches; in other words, the direct path to the target message, including branches along the path.
  - **translated**: Questa opzione duplica i messaggi visibili, insieme ai rami correlati; in altre parole, il percorso diretto al messaggio di destinazione, inclusi i rami lungo il percorso.

- **com_ui_fork_info_target**:
  - **english**: This option forks all messages leading up to the target message, including its neighbors; in other words, all message branches, whether or not they are visible or along the same path, are included.
  - **translated**: Questa opzione duplica tutti i messaggi che portano al messaggio di destinazione, inclusi i suoi vicini; in altre parole, sono inclusi tutti i rami di messaggi, sia che siano visibili o meno o lungo lo stesso percorso.

- **com_ui_fork_info_start**:
  - **english**: If checked, forking will commence from this message to the latest message in the conversation, according to the behavior selected above.
  - **translated**: Se selezionato, la duplicazione partirà da questo messaggio fino all'ultimo messaggio della conversazione, in base al comportamento selezionato sopra.

- **com_ui_fork_info_remember**:
  - **english**: Check this to remember the options you select for future usage, making it quicker to fork conversations as preferred.
  - **translated**: Seleziona questa opzione per ricordare le opzioni selezionate per un futuro utilizzo, rendendo più veloce la duplicazione delle conversazioni come preferito.

- **com_ui_fork_success**:
  - **english**: Successfully forked conversation
  - **translated**: Conversazione duplicata con successo

- **com_ui_fork_processing**:
  - **english**: Forking conversation...
  - **translated**: Duplicazione conversazione in corso...

- **com_ui_fork_error**:
  - **english**: There was an error forking the conversation
  - **translated**: Si è verificato un errore durante la duplicazione della conversazione

- **com_ui_fork_change_default**:
  - **english**: Change default fork option
  - **translated**: Cambia opzione di duplicazione predefinita

- **com_ui_fork_default**:
  - **english**: Use default fork option
  - **translated**: Usa opzione di duplicazione predefinita

- **com_ui_fork_remember**:
  - **english**: Remember
  - **translated**: Ricorda

- **com_ui_fork_split_target_setting**:
  - **english**: Start fork from target message by default
  - **translated**: Avvia la duplicazione dal messaggio di destinazione per impostazione predefinita

- **com_ui_fork_split_target**:
  - **english**: Start fork here
  - **translated**: Avvia la duplicazione da qui

- **com_ui_fork_remember_checked**:
  - **english**: Your selection will be remembered after usage. Change this at any time in the settings.
  - **translated**: La tua selezione verrà ricordata dopo l'utilizzo. Puoi cambiarla in qualsiasi momento nelle impostazioni.

- **com_ui_fork_all_target**:
  - **english**: Include all to/from here
  - **translated**: Includi tutto da/per qui

- **com_ui_fork_branches**:
  - **english**: Include related branches
  - **translated**: Includi rami correlati

- **com_ui_fork_visible**:
  - **english**: Visible messages only
  - **translated**: Solo messaggi visibili

- **com_ui_fork_from_message**:
  - **english**: Select a fork option
  - **translated**: Seleziona un'opzione di duplicazione

- **com_ui_regenerate**:
  - **english**: Regenerate
  - **translated**: Rigenera

- **com_ui_continue**:
  - **english**: Continue
  - **translated**: Continua

- **com_ui_edit**:
  - **english**: Edit
  - **translated**: Modifica

- **com_ui_success**:
  - **english**: Success
  - **translated**: Successo

- **com_ui_all**:
  - **english**: all
  - **translated**: tutto

- **com_ui_clear**:
  - **english**: Clear
  - **translated**: Cancella

- **com_ui_revoke**:
  - **english**: Revoke
  - **translated**: Revoca

- **com_ui_revoke_info**:
  - **english**: Revoke all user provided credentials
  - **translated**: Revoca tutte le credenziali fornite dall'utente

- **com_ui_import_conversation**:
  - **english**: Import
  - **translated**: Importa

- **com_ui_import_conversation_info**:
  - **english**: Import conversations from a JSON file
  - **translated**: Importa conversazioni da un file JSON

- **com_ui_import_conversation_success**:
  - **english**: Conversations imported successfully
  - **translated**: Conversazioni importate con successo

- **com_ui_import_conversation_error**:
  - **english**: There was an error importing your conversations
  - **translated**: Si è verificato un errore durante l'importazione delle conversazioni

- **com_ui_import_conversation_file_type_error**:
  - **english**: Unsupported import type
  - **translated**: Tipo di importazione non supportato

- **com_ui_confirm_action**:
  - **english**: Confirm Action
  - **translated**: Conferma Azione

- **com_ui_chats**:
  - **english**: chats
  - **translated**: chat

- **com_ui_avatar**:
  - **english**: Avatar
  - **translated**: Avatar

- **com_ui_unknown**:
  - **english**: Unknown
  - **translated**: Sconosciuto

- **com_ui_result**:
  - **english**: Result
  - **translated**: Risultato

- **com_ui_image_gen**:
  - **english**: Image Gen
  - **translated**: Generazione immagine

- **com_ui_assistant**:
  - **english**: Assistant
  - **translated**: Assistente

- **com_ui_assistants**:
  - **english**: Assistants
  - **translated**: Assistenti

- **com_ui_attachment**:
  - **english**: Attachment
  - **translated**: Allegato

- **com_ui_assistants_output**:
  - **english**: Assistants Output
  - **translated**: Output Assistenti

- **com_ui_delete**:
  - **english**: Delete
  - **translated**: Elimina

- **com_ui_create**:
  - **english**: Create
  - **translated**: Crea

- **com_ui_delete_conversation**:
  - **english**: Delete chat?
  - **translated**: Eliminare la chat?

- **com_ui_delete_confirm**:
  - **english**: This will delete
  - **translated**: Questo eliminerà

- **com_ui_rename**:
  - **english**: Rename
  - **translated**: Rinomina

- **com_ui_archive**:
  - **english**: Archive
  - **translated**: Archivia

- **com_ui_archive_error**:
  - **english**: Failed to archive conversation
  - **translated**: Errore durante l'archiviazione della conversazione

- **com_ui_unarchive**:
  - **english**: Unarchive
  - **translated**: Disarchivia

- **com_ui_unarchive_error**:
  - **english**: Failed to unarchive conversation
  - **translated**: Impossibile disarchiviare la conversazione

- **com_ui_more_options**:
  - **english**: More
  - **translated**: Pi

- **com_ui_delete_assistant_confirm**:
  - **english**: Are you sure you want to delete this Assistant? This cannot be undone.
  - **translated**: Sei sicuro di voler eliminare questo Assistente? Questa operazione non può essere annullata.

- **com_ui_preview**:
  - **english**: Preview
  - **translated**: Anteprima

- **com_ui_upload**:
  - **english**: Upload
  - **translated**: Carica

- **com_ui_connect**:
  - **english**: Connect
  - **translated**: Connetti

- **com_ui_upload_delay**:
  - **english**: Uploading "{0}" is taking more time than anticipated. Please wait while the file finishes indexing for retrieval.
  - **translated**: Il caricamento di "{0}" sta richiedendo più tempo del previsto. Attendi il completamento dell'indicizzazione per il recupero.

- **com_ui_privacy_policy**:
  - **english**: Privacy policy
  - **translated**: Informativa sulla privacy

- **com_ui_terms_of_service**:
  - **english**: Terms of service
  - **translated**: Termini di servizio

- **com_ui_min_tags**:
  - **english**: Cannot remove more values, a minimum of {0} are required.
  - **translated**: Impossibile rimuovere altri valori, è richiesto un minimo di {0}.

- **com_ui_max_tags**:
  - **english**: Maximum number allowed is {0}, using latest values.
  - **translated**: Il numero massimo consentito è {0}, verranno utilizzati gli ultimi valori.

- **com_auth_error_login**:
  - **english**: Unable to login with the information provided. Please check your credentials and try again.
  - **translated**: Impossibile eseguire l'accesso con le informazioni fornite. Controlla le tue credenziali e riprova.

- **com_auth_error_login_rl**:
  - **english**: Too many login attempts in a short amount of time. Please try again later.
  - **translated**: Troppi tentativi di accesso in un breve periodo di tempo. Riprova più tardi.

- **com_auth_error_login_ban**:
  - **english**: Your account has been temporarily banned due to violations of our service.
  - **translated**: Il tuo account è stato temporaneamente bloccato a causa di violazioni del nostro servizio.

- **com_auth_error_login_server**:
  - **english**: There was an internal server error. Please wait a few moments and try again.
  - **translated**: Si è verificato un errore interno del server. Attendi qualche istante e riprova.

- **com_auth_no_account**:
  - **english**: Don't have an account?
  - **translated**: Non hai un account?

- **com_auth_sign_up**:
  - **english**: Sign up
  - **translated**: Registrati

- **com_auth_sign_in**:
  - **english**: Sign in
  - **translated**: Accedi

- **com_auth_google_login**:
  - **english**: Continue with Google
  - **translated**: Continua con Google

- **com_auth_facebook_login**:
  - **english**: Continue with Facebook
  - **translated**: Continua con Facebook

- **com_auth_github_login**:
  - **english**: Continue with Github
  - **translated**: Continua con Github

- **com_auth_discord_login**:
  - **english**: Continue with Discord
  - **translated**: Continua con Discord

- **com_auth_email**:
  - **english**: Email
  - **translated**: Email

- **com_auth_email_required**:
  - **english**: Email is required
  - **translated**: L'email è obbligatoria

- **com_auth_email_min_length**:
  - **english**: Email must be at least 6 characters
  - **translated**: L'email deve essere di almeno 6 caratteri

- **com_auth_email_max_length**:
  - **english**: Email should not be longer than 120 characters
  - **translated**: L'email non deve superare i 120 caratteri

- **com_auth_email_pattern**:
  - **english**: You must enter a valid email address
  - **translated**: Devi inserire un indirizzo email valido

- **com_auth_email_address**:
  - **english**: Email address
  - **translated**: Indirizzo email

- **com_auth_password**:
  - **english**: Password
  - **translated**: Password

- **com_auth_password_required**:
  - **english**: Password is required
  - **translated**: La password è obbligatoria

- **com_auth_password_min_length**:
  - **english**: Password must be at least 8 characters
  - **translated**: La password deve essere di almeno 8 caratteri

- **com_auth_password_max_length**:
  - **english**: Password must be less than 128 characters
  - **translated**: La password deve essere inferiore a 128 caratteri

- **com_auth_password_forgot**:
  - **english**: Forgot Password?
  - **translated**: Password dimenticata?

- **com_auth_password_confirm**:
  - **english**: Confirm password
  - **translated**: Conferma password

- **com_auth_password_not_match**:
  - **english**: Passwords do not match
  - **translated**: Le password non corrispondono

- **com_auth_continue**:
  - **english**: Continue
  - **translated**: Continua

- **com_auth_create_account**:
  - **english**: Create your account
  - **translated**: Crea il tuo account

- **com_auth_error_create**:
  - **english**: There was an error attempting to register your account. Please try again.
  - **translated**: Si è verificato un errore durante il tentativo di registrare il tuo account. Riprova.

- **com_auth_full_name**:
  - **english**: Full name
  - **translated**: Nome completo

- **com_auth_name_required**:
  - **english**: Name is required
  - **translated**: Il nome è obbligatorio

- **com_auth_name_min_length**:
  - **english**: Name must be at least 3 characters
  - **translated**: Il nome deve essere di almeno 3 caratteri

- **com_auth_name_max_length**:
  - **english**: Name must be less than 80 characters
  - **translated**: Il nome deve essere inferiore a 80 caratteri

- **com_auth_username**:
  - **english**: Username (optional)
  - **translated**: Nome utente (opzionale)

- **com_auth_username_required**:
  - **english**: Username is required
  - **translated**: Il nome utente è obbligatorio

- **com_auth_username_min_length**:
  - **english**: Username must be at least 2 characters
  - **translated**: Il nome utente deve essere di almeno 2 caratteri

- **com_auth_username_max_length**:
  - **english**: Username must be less than 20 characters
  - **translated**: Il nome utente deve essere inferiore a 20 caratteri

- **com_auth_already_have_account**:
  - **english**: Already have an account?
  - **translated**: Hai già un account?

- **com_auth_login**:
  - **english**: Login
  - **translated**: Accedi

- **com_auth_reset_password**:
  - **english**: Reset your password
  - **translated**: Reimposta la tua password

- **com_auth_click**:
  - **english**: Click
  - **translated**: Clicca

- **com_auth_here**:
  - **english**: HERE
  - **translated**: QUI

- **com_auth_to_reset_your_password**:
  - **english**: to reset your password.
  - **translated**: per reimpostare la tua password.

- **com_auth_reset_password_link_sent**:
  - **english**: Email Sent
  - **translated**: Email inviata

- **com_auth_reset_password_email_sent**:
  - **english**: An email has been sent to you with further instructions to reset your password.
  - **translated**: Ti è stata inviata un'email con ulteriori istruzioni per reimpostare la tua password.

- **com_auth_error_reset_password**:
  - **english**: There was a problem resetting your password. There was no user found with the email address provided. Please try again.
  - **translated**: Si è verificato un problema durante il reset della tua password. Nessun utente trovato con l'indirizzo email fornito. Riprova.

- **com_auth_reset_password_success**:
  - **english**: Password Reset Success
  - **translated**: Reset della password avvenuto con successo

- **com_auth_login_with_new_password**:
  - **english**: You may now login with your new password.
  - **translated**: Ora puoi accedere con la tua nuova password.

- **com_auth_error_invalid_reset_token**:
  - **english**: This password reset token is no longer valid.
  - **translated**: Questo token di reset della password non è più valido.

- **com_auth_click_here**:
  - **english**: Click here
  - **translated**: Clicca qui

- **com_auth_to_try_again**:
  - **english**: to try again.
  - **translated**: per riprovare.

- **com_auth_submit_registration**:
  - **english**: Submit registration
  - **translated**: Invia registrazione

- **com_auth_welcome_back**:
  - **english**: Welcome back
  - **translated**: Ben tornato

- **com_auth_back_to_login**:
  - **english**: Back to Login
  - **translated**: Torna all'accesso

- **com_endpoint_open_menu**:
  - **english**: Open Menu
  - **translated**: Apri menu

- **com_endpoint_bing_enable_sydney**:
  - **english**: Enable Sydney
  - **translated**: Abilita Sydney

- **com_endpoint_bing_to_enable_sydney**:
  - **english**: To enable Sydney
  - **translated**: Per abilitare Sydney

- **com_endpoint_bing_jailbreak**:
  - **english**: Jailbreak
  - **translated**: Jailbreak

- **com_endpoint_bing_context_placeholder**:
  - **english**: Bing can use up to 7k tokens for 'context', which it can reference for the conversation. The specific limit is not known but may run into errors exceeding 7k tokens
  - **translated**: Bing può utilizzare fino a 7k token per il "contesto", che può riferire per la conversazione. Il limite specifico non è noto ma potrebbe incontrare errori superando 7k token

- **com_endpoint_bing_system_message_placeholder**:
  - **english**: WARNING: Misuse of this feature can get you BANNED from using Bing! Click on 'System Message' for full instructions and the default message if omitted, which is the 'Sydney' preset that is considered safe.
  - **translated**: ATTENZIONE: L'uso improprio di questa funzione può farti BANNARE dall'utilizzo di Bing! Clicca su "Messaggio di sistema" per le istruzioni complete e il messaggio predefinito se omesso, che è il preset "Sydney" considerato sicuro.

- **com_endpoint_system_message**:
  - **english**: System Message
  - **translated**: Messaggio di sistema

- **com_endpoint_message**:
  - **english**: Message
  - **translated**: Messaggio

- **com_endpoint_message_not_appendable**:
  - **english**: Edit your message or Regenerate.
  - **translated**: Modifica il tuo messaggio o Rigenera.

- **com_endpoint_default_blank**:
  - **english**: default: blank
  - **translated**: predefinito: vuoto

- **com_endpoint_default_false**:
  - **english**: default: false
  - **translated**: predefinito: falso

- **com_endpoint_default_creative**:
  - **english**: default: creative
  - **translated**: predefinito: creativo

- **com_endpoint_default_empty**:
  - **english**: default: empty
  - **translated**: predefinito: vuoto

- **com_endpoint_default_with_num**:
  - **english**: default: {0}
  - **translated**: predefinito: {0}

- **com_endpoint_context**:
  - **english**: Context
  - **translated**: Contesto

- **com_endpoint_tone_style**:
  - **english**: Tone Style
  - **translated**: Tono Stile

- **com_endpoint_token_count**:
  - **english**: Token count
  - **translated**: Conteggio token

- **com_endpoint_output**:
  - **english**: Output
  - **translated**: Output

- **com_endpoint_google_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: Valori più alti = più casualità, mentre valori più bassi = più focalizzati e deterministici. Consigliamo di modificare questo o Top P ma non entrambi.

- **com_endpoint_google_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p cambia il modo in cui il modello seleziona i token per l'output. I token vengono selezionati dai più probabili K (vedi parametro topK) ai meno probabili fino a quando la somma delle loro probabilità eguaglia il valore top-p.

- **com_endpoint_google_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k cambia il modo in cui il modello seleziona i token per l'output. Un top-k di 1 significa che il token selezionato è il più probabile tra tutti i token nel vocabolario del modello (anche chiamato greedy decoding), mentre un top-k di 3 significa che il prossimo token è selezionato tra i 3 più probabili (usando la temperatura).

- **com_endpoint_google_maxoutputtokens**:
  - **english**:  	Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: Numero massimo di token che possono essere generati nella risposta. Specifica un valore più basso per risposte più brevi e un valore più alto per risposte più lunghe.

- **com_endpoint_google_custom_name_placeholder**:
  - **english**: Set a custom name for Google
  - **translated**: Imposta un nome personalizzato per Google

- **com_endpoint_prompt_prefix_placeholder**:
  - **english**: Set custom instructions or context. Ignored if empty.
  - **translated**: Imposta istruzioni personalizzate o contesto. Ignorato se vuoto.

- **com_endpoint_instructions_assistants_placeholder**:
  - **english**: Overrides the instructions of the assistant. This is useful for modifying the behavior on a per-run basis.
  - **translated**: Sovrascrive le istruzioni dell'assistente. Utile per modificare il comportamento su base singola.

- **com_endpoint_prompt_prefix_assistants_placeholder**:
  - **english**: Set additional instructions or context on top of the Assistant's main instructions. Ignored if empty.
  - **translated**: Imposta istruzioni o contesto aggiuntivi oltre alle istruzioni principali dell'Assistente. Ignorato se vuoto.

- **com_endpoint_custom_name**:
  - **english**: Custom Name
  - **translated**: Nome personalizzato

- **com_endpoint_prompt_prefix**:
  - **english**: Custom Instructions
  - **translated**: Istruzioni personalizzate

- **com_endpoint_prompt_prefix_assistants**:
  - **english**: Additional Instructions
  - **translated**: Istruzioni aggiuntive

- **com_endpoint_instructions_assistants**:
  - **english**: Override Instructions
  - **translated**: Sovrascrivi istruzioni

- **com_endpoint_temperature**:
  - **english**: Temperature
  - **translated**: Temperatura

- **com_endpoint_default**:
  - **english**: default
  - **translated**: predefinito

- **com_endpoint_top_p**:
  - **english**: Top P
  - **translated**: Top P

- **com_endpoint_top_k**:
  - **english**: Top K
  - **translated**: Top K

- **com_endpoint_max_output_tokens**:
  - **english**: Max Output Tokens
  - **translated**: Token di output massimi

- **com_endpoint_stop**:
  - **english**: Stop Sequences
  - **translated**: Sequenze di stop

- **com_endpoint_stop_placeholder**:
  - **english**: Separate values by pressing `Enter`
  - **translated**: Separa i valori premendo `Invio`

- **com_endpoint_openai_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: Valori più alti = più casualità, mentre valori più bassi = più focalizzati e deterministici. Consigliamo di modificare questo o Top P ma non entrambi.

- **com_endpoint_openai_max**:
  - **english**: The max tokens to generate. The total length of input tokens and generated tokens is limited by the model's context length.
  - **translated**: I token massimi da generare. La lunghezza totale dei token di input e dei token generati è limitata dalla lunghezza del contesto del modello.

- **com_endpoint_openai_topp**:
  - **english**: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We recommend altering this or temperature but not both.
  - **translated**: Un'alternativa al campionamento con temperatura, chiamata nucleus sampling, in cui il modello considera i risultati dei token con probabilità di massa top_p. Quindi 0,1 significa che vengono considerati solo i token che compongono la massa di probabilità superiore al 10%. Consigliamo di modificare questo o la temperatura ma non entrambi.

- **com_endpoint_openai_freq**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
  - **translated**: Numero compreso tra -2.0 e 2.0. Valori positivi penalizzano i nuovi token basati sulla loro frequenza esistente nel testo fino a quel momento, diminuendo la probabilità del modello di ripetere la stessa riga verbatim.

- **com_endpoint_openai_pres**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
  - **translated**: Numero compreso tra -2.0 e 2.0. Valori positivi penalizzano i nuovi token in base a se compaiono nel testo fino a quel momento, aumentando la probabilità del modello di parlare di nuovi argomenti.

- **com_endpoint_openai_resend**:
  - **english**: Resend all previously attached images. Note: this can significantly increase token cost and you may experience errors with many image attachments.
  - **translated**: Invia nuovamente tutte le immagini allegate in precedenza. Nota: questo può aumentare significativamente il costo dei token e potresti incontrare errori con molti allegati di immagini.

- **com_endpoint_openai_resend_files**:
  - **english**: Resend all previously attached files. Note: this will increase token cost and you may experience errors with many attachments.
  - **translated**: Invia nuovamente tutti i file allegati in precedenza. Nota: questo aumenterà il costo dei token e potresti incontrare errori con molti allegati.

- **com_endpoint_openai_detail**:
  - **english**: The resolution for Vision requests. "Low" is cheaper and faster, "High" is more detailed and expensive, and "Auto" will automatically choose between the two based on the image resolution.
  - **translated**: La risoluzione per le richieste Vision. "Bassa" è più economica e veloce, "Alta" è più dettagliata e costosa, e "Auto" sceglierà automaticamente tra le due in base alla risoluzione dell'immagine.

- **com_endpoint_openai_stop**:
  - **english**: Up to 4 sequences where the API will stop generating further tokens.
  - **translated**: Fino a 4 sequenze in cui l'API smetterà di generare ulteriori token.

- **com_endpoint_openai_custom_name_placeholder**:
  - **english**: Set a custom name for the AI
  - **translated**: Imposta un nome personalizzato per l'IA

- **com_endpoint_openai_prompt_prefix_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: Imposta istruzioni personalizzate da includere nel Messaggio di Sistema. Predefinito: nessuno

- **com_endpoint_anthropic_temp**:
  - **english**: Ranges from 0 to 1. Use temp closer to 0 for analytical / multiple choice, and closer to 1 for creative and generative tasks. We recommend altering this or Top P but not both.
  - **translated**: Varia da 0 a 1. Usa temp più vicino a 0 per analitica / scelta multipla, e più vicino a 1 per compiti creativi e generativi. Consigliamo di modificare questo o Top P ma non entrambi.

- **com_endpoint_anthropic_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p cambia il modo in cui il modello seleziona i token per l'output. I token vengono selezionati dai più probabili K (vedi parametro topK) ai meno probabili fino a quando la somma delle loro probabilità eguaglia il valore top-p.

- **com_endpoint_anthropic_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k cambia il modo in cui il modello seleziona i token per l'output. Un top-k di 1 significa che il token selezionato è il più probabile tra tutti i token nel vocabolario del modello (anche chiamato greedy decoding), mentre un top-k di 3 significa che il prossimo token è selezionato tra i 3 più probabili (usando la temperatura).

- **com_endpoint_anthropic_maxoutputtokens**:
  - **english**: Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: Numero massimo di token che possono essere generati nella risposta. Specifica un valore più basso per risposte più brevi e un valore più alto per risposte più lunghe.

- **com_endpoint_anthropic_custom_name_placeholder**:
  - **english**: Set a custom name for Anthropic
  - **translated**: Imposta un nome personalizzato per Anthropic

- **com_endpoint_frequency_penalty**:
  - **english**: Frequency Penalty
  - **translated**: Penalità di frequenza

- **com_endpoint_presence_penalty**:
  - **english**: Presence Penalty
  - **translated**: Penalità di presenza

- **com_endpoint_plug_use_functions**:
  - **english**: Use Functions
  - **translated**: Usa funzioni

- **com_endpoint_plug_resend_files**:
  - **english**: Resend Files
  - **translated**: Reinvia file

- **com_endpoint_plug_resend_images**:
  - **english**: Resend Images
  - **translated**: Reinvia immagini

- **com_endpoint_plug_image_detail**:
  - **english**: Image Detail
  - **translated**: Dettaglio immagine

- **com_endpoint_plug_skip_completion**:
  - **english**: Skip Completion
  - **translated**: Salta completamento

- **com_endpoint_disabled_with_tools**:
  - **english**: disabled with tools
  - **translated**: disabilitato con strumenti

- **com_endpoint_disabled_with_tools_placeholder**:
  - **english**: Disabled with Tools Selected
  - **translated**: Disabilitato con Strumenti Selezionati

- **com_endpoint_plug_set_custom_instructions_for_gpt_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: Imposta istruzioni personalizzate da includere nel Messaggio di Sistema. Predefinito: nessuno

- **com_endpoint_import**:
  - **english**: Import
  - **translated**: Importa

- **com_endpoint_set_custom_name**:
  - **english**: Set a custom name, in case you can find this preset
  - **translated**: Imposta un nome personalizzato, nel caso tu possa trovare questa preimpostazione

- **com_endpoint_preset_delete_confirm**:
  - **english**: Are you sure you want to delete this preset?
  - **translated**: Sei sicuro di voler eliminare questa preimpostazione?

- **com_endpoint_preset_clear_all_confirm**:
  - **english**: Are you sure you want to delete all of your presets?
  - **translated**: Sei sicuro di voler eliminare tutte le tue preimpostazioni?

- **com_endpoint_preset_import**:
  - **english**: Preset Imported!
  - **translated**: Preimpostazione importata!

- **com_endpoint_preset_import_error**:
  - **english**: There was an error importing your preset. Please try again.
  - **translated**: Si è verificato un errore durante l'importazione della preimpostazione. Riprova.

- **com_endpoint_preset_save_error**:
  - **english**: There was an error saving your preset. Please try again.
  - **translated**: Si è verificato un errore durante il salvataggio della preimpostazione. Riprova.

- **com_endpoint_preset_delete_error**:
  - **english**: There was an error deleting your preset. Please try again.
  - **translated**: Si è verificato un errore durante l'eliminazione della preimpostazione. Riprova.

- **com_endpoint_preset_default_removed**:
  - **english**: is no longer the default preset.
  - **translated**: non è più la preimpostazione predefinita.

- **com_endpoint_preset_default_item**:
  - **english**: Default:
  - **translated**: Predefinita:

- **com_endpoint_preset_default_none**:
  - **english**: No default preset active.
  - **translated**: Nessuna preimpostazione predefinita attiva.

- **com_endpoint_preset_title**:
  - **english**: Preset
  - **translated**: Preimpostazione

- **com_endpoint_preset_saved**:
  - **english**: Saved!
  - **translated**: Salvata!

- **com_endpoint_preset_default**:
  - **english**: is now the default preset.
  - **translated**: è ora la preimpostazione predefinita.

- **com_endpoint_preset**:
  - **english**: preset
  - **translated**: preimpostazione

- **com_endpoint_presets**:
  - **english**: presets
  - **translated**: preimpostazioni

- **com_endpoint_preset_selected**:
  - **english**: Preset Active!
  - **translated**: Preimpostazione attiva!

- **com_endpoint_preset_selected_title**:
  - **english**: Active!
  - **translated**: Attiva!

- **com_endpoint_preset_name**:
  - **english**: Preset Name
  - **translated**: Nome preimpostazione

- **com_endpoint_new_topic**:
  - **english**: New Topic
  - **translated**: Nuovo argomento

- **com_endpoint**:
  - **english**: Endpoint
  - **translated**: Endpoint

- **com_endpoint_hide**:
  - **english**: Hide
  - **translated**: Nascondi

- **com_endpoint_show**:
  - **english**: Show
  - **translated**: Mostra

- **com_endpoint_examples**:
  - **english**:  Presets
  - **translated**: Preimpostazioni

- **com_endpoint_completion**:
  - **english**: Completion
  - **translated**: Completamento

- **com_endpoint_agent**:
  - **english**: Agent
  - **translated**: Agente

- **com_endpoint_show_what_settings**:
  - **english**: Show {0} Settings
  - **translated**: Mostra impostazioni {0}

- **com_endpoint_export**:
  - **english**: Export
  - **translated**: Esporta

- **com_endpoint_assistant**:
  - **english**: Assistant
  - **translated**: Assistente

- **com_endpoint_use_active_assistant**:
  - **english**: Use Active Assistant
  - **translated**: Usa Assistente Attivo

- **com_endpoint_assistant_model**:
  - **english**: Assistant Model
  - **translated**: Modello Assistente

- **com_endpoint_save_as_preset**:
  - **english**: Save As Preset
  - **translated**: Salva come Preimpostazione

- **com_endpoint_presets_clear_warning**:
  - **english**: Are you sure you want to clear all presets? This is irreversible.
  - **translated**: Sei sicuro di voler cancellare tutte le preimpostazioni? Questa azione è irreversibile.

- **com_endpoint_not_implemented**:
  - **english**: Not implemented
  - **translated**: Non implementato

- **com_endpoint_no_presets**:
  - **english**: No presets yet, use the settings button to create one
  - **translated**: Ancora nessuna preimpostazione, usa il pulsante impostazioni per crearne una

- **com_endpoint_not_available**:
  - **english**: No endpoint available
  - **translated**: Nessun endpoint disponibile

- **com_endpoint_view_options**:
  - **english**: View Options
  - **translated**: Visualizza opzioni

- **com_endpoint_save_convo_as_preset**:
  - **english**: Save Conversation as Preset
  - **translated**: Salva conversazione come preimpostazione

- **com_endpoint_my_preset**:
  - **english**: My Preset
  - **translated**: La mia preimpostazione

- **com_endpoint_agent_model**:
  - **english**: Agent Model (Recommended: GPT-3.5)
  - **translated**: Modello Agente (Consigliato: GPT-3.5)

- **com_endpoint_completion_model**:
  - **english**: Completion Model (Recommended: GPT-4)
  - **translated**: Modello Completamento (Consigliato: GPT-4)

- **com_endpoint_func_hover**:
  - **english**: Enable use of Plugins as OpenAI Functions
  - **translated**: Abilita l'uso di Plugin come OpenAI Functions

- **com_endpoint_skip_hover**:
  - **english**: Enable skipping the completion step, which reviews the final answer and generated steps
  - **translated**: Abilita la possibilità di saltare il passaggio di completamento, che rivede la risposta finale e i passaggi generati

- **com_endpoint_config_key**:
  - **english**: Set API Key
  - **translated**: Imposta chiave API

- **com_endpoint_assistant_placeholder**:
  - **english**: Please select an Assistant from the right-hand Side Panel
  - **translated**: Seleziona un Assistente dal Pannello laterale destro

- **com_endpoint_config_placeholder**:
  - **english**: Set your Key in the Header menu to chat.
  - **translated**: Imposta la tua Chiave nel menu Header per chattare.

- **com_endpoint_config_key_for**:
  - **english**: Set API Key for
  - **translated**: Imposta chiave API per

- **com_endpoint_config_key_name**:
  - **english**: Key
  - **translated**: Chiave

- **com_endpoint_config_value**:
  - **english**: Enter value for
  - **translated**: Inserisci valore per

- **com_endpoint_config_key_name_placeholder**:
  - **english**: Set API key first
  - **translated**: Imposta prima la chiave API

- **com_endpoint_config_key_encryption**:
  - **english**: Your key will be encrypted and deleted at
  - **translated**: La tua chiave sarà crittografata ed eliminata al

- **com_endpoint_config_key_expiry**:
  - **english**: the expiry time
  - **translated**: tempo di scadenza

- **com_endpoint_config_click_here**:
  - **english**: Click Here
  - **translated**: Clicca qui

- **com_endpoint_config_google_service_key**:
  - **english**: Google Service Account Key
  - **translated**: Chiave Account di Servizio Google

- **com_endpoint_config_google_cloud_platform**:
  - **english**: (from Google Cloud Platform)
  - **translated**: (da Google Cloud Platform)

- **com_endpoint_config_google_api_key**:
  - **english**: Google API Key
  - **translated**: Chiave API Google

- **com_endpoint_config_google_gemini_api**:
  - **english**: (Gemini API)
  - **translated**: (API Gemini)

- **com_endpoint_config_google_api_info**:
  - **english**: To get your Generative Language API key (for Gemini),
  - **translated**: Per ottenere la tua chiave API Generative Language (per Gemini),

- **com_endpoint_config_key_import_json_key**:
  - **english**: Import Service Account JSON Key.
  - **translated**: Importa chiave JSON Account di Servizio.

- **com_endpoint_config_key_import_json_key_success**:
  - **english**: Successfully Imported Service Account JSON Key
  - **translated**: Chiave JSON Account di Servizio importata con successo

- **com_endpoint_config_key_import_json_key_invalid**:
  - **english**: Invalid Service Account JSON Key, Did you import the correct file?
  - **translated**: Chiave JSON Account di Servizio non valida, hai importato il file corretto?

- **com_endpoint_config_key_get_edge_key**:
  - **english**: To get your Access token for Bing, login to
  - **translated**: Per ottenere il tuo token di accesso per Bing, accedi a

- **com_endpoint_config_key_get_edge_key_dev_tool**:
  - **english**: Use dev tools or an extension while logged into the site to copy the content of the _U cookie. If this fails, follow these
  - **translated**: Usa gli strumenti di sviluppo o un'estensione mentre sei connesso al sito per copiare il contenuto del cookie _U. Se questo fallisce, segui queste

- **com_endpoint_config_key_edge_instructions**:
  - **english**: instructions
  - **translated**: istruzioni

- **com_endpoint_config_key_edge_full_key_string**:
  - **english**: to provide the full cookie strings.
  - **translated**: per fornire le stringhe complete dei cookie.

- **com_endpoint_config_key_chatgpt**:
  - **english**: To get your Access token For ChatGPT 'Free Version', login to
  - **translated**: Per ottenere il tuo token di accesso per ChatGPT "Versione Gratuita", accedi a

- **com_endpoint_config_key_chatgpt_then_visit**:
  - **english**: then visit
  - **translated**: poi visita

- **com_endpoint_config_key_chatgpt_copy_token**:
  - **english**: Copy access token.
  - **translated**: Copia il token di accesso.

- **com_endpoint_config_key_google_need_to**:
  - **english**: You need to
  - **translated**: Devi

- **com_endpoint_config_key_google_vertex_ai**:
  - **english**: Enable Vertex AI
  - **translated**: Abilitare Vertex AI

- **com_endpoint_config_key_google_vertex_api**:
  - **english**: API on Google Cloud, then
  - **translated**: API su Google Cloud, poi

- **com_endpoint_config_key_google_service_account**:
  - **english**: Create a Service Account
  - **translated**: Creare un Account di Servizio

- **com_endpoint_config_key_google_vertex_api_role**:
  - **english**: Make sure to click 'Create and Continue' to give at least the 'Vertex AI User' role. Lastly, create a JSON key to import here.
  - **translated**: Assicurati di cliccare su "Crea e Continua" per assegnare almeno il ruolo "Utente Vertex AI". Infine, crea una chiave JSON da importare qui.

- **com_nav_welcome_assistant**:
  - **english**: Please Select an Assistant
  - **translated**: Seleziona un Assistente

- **com_nav_welcome_message**:
  - **english**: How can I help you today?
  - **translated**: Come posso aiutarti oggi?

- **com_nav_auto_scroll**:
  - **english**: Auto-scroll to Newest on Open
  - **translated**: Scorri automaticamente ai nuovi messaggi all'apertura

- **com_nav_hide_panel**:
  - **english**: Hide Right-most Side Panel
  - **translated**: Nascondi il Pannello laterale più a destra

- **com_nav_modular_chat**:
  - **english**: Enable switching Endpoints mid-conversation
  - **translated**: Abilita il cambio di Endpoint a metà conversazione

- **com_nav_latex_parsing**:
  - **english**: Parsing LaTeX in messages (may affect performance)
  - **translated**: Analizza LaTeX nei messaggi (potrebbe influire sulle prestazioni)

- **com_nav_profile_picture**:
  - **english**: Profile Picture
  - **translated**: Immagine profilo

- **com_nav_change_picture**:
  - **english**: Change picture
  - **translated**: Cambia immagine

- **com_nav_plugin_store**:
  - **english**: Plugin store
  - **translated**: Store plugin

- **com_nav_plugin_install**:
  - **english**: Install
  - **translated**: Installa

- **com_nav_plugin_uninstall**:
  - **english**: Uninstall
  - **translated**: Disinstalla

- **com_ui_add**:
  - **english**: Add
  - **translated**: Aggiungi

- **com_nav_tool_remove**:
  - **english**: Remove
  - **translated**: Rimuovi

- **com_nav_tool_dialog**:
  - **english**: Assistant Tools
  - **translated**: Strumenti Assistente

- **com_nav_tool_dialog_description**:
  - **english**: Assistant must be saved to persist tool selections.
  - **translated**: L'Assistente deve essere salvato per conservare le selezioni degli strumenti.

- **com_show_agent_settings**:
  - **english**: Show Agent Settings
  - **translated**: Mostra impostazioni Agente

- **com_show_completion_settings**:
  - **english**: Show Completion Settings
  - **translated**: Mostra impostazioni Completamento

- **com_hide_examples**:
  - **english**: Hide Examples
  - **translated**: Nascondi esempi

- **com_show_examples**:
  - **english**: Show Examples
  - **translated**: Mostra esempi

- **com_nav_plugin_search**:
  - **english**: Search plugins
  - **translated**: Cerca plugin

- **com_nav_tool_search**:
  - **english**: Search tools
  - **translated**: Cerca strumenti

- **com_nav_plugin_auth_error**:
  - **english**: There was an error attempting to authenticate this plugin. Please try again.
  - **translated**: Si è verificato un errore durante il tentativo di autenticazione di questo plugin. Riprova.

- **com_nav_export_filename**:
  - **english**: Filename
  - **translated**: Nome file

- **com_nav_export_filename_placeholder**:
  - **english**: Set the filename
  - **translated**: Imposta il nome del file

- **com_nav_export_type**:
  - **english**: Type
  - **translated**: Tipo

- **com_nav_export_include_endpoint_options**:
  - **english**: Include endpoint options
  - **translated**: Includi opzioni endpoint

- **com_nav_enabled**:
  - **english**: Enabled
  - **translated**: Abilitato

- **com_nav_not_supported**:
  - **english**: Not Supported
  - **translated**: Non supportato

- **com_nav_export_all_message_branches**:
  - **english**: Export all message branches
  - **translated**: Esporta tutti i rami dei messaggi

- **com_nav_export_recursive_or_sequential**:
  - **english**: Recursive or sequential?
  - **translated**: Ricorsivo o sequenziale?

- **com_nav_export_recursive**:
  - **english**: Recursive
  - **translated**: Ricorsivo

- **com_nav_export_conversation**:
  - **english**: Export conversation
  - **translated**: Esporta conversazione

- **com_nav_my_files**:
  - **english**: My Files
  - **translated**: I miei file

- **com_nav_theme**:
  - **english**: Theme
  - **translated**: Tema

- **com_nav_theme_system**:
  - **english**: System
  - **translated**: Sistema

- **com_nav_theme_dark**:
  - **english**: Dark
  - **translated**: Scuro

- **com_nav_theme_light**:
  - **english**: Light
  - **translated**: Chiaro

- **com_nav_enter_to_send**:
  - **english**: Press Enter to send messages
  - **translated**: Premi Invio per inviare messaggi

- **com_nav_user_name_display**:
  - **english**: Display username in messages
  - **translated**: Mostra nome utente nei messaggi

- **com_nav_show_code**:
  - **english**: Always show code when using code interpreter
  - **translated**: Mostra sempre il codice quando si usa l'interprete di codice

- **com_nav_clear_all_chats**:
  - **english**: Clear all chats
  - **translated**: Cancella tutte le chat

- **com_nav_confirm_clear**:
  - **english**: Confirm Clear
  - **translated**: Conferma cancellazione

- **com_nav_close_sidebar**:
  - **english**: Close sidebar
  - **translated**: Chiudi barra laterale

- **com_nav_open_sidebar**:
  - **english**: Open sidebar
  - **translated**: Apri barra laterale

- **com_nav_send_message**:
  - **english**: Send message
  - **translated**: Invia messaggio

- **com_nav_log_out**:
  - **english**: Log out
  - **translated**: Disconnetti

- **com_nav_user**:
  - **english**: USER
  - **translated**: UTENTE

- **com_nav_archived_chats**:
  - **english**: Archived chats
  - **translated**: Chat archiviate

- **com_nav_archived_chats_manage**:
  - **english**: Manage
  - **translated**: Gestisci

- **com_nav_archived_chats_empty**:
  - **english**: You have no archived conversations.
  - **translated**: Non hai chat archiviate.

- **com_nav_archive_all_chats**:
  - **english**: Archive all chats
  - **translated**: Archivia tutte le chat

- **com_nav_archive_all**:
  - **english**: Archive all
  - **translated**: Archivia tutto

- **com_nav_archive_name**:
  - **english**: Name
  - **translated**: Nome

- **com_nav_archive_created_at**:
  - **english**: DateCreated
  - **translated**: DateCreated

- **com_nav_clear_conversation**:
  - **english**: Clear conversations
  - **translated**: Cancella conversazioni

- **com_nav_clear_conversation_confirm_message**:
  - **english**: Are you sure you want to clear all conversations? This is irreversible.
  - **translated**: Sei sicuro di voler cancellare tutte le conversazioni? Questa azione è irreversibile.

- **com_nav_help_faq**:
  - **english**: Help & FAQ
  - **translated**: Guida e FAQ

- **com_nav_settings**:
  - **english**: Settings
  - **translated**: Impostazioni

- **com_nav_search_placeholder**:
  - **english**: Search messages
  - **translated**: Cerca messaggi

- **com_nav_setting_general**:
  - **english**: General
  - **translated**: Generali

- **com_nav_setting_beta**:
  - **english**: Beta features
  - **translated**: Funzionalità beta

- **com_nav_setting_data**:
  - **english**: Data controls
  - **translated**: Controlli dati

- **com_nav_setting_account**:
  - **english**: Account
  - **translated**: Account

Please consider the above comparisons to enhance understanding and guide improvements in translations.

Provide insights or suggestions that could help refine the translation process, focusing on cultural and contextual relevance.

Please craft a prompt that can be used to better inform future translations to this language.

Write this prompt in the translated language, with all its nuances detected, not in the English.
