# Instructions for Translation

Write a prompt that is mindful of the nuances in the language with respect to its English counterpart, which serves as the baseline for translations. Here are the comparisons between the language translations and their English counterparts:


- **com_ui_examples**:
  - **english**: Examples
  - **translated**: Contoh

- **com_ui_new_chat**:
  - **english**: New chat
  - **translated**: Chat Baru

- **com_ui_happy_birthday**:
  - **english**: It's my 1st birthday!
  - **translated**: Ini ulang tahun pertamaku!

- **com_ui_example_quantum_computing**:
  - **english**: Explain quantum computing in simple terms
  - **translated**: Jelaskan komputasi kuantum dengan istilah yang sederhana

- **com_ui_example_10_year_old_b_day**:
  - **english**: Got any creative ideas for a 10 year old's birthday?
  - **translated**: Ada ide kreatif untuk ulang tahun anak 10 tahun?

- **com_ui_example_http_in_js**:
  - **english**: How do I make an HTTP request in Javascript?
  - **translated**: Bagaimana cara membuat permintaan HTTP dalam Javascript?

- **com_ui_capabilities**:
  - **english**: Capabilities
  - **translated**: Kemampuan

- **com_ui_capability_remember**:
  - **english**: Remembers what user said earlier in the conversation
  - **translated**: Mengingat apa yang pengguna katakan sebelumnya dalam percakapan

- **com_ui_capability_correction**:
  - **english**: Allows user to provide follow-up corrections
  - **translated**: Memungkinkan pengguna untuk memberikan koreksi tindak lanjut

- **com_ui_capability_decline_requests**:
  - **english**: Trained to decline inappropriate requests
  - **translated**: Dilatih untuk menolak permintaan yang tidak pantas

- **com_ui_limitations**:
  - **english**: Limitations
  - **translated**: Keterbatasan

- **com_ui_limitation_incorrect_info**:
  - **english**: May occasionally generate incorrect information
  - **translated**: Mungkin sesekali menghasilkan informasi yang salah

- **com_ui_limitation_harmful_biased**:
  - **english**: May occasionally produce harmful instructions or biased content
  - **translated**: Mungkin sesekali menghasilkan instruksi yang berbahaya atau konten yang bias

- **com_ui_limitation_limited_2021**:
  - **english**: Limited knowledge of world and events after 2021
  - **translated**: Pengetahuan terbatas tentang dunia dan peristiwa setelah 2021

- **com_ui_experimental**:
  - **english**: Experimental Features
  - **translated**: Fitur Eksperimental

- **com_ui_input**:
  - **english**: Input
  - **translated**: Masukan

- **com_ui_close**:
  - **english**: Close
  - **translated**: Tutup

- **com_ui_model**:
  - **english**: Model
  - **translated**: Model

- **com_ui_select_model**:
  - **english**: Select a model
  - **translated**: Pilih model

- **com_ui_use_prompt**:
  - **english**: Use prompt
  - **translated**: Gunakan petunjuk

- **com_ui_prev**:
  - **english**: Prev
  - **translated**: Sebelumnya

- **com_ui_next**:
  - **english**: Next
  - **translated**: Berikutnya

- **com_ui_stop**:
  - **english**: Stop
  - **translated**: Berhenti

- **com_ui_prompt_templates**:
  - **english**: Prompt Templates
  - **translated**: Template Petunjuk

- **com_ui_hide_prompt_templates**:
  - **english**: Hide Prompt Templates
  - **translated**: Sembunyikan Template Petunjuk

- **com_ui_showing**:
  - **english**: Showing
  - **translated**: Menampilkan

- **com_ui_of**:
  - **english**: of
  - **translated**: dari

- **com_ui_entries**:
  - **english**: Entries
  - **translated**: Entri

- **com_ui_pay_per_call**:
  - **english**: All AI conversations in one place. Pay per call and not per month
  - **translated**: Semua percakapan AI di satu tempat. Bayar per panggilan dan bukan per bulan

- **com_ui_new_footer**:
  - **english**: All AI conversations in one place.
  - **translated**: Semua percakapan AI di satu tempat.

- **com_ui_enter**:
  - **english**: Enter
  - **translated**: Masuk

- **com_ui_submit**:
  - **english**: Submit
  - **translated**: Kirim

- **com_ui_upload_success**:
  - **english**: Successfully uploaded file
  - **translated**: Berhasil mengunggah file

- **com_ui_upload_error**:
  - **english**: There was an error uploading your file
  - **translated**: Ada kesalahan saat mengunggah file Anda

- **com_ui_upload_invalid**:
  - **english**: Invalid file for upload. Must be an image not exceeding 2 MB
  - **translated**: File tidak valid untuk diunggah. Harus berupa gambar yang tidak melebihi 2 MB

- **com_ui_cancel**:
  - **english**: Cancel
  - **translated**: Batal

- **com_ui_save**:
  - **english**: Save
  - **translated**: Simpan

- **com_ui_save_submit**:
  - **english**: Save & Submit
  - **translated**: Simpan & Kirim

- **com_user_message**:
  - **english**: You
  - **translated**: Kamu

- **com_ui_copy_to_clipboard**:
  - **english**: Copy to clipboard
  - **translated**: Salin ke papan klip

- **com_ui_copied_to_clipboard**:
  - **english**: Copied to clipboard
  - **translated**: Disalin ke papan klip

- **com_ui_regenerate**:
  - **english**: Regenerate
  - **translated**: Regenerasi

- **com_ui_continue**:
  - **english**: Continue
  - **translated**: Lanjutkan

- **com_ui_edit**:
  - **english**: Edit
  - **translated**: Edit

- **com_ui_success**:
  - **english**: Success
  - **translated**: Berhasil

- **com_ui_all**:
  - **english**: all
  - **translated**: semua

- **com_ui_clear**:
  - **english**: Clear
  - **translated**: Bersihkan

- **com_ui_revoke**:
  - **english**: Revoke
  - **translated**: Cabut

- **com_ui_revoke_info**:
  - **english**: Revoke all user provided credentials
  - **translated**: Cabut semua kredensial yang diberikan pengguna

- **com_ui_import_conversation**:
  - **english**: Import
  - **translated**: Impor

- **com_ui_import_conversation_info**:
  - **english**: Import conversations from a JSON file
  - **translated**: Impor percakapan dari file JSON

- **com_ui_import_conversation_success**:
  - **english**: Conversations imported successfully
  - **translated**: Percakapan berhasil diimpor

- **com_ui_import_conversation_error**:
  - **english**: There was an error importing your conversations
  - **translated**: Terjadi kesalahan saat mengimpor percakapan Anda

- **com_ui_confirm_action**:
  - **english**: Confirm Action
  - **translated**: Konfirmasi Aksi

- **com_ui_chats**:
  - **english**: chats
  - **translated**: chat

- **com_ui_delete**:
  - **english**: Delete
  - **translated**: Hapus

- **com_ui_delete_conversation**:
  - **english**: Delete chat?
  - **translated**: Hapus chat?

- **com_ui_delete_confirm**:
  - **english**: This will delete
  - **translated**: Ini akan menghapus

- **com_ui_rename**:
  - **english**: Rename
  - **translated**: Renombrar

- **com_ui_archive**:
  - **english**: Archive
  - **translated**: Arsip

- **com_ui_archive_error**:
  - **english**: Failed to archive conversation
  - **translated**: Gagal mengarsipkan percakapan

- **com_ui_unarchive**:
  - **english**: Unarchive
  - **translated**: Buka Arsip

- **com_ui_unarchive_error**:
  - **english**: Failed to unarchive conversation
  - **translated**: Gagal membuka arsip

- **com_ui_more_options**:
  - **english**: More
  - **translated**: Lebih

- **com_ui_preview**:
  - **english**: Preview
  - **translated**: Pratinjau

- **com_ui_upload**:
  - **english**: Upload
  - **translated**: Unggah

- **com_ui_connect**:
  - **english**: Connect
  - **translated**: Hubungkan

- **com_auth_error_login**:
  - **english**: Unable to login with the information provided. Please check your credentials and try again.
  - **translated**: Tidak dapat masuk dengan informasi yang diberikan. Silakan periksa kredensial Anda dan coba lagi.

- **com_auth_error_login_rl**:
  - **english**: Too many login attempts in a short amount of time. Please try again later.
  - **translated**: Terlalu banyak upaya masuk dalam waktu singkat. Silakan coba lagi nanti.

- **com_auth_error_login_ban**:
  - **english**: Your account has been temporarily banned due to violations of our service.
  - **translated**: Akun Anda telah dilarang sementara karena pelanggaran layanan kami.

- **com_auth_error_login_server**:
  - **english**: There was an internal server error. Please wait a few moments and try again.
  - **translated**: Ada kesalahan server internal. Harap tunggu beberapa saat dan coba lagi.

- **com_auth_no_account**:
  - **english**: Don't have an account?
  - **translated**: Tidak memiliki akun?

- **com_auth_sign_up**:
  - **english**: Sign up
  - **translated**: Daftar

- **com_auth_sign_in**:
  - **english**: Sign in
  - **translated**: Masuk

- **com_auth_google_login**:
  - **english**: Continue with Google
  - **translated**: Masuk dengan Google

- **com_auth_facebook_login**:
  - **english**: Continue with Facebook
  - **translated**: Masuk dengan Facebook

- **com_auth_github_login**:
  - **english**: Continue with Github
  - **translated**: Masuk dengan Github

- **com_auth_discord_login**:
  - **english**: Continue with Discord
  - **translated**: Masuk dengan Discord

- **com_auth_email**:
  - **english**: Email
  - **translated**: Email

- **com_auth_email_required**:
  - **english**: Email is required
  - **translated**: Email diperlukan

- **com_auth_email_min_length**:
  - **english**: Email must be at least 6 characters
  - **translated**: Email harus setidaknya 6 karakter

- **com_auth_email_max_length**:
  - **english**: Email should not be longer than 120 characters
  - **translated**: Email tidak boleh lebih dari 120 karakter

- **com_auth_email_pattern**:
  - **english**: You must enter a valid email address
  - **translated**: Anda harus memasukkan alamat email yang valid

- **com_auth_email_address**:
  - **english**: Email address
  - **translated**: Alamat email

- **com_auth_password**:
  - **english**: Password
  - **translated**: Kata sandi

- **com_auth_password_required**:
  - **english**: Password is required
  - **translated**: Kata sandi diperlukan

- **com_auth_password_min_length**:
  - **english**: Password must be at least 8 characters
  - **translated**: Kata sandi harus setidaknya 8 karakter

- **com_auth_password_max_length**:
  - **english**: Password must be less than 128 characters
  - **translated**: Kata sandi harus kurang dari 128 karakter

- **com_auth_password_forgot**:
  - **english**: Forgot Password?
  - **translated**: Lupa Kata Sandi?

- **com_auth_password_confirm**:
  - **english**: Confirm password
  - **translated**: Konfirmasi kata sandi

- **com_auth_password_not_match**:
  - **english**: Passwords do not match
  - **translated**: Kata sandi tidak cocok

- **com_auth_continue**:
  - **english**: Continue
  - **translated**: Lanjutkan

- **com_auth_create_account**:
  - **english**: Create your account
  - **translated**: Buat akun Anda

- **com_auth_error_create**:
  - **english**: There was an error attempting to register your account. Please try again.
  - **translated**: Ada kesalahan saat mencoba mendaftarkan akun Anda. Silakan coba lagi.

- **com_auth_full_name**:
  - **english**: Full name
  - **translated**: Nama lengkap

- **com_auth_name_required**:
  - **english**: Name is required
  - **translated**: Nama diperlukan

- **com_auth_name_min_length**:
  - **english**: Name must be at least 3 characters
  - **translated**: Nama harus setidaknya 3 karakter

- **com_auth_name_max_length**:
  - **english**: Name must be less than 80 characters
  - **translated**: Nama harus kurang dari 80 karakter

- **com_auth_username**:
  - **english**: Username (optional)
  - **translated**: Nama pengguna (opsional)

- **com_auth_username_required**:
  - **english**: Username is required
  - **translated**: Nama pengguna diperlukan

- **com_auth_username_min_length**:
  - **english**: Username must be at least 2 characters
  - **translated**: Nama pengguna harus setidaknya 2 karakter

- **com_auth_username_max_length**:
  - **english**: Username must be less than 20 characters
  - **translated**: Nama pengguna harus kurang dari 20 karakter

- **com_auth_already_have_account**:
  - **english**: Already have an account?
  - **translated**: Sudah memiliki akun?

- **com_auth_login**:
  - **english**: Login
  - **translated**: Masuk

- **com_auth_reset_password**:
  - **english**: Reset your password
  - **translated**: Atur ulang kata sandi Anda

- **com_auth_click**:
  - **english**: Click
  - **translated**: Klik

- **com_auth_here**:
  - **english**: HERE
  - **translated**: DI SINI

- **com_auth_to_reset_your_password**:
  - **english**: to reset your password.
  - **translated**: untuk mengatur ulang kata sandi Anda.

- **com_auth_reset_password_link_sent**:
  - **english**: Email Sent
  - **translated**: Email Terkirim

- **com_auth_reset_password_email_sent**:
  - **english**: An email has been sent to you with further instructions to reset your password.
  - **translated**: Email telah dikirim kepada Anda dengan instruksi lebih lanjut untuk mengatur ulang kata sandi Anda.

- **com_auth_error_reset_password**:
  - **english**: There was a problem resetting your password. There was no user found with the email address provided. Please try again.
  - **translated**: Ada masalah saat mengatur ulang kata sandi Anda. Tidak ada pengguna yang ditemukan dengan alamat email yang diberikan. Silakan coba lagi.

- **com_auth_reset_password_success**:
  - **english**: Password Reset Success
  - **translated**: Berhasil Mengatur Ulang Kata Sandi

- **com_auth_login_with_new_password**:
  - **english**: You may now login with your new password.
  - **translated**: Anda sekarang dapat masuk dengan kata sandi baru Anda.

- **com_auth_error_invalid_reset_token**:
  - **english**: This password reset token is no longer valid.
  - **translated**: Token pengaturan ulang kata sandi ini tidak lagi valid.

- **com_auth_click_here**:
  - **english**: Click here
  - **translated**: Klik di sini

- **com_auth_to_try_again**:
  - **english**: to try again.
  - **translated**: untuk mencoba lagi.

- **com_auth_submit_registration**:
  - **english**: Submit registration
  - **translated**: Kirim pendaftaran

- **com_auth_welcome_back**:
  - **english**: Welcome back
  - **translated**: Selamat datang kembali

- **com_endpoint_open_menu**:
  - **english**: Open Menu
  - **translated**: Buka Menu

- **com_endpoint_bing_enable_sydney**:
  - **english**: Enable Sydney
  - **translated**: Aktifkan Sydney

- **com_endpoint_bing_to_enable_sydney**:
  - **english**: To enable Sydney
  - **translated**: Untuk mengaktifkan Sydney

- **com_endpoint_bing_jailbreak**:
  - **english**: Jailbreak
  - **translated**: Jailbreak

- **com_endpoint_bing_context_placeholder**:
  - **english**: Bing can use up to 7k tokens for 'context', which it can reference for the conversation. The specific limit is not known but may run into errors exceeding 7k tokens
  - **translated**: Bing dapat menggunakan hingga 7k token untuk 'konteks', yang dapat dirujuk untuk percakapan. Batas spesifik tidak diketahui tetapi mungkin menemui kesalahan melebihi 7k token

- **com_endpoint_bing_system_message_placeholder**:
  - **english**: WARNING: Misuse of this feature can get you BANNED from using Bing! Click on 'System Message' for full instructions and the default message if omitted, which is the 'Sydney' preset that is considered safe.
  - **translated**: PERINGATAN: Penyalahgunaan fitur ini dapat membuat Anda DILARANG menggunakan Bing! Klik pada 'Pesan Sistem' untuk instruksi lengkap dan pesan default jika diabaikan, yang merupakan preset 'Sydney' yang dianggap aman.

- **com_endpoint_system_message**:
  - **english**: System Message
  - **translated**: Pesan Sistem

- **com_endpoint_message**:
  - **english**: Message
  - **translated**: Pesan

- **com_endpoint_message_not_appendable**:
  - **english**: Edit your message or Regenerate.
  - **translated**: Edit pesan Anda atau Regenerasi.

- **com_endpoint_default_blank**:
  - **english**: default: blank
  - **translated**: default: kosong

- **com_endpoint_default_false**:
  - **english**: default: false
  - **translated**: default: salah

- **com_endpoint_default_creative**:
  - **english**: default: creative
  - **translated**: default: kreatif

- **com_endpoint_default_empty**:
  - **english**: default: empty
  - **translated**: default: kosong

- **com_endpoint_default_with_num**:
  - **english**: default: {0}
  - **translated**: default: {0}

- **com_endpoint_context**:
  - **english**: Context
  - **translated**: Konteks

- **com_endpoint_tone_style**:
  - **english**: Tone Style
  - **translated**: Gaya Nada

- **com_endpoint_token_count**:
  - **english**: Token count
  - **translated**: Jumlah Token

- **com_endpoint_output**:
  - **english**: Output
  - **translated**: Output

- **com_endpoint_google_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: Nilai yang lebih tinggi = lebih acak, sedangkan nilai yang lebih rendah = lebih fokus dan deterministik. Kami merekomendasikan untuk mengubah ini atau Top P tetapi tidak keduanya.

- **com_endpoint_google_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p mengubah cara model memilih token untuk output. Token dipilih dari yang paling mungkin (lihat parameter topK) hingga yang paling tidak mungkin sampai jumlah probabilitas mereka sama dengan nilai top-p.

- **com_endpoint_google_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k mengubah cara model memilih token untuk output. Top-k 1 berarti token yang dipilih adalah yang paling mungkin di antara semua token dalam kosakata model (juga disebut decoding serakah), sedangkan top-k 3 berarti token berikutnya dipilih dari antara 3 token yang paling mungkin (menggunakan temperatur).

- **com_endpoint_google_maxoutputtokens**:
  - **english**:  	Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: Jumlah maksimum token yang dapat dihasilkan dalam respons. Tentukan nilai yang lebih rendah untuk respons yang lebih pendek dan nilai yang lebih tinggi untuk respons yang lebih panjang.

- **com_endpoint_google_custom_name_placeholder**:
  - **english**: Set a custom name for Google
  - **translated**: Tetapkan nama kustom untuk Google

- **com_endpoint_prompt_prefix_placeholder**:
  - **english**: Set custom instructions or context. Ignored if empty.
  - **translated**: Tetapkan instruksi kustom atau konteks. Diabaikan jika kosong.

- **com_endpoint_custom_name**:
  - **english**: Custom Name
  - **translated**: Nama Kustom

- **com_endpoint_prompt_prefix**:
  - **english**: Custom Instructions
  - **translated**: Awalan Prompt

- **com_endpoint_temperature**:
  - **english**: Temperature
  - **translated**: Temperatur

- **com_endpoint_default**:
  - **english**: default
  - **translated**: default

- **com_endpoint_top_p**:
  - **english**: Top P
  - **translated**: Top P

- **com_endpoint_top_k**:
  - **english**: Top K
  - **translated**: Top K

- **com_endpoint_max_output_tokens**:
  - **english**: Max Output Tokens
  - **translated**: Token Output Maks

- **com_endpoint_openai_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: Nilai yang lebih tinggi = lebih acak, sedangkan nilai yang lebih rendah = lebih fokus dan deterministik. Kami merekomendasikan untuk mengubah ini atau Top P tetapi tidak keduanya.

- **com_endpoint_openai_max**:
  - **english**: The max tokens to generate. The total length of input tokens and generated tokens is limited by the model's context length.
  - **translated**: Token maksimum yang akan dihasilkan. Panjang total token masukan dan token yang dihasilkan dibatasi oleh panjang konteks model.

- **com_endpoint_openai_topp**:
  - **english**: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We recommend altering this or temperature but not both.
  - **translated**: Sebuah alternatif untuk pengambilan sampel dengan suhu, disebut pengambilan sampel inti, di mana model mempertimbangkan hasil dari token dengan massa probabilitas top_p. Jadi 0,1 berarti hanya token yang mencakup 10% massa probabilitas teratas yang dipertimbangkan. Kami merekomendasikan untuk mengubah ini atau suhu tetapi tidak keduanya.

- **com_endpoint_openai_freq**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
  - **translated**: Angka antara -2,0 dan 2,0. Nilai positif menghukum token baru berdasarkan frekuensi mereka yang ada dalam teks sejauh ini, mengurangi kemungkinan model untuk mengulangi baris yang sama secara harfiah.

- **com_endpoint_openai_pres**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
  - **translated**: Angka antara -2,0 dan 2,0. Nilai positif menghukum token baru berdasarkan apakah mereka muncul dalam teks sejauh ini, meningkatkan kemungkinan model untuk berbicara tentang topik baru.

- **com_endpoint_openai_resend**:
  - **english**: Resend all previously attached images. Note: this can significantly increase token cost and you may experience errors with many image attachments.
  - **translated**: Kirim ulang semua gambar yang sebelumnya dilampirkan. Catatan: ini dapat meningkatkan biaya token secara signifikan dan Anda mungkin mengalami kesalahan dengan banyak lampiran gambar.

- **com_endpoint_openai_detail**:
  - **english**: The resolution for Vision requests. "Low" is cheaper and faster, "High" is more detailed and expensive, and "Auto" will automatically choose between the two based on the image resolution.
  - **translated**: Resolusi untuk permintaan Vision. "Rendah" lebih murah dan lebih cepat, "Tinggi" lebih detail dan mahal, dan "Otomatis" akan secara otomatis memilih antara keduanya berdasarkan resolusi gambar.

- **com_endpoint_openai_custom_name_placeholder**:
  - **english**: Set a custom name for the AI
  - **translated**: Tetapkan nama kustom untuk ChatGPT

- **com_endpoint_openai_prompt_prefix_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: Tetapkan instruksi kustom untuk dimasukkan dalam Pesan Sistem. Default: tidak ada

- **com_endpoint_anthropic_temp**:
  - **english**: Ranges from 0 to 1. Use temp closer to 0 for analytical / multiple choice, and closer to 1 for creative and generative tasks. We recommend altering this or Top P but not both.
  - **translated**: Berkisar dari 0 hingga 1. Gunakan temp yang lebih dekat ke 0 untuk analitis / pilihan ganda, dan lebih dekat ke 1 untuk tugas kreatif dan generatif. Kami merekomendasikan untuk mengubah ini atau Top P tetapi tidak keduanya.

- **com_endpoint_anthropic_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p mengubah cara model memilih token untuk output. Token dipilih dari yang paling mungkin (lihat parameter topK) hingga yang paling tidak mungkin sampai jumlah probabilitas mereka sama dengan nilai top-p.

- **com_endpoint_anthropic_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k mengubah cara model memilih token untuk output. Top-k 1 berarti token yang dipilih adalah yang paling mungkin di antara semua token dalam kosakata model (juga disebut decoding serakah), sedangkan top-k 3 berarti token berikutnya dipilih dari antara 3 token yang paling mungkin (menggunakan suhu).

- **com_endpoint_anthropic_maxoutputtokens**:
  - **english**: Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: Jumlah maksimum token yang dapat dihasilkan dalam respons. Tentukan nilai yang lebih rendah untuk respons yang lebih pendek dan nilai yang lebih tinggi untuk respons yang lebih panjang.

- **com_endpoint_anthropic_custom_name_placeholder**:
  - **english**: Set a custom name for Anthropic
  - **translated**: Tetapkan nama kustom untuk Anthropic

- **com_endpoint_frequency_penalty**:
  - **english**: Frequency Penalty
  - **translated**: Penalti Frekuensi

- **com_endpoint_presence_penalty**:
  - **english**: Presence Penalty
  - **translated**: Penalti Kehadiran

- **com_endpoint_plug_use_functions**:
  - **english**: Use Functions
  - **translated**: Gunakan Fungsi

- **com_endpoint_plug_resend_images**:
  - **english**: Resend Images
  - **translated**: Kirim Ulang Gambar

- **com_endpoint_plug_image_detail**:
  - **english**: Image Detail
  - **translated**: Rincian Gambar

- **com_endpoint_plug_skip_completion**:
  - **english**: Skip Completion
  - **translated**: Lewati Penyelesaian

- **com_endpoint_disabled_with_tools**:
  - **english**: disabled with tools
  - **translated**: dinonaktifkan dengan alat

- **com_endpoint_disabled_with_tools_placeholder**:
  - **english**: Disabled with Tools Selected
  - **translated**: Dinonaktifkan dengan Alat yang Dipilih

- **com_endpoint_plug_set_custom_instructions_for_gpt_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: Tetapkan instruksi kustom untuk dimasukkan dalam Pesan Sistem. Default: tidak ada

- **com_endpoint_import**:
  - **english**: Import
  - **translated**: Impor

- **com_endpoint_set_custom_name**:
  - **english**: Set a custom name, in case you can find this preset
  - **translated**: Tetapkan nama kustom, jika Anda dapat menemukan preset ini

- **com_endpoint_preset_delete_confirm**:
  - **english**: Are you sure you want to delete this preset?
  - **translated**: Anda yakin ingin menghapus preset ini?

- **com_endpoint_preset_clear_all_confirm**:
  - **english**: Are you sure you want to delete all of your presets?
  - **translated**: Anda yakin ingin menghapus semua preset Anda?

- **com_endpoint_preset_import**:
  - **english**: Preset Imported!
  - **translated**: Preset Diimpor!

- **com_endpoint_preset_import_error**:
  - **english**: There was an error importing your preset. Please try again.
  - **translated**: Ada kesalahan saat mengimpor preset Anda. Silakan coba lagi.

- **com_endpoint_preset_save_error**:
  - **english**: There was an error saving your preset. Please try again.
  - **translated**: Ada kesalahan saat menyimpan preset Anda. Silakan coba lagi.

- **com_endpoint_preset_delete_error**:
  - **english**: There was an error deleting your preset. Please try again.
  - **translated**: Ada kesalahan saat menghapus preset Anda. Silakan coba lagi.

- **com_endpoint_preset_default_removed**:
  - **english**: is no longer the default preset.
  - **translated**: tidak lagi menjadi preset default.

- **com_endpoint_preset_default_item**:
  - **english**: Default:
  - **translated**: Default:

- **com_endpoint_preset_default_none**:
  - **english**: No default preset active.
  - **translated**: Tidak ada preset default yang aktif.

- **com_endpoint_preset_title**:
  - **english**: Preset
  - **translated**: Preset

- **com_endpoint_preset_saved**:
  - **english**: Saved!
  - **translated**: Tersimpan!

- **com_endpoint_preset_default**:
  - **english**: is now the default preset.
  - **translated**: sekarang menjadi preset default.

- **com_endpoint_preset**:
  - **english**: preset
  - **translated**: preset

- **com_endpoint_presets**:
  - **english**: presets
  - **translated**: presets

- **com_endpoint_preset_selected**:
  - **english**: Preset Active!
  - **translated**: Preset Aktif!

- **com_endpoint_preset_selected_title**:
  - **english**: Active!
  - **translated**: Aktif!

- **com_endpoint_preset_name**:
  - **english**: Preset Name
  - **translated**: Nama Preset

- **com_endpoint_new_topic**:
  - **english**: New Topic
  - **translated**: Topik Baru

- **com_endpoint**:
  - **english**: Endpoint
  - **translated**: Endpoint

- **com_endpoint_hide**:
  - **english**: Hide
  - **translated**: Sembunyikan

- **com_endpoint_show**:
  - **english**: Show
  - **translated**: Tampilkan

- **com_endpoint_examples**:
  - **english**:  Presets
  - **translated**:  Preset

- **com_endpoint_completion**:
  - **english**: Completion
  - **translated**: Penyelesaian

- **com_endpoint_agent**:
  - **english**: Agent
  - **translated**: Agen

- **com_endpoint_show_what_settings**:
  - **english**: Show {0} Settings
  - **translated**: Tampilkan {0} Pengaturan

- **com_endpoint_export**:
  - **english**: Export
  - **translated**: Ekspor

- **com_endpoint_save_as_preset**:
  - **english**: Save As Preset
  - **translated**: Simpan Sebagai Preset

- **com_endpoint_presets_clear_warning**:
  - **english**: Are you sure you want to clear all presets? This is irreversible.
  - **translated**: Anda yakin ingin menghapus semua preset? Ini tidak dapat dibatalkan.

- **com_endpoint_not_implemented**:
  - **english**: Not implemented
  - **translated**: Belum diimplementasikan

- **com_endpoint_no_presets**:
  - **english**: No presets yet, use the settings button to create one
  - **translated**: Belum ada preset, gunakan tombol pengaturan untuk membuat satu

- **com_endpoint_not_available**:
  - **english**: No endpoint available
  - **translated**: Endpoint tidak tersedia

- **com_endpoint_view_options**:
  - **english**: View Options
  - **translated**: Lihat Opsi

- **com_endpoint_save_convo_as_preset**:
  - **english**: Save Conversation as Preset
  - **translated**: Simpan Percakapan sebagai Preset

- **com_endpoint_my_preset**:
  - **english**: My Preset
  - **translated**: Preset Saya

- **com_endpoint_agent_model**:
  - **english**: Agent Model (Recommended: GPT-3.5)
  - **translated**: Model Agen (Direkomendasikan: GPT-3.5)

- **com_endpoint_completion_model**:
  - **english**: Completion Model (Recommended: GPT-4)
  - **translated**: Model Penyelesaian (Direkomendasikan: GPT-4)

- **com_endpoint_func_hover**:
  - **english**: Enable use of Plugins as OpenAI Functions
  - **translated**: Aktifkan penggunaan Plugin sebagai Fungsi OpenAI

- **com_endpoint_skip_hover**:
  - **english**: Enable skipping the completion step, which reviews the final answer and generated steps
  - **translated**: Aktifkan langkah penyelesaian yang dilewati, yang meninjau jawaban akhir dan langkah yang dihasilkan

- **com_endpoint_config_key**:
  - **english**: Set API Key
  - **translated**: Atur Kunci API

- **com_endpoint_config_placeholder**:
  - **english**: Set your Key in the Header menu to chat.
  - **translated**: Atur Kunci Anda di menu Header untuk mengobrol.

- **com_endpoint_config_key_for**:
  - **english**: Set API Key for
  - **translated**: Atur Kunci API untuk

- **com_endpoint_config_key_name**:
  - **english**: Key
  - **translated**: Kunci

- **com_endpoint_config_value**:
  - **english**: Enter value for
  - **translated**: Masukkan nilai untuk

- **com_endpoint_config_key_name_placeholder**:
  - **english**: Set API key first
  - **translated**: Atur kunci API terlebih dahulu

- **com_endpoint_config_key_encryption**:
  - **english**: Your key will be encrypted and deleted at
  - **translated**: Kunci Anda akan dienkripsi dan dihapus pada

- **com_endpoint_config_key_expiry**:
  - **english**: the expiry time
  - **translated**: waktu kedaluwarsa

- **com_endpoint_config_click_here**:
  - **english**: Click Here
  - **translated**: Klik Di Sini

- **com_endpoint_config_google_service_key**:
  - **english**: Google Service Account Key
  - **translated**: Kunci Akun Layanan Google

- **com_endpoint_config_google_cloud_platform**:
  - **english**: (from Google Cloud Platform)
  - **translated**: (dari Google Cloud Platform)

- **com_endpoint_config_google_api_key**:
  - **english**: Google API Key
  - **translated**: Kunci API Google

- **com_endpoint_config_google_gemini_api**:
  - **english**: (Gemini API)
  - **translated**: (Gemini API)

- **com_endpoint_config_google_api_info**:
  - **english**: To get your Generative Language API key (for Gemini),
  - **translated**: Untuk mendapatkan kunci API Bahasa Generatif Anda (untuk Gemini),

- **com_endpoint_config_key_import_json_key**:
  - **english**: Import Service Account JSON Key.
  - **translated**: Impor Kunci JSON Akun Layanan.

- **com_endpoint_config_key_import_json_key_success**:
  - **english**: Successfully Imported Service Account JSON Key
  - **translated**: Berhasil Mengimpor Kunci JSON Akun Layanan

- **com_endpoint_config_key_import_json_key_invalid**:
  - **english**: Invalid Service Account JSON Key, Did you import the correct file?
  - **translated**: Kunci JSON Akun Layanan Tidak Valid, Apakah Anda mengimpor file yang benar?

- **com_endpoint_config_key_get_edge_key**:
  - **english**: To get your Access token for Bing, login to
  - **translated**: Untuk mendapatkan token akses Anda untuk Bing, masuk ke

- **com_endpoint_config_key_get_edge_key_dev_tool**:
  - **english**: Use dev tools or an extension while logged into the site to copy the content of the _U cookie. If this fails, follow these
  - **translated**: Gunakan alat pengembang atau ekstensi saat masuk ke situs untuk menyalin konten dari cookie _U. Jika ini gagal, ikuti ini

- **com_endpoint_config_key_edge_instructions**:
  - **english**: instructions
  - **translated**: instruksi

- **com_endpoint_config_key_edge_full_key_string**:
  - **english**: to provide the full cookie strings.
  - **translated**: untuk memberikan string cookie lengkap.

- **com_endpoint_config_key_chatgpt**:
  - **english**: To get your Access token For ChatGPT 'Free Version', login to
  - **translated**: Untuk mendapatkan token akses Anda Untuk ChatGPT 'Versi Gratis', masuk ke

- **com_endpoint_config_key_chatgpt_then_visit**:
  - **english**: then visit
  - **translated**: kemudian kunjungi

- **com_endpoint_config_key_chatgpt_copy_token**:
  - **english**: Copy access token.
  - **translated**: Salin token akses.

- **com_endpoint_config_key_google_need_to**:
  - **english**: You need to
  - **translated**: Anda perlu

- **com_endpoint_config_key_google_vertex_ai**:
  - **english**: Enable Vertex AI
  - **translated**: Aktifkan Vertex AI

- **com_endpoint_config_key_google_vertex_api**:
  - **english**: API on Google Cloud, then
  - **translated**: API di Google Cloud, kemudian

- **com_endpoint_config_key_google_service_account**:
  - **english**: Create a Service Account
  - **translated**: Buat Akun Layanan

- **com_endpoint_config_key_google_vertex_api_role**:
  - **english**: Make sure to click 'Create and Continue' to give at least the 'Vertex AI User' role. Lastly, create a JSON key to import here.
  - **translated**: Pastikan untuk mengklik 'Buat dan Lanjutkan' untuk memberikan setidaknya peran 'Pengguna Vertex AI'. Terakhir, buat kunci JSON untuk diimpor di sini.

- **com_nav_welcome_message**:
  - **english**: How can I help you today?
  - **translated**: Bagaimana saya bisa membantu Anda hari ini?

- **com_nav_auto_scroll**:
  - **english**: Auto-scroll to Newest on Open
  - **translated**: Otomatis gulir ke Baru saat Buka

- **com_nav_modular_chat**:
  - **english**: Enable switching Endpoints mid-conversation
  - **translated**: Aktifkan penggantian Endpoint di tengah percakapan

- **com_nav_latex_parsing**:
  - **english**: Parsing LaTeX in messages (may affect performance)
  - **translated**: Parsing LaTeX dalam pesan (dapat memengaruhi kinerja)

- **com_nav_profile_picture**:
  - **english**: Profile Picture
  - **translated**: Foto Profil

- **com_nav_change_picture**:
  - **english**: Change picture
  - **translated**: Ubah foto

- **com_nav_plugin_store**:
  - **english**: Plugin store
  - **translated**: Toko plugin

- **com_show_agent_settings**:
  - **english**: Show Agent Settings
  - **translated**: Tampilkan Pengaturan Agen

- **com_show_completion_settings**:
  - **english**: Show Completion Settings
  - **translated**: Tampilkan Pengaturan Penyelesaian

- **com_hide_examples**:
  - **english**: Hide Examples
  - **translated**: Sembunyikan Contoh

- **com_show_examples**:
  - **english**: Show Examples
  - **translated**: Tampilkan Contoh

- **com_nav_plugin_search**:
  - **english**: Search plugins
  - **translated**: Cari plugin

- **com_nav_plugin_auth_error**:
  - **english**: There was an error attempting to authenticate this plugin. Please try again.
  - **translated**: Ada kesalahan saat mencoba mengautentikasi plugin ini. Silakan coba lagi.

- **com_nav_export_filename**:
  - **english**: Filename
  - **translated**: Nama File

- **com_nav_export_filename_placeholder**:
  - **english**: Set the filename
  - **translated**: Atur nama file

- **com_nav_export_type**:
  - **english**: Type
  - **translated**: Tipe

- **com_nav_export_include_endpoint_options**:
  - **english**: Include endpoint options
  - **translated**: Sertakan opsi endpoint

- **com_nav_enabled**:
  - **english**: Enabled
  - **translated**: Diaktifkan

- **com_nav_not_supported**:
  - **english**: Not Supported
  - **translated**: Tidak Didukung

- **com_nav_export_all_message_branches**:
  - **english**: Export all message branches
  - **translated**: Ekspor semua cabang pesan

- **com_nav_export_recursive_or_sequential**:
  - **english**: Recursive or sequential?
  - **translated**: Rekursif atau berurutan?

- **com_nav_export_recursive**:
  - **english**: Recursive
  - **translated**: Rekursif

- **com_nav_export_conversation**:
  - **english**: Export conversation
  - **translated**: Ekspor percakapan

- **com_nav_theme**:
  - **english**: Theme
  - **translated**: Tema

- **com_nav_theme_system**:
  - **english**: System
  - **translated**: Sistem

- **com_nav_theme_dark**:
  - **english**: Dark
  - **translated**: Gelap

- **com_nav_theme_light**:
  - **english**: Light
  - **translated**: Terang

- **com_nav_user_name_display**:
  - **english**: Display username in messages
  - **translated**: Tampilkan nama pengguna dalam pesan

- **com_nav_clear_all_chats**:
  - **english**: Clear all chats
  - **translated**: Hapus semua obrolan

- **com_nav_confirm_clear**:
  - **english**: Confirm Clear
  - **translated**: Konfirmasi Hapus

- **com_nav_close_sidebar**:
  - **english**: Close sidebar
  - **translated**: Tutup sidebar

- **com_nav_open_sidebar**:
  - **english**: Open sidebar
  - **translated**: Buka sidebar

- **com_nav_send_message**:
  - **english**: Send message
  - **translated**: Kirim pesan

- **com_nav_log_out**:
  - **english**: Log out
  - **translated**: Keluar

- **com_nav_user**:
  - **english**: USER
  - **translated**: PENGGUNA

- **com_nav_archived_chats**:
  - **english**: Archived chats
  - **translated**: Percakapan Arsip

- **com_nav_archived_chats_manage**:
  - **english**: Manage
  - **translated**: Pengelolaan

- **com_nav_archived_chats_empty**:
  - **english**: You have no archived conversations.
  - **translated**: Tidak ada percakapan yang diarsipkan.

- **com_nav_archive_all_chats**:
  - **english**: Archive all chats
  - **translated**: Arsipkan semua percakapan

- **com_nav_archive_all**:
  - **english**: Archive all
  - **translated**: Arsipkan semua

- **com_nav_archive_name**:
  - **english**: Name
  - **translated**: Nama

- **com_nav_archive_created_at**:
  - **english**: DateCreated
  - **translated**: TanggalDibuat

- **com_nav_clear_conversation**:
  - **english**: Clear conversations
  - **translated**: Hapus percakapan

- **com_nav_clear_conversation_confirm_message**:
  - **english**: Are you sure you want to clear all conversations? This is irreversible.
  - **translated**: Anda yakin ingin menghapus semua percakapan? Ini tidak dapat dibatalkan.

- **com_nav_help_faq**:
  - **english**: Help & FAQ
  - **translated**: Bantuan & FAQ

- **com_nav_settings**:
  - **english**: Settings
  - **translated**: Pengaturan

- **com_nav_search_placeholder**:
  - **english**: Search messages
  - **translated**: Cari pesan

- **com_nav_setting_general**:
  - **english**: General
  - **translated**: Umum

- **com_nav_setting_beta**:
  - **english**: Beta features
  - **translated**: Fitur beta

- **com_nav_setting_data**:
  - **english**: Data controls
  - **translated**: Kontrol data

- **com_nav_setting_account**:
  - **english**: Account
  - **translated**: Akun

- **com_nav_language**:
  - **english**: Language
  - **translated**: Bahasa

- **com_nav_lang_auto**:
  - **english**: Auto detect
  - **translated**: Deteksi otomatis

- **com_nav_lang_english**:
  - **english**: English
  - **translated**: English

- **com_nav_lang_chinese**:
  - **english**: 中文
  - **translated**: 中文

- **com_nav_lang_german**:
  - **english**: Deutsch
  - **translated**: Deutsch

- **com_nav_lang_spanish**:
  - **english**: Español
  - **translated**: Español

- **com_nav_lang_french**:
  - **english**: Français 
  - **translated**: Français 

- **com_nav_lang_italian**:
  - **english**: Italiano
  - **translated**: Italiano

- **com_nav_lang_polish**:
  - **english**: Polski
  - **translated**: Polski

- **com_nav_lang_brazilian_portuguese**:
  - **english**: Português Brasileiro
  - **translated**: Português Brasileiro

- **com_nav_lang_russian**:
  - **english**: Русский
  - **translated**: Русский

- **com_nav_lang_japanese**:
  - **english**: 日本語
  - **translated**: 日本語

- **com_nav_lang_swedish**:
  - **english**: Svenska
  - **translated**: Svenska

- **com_nav_lang_korean**:
  - **english**: 한국어
  - **translated**: 한국어

- **com_nav_lang_vietnamese**:
  - **english**: Tiếng Việt
  - **translated**: Tiếng Việt

- **com_nav_lang_traditionalchinese**:
  - **english**: 繁體中文
  - **translated**: 繁體中文

- **com_nav_lang_arabic**:
  - **english**: العربية
  - **translated**: العربية

- **com_nav_lang_turkish**:
  - **english**: Türkçe
  - **translated**: Türkçe

- **com_nav_lang_dutch**:
  - **english**: Nederlands
  - **translated**: Nederlands

- **com_nav_lang_indonesia**:
  - **english**: Indonesia
  - **translated**: Indonesia

Please consider the above comparisons to enhance understanding and guide improvements in translations.

Provide insights or suggestions that could help refine the translation process, focusing on cultural and contextual relevance.

Please craft a prompt that can be used to better inform future translations to this language.

Write this prompt in the translated language, with all its nuances detected, not in the English.
