# Instructions for Translation

Write a prompt that is mindful of the nuances in the language with respect to its English counterpart, which serves as the baseline for translations. Here are the comparisons between the language translations and their English counterparts:


- **com_sidepanel_select_assistant**:
  - **english**: Select an Assistant
  - **translated**: בחר סייען

- **com_sidepanel_assistant_builder**:
  - **english**: Assistant Builder
  - **translated**: בניית סייען

- **com_sidepanel_attach_files**:
  - **english**: Attach Files
  - **translated**: צרף קבצים

- **com_assistants_knowledge**:
  - **english**: Knowledge
  - **translated**: ידע

- **com_assistants_knowledge_info**:
  - **english**: If you upload files under Knowledge, conversations with your Assistant may include file contents.
  - **translated**: אם אתה מעלה קבצים תחת ידע, שיחות עם ה-סייען שלך עשויות לכלול תוכן מהקובץ.

- **com_assistants_knowledge_disabled**:
  - **english**: Assistant must be created, and Code Interpreter or Retrieval must be enabled and saved before uploading files as Knowledge.
  - **translated**: יש ליצור סייען, ויש להפעיל ולשמור את מתורגמן קוד או אחזור לפני העלאת קבצים כ-ידע.

- **com_assistants_code_interpreter**:
  - **english**: Code Interpreter
  - **translated**: מתורגמן קוד

- **com_assistants_code_interpreter_files**:
  - **english**: The following files are only available for Code Interpreter:
  - **translated**: הקבצים הבאים זמינים רק עבור מתורגמן קוד:

- **com_assistants_retrieval**:
  - **english**: Retrieval
  - **translated**: אחזור

- **com_assistants_add_tools**:
  - **english**: Add Tools
  - **translated**: הוסף כלים

- **com_assistants_add_actions**:
  - **english**: Add Actions
  - **translated**: הוסף פעולות

- **com_assistants_name_placeholder**:
  - **english**: Optional: The name of the assistant
  - **translated**: אופציונלי: שם הסייען

- **com_assistants_instructions_placeholder**:
  - **english**: The system instructions that the assistant uses
  - **translated**: הוראות המערכת שהסייען משתמש בהן

- **com_assistants_description_placeholder**:
  - **english**: Optional: Describe your Assistant here
  - **translated**: אופציונלי: תאר את ה-סייען שלך כאן

- **com_assistants_actions_disabled**:
  - **english**: You need to create an assistant before adding actions.
  - **translated**: עליך ליצור סייען לפני הוספת פעולות.

- **com_assistants_update_success**:
  - **english**: Successfully updated
  - **translated**: עודכן בהצלחה

- **com_assistants_update_error**:
  - **english**: There was an error updating your assistant.
  - **translated**: אירעה שגיאה בעדכון הסייען שלך.

- **com_assistants_create_success**:
  - **english**: Successfully created
  - **translated**: נוצר בהצלחה

- **com_assistants_create_error**:
  - **english**: There was an error creating your assistant.
  - **translated**: אירעה שגיאה ביצירת הסייען שלך.

- **com_ui_attach_error_type**:
  - **english**: Unsupported file type for endpoint:
  - **translated**: סוג קובץ לא נתמך עבור נקודת קצה:

- **com_ui_attach_error_size**:
  - **english**: File size limit exceeded for endpoint:
  - **translated**: חרגת ממגבלת גודל הקובץ עבור נקודת הקצה:

- **com_ui_attach_error**:
  - **english**: Cannot attach file. Create or select a conversation, or try refreshing the page.
  - **translated**: לא ניתן לצרף קובץ. צור או בחר שיחה, או נסה לרענן את הדף.

- **com_ui_examples**:
  - **english**: Examples
  - **translated**: דוגמאות

- **com_ui_new_chat**:
  - **english**: New chat
  - **translated**: שיחה חדשה

- **com_ui_happy_birthday**:
  - **english**: It's my 1st birthday!
  - **translated**: זה יום ההולדת הראשון שלי!

- **com_ui_example_quantum_computing**:
  - **english**: Explain quantum computing in simple terms
  - **translated**: הסבר מחשוב קוונטי במונחים פשוטים

- **com_ui_example_10_year_old_b_day**:
  - **english**: Got any creative ideas for a 10 year old's birthday?
  - **translated**: יש לך רעיונות יצירתיים ליום הולדת של ילד בן 10?

- **com_ui_example_http_in_js**:
  - **english**: How do I make an HTTP request in Javascript?
  - **translated**: כיצד אוכל לבצע בקשת HTTP ב-Javascript?

- **com_ui_capabilities**:
  - **english**: Capabilities
  - **translated**: יכולות

- **com_ui_capability_remember**:
  - **english**: Remembers what user said earlier in the conversation
  - **translated**: זוכר את מה שהמשתמש אמר קודם בשיחה

- **com_ui_capability_correction**:
  - **english**: Allows user to provide follow-up corrections
  - **translated**: מאפשר למשתמש לספק תיקוני המשך

- **com_ui_capability_decline_requests**:
  - **english**: Trained to decline inappropriate requests
  - **translated**: אומן לדחות בקשות בלתי הולמות

- **com_ui_limitations**:
  - **english**: Limitations
  - **translated**: הגבלות

- **com_ui_limitation_incorrect_info**:
  - **english**: May occasionally generate incorrect information
  - **translated**: עשוי מדי פעם ליצור מידע שגוי

- **com_ui_limitation_harmful_biased**:
  - **english**: May occasionally produce harmful instructions or biased content
  - **translated**: עלול לייצר מדי פעם הוראות מזיקות או תוכן מוטה

- **com_ui_limitation_limited_2021**:
  - **english**: Limited knowledge of world and events after 2021
  - **translated**: ידע מוגבל על העולם והאירועים אחרי 2021

- **com_ui_experimental**:
  - **english**: Experimental Features
  - **translated**: מאפיינים ניסיוניים

- **com_ui_name**:
  - **english**: Name
  - **translated**: שם

- **com_ui_instructions**:
  - **english**: Instructions
  - **translated**: הוראות

- **com_ui_description**:
  - **english**: Description
  - **translated**: תיאור

- **com_ui_error**:
  - **english**: Error
  - **translated**: שגיאה

- **com_ui_select**:
  - **english**: Select
  - **translated**: בחר

- **com_ui_input**:
  - **english**: Input
  - **translated**: קלט

- **com_ui_close**:
  - **english**: Close
  - **translated**: סגור

- **com_ui_model**:
  - **english**: Model
  - **translated**: דגם

- **com_ui_select_model**:
  - **english**: Select a model
  - **translated**: בחר דגם

- **com_ui_use_prompt**:
  - **english**: Use prompt
  - **translated**: השתמש בהודעת

- **com_ui_prev**:
  - **english**: Prev
  - **translated**: הקודם

- **com_ui_next**:
  - **english**: Next
  - **translated**: הבא

- **com_ui_stop**:
  - **english**: Stop
  - **translated**: עצור

- **com_ui_upload_files**:
  - **english**: Upload files
  - **translated**: העלה קבצים

- **com_ui_prompt_templates**:
  - **english**: Prompt Templates
  - **translated**: תבניות בקשה

- **com_ui_hide_prompt_templates**:
  - **english**: Hide Prompt Templates
  - **translated**: הסתר תבניות הנחיות

- **com_ui_showing**:
  - **english**: Showing
  - **translated**: מציג

- **com_ui_of**:
  - **english**: of
  - **translated**: של

- **com_ui_entries**:
  - **english**: Entries
  - **translated**: ערכים

- **com_ui_pay_per_call**:
  - **english**: All AI conversations in one place. Pay per call and not per month
  - **translated**: כל שיחות הבינה המלאכותית במקום אחד. שלם לפי שיחה ולא לחודש

- **com_ui_new_footer**:
  - **english**: All AI conversations in one place.
  - **translated**: כל שיחות הבינה המלאכותית במקום אחד.

- **com_ui_enter**:
  - **english**: Enter
  - **translated**: Enter

- **com_ui_submit**:
  - **english**: Submit
  - **translated**: שלח

- **com_ui_upload_success**:
  - **english**: Successfully uploaded file
  - **translated**: קובץ שהועלה בהצלחה

- **com_ui_upload_error**:
  - **english**: There was an error uploading your file
  - **translated**: אירעה שגיאה בהעלאת הקובץ שלך

- **com_ui_upload_invalid**:
  - **english**: Invalid file for upload. Must be an image not exceeding 2 MB
  - **translated**: קובץ לא חוקי להעלאה. חייבת להיות תמונה שגודלה לא עולה על 2 MB

- **com_ui_cancel**:
  - **english**: Cancel
  - **translated**: בטל

- **com_ui_save**:
  - **english**: Save
  - **translated**: שמור

- **com_ui_save_submit**:
  - **english**: Save & Submit
  - **translated**: שמור ושלח

- **com_user_message**:
  - **english**: You
  - **translated**: אתה

- **com_ui_copy_to_clipboard**:
  - **english**: Copy to clipboard
  - **translated**: העתק ללוח

- **com_ui_copied_to_clipboard**:
  - **english**: Copied to clipboard
  - **translated**: הועתק ללוח

- **com_ui_regenerate**:
  - **english**: Regenerate
  - **translated**: לחדש

- **com_ui_continue**:
  - **english**: Continue
  - **translated**: המשך

- **com_ui_edit**:
  - **english**: Edit
  - **translated**: ערוך

- **com_ui_success**:
  - **english**: Success
  - **translated**: הצלחה

- **com_ui_all**:
  - **english**: all
  - **translated**: הכל

- **com_ui_clear**:
  - **english**: Clear
  - **translated**: נקה

- **com_ui_revoke**:
  - **english**: Revoke
  - **translated**: בטל

- **com_ui_revoke_info**:
  - **english**: Revoke all user provided credentials
  - **translated**: בטל את כל האישורים שסופקו על ידי המשתמש

- **com_ui_import_conversation**:
  - **english**: Import
  - **translated**: יבוא

- **com_ui_import_conversation_info**:
  - **english**: Import conversations from a JSON file
  - **translated**: ייבא שיחות מקובץ JSON

- **com_ui_import_conversation_success**:
  - **english**: Conversations imported successfully
  - **translated**: השיחות יובאו בהצלחה

- **com_ui_import_conversation_error**:
  - **english**: There was an error importing your conversations
  - **translated**: אירעה שגיאה בעת ייבוא השיחות שלך

- **com_ui_confirm_action**:
  - **english**: Confirm Action
  - **translated**: אשר פעולה

- **com_ui_chats**:
  - **english**: chats
  - **translated**: צאטים

- **com_ui_assistant**:
  - **english**: Assistant
  - **translated**: סייען

- **com_ui_delete**:
  - **english**: Delete
  - **translated**: מחק

- **com_ui_create**:
  - **english**: Create
  - **translated**: צור

- **com_ui_delete_conversation**:
  - **english**: Delete chat?
  - **translated**: למחוק את השיחה (צאט)?

- **com_ui_delete_confirm**:
  - **english**: This will delete
  - **translated**: זה ימחק

- **com_ui_delete_assistant_confirm**:
  - **english**: Are you sure you want to delete this Assistant? This cannot be undone.
  - **translated**: האם אתה בטוח שאתה רוצה למחוק את הסייען הזה? אי אפשר לבטל את זה.

- **com_ui_rename**:
  - **english**: Rename
  - **translated**: שם מחדש

- **com_ui_archive**:
  - **english**: Archive
  - **translated**: ארכיון

- **com_ui_archive_error**:
  - **english**: Failed to archive conversation
  - **translated**: אירעה שגיאה בארכיון השיחה

- **com_ui_unarchive**:
  - **english**: Unarchive
  - **translated**: לארכיון

- **com_ui_unarchive_error**:
  - **english**: Failed to unarchive conversation
  - **translated**: אירעה שגיאה בארכיון השיחה

- **com_ui_more_options**:
  - **english**: More
  - **translated**: עוד

- **com_ui_upload**:
  - **english**: Upload
  - **translated**: העלה

- **com_ui_connect**:
  - **english**: Connect
  - **translated**: התחבר

- **com_auth_error_login**:
  - **english**: Unable to login with the information provided. Please check your credentials and try again.
  - **translated**: לא ניתן להתחבר עם המידע שסופק. אנא בדוק את האישורים שלך ונסה שוב.

- **com_auth_error_login_rl**:
  - **english**: Too many login attempts in a short amount of time. Please try again later.
  - **translated**: יותר מדי ניסיונות כניסה בזמן קצר. בבקשה נסה שוב מאוחר יותר.

- **com_auth_error_login_ban**:
  - **english**: Your account has been temporarily banned due to violations of our service.
  - **translated**: החשבון שלך נחסם באופן זמני עקב הפרות של השירות שלנו.

- **com_auth_error_login_server**:
  - **english**: There was an internal server error. Please wait a few moments and try again.
  - **translated**: הייתה שגיאת שרת פנימית. אנא המתן מספר רגעים ונסה שוב.

- **com_auth_no_account**:
  - **english**: Don't have an account?
  - **translated**: אין לך חשבון?

- **com_auth_sign_up**:
  - **english**: Sign up
  - **translated**: הירשם

- **com_auth_sign_in**:
  - **english**: Sign in
  - **translated**: כניסה

- **com_auth_google_login**:
  - **english**: Continue with Google
  - **translated**: המשך עם Google

- **com_auth_facebook_login**:
  - **english**: Continue with Facebook
  - **translated**: המשך עם פייסבוק

- **com_auth_github_login**:
  - **english**: Continue with Github
  - **translated**: המשך עם Github

- **com_auth_discord_login**:
  - **english**: Continue with Discord
  - **translated**: המשך עם Discord

- **com_auth_email**:
  - **english**: Email
  - **translated**: אימייל (דוא"ל)

- **com_auth_email_required**:
  - **english**: Email is required
  - **translated**: נדרש דוא"ל

- **com_auth_email_min_length**:
  - **english**: Email must be at least 6 characters
  - **translated**: אימייל (דוא"ל) חייב להיות בן 6 תווים לפחות

- **com_auth_email_max_length**:
  - **english**: Email should not be longer than 120 characters
  - **translated**: אימייל (דוא"ל) לא יכול להיות ארוך מ-120 תווים

- **com_auth_email_pattern**:
  - **english**: You must enter a valid email address
  - **translated**: עליך להזין כתובת אימייל (דוא"ל) חוקית

- **com_auth_email_address**:
  - **english**: Email address
  - **translated**: כתובת דואר אלקטרוני

- **com_auth_password**:
  - **english**: Password
  - **translated**: סיסמה

- **com_auth_password_required**:
  - **english**: Password is required
  - **translated**: נדרשת סיסמה

- **com_auth_password_min_length**:
  - **english**: Password must be at least 8 characters
  - **translated**: הסיסמה חייבת להיות בת 8 תווים לפחות

- **com_auth_password_max_length**:
  - **english**: Password must be less than 128 characters
  - **translated**: הסיסמה חייבת להיות פחות מ-128 תווים

- **com_auth_password_forgot**:
  - **english**: Forgot Password?
  - **translated**: שכחת את הסיסמה?

- **com_auth_password_confirm**:
  - **english**: Confirm password
  - **translated**: אשר סיסמה

- **com_auth_password_not_match**:
  - **english**: Passwords do not match
  - **translated**: הסיסמאות אינן תואמות

- **com_auth_continue**:
  - **english**: Continue
  - **translated**: המשך

- **com_auth_create_account**:
  - **english**: Create your account
  - **translated**: צור את החשבון שלך

- **com_auth_error_create**:
  - **english**: There was an error attempting to register your account. Please try again.
  - **translated**: אירעה שגיאה בניסיון לרשום את החשבון שלך. בבקשה נסה שוב.

- **com_auth_full_name**:
  - **english**: Full name
  - **translated**: שם מלא

- **com_auth_name_required**:
  - **english**: Name is required
  - **translated**: נדרש שם

- **com_auth_name_min_length**:
  - **english**: Name must be at least 3 characters
  - **translated**: השם חייב להיות לפחות 3 תווים

- **com_auth_name_max_length**:
  - **english**: Name must be less than 80 characters
  - **translated**: השם חייב להיות פחות מ-80 תווים

- **com_auth_username**:
  - **english**: Username (optional)
  - **translated**: שם משתמש (אופציונלי)

- **com_auth_username_required**:
  - **english**: Username is required
  - **translated**: נדרש שם משתמש

- **com_auth_username_min_length**:
  - **english**: Username must be at least 2 characters
  - **translated**: שם משתמש חייב להיות לפחות 2 תווים

- **com_auth_username_max_length**:
  - **english**: Username must be less than 20 characters
  - **translated**: שם המשתמש חייב להיות פחות מ-20 תווים

- **com_auth_already_have_account**:
  - **english**: Already have an account?
  - **translated**: כבר יש לך חשבון?

- **com_auth_login**:
  - **english**: Login
  - **translated**: התחבר

- **com_auth_reset_password**:
  - **english**: Reset your password
  - **translated**: אפס את הסיסמה שלך

- **com_auth_click**:
  - **english**: Click
  - **translated**: קליק

- **com_auth_here**:
  - **english**: HERE
  - **translated**: כאן

- **com_auth_to_reset_your_password**:
  - **english**: to reset your password.
  - **translated**: כדי לאפס את הסיסמה שלך.

- **com_auth_reset_password_link_sent**:
  - **english**: Email Sent
  - **translated**: אימייל (דוא"ל) נשלח

- **com_auth_reset_password_email_sent**:
  - **english**: An email has been sent to you with further instructions to reset your password.
  - **translated**: נשלח אליך הודעת דוא"ל עם הנחיות נוספות לאיפוס הסיסמה שלך.

- **com_auth_error_reset_password**:
  - **english**: There was a problem resetting your password. There was no user found with the email address provided. Please try again.
  - **translated**: הייתה בעיה באיפוס הסיסמה שלך. לא נמצא משתמש עם כתובת האימייל (דוא"ל) שסופקה. בבקשה נסה שוב.

- **com_auth_reset_password_success**:
  - **english**: Password Reset Success
  - **translated**: איפוס סיסמה הצליח

- **com_auth_login_with_new_password**:
  - **english**: You may now login with your new password.
  - **translated**: עכשיו אתה יכול להתחבר עם הסיסמה החדשה שלך.

- **com_auth_error_invalid_reset_token**:
  - **english**: This password reset token is no longer valid.
  - **translated**: אסימון איפוס הסיסמה הזה אינו תקף עוד.

- **com_auth_click_here**:
  - **english**: Click here
  - **translated**: לחץ כאן

- **com_auth_to_try_again**:
  - **english**: to try again.
  - **translated**: כדי לנסות שוב.

- **com_auth_submit_registration**:
  - **english**: Submit registration
  - **translated**: שלח רישום

- **com_auth_welcome_back**:
  - **english**: Welcome back
  - **translated**: ברוכים הבאים

- **com_auth_back_to_login**:
  - **english**: Back to Login
  - **translated**: חזרה לכניסה

- **com_endpoint_open_menu**:
  - **english**: Open Menu
  - **translated**: תפריט פתח

- **com_endpoint_bing_enable_sydney**:
  - **english**: Enable Sydney
  - **translated**: אפשר את סידני

- **com_endpoint_bing_to_enable_sydney**:
  - **english**: To enable Sydney
  - **translated**: כדי לאפשר את סידני

- **com_endpoint_bing_jailbreak**:
  - **english**: Jailbreak
  - **translated**: Jailbreak

- **com_endpoint_bing_context_placeholder**:
  - **english**: Bing can use up to 7k tokens for 'context', which it can reference for the conversation. The specific limit is not known but may run into errors exceeding 7k tokens
  - **translated**: בינג יכול להשתמש בעד 7,000 אסימונים עבור 'הקשר', שאליהם הוא יכול להתייחס לשיחה. המגבלה הספציפית אינה ידועה אך עשויה להיתקל בשגיאות העולות על 7,000 אסימונים

- **com_endpoint_bing_system_message_placeholder**:
  - **english**: WARNING: Misuse of this feature can get you BANNED from using Bing! Click on 'System Message' for full instructions and the default message if omitted, which is the 'Sydney' preset that is considered safe.
  - **translated**: אזהרה: שימוש לרעה בתכונה זו יכול לגרום לך לאסור להשתמש ב-Bing! לחץ על 'הודעת מערכת' לקבלת הוראות מלאות והודעת ברירת המחדל אם הושמטה, שהיא הקביעה המוגדרת מראש של 'Sydney' שנחשבת בטוחה.

- **com_endpoint_system_message**:
  - **english**: System Message
  - **translated**: הודעת מערכת

- **com_endpoint_message**:
  - **english**: Message
  - **translated**: הודעה

- **com_endpoint_message_not_appendable**:
  - **english**: Edit your message or Regenerate.
  - **translated**: ערוך את ההודעה שלך או צור מחדש.

- **com_endpoint_default_blank**:
  - **english**: default: blank
  - **translated**: ברירת מחדל: ריק

- **com_endpoint_default_false**:
  - **english**: default: false
  - **translated**: ברירת מחדל: false

- **com_endpoint_default_creative**:
  - **english**: default: creative
  - **translated**: ברירת מחדל: יצירתי

- **com_endpoint_default_empty**:
  - **english**: default: empty
  - **translated**: ברירת מחדל: ריקה

- **com_endpoint_default_with_num**:
  - **english**: default: {0}
  - **translated**: ברירת מחדל: {0}

- **com_endpoint_context**:
  - **english**: Context
  - **translated**: הקשר

- **com_endpoint_tone_style**:
  - **english**: Tone Style
  - **translated**: סגנון טון

- **com_endpoint_token_count**:
  - **english**: Token count
  - **translated**: ספירת אסימונים

- **com_endpoint_output**:
  - **english**: Output
  - **translated**: פלט

- **com_endpoint_google_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: ערכים גבוהים יותר = יותר אקראיים, בעוד שערכים נמוכים יותר = יותר ממוקד ודטרמיניסטי. אנו ממליצים לשנות את זה או את Top P אבל לא את שניהם.

- **com_endpoint_google_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p משנה את האופן שבו המודל בוחר אסימונים לפלט. אסימונים נבחרים מרוב K (ראה פרמטר topK) ככל הנראה לפחות עד ה-sum של ההסתברויות שלהם שווה לערך ה-p העליון.

- **com_endpoint_google_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k משנה את האופן שבו המודל בוחר אסימונים לפלט. Top-k של 1 פירושו שהאסימון שנבחר הוא הסביר ביותר מבין כל האסימונים באוצר המילים של הדגם (נקרא גם פענוח חמדן), בעוד ש-top-k של 3 פירושו שהאסימון הבא נבחר מבין 3 הכי הרבה. אסימונים סבירים (באמצעות טמפרטורה).

- **com_endpoint_google_maxoutputtokens**:
  - **english**:  	Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**:  המספר המרבי של אסימונים שניתן להפיק בתגובה. ציין ערך נמוך יותר עבור תגובות קצרות יותר וערך גבוה יותר עבור תגובות ארוכות יותר.

- **com_endpoint_google_custom_name_placeholder**:
  - **english**: Set a custom name for Google
  - **translated**: הגדר שם מותאם אישית עבור Google

- **com_endpoint_prompt_prefix_placeholder**:
  - **english**: Set custom instructions or context. Ignored if empty.
  - **translated**: הגדר הוראות מותאמות אישית או הקשר. התעלמו אם ריק.

- **com_endpoint_instructions_assistants_placeholder**:
  - **english**: Overrides the instructions of the assistant. This is useful for modifying the behavior on a per-run basis.
  - **translated**: עובר את הוראות הסייען. זה שימושי לשינוי ההתנהגות על בסיס ריצה.

- **com_endpoint_prompt_prefix_assistants_placeholder**:
  - **english**: Set additional instructions or context on top of the Assistant's main instructions. Ignored if empty.
  - **translated**: הגדר הוראות נוספות או הקשר על גבי ההנחיות הראשיות של ה-סייען. התעלמו אם ריק.

- **com_endpoint_custom_name**:
  - **english**: Custom Name
  - **translated**: שם מותאם אישית

- **com_endpoint_prompt_prefix**:
  - **english**: Custom Instructions
  - **translated**: הוראות מותאמות אישית

- **com_endpoint_prompt_prefix_assistants**:
  - **english**: Additional Instructions
  - **translated**: הוראות נוספות

- **com_endpoint_instructions_assistants**:
  - **english**: Override Instructions
  - **translated**: עקוף הוראות

- **com_endpoint_temperature**:
  - **english**: Temperature
  - **translated**: טמפרטורה

- **com_endpoint_default**:
  - **english**: default
  - **translated**: default

- **com_endpoint_top_p**:
  - **english**: Top P
  - **translated**: Top P

- **com_endpoint_top_k**:
  - **english**: Top K
  - **translated**: Top K

- **com_endpoint_max_output_tokens**:
  - **english**: Max Output Tokens
  - **translated**: אסימוני פלט מרבי

- **com_endpoint_openai_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: ערכים גבוהים יותר = יותר אקראיים, בעוד שערכים נמוכים יותר = יותר ממוקד ודטרמיניסטי. אנו ממליצים לשנות את זה או את Top P אבל לא את שניהם.

- **com_endpoint_openai_max**:
  - **english**: The max tokens to generate. The total length of input tokens and generated tokens is limited by the model's context length.
  - **translated**: האסימונים המקסימליים להפיק. האורך הכולל של אסימוני קלט ואסימונים שנוצרו מוגבל על ידי אורך ההקשר של המודל.

- **com_endpoint_openai_topp**:
  - **english**: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We recommend altering this or temperature but not both.
  - **translated**: חלופה לדגימה עם טמפרטורה, הנקראת דגימת גרעין, שבה המודל מחשיב את תוצאות האסימונים עם מסת ההסתברות top_p. אז 0.1 אומר שרק האסימונים המהווים את מסת ההסתברות העליונה של 10% נחשבים. אנו ממליצים לשנות את זה או את הטמפרטורה אבל לא את שניהם.

- **com_endpoint_openai_freq**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
  - **translated**: מספר בין -2.0 ל-2.0. ערכים חיוביים מענישים אסימונים חדשים בהתבסס על התדירות הקיימת שלהם בטקסט עד כה, ומקטינים את הסבירות של המודל לחזור על אותה שורה מילה במילה.

- **com_endpoint_openai_pres**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
  - **translated**: מספר בין -2.0 ל-2.0. ערכים חיוביים מענישים אסימונים חדשים על סמך האם הם מופיעים בטקסט עד כה, ומגדילים את הסבירות של המודל לדבר על נושאים חדשים.

- **com_endpoint_openai_resend**:
  - **english**: Resend all previously attached images. Note: this can significantly increase token cost and you may experience errors with many image attachments.
  - **translated**: שלח שוב את כל התמונות שצורפו בעבר. הערה: זה יכול להגדיל משמעותית את עלות האסימונים ואתה עלול להיתקל בשגיאות עם קבצים מצורפים רבים של תמונות.

- **com_endpoint_openai_detail**:
  - **english**: The resolution for Vision requests. "Low" is cheaper and faster, "High" is more detailed and expensive, and "Auto" will automatically choose between the two based on the image resolution.
  - **translated**: ההחלטה לבקשות חזון. "נמוך" זול ומהיר יותר, "גבוה" מפורט ויקר יותר, ו"אוטומטי" יבחר אוטומטית בין השניים על סמך רזולוציית התמונה.

- **com_endpoint_openai_custom_name_placeholder**:
  - **english**: Set a custom name for the AI
  - **translated**: הגדר שם מותאם אישית עבור ChatGPT

- **com_endpoint_openai_prompt_prefix_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: הגדר הוראות מותאמות אישית לכלול בהודעת המערכת. ברירת מחדל: אין

- **com_endpoint_anthropic_temp**:
  - **english**: Ranges from 0 to 1. Use temp closer to 0 for analytical / multiple choice, and closer to 1 for creative and generative tasks. We recommend altering this or Top P but not both.
  - **translated**: נע בין 0 ל-1. השתמש בטמפ' הקרובה יותר ל-0 עבור בחירה אנליטית / מרובה, וקרוב יותר ל-1 עבור משימות יצירתיות ויצירתיות. אנו ממליצים לשנות את זה או את Top P אבל לא את שניהם.

- **com_endpoint_anthropic_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p משנה את האופן שבו המודל בוחר אסימונים לפלט. אסימונים נבחרים מבין רוב K (ראה פרמטר topK) הסביר לפחות עד שסכום ההסתברויות שלהם שווה לערך העליון-p.

- **com_endpoint_anthropic_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k משנה את האופן שבו המודל בוחר אסימונים לפלט. Top-k של 1 פירושו שהאסימון שנבחר הוא הסביר ביותר מבין כל האסימונים באוצר המילים של הדגם (נקרא גם פענוח חמדן), בעוד ש-top-k של 3 פירושו שהאסימון הבא נבחר מבין 3 הכי הרבה. אסימונים סבירים (באמצעות טמפרטורה).

- **com_endpoint_anthropic_maxoutputtokens**:
  - **english**: Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: מספר האסימונים המרבי שניתן להפיק בתגובה. ציין ערך נמוך יותר עבור תגובות קצרות יותר וערך גבוה יותר עבור תגובות ארוכות יותר.

- **com_endpoint_anthropic_custom_name_placeholder**:
  - **english**: Set a custom name for Anthropic
  - **translated**: הגדר שם מותאם אישית עבור Anthropic

- **com_endpoint_frequency_penalty**:
  - **english**: Frequency Penalty
  - **translated**: עונש תדירות

- **com_endpoint_presence_penalty**:
  - **english**: Presence Penalty
  - **translated**: עונש נוכחות

- **com_endpoint_plug_use_functions**:
  - **english**: Use Functions
  - **translated**: השתמש בפונקציות

- **com_endpoint_plug_resend_images**:
  - **english**: Resend Images
  - **translated**: שלח שוב תמונות

- **com_endpoint_plug_image_detail**:
  - **english**: Image Detail
  - **translated**: פרטי תמונה

- **com_endpoint_plug_skip_completion**:
  - **english**: Skip Completion
  - **translated**: השלמת דילוג

- **com_endpoint_disabled_with_tools**:
  - **english**: disabled with tools
  - **translated**: מושבת עם כלים

- **com_endpoint_disabled_with_tools_placeholder**:
  - **english**: Disabled with Tools Selected
  - **translated**: מושבת עם הכלים שנבחרו

- **com_endpoint_plug_set_custom_instructions_for_gpt_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: הגדר הוראות מותאמות אישית לכלול בהודעת המערכת. ברירת מחדל: אין

- **com_endpoint_set_custom_name**:
  - **english**: Set a custom name, in case you can find this preset
  - **translated**: הגדר שם מותאם אישית, למקרה שתוכל למצוא את הקביעה המוגדרת מראש

- **com_endpoint_preset_delete_confirm**:
  - **english**: Are you sure you want to delete this preset?
  - **translated**: האם אתה בטוח שברצונך למחוק את הקביעה המוגדרת מראש הזו?

- **com_endpoint_preset_clear_all_confirm**:
  - **english**: Are you sure you want to delete all of your presets?
  - **translated**: האם אתה בטוח שברצונך למחוק את כל הקביעות המוגדרות מראש שלך?

- **com_endpoint_preset_import**:
  - **english**: Preset Imported!
  - **translated**: הגדרה מראש מיובאת!

- **com_endpoint_preset_import_error**:
  - **english**: There was an error importing your preset. Please try again.
  - **translated**: אירעה שגיאה בייבוא הקביעה המוגדרת מראש שלך. בבקשה נסה שוב.

- **com_endpoint_preset_save_error**:
  - **english**: There was an error saving your preset. Please try again.
  - **translated**: אירעה שגיאה בשמירת ההגדרה מראש שלך. בבקשה נסה שוב.

- **com_endpoint_preset_delete_error**:
  - **english**: There was an error deleting your preset. Please try again.
  - **translated**: אירעה שגיאה במחיקת הקביעה המוגדרת מראש שלך. בבקשה נסה שוב.

- **com_endpoint_preset_default_removed**:
  - **english**: is no longer the default preset.
  - **translated**: איננו עוד ברירת המחדל המוגדרת מראש.

- **com_endpoint_preset_default_item**:
  - **english**: Default:
  - **translated**: ברירת מחדל:

- **com_endpoint_preset_default_none**:
  - **english**: No default preset active.
  - **translated**: אין ברירת מחדל פעילה.

- **com_endpoint_preset_title**:
  - **english**: Preset
  - **translated**: הגדרה מראש

- **com_endpoint_preset_saved**:
  - **english**: Saved!
  - **translated**: שמור!

- **com_endpoint_preset_default**:
  - **english**: is now the default preset.
  - **translated**: הוא כעת ברירת המחדל המוגדרת מראש.

- **com_endpoint_preset**:
  - **english**: preset
  - **translated**: preset

- **com_endpoint_presets**:
  - **english**: presets
  - **translated**: presets

- **com_endpoint_preset_selected**:
  - **english**: Preset Active!
  - **translated**: הגדרה מראש פעילה!

- **com_endpoint_preset_selected_title**:
  - **english**: Active!
  - **translated**: פעיל!

- **com_endpoint_preset_name**:
  - **english**: Preset Name
  - **translated**: שם מוגדר מראש

- **com_endpoint_new_topic**:
  - **english**: New Topic
  - **translated**: נושא חדש

- **com_endpoint**:
  - **english**: Endpoint
  - **translated**: נקודת קצה

- **com_endpoint_hide**:
  - **english**: Hide
  - **translated**: הסתר

- **com_endpoint_show**:
  - **english**: Show
  - **translated**: הצג

- **com_endpoint_examples**:
  - **english**:  Presets
  - **translated**: הגדרות קבועות מראש

- **com_endpoint_completion**:
  - **english**: Completion
  - **translated**: השלמה

- **com_endpoint_agent**:
  - **english**: Agent
  - **translated**: סוכן

- **com_endpoint_show_what_settings**:
  - **english**: Show {0} Settings
  - **translated**: הצג {0} הגדרות

- **com_endpoint_export**:
  - **english**: Export
  - **translated**: ייצוא

- **com_endpoint_assistant**:
  - **english**: Assistant
  - **translated**: סייען

- **com_endpoint_use_active_assistant**:
  - **english**: Use Active Assistant
  - **translated**: השתמש ב-סייען פעיל

- **com_endpoint_assistant_model**:
  - **english**: Assistant Model
  - **translated**: מודל סייען

- **com_endpoint_save_as_preset**:
  - **english**: Save As Preset
  - **translated**: שמור כ-preset

- **com_endpoint_presets_clear_warning**:
  - **english**: Are you sure you want to clear all presets? This is irreversible.
  - **translated**: האם אתה בטוח שאתה רוצה לנקות את כל הקביעות המוגדרות מראש? זה בלתי הפיך.

- **com_endpoint_not_implemented**:
  - **english**: Not implemented
  - **translated**: לא מיושם

- **com_endpoint_no_presets**:
  - **english**: No presets yet, use the settings button to create one
  - **translated**: אין עדיין הגדרות מוגדרות מראש, השתמש בלחצן ההגדרות כדי ליצור אחת

- **com_endpoint_not_available**:
  - **english**: No endpoint available
  - **translated**: אין נקודת קצה זמינה

- **com_endpoint_view_options**:
  - **english**: View Options
  - **translated**: אפשרויות תצוגה

- **com_endpoint_save_convo_as_preset**:
  - **english**: Save Conversation as Preset
  - **translated**: שמור שיחה כקביעה מראש

- **com_endpoint_my_preset**:
  - **english**: My Preset
  - **translated**: ההגדרה המוגדרת מראש שלי

- **com_endpoint_agent_model**:
  - **english**: Agent Model (Recommended: GPT-3.5)
  - **translated**: מודל סוכן (מומלץ: GPT-3.5)

- **com_endpoint_completion_model**:
  - **english**: Completion Model (Recommended: GPT-4)
  - **translated**: מודל השלמה (מומלץ: GPT-4)

- **com_endpoint_func_hover**:
  - **english**: Enable use of Plugins as OpenAI Functions
  - **translated**: אפשר שימוש בפלאגינים כפונקציות OpenAI

- **com_endpoint_skip_hover**:
  - **english**: Enable skipping the completion step, which reviews the final answer and generated steps
  - **translated**: אפשר דילוג על שלב ההשלמה, הסוקר את התשובה הסופית ואת השלבים שנוצרו

- **com_endpoint_config_key**:
  - **english**: Set API Key
  - **translated**: הגדר מפתח API

- **com_endpoint_config_placeholder**:
  - **english**: Set your Key in the Header menu to chat.
  - **translated**: הגדר את המפתח שלך בתפריט הכותרת לצאט.

- **com_endpoint_config_key_for**:
  - **english**: Set API Key for
  - **translated**: הגדר מפתח API עבור

- **com_endpoint_config_key_name**:
  - **english**: Key
  - **translated**: מפתח

- **com_endpoint_config_value**:
  - **english**: Enter value for
  - **translated**: הזן ערך עבור

- **com_endpoint_config_key_name_placeholder**:
  - **english**: Set API key first
  - **translated**: הגדר תחילה מפתח API

- **com_endpoint_config_key_encryption**:
  - **english**: Your key will be encrypted and deleted at
  - **translated**: המפתח שלך יוצפן וימחק ב

- **com_endpoint_config_key_expiry**:
  - **english**: the expiry time
  - **translated**: זמן התפוגה

- **com_endpoint_config_click_here**:
  - **english**: Click Here
  - **translated**: לחץ כאן

- **com_endpoint_config_google_service_key**:
  - **english**: Google Service Account Key
  - **translated**: מפתח חשבון שירות Google

- **com_endpoint_config_google_cloud_platform**:
  - **english**: (from Google Cloud Platform)
  - **translated**: (מ-Google Cloud Platform)

- **com_endpoint_config_google_api_key**:
  - **english**: Google API Key
  - **translated**: מפתח Google API

- **com_endpoint_config_google_gemini_api**:
  - **english**: (Gemini API)
  - **translated**: (Gemini API)

- **com_endpoint_config_google_api_info**:
  - **english**: To get your Generative Language API key (for Gemini),
  - **translated**: כדי לקבל את מפתח ה-API של Generative Language (עבור תאומים),

- **com_endpoint_config_key_import_json_key**:
  - **english**: Import Service Account JSON Key.
  - **translated**: ייבוא מפתח JSON של חשבון שירות.

- **com_endpoint_config_key_import_json_key_success**:
  - **english**: Successfully Imported Service Account JSON Key
  - **translated**: מפתח JSON של חשבון שירות יובא בהצלחה

- **com_endpoint_config_key_import_json_key_invalid**:
  - **english**: Invalid Service Account JSON Key, Did you import the correct file?
  - **translated**: מפתח JSON חשבון שירות לא חוקי, האם ייבאת את הקובץ הנכון?

- **com_endpoint_config_key_get_edge_key**:
  - **english**: To get your Access token for Bing, login to
  - **translated**: כדי לקבל את אסימון הגישה שלך ל-Bing, היכנס אל

- **com_endpoint_config_key_get_edge_key_dev_tool**:
  - **english**: Use dev tools or an extension while logged into the site to copy the content of the _U cookie. If this fails, follow these
  - **translated**: השתמש בכלי מפתחים או בתוסף בזמן שאתה מחובר לאתר כדי להעתיק את התוכן של קובץ ה-cookie _U. אם זה נכשל, עקוב אחר אלה

- **com_endpoint_config_key_edge_instructions**:
  - **english**: instructions
  - **translated**: הוראות

- **com_endpoint_config_key_edge_full_key_string**:
  - **english**: to provide the full cookie strings.
  - **translated**: כדי לספק את מחרוזות העוגיות המלאות.

- **com_endpoint_config_key_chatgpt**:
  - **english**: To get your Access token For ChatGPT 'Free Version', login to
  - **translated**: כדי לקבל את אסימון הגישה שלך ל-ChatGPT 'גרסה חינמית', היכנס אל

- **com_endpoint_config_key_chatgpt_then_visit**:
  - **english**: then visit
  - **translated**: ואז בקר

- **com_endpoint_config_key_chatgpt_copy_token**:
  - **english**: Copy access token.
  - **translated**: העתק אסימון גישה.

- **com_endpoint_config_key_google_need_to**:
  - **english**: You need to
  - **translated**: אתה צריך

- **com_endpoint_config_key_google_vertex_ai**:
  - **english**: Enable Vertex AI
  - **translated**: הפעל את Vertex AI

- **com_endpoint_config_key_google_vertex_api**:
  - **english**: API on Google Cloud, then
  - **translated**: API ב-Google Cloud, אז

- **com_endpoint_config_key_google_service_account**:
  - **english**: Create a Service Account
  - **translated**: צור חשבון שירות

- **com_endpoint_config_key_google_vertex_api_role**:
  - **english**: Make sure to click 'Create and Continue' to give at least the 'Vertex AI User' role. Lastly, create a JSON key to import here.
  - **translated**: הקפד ללחוץ על 'צור והמשך' כדי לתת לפחות את התפקיד 'Vertex AI User'. לבסוף, צור מפתח JSON לייבא לכאן.

- **com_nav_welcome_message**:
  - **english**: How can I help you today?
  - **translated**: איך אני יכול לעזור לך היום?

- **com_nav_auto_scroll**:
  - **english**: Auto-scroll to Newest on Open
  - **translated**: Auto-s גלול אל הכי חדש בפתיחה

- **com_nav_hide_panel**:
  - **english**: Hide Right-most Side Panel
  - **translated**: הסתר לוח הצד הימני ביותר

- **com_nav_modular_chat**:
  - **english**: Enable switching Endpoints mid-conversation
  - **translated**: אפשר החלפת נקודות קצה באמצע שיחה

- **com_nav_latex_parsing**:
  - **english**: Parsing LaTeX in messages (may affect performance)
  - **translated**: ניתוח LaTeX בהודעות (עשוי להשפיע על הביצועים)

- **com_nav_profile_picture**:
  - **english**: Profile Picture
  - **translated**: תמונת פרופיל

- **com_nav_change_picture**:
  - **english**: Change picture
  - **translated**: שנה תמונה

- **com_nav_plugin_store**:
  - **english**: Plugin store
  - **translated**: חנות פלאגין

- **com_nav_plugin_install**:
  - **english**: Install
  - **translated**: התקן

- **com_nav_plugin_uninstall**:
  - **english**: Uninstall
  - **translated**: הסר התקנה

- **com_ui_add**:
  - **english**: Add
  - **translated**: הוסף

- **com_nav_tool_remove**:
  - **english**: Remove
  - **translated**: הסר

- **com_nav_tool_dialog**:
  - **english**: Assistant Tools
  - **translated**: כלי סייען

- **com_nav_tool_dialog_description**:
  - **english**: Assistant must be saved to persist tool selections.
  - **translated**: יש לשמור את האסיסטנט כדי להמשיך בבחירת הכלים.

- **com_show_agent_settings**:
  - **english**: Show Agent Settings
  - **translated**: הצג הגדרות סוכן

- **com_show_completion_settings**:
  - **english**: Show Completion Settings
  - **translated**: הצג הגדרות השלמה

- **com_hide_examples**:
  - **english**: Hide Examples
  - **translated**: הסתר דוגמאות

- **com_show_examples**:
  - **english**: Show Examples
  - **translated**: הצג דוגמאות

- **com_nav_plugin_search**:
  - **english**: Search plugins
  - **translated**: תוספי חיפוש

- **com_nav_tool_search**:
  - **english**: Search tools
  - **translated**: כלי חיפוש

- **com_nav_plugin_auth_error**:
  - **english**: There was an error attempting to authenticate this plugin. Please try again.
  - **translated**: אירעה שגיאה בניסיון לאמת את הפלאגין הזה. בבקשה נסה שוב.

- **com_nav_export_filename**:
  - **english**: Filename
  - **translated**: שם קובץ

- **com_nav_export_filename_placeholder**:
  - **english**: Set the filename
  - **translated**: הגדר את שם הקובץ

- **com_nav_export_type**:
  - **english**: Type
  - **translated**: סוג

- **com_nav_export_include_endpoint_options**:
  - **english**: Include endpoint options
  - **translated**: כלול אפשרויות נקודת קצה

- **com_nav_enabled**:
  - **english**: Enabled
  - **translated**: מופעל

- **com_nav_not_supported**:
  - **english**: Not Supported
  - **translated**: לא נתמך

- **com_nav_export_all_message_branches**:
  - **english**: Export all message branches
  - **translated**: ייצא את כל ענפי ההודעות

- **com_nav_export_recursive_or_sequential**:
  - **english**: Recursive or sequential?
  - **translated**: רקורסיבי או רציף?

- **com_nav_export_recursive**:
  - **english**: Recursive
  - **translated**: רקורסיבי

- **com_nav_export_conversation**:
  - **english**: Export conversation
  - **translated**: ייצא שיחה

- **com_nav_theme**:
  - **english**: Theme
  - **translated**: נושא

- **com_nav_theme_system**:
  - **english**: System
  - **translated**: מערכת

- **com_nav_theme_dark**:
  - **english**: Dark
  - **translated**: כהה

- **com_nav_theme_light**:
  - **english**: Light
  - **translated**: אור

- **com_nav_user_name_display**:
  - **english**: Display username in messages
  - **translated**: הצג שם משתמש בהודעות

- **com_nav_clear_all_chats**:
  - **english**: Clear all chats
  - **translated**: נקה את כל השיחות

- **com_nav_confirm_clear**:
  - **english**: Confirm Clear
  - **translated**: אשר נקה

- **com_nav_close_sidebar**:
  - **english**: Close sidebar
  - **translated**: סגור סרגל צד

- **com_nav_open_sidebar**:
  - **english**: Open sidebar
  - **translated**: פתח סרגל צד

- **com_nav_send_message**:
  - **english**: Send message
  - **translated**: שלח הודעה

- **com_nav_log_out**:
  - **english**: Log out
  - **translated**: צא

- **com_nav_user**:
  - **english**: USER
  - **translated**: USER

- **com_nav_archived_chats**:
  - **english**: Archived chats
  - **translated**: שיחות מארכיון

- **com_nav_archived_chats_manage**:
  - **english**: Manage
  - **translated**: ניהול

- **com_nav_archived_chats_empty**:
  - **english**: You have no archived conversations.
  - **translated**: אין שיחות מארכיון.

- **com_nav_archive_all_chats**:
  - **english**: Archive all chats
  - **translated**: ארכין כל השיחות

- **com_nav_archive_all**:
  - **english**: Archive all
  - **translated**: ארכין כל

- **com_nav_archive_name**:
  - **english**: Name
  - **translated**: שם

- **com_nav_archive_created_at**:
  - **english**: DateCreated
  - **translated**: תאריך יצרן

- **com_nav_clear_conversation**:
  - **english**: Clear conversations
  - **translated**: נקה שיחות

- **com_nav_clear_conversation_confirm_message**:
  - **english**: Are you sure you want to clear all conversations? This is irreversible.
  - **translated**: אתה בטוח שאתה רוצה לנקות את כל השיחות? זה בלתי הפיך.

- **com_nav_help_faq**:
  - **english**: Help & FAQ
  - **translated**: עזרה ושאלות נפוצות

- **com_nav_settings**:
  - **english**: Settings
  - **translated**: הגדרות

- **com_nav_search_placeholder**:
  - **english**: Search messages
  - **translated**: חפש הודעות

- **com_nav_setting_general**:
  - **english**: General
  - **translated**: כללי

- **com_nav_setting_beta**:
  - **english**: Beta features
  - **translated**: תכונות ביטא

- **com_nav_setting_data**:
  - **english**: Data controls
  - **translated**: בקרות נתונים

- **com_nav_setting_account**:
  - **english**: Account
  - **translated**: חשבון

Please consider the above comparisons to enhance understanding and guide improvements in translations.

Provide insights or suggestions that could help refine the translation process, focusing on cultural and contextual relevance.

Please craft a prompt that can be used to better inform future translations to this language.

Write this prompt in the translated language, with all its nuances detected, not in the English.
