# Instructions for Translation

Write a prompt that is mindful of the nuances in the language with respect to its English counterpart, which serves as the baseline for translations. Here are the comparisons between the language translations and their English counterparts:


- **com_ui_examples**:
  - **english**: Examples
  - **translated**: Exemples

- **com_ui_new_chat**:
  - **english**: New chat
  - **translated**: Nouvelle conversation

- **com_ui_happy_birthday**:
  - **english**: It's my 1st birthday!
  - **translated**: C'est mon premier anniversaire !

- **com_ui_example_quantum_computing**:
  - **english**: Explain quantum computing in simple terms
  - **translated**: Expliquer l'informatique quantique en termes simples

- **com_ui_example_10_year_old_b_day**:
  - **english**: Got any creative ideas for a 10 year old's birthday?
  - **translated**: Tu as des idées créatives pour l'anniversaire d'un enfant de 10 ans ?

- **com_ui_example_http_in_js**:
  - **english**: How do I make an HTTP request in Javascript?
  - **translated**: Comment faire une requête HTTP en Javascript ?

- **com_ui_capabilities**:
  - **english**: Capabilities
  - **translated**: Capacités

- **com_ui_capability_remember**:
  - **english**: Remembers what user said earlier in the conversation
  - **translated**: Se souvient de ce que l'utilisateur a dit plus tôt dans la conversation

- **com_ui_capability_correction**:
  - **english**: Allows user to provide follow-up corrections
  - **translated**: Permet à l'utilisateur de fournir des corrections de suivi

- **com_ui_capability_decline_requests**:
  - **english**: Trained to decline inappropriate requests
  - **translated**: Formé à refuser les demandes inappropriées

- **com_ui_limitations**:
  - **english**: Limitations
  - **translated**: Limitations

- **com_ui_limitation_incorrect_info**:
  - **english**: May occasionally generate incorrect information
  - **translated**: Peut occasionnellement générer des informations incorrectes

- **com_ui_limitation_harmful_biased**:
  - **english**: May occasionally produce harmful instructions or biased content
  - **translated**: Peut occasionnellement produire des instructions nuisibles ou du contenu biaisé

- **com_ui_limitation_limited_2021**:
  - **english**: Limited knowledge of world and events after 2021
  - **translated**: Connaissance limitée du monde et des événements après 2021

- **com_ui_experimental**:
  - **english**: Experimental Features
  - **translated**: Fonctionnalités expérimentales

- **com_ui_input**:
  - **english**: Input
  - **translated**: Entrée

- **com_ui_close**:
  - **english**: Close
  - **translated**: Fermer

- **com_ui_model**:
  - **english**: Model
  - **translated**: Modèle

- **com_ui_select_model**:
  - **english**: Select a model
  - **translated**: Sélectionner un modèle

- **com_ui_use_prompt**:
  - **english**: Use prompt
  - **translated**: Utiliser le prompt

- **com_ui_prev**:
  - **english**: Prev
  - **translated**: Précédent

- **com_ui_next**:
  - **english**: Next
  - **translated**: Suivant

- **com_ui_stop**:
  - **english**: Stop
  - **translated**: Arrêt 

- **com_ui_prompt_templates**:
  - **english**: Prompt Templates
  - **translated**: Modèles de prompt

- **com_ui_hide_prompt_templates**:
  - **english**: Hide Prompt Templates
  - **translated**: Masquer les modèles de prompt

- **com_ui_showing**:
  - **english**: Showing
  - **translated**: Affichage

- **com_ui_of**:
  - **english**: of
  - **translated**: des

- **com_ui_entries**:
  - **english**: Entries
  - **translated**: entrées

- **com_ui_pay_per_call**:
  - **english**: All AI conversations in one place. Pay per call and not per month
  - **translated**: Toutes les conversations IA au même endroit. Payez à la demande et non par mois

- **com_ui_new_footer**:
  - **english**: All AI conversations in one place.
  - **translated**: Toutes les conversations IA au même endroit.

- **com_ui_enter**:
  - **english**: Enter
  - **translated**: Entrer

- **com_ui_submit**:
  - **english**: Submit
  - **translated**: Soumettre

- **com_ui_upload_success**:
  - **english**: Successfully uploaded file
  - **translated**: Fichier téléversé avec succès

- **com_ui_upload_error**:
  - **english**: There was an error uploading your file
  - **translated**: Une erreur s'est produite lors du téléversement de votre fichier

- **com_ui_upload_invalid**:
  - **english**: Invalid file for upload. Must be an image not exceeding 2 MB
  - **translated**: Fichier invalide pour le téléversement. Doit être une image ne dépassant pas 2 Mo

- **com_ui_cancel**:
  - **english**: Cancel
  - **translated**: Annuler

- **com_ui_save**:
  - **english**: Save
  - **translated**: Sauvegarder

- **com_ui_save_submit**:
  - **english**: Save & Submit
  - **translated**: Enregistrer et Soumettre

- **com_user_message**:
  - **english**: You
  - **translated**: Vous

- **com_ui_copy_to_clipboard**:
  - **english**: Copy to clipboard
  - **translated**: Copier dans le presse-papier

- **com_ui_copied_to_clipboard**:
  - **english**: Copied to clipboard
  - **translated**: Copié dans le presse-papier

- **com_ui_regenerate**:
  - **english**: Regenerate
  - **translated**: Régénérer

- **com_ui_continue**:
  - **english**: Continue
  - **translated**: Continuer

- **com_ui_edit**:
  - **english**: Edit
  - **translated**: Modifier

- **com_ui_success**:
  - **english**: Success
  - **translated**: Succès

- **com_ui_all**:
  - **english**: all
  - **translated**: tout

- **com_ui_clear**:
  - **english**: Clear
  - **translated**: Effacer

- **com_ui_revoke**:
  - **english**: Revoke
  - **translated**: Révoquer

- **com_ui_revoke_info**:
  - **english**: Revoke all user provided credentials
  - **translated**: Révoquer toutes les informations d'identification fournies par l'utilisateur

- **com_ui_import_conversation**:
  - **english**: Import
  - **translated**: Importer

- **com_ui_import_conversation_info**:
  - **english**: Import conversations from a JSON file
  - **translated**: Importer des conversations à partir d’un fichier JSON

- **com_ui_import_conversation_success**:
  - **english**: Conversations imported successfully
  - **translated**: Conversations importées avec succès

- **com_ui_import_conversation_error**:
  - **english**: There was an error importing your conversations
  - **translated**: Une erreur s’est produite lors de l’importation de vos conversations

- **com_ui_confirm_action**:
  - **english**: Confirm Action
  - **translated**: Confirmer l'action

- **com_ui_chats**:
  - **english**: chats
  - **translated**: discussions

- **com_ui_delete**:
  - **english**: Delete
  - **translated**: Supprimer

- **com_ui_delete_conversation**:
  - **english**: Delete chat?
  - **translated**: Supprimer la discussions?

- **com_ui_delete_confirm**:
  - **english**: This will delete
  - **translated**: Cela supprimera

- **com_ui_rename**:
  - **english**: Rename
  - **translated**: Renombrar

- **com_ui_archive**:
  - **english**: Archive
  - **translated**: Archiver

- **com_ui_archive_error**:
  - **english**: Failed to archive conversation
  - **translated**: échec de l'archivage de la conversation

- **com_ui_unarchive**:
  - **english**: Unarchive
  - **translated**: Désarchiver

- **com_ui_unarchive_error**:
  - **english**: Failed to unarchive conversation
  - **translated**: Échec de la désarchivage de la conversation

- **com_ui_more_options**:
  - **english**: More
  - **translated**: Plus

- **com_ui_preview**:
  - **english**: Preview
  - **translated**: Aperçu

- **com_ui_upload**:
  - **english**: Upload
  - **translated**: Téléverser

- **com_ui_connect**:
  - **english**: Connect
  - **translated**: Connecter

- **com_auth_error_login**:
  - **english**: Unable to login with the information provided. Please check your credentials and try again.
  - **translated**: Impossible de se connecter avec les informations fournies. Veuillez vérifier vos identifiants et réessayer.

- **com_auth_error_login_rl**:
  - **english**: Too many login attempts in a short amount of time. Please try again later.
  - **translated**: Trop de tentatives de connexion en peu de temps. Veuillez réessayer plus tard.

- **com_auth_error_login_ban**:
  - **english**: Your account has been temporarily banned due to violations of our service.
  - **translated**: Votre compte a été temporairement banni en raison de violations de notre service.

- **com_auth_error_login_server**:
  - **english**: There was an internal server error. Please wait a few moments and try again.
  - **translated**: Une erreur interne du serveur s'est produite. Veuillez patienter quelques instants et réessayer.

- **com_auth_no_account**:
  - **english**: Don't have an account?
  - **translated**: Vous n'avez pas de compte?

- **com_auth_sign_up**:
  - **english**: Sign up
  - **translated**: S'inscrire

- **com_auth_sign_in**:
  - **english**: Sign in
  - **translated**: Se connecter

- **com_auth_google_login**:
  - **english**: Continue with Google
  - **translated**: Se connecter avec Google

- **com_auth_facebook_login**:
  - **english**: Continue with Facebook
  - **translated**: Se connecter avec Facebook

- **com_auth_github_login**:
  - **english**: Continue with Github
  - **translated**: Se connecter avec Github

- **com_auth_discord_login**:
  - **english**: Continue with Discord
  - **translated**: Se connecter avec Discord

- **com_auth_email**:
  - **english**: Email
  - **translated**: Courriel

- **com_auth_email_required**:
  - **english**: Email is required
  - **translated**: Le courriel est obligatoire

- **com_auth_email_min_length**:
  - **english**: Email must be at least 6 characters
  - **translated**: Le courriel doit comporter au moins 6 caractères

- **com_auth_email_max_length**:
  - **english**: Email should not be longer than 120 characters
  - **translated**: Le courriel ne doit pas dépasser 120 caractères

- **com_auth_email_pattern**:
  - **english**: You must enter a valid email address
  - **translated**: Vous devez entrer une adresse courriel valide

- **com_auth_email_address**:
  - **english**: Email address
  - **translated**: Adresse courriel

- **com_auth_password**:
  - **english**: Password
  - **translated**: Mot de passe

- **com_auth_password_required**:
  - **english**: Password is required
  - **translated**: Le mot de passe est obligatoire

- **com_auth_password_min_length**:
  - **english**: Password must be at least 8 characters
  - **translated**: Le mot de passe doit comporter au moins 8 caractères

- **com_auth_password_max_length**:
  - **english**: Password must be less than 128 characters
  - **translated**: Le mot de passe doit être inférieur à 128 caractères

- **com_auth_password_forgot**:
  - **english**: Forgot Password?
  - **translated**: Mot de passe oublié?

- **com_auth_password_confirm**:
  - **english**: Confirm password
  - **translated**: Confirmer le mot de passe

- **com_auth_password_not_match**:
  - **english**: Passwords do not match
  - **translated**: Les mots de passe ne correspondent pas

- **com_auth_continue**:
  - **english**: Continue
  - **translated**: Continuer

- **com_auth_create_account**:
  - **english**: Create your account
  - **translated**: Créez votre compte

- **com_auth_error_create**:
  - **english**: There was an error attempting to register your account. Please try again.
  - **translated**: Il y a eu une erreur lors de la tentative d'enregistrement de votre compte. Veuillez réessayer.

- **com_auth_full_name**:
  - **english**: Full name
  - **translated**: Nom complet

- **com_auth_name_required**:
  - **english**: Name is required
  - **translated**: Le nom est obligatoire

- **com_auth_name_min_length**:
  - **english**: Name must be at least 3 characters
  - **translated**: Le nom doit comporter au moins 3 caractères

- **com_auth_name_max_length**:
  - **english**: Name must be less than 80 characters
  - **translated**: Le nom doit être inférieur à 80 caractères

- **com_auth_username**:
  - **english**: Username (optional)
  - **translated**: Nom d'utilisateur

- **com_auth_username_required**:
  - **english**: Username is required
  - **translated**: Le nom d'utilisateur est obligatoire

- **com_auth_username_min_length**:
  - **english**: Username must be at least 2 characters
  - **translated**: Le nom d'utilisateur doit comporter au moins 3 caractères

- **com_auth_username_max_length**:
  - **english**: Username must be less than 20 characters
  - **translated**: Le nom d'utilisateur doit être inférieur à 20 caractères

- **com_auth_already_have_account**:
  - **english**: Already have an account?
  - **translated**: Vous avez déjà un compte ?

- **com_auth_login**:
  - **english**: Login
  - **translated**: Connexion

- **com_auth_reset_password**:
  - **english**: Reset your password
  - **translated**: Réinitialiser votre mot de passe

- **com_auth_click**:
  - **english**: Click
  - **translated**: Cliquez

- **com_auth_here**:
  - **english**: HERE
  - **translated**: ICI

- **com_auth_to_reset_your_password**:
  - **english**: to reset your password.
  - **translated**: pour réinitialiser votre mot de passe.

- **com_auth_reset_password_link_sent**:
  - **english**: Email Sent
  - **translated**: Courriel envoyé

- **com_auth_reset_password_email_sent**:
  - **english**: An email has been sent to you with further instructions to reset your password.
  - **translated**: Un courriel vous a été envoyé avec des instructions supplémentaires pour réinitialiser votre mot de passe.

- **com_auth_error_reset_password**:
  - **english**: There was a problem resetting your password. There was no user found with the email address provided. Please try again.
  - **translated**: Il y a eu un problème pour réinitialiser votre mot de passe. Aucun utilisateur n'a été trouvé avec l'adresse courriel fournie. Veuillez réessayer.

- **com_auth_reset_password_success**:
  - **english**: Password Reset Success
  - **translated**: Réinitialisation du mot de passe réussie

- **com_auth_login_with_new_password**:
  - **english**: You may now login with your new password.
  - **translated**: Vous pouvez maintenant vous connecter avec votre nouveau mot de passe.

- **com_auth_error_invalid_reset_token**:
  - **english**: This password reset token is no longer valid.
  - **translated**: Ce jeton de réinitialisation de mot de passe n'est plus valide.

- **com_auth_click_here**:
  - **english**: Click here
  - **translated**: Cliquez ici

- **com_auth_to_try_again**:
  - **english**: to try again.
  - **translated**: pour réessayer.

- **com_auth_submit_registration**:
  - **english**: Submit registration
  - **translated**: Soumettre l'inscription

- **com_auth_welcome_back**:
  - **english**: Welcome back
  - **translated**: Bienvenue à nouveau

- **com_endpoint_open_menu**:
  - **english**: Open Menu
  - **translated**: Ouvrir le menu

- **com_endpoint_bing_enable_sydney**:
  - **english**: Enable Sydney
  - **translated**: Activer Sydney

- **com_endpoint_bing_to_enable_sydney**:
  - **english**: To enable Sydney
  - **translated**: Pour activer Sydney

- **com_endpoint_bing_jailbreak**:
  - **english**: Jailbreak
  - **translated**: Jailbreak

- **com_endpoint_bing_context_placeholder**:
  - **english**: Bing can use up to 7k tokens for 'context', which it can reference for the conversation. The specific limit is not known but may run into errors exceeding 7k tokens
  - **translated**: Bing peut utiliser jusqu'à 7k jetons pour le "contexte", qu'il peut référencer pour la conversation. La limite spécifique n'est pas connue mais peut entraîner des erreurs dépassant les 7k jetons

- **com_endpoint_bing_system_message_placeholder**:
  - **english**: WARNING: Misuse of this feature can get you BANNED from using Bing! Click on 'System Message' for full instructions and the default message if omitted, which is the 'Sydney' preset that is considered safe.
  - **translated**: AVERTISSEMENT : L'abus de cette fonctionnalité peut vous faire BANNIR de l'utilisation de Bing! Cliquez sur "Message système" pour obtenir les instructions complètes et le message par défaut si omis, qui est le préréglage "Sydney" qui est considéré comme sûr.

- **com_endpoint_system_message**:
  - **english**: System Message
  - **translated**: Message système

- **com_endpoint_message**:
  - **english**: Message
  - **translated**: Message

- **com_endpoint_message_not_appendable**:
  - **english**: Edit your message or Regenerate.
  - **translated**: Editer votre message ou regénerer.

- **com_endpoint_default_blank**:
  - **english**: default: blank
  - **translated**: par défaut : vide

- **com_endpoint_default_false**:
  - **english**: default: false
  - **translated**: par défaut : faux

- **com_endpoint_default_creative**:
  - **english**: default: creative
  - **translated**: par défaut : créatif

- **com_endpoint_default_empty**:
  - **english**: default: empty
  - **translated**: par défaut : vide

- **com_endpoint_default_with_num**:
  - **english**: default: {0}
  - **translated**: par défaut : {0}

- **com_endpoint_context**:
  - **english**: Context
  - **translated**: Contexte

- **com_endpoint_tone_style**:
  - **english**: Tone Style
  - **translated**: Style de ton

- **com_endpoint_token_count**:
  - **english**: Token count
  - **translated**: Nombre de jetons

- **com_endpoint_output**:
  - **english**: Output
  - **translated**: Sortie

- **com_endpoint_google_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: Des valeurs plus élevées = plus aléatoires, tandis que des valeurs plus faibles = plus concentrées et déterministes. Nous vous recommandons de modifier ceci ou Top P mais pas les deux.

- **com_endpoint_google_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p change la façon dont le modèle sélectionne les jetons pour la sortie. Les jetons sont sélectionnés du plus K (voir le paramètre topK) probable au moins jusqu'à ce que la somme de leurs probabilités égale la valeur top-p.

- **com_endpoint_google_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k change la façon dont le modèle sélectionne les jetons pour la sortie. Un top-k de 1 signifie que le jeton sélectionné est le plus probable parmi tous les jetons du vocabulaire du modèle (également appelé décodage glouton), tandis qu'un top-k de 3 signifie que le jeton suivant est sélectionné parmi les 3 jetons les plus probables (en utilisant la température).

- **com_endpoint_google_maxoutputtokens**:
  - **english**:  	Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: Nombre maximum de jetons qui peuvent être générés dans la réponse. Spécifiez une valeur plus faible pour des réponses plus courtes et une valeur plus élevée pour des réponses plus longues.

- **com_endpoint_google_custom_name_placeholder**:
  - **english**: Set a custom name for Google
  - **translated**: Définir un nom personnalisé pour Google

- **com_endpoint_custom_name**:
  - **english**: Custom Name
  - **translated**: Nom personnalisé

- **com_endpoint_prompt_prefix**:
  - **english**: Custom Instructions
  - **translated**: Préfixe du prompt

- **com_endpoint_temperature**:
  - **english**: Temperature
  - **translated**: Température

- **com_endpoint_default**:
  - **english**: default
  - **translated**: par défaut

- **com_endpoint_top_p**:
  - **english**: Top P
  - **translated**: Top P

- **com_endpoint_top_k**:
  - **english**: Top K
  - **translated**: Top K

- **com_endpoint_max_output_tokens**:
  - **english**: Max Output Tokens
  - **translated**: Nombre maximum de jetons en sortie

- **com_endpoint_openai_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: Des valeurs plus élevées = plus aléatoires, tandis que des valeurs plus faibles = plus concentrées et déterministes. Nous vous recommandons de modifier ceci ou Top P mais pas les deux.

- **com_endpoint_openai_max**:
  - **english**: The max tokens to generate. The total length of input tokens and generated tokens is limited by the model's context length.
  - **translated**: Le nombre maximum de jetons à générer. La longueur totale des jetons d'entrée et des jetons générés est limitée par la longueur du contexte du modèle.

- **com_endpoint_openai_topp**:
  - **english**: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We recommend altering this or temperature but not both.
  - **translated**: Une alternative à l'échantillonnage avec température, appelée échantillonnage du noyau, où le modèle considère les résultats des jetons avec une masse de probabilité top_p. Ainsi, 0,1 signifie que seuls les jetons représentant les 10 % de masse de probabilité les plus élevés sont pris en compte. Nous vous recommandons de modifier ceci ou la température mais pas les deux.

- **com_endpoint_openai_freq**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
  - **translated**: Nombre compris entre -2,0 et 2,0. Les valeurs positives pénalisent les nouveaux jetons en fonction de leur fréquence existante dans le texte jusqu'à présent, diminuant ainsi la probabilité que le modèle répète la même ligne mot pour mot.

- **com_endpoint_openai_pres**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
  - **translated**: Nombre compris entre -2,0 et 2,0. Les valeurs positives pénalisent les nouveaux jetons en fonction du fait qu'ils apparaissent ou non dans le texte jusqu'à présent, augmentant ainsi la probabilité que le modèle parle de nouveaux sujets.

- **com_endpoint_openai_resend**:
  - **english**: Resend all previously attached images. Note: this can significantly increase token cost and you may experience errors with many image attachments.
  - **translated**: Renvoyer toutes les images précédemment jointes. Remarque : cela peut augmenter considérablement le coût en jetons et vous pouvez rencontrer des erreurs avec de nombreuses pièces jointes d'images.

- **com_endpoint_openai_detail**:
  - **english**: The resolution for Vision requests. "Low" is cheaper and faster, "High" is more detailed and expensive, and "Auto" will automatically choose between the two based on the image resolution.
  - **translated**: La résolution pour les requêtes Vision. "Low" est moins cher et plus rapide, "High" est plus détaillé et plus cher, et "Auto" choisira automatiquement entre les deux en fonction de la résolution de l'image.

- **com_endpoint_openai_custom_name_placeholder**:
  - **english**: Set a custom name for the AI
  - **translated**: Définir un nom personnalisé pour ChatGPT

- **com_endpoint_openai_prompt_prefix_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: Définir des instructions personnalisées à inclure dans le message système. Par défaut : aucun

- **com_endpoint_anthropic_temp**:
  - **english**: Ranges from 0 to 1. Use temp closer to 0 for analytical / multiple choice, and closer to 1 for creative and generative tasks. We recommend altering this or Top P but not both.
  - **translated**: Varie de 0 à 1. Utilisez une température proche de 0 pour l'analyse / le choix multiple, et proche de 1 pour les tâches créatives et génératives. Nous vous recommandons de modifier ceci ou Top P mais pas les deux.

- **com_endpoint_anthropic_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p change la façon dont le modèle sélectionne les jetons pour la sortie. Les jetons sont sélectionnés du plus K (voir le paramètre topK) probable au moins jusqu'à ce que la somme de leurs probabilités égale la valeur top-p.

- **com_endpoint_anthropic_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k change la façon dont le modèle sélectionne les jetons pour la sortie. Un top-k de 1 signifie que le jeton sélectionné est le plus probable parmi tous les jetons du vocabulaire du modèle (également appelé décodage glouton), tandis qu'un top-k de 3 signifie que le jeton suivant est sélectionné parmi les 3 jetons les plus probables (en utilisant la température).

- **com_endpoint_anthropic_maxoutputtokens**:
  - **english**: Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: Nombre maximum de jetons qui peuvent être générés dans la réponse. Spécifiez une valeur plus faible pour des réponses plus courtes et une valeur plus élevée pour des réponses plus longues.

- **com_endpoint_anthropic_custom_name_placeholder**:
  - **english**: Set a custom name for Anthropic
  - **translated**: Définir un nom personnalisé pour Anthropic

- **com_endpoint_frequency_penalty**:
  - **english**: Frequency Penalty
  - **translated**: Pénalité de fréquence

- **com_endpoint_presence_penalty**:
  - **english**: Presence Penalty
  - **translated**: Pénalité de présence

- **com_endpoint_plug_use_functions**:
  - **english**: Use Functions
  - **translated**: Utiliser les fonctions

- **com_endpoint_plug_resend_images**:
  - **english**: Resend Images
  - **translated**: Renvoyer des images

- **com_endpoint_plug_skip_completion**:
  - **english**: Skip Completion
  - **translated**: Sauter la complétion

- **com_endpoint_disabled_with_tools**:
  - **english**: disabled with tools
  - **translated**: désactivé avec les outils

- **com_endpoint_disabled_with_tools_placeholder**:
  - **english**: Disabled with Tools Selected
  - **translated**: Désactivé avec les outils sélectionnés

- **com_endpoint_plug_set_custom_instructions_for_gpt_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: Définir des instructions personnalisées à inclure dans le message système. Par défaut : aucun

- **com_endpoint_import**:
  - **english**: Import
  - **translated**: Importer

- **com_endpoint_set_custom_name**:
  - **english**: Set a custom name, in case you can find this preset
  - **translated**: Définir un nom personnalisé, au cas où vous trouveriez ce préréglage

- **com_endpoint_preset_delete_confirm**:
  - **english**: Are you sure you want to delete this preset?
  - **translated**: Êtes-vous sûr de vouloir supprimer ce préréglage?

- **com_endpoint_preset_clear_all_confirm**:
  - **english**: Are you sure you want to delete all of your presets?
  - **translated**: Êtes-vous sûr de vouloir supprimer tous vos préréglages?

- **com_endpoint_preset_import**:
  - **english**: Preset Imported!
  - **translated**: Préréglage importé!

- **com_endpoint_preset_import_error**:
  - **english**: There was an error importing your preset. Please try again.
  - **translated**: Il y a eu une erreur lors de l'importation de votre préréglage. Veuillez réessayer.

- **com_endpoint_preset_save_error**:
  - **english**: There was an error saving your preset. Please try again.
  - **translated**: Il y a eu une erreur lors de la sauvegarde de votre préréglage. Veuillez réessayer.

- **com_endpoint_preset_delete_error**:
  - **english**: There was an error deleting your preset. Please try again.
  - **translated**: Il y a eu une erreur lors de la suppression de votre préréglage. Veuillez réessayer.

- **com_endpoint_preset_default_removed**:
  - **english**: is no longer the default preset.
  - **translated**: n'est plus le préréglage par défaut.

- **com_endpoint_preset_default_item**:
  - **english**: Default:
  - **translated**: Par défaut :

- **com_endpoint_preset_default_none**:
  - **english**: No default preset active.
  - **translated**: Aucun préréglage par défaut actif.

- **com_endpoint_preset_title**:
  - **english**: Preset
  - **translated**: Préréglage

- **com_endpoint_preset_saved**:
  - **english**: Saved!
  - **translated**: Enregistré!

- **com_endpoint_preset_default**:
  - **english**: is now the default preset.
  - **translated**: est maintenant le préréglage par défaut.

- **com_endpoint_preset**:
  - **english**: preset
  - **translated**: préréglage

- **com_endpoint_presets**:
  - **english**: presets
  - **translated**: préréglages

- **com_endpoint_preset_selected**:
  - **english**: Preset Active!
  - **translated**: Préréglage actif!

- **com_endpoint_preset_selected_title**:
  - **english**: Active!
  - **translated**: Actif!

- **com_endpoint_preset_name**:
  - **english**: Preset Name
  - **translated**: Nom du préréglage

- **com_endpoint_new_topic**:
  - **english**: New Topic
  - **translated**: Nouveau sujet

- **com_endpoint**:
  - **english**: Endpoint
  - **translated**: Endpoint

- **com_endpoint_hide**:
  - **english**: Hide
  - **translated**: Masquer

- **com_endpoint_show**:
  - **english**: Show
  - **translated**: Afficher

- **com_endpoint_examples**:
  - **english**:  Presets
  - **translated**:  Exemples

- **com_endpoint_completion**:
  - **english**: Completion
  - **translated**: Complétion

- **com_endpoint_agent**:
  - **english**: Agent
  - **translated**: Agent

- **com_endpoint_show_what_settings**:
  - **english**: Show {0} Settings
  - **translated**: Afficher les paramètres {0}

- **com_endpoint_export**:
  - **english**: Export
  - **translated**: Exporter

- **com_endpoint_save_as_preset**:
  - **english**: Save As Preset
  - **translated**: Enregistrer comme préréglage

- **com_endpoint_presets_clear_warning**:
  - **english**: Are you sure you want to clear all presets? This is irreversible.
  - **translated**: Etes-vous sûr de vouloir effacer tous les préréglages? Cette action est irréversible.

- **com_endpoint_not_implemented**:
  - **english**: Not implemented
  - **translated**: Non implémenté

- **com_endpoint_no_presets**:
  - **english**: No presets yet, use the settings button to create one
  - **translated**: Aucun préréglage pour l'instant, utilisez le bouton paramètres pour en créer un

- **com_endpoint_not_available**:
  - **english**: No endpoint available
  - **translated**: Aucun endpoint disponible

- **com_endpoint_view_options**:
  - **english**: View Options
  - **translated**: Voir les options

- **com_endpoint_save_convo_as_preset**:
  - **english**: Save Conversation as Preset
  - **translated**: Enregistrer la conversation comme préréglage

- **com_endpoint_my_preset**:
  - **english**: My Preset
  - **translated**: Mon préréglage

- **com_endpoint_agent_model**:
  - **english**: Agent Model (Recommended: GPT-3.5)
  - **translated**: Modèle d'agent (recommandé : GPT-3.5)

- **com_endpoint_completion_model**:
  - **english**: Completion Model (Recommended: GPT-4)
  - **translated**: Modèle de complétion (recommandé : GPT-4)

- **com_endpoint_func_hover**:
  - **english**: Enable use of Plugins as OpenAI Functions
  - **translated**: Activer l'utilisation des plugins comme fonctions OpenAI

- **com_endpoint_skip_hover**:
  - **english**: Enable skipping the completion step, which reviews the final answer and generated steps
  - **translated**: Activer le saut de l'étape de complétion, qui examine la réponse finale et les étapes générées

- **com_endpoint_config_key**:
  - **english**: Set API Key
  - **translated**: Définir la clé API

- **com_endpoint_config_placeholder**:
  - **english**: Set your Key in the Header menu to chat.
  - **translated**: Définissez votre clé dans le menu En-tête pour discuter.

- **com_endpoint_config_key_for**:
  - **english**: Set API Key for
  - **translated**: Définir la clé API pour

- **com_endpoint_config_key_name**:
  - **english**: Key
  - **translated**: Clé

- **com_endpoint_config_value**:
  - **english**: Enter value for
  - **translated**: Entrez la valeur pour

- **com_endpoint_config_key_name_placeholder**:
  - **english**: Set API key first
  - **translated**: Définir d'abord la clé API

- **com_endpoint_config_key_encryption**:
  - **english**: Your key will be encrypted and deleted at
  - **translated**: Votre clé sera cryptée et supprimée à

- **com_endpoint_config_key_expiry**:
  - **english**: the expiry time
  - **translated**: le délai d'expiration

- **com_endpoint_config_click_here**:
  - **english**: Click Here
  - **translated**: Cliquez ici

- **com_endpoint_config_google_service_key**:
  - **english**: Google Service Account Key
  - **translated**: Clé de compte de service Google

- **com_endpoint_config_google_cloud_platform**:
  - **english**: (from Google Cloud Platform)
  - **translated**: (de Google Cloud Platform)

- **com_endpoint_config_google_api_key**:
  - **english**: Google API Key
  - **translated**: Clé API Google

- **com_endpoint_config_google_gemini_api**:
  - **english**: (Gemini API)
  - **translated**: (API Gemini)

- **com_endpoint_config_google_api_info**:
  - **english**: To get your Generative Language API key (for Gemini),
  - **translated**: Pour obtenir votre clé API de langage génératif (pour Gemini),

- **com_endpoint_config_key_import_json_key**:
  - **english**: Import Service Account JSON Key.
  - **translated**: Importez la clé JSON du compte de service.

- **com_endpoint_config_key_import_json_key_success**:
  - **english**: Successfully Imported Service Account JSON Key
  - **translated**: Clé JSON du compte de service importé avec succès

- **com_endpoint_config_key_import_json_key_invalid**:
  - **english**: Invalid Service Account JSON Key, Did you import the correct file?
  - **translated**: Clé JSON du compte de service invalide. Avez-vous importé le bon fichier ?

- **com_endpoint_config_key_get_edge_key**:
  - **english**: To get your Access token for Bing, login to
  - **translated**: Pour obtenir votre jeton d'accès pour Bing, connectez-vous à

- **com_endpoint_config_key_get_edge_key_dev_tool**:
  - **english**: Use dev tools or an extension while logged into the site to copy the content of the _U cookie. If this fails, follow these
  - **translated**: Utilisez dev tools ou une extension lorsque vous êtes connecté au site pour copier le contenu du cookie _U. Si cela échoue, suivez ces

- **com_endpoint_config_key_edge_instructions**:
  - **english**: instructions
  - **translated**: instructions

- **com_endpoint_config_key_edge_full_key_string**:
  - **english**: to provide the full cookie strings.
  - **translated**: pour fournir les chaînes complètes des cookies.

- **com_endpoint_config_key_chatgpt**:
  - **english**: To get your Access token For ChatGPT 'Free Version', login to
  - **translated**: Pour obtenir votre jeton d'accès pour ChatGPT 'Version gratuite', se connecter à

- **com_endpoint_config_key_chatgpt_then_visit**:
  - **english**: then visit
  - **translated**: puis visitez

- **com_endpoint_config_key_chatgpt_copy_token**:
  - **english**: Copy access token.
  - **translated**: Copiez le jeton d'accès.

- **com_endpoint_config_key_google_need_to**:
  - **english**: You need to
  - **translated**: Vous devez

- **com_endpoint_config_key_google_vertex_ai**:
  - **english**: Enable Vertex AI
  - **translated**: Activer Vertex AI

- **com_endpoint_config_key_google_vertex_api**:
  - **english**: API on Google Cloud, then
  - **translated**: API sur Google Cloud, puis

- **com_endpoint_config_key_google_service_account**:
  - **english**: Create a Service Account
  - **translated**: Créer un compte de service

- **com_endpoint_config_key_google_vertex_api_role**:
  - **english**: Make sure to click 'Create and Continue' to give at least the 'Vertex AI User' role. Lastly, create a JSON key to import here.
  - **translated**: Assurez-vous de cliquer 'Créer et continuer' pour donner au moins le role 'Utilisateur de Vertex AI'. Finalement, créez une clé JSON à importer ici.

- **com_nav_welcome_message**:
  - **english**: How can I help you today?
  - **translated**: Comment puis-je vous aider aujourd'hui?

- **com_nav_auto_scroll**:
  - **english**: Auto-scroll to Newest on Open
  - **translated**: Défilement automatique jusqu'au plus récent à l'ouverture

- **com_nav_modular_chat**:
  - **english**: Enable switching Endpoints mid-conversation
  - **translated**: Activer le changement de points de terminaison en cours de conversation

- **com_nav_latex_parsing**:
  - **english**: Parsing LaTeX in messages (may affect performance)
  - **translated**: Analyse LaTeX dans les messages (peut affecter les performances)

- **com_nav_profile_picture**:
  - **english**: Profile Picture
  - **translated**: Photo de profil

- **com_nav_change_picture**:
  - **english**: Change picture
  - **translated**: Changer de photo

- **com_nav_plugin_store**:
  - **english**: Plugin store
  - **translated**: Boutique de plugins

- **com_show_agent_settings**:
  - **english**: Show Agent Settings
  - **translated**: Afficher les paramètres de l'agent

- **com_show_completion_settings**:
  - **english**: Show Completion Settings
  - **translated**: Afficher les paramètres de complétion

- **com_hide_examples**:
  - **english**: Hide Examples
  - **translated**: Masquer les exemples

- **com_show_examples**:
  - **english**: Show Examples
  - **translated**: Afficher les exemples

- **com_nav_plugin_search**:
  - **english**: Search plugins
  - **translated**: Rechercher des plugins

- **com_nav_plugin_auth_error**:
  - **english**: There was an error attempting to authenticate this plugin. Please try again.
  - **translated**: Une erreur s'est produite lors de la tentative d'authentification de ce plugin. Veuillez réessayer.

- **com_nav_export_filename**:
  - **english**: Filename
  - **translated**: Nom du fichier

- **com_nav_export_filename_placeholder**:
  - **english**: Set the filename
  - **translated**: Définir le nom du fichier

- **com_nav_export_type**:
  - **english**: Type
  - **translated**: Type

- **com_nav_export_include_endpoint_options**:
  - **english**: Include endpoint options
  - **translated**: Inclure les options d'extrémité

- **com_nav_enabled**:
  - **english**: Enabled
  - **translated**: Activé

- **com_nav_not_supported**:
  - **english**: Not Supported
  - **translated**: Non pris en charge

- **com_nav_export_all_message_branches**:
  - **english**: Export all message branches
  - **translated**: Exporter toutes les branches de messages

- **com_nav_export_recursive_or_sequential**:
  - **english**: Recursive or sequential?
  - **translated**: Récursif ou séquentiel ?

- **com_nav_export_recursive**:
  - **english**: Recursive
  - **translated**: Récursif

- **com_nav_export_conversation**:
  - **english**: Export conversation
  - **translated**: Exporter la conversation

- **com_nav_theme**:
  - **english**: Theme
  - **translated**: Thème

- **com_nav_theme_system**:
  - **english**: System
  - **translated**: Système

- **com_nav_theme_dark**:
  - **english**: Dark
  - **translated**: Sombre

- **com_nav_theme_light**:
  - **english**: Light
  - **translated**: Clair

- **com_nav_user_name_display**:
  - **english**: Display username in messages
  - **translated**: Afficher le nom d'utilisateur dans les messages

- **com_nav_clear_all_chats**:
  - **english**: Clear all chats
  - **translated**: Effacer toutes les conversations

- **com_nav_confirm_clear**:
  - **english**: Confirm Clear
  - **translated**: Confirmer l'effacement

- **com_nav_close_sidebar**:
  - **english**: Close sidebar
  - **translated**: Fermer la barre latérale

- **com_nav_open_sidebar**:
  - **english**: Open sidebar
  - **translated**: Ouvrir la barre latérale

- **com_nav_send_message**:
  - **english**: Send message
  - **translated**: Envoyer un message

- **com_nav_log_out**:
  - **english**: Log out
  - **translated**: Se déconnecter

- **com_nav_user**:
  - **english**: USER
  - **translated**: UTILISATEUR

- **com_nav_archived_chats**:
  - **english**: Archived chats
  - **translated**: Conversations archivées

- **com_nav_archived_chats_manage**:
  - **english**: Manage
  - **translated**: Gérer

- **com_nav_archive_all_chats**:
  - **english**: Archive all chats
  - **translated**: Archiver toutes les conversations

- **com_nav_archive_all**:
  - **english**: Archive all
  - **translated**: Archiver tout

- **com_nav_archive_name**:
  - **english**: Name
  - **translated**: Nom

- **com_nav_archive_created_at**:
  - **english**: DateCreated
  - **translated**: CréééLe

- **com_nav_clear_conversation**:
  - **english**: Clear conversations
  - **translated**: Effacer les conversations

- **com_nav_clear_conversation_confirm_message**:
  - **english**: Are you sure you want to clear all conversations? This is irreversible.
  - **translated**: Êtes-vous sûr de vouloir effacer toutes les conversations ? Ceci est irréversible.

- **com_nav_help_faq**:
  - **english**: Help & FAQ
  - **translated**: Aide & FAQ

- **com_nav_settings**:
  - **english**: Settings
  - **translated**: Paramètres

- **com_nav_search_placeholder**:
  - **english**: Search messages
  - **translated**: Rechercher des messages

- **com_nav_setting_general**:
  - **english**: General
  - **translated**: Général

- **com_nav_setting_beta**:
  - **english**: Beta features
  - **translated**: Fonctionnalités bêta

- **com_nav_setting_data**:
  - **english**: Data controls
  - **translated**: Contrôles des données

- **com_nav_setting_account**:
  - **english**: Account
  - **translated**: Compte

Please consider the above comparisons to enhance understanding and guide improvements in translations.

Provide insights or suggestions that could help refine the translation process, focusing on cultural and contextual relevance.

Please craft a prompt that can be used to better inform future translations to this language.

Write this prompt in the translated language, with all its nuances detected, not in the English.
