# Instructions for Translation

Write a prompt that is mindful of the nuances in the language with respect to its English counterpart, which serves as the baseline for translations. Here are the comparisons between the language translations and their English counterparts:


- **com_files_no_results**:
  - **english**: No results.
  - **translated**: Keine Ergebnisse.

- **com_files_filter**:
  - **english**: Filter files...
  - **translated**: Dateien filtern...

- **com_files_number_selected**:
  - **english**: {0} of {1} file(s) selected
  - **translated**: {0} von {1} Datei(en) ausgewählt

- **com_sidepanel_select_assistant**:
  - **english**: Select an Assistant
  - **translated**: Wähle einen Assistenten

- **com_sidepanel_parameters**:
  - **english**: Parameters
  - **translated**: Parameter

- **com_sidepanel_assistant_builder**:
  - **english**: Assistant Builder
  - **translated**: Assistenten Ersteller

- **com_sidepanel_hide_panel**:
  - **english**: Hide Panel
  - **translated**: Seitenleiste ausblenden

- **com_sidepanel_attach_files**:
  - **english**: Attach Files
  - **translated**: Dateien anhängen

- **com_sidepanel_manage_files**:
  - **english**: Manage Files
  - **translated**: Dateien verwalten

- **com_assistants_capabilities**:
  - **english**: Capabilities
  - **translated**: Fähigkeiten

- **com_assistants_knowledge**:
  - **english**: Knowledge
  - **translated**: Wissen

- **com_assistants_knowledge_info**:
  - **english**: If you upload files under Knowledge, conversations with your Assistant may include file contents.
  - **translated**: Wenn du unter Wissen Dateien hochlädst, können die Gespräche mit deinem Assistenten den Inhalt der Dateien beinhalten.

- **com_assistants_knowledge_disabled**:
  - **english**: Assistant must be created, and Code Interpreter or Retrieval must be enabled and saved before uploading files as Knowledge.
  - **translated**: Der Assistent muss erstellt und Code-Interpreter oder Wissenabruf müssen aktiviert und gespeichert sein, bevor du Dateien als Wissen hochlädst.

- **com_assistants_image_vision**:
  - **english**: Image Vision
  - **translated**: Bilderkennung

- **com_assistants_code_interpreter**:
  - **english**: Code Interpreter
  - **translated**: Code Interpreter

- **com_assistants_code_interpreter_files**:
  - **english**: The following files are only available for Code Interpreter:
  - **translated**: Die folgenden Dateien sind nur für Code Interpreter verfügbar:

- **com_assistants_retrieval**:
  - **english**: Retrieval
  - **translated**: Wissensabruf

- **com_assistants_search_name**:
  - **english**: Search assistants by name
  - **translated**: Assistenten nach Namen suchen

- **com_ui_tools**:
  - **english**: Tools
  - **translated**: Werkzeuge

- **com_assistants_actions**:
  - **english**: Actions
  - **translated**: Aktionen

- **com_assistants_add_tools**:
  - **english**: Add Tools
  - **translated**: Werkzeuge hinzufügen

- **com_assistants_add_actions**:
  - **english**: Add Actions
  - **translated**: Aktionen hinzufügen

- **com_assistants_available_actions**:
  - **english**: Available Actions
  - **translated**: Verfügbare Aktionen

- **com_assistants_running_action**:
  - **english**: Running action
  - **translated**: Laufende Aktion

- **com_assistants_completed_action**:
  - **english**: Talked to {0}
  - **translated**: Habe mit {0} gesprochen

- **com_assistants_completed_function**:
  - **english**: Ran {0}
  - **translated**: {0} ausgeführt

- **com_assistants_function_use**:
  - **english**: Assistant used {0}
  - **translated**: Assistent hat {0} benutzt

- **com_assistants_domain_info**:
  - **english**: Assistant sent this info to {0}
  - **translated**: Assistent hat diese Info an {0} gesendet

- **com_assistants_delete_actions_success**:
  - **english**: Successfully deleted Action from Assistant
  - **translated**: Aktion vom Assistant erfolgreich gelöscht

- **com_assistants_update_actions_success**:
  - **english**: Successfully created or updated Action
  - **translated**: Erfolgreich erstellte oder aktualisierte Aktion

- **com_assistants_update_actions_error**:
  - **english**: There was an error creating or updating the action.
  - **translated**: Beim Erstellen oder Aktualisieren der Aktion ist ein Fehler aufgetreten.

- **com_assistants_delete_actions_error**:
  - **english**: There was an error deleting the action.
  - **translated**: Beim Löschen der Aktion ist ein Fehler aufgetreten.

- **com_assistants_actions_info**:
  - **english**: Let your Assistant retrieve information or take actions via API's
  - **translated**: Lass deinen Assistenten Informationen abrufen oder Aktionen über API's ausführen

- **com_assistants_name_placeholder**:
  - **english**: Optional: The name of the assistant
  - **translated**: Optional: Der Name des Assistenten

- **com_assistants_instructions_placeholder**:
  - **english**: The system instructions that the assistant uses
  - **translated**: Die Systemanweisungen, die der Assistent verwendet

- **com_assistants_description_placeholder**:
  - **english**: Optional: Describe your Assistant here
  - **translated**: Optional: Beschreibe hier deinen Assistenten

- **com_assistants_actions_disabled**:
  - **english**: You need to create an assistant before adding actions.
  - **translated**: Du musst einen Assistenten erstellen, bevor du Aktionen hinzufügen kannst.

- **com_assistants_update_success**:
  - **english**: Successfully updated
  - **translated**: Erfolgreich aktualisiert

- **com_assistants_update_error**:
  - **english**: There was an error updating your assistant.
  - **translated**: Beim Aktualisieren deines Assistenten ist ein Fehler aufgetreten.

- **com_assistants_create_success**:
  - **english**: Successfully created
  - **translated**: Erfolgreich erstellt

- **com_assistants_create_error**:
  - **english**: There was an error creating your assistant.
  - **translated**: Bei der Erstellung deines Assistenten ist ein Fehler aufgetreten.

- **com_ui_field_required**:
  - **english**: This field is required
  - **translated**: Dieses Feld ist erforderlich

- **com_ui_download_error**:
  - **english**: Error downloading file. The file may have been deleted.
  - **translated**: Fehler beim Herunterladen der Datei. Die Datei wurde möglicherweise gelöscht.

- **com_ui_attach_error_type**:
  - **english**: Unsupported file type for endpoint:
  - **translated**: Nicht unterstützter Dateityp für Endpunkt:

- **com_ui_attach_error_size**:
  - **english**: File size limit exceeded for endpoint:
  - **translated**: Dateigrößenlimit für den Endpunkt überschritten:

- **com_ui_attach_error**:
  - **english**: Cannot attach file. Create or select a conversation, or try refreshing the page.
  - **translated**: Datei kann nicht angehängt werden. Erstelle oder wähle eine Konversation oder versuche, die Seite zu aktualisieren.

- **com_ui_examples**:
  - **english**: Examples
  - **translated**: Beispiele

- **com_ui_new_chat**:
  - **english**: New chat
  - **translated**: Neuer Chat

- **com_ui_happy_birthday**:
  - **english**: It's my 1st birthday!
  - **translated**: Es ist mein 1. Geburtstag!

- **com_ui_example_quantum_computing**:
  - **english**: Explain quantum computing in simple terms
  - **translated**: Erkläre Quantencomputing in einfachen Worten

- **com_ui_example_10_year_old_b_day**:
  - **english**: Got any creative ideas for a 10 year old's birthday?
  - **translated**: Hast du eine kreative Idee für den Geburtstag eines 10-Jährigen?

- **com_ui_example_http_in_js**:
  - **english**: How do I make an HTTP request in Javascript?
  - **translated**: Wie stelle ich eine HTTP-Anfrage in Javascript?

- **com_ui_capabilities**:
  - **english**: Capabilities
  - **translated**: Funktionen

- **com_ui_capability_remember**:
  - **english**: Remembers what user said earlier in the conversation
  - **translated**: Erinnert sich daran, was der Benutzer zu einem früheren Zeitpunkt in der Konversation gesagt hat

- **com_ui_capability_correction**:
  - **english**: Allows user to provide follow-up corrections
  - **translated**: Ermöglicht es dem Benutzer, nachträgliche Korrekturen vorzunehmen

- **com_ui_capability_decline_requests**:
  - **english**: Trained to decline inappropriate requests
  - **translated**: Ermöglicht es, unangemessene Anfragen abzulehnen

- **com_ui_limitations**:
  - **english**: Limitations
  - **translated**: Limitationen

- **com_ui_limitation_incorrect_info**:
  - **english**: May occasionally generate incorrect information
  - **translated**: Kann gelegentlich falsche Informationen erzeugen

- **com_ui_limitation_harmful_biased**:
  - **english**: May occasionally produce harmful instructions or biased content
  - **translated**: Kann gelegentlich schädliche Anweisungen oder verzerrte Inhalte erzeugen

- **com_ui_limitation_limited_2021**:
  - **english**: Limited knowledge of world and events after 2021
  - **translated**: Begrenztes Wissen über die Welt und Ereignisse nach 2021

- **com_ui_experimental**:
  - **english**: Experimental Features
  - **translated**: Experimentelle Funktionen

- **com_ui_on**:
  - **english**: On
  - **translated**: An

- **com_ui_off**:
  - **english**: Off
  - **translated**: Aus

- **com_ui_yes**:
  - **english**: Yes
  - **translated**: Ja

- **com_ui_no**:
  - **english**: No
  - **translated**: Nein

- **com_ui_ascending**:
  - **english**: Asc
  - **translated**: Aufsteigend

- **com_ui_descending**:
  - **english**: Desc
  - **translated**: Absteigend

- **com_ui_show_all**:
  - **english**: Show All
  - **translated**: Alle anzeigen

- **com_ui_name**:
  - **english**: Name
  - **translated**: Name

- **com_ui_date**:
  - **english**: Date
  - **translated**: Datum

- **com_ui_storage**:
  - **english**: Storage
  - **translated**: Speicher

- **com_ui_context**:
  - **english**: Context
  - **translated**: Kontext

- **com_ui_size**:
  - **english**: Size
  - **translated**: Größe

- **com_ui_host**:
  - **english**: Host
  - **translated**: Host

- **com_ui_update**:
  - **english**: Update
  - **translated**: Aktualisierung

- **com_ui_authentication**:
  - **english**: Authentication
  - **translated**: Authentifizierung

- **com_ui_instructions**:
  - **english**: Instructions
  - **translated**: Anweisungen

- **com_ui_description**:
  - **english**: Description
  - **translated**: Beschreibung

- **com_ui_error**:
  - **english**: Error
  - **translated**: Fehler

- **com_ui_select**:
  - **english**: Select
  - **translated**: Auswählen

- **com_ui_input**:
  - **english**: Input
  - **translated**: Eingabe

- **com_ui_close**:
  - **english**: Close
  - **translated**: Schließen

- **com_ui_model**:
  - **english**: Model
  - **translated**: KI-Modell

- **com_ui_select_model**:
  - **english**: Select a model
  - **translated**: Wähle ein KI-Modell

- **com_ui_select_search_model**:
  - **english**: Search model by name
  - **translated**: KI-Modell nach Name suchen

- **com_ui_select_search_plugin**:
  - **english**: Search plugin by name
  - **translated**: Plugin nach Name suchen

- **com_ui_use_prompt**:
  - **english**: Use prompt
  - **translated**: Eingabeaufforderung verwenden

- **com_ui_prev**:
  - **english**: Prev
  - **translated**: Vorherig

- **com_ui_next**:
  - **english**: Next
  - **translated**: Nächste

- **com_ui_stop**:
  - **english**: Stop
  - **translated**: Anhalten

- **com_ui_upload_files**:
  - **english**: Upload files
  - **translated**: Dateien hochladen

- **com_ui_prompt_templates**:
  - **english**: Prompt Templates
  - **translated**: Prompt-Vorlagen

- **com_ui_hide_prompt_templates**:
  - **english**: Hide Prompt Templates
  - **translated**: Prompt-Vorlagen ausblenden

- **com_ui_showing**:
  - **english**: Showing
  - **translated**: Zeigen

- **com_ui_of**:
  - **english**: of
  - **translated**: von

- **com_ui_entries**:
  - **english**: Entries
  - **translated**: Einträge

- **com_ui_pay_per_call**:
  - **english**: All AI conversations in one place. Pay per call and not per month
  - **translated**: Alle KI-Chats an einem Ort. Bezahle pro Anruf und nicht pro Monat

- **com_ui_new_footer**:
  - **english**: All AI conversations in one place.
  - **translated**: Alle KI-Chats an einem Ort.

- **com_ui_enter**:
  - **english**: Enter
  - **translated**: Eingabe

- **com_ui_submit**:
  - **english**: Submit
  - **translated**: Abschicken

- **com_ui_upload_success**:
  - **english**: Successfully uploaded file
  - **translated**: Erfolgreich hochgeladene Datei

- **com_ui_upload_error**:
  - **english**: There was an error uploading your file
  - **translated**: Beim Hochladen deiner Datei ist ein Fehler aufgetreten

- **com_ui_upload_invalid**:
  - **english**: Invalid file for upload. Must be an image not exceeding 2 MB
  - **translated**: Ungültige Datei zum Hochladen. Muss ein Bild sein, das nicht größer als 2 MB ist

- **com_ui_cancel**:
  - **english**: Cancel
  - **translated**: Abbrechen

- **com_ui_save**:
  - **english**: Save
  - **translated**: Speichern

- **com_ui_save_submit**:
  - **english**: Save & Submit
  - **translated**: Speichern & Absenden

- **com_user_message**:
  - **english**: You
  - **translated**: Du

- **com_ui_copy_to_clipboard**:
  - **english**: Copy to clipboard
  - **translated**: In die Zwischenablage kopieren

- **com_ui_copied_to_clipboard**:
  - **english**: Copied to clipboard
  - **translated**: In die Zwischenablage kopiert

- **com_ui_regenerate**:
  - **english**: Regenerate
  - **translated**: Neu generieren

- **com_ui_continue**:
  - **english**: Continue
  - **translated**: Fortsetzen

- **com_ui_edit**:
  - **english**: Edit
  - **translated**: Bearbeiten

- **com_ui_success**:
  - **english**: Success
  - **translated**: Erfolg

- **com_ui_all**:
  - **english**: all
  - **translated**: Alle

- **com_ui_clear**:
  - **english**: Clear
  - **translated**: Löschen

- **com_ui_revoke**:
  - **english**: Revoke
  - **translated**: Widerrufen

- **com_ui_revoke_info**:
  - **english**: Revoke all user provided credentials
  - **translated**: Widerrufe alle vom Benutzer angegebenen Anmeldeinformationen

- **com_ui_import_conversation**:
  - **english**: Import
  - **translated**: Importieren

- **com_ui_import_conversation_info**:
  - **english**: Import conversations from a JSON file
  - **translated**: Chats aus einer JSON-Datei importieren

- **com_ui_import_conversation_success**:
  - **english**: Conversations imported successfully
  - **translated**: Chats erfolgreich importiert

- **com_ui_import_conversation_error**:
  - **english**: There was an error importing your conversations
  - **translated**: Beim Importieren Ihrer Chats ist ein Fehler aufgetreten

- **com_ui_confirm_action**:
  - **english**: Confirm Action
  - **translated**: Bestätige Aktion

- **com_ui_chats**:
  - **english**: chats
  - **translated**: Chats

- **com_ui_avatar**:
  - **english**: Avatar
  - **translated**: Avatar

- **com_ui_unknown**:
  - **english**: Unknown
  - **translated**: Unbekannt

- **com_ui_result**:
  - **english**: Result
  - **translated**: Ergebnis

- **com_ui_image_gen**:
  - **english**: Image Gen
  - **translated**: Image Gen

- **com_ui_assistant**:
  - **english**: Assistant
  - **translated**: Assistent

- **com_ui_assistants**:
  - **english**: Assistants
  - **translated**: Assistenten

- **com_ui_attachment**:
  - **english**: Attachment
  - **translated**: Anhang

- **com_ui_assistants_output**:
  - **english**: Assistants Output
  - **translated**: Assistenten Ausgabe

- **com_ui_delete**:
  - **english**: Delete
  - **translated**: Löschen

- **com_ui_create**:
  - **english**: Create
  - **translated**: Erstellen

- **com_ui_delete_conversation**:
  - **english**: Delete chat?
  - **translated**: Chat löschen?

- **com_ui_delete_confirm**:
  - **english**: This will delete
  - **translated**: Damit wird gelöscht

- **com_ui_delete_assistant_confirm**:
  - **english**: Are you sure you want to delete this Assistant? This cannot be undone.
  - **translated**: Bist du sicher, dass du diesen Assistenten löschen willst? Dies kann nicht rückgängig gemacht werden.

- **com_ui_rename**:
  - **english**: Rename
  - **translated**: Umbenennen

- **com_ui_archive**:
  - **english**: Archive
  - **translated**: Archiv

- **com_ui_archive_error**:
  - **english**: Failed to archive conversation
  - **translated**: Fehler beim Archivieren der Konversation

- **com_ui_unarchive**:
  - **english**: Unarchive
  - **translated**: Entarchivieren

- **com_ui_unarchive_error**:
  - **english**: Failed to unarchive conversation
  - **translated**: Fehler beim Entarchivieren der Konversation

- **com_ui_more_options**:
  - **english**: More
  - **translated**: Mehr

- **com_ui_preview**:
  - **english**: Preview
  - **translated**: Vorschau

- **com_ui_upload**:
  - **english**: Upload
  - **translated**: Hochladen

- **com_ui_connect**:
  - **english**: Connect
  - **translated**: Verbinden

- **com_ui_upload_delay**:
  - **english**: Uploading "{0}" is taking more time than anticipated. Please wait while the file finishes indexing for retrieval.
  - **translated**: Das Hochladen von "{0}" dauert länger als erwartet. Bitte warte, während die Datei zum Abruf indiziert wird.

- **com_ui_privacy_policy**:
  - **english**: Privacy policy
  - **translated**: Datenschutzrichtlinie

- **com_ui_terms_of_service**:
  - **english**: Terms of service
  - **translated**: Nutzungsbedingungen

- **com_auth_error_login**:
  - **english**: Unable to login with the information provided. Please check your credentials and try again.
  - **translated**: Die Anmeldung mit den angegebenen Daten ist fehlgeschlagen. Bitte überprüfe deine Anmeldedaten und versuche es erneut.

- **com_auth_error_login_rl**:
  - **english**: Too many login attempts in a short amount of time. Please try again later.
  - **translated**: Zu viele Anmeldeversuche in einer kurzen Zeitspanne. Bitte versuche es später noch einmal.

- **com_auth_error_login_ban**:
  - **english**: Your account has been temporarily banned due to violations of our service.
  - **translated**: Dein Konto wurde aufgrund von Verstößen gegen unseren Service vorübergehend gesperrt.

- **com_auth_error_login_server**:
  - **english**: There was an internal server error. Please wait a few moments and try again.
  - **translated**: Es ist ein interner Serverfehler aufgetreten. Bitte warte ein paar Augenblicke und versuche es erneut.

- **com_auth_no_account**:
  - **english**: Don't have an account?
  - **translated**: Du hast kein Konto?

- **com_auth_sign_up**:
  - **english**: Sign up
  - **translated**: Melde dich an

- **com_auth_sign_in**:
  - **english**: Sign in
  - **translated**: Melde dich an

- **com_auth_google_login**:
  - **english**: Continue with Google
  - **translated**: Weiter mit Google

- **com_auth_facebook_login**:
  - **english**: Continue with Facebook
  - **translated**: Weiter mit Facebook

- **com_auth_github_login**:
  - **english**: Continue with Github
  - **translated**: Weiter mit Github

- **com_auth_discord_login**:
  - **english**: Continue with Discord
  - **translated**: Weiter mit Discord

- **com_auth_email**:
  - **english**: Email
  - **translated**: E-Mail

- **com_auth_email_required**:
  - **english**: Email is required
  - **translated**: E-Mail ist erforderlich

- **com_auth_email_min_length**:
  - **english**: Email must be at least 6 characters
  - **translated**: E-Mail muss mindestens 6 Zeichen lang sein

- **com_auth_email_max_length**:
  - **english**: Email should not be longer than 120 characters
  - **translated**: Die E-Mail sollte nicht länger als 120 Zeichen sein

- **com_auth_email_pattern**:
  - **english**: You must enter a valid email address
  - **translated**: Du musst eine gültige E-Mail-Adresse eingeben

- **com_auth_email_address**:
  - **english**: Email address
  - **translated**: E-Mail-Adresse

- **com_auth_password**:
  - **english**: Password
  - **translated**: Passwort

- **com_auth_password_required**:
  - **english**: Password is required
  - **translated**: Passwort ist erforderlich

- **com_auth_password_min_length**:
  - **english**: Password must be at least 8 characters
  - **translated**: Das Passwort muss mindestens 8 Zeichen lang sein

- **com_auth_password_max_length**:
  - **english**: Password must be less than 128 characters
  - **translated**: Das Passwort muss weniger als 128 Zeichen lang sein

- **com_auth_password_forgot**:
  - **english**: Forgot Password?
  - **translated**: Passwort vergessen?

- **com_auth_password_confirm**:
  - **english**: Confirm password
  - **translated**: Passwort bestätigen

- **com_auth_password_not_match**:
  - **english**: Passwords do not match
  - **translated**: Passwörter stimmen nicht überein

- **com_auth_continue**:
  - **english**: Continue
  - **translated**: Fortfahren

- **com_auth_create_account**:
  - **english**: Create your account
  - **translated**: Erstelle dein Konto

- **com_auth_error_create**:
  - **english**: There was an error attempting to register your account. Please try again.
  - **translated**: Beim Versuch, dein Konto zu registrieren, ist ein Fehler aufgetreten. Bitte versuche es erneut.

- **com_auth_full_name**:
  - **english**: Full name
  - **translated**: Vollständiger Name

- **com_auth_name_required**:
  - **english**: Name is required
  - **translated**: Name ist erforderlich

- **com_auth_name_min_length**:
  - **english**: Name must be at least 3 characters
  - **translated**: Der Name muss mindestens 3 Zeichen lang sein

- **com_auth_name_max_length**:
  - **english**: Name must be less than 80 characters
  - **translated**: Der Name muss weniger als 80 Zeichen lang sein

- **com_auth_username**:
  - **english**: Username (optional)
  - **translated**: Benutzername (optional)

- **com_auth_username_required**:
  - **english**: Username is required
  - **translated**: Benutzername ist erforderlich

- **com_auth_username_min_length**:
  - **english**: Username must be at least 2 characters
  - **translated**: Der Benutzername muss mindestens 2 Zeichen lang sein

- **com_auth_username_max_length**:
  - **english**: Username must be less than 20 characters
  - **translated**: Der Benutzername muss weniger als 20 Zeichen lang sein

- **com_auth_already_have_account**:
  - **english**: Already have an account?
  - **translated**: Hast du schon ein Konto?

- **com_auth_login**:
  - **english**: Login
  - **translated**: Anmelden

- **com_auth_reset_password**:
  - **english**: Reset your password
  - **translated**: Setze dein Passwort zurück

- **com_auth_click**:
  - **english**: Click
  - **translated**: Klick

- **com_auth_here**:
  - **english**: HERE
  - **translated**: HIER

- **com_auth_to_reset_your_password**:
  - **english**: to reset your password.
  - **translated**: um dein Passwort zurückzusetzen.

- **com_auth_reset_password_link_sent**:
  - **english**: Email Sent
  - **translated**: E-Mail gesendet

- **com_auth_reset_password_email_sent**:
  - **english**: An email has been sent to you with further instructions to reset your password.
  - **translated**: Es wurde eine E-Mail mit weiteren Anweisungen zum Zurücksetzen deines Passworts an dich gesendet.

- **com_auth_error_reset_password**:
  - **english**: There was a problem resetting your password. There was no user found with the email address provided. Please try again.
  - **translated**: Es gab ein Problem beim Zurücksetzen deines Passworts. Es wurde kein Benutzer mit der angegebenen E-Mail Adresse gefunden. Bitte versuche es erneut.

- **com_auth_reset_password_success**:
  - **english**: Password Reset Success
  - **translated**: Passwort zurücksetzen erfolgreich

- **com_auth_login_with_new_password**:
  - **english**: You may now login with your new password.
  - **translated**: Du kannst dich jetzt mit deinem neuen Passwort anmelden.

- **com_auth_error_invalid_reset_token**:
  - **english**: This password reset token is no longer valid.
  - **translated**: Dieses Passwort-Reset-Token ist nicht mehr gültig.

- **com_auth_click_here**:
  - **english**: Click here
  - **translated**: Klicke hier

- **com_auth_to_try_again**:
  - **english**: to try again.
  - **translated**: um es erneut zu versuchen.

- **com_auth_submit_registration**:
  - **english**: Submit registration
  - **translated**: Anmeldung einreichen

- **com_auth_welcome_back**:
  - **english**: Welcome back
  - **translated**: Willkommen zurück

- **com_auth_back_to_login**:
  - **english**: Back to Login
  - **translated**: Zurück zum Login

- **com_endpoint_open_menu**:
  - **english**: Open Menu
  - **translated**: Menü öffnen

- **com_endpoint_bing_enable_sydney**:
  - **english**: Enable Sydney
  - **translated**: Sydney aktivieren

- **com_endpoint_bing_to_enable_sydney**:
  - **english**: To enable Sydney
  - **translated**: Um Sydney zu aktivieren

- **com_endpoint_bing_jailbreak**:
  - **english**: Jailbreak
  - **translated**: Jailbreak

- **com_endpoint_bing_context_placeholder**:
  - **english**: Bing can use up to 7k tokens for 'context', which it can reference for the conversation. The specific limit is not known but may run into errors exceeding 7k tokens
  - **translated**: Bing kann bis zu 7k Token für 'context' verwenden, auf die es in der Konversation Bezug nehmen kann. Der genaue Grenzwert ist nicht bekannt, aber mehr als 7k Token können zu Fehlern führen.

- **com_endpoint_bing_system_message_placeholder**:
  - **english**: WARNING: Misuse of this feature can get you BANNED from using Bing! Click on 'System Message' for full instructions and the default message if omitted, which is the 'Sydney' preset that is considered safe.
  - **translated**: WARNUNG: Der Missbrauch dieser Funktion kann dazu führen, dass du von der Nutzung von Bing ausgeschlossen wirst! Klicken Sie auf 'Systemaufforderung', um vollständige Anweisungen und die Standardnachricht zu erhalten, die als sicher gilt.

- **com_endpoint_system_message**:
  - **english**: System Message
  - **translated**: Systemaufforderung

- **com_endpoint_message**:
  - **english**: Message
  - **translated**: Nachricht an

- **com_endpoint_message_not_appendable**:
  - **english**: Edit your message or Regenerate.
  - **translated**: Bearbeite deine Nachricht oder generiere sie neu.

- **com_endpoint_default_blank**:
  - **english**: default: blank
  - **translated**: Standard: leer

- **com_endpoint_default_false**:
  - **english**: default: false
  - **translated**: Standard: falsch

- **com_endpoint_default_creative**:
  - **english**: default: creative
  - **translated**: Standard: kreativ

- **com_endpoint_default_empty**:
  - **english**: default: empty
  - **translated**: Standard: leer

- **com_endpoint_default_with_num**:
  - **english**: default: {0}
  - **translated**: Standard: {0}

- **com_endpoint_context**:
  - **english**: Context
  - **translated**: Kontext

- **com_endpoint_tone_style**:
  - **english**: Tone Style
  - **translated**: Farbtonstil

- **com_endpoint_token_count**:
  - **english**: Token count
  - **translated**: Token-Anzahl

- **com_endpoint_output**:
  - **english**: Output
  - **translated**: Antwort

- **com_endpoint_google_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: Höhere Werte = zufälliger, während niedrigere Werte = gezielter und deterministischer sind. Wir empfehlen, dies oder Top P zu ändern, aber nicht beides.

- **com_endpoint_google_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p ändert, wie das Modell die Token für die Ausgabe auswählt. Die Token werden von der höchsten K-Wahrscheinlichkeit (siehe topK-Parameter) zur niedrigsten ausgewählt, bis die Summe ihrer Wahrscheinlichkeiten gleich dem top-p-Wert ist.

- **com_endpoint_google_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k ändert, wie das Modell die Token für die Ausgabe auswählt. Ein top-k von 1 bedeutet, dass das ausgewählte Token das wahrscheinlichste unter allen Token im Vokabular des Modells ist (auch gierige Dekodierung genannt), während ein top-k von 3 bedeutet, dass das nächste Token aus den 3 wahrscheinlichsten Token ausgewählt wird (unter Verwendung der Temperatur).

- **com_endpoint_google_maxoutputtokens**:
  - **english**:  	Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**:  Maximale Anzahl von Token, die in der Antwort erzeugt werden können. Gib einen niedrigeren Wert für kürzere Antworten und einen höheren Wert für längere Antworten an.

- **com_endpoint_google_custom_name_placeholder**:
  - **english**: Set a custom name for Google
  - **translated**: Setze einen benutzerdefinierten Namen für Google

- **com_endpoint_prompt_prefix_placeholder**:
  - **english**: Set custom instructions or context. Ignored if empty.
  - **translated**: Setze benutzerdefinierte Anweisungen oder Kontext. Ignoriert, wenn leer.

- **com_endpoint_instructions_assistants_placeholder**:
  - **english**: Overrides the instructions of the assistant. This is useful for modifying the behavior on a per-run basis.
  - **translated**: Setzt die Anweisungen des Assistenten außer Kraft. Dies ist nützlich, um das Verhalten pro Lauf zu ändern.

- **com_endpoint_prompt_prefix_assistants_placeholder**:
  - **english**: Set additional instructions or context on top of the Assistant's main instructions. Ignored if empty.
  - **translated**: Setzt zusätzliche Anweisungen oder Kontext über die Hauptanweisungen des Assistenten. Wird ignoriert, wenn leer.

- **com_endpoint_custom_name**:
  - **english**: Custom Name
  - **translated**: Benutzerdefinierter Name

- **com_endpoint_prompt_prefix**:
  - **english**: Custom Instructions
  - **translated**: Benutzerdefinierte Anweisungen

- **com_endpoint_prompt_prefix_assistants**:
  - **english**: Additional Instructions
  - **translated**: Zusätzliche Anweisungen

- **com_endpoint_instructions_assistants**:
  - **english**: Override Instructions
  - **translated**: Anweisungen überschreiben

- **com_endpoint_temperature**:
  - **english**: Temperature
  - **translated**: Temperatur

- **com_endpoint_default**:
  - **english**: default
  - **translated**: Standard

- **com_endpoint_top_p**:
  - **english**: Top P
  - **translated**: Top-P

- **com_endpoint_top_k**:
  - **english**: Top K
  - **translated**: Top-K

- **com_endpoint_max_output_tokens**:
  - **english**: Max Output Tokens
  - **translated**: Max. Antwort Tokens

- **com_endpoint_openai_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: Höhere Werte = zufälliger, während niedrigere Werte = zielgerichteter und deterministischer sind. Wir empfehlen, dies oder Top P zu ändern, aber nicht beides.

- **com_endpoint_openai_max**:
  - **english**: The max tokens to generate. The total length of input tokens and generated tokens is limited by the model's context length.
  - **translated**: Die maximale Anzahl der zu erzeugenden Token. Die Gesamtlänge der eingegebenen und generierten Token wird durch die Kontextlänge des Modells begrenzt.

- **com_endpoint_openai_topp**:
  - **english**: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We recommend altering this or temperature but not both.
  - **translated**: Eine Alternative zum Sampling mit Temperatur, genannt Nukleus-Sampling, bei dem das Modell die Ergebnisse der Token mit der Wahrscheinlichkeitsmasse top_p berücksichtigt. 0,1 bedeutet also, dass nur die Token mit den obersten 10% Wahrscheinlichkeitsmasse berücksichtigt werden. Wir empfehlen, dies oder die Temperatur zu ändern, aber nicht beides.

- **com_endpoint_openai_freq**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
  - **translated**: Zahl zwischen -2,0 und 2,0. Positive Werte bestrafen neue Token auf der Grundlage ihrer bisherigen Häufigkeit im Text und verringern so die Wahrscheinlichkeit, dass das Model dieselbe Zeile wortwörtlich wiederholt.

- **com_endpoint_openai_pres**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
  - **translated**: Zahl zwischen -2.0 und 2.0. Positive Werte bestrafen neue Token, je nachdem, ob sie bereits im Text vorkommen, und erhöhen so die Wahrscheinlichkeit, dass das Model über neue Themen spricht.

- **com_endpoint_openai_resend**:
  - **english**: Resend all previously attached images. Note: this can significantly increase token cost and you may experience errors with many image attachments.
  - **translated**: Sende alle zuvor angehängten Bilder erneut. Hinweis: Dies kann die Token-Kosten erheblich erhöhen und bei vielen Bildanhängen können Fehler auftreten.

- **com_endpoint_openai_resend_files**:
  - **english**: Resend all previously attached files. Note: this will increase token cost and you may experience errors with many attachments.
  - **translated**: Sende alle zuvor angehängten Dateien erneut. Hinweis: Dies erhöht die Token-Kosten und bei vielen Anhängen kann es zu Fehlern kommen.

- **com_endpoint_openai_detail**:
  - **english**: The resolution for Vision requests. "Low" is cheaper and faster, "High" is more detailed and expensive, and "Auto" will automatically choose between the two based on the image resolution.
  - **translated**: Die Auflösung für Bilderkennungs-Anfragen. "Niedrig" ist billiger und schneller, "Hoch" ist detaillierter und teurer, und "Auto" wählt automatisch zwischen den beiden Auflösungen.

- **com_endpoint_openai_custom_name_placeholder**:
  - **english**: Set a custom name for the AI
  - **translated**: Setzt einen benutzerdefinierten Namen für die KI

- **com_endpoint_openai_prompt_prefix_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: Lege benutzerdefinierte Anweisungen fest, die in die Systemaufforderung aufgenommen werden sollen. Standard: keine

- **com_endpoint_anthropic_temp**:
  - **english**: Ranges from 0 to 1. Use temp closer to 0 for analytical / multiple choice, and closer to 1 for creative and generative tasks. We recommend altering this or Top P but not both.
  - **translated**: Der Bereich reicht von 0 bis 1. Verwende temp näher an 0 für analytische / Multiple Choice Aufgaben und näher an 1 für kreative und generative Aufgaben. Wir empfehlen, dies oder Top P zu ändern, aber nicht beides.

- **com_endpoint_anthropic_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p ändert, wie das Modell die Token für die Ausgabe auswählt. Die Token werden von der höchsten K-Wahrscheinlichkeit (siehe topK-Parameter) zur niedrigsten ausgewählt, bis die Summe ihrer Wahrscheinlichkeiten gleich dem top-p-Wert ist.

- **com_endpoint_anthropic_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k ändert, wie das Modell Token für die Ausgabe auswählt. Ein top-k von 1 bedeutet, dass das ausgewählte Token das wahrscheinlichste unter allen Token im Vokabular des Modells ist (auch greedy decoding genannt), während ein top-k von 3 bedeutet, dass das nächste Token aus den 3 wahrscheinlichsten Token ausgewählt wird (unter Verwendung der Temperatur).

- **com_endpoint_anthropic_maxoutputtokens**:
  - **english**: Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: Maximale Anzahl von Token, die in der Antwort erzeugt werden können. Gib einen niedrigeren Wert für kürzere Antworten und einen höheren Wert für längere Antworten an.

- **com_endpoint_anthropic_custom_name_placeholder**:
  - **english**: Set a custom name for Anthropic
  - **translated**: Lege einen eigenen Namen für Anthropic fest

- **com_endpoint_frequency_penalty**:
  - **english**: Frequency Penalty
  - **translated**: Frequency Penalty

- **com_endpoint_presence_penalty**:
  - **english**: Presence Penalty
  - **translated**: Presence Penalty

- **com_endpoint_plug_use_functions**:
  - **english**: Use Functions
  - **translated**: Funktionen verwenden

- **com_endpoint_plug_resend_files**:
  - **english**: Resend Files
  - **translated**: Dateien erneut senden

- **com_endpoint_plug_resend_images**:
  - **english**: Resend Images
  - **translated**: Bilder erneut senden

- **com_endpoint_plug_image_detail**:
  - **english**: Image Detail
  - **translated**: Bild-Detail

- **com_endpoint_plug_skip_completion**:
  - **english**: Skip Completion
  - **translated**: Fertigstellung überspringen

- **com_endpoint_disabled_with_tools**:
  - **english**: disabled with tools
  - **translated**: Mit Werkzeugen deaktiviert

- **com_endpoint_disabled_with_tools_placeholder**:
  - **english**: Disabled with Tools Selected
  - **translated**: Deaktiviert mit ausgewählten Werkzeugen

- **com_endpoint_plug_set_custom_instructions_for_gpt_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: Setzt benutzerdefinierte Anweisungen, die in die Systemaufforderung aufgenommen werden. Standard: keine

- **com_endpoint_import**:
  - **english**: Import
  - **translated**: Importieren

- **com_endpoint_set_custom_name**:
  - **english**: Set a custom name, in case you can find this preset
  - **translated**: Lege einen benutzerdefinierten Namen fest, für den Fall, dass du diese Vorgabe finden kannst

- **com_endpoint_preset_delete_confirm**:
  - **english**: Are you sure you want to delete this preset?
  - **translated**: Bist du sicher, dass du diese Vorgabe löschen willst?

- **com_endpoint_preset_clear_all_confirm**:
  - **english**: Are you sure you want to delete all of your presets?
  - **translated**: Bist du sicher, dass du alle deine Voreinstellungen löschen willst?

- **com_endpoint_preset_import**:
  - **english**: Preset Imported!
  - **translated**: Voreinstellung importiert!

- **com_endpoint_preset_import_error**:
  - **english**: There was an error importing your preset. Please try again.
  - **translated**: Beim Import deiner Voreinstellung ist ein Fehler aufgetreten. Bitte versuche es erneut.

- **com_endpoint_preset_save_error**:
  - **english**: There was an error saving your preset. Please try again.
  - **translated**: Es ist ein Fehler beim Speichern deiner Voreinstellung aufgetreten. Bitte versuche es noch einmal.

- **com_endpoint_preset_delete_error**:
  - **english**: There was an error deleting your preset. Please try again.
  - **translated**: Beim Löschen deiner Voreinstellung ist ein Fehler aufgetreten. Bitte versuche es noch einmal.

- **com_endpoint_preset_default_removed**:
  - **english**: is no longer the default preset.
  - **translated**: ist nicht mehr die Standardvorgabe.

- **com_endpoint_preset_default_item**:
  - **english**: Default:
  - **translated**: Standard:

- **com_endpoint_preset_default_none**:
  - **english**: No default preset active.
  - **translated**: Keine Standardvoreinstellung aktiv.

- **com_endpoint_preset_title**:
  - **english**: Preset
  - **translated**: Voreinstellung

- **com_endpoint_preset_saved**:
  - **english**: Saved!
  - **translated**: Gespeichert!

- **com_endpoint_preset_default**:
  - **english**: is now the default preset.
  - **translated**: ist jetzt die Standardvoreinstellung.

- **com_endpoint_preset**:
  - **english**: preset
  - **translated**: Voreinstellung

- **com_endpoint_presets**:
  - **english**: presets
  - **translated**: Voreinstellungen

- **com_endpoint_preset_selected**:
  - **english**: Preset Active!
  - **translated**: Voreinstellung aktiv!

- **com_endpoint_preset_selected_title**:
  - **english**: Active!
  - **translated**: Aktiv!

- **com_endpoint_preset_name**:
  - **english**: Preset Name
  - **translated**: Voreinstellungsname

- **com_endpoint_new_topic**:
  - **english**: New Topic
  - **translated**: Neues Thema

- **com_endpoint**:
  - **english**: Endpoint
  - **translated**: Endpunkt

- **com_endpoint_hide**:
  - **english**: Hide
  - **translated**: Ausblenden

- **com_endpoint_show**:
  - **english**: Show
  - **translated**: Anzeigen

- **com_endpoint_examples**:
  - **english**:  Presets
  - **translated**: Voreinstellungen

- **com_endpoint_completion**:
  - **english**: Completion
  - **translated**: Fertigstellung

- **com_endpoint_agent**:
  - **english**: Agent
  - **translated**: Agent

- **com_endpoint_show_what_settings**:
  - **english**: Show {0} Settings
  - **translated**: Zeige {0} Einstellungen

- **com_endpoint_export**:
  - **english**: Export
  - **translated**: Exportieren

- **com_endpoint_assistant**:
  - **english**: Assistant
  - **translated**: Assistent

- **com_endpoint_use_active_assistant**:
  - **english**: Use Active Assistant
  - **translated**: Aktiven Assistenten verwenden

- **com_endpoint_assistant_model**:
  - **english**: Assistant Model
  - **translated**: Assistentenmodell

- **com_endpoint_save_as_preset**:
  - **english**: Save As Preset
  - **translated**: Als Voreinstellung speichern

- **com_endpoint_presets_clear_warning**:
  - **english**: Are you sure you want to clear all presets? This is irreversible.
  - **translated**: Bist du sicher, dass du alle Voreinstellungen löschen willst? Dies ist nicht umkehrbar.

- **com_endpoint_not_implemented**:
  - **english**: Not implemented
  - **translated**: Nicht implementiert

- **com_endpoint_no_presets**:
  - **english**: No presets yet, use the settings button to create one
  - **translated**: Es gibt noch keine Voreinstellungen, verwende die Schaltfläche Einstellungen, um eine zu erstellen

- **com_endpoint_not_available**:
  - **english**: No endpoint available
  - **translated**: Kein Endpunkt verfügbar

- **com_endpoint_view_options**:
  - **english**: View Options
  - **translated**: Ansichtsoptionen

- **com_endpoint_save_convo_as_preset**:
  - **english**: Save Conversation as Preset
  - **translated**: Konversation als Voreinstellung speichern

- **com_endpoint_my_preset**:
  - **english**: My Preset
  - **translated**: Meine Voreinstellung

- **com_endpoint_agent_model**:
  - **english**: Agent Model (Recommended: GPT-3.5)
  - **translated**: Agentenmodell (empfohlen: GPT-3.5)

- **com_endpoint_completion_model**:
  - **english**: Completion Model (Recommended: GPT-4)
  - **translated**: Vervollständigungsmodell (empfohlen: GPT-4-Turbo)

- **com_endpoint_func_hover**:
  - **english**: Enable use of Plugins as OpenAI Functions
  - **translated**: Aktiviere die Verwendung von Plugins als OpenAI-Funktionen

- **com_endpoint_skip_hover**:
  - **english**: Enable skipping the completion step, which reviews the final answer and generated steps
  - **translated**: Aktiviere das Überspringen des Abschlussschritts, der die endgültige Antwort und die generierten Schritte überprüft

- **com_endpoint_config_key**:
  - **english**: Set API Key
  - **translated**: API-Schlüssel festlegen

- **com_endpoint_assistant_placeholder**:
  - **english**: Please select an Assistant from the right-hand Side Panel
  - **translated**: Bitte wähle einen Assistenten aus dem rechter Seitenleiste aus

- **com_endpoint_config_placeholder**:
  - **english**: Set your Key in the Header menu to chat.
  - **translated**: Setze deinen Schlüssel im Header-Menü ein, um zu chatten.

- **com_endpoint_config_key_for**:
  - **english**: Set API Key for
  - **translated**: Setze den API-Schlüssel für

- **com_endpoint_config_key_name**:
  - **english**: Key
  - **translated**: Schlüssel

- **com_endpoint_config_value**:
  - **english**: Enter value for
  - **translated**: Wert eingeben für

- **com_endpoint_config_key_name_placeholder**:
  - **english**: Set API key first
  - **translated**: Setze API-Schlüssel zuerst

- **com_endpoint_config_key_encryption**:
  - **english**: Your key will be encrypted and deleted at
  - **translated**: Dein Schlüssel wird verschlüsselt und gelöscht bei

- **com_endpoint_config_key_expiry**:
  - **english**: the expiry time
  - **translated**: die Verfallszeit

- **com_endpoint_config_click_here**:
  - **english**: Click Here
  - **translated**: Hier klicken

- **com_endpoint_config_google_service_key**:
  - **english**: Google Service Account Key
  - **translated**: Google Service Account Key

- **com_endpoint_config_google_cloud_platform**:
  - **english**: (from Google Cloud Platform)
  - **translated**: (von Google Cloud Platform)

- **com_endpoint_config_google_api_key**:
  - **english**: Google API Key
  - **translated**: Google API Key

- **com_endpoint_config_google_gemini_api**:
  - **english**: (Gemini API)
  - **translated**: (Gemini API)

- **com_endpoint_config_google_api_info**:
  - **english**: To get your Generative Language API key (for Gemini),
  - **translated**: Um deinen Generative Language API-Schlüssel (für Gemini) zu erhalten,

- **com_endpoint_config_key_import_json_key**:
  - **english**: Import Service Account JSON Key.
  - **translated**: Import Service Account JSON Key.

- **com_endpoint_config_key_import_json_key_success**:
  - **english**: Successfully Imported Service Account JSON Key
  - **translated**: Erfolgreich importierter Service Account JSON Key

- **com_endpoint_config_key_import_json_key_invalid**:
  - **english**: Invalid Service Account JSON Key, Did you import the correct file?
  - **translated**: Ungültiger Service Account JSON Key, Hast du die richtige Datei importiert?

- **com_endpoint_config_key_get_edge_key**:
  - **english**: To get your Access token for Bing, login to
  - **translated**: Um dein Access Token für Bing zu erhalten, melde dich an bei

- **com_endpoint_config_key_get_edge_key_dev_tool**:
  - **english**: Use dev tools or an extension while logged into the site to copy the content of the _U cookie. If this fails, follow these
  - **translated**: Verwende Dev-Tools oder eine Erweiterung, während du auf der Website angemeldet bist, um den Inhalt des _U-Cookies zu kopieren. Wenn dies fehlschlägt, befolge die folgenden Anweisungen

- **com_endpoint_config_key_edge_instructions**:
  - **english**: instructions
  - **translated**: Anweisungen

- **com_endpoint_config_key_edge_full_key_string**:
  - **english**: to provide the full cookie strings.
  - **translated**: um die vollständigen Cookie-Strings bereitzustellen.

- **com_endpoint_config_key_chatgpt**:
  - **english**: To get your Access token For ChatGPT 'Free Version', login to
  - **translated**: Um dein Zugangstoken für ChatGPT 'Free Version' zu erhalten, melde dich bei

- **com_endpoint_config_key_chatgpt_then_visit**:
  - **english**: then visit
  - **translated**: dann besuche

- **com_endpoint_config_key_chatgpt_copy_token**:
  - **english**: Copy access token.
  - **translated**: Kopiere das Zugangstoken.

- **com_endpoint_config_key_google_need_to**:
  - **english**: You need to
  - **translated**: Du musst

- **com_endpoint_config_key_google_vertex_ai**:
  - **english**: Enable Vertex AI
  - **translated**: Vertex AI aktivieren

- **com_endpoint_config_key_google_vertex_api**:
  - **english**: API on Google Cloud, then
  - **translated**: API auf Google Cloud, dann

- **com_endpoint_config_key_google_service_account**:
  - **english**: Create a Service Account
  - **translated**: Ein Service-Konto erstellen

- **com_endpoint_config_key_google_vertex_api_role**:
  - **english**: Make sure to click 'Create and Continue' to give at least the 'Vertex AI User' role. Lastly, create a JSON key to import here.
  - **translated**: Stelle sicher, dass du auf 'Erstellen und Fortfahren' klickst, um mindestens die 'Vertex AI User'-Rolle zu vergeben. Erstelle schließlich einen JSON-Schlüssel, den du hier importieren kannst.

- **com_nav_welcome_assistant**:
  - **english**: Please Select an Assistant
  - **translated**: Bitte wähle einen Assistenten

- **com_nav_welcome_message**:
  - **english**: How can I help you today?
  - **translated**: Wie kann ich dir heute helfen?

- **com_nav_auto_scroll**:
  - **english**: Auto-scroll to Newest on Open
  - **translated**: Beim Öffnen automatisch zum Neuesten scrollen

- **com_nav_hide_panel**:
  - **english**: Hide Right-most Side Panel
  - **translated**: Rechtsseitige Seitenleiste ausblenden

- **com_nav_modular_chat**:
  - **english**: Enable switching Endpoints mid-conversation
  - **translated**: Umschalten der Endpunkte während der Konversation aktivieren

- **com_nav_latex_parsing**:
  - **english**: Parsing LaTeX in messages (may affect performance)
  - **translated**: Parsen von LaTeX in Nachrichten (kann die Leistung beeinträchtigen)

- **com_nav_profile_picture**:
  - **english**: Profile Picture
  - **translated**: Profilbild

- **com_nav_change_picture**:
  - **english**: Change picture
  - **translated**: Bild ändern

- **com_nav_plugin_store**:
  - **english**: Plugin store
  - **translated**: Plugin-Store

- **com_nav_plugin_install**:
  - **english**: Install
  - **translated**: Installieren

- **com_nav_plugin_uninstall**:
  - **english**: Uninstall
  - **translated**: Deinstallieren

- **com_ui_add**:
  - **english**: Add
  - **translated**: Hinzufügen

- **com_nav_tool_remove**:
  - **english**: Remove
  - **translated**: Löschen

- **com_nav_tool_dialog**:
  - **english**: Assistant Tools
  - **translated**: Assistententools

- **com_nav_tool_dialog_description**:
  - **english**: Assistant must be saved to persist tool selections.
  - **translated**: Der Assistent muss gespeichert werden, um die Werkzeugauswahl beizubehalten.

- **com_show_agent_settings**:
  - **english**: Show Agent Settings
  - **translated**: Agent-Einstellungen anzeigen

- **com_show_completion_settings**:
  - **english**: Show Completion Settings
  - **translated**: Fertigstellungseinstellungen anzeigen

- **com_hide_examples**:
  - **english**: Hide Examples
  - **translated**: Beispiele ausblenden

- **com_show_examples**:
  - **english**: Show Examples
  - **translated**: Beispiele anzeigen

- **com_nav_plugin_search**:
  - **english**: Search plugins
  - **translated**: Plugins suchen

- **com_nav_tool_search**:
  - **english**: Search tools
  - **translated**: Werkzeuge suchen

- **com_nav_plugin_auth_error**:
  - **english**: There was an error attempting to authenticate this plugin. Please try again.
  - **translated**: Beim Versuch, dieses Plugin zu authentifizieren, ist ein Fehler aufgetreten. Bitte versuche es erneut.

- **com_nav_export_filename**:
  - **english**: Filename
  - **translated**: Dateiname

- **com_nav_export_filename_placeholder**:
  - **english**: Set the filename
  - **translated**: Setze den Dateinamen

- **com_nav_export_type**:
  - **english**: Type
  - **translated**: Typ

- **com_nav_export_include_endpoint_options**:
  - **english**: Include endpoint options
  - **translated**: Endpunktoptionen einbeziehen

- **com_nav_enabled**:
  - **english**: Enabled
  - **translated**: Aktiviert

- **com_nav_not_supported**:
  - **english**: Not Supported
  - **translated**: Nicht unterstützt

- **com_nav_export_all_message_branches**:
  - **english**: Export all message branches
  - **translated**: Alle Nachrichtenzweige exportieren

- **com_nav_export_recursive_or_sequential**:
  - **english**: Recursive or sequential?
  - **translated**: Rekursiv oder sequentiell?

- **com_nav_export_recursive**:
  - **english**: Recursive
  - **translated**: Rekursiv

- **com_nav_export_conversation**:
  - **english**: Export conversation
  - **translated**: Konversation exportieren

- **com_nav_my_files**:
  - **english**: My Files
  - **translated**: Meine Dateien

- **com_nav_theme**:
  - **english**: Theme
  - **translated**: Farbschema

- **com_nav_theme_system**:
  - **english**: System
  - **translated**: System

- **com_nav_theme_dark**:
  - **english**: Dark
  - **translated**: Dunkel

- **com_nav_theme_light**:
  - **english**: Light
  - **translated**: Hell

- **com_nav_user_name_display**:
  - **english**: Display username in messages
  - **translated**: Benutzernamen in Nachrichten anzeigen

- **com_nav_show_code**:
  - **english**: Always show code when using code interpreter
  - **translated**: Code immer anzeigen, wenn Code-Interpreter verwendet wird

- **com_nav_clear_all_chats**:
  - **english**: Clear all chats
  - **translated**: Alle Chats löschen

- **com_nav_confirm_clear**:
  - **english**: Confirm Clear
  - **translated**: Bestätige Löschen

- **com_nav_close_sidebar**:
  - **english**: Close sidebar
  - **translated**: Sidebar schließen

- **com_nav_open_sidebar**:
  - **english**: Open sidebar
  - **translated**: Seitenleiste öffnen

- **com_nav_send_message**:
  - **english**: Send message
  - **translated**: Nachricht senden

- **com_nav_log_out**:
  - **english**: Log out
  - **translated**: Abmelden

- **com_nav_user**:
  - **english**: USER
  - **translated**: NUTZER

- **com_nav_archived_chats**:
  - **english**: Archived chats
  - **translated**: Archivierte Chats

- **com_nav_archived_chats_manage**:
  - **english**: Manage
  - **translated**: Verwalten

- **com_nav_archived_chats_empty**:
  - **english**: You have no archived conversations.
  - **translated**: Keine archivierten Chats

- **com_nav_archive_all_chats**:
  - **english**: Archive all chats
  - **translated**: Alle Chats archivieren

- **com_nav_archive_all**:
  - **english**: Archive all
  - **translated**: Archivieren

- **com_nav_archive_name**:
  - **english**: Name
  - **translated**: Name

- **com_nav_archive_created_at**:
  - **english**: DateCreated
  - **translated**: ErstelltAm

- **com_nav_clear_conversation**:
  - **english**: Clear conversations
  - **translated**: Unterhaltungen löschen

- **com_nav_clear_conversation_confirm_message**:
  - **english**: Are you sure you want to clear all conversations? This is irreversible.
  - **translated**: Bist du sicher, dass du alle Unterhaltungen löschen willst? Dies ist unumkehrbar.

- **com_nav_help_faq**:
  - **english**: Help & FAQ
  - **translated**: Hilfe & FAQ

- **com_nav_settings**:
  - **english**: Settings
  - **translated**: Einstellungen

- **com_nav_search_placeholder**:
  - **english**: Search messages
  - **translated**: Nachrichten suchen

- **com_nav_setting_general**:
  - **english**: General
  - **translated**: Allgemein

- **com_nav_setting_beta**:
  - **english**: Beta features
  - **translated**: Beta-Funktionen

- **com_nav_setting_data**:
  - **english**: Data controls
  - **translated**: Datenkontrollen

- **com_nav_setting_account**:
  - **english**: Account
  - **translated**: Konto

- **com_nav_language**:
  - **english**: Language
  - **translated**: Sprache

Please consider the above comparisons to enhance understanding and guide improvements in translations.

Provide insights or suggestions that could help refine the translation process, focusing on cultural and contextual relevance.

Please craft a prompt that can be used to better inform future translations to this language.

Write this prompt in the translated language, with all its nuances detected, not in the English.
