# Instructions for Translation

Write a prompt that is mindful of the nuances in the language with respect to its English counterpart, which serves as the baseline for translations. Here are the comparisons between the language translations and their English counterparts:


- **com_ui_examples**:
  - **english**: Examples
  - **translated**: أمثلة

- **com_ui_happy_birthday**:
  - **english**: It's my 1st birthday!
  - **translated**: إنه عيد ميلادي الأول!

- **com_ui_new_chat**:
  - **english**: New chat
  - **translated**: دردشة جديدة

- **com_ui_example_quantum_computing**:
  - **english**: Explain quantum computing in simple terms
  - **translated**: شرح الحوسبة الكمومية ببساطة

- **com_ui_example_10_year_old_b_day**:
  - **english**: Got any creative ideas for a 10 year old's birthday?
  - **translated**: هل لديك أفكار إبداعية لعيد ميلاد طفل عمره 10 سنوات؟

- **com_ui_example_http_in_js**:
  - **english**: How do I make an HTTP request in Javascript?
  - **translated**: كيف أقوم بإجراء طلب HTTP في Javascript؟

- **com_ui_capabilities**:
  - **english**: Capabilities
  - **translated**: القدرات

- **com_ui_capability_remember**:
  - **english**: Remembers what user said earlier in the conversation
  - **translated**: يتذكر ما قاله المستخدم في وقت سابق من المحادثة

- **com_ui_capability_correction**:
  - **english**: Allows user to provide follow-up corrections
  - **translated**: يسمح للمستخدم بتقديم تصحيحات لاحقة

- **com_ui_capability_decline_requests**:
  - **english**: Trained to decline inappropriate requests
  - **translated**: تم تدريبه على رفض الطلبات غير المناسبة

- **com_ui_limitations**:
  - **english**: Limitations
  - **translated**: القيود

- **com_ui_limitation_incorrect_info**:
  - **english**: May occasionally generate incorrect information
  - **translated**: قد يولد معلومات غير صحيحة أحيانًا

- **com_ui_limitation_harmful_biased**:
  - **english**: May occasionally produce harmful instructions or biased content
  - **translated**: قد ينتج تعليمات ضارة أو محتوى متحيز أحيانًا

- **com_ui_limitation_limited_2021**:
  - **english**: Limited knowledge of world and events after 2021
  - **translated**: معرفة محدودة بالعالم والأحداث بعد عام 2021

- **com_ui_input**:
  - **english**: Input
  - **translated**: إدخال

- **com_ui_close**:
  - **english**: Close
  - **translated**: إغلاق

- **com_ui_model**:
  - **english**: Model
  - **translated**: النموذج

- **com_ui_select_model**:
  - **english**: Select a model
  - **translated**: اختر نموذجًا

- **com_ui_use_prompt**:
  - **english**: Use prompt
  - **translated**: استخدم الأمر

- **com_ui_prev**:
  - **english**: Prev
  - **translated**: السابق

- **com_ui_next**:
  - **english**: Next
  - **translated**: التالي

- **com_ui_prompt_templates**:
  - **english**: Prompt Templates
  - **translated**: قوالب الأوامر

- **com_ui_hide_prompt_templates**:
  - **english**: Hide Prompt Templates
  - **translated**: إخفاء قوالب الأوامر

- **com_ui_showing**:
  - **english**: Showing
  - **translated**: عرض

- **com_ui_of**:
  - **english**: of
  - **translated**: من

- **com_ui_entries**:
  - **english**: Entries
  - **translated**: الإدخالات

- **com_ui_pay_per_call**:
  - **english**: All AI conversations in one place. Pay per call and not per month
  - **translated**: الذكاء الاصطناعي يمكن ان ينتج اخطاء الرجاء التاكد بنفسك من المعلومات المهمه.

- **com_ui_enter**:
  - **english**: Enter
  - **translated**: أدخل

- **com_ui_submit**:
  - **english**: Submit
  - **translated**: إرسال

- **com_ui_upload_success**:
  - **english**: Successfully uploaded file
  - **translated**: تم تحميل الملف بنجاح

- **com_ui_upload_invalid**:
  - **english**: Invalid file for upload. Must be an image not exceeding 2 MB
  - **translated**: ملف غير صالح للتحميل

- **com_ui_cancel**:
  - **english**: Cancel
  - **translated**: إلغاء

- **com_ui_save**:
  - **english**: Save
  - **translated**: حفظ

- **com_ui_copy_to_clipboard**:
  - **english**: Copy to clipboard
  - **translated**: نسخ إلى الحافظة

- **com_ui_copied_to_clipboard**:
  - **english**: Copied to clipboard
  - **translated**: تم النسخ إلى الحافظة

- **com_ui_regenerate**:
  - **english**: Regenerate
  - **translated**: إعادة توليد

- **com_ui_continue**:
  - **english**: Continue
  - **translated**: استمر

- **com_ui_edit**:
  - **english**: Edit
  - **translated**: تعديل

- **com_ui_success**:
  - **english**: Success
  - **translated**: نجاح

- **com_ui_all**:
  - **english**: all
  - **translated**: الكل

- **com_ui_clear**:
  - **english**: Clear
  - **translated**: مسح

- **com_ui_revoke**:
  - **english**: Revoke
  - **translated**: إلغاء

- **com_ui_revoke_info**:
  - **english**: Revoke all user provided credentials
  - **translated**: إلغاء جميع بيانات الاعتماد المقدمة من المستخدم.

- **com_ui_import_conversation**:
  - **english**: Import
  - **translated**: استيراد

- **com_ui_import_conversation_info**:
  - **english**: Import conversations from a JSON file
  - **translated**: استيراد محادثات من ملف JSON

- **com_ui_import_conversation_success**:
  - **english**: Conversations imported successfully
  - **translated**: تم استيراد المحادثات بنجاح

- **com_ui_import_conversation_error**:
  - **english**: There was an error importing your conversations
  - **translated**: حدث خطأ أثناء استيراد محادثاتك

- **com_ui_confirm_action**:
  - **english**: Confirm Action
  - **translated**: تأكيد الإجراء

- **com_ui_chats**:
  - **english**: chats
  - **translated**: الدردشات

- **com_ui_delete**:
  - **english**: Delete
  - **translated**: حذف

- **com_ui_delete_conversation**:
  - **english**: Delete chat?
  - **translated**: حذف الدردشة؟

- **com_ui_delete_confirm**:
  - **english**: This will delete
  - **translated**: سيتم حذف هذا

- **com_ui_rename**:
  - **english**: Rename
  - **translated**: إعادة تسمية

- **com_ui_archive**:
  - **english**: Archive
  - **translated**: أرشفة

- **com_ui_archive_error**:
  - **english**: Failed to archive conversation
  - **translated**: فشل في أرشفة المحادثة

- **com_ui_unarchive**:
  - **english**: Unarchive
  - **translated**: إلغاء الأرشفة

- **com_ui_unarchive_error**:
  - **english**: Failed to unarchive conversation
  - **translated**: فشل في إلغاء الأرشفة

- **com_ui_more_options**:
  - **english**: More
  - **translated**: المزيد

- **com_auth_error_login**:
  - **english**: Unable to login with the information provided. Please check your credentials and try again.
  - **translated**: تعذر تسجيل الدخول باستخدام المعلومات المقدمة. يرجى التحقق من بيانات الاعتماد الخاصة بك والمحاولة مرة أخرى.

- **com_auth_error_login_rl**:
  - **english**: Too many login attempts in a short amount of time. Please try again later.
  - **translated**: محاولات تسجيل الدخول الكثيرة في فترة زمنية قصيرة. يرجى المحاولة مرة أخرى لاحقًا.

- **com_auth_error_login_ban**:
  - **english**: Your account has been temporarily banned due to violations of our service.
  - **translated**: تم حظر حسابك مؤقتًا بسبب انتهاكات لخدمتنا.

- **com_auth_error_login_server**:
  - **english**: There was an internal server error. Please wait a few moments and try again.
  - **translated**: كان هناك خطأ في الخادم الداخلي. يرجى الانتظار بضع لحظات وحاول مرة أخرى.

- **com_auth_no_account**:
  - **english**: Don't have an account?
  - **translated**: ليس لديك حساب؟

- **com_auth_sign_up**:
  - **english**: Sign up
  - **translated**: سجل الان

- **com_auth_sign_in**:
  - **english**: Sign in
  - **translated**: تسجيل الدخول

- **com_auth_google_login**:
  - **english**: Continue with Google
  - **translated**: تسجيل الدخول بواسطة Google

- **com_auth_facebook_login**:
  - **english**: Continue with Facebook
  - **translated**: تسجيل الدخول بواسطة Facebook

- **com_auth_github_login**:
  - **english**: Continue with Github
  - **translated**: تسجيل الدخول بواسطة Github

- **com_auth_discord_login**:
  - **english**: Continue with Discord
  - **translated**: تسجيل الدخول بواسطة Discord

- **com_auth_email**:
  - **english**: Email
  - **translated**: البريد الإلكتروني

- **com_auth_email_required**:
  - **english**: Email is required
  - **translated**: البريد الإلكتروني مطلوب

- **com_auth_email_min_length**:
  - **english**: Email must be at least 6 characters
  - **translated**: يجب أن يكون البريد الإلكتروني على الأقل 6 أحرف

- **com_auth_email_max_length**:
  - **english**: Email should not be longer than 120 characters
  - **translated**: يجب ألا يزيد البريد الإلكتروني عن 120 حرفًا

- **com_auth_email_pattern**:
  - **english**: You must enter a valid email address
  - **translated**: يجب أن تدخل عنوان بريد إلكتروني صالح

- **com_auth_email_address**:
  - **english**: Email address
  - **translated**: عنوان البريد الإلكتروني

- **com_auth_password**:
  - **english**: Password
  - **translated**: كلمة المرور

- **com_auth_password_required**:
  - **english**: Password is required
  - **translated**: كلمة المرور مطلوبة

- **com_auth_password_min_length**:
  - **english**: Password must be at least 8 characters
  - **translated**: يجب أن تكون كلمة المرور على الأقل 8 أحرف

- **com_auth_password_max_length**:
  - **english**: Password must be less than 128 characters
  - **translated**: يجب أن تكون كلمة المرور أقل من 128 حرفًا

- **com_auth_password_forgot**:
  - **english**: Forgot Password?
  - **translated**: نسيت كلمة المرور؟

- **com_auth_password_confirm**:
  - **english**: Confirm password
  - **translated**: تأكيد كلمة المرور

- **com_auth_password_not_match**:
  - **english**: Passwords do not match
  - **translated**: كلمات المرور لا تتطابق

- **com_auth_continue**:
  - **english**: Continue
  - **translated**: استمر

- **com_auth_create_account**:
  - **english**: Create your account
  - **translated**: أنشئ حسابك

- **com_auth_error_create**:
  - **english**: There was an error attempting to register your account. Please try again.
  - **translated**: كان هناك خطأ في محاولة تسجيل حسابك. يرجى المحاولة مرة أخرى.

- **com_auth_full_name**:
  - **english**: Full name
  - **translated**: الاسم الكامل

- **com_auth_name_required**:
  - **english**: Name is required
  - **translated**: الاسم مطلوب

- **com_auth_name_min_length**:
  - **english**: Name must be at least 3 characters
  - **translated**: يجب أن يكون الاسم على الأقل 3 أحرف

- **com_auth_name_max_length**:
  - **english**: Name must be less than 80 characters
  - **translated**: يجب أن يكون الاسم أقل من 80 حرفًا

- **com_auth_username**:
  - **english**: Username (optional)
  - **translated**: اسم المستخدم (اختياري)

- **com_auth_username_required**:
  - **english**: Username is required
  - **translated**: اسم المستخدم مطلوب

- **com_auth_username_min_length**:
  - **english**: Username must be at least 2 characters
  - **translated**: يجب أن يكون اسم المستخدم على الأقل 2 أحرف

- **com_auth_username_max_length**:
  - **english**: Username must be less than 20 characters
  - **translated**: يجب أن يكون اسم المستخدم أقل من 20 حرفًا

- **com_auth_already_have_account**:
  - **english**: Already have an account?
  - **translated**: هل لديك حساب بالفعل؟

- **com_auth_login**:
  - **english**: Login
  - **translated**: تسجيل الدخول

- **com_auth_reset_password**:
  - **english**: Reset your password
  - **translated**: إعادة تعيين كلمة المرور

- **com_auth_click**:
  - **english**: Click
  - **translated**: انقر

- **com_auth_here**:
  - **english**: HERE
  - **translated**: هنا

- **com_auth_to_reset_your_password**:
  - **english**: to reset your password.
  - **translated**: لإعادة تعيين كلمة المرور الخاصة بك.

- **com_auth_reset_password_link_sent**:
  - **english**: Email Sent
  - **translated**: تم إرسال البريد الإلكتروني

- **com_auth_reset_password_email_sent**:
  - **english**: An email has been sent to you with further instructions to reset your password.
  - **translated**: تم إرسال بريد إلكتروني إليك مع مزيد من التعليمات لإعادة تعيين كلمة المرور الخاصة بك.

- **com_auth_error_reset_password**:
  - **english**: There was a problem resetting your password. There was no user found with the email address provided. Please try again.
  - **translated**: كانت هناك مشكلة في إعادة تعيين كلمة المرور الخاصة بك. لم يتم العثور على مستخدم بالعنوان البريدي الذي تم تقديمه. يرجى المحاولة مرة أخرى.

- **com_auth_reset_password_success**:
  - **english**: Password Reset Success
  - **translated**: نجاح إعادة تعيين كلمة المرور

- **com_auth_login_with_new_password**:
  - **english**: You may now login with your new password.
  - **translated**: يمكنك الآن تسجيل الدخول باستخدام كلمة المرور الجديدة الخاصة بك.

- **com_auth_error_invalid_reset_token**:
  - **english**: This password reset token is no longer valid.
  - **translated**: رمز إعادة تعيين كلمة المرور هذا لم يعد صالحًا.

- **com_auth_click_here**:
  - **english**: Click here
  - **translated**: انقر هنا

- **com_auth_to_try_again**:
  - **english**: to try again.
  - **translated**: للمحاولة مرة أخرى.

- **com_auth_submit_registration**:
  - **english**: Submit registration
  - **translated**: إرسال التسجيل

- **com_auth_welcome_back**:
  - **english**: Welcome back
  - **translated**: مرحبا بك مرة أخرى

- **com_endpoint_open_menu**:
  - **english**: Open Menu
  - **translated**: افتح القائمة

- **com_endpoint_bing_enable_sydney**:
  - **english**: Enable Sydney
  - **translated**: تمكين سيدني

- **com_endpoint_bing_to_enable_sydney**:
  - **english**: To enable Sydney
  - **translated**: لتمكين سيدني

- **com_endpoint_bing_jailbreak**:
  - **english**: Jailbreak
  - **translated**: الهروب من السجن

- **com_endpoint_bing_context_placeholder**:
  - **english**: Bing can use up to 7k tokens for 'context', which it can reference for the conversation. The specific limit is not known but may run into errors exceeding 7k tokens
  - **translated**: يمكن أن يستخدم بينغ ما يصل إلى 7 آلاف رمز لـ 'السياق'، والذي يمكنه الرجوع إليه للمحادثة. الحد الخاص ليس معروفًا ولكن قد يواجه أخطاء تجاوز 7 آلاف رمز

- **com_endpoint_bing_system_message_placeholder**:
  - **english**: WARNING: Misuse of this feature can get you BANNED from using Bing! Click on 'System Message' for full instructions and the default message if omitted, which is the 'Sydney' preset that is considered safe.
  - **translated**: تحذير: يمكن أن يؤدي سوء استخدام هذه الميزة إلى حظرك من استخدام Bing! انقر على 'رسالة النظام' للحصول على التعليمات الكاملة والرسالة الافتراضية إذا تم حذفها، والتي هي الإعداد المسبق 'سيدني' الذي يعتبر آمنًا.

- **com_endpoint_system_message**:
  - **english**: System Message
  - **translated**: رسالة النظام

- **com_endpoint_default_blank**:
  - **english**: default: blank
  - **translated**: الافتراضي: فارغ

- **com_endpoint_default_false**:
  - **english**: default: false
  - **translated**: الافتراضي: خاطئ

- **com_endpoint_default_creative**:
  - **english**: default: creative
  - **translated**: الافتراضي: إبداعي

- **com_endpoint_default_empty**:
  - **english**: default: empty
  - **translated**: الافتراضي: فارغ

- **com_endpoint_default_with_num**:
  - **english**: default: {0}
  - **translated**: الافتراضي: {0}

- **com_endpoint_context**:
  - **english**: Context
  - **translated**: السياق

- **com_endpoint_tone_style**:
  - **english**: Tone Style
  - **translated**: نمط النبرة

- **com_endpoint_token_count**:
  - **english**: Token count
  - **translated**: عدد الرموز

- **com_endpoint_output**:
  - **english**: Output
  - **translated**: الإخراج

- **com_endpoint_google_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: القيم الأعلى = أكثر عشوائية، بينما القيم الأقل = أكثر تركيزًا وحتمية. نوصي بتغيير هذا أو Top P ولكن ليس كلاهما.

- **com_endpoint_google_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p يغير كيفية اختيار النموذج للرموز للإخراج. يتم اختيار الرموز من الأكثر K (انظر معلمة topK) احتمالًا إلى   الأقل حتى يصبح مجموع احتمالاتهم يساوي قيمة top-p.

- **com_endpoint_google_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: Top-k يغير كيفية اختيار النموذج للرموز للإخراج. top-k من 1 يعني أن الرمز المحدد هو الأكثر احتمالية بين جميع   الرموز في مفردات النموذج (يسمى أيضًا الترميز الجشعي)، بينما top-k من 3 يعني أن الرمز التالي يتم اختياره من بين الرموز الثلاثة الأكثر احتمالية (باستخدام الحرارة).

- **com_endpoint_google_maxoutputtokens**:
  - **english**:  	Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: الحد الأقصى لعدد الرموز التي يمكن إنشاؤها في الرد. حدد قيمة أقل للردود الأقصر وقيمة أعلى للردود الأطول.

- **com_endpoint_google_custom_name_placeholder**:
  - **english**: Set a custom name for Google
  - **translated**: قم بتعيين اسم مخصص لـ Google

- **com_endpoint_prompt_prefix_placeholder**:
  - **english**: Set custom instructions or context. Ignored if empty.
  - **translated**: قم بتعيين تعليمات مخصصة أو سياق. يتم تجاهله إذا كان فارغًا.

- **com_endpoint_custom_name**:
  - **english**: Custom Name
  - **translated**: اسم مخصص

- **com_endpoint_prompt_prefix**:
  - **english**: Custom Instructions
  - **translated**: بادئة الأمر

- **com_endpoint_temperature**:
  - **english**: Temperature
  - **translated**: درجة الحرارة

- **com_endpoint_default**:
  - **english**: default
  - **translated**: الافتراضي

- **com_endpoint_top_p**:
  - **english**: Top P
  - **translated**: أعلى P

- **com_endpoint_top_k**:
  - **english**: Top K
  - **translated**: أعلى K

- **com_endpoint_max_output_tokens**:
  - **english**: Max Output Tokens
  - **translated**: الحد الأقصى لعدد الرموز المنتجة

- **com_endpoint_openai_temp**:
  - **english**: Higher values = more random, while lower values = more focused and deterministic. We recommend altering this or Top P but not both.
  - **translated**: القيم الأعلى = أكثر عشوائية ، بينما القيم الأقل = أكثر تركيزًا وتحديدًا. نوصي بتغيير هذا أو Top P ولكن ليس كلاهما.

- **com_endpoint_openai_max**:
  - **english**: The max tokens to generate. The total length of input tokens and generated tokens is limited by the model's context length.
  - **translated**: الحد الأقصى للرموز لتوليد. إجمالي طول الرموز المدخلة والرموز المولدة محدود بطول سياق النموذج.

- **com_endpoint_openai_topp**:
  - **english**: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We recommend altering this or temperature but not both.
  - **translated**: بديل للعينة مع درجة الحرارة، يسمى العينة النووية، حيث ينظر النموذج في نتائج الرموز مع كتلة احتمال top_p. لذا 0.1 يعني أن الرموز التي تشكل فقط 10% من كتلة الاحتمال تعتبر. نوصي بتغيير هذا أو درجة الحرارة ولكن ليس كلاهما.

- **com_endpoint_openai_freq**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
  - **translated**: رقم بين -2.0 و 2.0. القيم الموجبة تعاقب الرموز الجديدة بناءً على تكرارها الحالي في النص حتى الآن، مما يقلل من احتمالية تكرار النموذج لنفس السطر حرفيًا.

- **com_endpoint_openai_pres**:
  - **english**: Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
  - **translated**: رقم بين -2.0 و 2.0. القيم الموجبة تعاقب الرموز الجديدة بناءً على ما إذا كانت تظهر في النص حتى الآن، مما يزيد احتمالية النموذج للحديث عن مواضيع جديدة.

- **com_endpoint_openai_custom_name_placeholder**:
  - **english**: Set a custom name for the AI
  - **translated**: قم بتعيين اسم مخصص لـ ChatGPT

- **com_endpoint_openai_prompt_prefix_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: قم بتعيين تعليمات مخصصة لتضمينها في رسالة النظام. الافتراضي: لا شيء

- **com_endpoint_anthropic_temp**:
  - **english**: Ranges from 0 to 1. Use temp closer to 0 for analytical / multiple choice, and closer to 1 for creative and generative tasks. We recommend altering this or Top P but not both.
  - **translated**: المدى من 0 إلى 1. استخدم درجة الحرارة الأقرب إلى 0 للمهام التحليلية / اختيارية متعددة، وأقرب إلى 1 للمهام الإبداعية والإنشائية. نوصي بتغيير هذا أو Top P ولكن ليس كلاهما.

- **com_endpoint_anthropic_topp**:
  - **english**: Top-p changes how the model selects tokens for output. Tokens are selected from most K (see topK parameter) probable to least until the sum of their probabilities equals the top-p value.
  - **translated**: Top-p يغير الطريقة التي يختار فيها النموذج الرموز للإخراج. يتم اختيار الرموز من الأكثر احتمالية k (انظر المعلمة topK) إلى الأقل حتى يساوي مجموع احتمالاتهم قيمة top-p.

- **com_endpoint_anthropic_topk**:
  - **english**: Top-k changes how the model selects tokens for output. A top-k of 1 means the selected token is the most probable among all tokens in the model's vocabulary (also called greedy decoding), while a top-k of 3 means that the next token is selected from among the 3 most probable tokens (using temperature).
  - **translated**: يغير top-k الطريقة التي يختار فيها النموذج الرموز للإخراج. يعني top-k 1 أن الرمز المحدد هو الأكثر احتمالية من بين جميع الرموز في المفردات النموذجية (يسمى أيضا الترميز الطمع)، بينما يعني top-k من 3 أن الرمز القادم محدد من بين الرموز الثلاثة الأكثر احتمالية (باستخدام درجة الحرارة).

- **com_endpoint_anthropic_maxoutputtokens**:
  - **english**: Maximum number of tokens that can be generated in the response. Specify a lower value for shorter responses and a higher value for longer responses.
  - **translated**: العدد الأقصى من الرموز التي يمكن إنشاؤها في الرد. حدد قيمة أقل للحصول على ردود أقصر وقيمة أعلى للحصول على ردود أطول.

- **com_endpoint_anthropic_custom_name_placeholder**:
  - **english**: Set a custom name for Anthropic
  - **translated**: قم بتعيين اسم مخصص لـ Anthropic

- **com_endpoint_frequency_penalty**:
  - **english**: Frequency Penalty
  - **translated**: عقوبة التكرار

- **com_endpoint_presence_penalty**:
  - **english**: Presence Penalty
  - **translated**: عقوبة الوجود

- **com_endpoint_plug_use_functions**:
  - **english**: Use Functions
  - **translated**: استخدام الوظائف

- **com_endpoint_plug_skip_completion**:
  - **english**: Skip Completion
  - **translated**: تجاوز الإكمال

- **com_endpoint_disabled_with_tools**:
  - **english**: disabled with tools
  - **translated**: معطل بواسطة الأدوات

- **com_endpoint_disabled_with_tools_placeholder**:
  - **english**: Disabled with Tools Selected
  - **translated**: تم التعطيل باختيار الأدوات

- **com_endpoint_plug_set_custom_instructions_for_gpt_placeholder**:
  - **english**: Set custom instructions to include in System Message. Default: none
  - **translated**: قم بتعيين تعليمات مخصصة لتضمينها في رسالة النظام. الافتراضي: لا شيء

- **com_endpoint_import**:
  - **english**: Import
  - **translated**: استيراد

- **com_endpoint_set_custom_name**:
  - **english**: Set a custom name, in case you can find this preset
  - **translated**: قم بتعيين اسم مخصص، في حالة إمكانية العثور على هذا الإعداد المسبق

- **com_endpoint_preset**:
  - **english**: preset
  - **translated**: إعداد مسبق

- **com_endpoint_presets**:
  - **english**: presets
  - **translated**: إعدادات مسبقة

- **com_endpoint_preset_name**:
  - **english**: Preset Name
  - **translated**: اسم الإعداد المسبق

- **com_endpoint_new_topic**:
  - **english**: New Topic
  - **translated**: موضوع جديد

- **com_endpoint**:
  - **english**: Endpoint
  - **translated**: نقطة النهاية

- **com_endpoint_hide**:
  - **english**: Hide
  - **translated**: إخفاء

- **com_endpoint_show**:
  - **english**: Show
  - **translated**: إظهار

- **com_endpoint_examples**:
  - **english**:  Presets
  - **translated**: الإعدادات المسبقة 

- **com_endpoint_completion**:
  - **english**: Completion
  - **translated**: إكمال

- **com_endpoint_agent**:
  - **english**: Agent
  - **translated**: الوكيل

- **com_endpoint_show_what_settings**:
  - **english**: Show {0} Settings
  - **translated**: إظهار {0} الإعدادات

- **com_endpoint_export**:
  - **english**: Export
  - **translated**: تصدير

- **com_endpoint_save_as_preset**:
  - **english**: Save As Preset
  - **translated**: حفظ كإعداد مسبق

- **com_endpoint_presets_clear_warning**:
  - **english**: Are you sure you want to clear all presets? This is irreversible.
  - **translated**: هل أنت متأكد أنك تريد مسح جميع الإعدادات المسبقة؟ هذا لا يمكن التراجع عنه.

- **com_endpoint_not_implemented**:
  - **english**: Not implemented
  - **translated**: لم يتم تنفيذه

- **com_endpoint_no_presets**:
  - **english**: No presets yet, use the settings button to create one
  - **translated**: لا يوجد إعداد مسبق بعد

- **com_endpoint_not_available**:
  - **english**: No endpoint available
  - **translated**: لا توجد نقطة نهاية متاحة

- **com_endpoint_view_options**:
  - **english**: View Options
  - **translated**: عرض الخيارات

- **com_endpoint_save_convo_as_preset**:
  - **english**: Save Conversation as Preset
  - **translated**: حفظ المحادثة كإعداد مسبق

- **com_endpoint_my_preset**:
  - **english**: My Preset
  - **translated**: الإعداد المسبق الخاص بي

- **com_endpoint_agent_model**:
  - **english**: Agent Model (Recommended: GPT-3.5)
  - **translated**: نموذج الوكيل (موصى به: GPT-3.5)

- **com_endpoint_completion_model**:
  - **english**: Completion Model (Recommended: GPT-4)
  - **translated**: نموذج الإكمال (موصى به: GPT-4)

- **com_endpoint_func_hover**:
  - **english**: Enable use of Plugins as OpenAI Functions
  - **translated**: تمكين استخدام الإضافات كوظائف OpenAI

- **com_endpoint_skip_hover**:
  - **english**: Enable skipping the completion step, which reviews the final answer and generated steps
  - **translated**: تمكين تجاوز خطوة الإكمال التي تقوم بمراجعة الإجابة النهائية والخطوات المولدة

- **com_endpoint_config_key**:
  - **english**: Set API Key
  - **translated**: تعيين مفتاح API

- **com_endpoint_config_key_for**:
  - **english**: Set API Key for
  - **translated**: ضع API Key لـ

- **com_endpoint_config_key_name**:
  - **english**: Key
  - **translated**: مفتـاح

- **com_endpoint_config_value**:
  - **english**: Enter value for
  - **translated**: أدخل القيمة لـ

- **com_endpoint_config_key_name_placeholder**:
  - **english**: Set API key first
  - **translated**: قم بتعيين مفتاح API أولاً

- **com_endpoint_config_key_encryption**:
  - **english**: Your key will be encrypted and deleted at
  - **translated**: سيتم تشفير مفتاحك وحذفه في

- **com_endpoint_config_key_expiry**:
  - **english**: the expiry time
  - **translated**: وقت الانتهاء

- **com_endpoint_config_key_import_json_key**:
  - **english**: Import Service Account JSON Key.
  - **translated**: استيراد مفتاح حساب الخدمة JSON.

- **com_endpoint_config_key_import_json_key_success**:
  - **english**: Successfully Imported Service Account JSON Key
  - **translated**: تم استيراد مفتاح حساب الخدمة JSON بنجاح

- **com_endpoint_config_key_import_json_key_invalid**:
  - **english**: Invalid Service Account JSON Key, Did you import the correct file?
  - **translated**: مفتاح حساب الخدمة JSON غير صالح، هل قمت باستيراد الملف الصحيح؟

- **com_endpoint_config_key_get_edge_key**:
  - **english**: To get your Access token for Bing, login to
  - **translated**: للحصول على رمز الوصول الخاص بك لـ Bing، قم بتسجيل الدخول إلى

- **com_endpoint_config_key_get_edge_key_dev_tool**:
  - **english**: Use dev tools or an extension while logged into the site to copy the content of the _U cookie. If this fails, follow these
  - **translated**: استخدم أدوات المطور أو ملحق أثناء تسجيل الدخول إلى الموقع لنسخ محتوى ألـ_U cookie. إذا فشل هذا، اتبع هذه

- **com_endpoint_config_key_edge_instructions**:
  - **english**: instructions
  - **translated**: التعليمات

- **com_endpoint_config_key_edge_full_key_string**:
  - **english**: to provide the full cookie strings.
  - **translated**:  لتقديم سلاسل كاملة للكوكيز.

- **com_endpoint_config_key_chatgpt**:
  - **english**: To get your Access token For ChatGPT 'Free Version', login to
  - **translated**: للحصول على رمز الوصول الخاص بـ ChatGPT إصدار مجاني، قم بتسجيل الدخول إلى

- **com_endpoint_config_key_chatgpt_then_visit**:
  - **english**: then visit
  - **translated**: ثم قم بزيارة

- **com_endpoint_config_key_chatgpt_copy_token**:
  - **english**: Copy access token.
  - **translated**: نسخ رمز الوصول.

- **com_endpoint_config_key_google_need_to**:
  - **english**: You need to
  - **translated**: أنت بحاجة إلى

- **com_endpoint_config_key_google_vertex_ai**:
  - **english**: Enable Vertex AI
  - **translated**: تمكين Vertex AI

- **com_endpoint_config_key_google_vertex_api**:
  - **english**: API on Google Cloud, then
  - **translated**: API على Google Cloud، ثم

- **com_endpoint_config_key_google_service_account**:
  - **english**: Create a Service Account
  - **translated**: أنشئ حساب خدمة

- **com_endpoint_config_key_google_vertex_api_role**:
  - **english**: Make sure to click 'Create and Continue' to give at least the 'Vertex AI User' role. Lastly, create a JSON key to import here.
  - **translated**: تأكد من النقر على إنشاء ومتابعة" لمنح الدور "Vertex AI User" على الأقل. أخيرًا، قم بإنشاء مفتاح JSON للعمل على استيراده هنا.

- **com_nav_auto_scroll**:
  - **english**: Auto-scroll to Newest on Open
  - **translated**: التمرير التلقائي إلى أحدث عند الفتح

- **com_nav_plugin_store**:
  - **english**: Plugin store
  - **translated**: متجر الإضافات

- **com_nav_plugin_search**:
  - **english**: Search plugins
  - **translated**: ابحث عن الإضافات

- **com_nav_plugin_auth_error**:
  - **english**: There was an error attempting to authenticate this plugin. Please try again.
  - **translated**: حدث خطأ أثناء محاولة المصادقة على هذا البرنامج المساعد. يرجى المحاولة مرة أخرى.

- **com_nav_export_filename**:
  - **english**: Filename
  - **translated**: اسم الملف

- **com_nav_export_filename_placeholder**:
  - **english**: Set the filename
  - **translated**: قم بتعيين اسم الملف

- **com_nav_export_type**:
  - **english**: Type
  - **translated**: النوع

- **com_nav_export_include_endpoint_options**:
  - **english**: Include endpoint options
  - **translated**: تضمين خيارات النقاط النهائية

- **com_nav_enabled**:
  - **english**: Enabled
  - **translated**: تم التمكين

- **com_nav_not_supported**:
  - **english**: Not Supported
  - **translated**: غير مدعوم

- **com_nav_export_all_message_branches**:
  - **english**: Export all message branches
  - **translated**: تصدير كل فروع الرسائل

- **com_nav_export_recursive_or_sequential**:
  - **english**: Recursive or sequential?
  - **translated**: التراجع أو التسلسل؟

- **com_nav_export_recursive**:
  - **english**: Recursive
  - **translated**: تكراري

- **com_nav_export_conversation**:
  - **english**: Export conversation
  - **translated**: تصدير المحادثة

- **com_nav_theme**:
  - **english**: Theme
  - **translated**: المظهر

- **com_nav_theme_system**:
  - **english**: System
  - **translated**: النظام

- **com_nav_theme_dark**:
  - **english**: Dark
  - **translated**: داكن

- **com_nav_theme_light**:
  - **english**: Light
  - **translated**: فاتح

- **com_nav_clear_all_chats**:
  - **english**: Clear all chats
  - **translated**: مسح كل الدردشات

- **com_nav_confirm_clear**:
  - **english**: Confirm Clear
  - **translated**: تأكيد المسح

- **com_nav_close_sidebar**:
  - **english**: Close sidebar
  - **translated**: إغلاق القائمة الجانبية

- **com_nav_open_sidebar**:
  - **english**: Open sidebar
  - **translated**: افتح القائمة الجانبية

- **com_nav_log_out**:
  - **english**: Log out
  - **translated**: تسجيل الخروج

- **com_nav_user**:
  - **english**: USER
  - **translated**: المستخدم

- **com_nav_archived_chats**:
  - **english**: Archived chats
  - **translated**: الدردشات المؤرشفة

- **com_nav_archived_chats_manage**:
  - **english**: Manage
  - **translated**: إدارة

- **com_nav_archived_chats_empty**:
  - **english**: You have no archived conversations.
  - **translated**: ليس لديك أي دردشات مؤرشفة.

- **com_nav_archive_all_chats**:
  - **english**: Archive all chats
  - **translated**: الأرشفة على كل الدردشات

- **com_nav_archive_all**:
  - **english**: Archive all
  - **translated**: الأرشفة على كل الدردشات

- **com_nav_archive_name**:
  - **english**: Name
  - **translated**: الاسم

- **com_nav_archive_created_at**:
  - **english**: DateCreated
  - **translated**: تاريخ الإنشاء

- **com_nav_clear_conversation**:
  - **english**: Clear conversations
  - **translated**: مسح المحادثات

- **com_nav_clear_conversation_confirm_message**:
  - **english**: Are you sure you want to clear all conversations? This is irreversible.
  - **translated**: هل أنت متأكد أنك تريد مسح جميع المحادثات؟ هذا لا يمكن التراجع عنه.

- **com_nav_help_faq**:
  - **english**: Help & FAQ
  - **translated**: مساعدة & الأسئلة الشائعة

- **com_nav_settings**:
  - **english**: Settings
  - **translated**: الإعدادات

- **com_nav_search_placeholder**:
  - **english**: Search messages
  - **translated**: بحث في الرسائل

- **com_nav_setting_general**:
  - **english**: General
  - **translated**: عام

- **com_nav_setting_data**:
  - **english**: Data controls
  - **translated**: تحكم في البيانات

Please consider the above comparisons to enhance understanding and guide improvements in translations.

Provide insights or suggestions that could help refine the translation process, focusing on cultural and contextual relevance.

Please craft a prompt that can be used to better inform future translations to this language.

Write this prompt in the translated language, with all its nuances detected, not in the English.
