import { cn } from '~/utils';
export default function PaLMinimalIcon({ className = '' }: { className?: string }) {
  return (
    <svg
      stroke="currentColor"
      fill="none"
      strokeWidth="1"
      viewBox="0 0 32 32"
      strokeLinecap="round"
      strokeLinejoin="round"
      className={cn('h-4 w-4', className)}
      height="1em"
      width="1em"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path d="m16 30.238c1.2298 0 2.2259-0.99608 2.2259-2.2259v-11.46c-0.63513-0.56429-1.6553-1.6805-2.2259-2.251-0.79858 0.83793-1.3599 1.3599-2.2259 2.251v11.46c0 1.2298 0.99608 2.2259 2.2259 2.2259z" />
      <path d="m24.868 15.761c-0.61691-0.61643-1.3121-1.1065-2.0536-1.4703-6.8147 0.010467 0.13304 0.031026-6.8147 0.010467l9.5286 9.5286c0.39324 0.39324 1.0703 0.23743 1.2372-0.29122 0.83841-2.6544 0.20589-5.6723-1.8976-7.7776z" />
      <path d="m7.1318 15.761c0.5902-0.58975 1.2521-1.0639 1.9575-1.4224 6.9107-0.037427-0.11812-0.057288 6.9107-0.037427l-9.5286 9.5286c-0.39324 0.39324-1.0703 0.23743-1.2372-0.29122-0.83841-2.6543-0.20589-5.6723 1.8976-7.7776z" />
      <path d="m24.162 8.3655c-0.93169 0-1.8288 0.15009-2.6691 0.42772-5.4924 5.5079 0 0-5.4924 5.5079h15.069c0.61767 0 1.0295-0.65292 0.74938-1.2038-1.432-2.8102-4.3219-4.7318-7.657-4.7318z" />
      <path d="m17.575 4.333c-0.62613 0.62613-1.1343 1.3257-1.5248 2.0718 1.6767 4.1174 0.53518 6.3909-0.05003 7.8964l10.656-10.656c0.43775-0.43775 0.2671-1.1908-0.3209-1.3819-3.0012-0.97382-6.4031-0.28751-8.7607 2.0701z" />
      <path d="m14.425 4.333c2.6822 2.6822 3.1997 6.7129 1.5748 9.9682l-10.656-10.656c-0.43775-0.43775-0.2671-1.1908 0.3209-1.3819 3.0012-0.97382 6.4031-0.28751 8.7607 2.0701z" />
      <path d="m7.8385 8.3655c0.9121 0 1.791 0.14385 2.616 0.41037 5.5455 5.5253-0.061773 0.011675 5.5455 5.5253h-15.069c-0.61768 0-1.0295-0.65292-0.74938-1.2038 1.432-2.8102 4.3219-4.7318 7.657-4.7318z" />
    </svg>
  );
}
