import React from 'react';
import { cn } from '~/utils/';

export default function BirthdayIcon({ className = '' }) {
  return (
    <svg
      version="1.1"
      viewBox="0 0 233.33 290"
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      className={cn('h-11 w-11', className)}
    >
      <defs>
        <linearGradient
          id="linearGradient1842"
          x1="163.92"
          x2="173.66"
          y1="22.212"
          y2="-6.5784"
          gradientTransform="translate(.10391 .050143)"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#640a62" offset="0" />
          <stop stopColor="#852283" offset=".49917" />
          <stop stopColor="#640a62" offset="1" />
        </linearGradient>
      </defs>
      <g>
        <path
          transform="matrix(.43416 .90084 -.89966 .4366 0 0)"
          d="m259.29-126.03a232.2 237.56 0 0 1-17.412 231.34l-193.32-131.59z"
          fill="url(#linearGradient1842)"
        />
        <path
          transform="matrix(.6967 .051926 -.051926 .6967 35.578 23.196)"
          d="m50.818 31.415c-1.4654 2.4749-10.838 2.4195-12.997 4.3204-2.1584 1.9009-3.288 11.206-5.9282 12.347-2.6402 1.1409-10.191-4.4132-13.054-4.1441-2.8636 0.26917-9.2466 7.133-12.053 6.5041-2.8066-0.62889-5.6503-9.5602-8.1252-11.026-2.4749-1.4654-11.673 0.33572-13.574-1.8227s1.0482-11.056-0.0927-13.696c-1.1409-2.6402-9.6412-6.5898-9.9104-9.4533-0.26917-2.8636 7.3463-8.328 7.9752-11.135 0.62889-2.8066-3.9265-10.998-2.4612-13.473 1.4654-2.4749 10.838-2.4195 12.997-4.3204 2.1584-1.9009 3.288-11.206 5.9282-12.347 2.6402-1.1409 10.191 4.4132 13.054 4.1441 2.8636-0.26917 9.2466-7.133 12.053-6.5041 2.8066 0.62889 5.6503 9.5602 8.1252 11.026s11.673-0.33572 13.574 1.8227c1.9009 2.1584-1.0482 11.056 0.0927 13.696 1.1409 2.6402 9.6412 6.5898 9.9104 9.4533 0.26917 2.8635-7.3463 8.328-7.9752 11.135-0.62889 2.8066 3.9265 10.998 2.4612 13.473z"
          fill="#ff9d78"
          stroke="#f29472"
          strokeWidth="4.7877"
        />
        <circle cx="170.36" cy="215.76" r="12.903" fill="#cfffff" />
        <path
          d="m220.77 174.77c-88.526 101.03-191.21 85.731-209.5 82.142-2.2101-2e-5 -2.6686 0.42426-3.437 2.0021l-1.7042 7.5028c0.056197 2.3603 0.37544 2.6428 1.9121 3.5409 18.396 3.3746 130.27 19.488 223.46-86.881 0.64011-1.5095 0.46653-3.1324-0.59137-4.7337l-5.1558-3.6482c-1.586-0.8743-3.9524-0.94332-4.9837 0.0751z"
          color="#000000"
          fill="#ff9d78"
          stroke="#f29472"
          strokeLinejoin="round"
          strokeWidth="2.8913"
        />
        <g fill="#cfffff">
          <circle cx="72.684" cy="99.47" r="12.903" />
          <circle cx="99.144" cy="172.32" r="12.903" />
          <circle cx="59.617" cy="214.78" r="12.903" />
          <circle cx="135.4" cy="118.42" r="12.903" />
          <path
            transform="rotate(38.66)"
            d="m254.21-1.9608a12.903 12.903 0 0 1-6.4852 11.194 12.903 12.903 0 0 1-12.937-0.0582 12.903 12.903 0 0 1-6.3843-11.252l12.903 0.1161z"
          />
          <path d="m29.476 158.16a12.903 12.903 0 0 0-3.6562 0.5293l-3.3691 23.189a12.903 12.903 0 0 0 7.0254 2.0879 12.903 12.903 0 0 0 12.904-12.904 12.903 12.903 0 0 0-12.904-12.902z" />
        </g>
      </g>
    </svg>
  );
}
