import { cn } from '~/utils';

export default function BedrockIcon({
  size = 25,
  className = '',
}: {
  size?: number;
  className?: string;
}) {
  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      xmlns="http://www.w3.org/2000/svg"
      className={cn('fill-current text-black', className)}
    >
      <g fill="currentColor">
        <path d="M12,18.1397014 L9.574,18.9487014 L8.628,18.3177014 L9.658,17.9737014 L9.342,17.0257014 L7.574,17.6147014 L7,17.2327014 L7,14.4997014 C7,14.3107014 6.893,14.1377014 6.724,14.0527014 L5,13.1907014 L5,10.8087014 L6.5,10.0587014 L8,10.8087014 L8,12.4997014 C8,12.6897014 8.107,12.8627014 8.276,12.9477014 L10.276,13.9477014 L10.724,13.0527014 L9,12.1907014 L9,10.8087014 L10.724,9.94770136 C10.893,9.86270136 11,9.68970136 11,9.49970136 L11,7.99970136 L10,7.99970136 L10,9.19070136 L8.5,9.94070136 L7,9.19070136 L7,6.76770136 L8,6.10070136 L8,7.99970136 L9,7.99970136 L9,5.43470136 L9.574,5.05170136 L12,5.86070136 L12,18.1397014 Z M17.5,16.9997014 C17.775,16.9997014 18,17.2237014 18,17.4997014 C18,17.7757014 17.775,17.9997014 17.5,17.9997014 C17.225,17.9997014 17,17.7757014 17,17.4997014 C17,17.2237014 17.225,16.9997014 17.5,16.9997014 L17.5,16.9997014 Z M16.5,5.99970136 C16.775,5.99970136 17,6.22370136 17,6.49970136 C17,6.77570136 16.775,6.99970136 16.5,6.99970136 C16.225,6.99970136 16,6.77570136 16,6.49970136 C16,6.22370136 16.225,5.99970136 16.5,5.99970136 L16.5,5.99970136 Z M18.5,11.9997014 C18.775,11.9997014 19,12.2237014 19,12.4997014 C19,12.7757014 18.775,12.9997014 18.5,12.9997014 C18.225,12.9997014 18,12.7757014 18,12.4997014 C18,12.2237014 18.225,11.9997014 18.5,11.9997014 L18.5,11.9997014 Z M17.092,12.9997014 C17.299,13.5807014 17.849,13.9997014 18.5,13.9997014 C19.327,13.9997014 20,13.3277014 20,12.4997014 C20,11.6727014 19.327,10.9997014 18.5,10.9997014 C17.849,10.9997014 17.299,11.4197014 17.092,11.9997014 L13,11.9997014 L13,9.99970136 L16.5,9.99970136 C16.776,9.99970136 17,9.77670136 17,9.49970136 L17,7.90770136 C17.581,7.70070136 18,7.15070136 18,6.49970136 C18,5.67270136 17.327,4.99970136 16.5,4.99970136 C15.673,4.99970136 15,5.67270136 15,6.49970136 C15,7.15070136 15.419,7.70070136 16,7.90770136 L16,8.99970136 L13,8.99970136 L13,5.49970136 C13,5.28470136 12.862,5.09370136 12.658,5.02570136 L9.658,4.02570136 C9.511,3.97670136 9.351,3.99870136 9.223,4.08370136 L6.223,6.08370136 C6.084,6.17670136 6,6.33270136 6,6.49970136 L6,9.19070136 L4.276,10.0527014 C4.107,10.1377014 4,10.3107014 4,10.4997014 L4,13.4997014 C4,13.6897014 4.107,13.8627014 4.276,13.9477014 L6,14.8087014 L6,17.4997014 C6,17.6667014 6.084,17.8237014 6.223,17.9157014 L9.223,19.9157014 C9.306,19.9717014 9.402,19.9997014 9.5,19.9997014 C9.553,19.9997014 9.606,19.9917014 9.658,19.9737014 L12.658,18.9737014 C12.862,18.9067014 13,18.7157014 13,18.4997014 L13,15.9997014 L15.293,15.9997014 L16.146,16.8537014 L16.159,16.8407014 C16.061,17.0407014 16,17.2627014 16,17.4997014 C16,18.3267014 16.673,18.9997014 17.5,18.9997014 C18.327,18.9997014 19,18.3267014 19,17.4997014 C19,16.6727014 18.327,15.9997014 17.5,15.9997014 C17.262,15.9997014 17.04,16.0607014 16.841,16.1597014 L16.854,16.1467014 L15.854,15.1467014 C15.76,15.0527014 15.633,14.9997014 15.5,14.9997014 L13,14.9997014 L13,12.9997014 L17.092,12.9997014 Z" />
      </g>
    </svg>
  );
}
