# Workflow Core 3.1.0

## Decision Branching

You can define multiple independent branches within your workflow and select one based on an expression value.

For the fluent API, we define our branches with the `CreateBranch()` method on the workflow builder.  We can then select a branch using the `Branch` method.

The select expressions will be matched to the branch listed via the `Branch` method, and the matching next step(s) will be scheduled to execute next.

This workflow will select `branch1` if the value of `data.Value1` is `one`, and `branch2` if it is `two`.
```c#
var branch1 = builder.CreateBranch()
    .StartWith<PrintMessage>()
        .Input(step => step.Message, data => "hi from 1")
    .Then<PrintMessage>()
        .Input(step => step.Message, data => "bye from 1");

var branch2 = builder.CreateBranch()
    .StartWith<PrintMessage>()
        .Input(step => step.Message, data => "hi from 2")
    .Then<PrintMessage>()
        .Input(step => step.Message, data => "bye from 2");


builder
    .StartWith<HelloWorld>()
    .Decide(data => data.Value1)
        .Branch((data, outcome) => data.Value1 == "one", branch1)
        .Branch((data, outcome) => data.Value1 == "two", branch2);
```

The JSON representation would look somthing like this.

```json
{
  "Id": "DecisionWorkflow",
  "Version": 1,
  "DataType": "MyApp.MyData, MyApp",
  "Steps": [
    {
      "Id": "decide",
      "StepType": "...",
      "SelectNextStep":
      {
        "Print1": "data.Value1 == \"one\"",
        "Print2": "data.Value1 == \"two\""
      }
    },
    {
      "Id": "Print1",
      "StepType": "MyApp.PrintMessage, MyApp",
      "Inputs": 
	  { 
		"Message": "\"Hello from 1\"" 
	  }
    },
    {
      "Id": "Print2",
      "StepType": "MyApp.PrintMessage, MyApp",
      "Inputs": 
	  { 
	    "Message": "\"Hello from 2\"" 
	  }
    }
  ]
}
```


## Outcomes for JSON workflows

You can now specify `OutcomeSteps` for a step in JSON and YAML workflow definitions.

```
"SelectNextStep":
{
	"<<Step1 Id>>": "<<expression>>",
	"<<Step2 Id>>": "<<expression>>"
}
```
If the outcome of a step matches a particular expression, that step would be scheduled as the next step to execute.