# Workflow Core 2.0.0

### Upgrade notes
Existing JSON definitions will be loaded as follows
  ```c#
  using WorkflowCore.Services.DefinitionStorage;
  ...
  DefinitionLoader.LoadDefinition(json, Deserializers.Json);
  ```


* Targets .NET Standard 2.0

  The core library now targets .NET Standard 2.0, in order to leverage newer features.

* Support for YAML definitions

  Added support for YAML workflow definitions, which can be loaded as follows
  ```c#
  using WorkflowCore.Services.DefinitionStorage;
  ...
  DefinitionLoader.LoadDefinition(json, Deserializers.Yaml);
  ```

  Existing JSON definitions will be loaded as follows
  ```c#
  using WorkflowCore.Services.DefinitionStorage;
  ...
  DefinitionLoader.LoadDefinition(json, Deserializers.Json);
  ```
  
* Object graphs and inline expressions on input properties

  You can now pass object graphs to step inputs as opposed to just scalar values
  ```
  "inputs": 
  {    
    "Body": {
        "Value1": 1,
        "Value2": 2
    },
    "Headers": {
        "Content-Type": "application/json"
    }
  },
  ```
  If you want to evaluate an expression for a given property of your object, simply prepend and `@` and pass an expression string
  ```
  "inputs": 
  {    
    "Body": {
        "@Value1": "data.MyValue * 2",
        "Value2": 5
    },
    "Headers": {
        "Content-Type": "application/json"
    }
  },
  ```

* Support for enum values on input properties

  If your step has an enum property, you can now just pass the string representation of the enum value and it will be automatically converted.

* Environment variables available in input expressions

  You can now access environment variables from within input expressions.
  usage:
  ```
  environment["VARIABLE_NAME"]
  ```

