# Workflow Core 1.2.8

* .Schedule() API, to future date a block of steps to run in parallel to the rest of the workflow.

This following example will execute the block of steps after 3 days
```c#
builder                
    .StartWith<HelloWorld>()
    .Schedule(data => TimeSpan.FromDays(3)).Do(block => 
        block.StartWith<DoSomething>()
        .Then<DoSomethingElse>())
    .Then<GoodbyeWorld>();
```

* .Delay() API, to put the current branch to sleep for a specified period

```c#
builder                
    .StartWith<HelloWorld>()
    .Delay(data => TimeSpan.FromMinutes(5))
    .Then<GoodbyeWorld>();
```

* Overload of the .Input() method to allow access to the context object

```c#
builder
    .StartWith<SayHello>()
    .ForEach(data => new List<int>() { 1, 2, 3, 4 })
        .Do(x => x
            .StartWith<DisplayContext>()
                .Input(step => step.Item, (data, context) => context.Item)
            .Then<DoSomething>())
    .Then<SayGoodbye>();
```

* Inline action steps API

```c#
builder                
    .StartWith(context => Console.WriteLine("Hello!"))
    .Then(context => Console.WriteLine("Bye!"));
```

* Discontinued support for .NET 4.5.2 (.NET 4.6 is .NET Standard 1.3 compatible)
