drop procedure if exists sp_loggerpro_writer;
drop table if exists loggerpro_logs;

create table loggerpro_logs (
    id int generated by default as IDENTITY PRIMARY key,
    log_type int,
    log_tag varchar,
    log_message varchar,
    log_timestamp timestamp,
    log_thread_id integer    
);

create or replace procedure sp_loggerpro_writer(
    p_log_type int,
    p_log_tag varchar,
    p_log_message varchar,
    p_log_timestamp timestamp,
    p_log_thread_id integer
)
language plpgsql    
as $$
begin
  INSERT INTO 
  	public.loggerpro_logs(log_type, log_tag, log_message, log_timestamp, log_thread_id)
	values (p_log_type, p_log_tag, p_log_message, p_log_timestamp, p_log_thread_id);
end;
$$;