SET term ^;

EXECUTE BLOCK
AS
BEGIN
  if (exists(select 1 from RDB$PROCEDURES where upper(rdb$procedure_name) = 'SP_LOGGERPRO_WRITER')) THEN
  begin
    execute statement 'drop procedure SP_LOGGERPRO_WRITER;';
  END
END^

RECREATE table loggerpro_logs (
    id int generated by default as identity,
    log_type integer,
    log_tag varchar(20),
    log_message varchar(1024),
    log_timestamp timestamp,
    log_thread_id integer    
)^


CREATE procedure sp_loggerpro_writer(
    p_log_type int,
    p_log_tag varchar(20),
    p_log_message varchar(1024),
    p_log_timestamp timestamp,
    p_log_thread_id integer
)
as
begin
  INSERT INTO 
  	loggerpro_logs(log_type, log_tag, log_message, log_timestamp, log_thread_id)
  values 
    (:p_log_type, :p_log_tag, :p_log_message, :p_log_timestamp, :p_log_thread_id);
END^

SET term ;^
