unit LoggerProConfig;

interface

uses
  LoggerPro;

function Log: ILogWriter;

implementation

uses
  LoggerPro.FileAppender,
  LoggerPro.ConsoleAppender,
  LoggerPro.OutputDebugStringAppender;

var
  _Log: ILogWriter;

function Log: ILogWriter;
begin
  Result := _Log;
end;

procedure SetupLogger;
const
{$IFDEF DEBUG}
  LOG_LEVEL = TLogType.Debug;
{$ELSE}
  LOG_LEVEL = TLogType.Warning;
{$ENDIF}
begin
  _Log := BuildLogWriter([TLoggerProFileAppender.Create,
    TLoggerProConsoleAppender.Create,
    TLoggerProOutputDebugStringAppender.Create], nil, LOG_LEVEL);
end;

initialization

SetupLogger;

end.
