//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
// StyleAsCode exporter v2.0 - Style data exported as a values array            //
//                                                                              //
// USAGE: On init call: GuiLoadStyleDark();                                   //
//                                                                              //
// more info and bugs-report:  github.com/raysan5/raygui                        //
// feedback and support:       ray[at]raylibtech.com                            //
//                                                                              //
// Copyright (c) 2020-2023 raylib technologies (@raylibtech)                    //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////

#define DARK_STYLE_PROPS_COUNT  21

// Custom style name: Dark
static const GuiStyleProp darkStyleProps[DARK_STYLE_PROPS_COUNT] = {
    { 0, 0, 0x878787ff },    // DEFAULT_BORDER_COLOR_NORMAL 
    { 0, 1, 0x2c2c2cff },    // DEFAULT_BASE_COLOR_NORMAL 
    { 0, 2, 0xc3c3c3ff },    // DEFAULT_TEXT_COLOR_NORMAL 
    { 0, 3, 0xe1e1e1ff },    // DEFAULT_BORDER_COLOR_FOCUSED 
    { 0, 4, 0x848484ff },    // DEFAULT_BASE_COLOR_FOCUSED 
    { 0, 5, 0x181818ff },    // DEFAULT_TEXT_COLOR_FOCUSED 
    { 0, 6, 0x000000ff },    // DEFAULT_BORDER_COLOR_PRESSED 
    { 0, 7, 0xefefefff },    // DEFAULT_BASE_COLOR_PRESSED 
    { 0, 8, 0x202020ff },    // DEFAULT_TEXT_COLOR_PRESSED 
    { 0, 9, 0x6a6a6aff },    // DEFAULT_BORDER_COLOR_DISABLED 
    { 0, 10, 0x818181ff },    // DEFAULT_BASE_COLOR_DISABLED 
    { 0, 11, 0x606060ff },    // DEFAULT_TEXT_COLOR_DISABLED 
    // { 0, 16, 0x00000010 },    // DEFAULT_TEXT_SIZE 
    // { 0, 17, 0x00000000 },    // DEFAULT_TEXT_SPACING 
    { 0, 18, 0x9d9d9dff },    // DEFAULT_LINE_COLOR 
    { 0, 19, 0x3c3c3cff },    // DEFAULT_BACKGROUND_COLOR 
    { 0, 20, 0x00000018 },    // DEFAULT_TEXT_LINE_SPACING 
    { 1, 5, 0xf7f7f7ff },    // LABEL_TEXT_COLOR_FOCUSED 
    { 1, 8, 0x898989ff },    // LABEL_TEXT_COLOR_PRESSED 
    { 4, 5, 0xb0b0b0ff },    // SLIDER_TEXT_COLOR_FOCUSED 
    { 5, 5, 0x848484ff },    // PROGRESSBAR_TEXT_COLOR_FOCUSED 
    { 9, 5, 0xf5f5f5ff },    // TEXTBOX_TEXT_COLOR_FOCUSED 
    { 10, 5, 0xf6f6f6ff },    // VALUEBOX_TEXT_COLOR_FOCUSED 
};

// WARNING: This style uses a custom font: "SFCompactDisplay-Regular.otf" (size: 16, spacing: 0)

#define DARK_STYLE_FONT_ATLAS_COMP_SIZE 5973

// Font atlas image pixels data: DEFLATE compressed
static unsigned char darkFontData[DARK_STYLE_FONT_ATLAS_COMP_SIZE] = { 0xed,
    0x9d, 0x79, 0x7c, 0x15, 0xd5, 0xd9, 0xc7, 0x6f, 0x12, 0x12, 0x16, 0x05, 0x04, 0x64, 0x53, 0x50, 0x96, 0xb0, 0xc8, 0x22,
    0x28, 0x28, 0x45, 0x40, 0x51, 0x59, 0x54, 0x70, 0x01, 0xb1, 0x5a, 0x45, 0x14, 0x41, 0x83, 0xe2, 0x5e, 0xad, 0x2f, 0x75,
    0x85, 0x54, 0x50, 0xab, 0x80, 0xda, 0x82, 0x0a, 0x02, 0x0a, 0x08, 0x55, 0x64, 0x13, 0x44, 0x6d, 0x59, 0x44, 0x40, 0x23,
    0x45, 0x40, 0x65, 0x95, 0xc4, 0x84, 0xec, 0x3b, 0x59, 0x80, 0x42, 0xc5, 0xef, 0xfb, 0xb9, 0x27, 0x93, 0x9b, 0xc0, 0x7d,
    0xce, 0xe4, 0xde, 0x24, 0x48, 0xb4, 0x0f, 0xdf, 0x3f, 0xc8, 0x67, 0xce, 0x9c, 0x59, 0xce, 0x6f, 0xe6, 0x9c, 0x99, 0x3b,
    0xbf, 0xe7, 0x39, 0x78, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x8e, 0xe3, 0x47, 0x06, 0xfb, 0x2d, 0xbb, 0x90, 0xaf, 0xa8,
    0x43, 0x96, 0xa5, 0xc6, 0x95, 0xbc, 0x81, 0x87, 0xfe, 0xbc, 0x6a, 0xdd, 0xe6, 0x3b, 0xb4, 0xb3, 0x94, 0x74, 0x22, 0xb2,
    0x82, 0xc7, 0xeb, 0x3d, 0x36, 0xff, 0xa5, 0xa1, 0x8c, 0x20, 0xcc, 0x6f, 0x69, 0x5f, 0x5a, 0x5b, 0xb6, 0x52, 0x93, 0xd3,
    0x5c, 0xf6, 0xf1, 0x37, 0xda, 0x88, 0xcb, 0xc3, 0x68, 0x43, 0x35, 0xbf, 0xa5, 0x0d, 0xe9, 0x68, 0x68, 0x26, 0xd4, 0x18,
    0x48, 0x75, 0xcb, 0x3e, 0x86, 0x70, 0xb6, 0xa5, 0xa4, 0x8e, 0xb0, 0x8f, 0x22, 0x9a, 0xb1, 0xc8, 0xaa, 0x4a, 0x43, 0xe1,
    0xfc, 0x03, 0x21, 0x5d, 0xd0, 0xff, 0x3c, 0x62, 0x08, 0x23, 0xd7, 0x52, 0x63, 0x1c, 0x0f, 0xe1, 0xe1, 0x29, 0xee, 0x15,
    0x4b, 0x07, 0xb0, 0x83, 0x9f, 0xc8, 0x63, 0x06, 0x35, 0xfc, 0xca, 0xee, 0x61, 0x27, 0xfb, 0x19, 0x68, 0xfe, 0x3e, 0x9d,
    0x2f, 0xe9, 0x2a, 0xd4, 0x0f, 0xe7, 0x1d, 0xd2, 0x89, 0x13, 0x8e, 0xaa, 0xe4, 0xd8, 0xfc, 0x97, 0x3e, 0xc8, 0x14, 0x61,
    0x69, 0x17, 0xbe, 0x16, 0x5b, 0xa5, 0x3d, 0xd7, 0x13, 0xc5, 0x79, 0xd6, 0x36, 0x59, 0x4d, 0x17, 0x71, 0xf9, 0xe5, 0xec,
    0x21, 0xd4, 0x6f, 0xe9, 0xbd, 0xec, 0x34, 0xbc, 0xe0, 0x57, 0x52, 0x8f, 0x23, 0x5c, 0x22, 0x6e, 0x29, 0x82, 0x03, 0x34,
    0x10, 0x15, 0xde, 0x48, 0x1e, 0x79, 0x3c, 0x4b, 0x88, 0x70, 0x36, 0x19, 0xbc, 0xc1, 0x4f, 0x42, 0xad, 0x6b, 0x48, 0x22,
    0x95, 0x5c, 0xc6, 0x96, 0x43, 0xff, 0x44, 0x06, 0xf8, 0x2d, 0x6b, 0xc2, 0x9b, 0x78, 0x58, 0x26, 0xac, 0x5d, 0x97, 0xc7,
    0xd8, 0xcc, 0x0c, 0x1e, 0x63, 0x0b, 0xd3, 0x19, 0x24, 0x5c, 0xbb, 0xd9, 0xf4, 0x67, 0x29, 0x7d, 0x59, 0xc3, 0x78, 0xbf,
    0xd2, 0x7f, 0x72, 0x0b, 0x4f, 0x33, 0xdd, 0xfc, 0x3d, 0x8f, 0x87, 0xc5, 0xe3, 0xb9, 0x83, 0x6f, 0xa8, 0x49, 0x7f, 0x32,
    0x85, 0x16, 0x28, 0x39, 0xb6, 0xe3, 0xa9, 0x41, 0x1a, 0xad, 0xc4, 0xb5, 0xd7, 0x30, 0x4c, 0x58, 0x1a, 0xcd, 0x97, 0xfc,
    0x9b, 0xd7, 0x85, 0x3d, 0x84, 0x12, 0x4e, 0x38, 0x6b, 0xe8, 0x46, 0xb8, 0x70, 0x17, 0xbe, 0xc8, 0x03, 0x41, 0xb6, 0x6e,
    0x4d, 0xcb, 0xf2, 0x2b, 0xc4, 0x5e, 0xcc, 0xc3, 0x3a, 0x5e, 0x25, 0x8c, 0x96, 0x24, 0x32, 0xd4, 0xaf, 0xac, 0x15, 0xad,
    0x68, 0x23, 0xe8, 0x5f, 0x9b, 0x5c, 0x73, 0x4f, 0x75, 0xe3, 0xb0, 0xb5, 0xdf, 0xb5, 0x13, 0x4b, 0xdf, 0x20, 0xd6, 0x6e,
    0xc4, 0x18, 0x72, 0xb8, 0x87, 0xbb, 0xc9, 0xe6, 0x5e, 0xe1, 0xda, 0xee, 0x4c, 0x06, 0xa1, 0x2c, 0xa1, 0x03, 0xad, 0x85,
    0xed, 0xae, 0x62, 0x04, 0xd1, 0xbc, 0x86, 0x87, 0x28, 0x16, 0x59, 0xf4, 0x1d, 0xc2, 0x5a, 0x73, 0xad, 0xa7, 0x59, 0xca,
    0x25, 0x06, 0xf3, 0x9d, 0xa5, 0xe4, 0x51, 0x16, 0x0b, 0x4b, 0x9f, 0x21, 0x86, 0x6f, 0x98, 0x2c, 0xec, 0xe1, 0x0e, 0xd2,
    0x48, 0xe3, 0x08, 0x59, 0xa4, 0x09, 0xfd, 0xcc, 0xed, 0xd4, 0xae, 0xa4, 0x51, 0xf7, 0x25, 0x9e, 0x13, 0x96, 0x46, 0x72,
    0x88, 0xba, 0xe6, 0xaf, 0x3f, 0xb1, 0x42, 0xac, 0x27, 0xe9, 0x7f, 0x36, 0x4f, 0x39, 0x7f, 0x25, 0x58, 0x7b, 0x4d, 0x3b,
    0xbb, 0x2c, 0x3d, 0x94, 0xc7, 0x3a, 0xce, 0x7c, 0x83, 0x87, 0xc6, 0x6c, 0x16, 0x4b, 0xab, 0xb3, 0x8f, 0x0f, 0xf8, 0x8a,
    0x0e, 0x16, 0x6d, 0x93, 0x49, 0xe1, 0x42, 0x2e, 0xe4, 0x3b, 0xe7, 0x3c, 0xa5, 0x9e, 0x71, 0x23, 0xb3, 0xd9, 0x49, 0x3f,
    0xaa, 0x53, 0x3f, 0xc0, 0x63, 0x8a, 0x66, 0x96, 0xa5, 0xa4, 0x0f, 0xc9, 0xe2, 0x53, 0xc8, 0x75, 0xdc, 0x4d, 0xe7, 0xa0,
    0xfb, 0xff, 0xca, 0x63, 0x3b, 0xbf, 0x13, 0x96, 0x5e, 0xcd, 0x0e, 0xdf, 0x28, 0xba, 0x3b, 0x60, 0xfd, 0x8b, 0xe9, 0x46,
    0xbe, 0x38, 0xa6, 0x94, 0x75, 0x24, 0x17, 0x05, 0xb1, 0xf6, 0x50, 0xa6, 0x10, 0x43, 0x14, 0x93, 0x89, 0x61, 0xac, 0x30,
    0x16, 0x7a, 0xc7, 0xbc, 0x68, 0xb2, 0xc9, 0x61, 0x1a, 0xf5, 0xc4, 0xf1, 0xa3, 0x26, 0x67, 0xf0, 0x1d, 0x5d, 0x68, 0xcd,
    0x00, 0xc2, 0x85, 0x35, 0x7a, 0xb0, 0x87, 0x64, 0x1e, 0xc1, 0xc3, 0x75, 0xfc, 0x33, 0xc0, 0xa3, 0x7a, 0x8b, 0xe7, 0x2d,
    0x25, 0x91, 0xfc, 0x57, 0xec, 0x47, 0x6a, 0xb9, 0xde, 0xc9, 0x27, 0x5b, 0xff, 0xb3, 0xc9, 0x12, 0x9f, 0x4b, 0x86, 0xb3,
    0xc1, 0xf9, 0xeb, 0x22, 0x32, 0x83, 0xd4, 0xbf, 0x3e, 0x7b, 0xf9, 0x7d, 0x39, 0x8e, 0x65, 0x80, 0xa8, 0x93, 0x8d, 0xbb,
    0x58, 0xc7, 0x02, 0x1e, 0xe3, 0x73, 0xe6, 0x72, 0x9f, 0x75, 0xad, 0x25, 0x0c, 0x65, 0x35, 0x0b, 0xc4, 0xb2, 0x10, 0x96,
    0x30, 0x8a, 0xf3, 0x48, 0x65, 0xb5, 0x70, 0xd7, 0xb6, 0xe5, 0x00, 0xdd, 0x69, 0xc9, 0x7e, 0xae, 0x65, 0x34, 0xef, 0x06,
    0x78, 0x54, 0x73, 0x88, 0xb6, 0x94, 0xb4, 0xe2, 0x67, 0xeb, 0xd3, 0xb4, 0x9d, 0xb7, 0xcb, 0x31, 0x8e, 0x7a, 0x82, 0x6a,
    0x45, 0xb9, 0x6d, 0x06, 0xf9, 0xc6, 0xb1, 0x7e, 0xec, 0x0d, 0x4a, 0xff, 0xea, 0x7c, 0xce, 0xc4, 0x72, 0x1d, 0x4b, 0x2f,
    0x4e, 0x0f, 0x6a, 0xfd, 0x15, 0xa6, 0xbf, 0xf8, 0xd8, 0x72, 0x87, 0x74, 0xe5, 0x3a, 0xa3, 0x7f, 0x07, 0x2e, 0xb5, 0x9c,
    0xc1, 0x63, 0xcc, 0x31, 0xcf, 0xeb, 0xf3, 0xe8, 0x48, 0x9a, 0x5f, 0xe9, 0x18, 0xe7, 0x9e, 0xef, 0x42, 0x2a, 0xdf, 0x30,
    0x32, 0xc0, 0x63, 0x9a, 0xcc, 0x7c, 0x4b, 0x49, 0x3f, 0x0e, 0x54, 0xc1, 0x77, 0xee, 0xf7, 0xb9, 0xc3, 0xf2, 0x6e, 0x53,
    0xe8, 0xbc, 0x97, 0x3e, 0xcc, 0x27, 0x41, 0xe8, 0x1f, 0xc2, 0x3c, 0x3e, 0x10, 0x7b, 0xe3, 0xb2, 0x08, 0x25, 0x87, 0x1b,
    0x83, 0xaa, 0x11, 0x6f, 0xde, 0x68, 0x13, 0xc4, 0xbe, 0xdb, 0xfb, 0x76, 0x9e, 0xc5, 0x40, 0x96, 0xd1, 0x87, 0x19, 0xe2,
    0xdd, 0xdb, 0x9b, 0x6f, 0xa8, 0x65, 0xde, 0x04, 0x97, 0xf1, 0x3b, 0xe2, 0xfc, 0xca, 0x2f, 0x25, 0x9d, 0xe6, 0x78, 0xa8,
    0xc6, 0x6c, 0xe0, 0x8a, 0x00, 0x8f, 0x69, 0xb4, 0xe5, 0x69, 0xda, 0xbb, 0x9f, 0x4d, 0x55, 0x4e, 0xfd, 0x6a, 0x64, 0xd3,
    0xd4, 0x52, 0x16, 0x63, 0x7a, 0xb2, 0x46, 0xec, 0xe3, 0xd6, 0x20, 0xf4, 0x9f, 0x40, 0x8c, 0x69, 0xd5, 0xf2, 0x50, 0xab,
    0x92, 0xcf, 0xee, 0x16, 0xbe, 0xe7, 0x27, 0xb2, 0x98, 0x23, 0x8c, 0x2b, 0x8d, 0xd8, 0xe5, 0xf4, 0xac, 0x67, 0xb2, 0x9b,
    0x54, 0xc6, 0x08, 0xf5, 0x9f, 0x22, 0x9b, 0x7f, 0x93, 0xca, 0x2c, 0xee, 0x22, 0x83, 0xf3, 0x03, 0xda, 0x67, 0x24, 0x85,
    0x9c, 0x21, 0x96, 0xcc, 0x2d, 0x67, 0xaf, 0x78, 0x32, 0xe9, 0xc5, 0x56, 0x6b, 0x59, 0x5b, 0x76, 0x92, 0x4c, 0x01, 0x53,
    0x82, 0xb8, 0x9b, 0xdb, 0xf2, 0x33, 0xc5, 0xff, 0xa2, 0xab, 0xc4, 0x19, 0x4e, 0xb3, 0xfe, 0xee, 0x56, 0xba, 0xcf, 0xb2,
    0xfd, 0x32, 0x56, 0x9d, 0x56, 0xd6, 0x32, 0x1b, 0xeb, 0x78, 0x54, 0xfc, 0xad, 0xe0, 0xb0, 0xe5, 0x97, 0xbc, 0x53, 0x49,
    0x34, 0x93, 0x5c, 0xcb, 0xcf, 0x71, 0xfd, 0x6d, 0x52, 0x91, 0xb8, 0x98, 0x1f, 0x84, 0x27, 0xea, 0x67, 0x99, 0x56, 0x05,
    0x8f, 0xf5, 0x6b, 0x2e, 0x53, 0xc5, 0x2a, 0x9d, 0x70, 0xe1, 0x3d, 0xaf, 0x5a, 0xb9, 0x9e, 0x89, 0x4e, 0xc5, 0x91, 0x2a,
    0x8a, 0xa2, 0x28, 0x8a, 0xa2, 0x28, 0x8a, 0xa2, 0x28, 0x8a, 0xa2, 0x28, 0x8a, 0xa2, 0x28, 0x4a, 0xc5, 0x70, 0xf7, 0x89,
    0xd7, 0x60, 0x1b, 0xb9, 0x16, 0xd7, 0xea, 0x44, 0xf2, 0x1d, 0x46, 0xb8, 0xd4, 0x97, 0xbf, 0xdc, 0xfd, 0x81, 0x5c, 0x1f,
    0x03, 0x2d, 0x75, 0xeb, 0x09, 0x8e, 0xf1, 0x12, 0xce, 0xb0, 0xfe, 0x96, 0x1f, 0x12, 0xc4, 0xd2, 0xd2, 0x3e, 0x43, 0xff,
    0x1a, 0xbd, 0x7c, 0x9c, 0x2d, 0x78, 0xff, 0xcb, 0xf2, 0x11, 0xd5, 0xa5, 0x89, 0xcb, 0x5e, 0x5b, 0x30, 0x9c, 0x68, 0xa2,
    0xe8, 0xe6, 0xba, 0x8d, 0x0d, 0x56, 0xcf, 0x53, 0xac, 0x69, 0xbb, 0x34, 0x3e, 0x0e, 0xe0, 0xdb, 0xaa, 0x8d, 0xfe, 0x24,
    0x92, 0xc2, 0x01, 0x9e, 0xb0, 0xae, 0x31, 0x9e, 0x15, 0x60, 0xd1, 0x7f, 0x1e, 0x0f, 0x51, 0xdb, 0x20, 0x7b, 0x3f, 0x4e,
    0x63, 0x21, 0x39, 0xe4, 0x33, 0x5b, 0x28, 0x8f, 0xa0, 0x9e, 0xe1, 0x5c, 0x72, 0x69, 0x29, 0x3a, 0xf2, 0xb7, 0x90, 0xca,
    0x01, 0xe6, 0x8b, 0xd7, 0x4f, 0x1f, 0xf6, 0x90, 0x41, 0x36, 0xe3, 0x44, 0xc7, 0xf6, 0x7e, 0xae, 0x17, 0x96, 0x26, 0x70,
    0x83, 0xf5, 0x2c, 0xeb, 0x30, 0x45, 0x70, 0xa7, 0x7b, 0x7d, 0xcb, 0xc5, 0x0c, 0xf1, 0x2b, 0x3d, 0x93, 0x6d, 0xf4, 0x72,
    0xf9, 0xa6, 0xf3, 0x1e, 0x99, 0x64, 0xb1, 0x8d, 0x16, 0xa2, 0xcb, 0xe6, 0x19, 0xb6, 0xf2, 0x18, 0x83, 0x19, 0xc3, 0x0a,
    0x16, 0x5a, 0xbc, 0x0a, 0x1e, 0x3a, 0x90, 0x44, 0x2e, 0x75, 0xc4, 0xb2, 0x2c, 0xae, 0xa4, 0x1e, 0xcd, 0x58, 0xc0, 0x67,
    0xe5, 0xfe, 0xee, 0x94, 0x65, 0x1c, 0x82, 0xed, 0x28, 0x10, 0xdd, 0xa7, 0xde, 0x92, 0x14, 0xda, 0x58, 0xf5, 0xff, 0x17,
    0xd7, 0xba, 0x6e, 0x7f, 0x16, 0x0b, 0x88, 0xa0, 0x0e, 0xdf, 0x1a, 0xf7, 0xa6, 0xcc, 0x13, 0x16, 0xe7, 0xdb, 0x7a, 0xc6,
    0x13, 0xc2, 0x69, 0xac, 0xe7, 0x4f, 0x82, 0xb3, 0x31, 0x83, 0x9b, 0x8c, 0xe7, 0xf8, 0x5b, 0xae, 0x11, 0xea, 0xde, 0x48,
    0xc3, 0x80, 0x97, 0x7a, 0xef, 0xf2, 0xdb, 0x48, 0xe2, 0x6d, 0x1a, 0x07, 0xd9, 0x7a, 0xde, 0x7a, 0xfb, 0x99, 0x4d, 0x23,
    0xb1, 0xf4, 0x4e, 0xbe, 0xa2, 0x06, 0x61, 0xcc, 0x36, 0xee, 0xb6, 0x13, 0x79, 0x80, 0x0f, 0x4a, 0xf5, 0x6d, 0x8f, 0x58,
    0xdd, 0x6a, 0xcf, 0xf3, 0x12, 0xcb, 0xb8, 0xd3, 0xa2, 0xff, 0xc5, 0x8e, 0x47, 0x70, 0x7b, 0x39, 0xf5, 0xaf, 0xc9, 0x35,
    0xce, 0xfd, 0xb3, 0xcd, 0xb4, 0xa7, 0xff, 0x19, 0xae, 0x66, 0x34, 0x75, 0xad, 0xfa, 0x7f, 0xcf, 0x14, 0xbe, 0x64, 0x07,
    0xd1, 0xe2, 0x3d, 0xda, 0x90, 0x02, 0xc7, 0xd5, 0xd4, 0xc0, 0xd2, 0x46, 0xde, 0x23, 0x48, 0xe5, 0x02, 0xb1, 0x24, 0xd9,
    0x39, 0xbb, 0x09, 0x42, 0x74, 0xc7, 0x20, 0xbe, 0x75, 0xfe, 0xba, 0x9f, 0x0f, 0x2b, 0x38, 0xfa, 0x75, 0x64, 0x2d, 0x1b,
    0xe9, 0x6e, 0xf1, 0xc2, 0x7d, 0xeb, 0x63, 0xa4, 0xa5, 0x87, 0x8b, 0x26, 0x85, 0xb1, 0xc2, 0x08, 0xda, 0x83, 0x9e, 0x8e,
    0xb7, 0x63, 0xa9, 0x50, 0x6b, 0x3f, 0x0d, 0x88, 0x60, 0x22, 0xb3, 0x89, 0x62, 0x30, 0x21, 0x6c, 0xa6, 0xad, 0xd8, 0xfe,
    0x3f, 0xd2, 0x9d, 0xdb, 0x2c, 0xae, 0xe7, 0x2c, 0xae, 0xa2, 0x09, 0xdd, 0x58, 0xe5, 0xe2, 0xbb, 0x0d, 0xe4, 0x1a, 0x68,
    0xc1, 0x58, 0x62, 0x45, 0xf7, 0xfd, 0xed, 0xac, 0x27, 0xc4, 0x45, 0xff, 0x6c, 0xe6, 0xd1, 0x85, 0x2e, 0xc4, 0x98, 0x08,
    0x8e, 0x13, 0xb9, 0x8c, 0x9d, 0x0c, 0x61, 0x35, 0xab, 0xb8, 0xc5, 0xba, 0xf7, 0xb1, 0x7c, 0x6a, 0x29, 0x79, 0x92, 0x4f,
    0xe9, 0xc6, 0xd5, 0xec, 0x11, 0xfa, 0xd8, 0xfe, 0xec, 0xf3, 0xad, 0xf5, 0x4d, 0x85, 0xd4, 0x3f, 0x83, 0xa3, 0x4c, 0x70,
    0x19, 0xa3, 0x1b, 0xfa, 0xa8, 0xe5, 0xe2, 0xb6, 0x4a, 0xe3, 0x19, 0xeb, 0xf8, 0x9a, 0x21, 0x1c, 0x7f, 0x0f, 0x3e, 0xc2,
    0xc3, 0x28, 0xd6, 0xd0, 0x81, 0xaf, 0xf9, 0x3f, 0xe3, 0x57, 0xbd, 0x59, 0xf4, 0x46, 0xc6, 0x9a, 0xb1, 0xa9, 0x90, 0xb3,
    0x44, 0xfd, 0x33, 0x48, 0x22, 0x93, 0x3d, 0xe5, 0x88, 0xf1, 0x28, 0x1d, 0x29, 0x93, 0xc2, 0x61, 0x1e, 0x17, 0xda, 0xa0,
    0x3e, 0x89, 0x26, 0x6a, 0xc3, 0xae, 0xff, 0xa5, 0xce, 0xb8, 0xde, 0x93, 0x03, 0x42, 0xfd, 0xe1, 0xa4, 0xb1, 0x94, 0x5e,
    0x0c, 0x23, 0xd9, 0xd2, 0x83, 0x85, 0x13, 0xcf, 0x95, 0x96, 0xe3, 0x6a, 0xc7, 0x4e, 0xf6, 0x91, 0xce, 0x5c, 0xc1, 0x97,
    0x7f, 0x3a, 0x09, 0x4c, 0x24, 0x92, 0x61, 0xec, 0xe2, 0x47, 0xa1, 0x6e, 0x5f, 0x71, 0xc4, 0x8c, 0x14, 0x34, 0x0c, 0xe3,
    0x11, 0xd2, 0x99, 0x16, 0x74, 0xdf, 0x5f, 0x72, 0x87, 0xde, 0xcc, 0x3e, 0x96, 0x59, 0x62, 0x58, 0x2f, 0x22, 0x9d, 0x4b,
    0x85, 0xe5, 0x23, 0x78, 0x19, 0x0f, 0xaf, 0xf0, 0xa0, 0x71, 0x24, 0x79, 0xf5, 0x9f, 0xc4, 0x70, 0xd1, 0x35, 0xb7, 0x97,
    0x19, 0xcc, 0x20, 0x43, 0xf4, 0xb2, 0x15, 0xf7, 0xff, 0x3d, 0x28, 0x74, 0x89, 0x5c, 0x09, 0x84, 0x26, 0x6c, 0x13, 0x9c,
    0x97, 0xa3, 0x38, 0xcc, 0x3e, 0xf6, 0x11, 0x07, 0xc4, 0xd2, 0x49, 0xf0, 0xd2, 0x5c, 0xe6, 0x3c, 0x81, 0x77, 0xe6, 0xa0,
    0xd0, 0x03, 0x0e, 0xe3, 0x88, 0xe3, 0x24, 0xbf, 0xcb, 0x17, 0xc5, 0x70, 0x62, 0x6c, 0xd5, 0x66, 0x6b, 0xec, 0x42, 0x16,
    0x57, 0x1b, 0x7d, 0xa6, 0xb0, 0x5c, 0xbc, 0x3a, 0x3e, 0x64, 0x37, 0x1f, 0x30, 0x92, 0x2f, 0x85, 0x5e, 0x3b, 0x5b, 0x18,
    0xcd, 0x1a, 0x53, 0x60, 0x79, 0xca, 0xaa, 0xcf, 0x54, 0xb2, 0x79, 0xa6, 0x1c, 0x1e, 0xbb, 0xbe, 0x7c, 0xcd, 0x16, 0x2e,
    0xb7, 0x96, 0xbf, 0xca, 0x64, 0x4b, 0x84, 0xc5, 0x7c, 0x13, 0x73, 0xf6, 0xba, 0xf1, 0xa3, 0x4e, 0xc0, 0xc3, 0x5a, 0x21,
    0xf6, 0x34, 0x82, 0x2c, 0xee, 0x63, 0x08, 0x43, 0x78, 0x9e, 0x2d, 0x2e, 0xfa, 0x7b, 0xd8, 0x62, 0x71, 0x8f, 0x97, 0x1d,
    0x75, 0xd2, 0xcb, 0xe7, 0xb1, 0xfd, 0x40, 0x78, 0x7b, 0x69, 0x6b, 0xb8, 0x10, 0xe8, 0x2c, 0xbc, 0x89, 0x85, 0x90, 0x60,
    0x46, 0xc5, 0x08, 0xe6, 0xb3, 0x48, 0x74, 0x7e, 0xe7, 0xfa, 0xfa, 0x98, 0xed, 0xe2, 0xe8, 0xba, 0x53, 0x7c, 0xea, 0x28,
    0x8a, 0xab, 0x8d, 0xf3, 0x8d, 0xcf, 0x79, 0x42, 0x7c, 0x63, 0x47, 0x9f, 0x73, 0xf2, 0xad, 0x00, 0x63, 0x2c, 0x6f, 0x37,
    0x31, 0xea, 0x36, 0xda, 0xb0, 0x38, 0x68, 0xa7, 0x6c, 0x03, 0x12, 0xb9, 0xc3, 0xd5, 0x4f, 0xd6, 0x82, 0x26, 0xe2, 0xf2,
    0xc6, 0x26, 0x6a, 0xb8, 0x35, 0xa9, 0xc4, 0xf0, 0x3c, 0x71, 0x7c, 0xce, 0x5f, 0x84, 0xb5, 0xae, 0xe5, 0x07, 0xdf, 0xf9,
    0x1e, 0xa2, 0xbd, 0xa0, 0x7f, 0x0f, 0x33, 0x3a, 0xdf, 0x44, 0xa1, 0x25, 0xba, 0xae, 0x2c, 0xce, 0x27, 0xd7, 0xf4, 0x5c,
    0xb5, 0xd9, 0x64, 0x7a, 0x21, 0xdb, 0x5b, 0xac, 0xad, 0xff, 0xef, 0x4d, 0x02, 0xfb, 0xc8, 0x60, 0x95, 0xf8, 0x7c, 0x17,
    0xc2, 0x36, 0x46, 0x99, 0x5f, 0x00, 0x96, 0xf3, 0x8a, 0x18, 0x39, 0xf6, 0x83, 0xf5, 0x97, 0x87, 0x26, 0x14, 0x9a, 0x68,
    0xd1, 0x10, 0x26, 0x99, 0xe8, 0xcf, 0x13, 0x63, 0xa2, 0x8f, 0x98, 0xbb, 0xae, 0x2d, 0xe9, 0x5c, 0x18, 0xf0, 0x38, 0x17,
    0x59, 0xe6, 0xdb, 0x7a, 0xb0, 0x6f, 0x4f, 0x65, 0x39, 0xe5, 0xdb, 0x73, 0xae, 0xa5, 0x64, 0x81, 0x89, 0x75, 0x8e, 0x30,
    0x7d, 0x4e, 0x35, 0x4b, 0xe4, 0xd9, 0xc2, 0x52, 0x31, 0x6c, 0xd2, 0xd5, 0x99, 0x65, 0xfc, 0xdd, 0x87, 0xd9, 0x2a, 0x44,
    0x06, 0x07, 0xca, 0x13, 0xe4, 0xf3, 0x3d, 0xb9, 0xcc, 0xb4, 0xbc, 0xc1, 0x97, 0x1d, 0x2d, 0xd2, 0xd2, 0x25, 0xc2, 0xb0,
    0x13, 0xbb, 0x89, 0x23, 0x8b, 0x0f, 0x83, 0x8c, 0x28, 0x2a, 0x1a, 0x3d, 0x52, 0xf9, 0x96, 0x04, 0x36, 0x89, 0xbf, 0x0e,
    0x0c, 0x27, 0x9b, 0x58, 0xb2, 0x5d, 0x7e, 0x77, 0xaa, 0x0a, 0x2c, 0xe1, 0x6f, 0xd6, 0x5f, 0xb6, 0x36, 0x31, 0x93, 0x9e,
    0x34, 0xa4, 0xb9, 0xaf, 0x17, 0x3f, 0x35, 0xd4, 0xa2, 0x7d, 0x39, 0xd4, 0x09, 0x9c, 0xe6, 0x41, 0x45, 0x13, 0x1e, 0xff,
    0x7c, 0xd1, 0xda, 0xfa, 0xde, 0xe8, 0x2d, 0x3d, 0xb7, 0x9c, 0xf9, 0x2d, 0x7e, 0x39, 0x22, 0x5c, 0x8e, 0x30, 0x84, 0x5b,
    0x98, 0xce, 0x67, 0x2c, 0xb7, 0x64, 0xcd, 0x50, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51,
    0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x94, 0xf2, 0xba, 0x80, 0xeb, 0xbb, 0x3a, 0xcc, 0x77, 0x31, 0x4f, 0xfc, 0x8e, 0x1d,
    0xeb, 0xf3, 0xef, 0x8f, 0x71, 0x29, 0x1b, 0x66, 0xfd, 0x7e, 0xd7, 0xc0, 0xba, 0xd7, 0x62, 0x37, 0x66, 0x3f, 0xc1, 0xdd,
    0x17, 0x6b, 0xf1, 0x6a, 0x7a, 0xd9, 0x2a, 0xe4, 0x07, 0x2c, 0x5e, 0xff, 0x4a, 0x62, 0x85, 0xcc, 0x5f, 0x6e, 0x5b, 0xdb,
    0xc1, 0xe8, 0x52, 0x1e, 0xa1, 0x54, 0x21, 0x7b, 0x75, 0xac, 0xcf, 0x97, 0xd5, 0xc7, 0x9a, 0x6f, 0x30, 0xcc, 0xe5, 0x3c,
    0xbd, 0xed, 0x93, 0xcc, 0x22, 0xab, 0x4b, 0xc0, 0xdb, 0x4a, 0xee, 0xda, 0x24, 0xb1, 0xb4, 0x42, 0xf9, 0xcc, 0xea, 0x32,
    0x9f, 0x43, 0x14, 0x10, 0x2b, 0xfa, 0xa8, 0xbd, 0x1e, 0xac, 0x46, 0x5c, 0xc8, 0x74, 0x72, 0x84, 0x2f, 0xb1, 0xde, 0xbc,
    0x8e, 0x8d, 0x0c, 0x35, 0x2d, 0x35, 0xbd, 0xd4, 0x10, 0xbf, 0x7e, 0x7b, 0xf7, 0x9a, 0x4f, 0xa2, 0x98, 0x9f, 0x36, 0xcb,
    0xe7, 0x45, 0xbf, 0xca, 0xe7, 0xf3, 0x94, 0x4a, 0xfd, 0x89, 0x13, 0x22, 0x49, 0x8a, 0xd6, 0xbf, 0x80, 0x2c, 0xfa, 0xb9,
    0xee, 0xcb, 0x9f, 0x24, 0xbe, 0xf7, 0xb9, 0x1a, 0x1f, 0x03, 0xfa, 0x0b, 0xb5, 0x0f, 0x39, 0xad, 0x7f, 0x85, 0x2f, 0x4f,
    0xf3, 0xf1, 0x3e, 0xc5, 0x19, 0x14, 0x52, 0x40, 0x92, 0xe8, 0x80, 0xcd, 0x62, 0x00, 0x67, 0xd2, 0x82, 0x37, 0x45, 0x77,
    0x97, 0xd7, 0xf7, 0x39, 0x87, 0x83, 0x14, 0x90, 0x68, 0xa9, 0xdd, 0x9f, 0xfa, 0xb4, 0xe0, 0x2d, 0x76, 0x55, 0x20, 0xa7,
    0xd5, 0x3c, 0x56, 0x52, 0x9f, 0x10, 0x86, 0x50, 0x20, 0x38, 0x90, 0x4b, 0x5a, 0x67, 0x0d, 0x2f, 0xba, 0xf8, 0xcf, 0x82,
    0x6b, 0x57, 0x0f, 0xff, 0x60, 0x85, 0xb9, 0x2b, 0xfa, 0x93, 0x2f, 0xf8, 0x77, 0x2a, 0x5f, 0xff, 0x56, 0xa4, 0x58, 0x1c,
    0x72, 0xee, 0xfa, 0x67, 0x3b, 0xee, 0xd4, 0x30, 0x7e, 0x34, 0xed, 0xed, 0x5f, 0x7b, 0x21, 0xeb, 0xcc, 0x35, 0x22, 0xeb,
    0x3f, 0x93, 0x75, 0x26, 0x02, 0xe8, 0x2a, 0x0a, 0x84, 0x9c, 0xea, 0xc5, 0xed, 0x77, 0x06, 0x88, 0xfe, 0xde, 0x77, 0xf9,
    0x27, 0x8d, 0x08, 0x61, 0x20, 0xf9, 0x65, 0xd4, 0x6e, 0x51, 0x4e, 0xf5, 0x1b, 0xf0, 0x13, 0xe7, 0x38, 0x7f, 0xcf, 0x37,
    0x5e, 0x2d, 0x5b, 0xeb, 0x3c, 0xc4, 0xbf, 0x84, 0xd2, 0x2b, 0xa8, 0x6b, 0x08, 0x0b, 0xaa, 0x5d, 0x1b, 0x71, 0xcc, 0x77,
    0xbe, 0xd1, 0xe2, 0x5e, 0x87, 0x9a, 0x99, 0x0d, 0x5a, 0x71, 0x67, 0xa5, 0xe8, 0x7f, 0x2d, 0x7b, 0x85, 0xd8, 0x9e, 0x40,
    0xf4, 0x9f, 0xe4, 0x78, 0xf7, 0x6f, 0x60, 0x3d, 0x5f, 0x88, 0xfa, 0x77, 0x65, 0xbb, 0xf1, 0x6f, 0x48, 0xfa, 0xd7, 0xe3,
    0x98, 0xcf, 0x73, 0xf6, 0x22, 0xff, 0xb0, 0x2a, 0xd8, 0x86, 0x9f, 0x05, 0xbf, 0x72, 0x7d, 0x8e, 0xf9, 0xc6, 0x85, 0x49,
    0x2c, 0xb4, 0xd6, 0xee, 0xca, 0x7f, 0x2d, 0xf1, 0x41, 0x65, 0xd3, 0x83, 0x0c, 0xd7, 0xf2, 0x92, 0xd6, 0xb9, 0x45, 0x38,
    0xbf, 0x2c, 0xf2, 0xc9, 0x31, 0x74, 0x15, 0xca, 0x52, 0x89, 0x37, 0xf8, 0xf7, 0x4d, 0xbd, 0x48, 0x29, 0x63, 0xaf, 0x69,
    0x24, 0x18, 0xd2, 0x2b, 0x45, 0xff, 0x0c, 0xd2, 0x44, 0x97, 0x68, 0xd9, 0xfa, 0x77, 0x22, 0xd5, 0xb8, 0xcf, 0x56, 0x33,
    0xd4, 0xa2, 0x7f, 0x47, 0xba, 0x93, 0x43, 0x73, 0x51, 0xff, 0x1e, 0xa5, 0x66, 0xe6, 0x19, 0x2a, 0x38, 0x60, 0xb3, 0xf8,
    0x0b, 0xa3, 0x19, 0xc7, 0x2e, 0xde, 0x16, 0xf6, 0xde, 0xb3, 0x54, 0x2e, 0xec, 0xa1, 0x6c, 0x13, 0x6a, 0xbf, 0xc7, 0x64,
    0x66, 0x92, 0xca, 0xe3, 0xe5, 0xee, 0xfd, 0x07, 0xfa, 0x1c, 0xa6, 0x65, 0xb5, 0xce, 0x03, 0xac, 0x09, 0xb2, 0xff, 0xbf,
    0x89, 0x36, 0x06, 0xfb, 0x5e, 0x27, 0xb2, 0x80, 0x05, 0xdc, 0x73, 0xd2, 0xfb, 0xff, 0xc9, 0xb4, 0xe3, 0xa0, 0xf8, 0x7c,
    0x53, 0x96, 0xfe, 0x91, 0x4c, 0xe0, 0x65, 0x3a, 0x12, 0x4b, 0x98, 0x55, 0x7f, 0xef, 0xcc, 0x1d, 0x2b, 0x45, 0xfd, 0x07,
    0x9a, 0xe8, 0x0d, 0x8f, 0xf3, 0xf4, 0x99, 0x20, 0xd4, 0xfe, 0x88, 0xd9, 0xfc, 0x9d, 0xe1, 0xe2, 0xf8, 0x3d, 0x90, 0x3d,
    0xa5, 0x6a, 0xff, 0x28, 0xd4, 0x9e, 0xca, 0xa3, 0xac, 0x12, 0xe7, 0xe4, 0x09, 0x94, 0x4b, 0xca, 0xbc, 0x13, 0x8b, 0x5b,
    0xe7, 0x63, 0xc1, 0xc9, 0x5e, 0xde, 0xf1, 0xff, 0x12, 0x52, 0x1d, 0x17, 0xfc, 0xcd, 0x7c, 0x20, 0x5c, 0xfb, 0xc1, 0xeb,
    0x5f, 0xcb, 0x89, 0xc4, 0x4d, 0x12, 0xf2, 0xa8, 0x16, 0xad, 0xff, 0x28, 0xc9, 0xe2, 0x93, 0x74, 0x59, 0xfa, 0x37, 0x21,
    0x8d, 0x77, 0x8d, 0x57, 0xd7, 0xae, 0x7f, 0x4d, 0xf6, 0x32, 0x4b, 0xd0, 0xbf, 0xb7, 0x73, 0x9e, 0x1e, 0x33, 0x73, 0xc5,
    0xce, 0xa0, 0xda, 0xef, 0xf8, 0x5e, 0xf2, 0x7a, 0xb1, 0xf7, 0xb8, 0xd8, 0xc4, 0xb4, 0x1c, 0xa9, 0xc0, 0xfc, 0x69, 0xde,
    0x91, 0xb8, 0xb1, 0x2f, 0x92, 0xea, 0x7a, 0x61, 0x1f, 0xbd, 0x89, 0xa0, 0x25, 0x13, 0x29, 0x10, 0xe2, 0x9f, 0xb3, 0xe8,
    0x65, 0xe6, 0x46, 0x0a, 0x17, 0xae, 0x5f, 0xb7, 0x76, 0x6d, 0xcc, 0xcf, 0x3e, 0x5f, 0xfc, 0x14, 0xfe, 0x5a, 0x09, 0xfa,
    0x7f, 0xc6, 0x2b, 0x84, 0xd2, 0x85, 0xff, 0x08, 0x71, 0x3c, 0x45, 0xeb, 0x87, 0xb2, 0x41, 0x8c, 0x33, 0xcd, 0xa2, 0x0f,
    0xd5, 0x0d, 0xa1, 0xa2, 0xfe, 0xde, 0x99, 0xeb, 0xf2, 0xcc, 0xf8, 0x6a, 0xd7, 0xdf, 0x1b, 0x07, 0x75, 0x4c, 0xd0, 0xbf,
    0xf4, 0x79, 0x3e, 0x2d, 0x44, 0x01, 0xba, 0xeb, 0xdf, 0xd0, 0xa9, 0xfd, 0x2c, 0x7f, 0x60, 0xbc, 0x70, 0xec, 0xc5, 0xb5,
    0xdf, 0x67, 0x66, 0x05, 0x7a, 0x80, 0xa5, 0x2c, 0x34, 0x6f, 0x68, 0x3d, 0xc9, 0x13, 0xe2, 0xd0, 0x8b, 0x1c, 0xe6, 0xa9,
    0xac, 0x10, 0x67, 0x46, 0xcb, 0xf2, 0xe5, 0x18, 0x7f, 0x28, 0xc8, 0xe7, 0xff, 0x8f, 0x58, 0x64, 0xbc, 0xf3, 0x9d, 0x49,
    0xb7, 0xde, 0xb1, 0xc1, 0xe8, 0x7f, 0x11, 0xc9, 0xe6, 0x5d, 0xec, 0x51, 0x97, 0x3b, 0xbc, 0x2d, 0x07, 0x85, 0xb7, 0xcd,
    0x92, 0x73, 0x18, 0x66, 0xd1, 0xbf, 0xb1, 0x33, 0xaf, 0x85, 0x9b, 0xfe, 0xde, 0x48, 0xad, 0x1d, 0x62, 0xeb, 0x2e, 0x36,
    0xde, 0xea, 0x6e, 0x4e, 0x34, 0x53, 0x30, 0xfa, 0x7b, 0x58, 0xc4, 0x62, 0x6a, 0xd1, 0x85, 0x5c, 0x72, 0x84, 0x18, 0xa3,
    0xe2, 0xda, 0xdd, 0x39, 0x62, 0xe6, 0x47, 0x28, 0x1f, 0x8d, 0x59, 0xc5, 0x41, 0x12, 0xc9, 0x2c, 0x67, 0x04, 0x51, 0xf9,
    0x68, 0xca, 0x27, 0x1c, 0x66, 0xbf, 0x99, 0x37, 0xac, 0xb2, 0x7e, 0xc3, 0x6a, 0x53, 0x69, 0x33, 0x71, 0x55, 0x1e, 0x8d,
    0xf9, 0x88, 0x43, 0x24, 0x92, 0x17, 0xf4, 0x2c, 0x71, 0x45, 0x3d, 0xc0, 0x52, 0x0a, 0x88, 0x37, 0xbf, 0x1f, 0xd4, 0x3c,
    0x89, 0x47, 0x59, 0x97, 0xd6, 0xa7, 0xc0, 0x49, 0x5f, 0x87, 0xc8, 0x72, 0xcc, 0xc3, 0xf3, 0xeb, 0xa3, 0x4e, 0x85, 0x5a,
    0xb7, 0x36, 0x2d, 0x09, 0x65, 0x79, 0x95, 0xcc, 0x5a, 0xaf, 0xfc, 0x52, 0x84, 0x54, 0xc9, 0xac, 0xf5, 0x8a, 0xa2, 0x28,
    0x8a, 0xa2, 0x28, 0x8a, 0xa2, 0x28, 0x8a, 0xa2, 0x28, 0x8a, 0xa2, 0x28, 0x8a, 0xa2, 0x54, 0xdd, 0x6f, 0x0b, 0x67, 0x59,
    0xf2, 0x7f, 0x6d, 0x2d, 0x95, 0xa1, 0xff, 0x3d, 0xbf, 0xd2, 0xea, 0xe4, 0xfa, 0xdc, 0x0d, 0xb7, 0x0b, 0x39, 0x3a, 0x17,
    0xf1, 0x82, 0xef, 0xef, 0xc5, 0xa5, 0x32, 0xd9, 0x95, 0x78, 0x36, 0x1e, 0x76, 0x5c, 0x72, 0xb9, 0x8e, 0xbb, 0xe0, 0x59,
    0x21, 0x97, 0xf3, 0x6b, 0xac, 0x70, 0x3c, 0xd8, 0x03, 0x88, 0xe3, 0x4c, 0xbf, 0xf2, 0x0f, 0x7d, 0xbe, 0xe4, 0xfb, 0xd8,
    0x24, 0x7c, 0x67, 0xeb, 0x57, 0xea, 0x1c, 0xfc, 0x1d, 0x18, 0x43, 0x19, 0xc3, 0x18, 0xe1, 0xbb, 0xf1, 0x70, 0x6b, 0x3e,
    0xf6, 0x6b, 0x4d, 0x0d, 0xc9, 0x49, 0x74, 0x29, 0xb9, 0xe2, 0xf7, 0xfc, 0xba, 0xdc, 0xe8, 0xe3, 0x12, 0xa1, 0x15, 0xa3,
    0x2d, 0xf1, 0x01, 0x83, 0xd9, 0xc1, 0x01, 0x36, 0x0a, 0x99, 0x5d, 0xef, 0x71, 0xcd, 0x54, 0xd8, 0x8e, 0xd5, 0xe4, 0xb1,
    0xd5, 0x9a, 0x57, 0xf7, 0x78, 0x6e, 0x24, 0x89, 0x14, 0x0e, 0xb2, 0x4c, 0x38, 0x63, 0x6f, 0xd6, 0xee, 0x9e, 0x1c, 0x35,
    0x2e, 0x7e, 0xff, 0x3d, 0xd6, 0x28, 0xe5, 0x5a, 0x1e, 0x25, 0xb8, 0x03, 0xef, 0x20, 0xd1, 0x51, 0xae, 0x3e, 0x47, 0xb9,
    0xc8, 0xaf, 0x3c, 0x9a, 0x95, 0xe6, 0xff, 0x71, 0xe0, 0xe4, 0xaf, 0xde, 0x28, 0x38, 0x19, 0xeb, 0x93, 0x66, 0x9c, 0x09,
    0xb5, 0xd8, 0x27, 0xe6, 0x10, 0xee, 0xc4, 0x41, 0xe3, 0xd2, 0xa8, 0x27, 0xfa, 0xb3, 0xbd, 0x19, 0xd8, 0xce, 0x34, 0xb4,
    0x22, 0x4d, 0xc8, 0xfe, 0x1f, 0xc3, 0x3b, 0x3c, 0x29, 0x9c, 0xdb, 0x12, 0x6e, 0xb3, 0xb4, 0xd7, 0x70, 0x9e, 0x24, 0x4f,
    0xcc, 0xb6, 0xbb, 0x84, 0x89, 0xc2, 0x5d, 0xe2, 0xe1, 0x2c, 0xa6, 0xfa, 0x18, 0x2d, 0x94, 0x0f, 0x13, 0x73, 0xbf, 0x47,
    0x90, 0xcf, 0x50, 0xc2, 0x78, 0x4a, 0x88, 0x2b, 0x39, 0x2a, 0xe6, 0x0a, 0x2f, 0x8e, 0x36, 0xf1, 0x66, 0x63, 0xaf, 0x47,
    0x14, 0xf9, 0x01, 0xf8, 0x21, 0xce, 0xa6, 0x90, 0xde, 0x26, 0x1f, 0xf9, 0x32, 0x8b, 0x43, 0xb6, 0x1d, 0x47, 0x2d, 0x75,
    0xcb, 0xd2, 0xbf, 0x36, 0x07, 0x9d, 0xeb, 0x7d, 0x24, 0xbb, 0x85, 0xfa, 0x7d, 0xc8, 0x33, 0xf7, 0xeb, 0x67, 0x2c, 0x31,
    0xb9, 0x67, 0x6b, 0x71, 0x84, 0xf3, 0x85, 0xf5, 0x6e, 0x22, 0x8b, 0x86, 0xbc, 0xc0, 0x2a, 0xcb, 0x71, 0xbc, 0x6a, 0x7a,
    0x8d, 0x57, 0x58, 0xec, 0x7a, 0xa6, 0x33, 0x98, 0x27, 0x2c, 0x8d, 0x11, 0x5c, 0x39, 0x5e, 0xa2, 0x98, 0xeb, 0xb2, 0xad,
    0x44, 0x41, 0xff, 0x56, 0x6c, 0x21, 0x94, 0x1d, 0x82, 0x4b, 0xae, 0x6c, 0xba, 0x0a, 0x3e, 0x88, 0x30, 0x27, 0xde, 0xa6,
    0x13, 0x05, 0x41, 0xe9, 0xdf, 0x91, 0x7c, 0x67, 0x6b, 0xcd, 0x02, 0xc8, 0xe8, 0x39, 0x90, 0x74, 0xe7, 0xcb, 0x72, 0x2b,
    0x61, 0x7e, 0x8b, 0x8a, 0xe9, 0xef, 0xe1, 0x3d, 0xa6, 0x38, 0xde, 0xd1, 0xa7, 0x44, 0xc7, 0x4e, 0x1e, 0xdd, 0x89, 0x20,
    0x8f, 0x0e, 0xa4, 0x13, 0x42, 0x3f, 0x52, 0x2c, 0x79, 0xd8, 0x17, 0xb3, 0x96, 0x2c, 0xab, 0xc7, 0xe9, 0x0c, 0xd2, 0x19,
    0xc5, 0x01, 0xd7, 0x18, 0x88, 0xab, 0x2d, 0xee, 0x4f, 0x9b, 0xfe, 0xe7, 0xfa, 0xda, 0x25, 0x50, 0xfd, 0xef, 0x35, 0x31,
    0x3a, 0x77, 0x59, 0xf2, 0x9c, 0x97, 0x67, 0x54, 0x7e, 0x81, 0x38, 0x62, 0xd9, 0x4f, 0xa1, 0xa0, 0x7f, 0x14, 0x5b, 0xc9,
    0x60, 0xa6, 0x90, 0xb1, 0xba, 0x7f, 0x19, 0x8e, 0xee, 0x13, 0x1d, 0x46, 0x39, 0xbc, 0xc7, 0xef, 0x5c, 0xfc, 0x29, 0x15,
    0xd1, 0x7f, 0x10, 0x89, 0x84, 0x52, 0x8f, 0xff, 0x88, 0x19, 0x5c, 0xbd, 0xee, 0xb8, 0x3f, 0xd2, 0xdb, 0xe4, 0xef, 0xde,
    0x41, 0x27, 0xa2, 0xc5, 0x79, 0x32, 0x3c, 0x26, 0x8f, 0x34, 0xc2, 0xf3, 0x43, 0x09, 0xa3, 0x81, 0xe7, 0x5c, 0xca, 0xeb,
    0x91, 0x64, 0x99, 0xa7, 0xc4, 0xa6, 0xbf, 0x87, 0x9d, 0x2e, 0xb3, 0xf2, 0x24, 0x56, 0x30, 0xdb, 0x7a, 0x60, 0xce, 0xfc,
    0x6c, 0xd3, 0x97, 0x74, 0x12, 0xf5, 0xff, 0x9c, 0xe6, 0x34, 0x23, 0xa6, 0xd4, 0x13, 0x56, 0x31, 0xe7, 0x73, 0x20, 0x28,
    0xaf, 0x48, 0x67, 0x16, 0x99, 0x28, 0x8e, 0xbf, 0x5b, 0xb2, 0xb4, 0x56, 0x44, 0xff, 0x70, 0xd2, 0xe9, 0xc5, 0x48, 0xbe,
    0xb0, 0x6c, 0xe1, 0x3e, 0x96, 0xf3, 0xb4, 0xc9, 0x6b, 0x3c, 0x95, 0xfb, 0x59, 0xcf, 0xad, 0x96, 0xf5, 0x96, 0x10, 0x43,
    0xb2, 0xf5, 0x89, 0xcc, 0x1b, 0x23, 0x89, 0xe5, 0x0a, 0x2b, 0x8e, 0xa3, 0x7a, 0xc7, 0x52, 0x62, 0xd7, 0x7f, 0x32, 0x4f,
    0x9e, 0x52, 0xfd, 0x07, 0x93, 0x6c, 0x14, 0x79, 0x5a, 0xd4, 0xbf, 0xc8, 0x0d, 0x3a, 0x84, 0xef, 0x84, 0x36, 0x8f, 0x33,
    0x6e, 0xdc, 0x0b, 0x88, 0x75, 0xc9, 0x9d, 0x7b, 0x62, 0x9d, 0x81, 0x6c, 0xb5, 0x8c, 0x9f, 0x76, 0xfd, 0x43, 0x38, 0x40,
    0x0f, 0xe7, 0xef, 0xe7, 0x84, 0xf8, 0xa4, 0xa2, 0xa7, 0xf7, 0xa9, 0xac, 0x24, 0xca, 0xb2, 0x85, 0x48, 0x72, 0x59, 0x67,
    0xe6, 0x47, 0x18, 0xcc, 0x4a, 0x0e, 0x59, 0x66, 0xe7, 0xf9, 0x3d, 0xf1, 0x9c, 0xce, 0x72, 0x31, 0x46, 0xa6, 0x88, 0x50,
    0xd7, 0x08, 0xb8, 0x1b, 0x9c, 0x96, 0x0c, 0x4e, 0xff, 0x01, 0xd6, 0xab, 0xf6, 0x97, 0xd1, 0xbf, 0x1a, 0x8b, 0x38, 0xcc,
    0x6e, 0x5e, 0x17, 0xf5, 0x8f, 0x74, 0x5c, 0xcf, 0xd9, 0x42, 0xcd, 0x8b, 0xd9, 0x4b, 0x1e, 0x79, 0x42, 0x4c, 0xb6, 0x14,
    0x89, 0x71, 0x99, 0xef, 0xbd, 0x26, 0x25, 0x48, 0xfd, 0xbd, 0x11, 0x83, 0x9f, 0x9a, 0x67, 0xe7, 0x0e, 0xa4, 0x89, 0xb3,
    0x57, 0x78, 0xdf, 0xed, 0xd2, 0x28, 0xb0, 0x46, 0x30, 0x7b, 0x63, 0x98, 0x0b, 0xcc, 0xac, 0x6b, 0xb5, 0x39, 0xc2, 0xbf,
    0x2d, 0x11, 0x8a, 0x69, 0x26, 0x72, 0xe7, 0x1c, 0xf2, 0x19, 0x50, 0x0e, 0xfd, 0xcf, 0x24, 0x8d, 0xeb, 0xa9, 0x66, 0x08,
    0x0b, 0x42, 0xff, 0x1a, 0xe4, 0x59, 0x7b, 0x9c, 0x5f, 0x42, 0xff, 0xa2, 0x27, 0x68, 0xd9, 0x1f, 0x7b, 0xd4, 0x99, 0xb5,
    0x61, 0x10, 0xbb, 0xac, 0xcf, 0x44, 0x81, 0x39, 0x4e, 0x6f, 0x25, 0xd9, 0x44, 0x68, 0x85, 0xf3, 0xa6, 0x38, 0xcb, 0x86,
    0xbb, 0xfe, 0x0d, 0x58, 0x6a, 0x5c, 0xdc, 0x07, 0x5d, 0x46, 0xdf, 0x3d, 0xae, 0xcf, 0xe5, 0xd3, 0x9d, 0x77, 0x40, 0xef,
    0x6c, 0x5f, 0x13, 0x2d, 0x7d, 0xf7, 0x02, 0x5f, 0x04, 0x6a, 0xbc, 0xe5, 0x8d, 0xc6, 0x4d, 0xff, 0x47, 0x7c, 0xfe, 0x7e,
    0xd8, 0x1b, 0x84, 0xfe, 0xde, 0xa7, 0xd6, 0x61, 0xa7, 0x58, 0x7f, 0x1b, 0x47, 0x59, 0x62, 0x22, 0x56, 0x3e, 0xb1, 0x66,
    0x97, 0x0f, 0xfc, 0x29, 0xf3, 0x65, 0x0e, 0x13, 0x4b, 0x0e, 0x6b, 0xc4, 0x08, 0xe4, 0x40, 0xae, 0xd1, 0x36, 0xe5, 0x9c,
    0x39, 0xa0, 0x2a, 0xe0, 0xa6, 0xff, 0x83, 0xd6, 0xb8, 0x9a, 0x53, 0xaf, 0xff, 0xe3, 0x24, 0x91, 0xcf, 0xa7, 0x2e, 0x33,
    0x2f, 0x04, 0x4e, 0x04, 0x6d, 0x2b, 0x65, 0x3b, 0xbf, 0x35, 0xfd, 0xdb, 0x92, 0x58, 0x45, 0xf5, 0x2f, 0xea, 0xf3, 0x4e,
    0xd7, 0xdf, 0xae, 0x2b, 0x41, 0xff, 0x54, 0x62, 0x69, 0x66, 0x7d, 0x3a, 0xe9, 0x24, 0x3c, 0xf3, 0xc4, 0xf2, 0xdf, 0x2a,
    0xa0, 0xbf, 0x52, 0x39, 0x51, 0x63, 0x11, 0x44, 0x58, 0x67, 0xff, 0xab, 0x26, 0xbc, 0x49, 0x57, 0x73, 0xad, 0xa1, 0x28,
    0x8a, 0xa2, 0x28, 0x8a, 0xa2, 0x28, 0x8a, 0xa2, 0x28, 0x8a, 0xa2, 0x28, 0x8a, 0xa2, 0x28, 0x55, 0x8b, 0x8b, 0x84, 0xec,
    0xf6, 0x5e, 0x37, 0xe9, 0x3a, 0x72, 0xd8, 0xec, 0xf8, 0x0d, 0xfc, 0xbf, 0x1e, 0x0f, 0xe2, 0x09, 0xd1, 0x6d, 0xd6, 0x99,
    0x2f, 0xc8, 0x62, 0x19, 0xcf, 0x09, 0x0e, 0x35, 0x77, 0xf7, 0x7a, 0x1b, 0x8b, 0x73, 0x41, 0x5a, 0xee, 0xb6, 0xa5, 0x51,
    0x82, 0xe7, 0x27, 0x9e, 0x3f, 0x13, 0xcf, 0x0f, 0xdc, 0xc6, 0xfd, 0xec, 0x25, 0x83, 0x09, 0x42, 0xbd, 0x78, 0x1e, 0x60,
    0x3b, 0xd9, 0x4c, 0x17, 0xbd, 0x17, 0xad, 0x58, 0x45, 0x0e, 0x3b, 0xc4, 0x7c, 0xec, 0xfb, 0xb8, 0x9d, 0xed, 0xa4, 0x31,
    0x45, 0xfc, 0x1e, 0xde, 0x91, 0x0d, 0x64, 0xf3, 0x11, 0x4f, 0xf2, 0xb2, 0xb0, 0xcf, 0xf1, 0x24, 0x88, 0xee, 0xf5, 0xfb,
    0x88, 0x27, 0x93, 0x95, 0xbe, 0x38, 0x8b, 0xe3, 0x7d, 0x51, 0x92, 0x3f, 0xa1, 0x31, 0x09, 0x54, 0x77, 0x7c, 0xd1, 0x0f,
    0x06, 0xa1, 0x7f, 0xb4, 0xf0, 0xb5, 0x3b, 0x9c, 0xbd, 0x3c, 0x44, 0x35, 0x86, 0x92, 0x29, 0xb6, 0xf4, 0x1f, 0xc8, 0x64,
    0xbc, 0xf8, 0x8d, 0x64, 0x2f, 0xd1, 0x9c, 0x46, 0x5f, 0x0a, 0x04, 0x57, 0xb9, 0x9b, 0x7b, 0x39, 0x9c, 0x43, 0xe2, 0x75,
    0x28, 0x2f, 0x77, 0xdb, 0x52, 0x81, 0x2f, 0x33, 0x63, 0x09, 0xf0, 0x06, 0xf5, 0xb9, 0x99, 0xa3, 0x2c, 0xa5, 0x11, 0x97,
    0x71, 0x58, 0x88, 0xd7, 0x80, 0x7f, 0xd0, 0x94, 0x0b, 0x48, 0xe4, 0x6e, 0xe1, 0x9b, 0xeb, 0x36, 0x26, 0x50, 0x93, 0x4b,
    0xc8, 0x15, 0xb2, 0xd6, 0x1f, 0x65, 0x2d, 0x4d, 0x39, 0x87, 0xed, 0x3c, 0x22, 0xb8, 0xb9, 0x77, 0x31, 0x91, 0x3a, 0x26,
    0xdf, 0xfd, 0x6c, 0x61, 0x9f, 0x33, 0x69, 0x2a, 0x5c, 0x35, 0x91, 0xe4, 0x10, 0x49, 0x18, 0x73, 0xc4, 0xec, 0x6f, 0x53,
    0x79, 0x45, 0x8c, 0x36, 0xc0, 0x99, 0x71, 0x61, 0x9e, 0xe8, 0xba, 0x0e, 0x46, 0xff, 0xf3, 0xc9, 0xa6, 0x01, 0xf5, 0xa9,
    0xcf, 0x76, 0x06, 0x09, 0x75, 0x5e, 0xe1, 0x0d, 0x71, 0x5b, 0x1d, 0x28, 0x74, 0xee, 0x9e, 0xb9, 0x41, 0xea, 0xef, 0xb1,
    0x3a, 0x11, 0x1a, 0x88, 0x3e, 0x88, 0x60, 0xf5, 0x2f, 0x8a, 0x33, 0x4a, 0x76, 0xbe, 0xfa, 0x7f, 0xc1, 0x08, 0x61, 0x9d,
    0xa2, 0x18, 0x84, 0x97, 0x84, 0x23, 0x3f, 0x8f, 0x02, 0xe7, 0xbc, 0x66, 0x0a, 0x7e, 0xe4, 0x62, 0x57, 0xe6, 0x5d, 0xac,
    0x15, 0x5a, 0xe4, 0xa0, 0xa3, 0xef, 0xdb, 0xa2, 0xfe, 0x1d, 0x2d, 0xde, 0xdc, 0x42, 0xfa, 0x12, 0x46, 0x84, 0xe0, 0x7b,
    0x7a, 0x88, 0x7c, 0xf2, 0x84, 0x79, 0x23, 0x82, 0xd5, 0xbf, 0x3d, 0xeb, 0xc8, 0x62, 0x29, 0x7f, 0x17, 0xf4, 0xef, 0xcf,
    0x11, 0x76, 0x3a, 0x0c, 0xb3, 0x1c, 0x81, 0xe4, 0xda, 0xbb, 0x82, 0x38, 0xe7, 0xaf, 0x49, 0xa2, 0xfe, 0x7f, 0x64, 0x2b,
    0xd9, 0xcc, 0x10, 0xfb, 0xc9, 0xed, 0x96, 0xb6, 0x90, 0x96, 0x17, 0xe9, 0x1f, 0xc5, 0x7a, 0xa1, 0x77, 0x92, 0xf5, 0x6f,
    0xe9, 0x7c, 0xd7, 0x2f, 0xea, 0x4b, 0x56, 0x0b, 0x6e, 0xfd, 0xe2, 0x75, 0x9e, 0x11, 0x3c, 0xc3, 0xfd, 0x7c, 0xde, 0xfa,
    0xe7, 0x04, 0xaf, 0xfa, 0x51, 0x5a, 0x3b, 0xce, 0xed, 0xbd, 0x42, 0xcd, 0xe2, 0x16, 0x79, 0x5a, 0xd4, 0xbf, 0x95, 0x45,
    0x9d, 0x91, 0x7c, 0x4d, 0x36, 0x73, 0x84, 0xec, 0xbb, 0x35, 0x78, 0x93, 0xbf, 0x09, 0xe7, 0x1d, 0x9c, 0xfe, 0xde, 0x68,
    0xa1, 0x89, 0xd4, 0x66, 0x00, 0x85, 0xe2, 0xfd, 0x9f, 0xe5, 0xf2, 0xa5, 0xbb, 0x06, 0xd3, 0x99, 0x26, 0xce, 0x3c, 0xe0,
    0xcd, 0xb6, 0x5e, 0xdd, 0x71, 0x4b, 0x48, 0xfa, 0x7f, 0xc8, 0x59, 0x74, 0x21, 0xde, 0x89, 0xfa, 0x3a, 0x9e, 0x1c, 0x2e,
    0x10, 0xf7, 0x26, 0x2d, 0xf7, 0xea, 0x3f, 0x84, 0x34, 0xda, 0x07, 0x7c, 0xff, 0x57, 0x4c, 0xff, 0x12, 0x6f, 0xfd, 0x34,
    0x61, 0x36, 0x94, 0xa3, 0x26, 0x92, 0xca, 0xc3, 0x08, 0x36, 0x08, 0x77, 0x72, 0xbe, 0xf3, 0xfc, 0x32, 0x2d, 0x28, 0xfd,
    0xbd, 0x34, 0x67, 0x1a, 0x9b, 0x44, 0x6f, 0xb5, 0xd4, 0xff, 0x37, 0x05, 0xe7, 0xaa, 0xf8, 0x30, 0x00, 0xfd, 0x4b, 0xfa,
    0xa5, 0xd9, 0x82, 0xfe, 0x11, 0x24, 0x98, 0xd8, 0xbb, 0xf6, 0xec, 0x12, 0xa3, 0x6f, 0xa6, 0x3a, 0xf1, 0x3d, 0xfe, 0x57,
    0xd5, 0x77, 0x4c, 0xa1, 0x11, 0x57, 0x93, 0x2f, 0xea, 0x5f, 0x14, 0x59, 0xf1, 0xbc, 0xd0, 0x12, 0xc1, 0xea, 0x3f, 0x8a,
    0x4c, 0x4b, 0x0e, 0xe5, 0x93, 0xa1, 0x7f, 0x38, 0xb1, 0xe6, 0x9a, 0x6d, 0x45, 0x86, 0xf8, 0x34, 0xf2, 0x11, 0x35, 0x38,
    0x8d, 0x8d, 0x3c, 0x2b, 0xb4, 0xe4, 0x7e, 0xee, 0x37, 0x4f, 0xb1, 0xd9, 0x41, 0xe8, 0x7f, 0x39, 0x5f, 0x1a, 0x2d, 0x1f,
    0x66, 0x63, 0xc0, 0xfa, 0x87, 0x92, 0x67, 0xe6, 0x23, 0x69, 0x4b, 0x4e, 0x00, 0xfa, 0xf7, 0xf3, 0xcd, 0x50, 0xf0, 0x9c,
    0xe8, 0x76, 0xec, 0xc9, 0x5e, 0x92, 0xc8, 0x15, 0xef, 0x54, 0xbb, 0xfe, 0xde, 0xf3, 0xfc, 0x98, 0x78, 0xe6, 0xf2, 0xaa,
    0xcb, 0xf8, 0x3f, 0x4e, 0x8c, 0x96, 0x0c, 0x4e, 0xff, 0x42, 0xf6, 0x59, 0x3c, 0xc1, 0x27, 0x43, 0x7f, 0x6f, 0xae, 0xed,
    0x9d, 0x64, 0x92, 0x2b, 0xce, 0xb8, 0x71, 0x94, 0x17, 0x49, 0x25, 0x9f, 0x45, 0x42, 0x54, 0x96, 0x87, 0xcb, 0x48, 0x22,
    0x9d, 0xcd, 0xcc, 0x0a, 0x42, 0xff, 0x70, 0xe6, 0x71, 0x88, 0x64, 0x76, 0x0b, 0xd1, 0xb3, 0x36, 0xfd, 0xbd, 0x4f, 0xe5,
    0x79, 0xe4, 0xf2, 0x15, 0x9f, 0x04, 0xa0, 0x7f, 0x57, 0xf2, 0x7d, 0x3d, 0xda, 0x4c, 0x6b, 0xf4, 0x94, 0xcd, 0x4b, 0x6e,
    0xd3, 0x3f, 0x9c, 0xa7, 0x1c, 0x37, 0xf1, 0x22, 0xfe, 0x7c, 0x52, 0xf5, 0x1f, 0xc0, 0xc7, 0x62, 0x5c, 0xa7, 0xac, 0x7f,
    0xe5, 0x50, 0xd7, 0x12, 0x5f, 0xe5, 0x3d, 0xaf, 0x30, 0x51, 0xfb, 0x12, 0xaf, 0xb4, 0xf7, 0x3e, 0x9b, 0x1d, 0xd4, 0xde,
    0x6a, 0x58, 0x63, 0x57, 0x5e, 0x60, 0x89, 0x65, 0x74, 0x0e, 0x0b, 0x78, 0x3e, 0xa0, 0xea, 0x24, 0x33, 0xd6, 0xbc, 0x69,
    0x64, 0x96, 0x63, 0x16, 0x01, 0xfb, 0xfd, 0xff, 0x3e, 0x3b, 0x78, 0x96, 0xd9, 0x24, 0xd2, 0xf4, 0xa4, 0xea, 0xdf, 0x96,
    0x46, 0xa4, 0x08, 0x33, 0x48, 0x9d, 0x4c, 0xfd, 0xed, 0xae, 0xec, 0xb6, 0x01, 0xac, 0x15, 0xac, 0xfe, 0x6e, 0xbf, 0xd8,
    0xa4, 0x93, 0x54, 0xe1, 0xad, 0x5c, 0xce, 0x7e, 0xb2, 0xd9, 0x22, 0x3e, 0xff, 0x97, 0x5f, 0xff, 0x30, 0x6e, 0xe0, 0x49,
    0x46, 0x8b, 0xd7, 0x61, 0xe5, 0xea, 0xef, 0x7d, 0xdb, 0x90, 0xb4, 0xfe, 0xe5, 0xf5, 0x1f, 0xe8, 0x7a, 0xef, 0x97, 0xbc,
    0xd3, 0x57, 0xa6, 0x77, 0xb8, 0x66, 0x25, 0xc5, 0x19, 0x55, 0xf5, 0x5f, 0x27, 0xab, 0x07, 0x78, 0x77, 0x29, 0xbf, 0x45,
    0x3a, 0xb2, 0x9c, 0xb8, 0x5f, 0x71, 0x94, 0x91, 0x52, 0x31, 0xce, 0xe1, 0x4e, 0xf1, 0x17, 0x70, 0x45, 0x51, 0x14, 0x45,
    0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x24, 0x3e, 0x71, 0xb2, 0x3e, 0xb7, 0xe7,
    0x5b, 0xe1, 0xfb, 0xca, 0x4b, 0xce, 0x7c, 0xfa, 0x6b, 0x8d, 0x47, 0xc0, 0xc3, 0x26, 0x5f, 0xbe, 0xcf, 0x12, 0xee, 0x65,
    0x8d, 0xa9, 0x79, 0x0d, 0x5f, 0x0b, 0xdf, 0x3f, 0x57, 0x3a, 0x0e, 0x9b, 0xc6, 0xc4, 0x09, 0xd9, 0x48, 0xaf, 0x22, 0xc1,
    0x61, 0xa1, 0xe5, 0xbb, 0xcf, 0x9d, 0xc2, 0xb7, 0xc9, 0x73, 0x19, 0xe8, 0xb7, 0x6c, 0x10, 0x57, 0x5b, 0x72, 0x25, 0x86,
    0x70, 0x37, 0xaf, 0x19, 0xc7, 0x59, 0x63, 0xa1, 0xde, 0xff, 0x3a, 0x4f, 0xf3, 0xbe, 0xf9, 0x7f, 0x3c, 0xb3, 0x84, 0xd2,
    0x3b, 0xf8, 0xcc, 0xb4, 0xf7, 0x21, 0x93, 0xdd, 0xb7, 0x29, 0x87, 0x1d, 0x67, 0xe9, 0xf1, 0xce, 0xb6, 0x6d, 0x8c, 0xa3,
    0x36, 0x09, 0x42, 0x76, 0x7d, 0x0f, 0x4f, 0xf0, 0x2f, 0xe7, 0x2a, 0xf9, 0x5c, 0xf4, 0xb6, 0x34, 0xa1, 0x09, 0xed, 0x48,
    0x15, 0x33, 0xff, 0x5e, 0x43, 0x3a, 0x93, 0x04, 0x87, 0xeb, 0x60, 0x21, 0xa3, 0xe4, 0x08, 0x3e, 0x77, 0xce, 0xe4, 0x44,
    0xae, 0x23, 0x96, 0x3f, 0x91, 0xc2, 0xfd, 0xcc, 0xae, 0x34, 0xe7, 0xc5, 0x6f, 0x87, 0x48, 0x0a, 0x8c, 0x87, 0x60, 0x0f,
    0x57, 0x08, 0xa5, 0xcd, 0x8c, 0x6b, 0x35, 0x8a, 0xd7, 0x48, 0xa1, 0x36, 0xc3, 0x1c, 0x2d, 0xfd, 0x3d, 0x64, 0x79, 0x2c,
    0xb6, 0xe4, 0xcb, 0x6f, 0xc6, 0x11, 0x93, 0xd5, 0x77, 0x35, 0xf7, 0x58, 0x8f, 0x61, 0x81, 0x78, 0xed, 0x79, 0x1d, 0x69,
    0xe3, 0xc4, 0xe5, 0x83, 0xc5, 0x8c, 0xa2, 0x8d, 0x38, 0x2c, 0xfa, 0xb2, 0xfa, 0xd0, 0xcf, 0xf8, 0x11, 0xe7, 0x31, 0x5f,
    0xf0, 0x22, 0x29, 0x31, 0xdc, 0x40, 0x77, 0x92, 0x2c, 0x9e, 0xb6, 0x3d, 0x5c, 0xc0, 0x52, 0xfa, 0x31, 0x97, 0x21, 0x4c,
    0x11, 0xbc, 0x7c, 0x45, 0xbc, 0xc3, 0x31, 0xeb, 0xbc, 0x07, 0x5e, 0xe5, 0x1b, 0x71, 0xd0, 0x9a, 0x03, 0x78, 0x14, 0xbb,
    0x2d, 0xbe, 0x99, 0x77, 0x2c, 0xae, 0x53, 0x59, 0x7f, 0x6f, 0x36, 0x72, 0x75, 0x08, 0x04, 0xcf, 0xc3, 0xcc, 0xe5, 0x65,
    0xfe, 0x6a, 0x29, 0x9d, 0xc6, 0xa3, 0x24, 0x13, 0xc1, 0x2d, 0xbc, 0xc5, 0x66, 0x61, 0xf4, 0xf7, 0x18, 0xa7, 0x71, 0x36,
    0x31, 0xbc, 0x6e, 0xd9, 0xc2, 0x9d, 0x7c, 0x46, 0x94, 0x30, 0xf3, 0x4e, 0x71, 0x44, 0x4d, 0x36, 0x5d, 0x2d, 0x65, 0x4b,
    0x2d, 0x7d, 0x86, 0xac, 0x7f, 0x38, 0xc7, 0xfe, 0x67, 0xb3, 0x98, 0x56, 0x84, 0xb3, 0xc8, 0x26, 0x89, 0x2e, 0x96, 0xd2,
    0x61, 0x24, 0x9a, 0xd9, 0x55, 0xea, 0x91, 0x48, 0xa6, 0xe8, 0x03, 0x0e, 0xe3, 0x4b, 0x1e, 0xa7, 0x39, 0xb9, 0x62, 0xfc,
    0xa2, 0xd7, 0x5b, 0xe6, 0x8d, 0x11, 0xba, 0xc9, 0xe2, 0x5e, 0xdb, 0xce, 0x03, 0x96, 0x3d, 0xdf, 0xca, 0x7e, 0x3a, 0x04,
    0xa1, 0xbf, 0x87, 0x55, 0xcc, 0xf9, 0x15, 0x38, 0xd9, 0xaa, 0x1e, 0xab, 0x85, 0x59, 0x04, 0x4a, 0xa2, 0xee, 0x8e, 0x31,
    0xd2, 0xfc, 0xb5, 0x8e, 0x65, 0xe2, 0x1a, 0x7f, 0x76, 0x66, 0xdd, 0x1a, 0x49, 0xa2, 0x25, 0x5f, 0xfa, 0x7b, 0xe4, 0x59,
    0x7c, 0x8a, 0x37, 0x01, 0x47, 0x0c, 0x1b, 0x84, 0xde, 0x7f, 0xa5, 0x65, 0x7b, 0x36, 0xfd, 0xa3, 0x48, 0xd2, 0x11, 0xbe,
    0x0a, 0x32, 0xdd, 0x32, 0xb3, 0x54, 0x59, 0x6c, 0x10, 0xa3, 0xac, 0x6d, 0xfa, 0x87, 0x92, 0x4f, 0x3b, 0x6d, 0xed, 0x2a,
    0x46, 0x0f, 0xde, 0x25, 0xd3, 0x89, 0x8b, 0x0c, 0x16, 0x7d, 0xfe, 0xfb, 0xf5, 0xd3, 0x86, 0x91, 0xd6, 0x79, 0xbb, 0xca,
    0xd6, 0x7f, 0x6c, 0x90, 0xfa, 0x57, 0xd3, 0x16, 0xff, 0x0d, 0xf1, 0x17, 0x66, 0x89, 0xf1, 0x4d, 0xb2, 0xfe, 0xbd, 0x2d,
    0xf3, 0xd7, 0x28, 0xbf, 0x56, 0x9a, 0xb0, 0x9e, 0x64, 0x21, 0x37, 0xbf, 0xa4, 0xff, 0x42, 0xe2, 0xad, 0xb3, 0xb5, 0x28,
    0xbf, 0x5e, 0x42, 0x85, 0x1e, 0x20, 0x54, 0x9c, 0x2d, 0x53, 0xdb, 0x4a, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14,
    0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51,
    0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45,
    0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14,
    0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51,
    0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45,
    0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14,
    0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51,
    0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0x45,
    0x51, 0x14, 0x45, 0x51, 0x14, 0x45, 0x51, 0x14, 0xe5, 0x24, 0xf0, 0xff };

// Font glyphs rectangles data (on atlas)
static const Rectangle darkFontRecs[95] = {
    { 4, 4, 2 , 16 },
    { 14, 4, 3 , 10 },
    { 25, 4, 5 , 3 },
    { 38, 4, 8 , 9 },
    { 54, 4, 7 , 11 },
    { 69, 4, 9 , 11 },
    { 86, 4, 9 , 11 },
    { 103, 4, 2 , 3 },
    { 113, 4, 4 , 13 },
    { 125, 4, 4 , 13 },
    { 137, 4, 5 , 6 },
    { 150, 4, 7 , 7 },
    { 165, 4, 3 , 4 },
    { 176, 4, 5 , 2 },
    { 189, 4, 3 , 3 },
    { 200, 4, 5 , 13 },
    { 213, 4, 7 , 11 },
    { 228, 4, 4 , 9 },
    { 240, 4, 7 , 10 },
    { 4, 28, 7 , 11 },
    { 19, 28, 8 , 9 },
    { 35, 28, 8 , 10 },
    { 51, 28, 7 , 11 },
    { 66, 28, 7 , 9 },
    { 81, 28, 7 , 11 },
    { 96, 28, 7 , 11 },
    { 111, 28, 3 , 8 },
    { 122, 28, 3 , 9 },
    { 133, 28, 7 , 9 },
    { 148, 28, 7 , 5 },
    { 163, 28, 7 , 9 },
    { 178, 28, 6 , 11 },
    { 192, 28, 11 , 11 },
    { 211, 28, 8 , 9 },
    { 227, 28, 7 , 9 },
    { 4, 52, 8 , 11 },
    { 20, 52, 7 , 9 },
    { 35, 52, 6 , 9 },
    { 49, 52, 6 , 9 },
    { 63, 52, 8 , 11 },
    { 79, 52, 7 , 9 },
    { 94, 52, 2 , 9 },
    { 104, 52, 6 , 10 },
    { 118, 52, 7 , 9 },
    { 133, 52, 6 , 9 },
    { 147, 52, 9 , 9 },
    { 164, 52, 7 , 9 },
    { 179, 52, 8 , 11 },
    { 195, 52, 7 , 9 },
    { 210, 52, 8 , 12 },
    { 226, 52, 7 , 9 },
    { 4, 76, 7 , 11 },
    { 19, 76, 7 , 9 },
    { 34, 76, 8 , 10 },
    { 50, 76, 8 , 9 },
    { 66, 76, 11 , 9 },
    { 85, 76, 8 , 9 },
    { 101, 76, 8 , 9 },
    { 117, 76, 7 , 9 },
    { 132, 76, 4 , 13 },
    { 144, 76, 5 , 13 },
    { 157, 76, 4 , 13 },
    { 169, 76, 5 , 4 },
    { 182, 76, 7 , 2 },
    { 197, 76, 4 , 3 },
    { 209, 76, 6 , 8 },
    { 223, 76, 6 , 11 },
    { 237, 76, 7 , 8 },
    { 4, 100, 7 , 11 },
    { 19, 100, 7 , 8 },
    { 34, 100, 5 , 10 },
    { 47, 100, 7 , 10 },
    { 62, 100, 6 , 10 },
    { 76, 100, 3 , 10 },
    { 87, 100, 4 , 13 },
    { 99, 100, 6 , 10 },
    { 113, 100, 2 , 10 },
    { 123, 100, 10 , 7 },
    { 141, 100, 6 , 7 },
    { 155, 100, 7 , 8 },
    { 170, 100, 6 , 10 },
    { 184, 100, 7 , 10 },
    { 199, 100, 4 , 7 },
    { 211, 100, 6 , 8 },
    { 225, 100, 4 , 10 },
    { 237, 100, 7 , 8 },
    { 4, 124, 7 , 7 },
    { 19, 124, 10 , 7 },
    { 37, 124, 7 , 7 },
    { 52, 124, 7 , 10 },
    { 67, 124, 6 , 7 },
    { 81, 124, 5 , 13 },
    { 94, 124, 2 , 13 },
    { 104, 124, 5 , 13 },
    { 117, 124, 7 , 3 },
};

// Font glyphs info data
// NOTE: No glyphs.image data provided
static const GlyphInfo darkFontGlyphs[95] = {
    { 32, 0, 12, 2, { 0 }},
    { 33, 0, 3, 3, { 0 }},
    { 34, 0, 3, 4, { 0 }},
    { 35, 0, 3, 7, { 0 }},
    { 36, 0, 2, 7, { 0 }},
    { 37, 0, 2, 9, { 0 }},
    { 38, 0, 2, 8, { 0 }},
    { 39, 0, 3, 2, { 0 }},
    { 40, 1, 2, 4, { 0 }},
    { 41, 0, 2, 4, { 0 }},
    { 42, 1, 2, 6, { 0 }},
    { 43, 0, 5, 7, { 0 }},
    { 44, 0, 10, 2, { 0 }},
    { 45, 0, 7, 5, { 0 }},
    { 46, 0, 10, 3, { 0 }},
    { 47, 0, 2, 4, { 0 }},
    { 48, 0, 2, 7, { 0 }},
    { 49, 0, 3, 5, { 0 }},
    { 50, 0, 2, 7, { 0 }},
    { 51, 0, 2, 7, { 0 }},
    { 52, 0, 3, 7, { 0 }},
    { 53, 0, 3, 7, { 0 }},
    { 54, 0, 2, 7, { 0 }},
    { 55, 0, 3, 7, { 0 }},
    { 56, 0, 2, 7, { 0 }},
    { 57, 0, 2, 7, { 0 }},
    { 58, 0, 5, 3, { 0 }},
    { 59, 0, 5, 3, { 0 }},
    { 60, 0, 4, 7, { 0 }},
    { 61, 0, 6, 7, { 0 }},
    { 62, 0, 4, 7, { 0 }},
    { 63, 0, 2, 6, { 0 }},
    { 64, 0, 3, 10, { 0 }},
    { 65, 0, 3, 7, { 0 }},
    { 66, 1, 3, 8, { 0 }},
    { 67, 0, 2, 8, { 0 }},
    { 68, 1, 3, 8, { 0 }},
    { 69, 1, 3, 7, { 0 }},
    { 70, 1, 3, 6, { 0 }},
    { 71, 0, 2, 8, { 0 }},
    { 72, 1, 3, 8, { 0 }},
    { 73, 1, 3, 3, { 0 }},
    { 74, 0, 3, 6, { 0 }},
    { 75, 1, 3, 7, { 0 }},
    { 76, 1, 3, 6, { 0 }},
    { 77, 1, 3, 10, { 0 }},
    { 78, 1, 3, 8, { 0 }},
    { 79, 0, 2, 8, { 0 }},
    { 80, 1, 3, 7, { 0 }},
    { 81, 0, 2, 8, { 0 }},
    { 82, 1, 3, 7, { 0 }},
    { 83, 0, 2, 7, { 0 }},
    { 84, 0, 3, 6, { 0 }},
    { 85, 0, 3, 8, { 0 }},
    { 86, 0, 3, 7, { 0 }},
    { 87, 0, 3, 10, { 0 }},
    { 88, 0, 3, 7, { 0 }},
    { 89, 0, 3, 7, { 0 }},
    { 90, 0, 3, 7, { 0 }},
    { 91, 1, 2, 4, { 0 }},
    { 92, 0, 2, 4, { 0 }},
    { 93, 0, 2, 4, { 0 }},
    { 94, 0, 3, 4, { 0 }},
    { 95, -1, 12, 5, { 0 }},
    { 96, 1, 2, 6, { 0 }},
    { 97, 0, 5, 6, { 0 }},
    { 98, 1, 2, 7, { 0 }},
    { 99, 0, 5, 6, { 0 }},
    { 100, 0, 2, 7, { 0 }},
    { 101, 0, 5, 7, { 0 }},
    { 102, 0, 2, 4, { 0 }},
    { 103, 0, 5, 7, { 0 }},
    { 104, 1, 2, 7, { 0 }},
    { 105, 0, 2, 3, { 0 }},
    { 106, -1, 2, 3, { 0 }},
    { 107, 1, 2, 6, { 0 }},
    { 108, 1, 2, 3, { 0 }},
    { 109, 1, 5, 11, { 0 }},
    { 110, 1, 5, 7, { 0 }},
    { 111, 0, 5, 7, { 0 }},
    { 112, 1, 5, 7, { 0 }},
    { 113, 0, 5, 7, { 0 }},
    { 114, 1, 5, 4, { 0 }},
    { 115, 0, 5, 6, { 0 }},
    { 116, 0, 3, 4, { 0 }},
    { 117, 0, 5, 7, { 0 }},
    { 118, 0, 5, 6, { 0 }},
    { 119, 0, 5, 9, { 0 }},
    { 120, 0, 5, 6, { 0 }},
    { 121, 0, 5, 6, { 0 }},
    { 122, 0, 5, 6, { 0 }},
    { 123, 0, 2, 4, { 0 }},
    { 124, 1, 2, 4, { 0 }},
    { 125, 0, 2, 4, { 0 }},
    { 126, 0, 6, 7, { 0 }},
};

// Style loading function: Dark
static void GuiLoadStyleDark(void)
{
    // Load style properties provided
    // NOTE: Default properties are propagated
    for (int i = 0; i < DARK_STYLE_PROPS_COUNT; i++)
    {
        GuiSetStyle(darkStyleProps[i].controlId, darkStyleProps[i].propertyId, darkStyleProps[i].propertyValue);
    }

    // Custom font loading
    // NOTE: Compressed font image data (DEFLATE), it requires DecompressData() function
    // int darkFontDataSize = 0;
    // unsigned char *data = DecompressData(darkFontData, DARK_STYLE_FONT_ATLAS_COMP_SIZE, &darkFontDataSize);
    // Image imFont = { data, 256, 256, 1, 2 };

    // Font font = { 0 };
    // font.baseSize = 16;
    // font.glyphCount = 95;

    // // Load texture from image
    // font.texture = LoadTextureFromImage(imFont);
    // UnloadImage(imFont);  // Uncompressed image data can be unloaded from memory

    // // Copy char recs data from global fontRecs
    // // NOTE: Required to avoid issues if trying to free font
    // font.recs = (Rectangle *)RAYGUI_MALLOC(font.glyphCount*sizeof(Rectangle));
    // memcpy(font.recs, darkFontRecs, font.glyphCount*sizeof(Rectangle));

    // // Copy font char info data from global fontChars
    // // NOTE: Required to avoid issues if trying to free font
    // font.glyphs = (GlyphInfo *)RAYGUI_MALLOC(font.glyphCount*sizeof(GlyphInfo));
    // memcpy(font.glyphs, darkFontGlyphs, font.glyphCount*sizeof(GlyphInfo));

    // GuiSetFont(font);

    // // Setup a white rectangle on the font to be used on shapes drawing,
    // // it makes possible to draw shapes and text (full UI) in a single draw call
    // Rectangle fontWhiteRec = { 254, 254, 1, 1 };
    // SetShapesTexture(font.texture, fontWhiteRec);

    //-----------------------------------------------------------------

    // TODO: Custom user style setup: Set specific properties here (if required)
    // i.e. Controls specific BORDER_WIDTH, TEXT_PADDING, TEXT_ALIGNMENT
}
