# 📺 ML YouTube Courses

At DAIR.AI we ❤️ open AI education. In this repo, we index and organize some of the best and most recent machine learning courses available on YouTube.

**Machine Learning**

- [Caltech CS156: Learning from Data](#caltech-cs156-learning-from-data)
- [Stanford CS229: Machine Learning](#stanford-cs229-machine-learning)
- [Making Friends with Machine Learning](#making-friends-with-machine-learning)
- [Applied Machine Learning](#applied-machine-learning)
- [Introduction to Machine Learning (Tübingen)](#introduction-to-machine-learning-Tübingen)
- [Machine Learning Lecture (Stefan Harmeling)](#machine-learning-lecture-stefan-harmeling)
- [Statistical Machine Learning (Tübingen)](#statistical-machine-learning-Tübingen)
- [Probabilistic Machine Learning](#probabilistic-machine-learning)
- [MIT 6.S897: Machine Learning for Healthcare (2019)](#mit-6s897-machine-learning-for-healthcare-2019)

**Deep Learning**

- [Neural Networks: Zero to Hero](#neural-networks-zero-to-hero-by-andrej-karpathy)
- [MIT: Deep Learning for Art, Aesthetics, and Creativity](#mit-deep-learning-for-art-aesthetics-and-creativity)
- [Stanford CS230: Deep Learning (2018)](#stanford-cs230-deep-learning-2018)
- [Introduction to Deep Learning (MIT)](#introduction-to-deep-learning)
- [CMU Introduction to Deep Learning (11-785)](#cmu-introduction-to-deep-learning-11-785)
- [Deep Learning: CS 182](#deep-learning-cs-182)
- [Deep Unsupervised Learning](#deep-unsupervised-learning)
- [NYU Deep Learning SP21](#nyu-deep-learning-sp21)
- [Foundation Models](#foundation-models)
- [Deep Learning (Tübingen)](#deep-learning-Tübingen)

**Scientific Machine Learning**

- [Parallel Computing and Scientific Machine Learning](#parallel-computing-and-scientific-machine-learning)

**Practical Machine Learning**

- [LLMOps: Building Real-World Applications With Large Language Models](#llmops-building-real-world-applications-with-large-language-models)
- [Evaluating and Debugging Generative AI](#evaluating-and-debugging-generative-ai)
- [ChatGPT Prompt Engineering for Developers](#chatgpt-prompt-engineering-for-developers)
- [LangChain for LLM Application Development](#langchain-for-llm-application-development)
- [LangChain: Chat with Your Data](#langchain-chat-with-your-data)
- [Building Systems with the ChatGPT API](#building-systems-with-the-chatgpt-api)
- [LangChain & Vector Databases in Production](#langchain--vector-databases-in-production)
- [Building LLM-Powered Apps](#building-llm-powered-apps)
- [Full Stack LLM Bootcamp](#full-stack-llm-bootcamp)
- [Full Stack Deep Learning](#full-stack-deep-learning)
- [Practical Deep Learning for Coders](#practical-deep-learning-for-coders)
- [Stanford MLSys Seminars](#stanford-mlsys-seminars)
- [Machine Learning Engineering for Production (MLOps)](#machine-learning-engineering-for-production-mlops)
- [MIT Introduction to Data-Centric AI](#mit-introduction-to-data-centric-ai)

**Natural Language Processing**

- [XCS224U: Natural Language Understanding (2023)](#xcs224u-natural-language-understanding-2023)
- [Stanford CS25 - Transformers United](#stanford-cs25---transformers-united)
- [NLP Course (Hugging Face)](#nlp-course-hugging-face)
- [CS224N: Natural Language Processing with Deep Learning](#cs224n-natural-language-processing-with-deep-learning)
- [CMU Neural Networks for NLP](#cmu-neural-networks-for-nlp)
- [CS224U: Natural Language Understanding](#cs224u-natural-language-understanding)
- [CMU Advanced NLP 2021/2022/2024](#cmu-advanced-nlp)
- [Multilingual NLP](#multilingual-nlp)
- [Advanced NLP](#advanced-nlp)

**Computer Vision**

- [CS231N: Convolutional Neural Networks for Visual Recognition](#cs231n-convolutional-neural-networks-for-visual-recognition)
- [Deep Learning for Computer Vision](#deep-learning-for-computer-vision)
- [Deep Learning for Computer Vision (DL4CV)](#deep-learning-for-computer-vision-dl4cv)
- [Deep Learning for Computer Vision (neuralearn.ai)](#deep-learning-for-computer-vision-neuralearnai)

**Reinforcement Learning**

- [Deep Reinforcement Learning](#deep-reinforcement-learning)
- [Reinforcement Learning Lecture Series (DeepMind)](#reinforcement-learning-lecture-series-deepmind)
- [Reinforcement Learning (Polytechnique Montreal, Fall 2021)](#reinforcement-learning-polytechnique-montreal-fall-2021)
- [Foundations of Deep RL](#foundations-of-deep-rl)
- [Stanford CS234: Reinforcement Learning](#stanford-cs234-reinforcement-learning)

**Graph Machine Learning**

- [Machine Learning with Graphs (Stanford)](#machine-learning-with-graphs-stanford)
- [AMMI Geometric Deep Learning Course](#ammi-geometric-deep-learning-course)

**Multi-Task Learning**

- [Multi-Task and Meta-Learning (Stanford)](#stanford-cs330-deep-multi-task-and-meta-learning)

**Others**

- [MIT Deep Learning in Life Sciences](#mit-deep-learning-in-life-sciences)
- [Self-Driving Cars (Tübingen)](#self-driving-cars-Tübingen)
- [Advanced Robotics (Berkeley)](#advanced-robotics-uc-berkeley)

---

## Caltech CS156: Learning from Data

An introductory course in machine learning that covers the basic theory, algorithms, and applications.

- Lecture 1: The Learning Problem
- Lecture 2: Is Learning Feasible?
- Lecture 3: The Linear Model I
- Lecture 4: Error and Noise
- Lecture 5: Training versus Testing
- Lecture 6: Theory of Generalization
- Lecture 7: The VC Dimension
- Lecture 8: Bias-Variance Tradeoff
- Lecture 9: The Linear Model II
- Lecture 10: Neural Networks
- Lecture 11: Overfitting
- Lecture 12: Regularization
- Lecture 13: Validation
- Lecture 14: Support Vector Machines
- Lecture 15: Kernel Methods
- Lecture 16: Radial Basis Functions
- Lecture 17: Three Learning Principles
- Lecture 18: Epilogue

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLD63A284B7615313A)

## Stanford CS229: Machine Learning

To learn some of the basics of ML:

- Linear Regression and Gradient Descent
- Logistic Regression
- Naive Bayes
- SVMs
- Kernels
- Decision Trees
- Introduction to Neural Networks
- Debugging ML Models
  ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLoROMvodv4rMiGQp3WXShtMGgzqpfVfbU)

## Making Friends with Machine Learning

A series of mini lectures covering various introductory topics in ML:

- Explainability in AI
- Classification vs. Regression
- Precession vs. Recall
- Statistical Significance
- Clustering and K-means
- Ensemble models
  ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLRKtJ4IpxJpDxl0NTvNYQWKCYzHNuy2xG)

## Neural Networks: Zero to Hero (by Andrej Karpathy)

Course providing an in-depth overview of neural networks.

- Backpropagation
- Spelled-out intro to Language Modeling
- Activation and Gradients
- Becoming a Backprop Ninja

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLAqhIrjkxbuWI23v9cThsA9GvCAUhRvKZ)

## MIT: Deep Learning for Art, Aesthetics, and Creativity

Covers the application of deep learning for art, aesthetics, and creativity.

- Nostalgia -> Art -> Creativity -> Evolution as Data + Direction
- Efficient GANs
- Explorations in AI for Creativity
- Neural Abstractions
- Easy 3D Content Creation with Consistent Neural Fields
  ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLCpMvp7ftsnIbNwRnQJbDNRqO6qiN3EyH)

## Stanford CS230: Deep Learning (2018)

Covers the foundations of deep learning, how to build different neural networks(CNNs, RNNs, LSTMs, etc...), how to lead machine learning projects, and career advice for deep learning practitioners.

- Deep Learning Intuition
- Adversarial examples - GANs
- Full-cycle of a Deep Learning Project
- AI and Healthcare
- Deep Learning Strategy
- Interpretability of Neural Networks
- Career Advice and Reading Research Papers
- Deep Reinforcement Learning

🔗 [Link to Course](https://youtube.com/playlist?list=PLoROMvodv4rOABXSygHTsbvUz4G_YQhOb) 🔗 [Link to Materials](https://cs230.stanford.edu/syllabus/)

## Applied Machine Learning

To learn some of the most widely used techniques in ML:

- Optimization and Calculus
- Overfitting and Underfitting
- Regularization
- Monte Carlo Estimation
- Maximum Likelihood Learning
- Nearest Neighbours
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PL2UML_KCiC0UlY7iCQDSiGDMovaupqc83)

## Introduction to Machine Learning (Tübingen)

The course serves as a basic introduction to machine learning and covers key concepts in regression, classification, optimization, regularization, clustering, and dimensionality reduction.

- Linear regression
- Logistic regression
- Regularization
- Boosting
- Neural networks
- PCA
- Clustering
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PL05umP7R6ij35ShKLDqccJSDntugY4FQT)

## Machine Learning Lecture (Stefan Harmeling)

Covers many fundamental ML concepts:

- Bayes rule
- From logic to probabilities
- Distributions
- Matrix Differential Calculus
- PCA
- K-means and EM
- Causality
- Gaussian Processes
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLzrCXlf6ypbxS5OYOY3EN_0u2fDuIT6Gt)

## Statistical Machine Learning (Tübingen)

The course covers the standard paradigms and algorithms in statistical machine learning.

- KNN
- Bayesian decision theory
- Convex optimization
- Linear and ridge regression
- Logistic regression
- SVM
- Random Forests
- Boosting
- PCA
- Clustering
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PL05umP7R6ij2XCvrRzLokX6EoHWaGA2cC)

## Practical Deep Learning for Coders

This course covers topics such as how to:

- Build and train deep learning models for computer vision, natural language processing, tabular analysis, and collaborative filtering problems
- Create random forests and regression models
- Deploy models
- Use PyTorch, the world’s fastest growing deep learning software, plus popular libraries like fastai and Hugging Face
- Foundations and Deep Dive to Diffusion Models
- ...

🔗 [Link to Course - Part 1](https://www.youtube.com/playlist?list=PLfYUBJiXbdtSvpQjSnJJ_PmDQB_VyT5iU)

🔗 [Link to Course - Part 2](https://www.youtube.com/watch?v=_7rMfsA24Ls&ab_channel=JeremyHoward)

## Stanford MLSys Seminars

A seminar series on all sorts of topics related to building machine learning systems.

🔗 [Link to Lectures](https://www.youtube.com/playlist?list=PLSrTvUm384I9PV10koj_cqit9OfbJXEkq)

## Machine Learning Engineering for Production (MLOps)

Specialization course on MLOPs by Andrew Ng.

🔗 [Link to Lectures](https://www.youtube.com/playlist?list=PLkDaE6sCZn6GMoA0wbpJLi3t34Gd8l0aK)

## MIT Introduction to Data-Centric AI

Covers the emerging science of Data-Centric AI (DCAI) that studies techniques to improve datasets, which is often the best way to improve performance in practical ML applications. Topics include:

- Data-Centric AI vs. Model-Centric AI
- Label Errors
- Dataset Creation and Curation
- Data-centric Evaluation of ML Models
- Class Imbalance, Outliers, and Distribution Shift
- ...

🔗 [Course Website](https://dcai.csail.mit.edu/)

🔗 [Lecture Videos](https://www.youtube.com/watch?v=ayzOzZGHZy4&list=PLnSYPjg2dHQKdig0vVbN-ZnEU0yNJ1mo5)

🔗 [Lab Assignments](https://github.com/dcai-course/dcai-lab)

## Machine Learning with Graphs (Stanford)

To learn some of the latest graph techniques in machine learning:

- PageRank
- Matrix Factorizing
- Node Embeddings
- Graph Neural Networks
- Knowledge Graphs
- Deep Generative Models for Graphs
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLoROMvodv4rPLKxIpqhjhPgdQy7imNkDn)

## Probabilistic Machine Learning

To learn the probabilistic paradigm of ML:

- Reasoning about uncertainty
- Continuous Variables
- Sampling
- Markov Chain Monte Carlo
- Gaussian Distributions
- Graphical Models
- Tuning Inference Algorithms
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PL05umP7R6ij2YE8rRJSb-olDNbntAQ_Bx)

## MIT 6.S897: Machine Learning for Healthcare (2019)

This course introduces students to machine learning in healthcare, including the nature of clinical data and the use of machine learning for risk stratification, disease progression modeling, precision medicine, diagnosis, subtype discovery, and improving clinical workflows.

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLUl4u3cNGP60B0PQXVQyGNdCyCTDU1Q5j)

## Introduction to Deep Learning

To learn some of the fundamentals of deep learning:

- Introduction to Deep Learning

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLtBw6njQRU-rwp5__7C0oIVt26ZgjG9NI)

## CMU Introduction to Deep Learning (11-785)

The course starts off gradually from MLPs (Multi Layer Perceptrons) and then progresses into concepts like attention
and sequence-to-sequence models.

🔗 [Link to Course](https://deeplearning.cs.cmu.edu/F22/index.html) \
🔗 [Lectures](https://www.youtube.com/playlist?list=PLp-0K3kfddPxRmjgjm0P1WT6H-gTqE8j9) \
🔗 [Tutorials/Recitations](https://www.youtube.com/playlist?list=PLp-0K3kfddPz8WXg8RqH0sEN6X2L65HUZ)

## Deep Learning: CS 182

To learn some of the widely used techniques in deep learning:

- Machine Learning Basics
- Error Analysis
- Optimization
- Backpropagation
- Initialization
- Batch Normalization
- Style transfer
- Imitation Learning
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PL_iWQOsE6TfVmKkQHucjPAoRtIJYt8a5A)

## Deep Unsupervised Learning

To learn the latest and most widely used techniques in deep unsupervised learning:

- Autoregressive Models
- Flow Models
- Latent Variable Models
- Self-supervised learning
- Implicit Models
- Compression
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLwRJQ4m4UJjPiJP3691u-qWwPGVKzSlNP)

## NYU Deep Learning SP21

To learn some of the advanced techniques in deep learning:

- Neural Nets: rotation and squashing
- Latent Variable Energy Based Models
- Unsupervised Learning
- Generative Adversarial Networks
- Autoencoders
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLLHTzKZzVU9e6xUfG10TkTWApKSZCzuBI)

## Foundation Models

To learn about foundation models like GPT-3, CLIP, Flamingo, Codex, and DINO.

🔗 [Link to Course](https://www.youtube.com/playlist?list=PL9t0xVFP90GD8hox0KipBkJcLX_C3ja67)

## Deep Learning (Tübingen)

This course introduces the practical and theoretical principles of deep neural networks.

- Computation graphs
- Activation functions and loss functions
- Training, regularization and data augmentation
- Basic and state-of-the-art deep neural network architectures including convolutional networks and graph neural networks
- Deep generative models such as auto-encoders, variational auto-encoders and generative adversarial networks
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PL05umP7R6ij3NTWIdtMbfvX7Z-4WEXRqD)

## Parallel Computing and Scientific Machine Learning

- The Basics of Scientific Simulators
- Introduction to Parallel Computing
- Continuous Dynamics
- Inverse Problems and Differentiable Programming
- Distributed Parallel Computing
- Physics-Informed Neural Networks and Neural Differential Equations
- Probabilistic Programming, AKA Bayesian Estimation on Programs
- Globalizing the Understanding of Models

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLCAl7tjCwWyGjdzOOnlbGnVNZk0kB8VSa)

## XCS224U: Natural Language Understanding (2023)

This course covers topics such as:

- Contextual Word Representations
- Information Retrieval
- In-context learning
- Behavioral Evaluation of NLU models
- NLP Methods and Metrics
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLoROMvodv4rOwvldxftJTmoR3kRcWkJBp)

## Stanford CS25 - Transformers United

This course consists of lectures focused on Transformers, providing a deep dive and their applications

- Introduction to Transformers
- Transformers in Language: GPT-3, Codex
- Applications in Vision
- Transformers in RL & Universal
  Compute Engines
- Scaling transformers
- Interpretability with transformers
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLoROMvodv4rNiJRchCzutFw5ItR_Z27CM)

## NLP Course (Hugging Face)

Learn about different NLP concepts and how to apply language models and Transformers to NLP:

- What is Transfer Learning?
- BPE Tokenization
- Batching inputs
- Fine-tuning models
- Text embeddings and semantic search
- Model evaluation
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLo2EIpI_JMQvWfQndUesu0nPBAtZ9gP1o)

## CS224N: Natural Language Processing with Deep Learning

To learn the latest approaches for deep learning based NLP:

- Dependency parsing
- Language models and RNNs
- Question Answering
- Transformers and pretraining
- Natural Language Generation
- T5 and Large Language Models
- Future of NLP
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLoROMvodv4rOSH4v6133s9LFPRHjEmbmJ)

## CMU Neural Networks for NLP

To learn the latest neural network based techniques for NLP:

- Language Modeling
- Efficiency tricks
- Conditioned Generation
- Structured Prediction
- Model Interpretation
- Advanced Search Algorithms
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PL8PYTP1V4I8AkaHEJ7lOOrlex-pcxS-XV)

## CS224U: Natural Language Understanding

To learn the latest concepts in natural language understanding:

- Grounded Language Understanding
- Relation Extraction
- Natural Language Inference (NLI)
- NLU and Neural Information Extraction
- Adversarial testing
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLoROMvodv4rPt5D0zs3YhbWSZA8Q_DyiJ)

## CMU Advanced NLP

To learn:

- Basics of modern NLP techniques
- Multi-task, Multi-domain, multi-lingual learning
- Prompting + Sequence-to-sequence pre-training
- Interpreting and Debugging NLP Models
- Learning from Knowledge-bases
- Adversarial learning
- ...

🔗 [Link to 2021 Edition](https://www.youtube.com/playlist?list=PL8PYTP1V4I8AYSXn_GKVgwXVluCT9chJ6)

🔗 [Link to 2022 Edition](https://www.youtube.com/playlist?list=PL8PYTP1V4I8D0UkqW2fEhgLrnlDW9QK7z)

🔗 [Link to 2024 Edition](https://www.youtube.com/playlist?list=PL8PYTP1V4I8DZprnWryM4nR8IZl1ZXDjg)

## Multilingual NLP

To learn the latest concepts for doing multilingual NLP:

- Typology
- Words, Part of Speech, and Morphology
- Advanced Text Classification
- Machine Translation
- Data Augmentation for MT
- Low Resource ASR
- Active Learning
- ...

🔗 [Link to 2020 Course](https://www.youtube.com/playlist?list=PL8PYTP1V4I8CHhppU6n1Q9-04m96D9gt5)

🔗 [Link to 2022 Course](https://www.youtube.com/playlist?list=PL8PYTP1V4I8BhCpzfdKKdd1OnTfLcyZr7)

## Advanced NLP

To learn advanced concepts in NLP:

- Attention Mechanisms
- Transformers
- BERT
- Question Answering
- Model Distillation
- Vision + Language
- Ethics in NLP
- Commonsense Reasoning
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLWnsVgP6CzadmQX6qevbar3_vDBioWHJL)

## CS231N: Convolutional Neural Networks for Visual Recognition

Stanford's Famous CS231n course. The videos are only available for the Spring 2017 semester. The course is currently known as Deep Learning for Computer Vision, but the Spring 2017 version is titled Convolutional Neural Networks for Visual Recognition.

- Image Classification
- Loss Functions and Optimization
- Introduction to Neural Networks
- Convolutional Neural Networks
- Training Neural Networks
- Deep Learning Software
- CNN Architectures
- Recurrent Neural Networks
- Detection and Segmentation
- Visualizing and Understanding
- Generative Models
- Deep Reinforcement Learning

🔗 [Link to Course](https://www.youtube.com/playlist?list=PL3FW7Lu3i5JvHM8ljYj-zLfQRF3EO8sYv) 🔗 [Link to Materials](http://cs231n.stanford.edu/2017/)

## Deep Learning for Computer Vision

To learn some of the fundamental concepts in CV:

- Introduction to deep learning for CV
- Image Classification
- Convolutional Networks
- Attention Networks
- Detection and Segmentation
- Generative Models

🔗 [Link to Course](https://www.youtube.com/playlist?list=PL5-TkQAfAZFbzxjBHtzdVCWE0Zbhomg7r)

## Deep Learning for Computer Vision (DL4CV)

To learn modern methods for computer vision:

- CNNs
- Advanced PyTorch
- Understanding Neural Networks
- RNN, Attention and ViTs
- Generative Models
- GPU Fundamentals
- Self-Supervision
- Neural Rendering
- Efficient Architectures

🔗 [Link to Course](https://www.youtube.com/playlist?list=PL_Z2_U9MIJdNgFM7-f2fZ9ZxjVRP_jhJv)

## Deep Learning for Computer Vision (neuralearn.ai)

To learn modern methods for computer vision:

- Self-Supervised Learning
- Neural Rendering
- Efficient Architectures
- Machine Learning Operations (MLOps)
- Modern Convolutional Neural Networks
- Transformers in Vision
- Model Deployment

🔗 [Link to Course](https://www.youtube.com/watch?v=IA3WxTTPXqQ)

## AMMI Geometric Deep Learning Course

To learn about concepts in geometric deep learning:

- Learning in High Dimensions
- Geometric Priors
- Grids
- Manifolds and Meshes
- Sequences and Time Warping
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLn2-dEmQeTfSLXW8yXP4q_Ii58wFdxb3C)

## Deep Reinforcement Learning

To learn the latest concepts in deep RL:

- Intro to RL
- RL algorithms
- Real-world sequential decision making
- Supervised learning of behaviors
- Deep imitation learning
- Cost functions and reward functions
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PL_iWQOsE6TfURIIhCrlt-wj9ByIVpbfGc)

## Reinforcement Learning Lecture Series (DeepMind)

The Deep Learning Lecture Series is a collaboration between DeepMind and the UCL Centre for Artificial Intelligence.

- Introduction to RL
- Dynamic Programming
- Model-free algorithms
- Deep reinforcement learning
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLqYmG7hTraZDVH599EItlEWsUOsJbAodm)


## LLMOps: Building Real-World Applications With Large Language Models

Learn to build modern software with LLMs using the newest tools and techniques in the field.

🔗 [Link to Course](https://www.comet.com/site/llm-course/)

## Evaluating and Debugging Generative AI

You'll learn:

- Instrument A Jupyter Notebook
- Manage Hyperparameters Config
- Log Run Metrics
- Collect artifacts for dataset and model versioning
- Log experiment results
- Trace prompts and responses for LLMs
- ...

🔗 [Link to Course](https://www.deeplearning.ai/short-courses/evaluating-debugging-generative-ai/)

## ChatGPT Prompt Engineering for Developers

Learn how to use a large language model (LLM) to quickly build new and powerful applications.

🔗 [Link to Course](https://www.deeplearning.ai/short-courses/chatgpt-prompt-engineering-for-developers/)

## LangChain for LLM Application Development

You'll learn:

- Models, Prompt, and Parsers
- Memories for LLMs
- Chains
- Question Answering over Documents
- Agents

🔗 [Link to Course](https://www.deeplearning.ai/short-courses/langchain-for-llm-application-development/)

## LangChain: Chat with Your Data

You'll learn about:

- Document Loading
- Document Splitting
- Vector Stores and Embeddings
- Retrieval
- Question Answering
- Chat

🔗 [Link to Course](https://www.deeplearning.ai/short-courses/building-systems-with-chatgpt/)

## Building Systems with the ChatGPT API

Learn how to automate complex workflows using chain calls to a large language model.

🔗 [Link to Course](https://www.deeplearning.ai/short-courses/building-systems-with-chatgpt/)

## LangChain & Vector Databases in Production

Learn how to use LangChain and Vector DBs in Production:

- LLMs and LangChain
- Learning how to Prompt
- Keeping Knowledge Organized with Indexes
- Combining Components Together with Chains
- ...

🔗 [Link to Course](https://learn.activeloop.ai/courses/langchain)

## Building LLM-Powered Apps

Learn how to build LLM-powered applications using LLM APIs

- Unpacking LLM APIs
- Building a Baseline LLM Application
- Enhancing and Optimizing LLM Applications
- ...

🔗 [Link to Course](https://www.wandb.courses/courses/building-llm-powered-apps)

## Full Stack LLM Bootcamp

To learn how to build and deploy LLM-powered applications:

- Learn to Spell: Prompt Engineering
- LLMOPs
- UX for Language User Interfaces
- Augmented Language Models
- Launch an LLM App in One Hour
- LLM Foundations
- Project Walkthrough: askFSDL
- ...

🔗 [Link to Course](https://fullstackdeeplearning.com/llm-bootcamp/spring-2023/)

## Full Stack Deep Learning

To learn full-stack production deep learning:

- ML Projects
- Infrastructure and Tooling
- Experiment Managing
- Troubleshooting DNNs
- Data Management
- Data Labeling
- Monitoring ML Models
- Web deployment
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PL1T8fO7ArWlcWg04OgNiJy91PywMKT2lv)

## Introduction to Deep Learning and Deep Generative Models

Covers the fundamental concepts of deep learning

- Single-layer neural networks and gradient descent
- Multi-layer neural networks and backpropagation
- Convolutional neural networks for images
- Recurrent neural networks for text
- Autoencoders, variational autoencoders, and generative adversarial networks
- Encoder-decoder recurrent neural networks and transformers
- PyTorch code examples

🔗 [Link to Course](https://www.youtube.com/watch?v=1nqCZqDYPp0&list=PLTKMiZHVd_2KJtIXOW0zFhFfBaJJilH51) 🔗 [Link to Materials](https://sebastianraschka.com/blog/2021/dl-course.html)

## Self-Driving Cars (Tübingen)

Covers the most dominant paradigms of self-driving cars: modular pipeline-based approaches as well as deep-learning based end-to-end driving techniques.

- Camera, lidar and radar-based perception
- Localization, navigation, path planning
- Vehicle modeling/control
- Deep Learning
- Imitation learning
- Reinforcement learning

🔗 [Link to Course](https://www.youtube.com/playlist?list=PL05umP7R6ij321zzKXK6XCQXAaaYjQbzr)

## Reinforcement Learning (Polytechnique Montreal, Fall 2021)

Designing autonomous decision making systems is one of the longstanding goals of Artificial Intelligence. Such decision making systems, if realized, can have a big impact in machine learning for robotics, game playing, control, health care to name a few. This course introduces Reinforcement Learning as a general framework to design such autonomous decision making systems.

- Introduction to RL
- Multi-armed bandits
- Policy Gradient Methods
- Contextual Bandits
- Finite Markov Decision Process
- Dynamic Programming
- Policy Iteration, Value Iteration
- Monte Carlo Methods
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLImtCgowF_ES_JdF_UcM60EXTcGZg67Ua) 🔗 [Link to Materials](https://chandar-lab.github.io/INF8953DE/)

## Foundations of Deep RL

A mini 6-lecture series by Pieter Abbeel.

- MDPs, Exact Solution Methods, Max-ent RL
- Deep Q-Learning
- Policy Gradients and Advantage Estimation
- TRPO and PPO
- DDPG and SAC
- Model-based RL

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLwRJQ4m4UJjNymuBM9RdmB3Z9N5-0IlY0)

## Stanford CS234: Reinforcement Learning

Covers topics from basic concepts of Reinforcement Learning to more advanced ones:

- Markov decision processes & planning
- Model-free policy evaluation
- Model-free control
- Reinforcement learning with function approximation & Deep RL
- Policy Search
- Exploration
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLoROMvodv4rOSOPzutgyCTapiGlY2Nd8u) 🔗 [Link to Materials](https://web.stanford.edu/class/cs234/)

## Stanford CS330: Deep Multi-Task and Meta Learning

This is a graduate-level course covering different aspects of deep multi-task and meta learning.

- Multi-task learning, transfer learning basics
- Meta-learning algorithms
- Advanced meta-learning topics
- Multi-task RL, goal-conditioned RL
- Meta-reinforcement learning
- Hierarchical RL
- Lifelong learning
- Open problems

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLoROMvodv4rMC6zfYmnD7UG3LVvwaITY5) 🔗 [Link to Materials](https://cs330.stanford.edu/)

## MIT Deep Learning in Life Sciences

A course introducing foundations of ML for applications in genomics and the life sciences more broadly.

- Interpreting ML Models
- DNA Accessibility, Promoters and Enhancers
- Chromatin and gene regulation
- Gene Expression, Splicing
- RNA-seq, Splicing
- Single cell RNA-sequencing
- Dimensionality Reduction, Genetics, and Variation
- Drug Discovery
- Protein Structure Prediction
- Protein Folding
- Imaging and Cancer
- Neuroscience

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLypiXJdtIca5ElZMWHl4HMeyle2AzUgVB)

🔗 [Link to Materials](https://mit6874.github.io/)

## Advanced Robotics: UC Berkeley

This is course is from Peter Abbeel and covers a review on reinforcement learning and continues to applications in robotics.

- MDPs: Exact Methods
- Discretization of Continuous State Space MDPs
- Function Approximation / Feature-based Representations
- LQR, iterative LQR / Differential Dynamic Programming
- ...

🔗 [Link to Course](https://www.youtube.com/playlist?list=PLwRJQ4m4UJjNBPJdt8WamRAt4XKc639wF) 🔗 [Link to Materials](https://people.eecs.berkeley.edu/~pabbeel/cs287-fa19/)

---

Reach out on [Twitter](https://twitter.com/omarsar0) if you have any questions.

If you are interested to contribute, feel free to open a PR with a link to the course. It will take a bit of time, but I have plans to do many things with these individual lectures. We can summarize the lectures, include notes, provide additional reading material, include difficulty of content, etc.

You can now find ML Course notes [here](https://github.com/dair-ai/ML-Course-Notes).
