<?php

namespace Jblv\Admin\Form\Field;

use Illuminate\Contracts\Support\Arrayable;
use Jblv\Admin\Form\Field;

class Radio extends Field
{
    protected $inline = true;

    protected static $css = [
        '/vendor/daimakuai-admin/AdminLTE/plugins/iCheck/all.css',
    ];

    protected static $js = [
        'vendor/daimakuai-admin/AdminLTE/plugins/iCheck/icheck.min.js',
    ];

    /**
     * Set options.
     *
     * @param array|callable|string $options
     *
     * @return $this
     */
    public function options($options = [])
    {
        if ($options instanceof Arrayable) {
            $options = $options->toArray();
        }

        $this->options = (array) $options;

        return $this;
    }

    /**
     * Draw inline radios.
     *
     * @return $this
     */
    public function inline()
    {
        $this->inline = true;

        return $this;
    }

    /**
     * Draw stacked radios.
     *
     * @return $this
     */
    public function stacked()
    {
        $this->inline = false;

        return $this;
    }

    /**
     * Set options.
     *
     * @param array|callable|string $values
     *
     * @return $this
     */
    public function values($values)
    {
        return $this->options($values);
    }

    /**
     * {@inheritdoc}
     */
    public function render()
    {
        $this->script = "$('{$this->getElementClassSelector()}').iCheck({radioClass:'iradio_minimal-blue'});";

        return parent::render()->with(['options' => $this->options, 'inline' => $this->inline]);
    }
}
