<?php

namespace Jblv\Admin\Controllers;

use Jblv\Admin\Admin;

class Dashboard
{
    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public static function title()
    {
        return view('admin::dashboard.title');
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public static function environment()
    {
        $envs = [
            ['name' => 'PHP version',       'value' => 'PHP/'.PHP_VERSION],
            ['name' => 'Laravel version',   'value' => app()->version()],
            ['name' => 'CGI',               'value' => php_sapi_name()],
            ['name' => 'Uname',             'value' => php_uname()],
            ['name' => 'Server',            'value' => array_get($_SERVER, 'SERVER_SOFTWARE')],

            ['name' => 'Cache driver',      'value' => config('cache.default')],
            ['name' => 'Session driver',    'value' => config('session.driver')],
            ['name' => 'Queue driver',      'value' => config('queue.default')],

            ['name' => 'Timezone',          'value' => config('app.timezone')],
            ['name' => 'Locale',            'value' => config('app.locale')],
            ['name' => 'Env',               'value' => config('app.env')],
            ['name' => 'URL',               'value' => config('app.url')],
        ];

        return view('admin::dashboard.environment', compact('envs'));
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public static function extensions()
    {
        $extensions = [
            'helpers' => [
                'name' => 'daimakuai-ext/helpers',
                'link' => 'https://github.com/daimakuai-ext/helpers',
                'icon' => 'gears',
            ],
            'log-viewer' => [
                'name' => 'daimakuai-ext/log-viewer',
                'link' => 'https://github.com/daimakuai-ext/log-viewer',
                'icon' => 'database',
            ],
            'backup' => [
                'name' => 'daimakuai-ext/backup',
                'link' => 'https://github.com/daimakuai-ext/backup',
                'icon' => 'copy',
            ],
            'config' => [
                'name' => 'daimakuai-ext/config',
                'link' => 'https://github.com/daimakuai-ext/config',
                'icon' => 'toggle-on',
            ],
            'api-tester' => [
                'name' => 'daimakuai-ext/api-tester',
                'link' => 'https://github.com/daimakuai-ext/api-tester',
                'icon' => 'sliders',
            ],
            'media-manager' => [
                'name' => 'daimakuai-ext/media-manager',
                'link' => 'https://github.com/daimakuai-ext/media-manager',
                'icon' => 'file',
            ],
            'scheduling' => [
                'name' => 'daimakuai-ext/scheduling',
                'link' => 'https://github.com/daimakuai-ext/scheduling',
                'icon' => 'clock-o',
            ],
            'reporter' => [
                'name' => 'daimakuai-ext/reporter',
                'link' => 'https://github.com/daimakuai-ext/reporter',
                'icon' => 'bug',
            ],
            'translation' => [
                'name' => 'daimakuai-ext/translation',
                'link' => 'https://github.com/daimakuai-ext/translation',
                'icon' => 'language',
            ],
        ];

        foreach ($extensions as &$extension) {
            $name = explode('/', $extension['name']);
            $extension['installed'] = array_key_exists(end($name), Admin::$extensions);
        }

        return view('admin::dashboard.extensions', compact('extensions'));
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public static function dependencies()
    {
        $json = file_get_contents(base_path('composer.json'));

        $dependencies = json_decode($json, true)['require'];

        return view('admin::dashboard.dependencies', compact('dependencies'));
    }
}
