<!DOCTYPE html>
<html lang="{{ config('app.locale') }}">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{{ Admin::title() }}</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

    <link rel="stylesheet" href="{{ admin_asset("/vendor/daimakuai-admin/AdminLTE/bootstrap/css/bootstrap.min.css") }}">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="{{ admin_asset("/vendor/daimakuai-admin/font-awesome/css/font-awesome.min.css") }}">

    <!-- Theme style -->
    <link rel="stylesheet" href="{{ admin_asset("/vendor/daimakuai-admin/AdminLTE/dist/css/skins/" . config('admin.skin') .".min.css") }}">

    {!! Admin::css() !!}
    <link rel="stylesheet" href="{{ admin_asset("/vendor/daimakuai-admin/daimakuai-admin/daimakuai-admin.css") }}">
    <link rel="stylesheet" href="{{ admin_asset("/vendor/daimakuai-admin/nprogress/nprogress.css") }}">
    <link rel="stylesheet" href="{{ admin_asset("/vendor/daimakuai-admin/sweetalert/dist/sweetalert.css") }}">
    <link rel="stylesheet" href="{{ admin_asset("/vendor/daimakuai-admin/nestable/nestable.css") }}">
    <link rel="stylesheet" href="{{ admin_asset("/vendor/daimakuai-admin/toastr/build/toastr.min.css") }}">
    <link rel="stylesheet" href="{{ admin_asset("/vendor/daimakuai-admin/bootstrap3-editable/css/bootstrap-editable.css") }}">
    <link rel="stylesheet" href="{{ admin_asset("/vendor/daimakuai-admin/google-fonts/fonts.css") }}">
    <link rel="stylesheet" href="{{ admin_asset("/vendor/daimakuai-admin/AdminLTE/dist/css/AdminLTE.min.css") }}">
    {{--<link rel="stylesheet" href="{{ admin_asset("/vendor/daimakuai-admin/AdminLTE/dist/css/skins/all-skins.min.css") }}">--}}

    <!-- REQUIRED JS SCRIPTS -->

    <script src="{{ admin_asset ("/vendor/daimakuai-admin/AdminLTE/plugins/jQuery/jQuery-2.2.3.min.js") }}"></script>
    <script src="{{ admin_asset ("/vendor/daimakuai-admin/AdminLTE/bootstrap/js/bootstrap.min.js") }}"></script>
    <script src="{{ admin_asset ("/vendor/daimakuai-admin/AdminLTE/plugins/slimScroll/jquery.slimscroll.min.js") }}"></script>
    <script src="https://cdn.bootcss.com/jquery-cookie/1.4.1/jquery.cookie.min.js"></script>
    <script src="{{ admin_asset ("/vendor/daimakuai-admin/AdminLTE/plugins/fastclick/fastclick.js") }}"></script>
    <script src="{{ admin_asset ("/vendor/daimakuai-admin/AdminLTE/dist/js/app.min.js") }}"></script>

    <script src="{{ admin_asset ("/vendor/daimakuai-admin/AdminLTE/dist/js/app_iframe.js") }}"></script>
    <script src="{{ admin_asset ("/vendor/daimakuai-admin/jquery-pjax/jquery.pjax.js") }}"></script>
    <script src="{{ admin_asset ("/vendor/daimakuai-admin/nprogress/nprogress.js") }}"></script>

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->

</head>

<body class="hold-transition {{config('admin.skin')}} {{join(' ', config('admin.layout'))}}">
<div class="wrapper">

    @include('admin::partials.header')

    @include('admin::partials.sidebar')


    <div class="content-wrapper" id="pjax-container">

    @yield('content')
    {!! Admin::script() !!}

        <!--bootstrap tab风格 多标签页-->
        {{--<div class="content-tabs">--}}
            {{--<button class="roll-nav roll-left tabLeft" onclick="scrollTabLeft()">--}}
                {{--<i class="fa fa-backward"></i>--}}
            {{--</button>--}}
            {{--<nav class="page-tabs menuTabs tab-ui-menu" id="tab-menu">--}}
                {{--<div class="page-tabs-content" style="margin-left: 0px;">--}}

                {{--</div>--}}
            {{--</nav>--}}
            {{--<button class="roll-nav roll-right tabRight" onclick="scrollTabRight()">--}}
                {{--<i class="fa fa-forward" style="margin-left: 3px;"></i>--}}
            {{--</button>--}}
            {{--<div class="btn-group roll-nav roll-right">--}}
                {{--<button class="dropdown tabClose" data-toggle="dropdown">--}}
                    {{--页签操作<i class="fa fa-caret-down" style="padding-left: 3px;"></i>--}}
                {{--</button>--}}
                {{--<ul class="dropdown-menu dropdown-menu-right" style="min-width: 128px;">--}}
                    {{--<li><a class="tabReload" href="javascript:refreshTab();">刷新当前</a></li>--}}
                    {{--<li><a class="tabCloseCurrent" href="javascript:closeCurrentTab();">关闭当前</a></li>--}}
                    {{--<li><a class="tabCloseAll" href="javascript:closeOtherTabs(true);">全部关闭</a></li>--}}
                    {{--<li><a class="tabCloseOther" href="javascript:closeOtherTabs();">除此之外全部关闭</a></li>--}}
                {{--</ul>--}}
            {{--</div>--}}
            {{--<button class="roll-nav roll-right fullscreen" onclick="App.handleFullScreen()"><i--}}
                        {{--class="fa fa-arrows-alt"></i></button>--}}
        {{--</div>--}}
        {{--<div class="content-iframe " style="background-color: #ffffff; " >--}}
            {{--<div class="tab-content " id="tab-content">--}}
              {{----}}
            {{--</div>--}}
        {{--</div>--}}


    </div>


    @include('admin::partials.footer')

            <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
        <!-- Create the tabs -->
        <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
            <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>
            <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
        </ul>
        <!-- Tab panes -->
        <div class="tab-content">
            <!-- Home tab content -->
            <div class="tab-pane" id="control-sidebar-home-tab">
                <h3 class="control-sidebar-heading">Recent Activity</h3>
                <ul class="control-sidebar-menu">
                    <li>
                        <a href="javascript:void(0)">
                            <i class="menu-icon fa fa-birthday-cake bg-red"></i>

                            <div class="menu-info">
                                <h4 class="control-sidebar-subheading">Langdon's Birthday</h4>

                                <p>Will be 23 on April 24th</p>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:void(0)">
                            <i class="menu-icon fa fa-user bg-yellow"></i>

                            <div class="menu-info">
                                <h4 class="control-sidebar-subheading">Frodo Updated His Profile</h4>

                                <p>New phone +1(800)555-1234</p>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:void(0)">
                            <i class="menu-icon fa fa-envelope-o bg-light-blue"></i>

                            <div class="menu-info">
                                <h4 class="control-sidebar-subheading">Nora Joined Mailing List</h4>

                                <p>nora@example.com</p>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:void(0)">
                            <i class="menu-icon fa fa-file-code-o bg-green"></i>

                            <div class="menu-info">
                                <h4 class="control-sidebar-subheading">Cron Job 254 Executed</h4>

                                <p>Execution time 5 seconds</p>
                            </div>
                        </a>
                    </li>
                </ul>
                <!-- /.control-sidebar-menu -->

                <h3 class="control-sidebar-heading">Tasks Progress</h3>
                <ul class="control-sidebar-menu">
                    <li>
                        <a href="javascript:void(0)">
                            <h4 class="control-sidebar-subheading">
                                Custom Template Design
                                <span class="label label-danger pull-right">70%</span>
                            </h4>

                            <div class="progress progress-xxs">
                                <div class="progress-bar progress-bar-danger" style="width: 70%"></div>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:void(0)">
                            <h4 class="control-sidebar-subheading">
                                Update Resume
                                <span class="label label-success pull-right">95%</span>
                            </h4>

                            <div class="progress progress-xxs">
                                <div class="progress-bar progress-bar-success" style="width: 95%"></div>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:void(0)">
                            <h4 class="control-sidebar-subheading">
                                Laravel Integration
                                <span class="label label-warning pull-right">50%</span>
                            </h4>

                            <div class="progress progress-xxs">
                                <div class="progress-bar progress-bar-warning" style="width: 50%"></div>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:void(0)">
                            <h4 class="control-sidebar-subheading">
                                Back End Framework
                                <span class="label label-primary pull-right">68%</span>
                            </h4>

                            <div class="progress progress-xxs">
                                <div class="progress-bar progress-bar-primary" style="width: 68%"></div>
                            </div>
                        </a>
                    </li>
                </ul>
                <!-- /.control-sidebar-menu -->

            </div>
            <!-- /.tab-pane -->
            <!-- Stats tab content -->
            <div class="tab-pane" id="control-sidebar-stats-tab">Stats Tab Content</div>
            <!-- /.tab-pane -->
            <!-- Settings tab content -->
            <div class="tab-pane" id="control-sidebar-settings-tab">
                <form method="post">
                    <h3 class="control-sidebar-heading">General Settings</h3>

                    <div class="form-group">
                        <label class="control-sidebar-subheading">
                            Report panel usage
                            <input type="checkbox" class="pull-right" checked>
                        </label>

                        <p>
                            Some information about this general settings option
                        </p>
                    </div>
                    <!-- /.form-group -->

                    <div class="form-group">
                        <label class="control-sidebar-subheading">
                            Allow mail redirect
                            <input type="checkbox" class="pull-right" checked>
                        </label>

                        <p>
                            Other sets of options are available
                        </p>
                    </div>
                    <!-- /.form-group -->

                    <div class="form-group">
                        <label class="control-sidebar-subheading">
                            Expose author name in posts
                            <input type="checkbox" class="pull-right" checked>
                        </label>

                        <p>
                            Allow the user to show his name in blog posts
                        </p>
                    </div>
                    <!-- /.form-group -->

                    <h3 class="control-sidebar-heading">Chat Settings</h3>

                    <div class="form-group">
                        <label class="control-sidebar-subheading">
                            Show me as online
                            <input type="checkbox" class="pull-right" checked>
                        </label>
                    </div>
                    <!-- /.form-group -->

                    <div class="form-group">
                        <label class="control-sidebar-subheading">
                            Turn off notifications
                            <input type="checkbox" class="pull-right">
                        </label>
                    </div>
                    <!-- /.form-group -->

                    <div class="form-group">
                        <label class="control-sidebar-subheading">
                            Delete chat history
                            <a href="javascript:void(0)" class="text-red pull-right"><i class="fa fa-trash-o"></i></a>
                        </label>
                    </div>
                    <!-- /.form-group -->
                </form>
            </div>
            <!-- /.tab-pane -->
        </div>
    </aside>
    <!-- /.control-sidebar -->
    <!-- Add the sidebar's background. This div must be placed
         immediately after the control sidebar -->
    <div class="control-sidebar-bg"></div>

</div>

<!-- ./wrapper -->

<!-- REQUIRED JS SCRIPTS -->
<script src="{{ admin_asset ("/vendor/daimakuai-admin/AdminLTE/dist/js/demo.js") }}"></script>
<script src="{{ admin_asset ("/vendor/daimakuai-admin/AdminLTE/plugins/chartjs/Chart.min.js") }}"></script>
<script src="{{ admin_asset ("/vendor/daimakuai-admin/nestable/jquery.nestable.js") }}"></script>
<script src="{{ admin_asset ("/vendor/daimakuai-admin/toastr/build/toastr.min.js") }}"></script>
<script src="{{ admin_asset ("/vendor/daimakuai-admin/bootstrap3-editable/js/bootstrap-editable.min.js") }}"></script>
<script src="{{ admin_asset ("/vendor/daimakuai-admin/sweetalert/dist/sweetalert.min.js") }}"></script>

{!! Admin::js() !!}

<script>
    function LA() {}
    LA.token = "{{ csrf_token() }}";
</script>
<script src="{{ admin_asset ("/vendor/daimakuai-admin/daimakuai-admin/daimakuai-admin.js") }}"></script>

</body>
</html>
