# React Native AI CLI

Full stack framework for building cross-platform mobile AI apps supporting LLM real-time / streaming text and chat UIs, image services and natural language to images with multiple models, and image processing.

> Check out the video tutorial [here](https://www.youtube.com/watch?v=zf3NnTU5pr4)

![React Native AI](https://i.imgur.com/AOOgBM0.png)

## Features

- LLM support for [OpenAI](https://openai.com/) ChatGPT, [Anthropic](https://anthropic.com) Claude, [Cohere](https://cohere.com/) and Cohere Web
- An array of image models provided by [Fal.ai](https://www.fal.ai/)
- Real-time / streaming responses from all providers
- OpenAI Assistants including code interpreter and retrieval
- Server proxy to easily enable authentication and authorization with auth provider of choice.
- Theming (comes out of the box with 5 themes) - easily add additional themes with just a few lines of code.
- Image processing with [ByteScale](https://bytescale.com/)

![React Native AI Preview](https://i.imgur.com/D4LIVal.png)

## Usage

Generate a new project by running:

```sh
npx rn-ai
```

Next, either configure your environment variables with the CLI, or do so later.

### Running the app

Change into the app directory and run:

```sh
npm start
```

### Running the server

Change into the server directory and run:

```sh
npm run dev
```

## Themes preview

![React Native AI Themes](https://i.imgur.com/7Gser4F.png)
