import Svg, { Path, G } from 'react-native-svg';

export function MistralIcon({
  size,
  theme,
  selected,
  ...props
}) {
    const fill = selected ? theme.tintTextColor : theme.textColor
  return (
    <Svg
      {...props}
      width={size}
      height={size}
      viewBox="0 0 200 200" 
    >
      <G>
        <Path
         fill={fill}
         d="M 45.5,33.5 C 53.5277,33.169 61.5277,33.5023 69.5,34.5C 70.1667,35.1667 70.8333,35.8333 71.5,36.5C 71.3239,43.9876 70.9906,51.321 70.5,58.5C 78.8068,59.4979 87.1401,59.8312 95.5,59.5C 95.5,67.5 95.5,75.5 95.5,83.5C 99.1667,83.5 102.833,83.5 106.5,83.5C 106.5,75.1667 106.5,66.8333 106.5,58.5C 114.174,58.6664 121.841,58.4997 129.5,58C 130.482,50.253 130.815,42.4197 130.5,34.5C 142.826,33.6947 155.16,33.528 167.5,34C 168.167,34.6667 168.833,35.3333 169.5,36C 168.905,76.1863 168.571,116.686 168.5,157.5C 155.833,157.5 143.167,157.5 130.5,157.5C 130.5,141.5 130.5,125.5 130.5,109.5C 127.223,109.216 124.057,109.549 121,110.5C 120.5,118.159 120.334,125.826 120.5,133.5C 107.829,133.667 95.1623,133.5 82.5,133C 81.5183,125.253 81.185,117.42 81.5,109.5C 77.6494,108.971 74.1494,109.638 71,111.5C 70.5001,126.83 70.3334,142.163 70.5,157.5C 57.8333,157.5 45.1667,157.5 32.5,157.5C 32.5,116.5 32.5,75.5 32.5,34.5C 37.0323,34.8182 41.3656,34.4849 45.5,33.5 Z"
        />
      </G>
    </Svg>
  )
}