# Contributing

## Basics of Contributing

- Use descriptive commit messages
- Run tests with `npm test` before submitting a PR / pushing
  - Resolve issues if tests surface them

## How You Can Contribute

There are a few things we'll always want to improve in Good First Issue... and are great ways to contribute!

### Adding New Projects

See [Adding New Projects](https://github.com/bnb/good-first-issue#adding-new-projects) in the README.md if you would like to add a new project.

### Solidifying the Module

libgfi is a module intended to help you surface issues labeled "Good First Issue" (and the many variants)! Its original purpose was to be used as a CLI as a part of `good-first-issue`, but has since been split out to seperate concerns. If you'd like to help out with solidifying the interface and ensuring that it's a good experience for end-users to consume, we'd love your help.

### Enhancing Tests

We use [Jest](https://www.npmjs.com/package/jest) for tests, and [Standard](https://www.npmjs.com/package/standard) for linting. If you would like to help Good First Issue by enhancing our test suite or improving linting, we more than welcome your contributions.

### Improving Documentation

We keep our documentation in [README.md](./README.md). If there's anything in there that doesn't currently reflect the state of the module or CLI, or anything that's unclear, improvements are *always* welcome.
