import {
  coldarkCold,
  coldarkDark,
  darcula,
  dracula,
  duotoneSea,
  funky,
  gruvboxDark,
  materialLight,
  materialOceanic,
  nightOwl,
  nord,
  okaidia,
  oneDark,
  oneLight,
  prism,
  solarizedlight,
  synthwave84,
  tomorrow,
} from 'react-syntax-highlighter/dist/esm/styles/prism';

export const themes = [
  'light',
  'dark',
  'acid',
  'aqua',
  'autumn',
  'black',
  'bumblebee',
  'business',
  'cmyk',
  'coffee',
  'corporate',
  'cupcake',
  'cyberpunk',
  'dim',
  'dracula',
  'emerald',
  'fantasy',
  'forest',
  'garden',
  'halloween',
  'lemonade',
  'lofi',
  'luxury',
  'night',
  'nord',
  'pastel',
  'retro',
  'sunset',
  'synthwave',
  'valentine',
  'winter',
  'wireframe',
];

export const getEditorTheme = (theme = 'night') => {
  const themeList = {
    night: nightOwl,
    autumn: gruvboxDark,
    light: oneLight,
    dark: oneDark,
    acid: oneLight,
    aqua: nord,
    black: oneDark,
    bumblebee: materialLight,
    business: nord,
    cmyk: okaidia,
    coffee: tomorrow,
    corporate: oneLight,
    cupcake: oneLight,
    cyberpunk: funky,
    dim: materialOceanic,
    dracula: dracula,
    emerald: oneLight,
    fantasy: materialLight,
    forest: duotoneSea,
    garden: oneLight,
    halloween: tomorrow,
    lemonade: prism,
    lofi: materialLight,
    luxury: darcula,
    nord: coldarkCold,
    pastel: oneLight,
    retro: solarizedlight,
    sunset: coldarkDark,
    synthwave: synthwave84,
    valentine: materialLight,
    winter: oneLight,
    wireframe: funky,
  };

  return themeList[theme];
};
