#!/bin/bash

echo "<!-- This file has been autogenerated. Do not edit. -->"
echo "<!-- See: ${0} -->"
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
echo "<gresources>"
echo "  <gresource prefix=\"/org/crownengine/Crown\">"
echo "    <file compressed=\"true\">theme/Adwaita/gtk-contained-dark.css</file>"
echo "    <file compressed=\"true\">theme/Adwaita/gtk-contained.css</file>"
echo "    <file compressed=\"true\">theme/Adwaita/gtk-dark.css</file>"
echo "    <file compressed=\"true\">theme/Adwaita/gtk.css</file>"
echo "    <file compressed=\"true\">ui/style.css</file>"
echo "    <file compressed=\"true\">ui/style-light.css</file>"
echo "    <file compressed=\"true\">ui/style-dark.css</file>"

find * -name '*.ui' \
	| sort          \
	| tr '\n' '\0'  \
	| xargs -0 -n1 printf "    <file compressed=\"true\" preprocess=\"xml-stripblanks\">%s</file>\n"

find theme/Adwaita/assets -name '*.png' \
	| sort                              \
	| tr '\n' '\0'                      \
	| xargs -0 -n1 printf "    <file>%s</file>\n"

find icons -name '*.svg' \
	| sort               \
	| tr '\n' '\0'       \
	| xargs -0 -n1 printf "    <file compressed=\"true\" preprocess=\"xml-stripblanks\">%s</file>\n"

echo "  </gresource>"
echo "</gresources>"
