
# coding: utf-8

# In[50]:


data = [[2017, 940, 700, 74.46],
[2016, 940, 705, 75],
[2015, 942, 700, 74.3],
[2014, 939, 698, 74.3],
[2013, 912, 694, 76],
[2012, 915, 685, 75],
[2011, 933, 675, 72],
[2010, 946, 657, 69],
[2009, 1020, 629, 62],
[2008, 1050, 599, 57],
[2007, 1010, 566, 56],
[2006, 950, 546, 57],
[2005, 877, 504, 57],
[2004, 729, 447, 61],
[2003, 613, 382, 62],
[2002, 510, 320, 63],
[2001, 454, 268, 59],
[2000, 375, 221, 59],
[1999, 288, 160, 56],
[1998, 320, 108, 34],
[1997, 278, 100, 36],
[1996, 241, 97, 40],
[1995, 253, 93, 37],
[1994, 251, 90, 36],
[1993, 286, 98, 34],
[1992, 303, 75, 25],
[1991, 296, 62, 21],
[1990, 283, 61, 22],
[1989, 266, 60, 23],
[1988, 272, 67, 25],
[1987, 228, 62, 27],
[1986, 191, 57, 30],
[1985, 176, 62, 35],
[1984, 164, 48, 29],
[1983, 167, 39, 23],
[1982, 187, 32, 17],
[1981, 259, 28, 11],
[1980, 333, 28, 8],
[1979, 468, 28, 6],
[1978, 610, 40.2, 7],
[1977, 570, 27, 5]]


# In[51]:


import numpy as np
arr = np.array(data)


# In[57]:


from pyecharts import Bar, Line, Overlap

bar = Bar("历年报考人数与录取率")
bar.add("报考人数",arr[::-1,0] , arr[::-1,1])
bar.add("录取人数",arr[::-1,0] , arr[::-1,2])
line = Line()
line.add("录取率",arr[::-1,0] , arr[::-1,3]*10, line_width=3, line_color='green')
ol = Overlap()
ol.add(bar)
ol.add(line)
ol


# In[112]:


data_born = [[124761, 123626, 122389, 121121, 119850, 118517, 117171, 115823, 114333, 112704, 111026, 109300, 107507, 105851, 104357, 103008, 101654, 100072, 98705, 97542, 96259, 94974, 93717, 92420, 90859, 89211, 87177, 85229, 82992, 80671, 78534, 76368, 74542, 72538, 70499, 69172, 67296, 65859, 66207, 67207, 65994], 
             [14.64, 15.64, 16.57, 16.98, 17.12, 17.70, 18.09, 18.24, 19.68, 21.06, 21.58, 22.37, 23.33, 22.43, 21.04, 19.90, 20.19, 22.28, 20.91, 18.21, 17.82, 18.25, 19.03, 20.01, 23.13, 24.95, 28.07, 29.92, 30.74, 33.59, 34.25, 35.75, 34.12, 35.21, 38.00, 39.34, 43.60, 37.22, 18.13, 20.86, 24.78]]
arr_born = np.array(data_born)
list_born = list((arr_born[0]*arr_born[1]/1000)[::-1])
list_born


# In[113]:


from pyecharts import Bar, Line, Overlap

bar = Bar("历年报考人数与出生人数")
bar.add("报考人数",arr[::-1,0] , arr[::-1,1])
bar.add("出生人数",arr[::-1,0] , list_born)
bar


# In[59]:


from pyecharts import Map  
  
data_prov = [('北京', 6.3), ('重庆', 25), ('上海', 5), ('天津', 5.5), ('河南', 98.38), ('广东', 75.8), ('山东', 59.2), ('安徽', 49.9), ('四川', 62), ('江苏', 33.15), ('河北', 48.64), ('湖北', 37.4), ('陕西', 31.9), ('湖南', 45.18), ('山西', 30.5), ('浙江', 30.6), ('甘肃', 27.3), ('广西', 40), ('江西', 38), ('福建', 20.09), ('辽宁', 18.5), ('贵州', 44), ('云南', 30), ('黑龙江', 19.04), ('内蒙古', 19.5), ('吉林', 15.03), ('新疆', 20.74), ('宁夏', 6.95), ('海南', 5.88), ('青海', 4), ('西藏', 2.53)]  
geo = Map("2018各省高考报名人数")
attr, value = geo.cast(data_prov)
geo.add("", attr, value, visual_range=[0, 80], is_visualmap=True, is_map_symbol_show=False)  
geo


# In[48]:


data_prov_ad = [('湖南', 11.2), ('江西', 10.4), ('安徽', 14.2), ('广东', 11.2), ('河北', 14.55), ('湖北', 15.8), ('河南', 7.8), ('山西', 9.8), ('福建', 18.7), ('吉林', 12.4), ('重庆', 11.5), ('辽宁', 16.1), ('内蒙古', 14.03), ('甘肃', 15.22), ('黑龙江', 13.5), ('陕西', 14.6), ('宁夏', 19), ('新疆', 12.86), ('西藏', 11), ('青海', 15.2), ('四川', 10.6), ('云南', 10.85), ('广西', 8.44), ('贵州', 14.50), ('北京', 30.5), ('江苏', 12.10), ('山东', 10.6), ('天津', 24.1), ('上海', 21.8), ('浙江', 14)]
geo = Map("2018各省一本录取率")
attr, value = geo.cast(data_prov_ad)
geo.add("", attr, value, visual_range=[8, 20], is_visualmap=True, is_map_symbol_show=False)  
geo


# In[ ]:




