
# coding: utf-8

# In[2]:


def get_list(data):
    list_data = data.split('	')
    list_data.reverse()
    list_data = [float(i or 0) for i in list_data]
    return list_data

data_bk = '704.1800	680.8866	659.3671	638.7210	624.7000	608.1600	575.4200	531.1000	511.9500	447.7900	377.5000	306.8000	239.1000	187.7000	133.7300	103.6300	94.9800	84.7600	82.9833	82.9070	83.8638	80.5000	63.7417	57.0715	60.4223	61.4267	61.4000	57.6242	55.3466	53.1900	39.2800	31.6000	28.6937	33.5344	45.7244	13.9640	14.7000	8.5085	16.5000	19.4000	14.9000	11.9000	4.3000	3.0000	1.7000	0.6000	10.3000	15.0000	15.0000	12.5000	14.1000	18.6000	20.4000	19.9000	17.7000	15.1000	13.6000	7.0000	7.2000	5.6000	6.3000	5.5000	4.7000	4.8000	3.2000	1.9000	1.8000	2.1000'
list_bk = get_list(data_bk)
all_bk = sum(list_bk)
print('历年本专科毕业生之和：', all_bk)

print('高等教育人口比例约：%.2f%%' % ((all_bk + 2695.8433) / 138271 * 100))

all_bk_near = sum(list_bk[-16:])
print('2000年后本专科毕业生之和：', all_bk_near, all_bk_near / all_bk)


# In[7]:


data_yjs = '56.3938	55.1522	53.5863	51.3626	48.6455	42.9994	38.3600	37.1273	34.4825	31.1839	25.5902	18.9728	15.0777	11.1091	8.0841	6.7809	5.8767	5.4670	4.7077	4.6539	3.9652	3.1877	2.8047	2.8214	2.5692	3.2537	3.5440	3.7232	4.0838	2.7603	1.6950	1.7004	0.2756	0.4497	0.4058	1.1669	0.0476	0.0140	0.0009									0.1317	0.1240	0.0852	0.1137	0.1665	0.0895	0.1512	0.1019	0.0179	0.0589	0.0727	0.1113	0.1723	0.2349	0.1730	0.0660	0.1177	0.0627	0.0166	0.0159	0.0107'
list_yjs = get_list(data_yjs)

data_lxs ='43.2500	40.9100	36.4800	35.3500	27.2900	18.6200	13.4800	10.8300	6.9300	4.4000	4.2000	3.4987	2.4726	2.0152	1.7945	1.2243	0.9121	0.7748	0.7379	0.7130	0.6570	0.5750	0.4230	0.5128	0.3611	0.2069	0.1593	0.1756	0.3000	0.1605	0.1388	0.1424	0.2290	0.2303	0.2116	0.1143	0.0162	0.0231	0.0248	0.0270	0.0189	0.0186	0.0070									0.0199	0.0191	0.0426	0.0980	0.1403	0.2217	0.1380	0.0670	0.0347	0.0258	0.0104	0.0022	0.0016				'
list_lxs = get_list(data_lxs)

list_edu = []
for i in zip(list_bk, list_yjs, list_lxs):
    list_edu.append(int(sum(i) * 10000))
print(list_edu)

data_total = '138271	137462	136782	136072	135404	134735	134091	133450	132802	132129	131448	130756	129988	129227	128453	127627	126743	125786	124761	123626	122389	121121	119850	118517	117171	115823	114333	112704	111026	109300	107507	105851	104357	103008	101654	100072	98705	97542	96259	94974	93717	92420	90859	89211	87177	85229	82992	80671	78534	76368	74542	72538	70499	69172	67296	65859	66207	67207	65994	64653	62828	61465	60266	58796	57482	56300	55196	54167'
list_total = get_list(data_total)

rate_edu = []
for i in zip(list_edu, list_total):
    rate_edu.append(i[0] / (i[1] * 10000) * 100)


# In[13]:


from pyecharts import Bar, Line, Overlap

years = [str(i) for i in range(1949, 2017)]
bar = Bar("毕业生年度变化表")
bar.add("本专科毕业生", years, list_bk, is_stack=True)
bar.add("研究生毕业生", years, list_yjs, is_stack=True)
bar.add("归国留学生", years, list_lxs, is_stack=True)
bar
line = Line()
line.add("高等教育毕业生占人口比例", years, rate_edu, line_width=3)
ol = Overlap()
ol.add(bar)
ol.add(line, is_add_yaxis=True, yaxis_index=1)
ol


# In[126]:


data_cg = '54.4500	52.3700	45.9800	41.3900	39.9600	33.9700	28.4700	22.9300	17.9800	14.4000	13.4000	11.8515	11.4682	11.7307	12.5179	8.3973	3.8989	2.3749	1.7622	2.2410	2.0905	2.0381	1.9071	1.0742	0.6540	0.2900	0.2950	0.3329	0.3786	0.4703	0.4676	0.4888	0.3073	0.2633	0.2326	0.2922	0.2124	0.1777	0.0860	0.0220	0.0277	0.0245	0.0180	0.0259	0.0036							0.0454	0.0650	0.0032	0.0114	0.0124	0.0441	0.0576	0.0415	0.0529	0.2401	0.2093	0.1518	0.0675	0.0231	0.0380	0.0035	'
list_cg = get_list(data_cg)
print(list_cg)
rate_back = []
for i in zip(list_lxs[-16:], list_cg[-16:]):
    rate_back.append(i[1] and i[0] / i[1])
print(rate_back)


# In[128]:


years_near = years[-16:]

bar = Bar("留学及归国人数年度变化表")
bar.add("出国留学人数", years_near, list_cg[-16:])
bar.add("学成归国人数", years_near, list_lxs[-16:], bar_category_gap=15)
bar
line = Line()
line.add("归国比例", years_near, rate_back, line_width=3)
ol = Overlap()
ol.add(bar)
ol.add(line, is_add_yaxis=True, yaxis_index=1)
ol


# In[24]:


data_born_rate = '12.95	12.07	12.37	12.08	12.10	11.93	11.90	11.95	12.14	12.10	12.09	12.40	12.29	12.41	12.86	13.38	14.03	14.64	15.64	16.57	16.98	17.12	17.70	18.09	18.24	19.68	21.06	21.58	22.37	23.33	22.43	21.04	19.90	20.19	22.28	20.91	18.21	17.82	18.25	19.03	20.01	23.13	24.95	28.07	29.92	30.74	33.59	34.25	35.75	34.12	35.21	38.00	39.34	43.60	37.22	18.13	20.86	24.78	29.22	34.03	31.90	32.60	37.97	37.00	37.00	37.80	37.00	36.00'
list_born_rate = get_list(data_born_rate)
list_born = []
for i in zip(list_total, list_born_rate):
    list_born.append(i[0] * i[1] / 1000)
print(list_born)

data_zs = '748.6110	737.8495	721.3987	699.8330	688.8300	681.5000	661.7600	639.4900	607.6600	565.9200	546.1000	504.4600	447.3000	382.2000	320.5000	268.2800	220.6100	159.6800	108.3627	100.0393	96.5812	92.6000	89.9846	92.3952	75.4192	61.9874	60.9000	59.7113	66.9700	61.6800	57.2000	61.9000	47.5171	39.1000	31.5000	27.9000	28.1000	27.5000	40.2000	27.3000	21.7000	19.1000	16.5000	15.0000	13.4000	4.2000	4.2000					16.4000	14.7000	13.3000	10.7000	16.9000	32.3000	27.4000	26.5000	10.6000	18.5000	9.8000	9.2000	8.1000	7.9000	5.2000	5.8000	3.1000'
list_zs = get_list(data_zs)
print(list_zs)

rate_zs = []
for i in zip(list_born[:-19], list_zs[19:]):
    rate_zs.append(i[1] / i[0])
print(rate_zs)

years_19 = years[19:]

bar = Bar("适龄大学入学比例")
bar.add("19岁人口数", years_19, list_born[:-19])
bar.add("本专科招生人数", years_19, list_zs[19:])
# bar
line = Line()
line.add("招生比例", years_19, rate_zs, line_width=3)
ol = Overlap()
ol.add(bar)
ol.add(line, is_add_yaxis=True, yaxis_index=1)
ol

