import pgzrun
import pygame
import time
import random
import colorsys

print('\n'*50)

WIDTH = 800
HEIGHT = 600
SPEED = 400

keys = ['C', 'C#', 'D', 'D#', 'E', 'F', 'F#', 'G', 'G#', 'A', 'A#', 'B']
def key2note(note):
    return (int(note[-1])+2)*12 + keys.index(note[:-1])

def get_color(n):
    return tuple(int(c*255) for c in colorsys.hsv_to_rgb((n-20)/700, 1, 1))

def rgb(n):
    r, g, b = get_color(n)
    return f'\x1b[38;2;{r};{g};{b}m'


class Particle():
    def __init__(self, pos):
        self.pos = pos
        self.color = get_color(pos[0])
        particles.append(self)
        animate(self, duration=0.5, pos=(pos[0]+random.random()*100-50, pos[1]-random.random()*20), on_finished=self.end, tween='decelerate')

    def end(self):
        particles.remove(self)

particles = []


class ComboText():
    def __init__(self):
        self.count = 0
        self.progress = 0
        self.alpha = 0
        self.ani_clear = None

    def set(self):
        self.count += 1
        self.progress = 0
        self.alpha = 0.6
        animate(self, duration=0.15, progress=1, on_finished=self.clear)
        if self.ani_clear and self.ani_clear.running:
            self.ani_clear.stop()

    def clear(self):
        self.ani_clear = animate(self, duration=1, alpha=0, tween='decelerate')

combo = ComboText()

notes = []
note_rects = []

class Note():
    def __init__(self, note, duration, t):
        self.note = note
        self.duration = duration
        self.playing = False
        self.rect = Rect((key2note(note)*9-200, -duration*SPEED), (8, duration*SPEED))
        notes.append(self)
        clock.schedule_unique(self.show, t)

    def show(self):
        note_rects.append(self.rect)
        animate(self.rect, y=500-self.rect.height, duration=500/SPEED, on_finished=self.play)

    def play(self):
        x = tone.create(self.note, self.duration)
        # 输出
        print(f'{rgb(self.rect.x)}tone.create("{self.note}", {self.duration:.2}).play()')
        x.set_volume(0.2)
        x.play()
        self.playing = True
        animate(self.rect, height=0, duration=self.duration, on_finished=self.clear)
        animate(self.rect, y=500, duration=self.duration)
        combo.set()

    def clear(self):
        note_rects.remove(self.rect)
        notes.remove(self)


def draw():
    # screen.fill('white')
    screen.clear()
    for rect in note_rects:
        screen.draw.filled_rect(rect, get_color(rect.x))
    for p in particles:
        screen.draw.circle(p.pos, 4, p.color)

    screen.draw.text(str(combo.count), center=(WIDTH/2, HEIGHT/3-20*combo.progress), color="yellow", gcolor="red", 
                     fontsize=200, owidth=0.5, ocolor='orange', antialias=False, alpha=combo.alpha)
    screen.draw.text('COMBO', center=(WIDTH/2, HEIGHT/2), color="white", gcolor="dodger blue", 
                     fontsize=40+combo.progress*60, owidth=0.5, ocolor='dodger blue', antialias=False, 
                     alpha=0.6 if combo.alpha > 0.3 else 0)

def update(dt):
    for note in notes:
        if note.playing and random.random() > 0.618:
            Particle((random.randrange(note.rect.left, note.rect.right+1), note.rect.bottom))

Note("C#3", 0.42, 0.00)
Note("A#2", 0.4, 0.46)
Note("C#3", 0.05, 0.87)
Note("B2", 0.48, 0.92)
Note("G#2", 0.42, 1.38)
Note("C#3", 0.42, 1.85)
Note("A#2", 0.4, 2.31)
Note("C#3", 0.05, 2.71)
Note("B2", 0.48, 2.77)
Note("G#2", 0.42, 3.23)
Note("C#3", 0.42, 3.69)
Note("A#2", 0.4, 4.15)
Note("C#3", 0.05, 4.56)
Note("B2", 0.48, 4.62)
Note("G#2", 0.42, 5.08)
Note("C#3", 0.42, 5.54)
Note("A#2", 0.4, 6.00)
Note("C#3", 0.05, 6.40)
Note("B2", 0.48, 6.46)
Note("G#2", 0.42, 6.92)
Note("C#3", 0.42, 7.38)
Note("E1", 0.21, 7.38)
Note("E2", 0.21, 7.62)
Note("A#2", 0.4, 7.85)
Note("E1", 0.21, 7.85)
Note("E2", 0.21, 8.08)
Note("C#3", 0.05, 8.25)
Note("E1", 0.21, 8.31)
Note("B2", 0.48, 8.31)
Note("E2", 0.21, 8.54)
Note("E1", 0.21, 8.77)
Note("G#2", 0.42, 8.77)
Note("E2", 0.21, 9.00)
Note("F#1", 0.21, 9.23)
Note("C#3", 0.42, 9.23)
Note("F#2", 0.21, 9.46)
Note("F#1", 0.21, 9.69)
Note("A#2", 0.4, 9.69)
Note("F#2", 0.21, 9.92)
Note("C#3", 0.05, 10.10)
Note("F#1", 0.21, 10.15)
Note("B2", 0.48, 10.15)
Note("F#2", 0.21, 10.38)
Note("F#1", 0.21, 10.62)
Note("G#2", 0.42, 10.62)
Note("F#2", 0.21, 10.85)
Note("G#1", 0.21, 11.08)
Note("C#3", 0.42, 11.08)
Note("G#2", 0.21, 11.31)
Note("G#1", 0.21, 11.54)
Note("A#2", 0.4, 11.54)
Note("G#2", 0.21, 11.77)
Note("C#3", 0.05, 11.94)
Note("G#1", 0.21, 12.00)
Note("B2", 0.48, 12.00)
Note("G#2", 0.19, 12.23)
Note("G#1", 0.21, 12.46)
Note("G#2", 0.19, 12.46)
Note("G#2", 0.21, 12.69)
Note("F#1", 0.21, 12.92)
Note("C#3", 0.42, 12.92)
Note("F#2", 0.21, 13.15)
Note("F#1", 0.21, 13.38)
Note("A#2", 0.4, 13.38)
Note("F#2", 0.21, 13.62)
Note("C#3", 0.05, 13.79)
Note("F#1", 0.21, 13.85)
Note("B2", 0.48, 13.85)
Note("F#2", 0.21, 14.08)
Note("F#1", 0.21, 14.31)
Note("G#2", 0.42, 14.31)
Note("F#2", 0.21, 14.54)
Note("E1", 0.21, 14.77)
Note("C#3", 0.1, 14.77)
Note("C#4", 0.1, 14.88)
Note("E2", 0.21, 15.00)
Note("C#3", 0.1, 15.00)
Note("C#4", 0.1, 15.12)
Note("E1", 0.21, 15.23)
Note("A#2", 0.1, 15.23)
Note("A#3", 0.1, 15.35)
Note("E2", 0.21, 15.46)
Note("A#2", 0.1, 15.46)
Note("A#3", 0.1, 15.58)
Note("E1", 0.21, 15.69)
Note("B2", 0.1, 15.69)
Note("B3", 0.1, 15.81)
Note("E2", 0.21, 15.92)
Note("B2", 0.1, 15.92)
Note("B3", 0.1, 16.04)
Note("E1", 0.21, 16.15)
Note("G#2", 0.1, 16.15)
Note("G#3", 0.1, 16.27)
Note("E2", 0.21, 16.38)
Note("G#2", 0.1, 16.38)
Note("G#3", 0.1, 16.50)
Note("F#1", 0.21, 16.62)
Note("C#3", 0.1, 16.62)
Note("C#4", 0.1, 16.73)
Note("F#2", 0.21, 16.85)
Note("C#3", 0.1, 16.85)
Note("C#4", 0.1, 16.96)
Note("F#1", 0.21, 17.08)
Note("A#2", 0.1, 17.08)
Note("A#3", 0.1, 17.19)
Note("F#2", 0.21, 17.31)
Note("A#2", 0.1, 17.31)
Note("A#3", 0.1, 17.42)
Note("B2", 0.1, 17.54)
Note("F#1", 0.21, 17.54)
Note("B3", 0.1, 17.65)
Note("B2", 0.1, 17.77)
Note("F#2", 0.21, 17.77)
Note("B3", 0.1, 17.88)
Note("G#2", 0.1, 18.00)
Note("F#1", 0.21, 18.00)
Note("G#3", 0.22, 18.12)
Note("F#2", 0.21, 18.23)
Note("G#3", 0.18, 18.37)
Note("B3", 0.15, 18.40)
Note("D#4", 0.13, 18.43)
Note("G#4", 0.12, 18.46)
Note("G#1", 0.21, 18.46)
Note("C#4", 0.19, 18.58)
Note("G#2", 0.21, 18.69)
Note("C#4", 0.1, 18.81)
Note("A#2", 0.1, 18.92)
Note("G#1", 0.21, 18.92)
Note("A#3", 0.1, 19.04)
Note("A#2", 0.1, 19.15)
Note("G#2", 0.21, 19.15)
Note("A#3", 0.1, 19.27)
Note("B2", 0.1, 19.38)
Note("G#1", 0.21, 19.38)
Note("B3", 0.1, 19.50)
Note("B2", 0.1, 19.62)
Note("G#2", 0.19, 19.62)
Note("B3", 0.1, 19.73)
Note("G#2", 0.1, 19.85)
Note("G#1", 0.21, 19.85)
Note("G#3", 0.19, 19.96)
Note("G#2", 0.21, 20.08)
Note("G#3", 0.1, 20.19)
Note("C#3", 0.1, 20.31)
Note("F#1", 0.21, 20.31)
Note("C#4", 0.1, 20.42)
Note("C#3", 0.1, 20.54)
Note("F#2", 0.21, 20.54)
Note("C#4", 0.1, 20.65)
Note("A#2", 0.1, 20.77)
Note("F#1", 0.21, 20.77)
Note("A#3", 0.1, 20.88)
Note("A#2", 0.1, 21.00)
Note("F#2", 0.21, 21.00)
Note("A#3", 0.1, 21.12)
Note("B2", 0.1, 21.23)
Note("F#1", 0.21, 21.23)
Note("B3", 0.1, 21.35)
Note("B2", 0.1, 21.46)
Note("F#2", 0.21, 21.46)
Note("B3", 0.1, 21.58)
Note("G#2", 0.1, 21.69)
Note("F#1", 0.21, 21.69)
Note("G#3", 0.1, 21.81)
Note("G#2", 0.1, 21.92)
Note("F#2", 0.21, 21.92)
Note("G#3", 0.1, 22.04)
Note("D#4", 2.5, 22.15)
Note("G#2", 0.42, 22.15)
Note("D#3", 0.42, 22.62)
Note("D#3", 0.42, 23.08)
Note("D#3", 0.42, 23.54)
Note("D#3", 0.42, 24.00)
Note("D#3", 0.42, 24.46)
Note("D#3", 0.42, 24.92)
Note("B3", 0.21, 25.15)
Note("C#4", 0.21, 25.38)
Note("A#2", 0.42, 25.38)
Note("B3", 0.21, 25.62)
Note("D#4", 2.3, 25.85)
Note("B2", 0.42, 25.85)
Note("D#3", 0.42, 26.31)
Note("D#3", 0.42, 26.77)
Note("D#3", 0.42, 27.23)
Note("D#3", 0.42, 27.69)
Note("D#3", 0.42, 28.15)
Note("B3", 0.21, 28.38)
Note("C#4", 0.21, 28.62)
Note("D#3", 0.42, 28.62)
Note("B3", 0.21, 28.85)
Note("C#4", 0.21, 29.08)
Note("D#3", 0.42, 29.08)
Note("D#4", 0.21, 29.31)
Note("G#3", 0.62, 29.54)
Note("E2", 0.42, 29.54)
Note("D#3", 0.42, 30.00)
Note("B3", 0.21, 30.23)
Note("G#3", 0.62, 30.46)
Note("D#3", 0.42, 30.46)
Note("D#3", 0.42, 30.92)
Note("B3", 0.21, 31.15)
Note("G#3", 0.62, 31.38)
Note("D#3", 0.42, 31.38)
Note("D#3", 0.42, 31.85)
Note("B3", 0.13, 32.08)
Note("B3", 0.05, 32.25)
Note("C#4", 0.48, 32.31)
Note("D#3", 0.42, 32.31)
Note("B3", 0.42, 32.77)
Note("D#3", 0.42, 32.77)
Note("A#3", 2.5, 33.23)
Note("F#2", 0.42, 33.23)
Note("D#3", 0.42, 33.69)
Note("D#3", 0.42, 34.15)
Note("D#3", 0.42, 34.62)
Note("D#3", 0.42, 35.08)
Note("D#3", 0.42, 35.54)
Note("D#3", 0.42, 36.00)
Note("C#4", 0.21, 36.23)
Note("B3", 0.21, 36.46)
Note("D#3", 0.42, 36.46)
Note("A#3", 0.21, 36.69)
Note("B3", 2.5, 36.92)
Note("D#4", 2.5, 36.92)
Note("G#2", 0.42, 36.92)
Note("D#3", 0.42, 37.38)
Note("D#3", 0.42, 37.85)
Note("D#3", 0.42, 38.31)
Note("D#3", 0.42, 38.77)
Note("D#3", 0.42, 39.23)
Note("D#3", 0.42, 39.69)
Note("B3", 0.21, 39.92)
Note("C#4", 0.21, 40.15)
Note("A#2", 0.42, 40.15)
Note("B3", 0.21, 40.38)
Note("D#4", 2.3, 40.62)
Note("B2", 0.42, 40.62)
Note("D#3", 0.42, 41.08)
Note("D#3", 0.42, 41.54)
Note("D#3", 0.42, 42.00)
Note("D#3", 0.42, 42.46)
Note("D#3", 0.42, 42.92)
Note("B3", 0.21, 43.15)
Note("C#4", 0.21, 43.38)
Note("D#3", 0.42, 43.38)
Note("B3", 0.21, 43.62)
Note("C#4", 0.21, 43.85)
Note("D#3", 0.42, 43.85)
Note("D#4", 0.21, 44.08)
Note("G#3", 0.62, 44.31)
Note("E2", 0.42, 44.31)
Note("D#3", 0.42, 44.77)
Note("B3", 0.21, 45.00)
Note("G#3", 0.62, 45.23)
Note("D#3", 0.42, 45.23)
Note("D#3", 0.42, 45.69)
Note("B3", 0.21, 45.92)
Note("G#3", 0.62, 46.15)
Note("D#3", 0.42, 46.15)
Note("D#3", 0.42, 46.62)
Note("B3", 0.17, 46.85)
Note("C#4", 0.05, 47.02)
Note("D#4", 0.4, 47.08)
Note("D#3", 0.42, 47.08)
Note("B3", 0.05, 47.48)
Note("C#4", 0.48, 47.54)
Note("D#3", 0.42, 47.54)
Note("A#3", 1.7, 48.00)
Note("F#2", 0.42, 48.00)
Note("D#3", 0.42, 48.46)
Note("D#3", 0.42, 48.92)
Note("D#3", 0.42, 49.38)
Note("C#4", 0.69, 49.77)
Note("F#4", 0.66, 49.81)
Note("C#5", 0.69, 49.85)
Note("D#3", 0.42, 49.85)
Note("D#3", 0.42, 50.31)
Note("A#3", 0.21, 50.54)
Note("D#4", 0.21, 50.77)
Note("D#3", 0.42, 50.77)
Note("C#4", 0.21, 51.00)
Note("B3", 0.23, 51.23)
Note("D#3", 0.42, 51.23)
Note("C#4", 0.21, 51.46)
Note("E2", 0.52, 51.58)
Note("G#2", 0.48, 51.62)
Note("B2", 0.45, 51.65)
Note("G#3", 0.21, 51.69)
Note("D#3", 0.42, 51.69)
Note("B3", 0.21, 51.92)
Note("D#4", 0.62, 52.15)
Note("G#4", 0.62, 52.15)
Note("D#3", 0.21, 52.15)
Note("B2", 0.21, 52.38)
Note("D#3", 0.21, 52.62)
Note("D#4", 0.19, 52.85)
Note("G#4", 0.19, 52.85)
Note("B2", 0.21, 52.85)
Note("D#4", 0.21, 53.08)
Note("G#4", 0.21, 53.08)
Note("D#3", 0.21, 53.08)
Note("F#4", 0.21, 53.31)
Note("B2", 0.21, 53.31)
Note("D#4", 0.42, 53.54)
Note("G#4", 0.42, 53.54)
Note("D#3", 0.21, 53.54)
Note("B2", 0.21, 53.77)
Note("D#4", 0.21, 54.00)
Note("G#4", 0.21, 54.00)
Note("D#3", 0.21, 54.00)
Note("F#4", 0.21, 54.23)
Note("B2", 0.21, 54.23)
Note("D#4", 0.21, 54.46)
Note("G#4", 0.21, 54.46)
Note("D#3", 0.21, 54.46)
Note("F#4", 0.21, 54.69)
Note("B2", 0.21, 54.69)
Note("D#4", 0.21, 54.92)
Note("G#4", 0.21, 54.92)
Note("D#3", 0.21, 54.92)
Note("F#4", 0.21, 55.15)
Note("B2", 0.15, 55.15)
Note("G#2", 0.48, 55.31)
Note("B2", 0.45, 55.35)
Note("G#3", 0.21, 55.38)
Note("D#3", 0.42, 55.38)
Note("D#4", 0.21, 55.62)
Note("B3", 0.42, 55.85)
Note("D#3", 0.21, 55.85)
Note("B2", 0.21, 56.08)
Note("B3", 0.42, 56.31)
Note("D#3", 0.21, 56.31)
Note("B2", 0.21, 56.54)
Note("B3", 0.42, 56.77)
Note("D#3", 0.21, 56.77)
Note("B2", 0.21, 57.00)
Note("B3", 0.42, 57.23)
Note("D#3", 0.21, 57.23)
Note("B2", 0.21, 57.46)
Note("B3", 0.42, 57.69)
Note("D#3", 0.21, 57.69)
Note("B2", 0.19, 57.92)
Note("B3", 0.21, 58.15)
Note("B2", 0.21, 58.15)
Note("G#3", 0.19, 58.38)
Note("C#3", 0.21, 58.38)
Note("G#3", 0.23, 58.62)
Note("B2", 0.21, 58.62)
Note("B3", 0.15, 58.85)
Note("A#2", 0.21, 58.85)
Note("E2", 0.52, 58.96)
Note("G#2", 0.48, 59.00)
Note("B3", 0.66, 59.04)
Note("B2", 0.45, 59.04)
Note("G#4", 0.65, 59.08)
Note("D#3", 0.42, 59.08)
Note("D#3", 0.21, 59.54)
Note("B3", 0.19, 59.77)
Note("G#4", 0.19, 59.77)
Note("B2", 0.21, 59.77)
Note("B3", 0.21, 60.00)
Note("G#4", 0.21, 60.00)
Note("D#3", 0.21, 60.00)
Note("A#3", 0.21, 60.23)
Note("F#4", 0.21, 60.23)
Note("B2", 0.21, 60.23)
Note("B3", 0.21, 60.46)
Note("G#4", 0.21, 60.46)
Note("D#3", 0.21, 60.46)
Note("F#4", 0.12, 60.69)
Note("B2", 0.21, 60.69)
Note("A#3", 0.73, 60.81)
Note("F#2", 0.52, 60.81)
Note("C#4", 0.69, 60.85)
Note("A#2", 0.48, 60.85)
Note("F#4", 0.66, 60.88)
Note("C#3", 0.45, 60.88)
Note("A#4", 0.65, 60.92)
Note("D#3", 0.42, 60.92)
Note("D#3", 0.21, 61.38)
Note("C#4", 0.19, 61.62)
Note("A#4", 0.19, 61.62)
Note("A#2", 0.21, 61.62)
Note("C#4", 0.21, 61.85)
Note("A#4", 0.21, 61.85)
Note("D#3", 0.21, 61.85)
Note("B3", 0.21, 62.08)
Note("G#4", 0.21, 62.08)
Note("A#2", 0.21, 62.08)
Note("C#4", 0.42, 62.31)
Note("A#4", 0.42, 62.31)
Note("D#3", 0.21, 62.31)
Note("C#3", 0.21, 62.54)
Note("G#2", 0.28, 62.69)
Note("B2", 0.23, 62.73)
Note("G#3", 0.17, 62.77)
Note("D#3", 0.23, 62.77)
Note("F#4", 0.05, 62.94)
Note("G#4", 0.48, 63.00)
Note("B2", 0.21, 63.00)
Note("D#3", 0.21, 63.23)
Note("D#4", 0.62, 63.46)
Note("B2", 0.21, 63.46)
Note("D#3", 0.21, 63.69)
Note("B2", 0.21, 63.92)
Note("B3", 0.21, 64.15)
Note("D#3", 0.21, 64.15)
Note("G#3", 0.21, 64.38)
Note("B2", 0.21, 64.38)
Note("B3", 0.21, 64.62)
Note("D#3", 0.21, 64.62)
Note("G#3", 0.21, 64.85)
Note("B2", 0.21, 64.85)
Note("B3", 0.21, 65.08)
Note("D#3", 0.21, 65.08)
Note("G#3", 0.21, 65.31)
Note("B2", 0.19, 65.31)
Note("B3", 0.21, 65.54)
Note("B2", 0.21, 65.54)
Note("D#4", 0.21, 65.77)
Note("C#3", 0.21, 65.77)
Note("F#4", 0.21, 66.00)
Note("B2", 0.21, 66.00)
Note("D#4", 0.19, 66.23)
Note("C#3", 0.21, 66.23)
Note("E2", 0.31, 66.35)
Note("G#2", 0.28, 66.38)
Note("G#3", 0.66, 66.42)
Note("B2", 0.23, 66.42)
Note("C#4", 0.69, 66.46)
Note("D#3", 0.23, 66.46)
Note("B2", 0.21, 66.69)
Note("D#3", 0.21, 66.92)
Note("D#4", 0.21, 67.15)
Note("B2", 0.21, 67.15)
Note("G#3", 0.62, 67.38)
Note("C#4", 0.62, 67.38)
Note("D#3", 0.21, 67.38)
Note("B2", 0.21, 67.62)
Note("D#3", 0.21, 67.85)
Note("D#4", 0.15, 68.08)
Note("B2", 0.21, 68.08)
Note("F#2", 0.31, 68.19)
Note("F#3", 0.69, 68.23)
Note("A#2", 0.27, 68.23)
Note("A#3", 0.66, 68.27)
Note("C#3", 0.24, 68.27)
Note("C#4", 0.69, 68.31)
Note("D#3", 0.23, 68.31)
Note("A#2", 0.21, 68.54)
Note("D#3", 0.21, 68.77)
Note("D#4", 0.21, 69.00)
Note("A#2", 0.21, 69.00)
Note("F#3", 0.21, 69.23)
Note("A#3", 0.21, 69.23)
Note("F#4", 0.21, 69.23)
Note("D#3", 0.21, 69.23)
Note("D#4", 0.21, 69.46)
Note("A#2", 0.21, 69.46)
Note("F#3", 0.21, 69.69)
Note("A#3", 0.21, 69.69)
Note("F#4", 0.21, 69.69)
Note("D#3", 0.21, 69.69)
Note("D#4", 0.15, 69.92)
Note("C#3", 0.21, 69.92)
Note("G#3", 0.69, 70.08)
Note("G#2", 0.27, 70.08)
Note("B3", 0.66, 70.12)
Note("B2", 0.24, 70.12)
Note("C#4", 0.69, 70.15)
Note("D#3", 0.23, 70.15)
Note("G#2", 0.21, 70.38)
Note("B2", 0.21, 70.62)
Note("D#3", 0.21, 70.62)
Note("D#4", 0.21, 70.85)
Note("G#2", 0.21, 70.85)
Note("G#3", 0.62, 71.08)
Note("C#4", 0.62, 71.08)
Note("B2", 0.21, 71.08)
Note("D#3", 0.21, 71.08)
Note("G#2", 0.21, 71.31)
Note("B2", 0.21, 71.54)
Note("D#3", 0.21, 71.54)
Note("D#4", 0.15, 71.77)
Note("G#2", 0.21, 71.77)
Note("F#2", 0.31, 71.88)
Note("F#3", 0.69, 71.92)
Note("A#2", 0.28, 71.92)
Note("A#3", 0.66, 71.96)
Note("C#3", 0.24, 71.96)
Note("C#4", 0.65, 72.00)
Note("D#3", 0.23, 72.00)
Note("F#2", 0.21, 72.23)
Note("A#2", 0.21, 72.46)
Note("D#3", 0.21, 72.46)
Note("C#4", 0.21, 72.69)
Note("F#2", 0.21, 72.69)
Note("B3", 0.21, 72.92)
Note("D#4", 0.21, 72.92)
Note("A#2", 0.21, 72.92)
Note("D#3", 0.21, 72.92)
Note("A#3", 0.21, 73.15)
Note("C#4", 0.21, 73.15)
Note("F#2", 0.21, 73.15)
Note("G#3", 0.21, 73.38)
Note("B3", 0.21, 73.38)
Note("A#2", 0.21, 73.38)
Note("D#3", 0.21, 73.38)
Note("A#3", 0.19, 73.62)
Note("C#4", 0.19, 73.62)
Note("F#2", 0.21, 73.62)
Note("E2", 0.31, 73.73)
Note("G#2", 0.27, 73.77)
Note("B3", 0.45, 73.81)
Note("B2", 0.24, 73.81)
Note("D#4", 0.46, 73.85)
Note("D#3", 0.23, 73.85)
Note("G#2", 0.21, 74.08)
Note("G#3", 0.42, 74.31)
Note("B2", 0.21, 74.31)
Note("D#3", 0.21, 74.31)
Note("G#2", 0.21, 74.54)
Note("G#3", 0.42, 74.77)
Note("B3", 0.42, 74.77)
Note("B2", 0.21, 74.77)
Note("D#3", 0.21, 74.77)
Note("G#2", 0.21, 75.00)
Note("B3", 0.38, 75.23)
Note("D#4", 0.38, 75.23)
Note("B2", 0.21, 75.23)
Note("D#3", 0.21, 75.23)
Note("G#2", 0.21, 75.46)
Note("F#2", 0.31, 75.58)
Note("F#3", 0.69, 75.62)
Note("A#2", 0.28, 75.62)
Note("A#3", 0.66, 75.65)
Note("C#3", 0.24, 75.65)
Note("C#4", 0.69, 75.69)
Note("D#3", 0.23, 75.69)
Note("F#2", 0.21, 75.92)
Note("A#2", 0.21, 76.15)
Note("D#3", 0.21, 76.15)
Note("D#4", 0.21, 76.38)
Note("F#2", 0.21, 76.38)
Note("C#4", 0.42, 76.62)
Note("A#2", 0.21, 76.62)
Note("D#3", 0.21, 76.62)
Note("F#2", 0.21, 76.85)
Note("B3", 0.38, 77.08)
Note("A#2", 0.21, 77.08)
Note("D#3", 0.21, 77.08)
Note("F#2", 0.21, 77.31)
Note("B2", 0.48, 77.46)
Note("G#1", 0.48, 77.46)
Note("D#3", 0.45, 77.50)
Note("D#2", 0.45, 77.50)
Note("G#3", 0.46, 77.54)
Note("G#2", 0.42, 77.54)
Note("G#2", 2.9, 78.00)
Note("C#3", 0.21, 78.23)
Note("D#3", 0.21, 78.46)
Note("G#3", 0.21, 78.69)
Note("C#4", 0.21, 78.92)
Note("D#4", 0.15, 79.15)
Note("B3", 1.3, 79.31)
Note("D#4", 1.3, 79.35)
Note("G#4", 1.4, 79.38)
Note("G#3", 0.21, 80.77)
Note("A#3", 0.21, 81.00)
Note("D#3", 0.21, 81.23)
Note("B3", 0.21, 81.23)
Note("E1", 0.21, 81.23)
Note("C#4", 0.21, 81.46)
Note("D#2", 0.19, 81.46)
Note("D#3", 0.21, 81.69)
Note("A#3", 0.21, 81.69)
Note("D#2", 0.21, 81.69)
Note("B3", 0.19, 81.92)
Note("B2", 0.19, 81.92)
Note("D#3", 0.42, 82.15)
Note("B3", 0.42, 82.15)
Note("G#2", 0.21, 82.15)
Note("B2", 0.21, 82.15)
Note("D#2", 0.21, 82.38)
Note("D#3", 0.21, 82.62)
Note("B3", 0.21, 82.62)
Note("B2", 0.21, 82.62)
Note("A#3", 0.21, 82.85)
Note("A#2", 0.21, 82.85)
Note("F#3", 0.21, 83.08)
Note("B3", 0.21, 83.08)
Note("F#1", 0.21, 83.08)
Note("C#4", 0.21, 83.31)
Note("F#2", 0.19, 83.31)
Note("F#3", 0.21, 83.54)
Note("A#3", 0.21, 83.54)
Note("F#2", 0.21, 83.54)
Note("B3", 0.19, 83.77)
Note("C#3", 0.19, 83.77)
Note("F#3", 0.42, 84.00)
Note("B3", 0.42, 84.00)
Note("F#2", 0.19, 84.00)
Note("A#2", 0.21, 84.00)
Note("C#3", 0.21, 84.00)
Note("F#2", 0.21, 84.23)
Note("F#3", 0.21, 84.46)
Note("B3", 0.21, 84.46)
Note("B2", 0.21, 84.46)
Note("C#4", 0.21, 84.69)
Note("A#2", 0.21, 84.69)
Note("G#3", 0.21, 84.92)
Note("D#4", 0.21, 84.92)
Note("G#1", 0.21, 84.92)
Note("C#4", 0.21, 85.15)
Note("G#2", 0.19, 85.15)
Note("G#3", 0.21, 85.38)
Note("D#4", 0.21, 85.38)
Note("G#2", 0.21, 85.38)
Note("C#4", 0.21, 85.62)
Note("B2", 0.19, 85.62)
Note("G#3", 0.42, 85.85)
Note("D#4", 0.42, 85.85)
Note("B2", 0.21, 85.85)
Note("D#3", 0.21, 85.85)
Note("A#2", 0.21, 86.08)
Note("G#3", 0.21, 86.31)
Note("D#4", 0.21, 86.31)
Note("B2", 0.21, 86.31)
Note("D#3", 0.21, 86.31)
Note("C#4", 0.19, 86.54)
Note("G#2", 0.21, 86.54)
Note("F#3", 0.45, 86.73)
Note("D#4", 0.37, 86.77)
Note("F#1", 0.21, 86.77)
Note("F#2", 0.19, 87.00)
Note("D#4", 0.05, 87.17)
Note("F#3", 0.42, 87.23)
Note("F#4", 0.48, 87.23)
Note("F#2", 0.21, 87.23)
Note("D#3", 0.19, 87.46)
Note("F#3", 0.42, 87.69)
Note("D#4", 0.42, 87.69)
Note("F#2", 0.21, 87.69)
Note("A#2", 0.21, 87.69)
Note("D#3", 0.21, 87.69)
Note("C#2", 0.21, 87.92)
Note("G#3", 0.21, 88.15)
Note("G#2", 0.21, 88.15)
Note("A#3", 0.21, 88.38)
Note("A#2", 0.21, 88.38)
Note("D#3", 0.21, 88.62)
Note("B3", 0.21, 88.62)
Note("E1", 0.21, 88.62)
Note("C#4", 0.21, 88.85)
Note("D#2", 0.19, 88.85)
Note("D#3", 0.21, 89.08)
Note("A#3", 0.21, 89.08)
Note("D#2", 0.21, 89.08)
Note("B3", 0.19, 89.31)
Note("B2", 0.19, 89.31)
Note("D#3", 0.42, 89.54)
Note("B3", 0.42, 89.54)
Note("G#2", 0.21, 89.54)
Note("B2", 0.21, 89.54)
Note("D#2", 0.21, 89.77)
Note("D#3", 0.21, 90.00)
Note("B3", 0.21, 90.00)
Note("B2", 0.21, 90.00)
Note("A#3", 0.21, 90.23)
Note("A#2", 0.21, 90.23)
Note("F#3", 0.21, 90.46)
Note("B3", 0.21, 90.46)
Note("F#1", 0.21, 90.46)
Note("C#4", 0.21, 90.69)
Note("F#2", 0.19, 90.69)
Note("F#3", 0.21, 90.92)
Note("A#3", 0.21, 90.92)
Note("F#2", 0.21, 90.92)
Note("B3", 0.19, 91.15)
Note("C#3", 0.19, 91.15)
Note("F#3", 0.42, 91.38)
Note("B3", 0.42, 91.38)
Note("F#2", 0.19, 91.38)
Note("A#2", 0.21, 91.38)
Note("C#3", 0.21, 91.38)
Note("F#2", 0.21, 91.62)
Note("F#3", 0.21, 91.85)
Note("B3", 0.21, 91.85)
Note("B2", 0.21, 91.85)
Note("C#4", 0.21, 92.08)
Note("A#2", 0.21, 92.08)
Note("G#3", 0.21, 92.31)
Note("D#4", 0.21, 92.31)
Note("G#1", 0.21, 92.31)
Note("C#4", 0.21, 92.54)
Note("G#2", 0.19, 92.54)
Note("G#3", 0.21, 92.77)
Note("D#4", 0.21, 92.77)
Note("G#2", 0.21, 92.77)
Note("C#4", 0.21, 93.00)
Note("D#3", 0.19, 93.00)
Note("G#3", 0.42, 93.23)
Note("D#4", 0.42, 93.23)
Note("G#2", 0.19, 93.23)
Note("B2", 0.21, 93.23)
Note("D#3", 0.21, 93.23)
Note("G#2", 0.21, 93.46)
Note("G#3", 0.21, 93.69)
Note("D#4", 0.21, 93.69)
Note("B2", 0.21, 93.69)
Note("D#3", 0.21, 93.69)
Note("C#4", 0.19, 93.92)
Note("A#2", 0.21, 93.92)
Note("F#3", 0.45, 94.12)
Note("D#4", 0.37, 94.15)
Note("F#1", 0.21, 94.15)
Note("F#2", 0.19, 94.38)
Note("D#4", 0.05, 94.56)
Note("F#3", 0.48, 94.62)
Note("F#4", 0.48, 94.62)
Note("F#2", 0.21, 94.62)
Note("B2", 0.21, 94.85)
Note("D#3", 0.42, 95.08)
Note("D#4", 0.42, 95.08)
Note("F#2", 0.21, 95.08)
Note("A#2", 0.21, 95.08)
Note("F#1", 0.21, 95.31)
Note("F#3", 0.42, 95.54)
Note("F#4", 0.42, 95.54)
Note("F#0", 0.21, 95.54)
Note("F#1", 0.21, 95.77)
Note("D#3", 0.42, 96.00)
Note("G#3", 0.42, 96.00)
Note("D#4", 0.42, 96.00)
Note("E0", 0.19, 96.00)
Note("E1", 0.19, 96.00)
Note("E0", 0.42, 96.23)
Note("E1", 0.42, 96.23)
Note("B3", 0.21, 96.46)
Note("F#3", 0.21, 96.69)
Note("F#4", 0.21, 96.69)
Note("E2", 0.21, 96.69)
Note("D#3", 0.42, 96.92)
Note("A#3", 0.42, 96.92)
Note("D#4", 0.42, 96.92)
Note("G#2", 0.21, 96.92)
Note("B2", 0.21, 96.92)
Note("E2", 0.42, 97.15)
Note("C#4", 0.21, 97.38)
Note("F#3", 0.21, 97.62)
Note("F#4", 0.21, 97.62)
Note("E0", 0.21, 97.62)
Note("E1", 0.21, 97.62)
Note("D#3", 0.21, 97.85)
Note("D#4", 0.21, 97.85)
Note("F#0", 0.19, 97.85)
Note("F#1", 0.19, 97.85)
Note("F#3", 0.21, 98.08)
Note("F#4", 0.21, 98.08)
Note("F#0", 0.21, 98.08)
Note("F#1", 0.21, 98.08)
Note("G#3", 0.21, 98.31)
Note("G#4", 0.21, 98.31)
Note("B2", 0.21, 98.31)
Note("D#3", 0.21, 98.54)
Note("D#4", 0.21, 98.54)
Note("C#2", 0.21, 98.54)
Note("A#3", 0.42, 98.77)
Note("F#3", 0.42, 98.77)
Note("F#4", 0.42, 98.77)
Note("F#2", 0.21, 98.77)
Note("A#2", 0.21, 98.77)
Note("C#2", 0.42, 99.00)
Note("F#3", 0.42, 99.23)
Note("C#4", 0.42, 99.23)
Note("F#4", 0.42, 99.23)
Note("F#0", 0.21, 99.46)
Note("F#1", 0.21, 99.46)
Note("D#3", 0.42, 99.69)
Note("G#3", 0.42, 99.69)
Note("D#4", 0.42, 99.69)
Note("G#0", 0.19, 99.69)
Note("G#1", 0.19, 99.69)
Note("G#0", 0.42, 99.92)
Note("G#1", 0.42, 99.92)
Note("B3", 0.21, 100.15)
Note("F#3", 0.21, 100.38)
Note("F#4", 0.21, 100.38)
Note("D#2", 0.21, 100.38)
Note("D#3", 0.62, 100.62)
Note("D#4", 0.62, 100.62)
Note("G#2", 0.21, 100.62)
Note("A#2", 0.21, 100.62)
Note("D#2", 0.21, 100.85)
Note("C#3", 0.21, 101.08)
Note("F#3", 0.21, 101.31)
Note("F#4", 0.21, 101.31)
Note("D#2", 0.21, 101.31)
Note("D#3", 0.21, 101.54)
Note("A#3", 0.21, 101.54)
Note("D#4", 0.21, 101.54)
Note("F#1", 0.31, 101.54)
Note("F#0", 0.31, 101.54)
Note("F#3", 0.21, 101.77)
Note("F#4", 0.21, 101.77)
Note("F#1", 0.31, 101.88)
Note("G#3", 0.21, 102.00)
Note("B3", 0.21, 102.00)
Note("G#4", 0.21, 102.00)
Note("D#3", 0.21, 102.23)
Note("D#4", 0.21, 102.23)
Note("C#2", 0.21, 102.23)
Note("A#3", 0.42, 102.46)
Note("F#3", 0.42, 102.46)
Note("F#4", 0.42, 102.46)
Note("F#2", 0.21, 102.46)
Note("A#2", 0.21, 102.46)
Note("C#2", 0.21, 102.69)
Note("F#3", 0.19, 102.92)
Note("F#4", 0.19, 102.92)
Note("C#4", 0.21, 102.92)
Note("C#3", 0.21, 102.92)
Note("F#3", 0.21, 103.15)
Note("F#4", 0.21, 103.15)
Note("C#2", 0.21, 103.15)
Note("D#3", 0.42, 103.38)
Note("G#3", 0.42, 103.38)
Note("D#4", 0.42, 103.38)
Note("C#4", 0.42, 103.38)
Note("E0", 0.19, 103.38)
Note("E1", 0.19, 103.38)
Note("E0", 0.42, 103.62)
Note("E1", 0.42, 103.62)
Note("B3", 0.42, 103.85)
Note("C#3", 0.42, 103.85)
Note("C#4", 0.42, 103.85)
Note("B1", 0.21, 104.08)
Note("A#3", 0.42, 104.31)
Note("C#4", 0.42, 104.31)
Note("C#3", 0.42, 104.31)
Note("D#2", 0.21, 104.31)
Note("G#2", 0.21, 104.31)
Note("B1", 0.42, 104.54)
Note("B3", 0.19, 104.77)
Note("C#3", 0.21, 104.77)
Note("D#3", 0.62, 105.00)
Note("B3", 0.62, 105.00)
Note("D#4", 0.62, 105.00)
Note("E0", 0.21, 105.00)
Note("E1", 0.21, 105.00)
Note("F#0", 0.19, 105.23)
Note("F#1", 0.19, 105.23)
Note("F#0", 0.42, 105.46)
Note("F#1", 0.42, 105.46)
Note("C#3", 0.42, 105.69)
Note("A#3", 0.42, 105.69)
Note("C#4", 0.42, 105.69)
Note("C#2", 0.21, 105.92)
Note("A#3", 0.42, 106.15)
Note("C#4", 0.42, 106.15)
Note("C#3", 0.42, 106.15)
Note("F#2", 0.21, 106.15)
Note("A#2", 0.21, 106.15)
Note("C#2", 0.62, 106.38)
Note("G#3", 0.19, 106.62)
Note("B3", 0.19, 106.62)
Note("C#3", 0.21, 106.62)
Note("B3", 0.42, 106.85)
Note("G#3", 0.42, 106.85)
Note("G#0", 0.19, 107.08)
Note("G#1", 0.19, 107.08)
Note("G#3", 0.21, 107.31)
Note("G#1", 0.19, 107.31)
Note("G#0", 0.21, 107.31)
Note("D#4", 0.4, 107.54)
Note("D#5", 0.4, 107.54)
Note("G#1", 0.21, 107.54)
Note("D#2", 0.21, 107.77)
Note("A#5", 0.05, 107.94)
Note("B4", 0.48, 108.00)
Note("B5", 0.48, 108.00)
Note("G#2", 0.21, 108.00)
Note("A#2", 0.21, 108.00)
Note("D#2", 0.21, 108.23)
Note("A#4", 0.42, 108.46)
Note("A#5", 0.42, 108.46)
Note("C#3", 0.21, 108.46)
Note("D#2", 0.21, 108.69)
Note("G#4", 0.73, 108.92)
Note("G#5", 0.73, 108.92)
Note("F#0", 0.19, 108.92)
Note("F#1", 0.19, 108.92)
Note("F#1", 0.19, 109.15)
Note("F#0", 0.21, 109.15)
Note("F#1", 0.1, 109.38)
Note("C#2", 0.1, 109.50)
Note("F#2", 0.19, 109.62)
Note("A#4", 0.05, 109.73)
Note("G#4", 0.05, 109.79)
Note("F#5", 0.42, 109.85)
Note("F#4", 0.42, 109.85)
Note("F#2", 0.21, 109.85)
Note("A#2", 0.21, 109.85)
Note("C#3", 0.21, 109.85)
Note("C#2", 0.62, 110.08)
Note("F#4", 0.19, 110.31)
Note("F#4", 0.21, 110.54)
Note("B3", 0.42, 110.77)
Note("D#4", 0.42, 110.77)
Note("A#3", 0.42, 111.23)
Note("C#4", 0.42, 111.23)
Note("A#3", 0.42, 111.69)
Note("C#4", 0.42, 111.69)
Note("G#3", 0.17, 112.15)
Note("B3", 0.17, 112.15)
Note("C#4", 0.05, 112.33)
Note("B3", 0.71, 112.38)
Note("D#4", 0.71, 112.38)
Note("A#3", 0.42, 113.08)
Note("C#4", 0.42, 113.08)
Note("A#3", 0.42, 113.54)
Note("C#4", 0.42, 113.54)
Note("B3", 0.19, 114.00)
Note("B3", 0.21, 114.23)
Note("C#4", 0.21, 114.46)
Note("E2", 1.7, 114.46)
Note("G#2", 1.7, 114.46)
Note("B2", 1.7, 114.46)
Note("D#3", 1.7, 114.46)
Note("G#3", 0.21, 114.69)
Note("A#3", 0.42, 114.92)
Note("B3", 0.42, 115.38)
Note("G#3", 0.42, 115.85)
Note("F#3", 0.42, 116.31)
Note("C#4", 0.42, 116.31)
Note("F#2", 1.7, 116.31)
Note("A#2", 1.7, 116.31)
Note("C#3", 1.7, 116.31)
Note("D#3", 1.7, 116.31)
Note("A#3", 0.42, 116.77)
Note("B3", 0.42, 117.23)
Note("G#3", 0.42, 117.69)
Note("G#3", 0.42, 118.15)
Note("C#4", 0.42, 118.15)
Note("G#2", 0.62, 118.15)
Note("B2", 0.62, 118.15)
Note("D#3", 0.62, 118.15)
Note("A#3", 0.42, 118.62)
Note("A#2", 0.42, 118.85)
Note("B3", 0.42, 119.08)
Note("G#2", 2.3, 119.31)
Note("G#3", 0.42, 119.54)
Note("C#4", 0.42, 120.00)
Note("A#3", 0.42, 120.46)
Note("B3", 0.42, 120.92)
Note("G#3", 0.42, 121.38)
Note("C#4", 0.62, 121.85)
Note("E2", 0.42, 121.85)
Note("G#2", 0.42, 121.85)
Note("B2", 0.42, 121.85)
Note("D#3", 0.42, 121.85)
Note("A#3", 0.42, 122.31)
Note("F#4", 1.0, 122.50)
Note("F#5", 1.2, 122.54)
Note("B3", 0.42, 122.77)
Note("G#3", 0.42, 123.23)
Note("C#4", 0.42, 123.69)
Note("F#2", 0.42, 123.69)
Note("A#2", 0.42, 123.69)
Note("C#3", 0.42, 123.69)
Note("D#3", 0.42, 123.69)
Note("A#4", 1.3, 124.12)
Note("A#5", 1.4, 124.15)
Note("A#3", 0.42, 124.15)
Note("B3", 0.42, 124.62)
Note("G#3", 0.42, 125.08)
Note("G#3", 0.19, 125.54)
Note("C#4", 0.19, 125.54)
Note("G#2", 0.42, 125.54)
Note("B2", 0.42, 125.54)
Note("D#3", 0.42, 125.54)
Note("B4", 1.5, 125.73)
Note("B5", 1.6, 125.77)
Note("A#3", 0.42, 126.00)
Note("B3", 0.42, 126.46)
Note("G#3", 1.0, 126.92)
Note("C#4", 0.42, 127.38)
Note("A#3", 0.42, 127.85)
Note("A#2", 0.42, 128.08)
Note("B3", 0.42, 128.31)
Note("G#2", 0.62, 128.54)
Note("G#3", 0.21, 128.77)
Note("F#3", 0.15, 129.00)
Note("B2", 0.69, 129.15)
Note("D#3", 0.66, 129.19)
Note("G#3", 0.69, 129.23)
Note("E1", 0.21, 129.23)
Note("E2", 0.21, 129.46)
Note("G#2", 0.21, 129.69)
Note("F#3", 0.21, 129.92)
Note("D#3", 0.19, 129.92)
Note("G#3", 0.21, 130.15)
Note("D#3", 0.21, 130.15)
Note("F#3", 0.21, 130.38)
Note("E2", 0.21, 130.38)
Note("G#3", 0.21, 130.62)
Note("G#2", 0.21, 130.62)
Note("F#3", 0.15, 130.85)
Note("D#3", 0.21, 130.85)
Note("A#2", 0.48, 131.00)
Note("C#3", 0.45, 131.04)
Note("G#3", 0.42, 131.08)
Note("F#1", 0.21, 131.08)
Note("F#2", 0.21, 131.31)
Note("G#3", 0.21, 131.54)
Note("A#2", 0.21, 131.54)
Note("F#3", 0.21, 131.77)
Note("D#3", 0.19, 131.77)
Note("G#3", 0.21, 132.00)
Note("D#3", 0.21, 132.00)
Note("F#3", 0.21, 132.23)
Note("F#2", 0.21, 132.23)
Note("G#3", 0.21, 132.46)
Note("A#2", 0.21, 132.46)
Note("F#3", 0.42, 132.69)
Note("D#3", 0.21, 132.69)
Note("G#1", 0.21, 132.92)
Note("D#3", 0.62, 133.15)
Note("D#2", 0.21, 133.15)
Note("G#2", 0.21, 133.38)
Note("B2", 0.21, 133.62)
Note("D#3", 0.21, 133.85)
Note("G#3", 0.21, 134.08)
Note("D#2", 0.21, 134.08)
Note("B3", 0.21, 134.31)
Note("G#2", 0.21, 134.31)
Note("G#3", 0.21, 134.54)
Note("B2", 0.21, 134.54)
Note("D#3", 0.21, 134.77)
Note("B3", 0.21, 134.77)
Note("G#1", 0.21, 134.77)
Note("G#3", 0.21, 135.00)
Note("D#2", 0.21, 135.00)
Note("B3", 0.21, 135.23)
Note("G#2", 0.21, 135.23)
Note("C#4", 0.21, 135.46)
Note("D#3", 0.19, 135.46)
Note("B3", 0.21, 135.69)
Note("D#4", 0.21, 135.69)
Note("A#2", 0.21, 135.69)
Note("D#3", 0.21, 135.69)
Note("C#4", 0.21, 135.92)
Note("F#2", 0.21, 135.92)
Note("B3", 0.21, 136.15)
Note("G#4", 0.21, 136.15)
Note("C#2", 0.21, 136.15)
Note("C#4", 0.21, 136.38)
Note("F#4", 0.21, 136.38)
Note("F#1", 0.21, 136.38)
Note("G#3", 0.62, 136.62)
Note("D#4", 0.62, 136.62)
Note("G#4", 0.62, 136.62)
Note("E1", 0.21, 136.62)
Note("E2", 0.21, 136.85)
Note("G#2", 0.21, 137.08)
Note("F#3", 0.21, 137.31)
Note("F#4", 0.21, 137.31)
Note("D#3", 0.19, 137.31)
Note("G#3", 0.21, 137.54)
Note("G#4", 0.21, 137.54)
Note("G#2", 0.21, 137.54)
Note("D#3", 0.21, 137.54)
Note("F#3", 0.21, 137.77)
Note("F#4", 0.21, 137.77)
Note("E2", 0.21, 137.77)
Note("G#3", 0.21, 138.00)
Note("G#4", 0.21, 138.00)
Note("G#2", 0.21, 138.00)
Note("F#3", 0.17, 138.23)
Note("F#4", 0.17, 138.23)
Note("D#3", 0.21, 138.23)
Note("G#4", 0.05, 138.40)
Note("A#3", 0.71, 138.46)
Note("A#4", 0.71, 138.46)
Note("F#1", 0.21, 138.46)
Note("F#2", 0.21, 138.69)
Note("A#2", 0.21, 138.92)
Note("G#3", 0.21, 139.15)
Note("G#4", 0.21, 139.15)
Note("D#3", 0.19, 139.15)
Note("A#3", 0.21, 139.38)
Note("A#4", 0.21, 139.38)
Note("A#2", 0.21, 139.38)
Note("D#3", 0.21, 139.38)
Note("G#3", 0.21, 139.62)
Note("G#4", 0.21, 139.62)
Note("F#2", 0.21, 139.62)
Note("A#3", 0.21, 139.85)
Note("A#4", 0.21, 139.85)
Note("A#2", 0.21, 139.85)
Note("G#3", 0.42, 140.08)
Note("G#4", 0.42, 140.08)
Note("D#3", 0.21, 140.08)
Note("G#1", 0.21, 140.31)
Note("D#4", 0.42, 140.54)
Note("D#3", 0.42, 140.54)
Note("G#2", 0.19, 140.54)
Note("G#2", 0.1, 140.77)
Note("B2", 0.1, 140.88)
Note("D#3", 0.19, 141.00)
Note("G#3", 0.1, 141.12)
Note("B3", 0.21, 141.23)
Note("D#3", 0.21, 141.23)
Note("G#3", 0.21, 141.46)
Note("B2", 0.21, 141.46)
Note("B3", 0.21, 141.69)
Note("G#2", 0.21, 141.69)
Note("G#3", 0.21, 141.92)
Note("D#3", 0.21, 141.92)
Note("B3", 0.21, 142.15)
Note("G#1", 0.21, 142.15)
Note("G#3", 0.21, 142.38)
Note("D#2", 0.1, 142.38)
Note("G#2", 0.21, 142.50)
Note("B3", 0.21, 142.62)
Note("B2", 0.1, 142.73)
Note("D#4", 0.1, 142.85)
Note("D#3", 0.21, 142.85)
Note("G#3", 0.1, 142.96)
Note("C#4", 0.21, 143.08)
Note("F#2", 0.21, 143.08)
Note("A#3", 0.21, 143.31)
Note("D#4", 0.21, 143.31)
Note("A#2", 0.19, 143.31)
Note("B3", 0.21, 143.54)
Note("F#4", 0.21, 143.54)
Note("A#2", 0.21, 143.54)
Note("A#3", 0.21, 143.77)
Note("D#4", 0.21, 143.77)
Note("C#3", 0.21, 143.77)
Note("G#3", 0.62, 144.00)
Note("C#4", 0.62, 144.00)
Note("E1", 0.21, 144.00)
Note("E2", 0.21, 144.23)
Note("G#2", 0.21, 144.46)
Note("D#4", 0.21, 144.69)
Note("D#3", 0.19, 144.69)
Note("G#3", 0.62, 144.92)
Note("C#4", 0.62, 144.92)
Note("D#3", 0.21, 144.92)
Note("E2", 0.21, 145.15)
Note("G#2", 0.21, 145.38)
Note("B3", 0.21, 145.62)
Note("D#4", 0.21, 145.62)
Note("D#3", 0.21, 145.62)
Note("A#3", 0.62, 145.85)
Note("C#4", 0.62, 145.85)
Note("F#1", 0.21, 145.85)
Note("F#2", 0.21, 146.08)
Note("C#3", 0.21, 146.31)
Note("D#4", 0.21, 146.54)
Note("D#3", 0.19, 146.54)
Note("A#3", 0.21, 146.77)
Note("F#4", 0.21, 146.77)
Note("D#3", 0.21, 146.77)
Note("D#4", 0.21, 147.00)
Note("F#2", 0.21, 147.00)
Note("A#3", 0.21, 147.23)
Note("F#4", 0.21, 147.23)
Note("C#3", 0.21, 147.23)
Note("D#4", 0.15, 147.46)
Note("D#3", 0.12, 147.46)
Note("D#3", 0.69, 147.62)
Note("B3", 0.66, 147.65)
Note("G#1", 0.24, 147.65)
Note("C#4", 0.69, 147.69)
Note("D#2", 0.23, 147.69)
Note("G#2", 0.21, 147.92)
Note("B2", 0.21, 148.15)
Note("D#4", 0.21, 148.38)
Note("D#3", 0.19, 148.38)
Note("B3", 0.62, 148.62)
Note("C#4", 0.62, 148.62)
Note("G#2", 0.19, 148.62)
Note("D#3", 0.21, 148.62)
Note("G#2", 0.21, 148.85)
Note("B2", 0.21, 149.08)
Note("D#4", 0.12, 149.31)
Note("D#3", 0.077, 149.31)
Note("D#3", 0.52, 149.42)
Note("F#3", 0.48, 149.46)
Note("A#3", 0.45, 149.50)
Note("F#1", 0.24, 149.50)
Note("C#4", 0.46, 149.54)
Note("C#2", 0.23, 149.54)
Note("F#2", 0.21, 149.77)
Note("F#3", 0.42, 150.00)
Note("A#3", 0.42, 150.00)
Note("C#3", 0.21, 150.00)
Note("D#3", 0.19, 150.23)
Note("A#3", 0.42, 150.46)
Note("F#3", 0.42, 150.46)
Note("D#3", 0.21, 150.46)
Note("F#2", 0.21, 150.69)
Note("F#3", 0.21, 150.92)
Note("B3", 0.21, 150.92)
Note("C#3", 0.21, 150.92)
Note("C#4", 0.21, 151.15)
Note("D#3", 0.21, 151.15)
Note("G#3", 0.42, 151.38)
Note("D#4", 0.42, 151.38)
Note("E1", 0.21, 151.38)
Note("E2", 0.21, 151.62)
Note("B3", 0.42, 151.85)
Note("G#4", 0.42, 151.85)
Note("G#2", 0.21, 151.85)
Note("D#3", 0.19, 152.08)
Note("D#4", 0.42, 152.31)
Note("B4", 0.42, 152.31)
Note("E2", 0.19, 152.31)
Note("G#2", 0.21, 152.31)
Note("D#3", 0.21, 152.31)
Note("E2", 0.21, 152.54)
Note("G#4", 0.42, 152.77)
Note("D#5", 0.42, 152.77)
Note("G#2", 0.21, 152.77)
Note("D#3", 0.21, 153.00)
Note("F#4", 0.62, 153.23)
Note("C#5", 0.62, 153.23)
Note("F#1", 0.21, 153.23)
Note("F#2", 0.21, 153.46)
Note("C#3", 0.21, 153.69)
Note("G#4", 0.21, 153.92)
Note("D#5", 0.21, 153.92)
Note("D#3", 0.19, 153.92)
Note("C#5", 0.42, 154.15)
Note("F#4", 0.42, 154.15)
Note("F#2", 0.19, 154.15)
Note("C#3", 0.21, 154.15)
Note("D#3", 0.21, 154.15)
Note("F#2", 0.21, 154.38)
Note("F#4", 0.42, 154.62)
Note("B4", 0.42, 154.62)
Note("C#3", 0.21, 154.62)
Note("D#3", 0.21, 154.85)
Note("C#4", 0.83, 155.08)
Note("F4", 0.83, 155.08)
Note("G#4", 0.83, 155.08)
Note("C#2", 0.19, 155.08)
Note("C#1", 0.21, 155.08)
Note("C#2", 0.1, 155.31)
Note("G#2", 0.1, 155.42)
Note("C#3", 0.21, 155.54)
Note("D#3", 0.19, 155.77)
Note("G#3", 0.83, 156.00)
Note("C#4", 0.83, 156.00)
Note("D#3", 0.21, 156.00)
Note("G#2", 0.21, 156.23)
Note("C#3", 0.21, 156.46)
Note("D#3", 0.21, 156.69)
Note("G#3", 0.62, 156.92)
Note("C#4", 0.62, 156.92)
Note("C#2", 0.19, 156.92)
Note("C#1", 0.21, 156.92)
Note("C#2", 0.1, 157.15)
Note("G#2", 0.1, 157.27)
Note("C#3", 0.21, 157.38)
Note("G#3", 0.19, 157.62)
Note("D#3", 0.19, 157.62)
Note("G#3", 0.42, 157.85)
Note("D#3", 0.21, 157.85)
Note("C#3", 0.19, 158.08)
Note("C#3", 0.21, 158.31)
Note("G#3", 0.21, 158.31)
Note("G#2", 0.21, 158.31)
Note("D#3", 0.19, 158.54)
Note("A#3", 0.21, 158.54)
Note("C#2", 0.21, 158.54)
Note("D#3", 0.21, 158.77)
Note("B3", 0.21, 158.77)
Note("E0", 0.21, 158.77)
Note("E1", 0.21, 158.77)
Note("C#4", 0.21, 159.00)
Note("B1", 0.21, 159.00)
Note("D#3", 0.21, 159.23)
Note("A#3", 0.21, 159.23)
Note("D#2", 0.21, 159.23)
Note("B3", 0.19, 159.46)
Note("G#2", 0.19, 159.46)
Note("D#3", 0.42, 159.69)
Note("B3", 0.42, 159.69)
Note("G#2", 0.21, 159.69)
Note("B2", 0.21, 159.69)
Note("D#2", 0.21, 159.92)
Note("D#3", 0.21, 160.15)
Note("B3", 0.21, 160.15)
Note("G#2", 0.21, 160.15)
Note("B2", 0.21, 160.15)
Note("A#3", 0.21, 160.38)
Note("D#2", 0.21, 160.38)
Note("D#3", 0.21, 160.62)
Note("B3", 0.21, 160.62)
Note("F#0", 0.21, 160.62)
Note("F#1", 0.21, 160.62)
Note("C#4", 0.21, 160.85)
Note("C#2", 0.21, 160.85)
Note("D#3", 0.21, 161.08)
Note("A#3", 0.21, 161.08)
Note("F#2", 0.21, 161.08)
Note("B3", 0.19, 161.31)
Note("A#2", 0.19, 161.31)
Note("D#3", 0.42, 161.54)
Note("B3", 0.42, 161.54)
Note("A#2", 0.21, 161.54)
Note("C#3", 0.21, 161.54)
Note("F#2", 0.21, 161.77)
Note("D#3", 0.21, 162.00)
Note("B3", 0.21, 162.00)
Note("A#2", 0.21, 162.00)
Note("C#3", 0.21, 162.00)
Note("C#4", 0.21, 162.23)
Note("F#2", 0.21, 162.23)
Note("B3", 0.21, 162.46)
Note("D#4", 0.21, 162.46)
Note("G#0", 0.21, 162.46)
Note("G#1", 0.21, 162.46)
Note("G#3", 0.21, 162.69)
Note("C#4", 0.21, 162.69)
Note("D#2", 0.21, 162.69)
Note("B3", 0.21, 162.92)
Note("D#4", 0.21, 162.92)
Note("G#2", 0.21, 162.92)
Note("G#3", 0.21, 163.15)
Note("C#4", 0.21, 163.15)
Note("B2", 0.19, 163.15)
Note("B3", 0.42, 163.38)
Note("D#4", 0.42, 163.38)
Note("B2", 0.21, 163.38)
Note("D#3", 0.21, 163.38)
Note("G#2", 0.21, 163.62)
Note("B3", 0.21, 163.85)
Note("D#4", 0.21, 163.85)
Note("B2", 0.21, 163.85)
Note("D#3", 0.21, 163.85)
Note("G#3", 0.21, 164.08)
Note("C#4", 0.21, 164.08)
Note("G#2", 0.21, 164.08)
Note("D#4", 0.37, 164.31)
Note("A#3", 0.4, 164.31)
Note("F#0", 0.21, 164.31)
Note("F#1", 0.21, 164.31)
Note("C#2", 0.21, 164.54)
Note("D#4", 0.05, 164.71)
Note("F#4", 0.48, 164.77)
Note("F#2", 0.21, 164.77)
Note("A#2", 0.19, 165.00)
Note("A#3", 0.42, 165.23)
Note("D#4", 0.42, 165.23)
Note("A#2", 0.21, 165.23)
Note("C#3", 0.21, 165.23)
Note("F#2", 0.21, 165.46)
Note("G#3", 0.21, 165.69)
Note("A#2", 0.21, 165.69)
Note("C#3", 0.21, 165.69)
Note("A#3", 0.21, 165.92)
Note("F#2", 0.21, 165.92)
Note("D#3", 0.21, 166.15)
Note("B3", 0.21, 166.15)
Note("E0", 0.21, 166.15)
Note("E1", 0.21, 166.15)
Note("C#4", 0.21, 166.38)
Note("B1", 0.21, 166.38)
Note("D#3", 0.21, 166.62)
Note("A#3", 0.21, 166.62)
Note("D#2", 0.21, 166.62)
Note("B3", 0.19, 166.85)
Note("G#2", 0.19, 166.85)
Note("D#3", 0.42, 167.08)
Note("B3", 0.42, 167.08)
Note("G#2", 0.21, 167.08)
Note("B2", 0.21, 167.08)
Note("D#2", 0.21, 167.31)
Note("D#3", 0.21, 167.54)
Note("B3", 0.21, 167.54)
Note("G#2", 0.21, 167.54)
Note("B2", 0.21, 167.54)
Note("A#3", 0.21, 167.77)
Note("D#2", 0.21, 167.77)
Note("D#3", 0.21, 168.00)
Note("B3", 0.21, 168.00)
Note("F#0", 0.21, 168.00)
Note("F#1", 0.21, 168.00)
Note("C#4", 0.21, 168.23)
Note("C#2", 0.21, 168.23)
Note("D#3", 0.21, 168.46)
Note("A#3", 0.21, 168.46)
Note("F#2", 0.21, 168.46)
Note("B3", 0.19, 168.69)
Note("A#2", 0.19, 168.69)
Note("D#3", 0.42, 168.92)
Note("B3", 0.42, 168.92)
Note("A#2", 0.21, 168.92)
Note("C#3", 0.21, 168.92)
Note("F#2", 0.21, 169.15)
Note("D#3", 0.21, 169.38)
Note("B3", 0.21, 169.38)
Note("A#2", 0.21, 169.38)
Note("C#3", 0.21, 169.38)
Note("C#4", 0.21, 169.62)
Note("F#2", 0.21, 169.62)
Note("G#3", 0.21, 169.85)
Note("D#4", 0.21, 169.85)
Note("G#0", 0.21, 169.85)
Note("G#1", 0.21, 169.85)
Note("C#4", 0.21, 170.08)
Note("D#2", 0.21, 170.08)
Note("G#3", 0.21, 170.31)
Note("D#4", 0.21, 170.31)
Note("G#2", 0.21, 170.31)
Note("C#4", 0.21, 170.54)
Note("B2", 0.19, 170.54)
Note("G#3", 0.42, 170.77)
Note("D#4", 0.42, 170.77)
Note("B2", 0.21, 170.77)
Note("D#3", 0.21, 170.77)
Note("G#2", 0.21, 171.00)
Note("B2", 0.21, 171.23)
Note("D#3", 0.21, 171.23)
Note("G#3", 0.21, 171.23)
Note("D#4", 0.21, 171.23)
Note("G#2", 0.21, 171.46)
Note("C#4", 0.21, 171.46)
Note("F#0", 0.21, 171.69)
Note("F#1", 0.21, 171.69)
Note("D#4", 0.37, 171.69)
Note("A#3", 0.4, 171.69)
Note("C#2", 0.21, 171.92)
Note("D#4", 0.05, 172.10)
Note("F#2", 0.21, 172.15)
Note("A#3", 0.42, 172.15)
Note("F#4", 0.48, 172.15)
Note("A#2", 0.19, 172.38)
Note("A#2", 0.21, 172.62)
Note("C#3", 0.21, 172.62)
Note("A#3", 0.42, 172.62)
Note("D#4", 0.42, 172.62)
Note("F#2", 0.21, 172.85)
Note("A#2", 0.19, 173.08)
Note("C#3", 0.19, 173.08)
Note("F#4", 0.42, 173.08)
Note("F#5", 0.42, 173.08)
Note("F#2", 0.21, 173.31)
Note("A#2", 0.21, 173.31)
Note("C#3", 0.21, 173.31)
Note("E0", 0.19, 173.54)
Note("E1", 0.21, 173.54)
Note("D#5", 0.31, 173.54)
Note("D#4", 0.35, 173.54)
Note("G#4", 0.35, 173.54)
Note("E0", 0.1, 173.77)
Note("B0", 0.1, 173.88)
Note("D#5", 0.31, 173.88)
Note("G#5", 0.28, 173.92)
Note("B5", 0.24, 173.96)
Note("E1", 0.1, 174.00)
Note("D#6", 0.23, 174.00)
Note("G#1", 0.1, 174.12)
Note("B1", 0.1, 174.23)
Note("F#4", 0.21, 174.23)
Note("F#5", 0.21, 174.23)
Note("D#2", 0.1, 174.35)
Note("G#2", 0.19, 174.46)
Note("B2", 0.21, 174.46)
Note("D#4", 0.62, 174.46)
Note("D#5", 0.62, 174.46)
Note("G#2", 0.1, 174.69)
Note("B2", 0.1, 174.81)
Note("D#3", 0.12, 174.92)
Note("B2", 0.1, 175.04)
Note("G#2", 0.1, 175.15)
Note("F#4", 0.21, 175.15)
Note("F#5", 0.21, 175.15)
Note("D#2", 0.1, 175.27)
Note("F#0", 0.19, 175.38)
Note("F#1", 0.21, 175.38)
Note("D#4", 0.21, 175.38)
Note("D#5", 0.21, 175.38)
Note("F#0", 0.1, 175.62)
Note("F#4", 0.21, 175.62)
Note("F#5", 0.21, 175.62)
Note("C#1", 0.1, 175.73)
Note("F#1", 0.1, 175.85)
Note("G#5", 0.21, 175.85)
Note("B5", 0.21, 175.85)
Note("A#1", 0.1, 175.96)
Note("C#2", 0.1, 176.08)
Note("D#4", 0.21, 176.08)
Note("D#5", 0.21, 176.08)
Note("F#2", 0.1, 176.19)
Note("A#2", 0.19, 176.31)
Note("A#4", 0.42, 176.31)
Note("A#5", 0.42, 176.31)
Note("F#5", 0.42, 176.31)
Note("A#2", 0.1, 176.54)
Note("C#3", 0.1, 176.65)
Note("F#3", 0.12, 176.77)
Note("F#4", 0.42, 176.77)
Note("C#5", 0.42, 176.77)
Note("F#5", 0.42, 176.77)
Note("C#3", 0.1, 176.88)
Note("A#2", 0.1, 177.00)
Note("F#2", 0.1, 177.12)
Note("G#0", 0.19, 177.23)
Note("G#1", 0.21, 177.23)
Note("D#5", 0.31, 177.23)
Note("D#4", 0.35, 177.23)
Note("G#4", 0.35, 177.23)
Note("G#0", 0.1, 177.46)
Note("D#1", 0.1, 177.58)
Note("D#5", 0.31, 177.58)
Note("G#5", 0.28, 177.62)
Note("B5", 0.24, 177.65)
Note("G#1", 0.1, 177.69)
Note("D#6", 0.23, 177.69)
Note("B1", 0.1, 177.81)
Note("D#2", 0.1, 177.92)
Note("F#4", 0.21, 177.92)
Note("F#5", 0.21, 177.92)
Note("G#2", 0.1, 178.04)
Note("B2", 0.19, 178.15)
Note("D#3", 0.21, 178.15)
Note("D#4", 0.62, 178.15)
Note("D#5", 0.62, 178.15)
Note("B2", 0.1, 178.38)
Note("D#3", 0.1, 178.50)
Note("G#3", 0.12, 178.62)
Note("D#3", 0.1, 178.73)
Note("B2", 0.1, 178.85)
Note("F#4", 0.21, 178.85)
Note("F#5", 0.21, 178.85)
Note("G#2", 0.1, 178.96)
Note("F#0", 0.19, 179.08)
Note("F#1", 0.21, 179.08)
Note("D#4", 0.21, 179.08)
Note("A#4", 0.21, 179.08)
Note("D#5", 0.21, 179.08)
Note("F#0", 0.1, 179.31)
Note("F#4", 0.21, 179.31)
Note("F#5", 0.21, 179.31)
Note("C#1", 0.1, 179.42)
Note("F#1", 0.1, 179.54)
Note("G#4", 0.21, 179.54)
Note("G#5", 0.21, 179.54)
Note("A#1", 0.1, 179.65)
Note("C#2", 0.1, 179.77)
Note("D#4", 0.21, 179.77)
Note("D#5", 0.21, 179.77)
Note("F#2", 0.1, 179.88)
Note("A#2", 0.19, 180.00)
Note("F#4", 0.42, 180.00)
Note("A#4", 0.42, 180.00)
Note("F#5", 0.42, 180.00)
Note("A#2", 0.1, 180.23)
Note("C#3", 0.1, 180.35)
Note("F#3", 0.12, 180.46)
Note("F#4", 0.19, 180.46)
Note("A#4", 0.19, 180.46)
Note("F#5", 0.19, 180.46)
Note("C#3", 0.1, 180.58)
Note("A#2", 0.1, 180.69)
Note("F#4", 0.21, 180.69)
Note("A#4", 0.21, 180.69)
Note("F#5", 0.21, 180.69)
Note("F#2", 0.1, 180.81)
Note("E0", 0.21, 180.92)
Note("E1", 0.21, 180.92)
Note("D#4", 0.42, 180.92)
Note("B4", 0.42, 180.92)
Note("D#5", 0.42, 180.92)
Note("D#2", 0.21, 181.15)
Note("B2", 0.21, 181.38)
Note("C#4", 0.42, 181.38)
Note("A#4", 0.42, 181.38)
Note("C#5", 0.42, 181.38)
Note("D#2", 0.21, 181.62)
Note("A#2", 0.21, 181.85)
Note("A#4", 0.42, 181.85)
Note("C#5", 0.42, 181.85)
Note("C#4", 0.42, 181.85)
Note("D#2", 0.21, 182.08)
Note("C#3", 0.21, 182.31)
Note("B4", 0.19, 182.31)
Note("C#4", 0.21, 182.31)
Note("D#2", 0.21, 182.54)
Note("D#4", 0.62, 182.54)
Note("B4", 0.62, 182.54)
Note("D#5", 0.62, 182.54)
Note("F#0", 0.21, 182.77)
Note("F#1", 0.21, 182.77)
Note("C#2", 0.21, 183.00)
Note("B2", 0.21, 183.23)
Note("C#4", 0.42, 183.23)
Note("A#4", 0.42, 183.23)
Note("C#5", 0.42, 183.23)
Note("C#2", 0.21, 183.46)
Note("A#2", 0.21, 183.69)
Note("C#4", 0.42, 183.69)
Note("A#4", 0.42, 183.69)
Note("C#5", 0.42, 183.69)
Note("C#2", 0.21, 183.92)
Note("C#3", 0.21, 184.15)
Note("B3", 0.19, 184.15)
Note("G#4", 0.19, 184.15)
Note("B4", 0.19, 184.15)
Note("C#2", 0.21, 184.38)
Note("B3", 0.42, 184.38)
Note("B4", 0.42, 184.38)
Note("G#4", 0.42, 184.38)
Note("G#0", 0.21, 184.62)
Note("G#1", 0.21, 184.62)
Note("D#2", 0.21, 184.85)
Note("G#3", 0.21, 184.85)
Note("G#4", 0.21, 184.85)
Note("B2", 0.21, 185.08)
Note("D#4", 0.4, 185.08)
Note("D#5", 0.4, 185.08)
Note("D#2", 0.21, 185.31)
Note("A#5", 0.05, 185.48)
Note("A#2", 0.21, 185.54)
Note("B4", 0.48, 185.54)
Note("B5", 0.48, 185.54)
Note("D#2", 0.21, 185.77)
Note("C#3", 0.21, 186.00)
Note("A#4", 0.42, 186.00)
Note("A#5", 0.42, 186.00)
Note("D#2", 0.21, 186.23)
Note("F#0", 0.19, 186.46)
Note("F#1", 0.21, 186.46)
Note("G#4", 0.73, 186.46)
Note("D#5", 0.73, 186.46)
Note("G#5", 0.73, 186.46)
Note("F#0", 0.1, 186.69)
Note("F#1", 0.1, 186.81)
Note("A#1", 0.1, 186.92)
Note("C#2", 0.1, 187.04)
Note("F#2", 0.1, 187.15)
Note("A#2", 0.1, 187.27)
Note("A#4", 0.05, 187.27)
Note("G#4", 0.05, 187.33)
Note("F#2", 0.21, 187.38)
Note("C#3", 0.21, 187.38)
Note("F#4", 0.42, 187.38)
Note("F#5", 0.42, 187.38)
Note("C#2", 0.21, 187.62)
Note("F#2", 0.19, 187.85)
Note("C#5", 0.19, 187.85)
Note("F#5", 0.19, 187.85)
Note("F#2", 0.21, 188.08)
Note("C#5", 0.21, 188.08)
Note("F#5", 0.21, 188.08)
Note("B4", 0.42, 188.31)
Note("D#5", 0.42, 188.31)
Note("A#4", 0.42, 188.77)
Note("C#5", 0.42, 188.77)
Note("A#4", 0.42, 189.23)
Note("C#5", 0.42, 189.23)
Note("B4", 0.19, 189.69)
Note("G#4", 0.21, 189.69)
Note("B4", 0.62, 189.92)
Note("D#5", 0.62, 189.92)
Note("A#4", 0.42, 190.62)
Note("C#5", 0.42, 190.62)
Note("A#1", 0.21, 191.08)
Note("C#2", 0.21, 191.08)
Note("F#2", 0.21, 191.08)
Note("A#4", 0.42, 191.08)
Note("C#5", 0.42, 191.08)
Note("F#1", 0.19, 191.31)
Note("F#1", 0.21, 191.54)
Note("G#4", 0.19, 191.54)
Note("B4", 0.19, 191.54)
Note("F#0", 0.21, 191.77)
Note("G#4", 0.42, 191.77)
Note("B4", 0.42, 191.77)
Note("E1", 0.19, 192.00)
Note("E0", 0.21, 192.00)
Note("E1", 0.1, 192.23)
Note("G#3", 0.19, 192.23)
Note("G#1", 0.1, 192.35)
Note("B1", 0.069, 192.46)
Note("G#3", 0.42, 192.46)
Note("G#4", 0.42, 192.46)
Note("D#2", 0.069, 192.54)
Note("E2", 0.069, 192.62)
Note("G#2", 0.1, 192.69)
Note("B2", 0.1, 192.81)
Note("E2", 0.12, 192.92)
Note("B3", 0.42, 192.92)
Note("B4", 0.42, 192.92)
Note("G#2", 0.1, 193.04)
Note("B2", 0.069, 193.15)
Note("D#3", 0.069, 193.23)
Note("E3", 0.069, 193.31)
Note("G#3", 0.069, 193.38)
Note("D#4", 0.12, 193.38)
Note("D#5", 0.4, 193.38)
Note("B3", 0.069, 193.46)
Note("D#4", 0.069, 193.54)
Note("E4", 0.069, 193.62)
Note("G#4", 0.069, 193.69)
Note("B4", 0.069, 193.77)
Note("G#5", 0.05, 193.79)
Note("D#5", 0.12, 193.85)
Note("A#5", 0.88, 193.85)
Note("B4", 0.1, 193.96)
Note("G#4", 0.069, 194.08)
Note("E4", 0.069, 194.15)
Note("B3", 0.069, 194.23)
Note("G#3", 0.069, 194.31)
Note("E3", 0.069, 194.38)
Note("D#3", 0.069, 194.46)
Note("B2", 0.069, 194.54)
Note("G#2", 0.069, 194.62)
Note("E2", 0.069, 194.69)
Note("D#3", 0.12, 194.77)
Note("A#4", 0.42, 194.77)
Note("A#5", 0.42, 194.77)
Note("B2", 0.1, 194.88)
Note("G#2", 0.069, 195.00)
Note("E2", 0.069, 195.08)
Note("D#2", 0.069, 195.15)
Note("B1", 0.1, 195.23)
Note("A#4", 0.19, 195.23)
Note("A#5", 0.19, 195.23)
Note("G#1", 0.1, 195.35)
Note("E1", 0.21, 195.46)
Note("A#4", 0.42, 195.46)
Note("A#5", 0.42, 195.46)
Note("C#0", 0.21, 195.69)
Note("C#1", 0.21, 195.69)
Note("C#2", 0.1, 195.92)
Note("G#4", 0.62, 195.92)
Note("G#5", 0.62, 195.92)
Note("F2", 0.1, 196.04)
Note("G#2", 0.1, 196.15)
Note("B2", 0.1, 196.27)
Note("C#3", 0.069, 196.38)
Note("F3", 0.069, 196.46)
Note("G#3", 0.069, 196.54)
Note("C#3", 0.12, 196.62)
Note("D#4", 0.42, 196.62)
Note("D#5", 0.42, 196.62)
Note("F3", 0.1, 196.73)
Note("G#3", 0.1, 196.85)
Note("B3", 0.1, 196.96)
Note("C#4", 0.069, 197.08)
Note("A#4", 0.21, 197.08)
Note("A#5", 0.21, 197.08)
Note("F4", 0.069, 197.15)
Note("G#4", 0.27, 197.23)
Note("B4", 0.069, 197.31)
Note("C#5", 0.069, 197.38)
Note("F5", 0.069, 197.46)
Note("G#4", 0.35, 197.54)
Note("C#4", 0.62, 197.54)
Note("G#5", 0.15, 197.54)
Note("F5", 0.069, 197.69)
Note("C#5", 0.069, 197.77)
Note("B4", 0.069, 197.85)
Note("G#4", 0.069, 197.92)
Note("F5", 0.069, 198.00)
Note("C#5", 0.069, 198.08)
Note("B4", 0.069, 198.15)
Note("G#4", 0.069, 198.23)
Note("D#5", 0.62, 198.23)
Note("F4", 0.069, 198.31)
Note("C#4", 0.069, 198.38)
Note("B3", 0.077, 198.46)
Note("G#3", 0.069, 198.54)
Note("F3", 0.069, 198.62)
Note("C#3", 0.069, 198.69)
Note("B2", 0.069, 198.77)
Note("G#2", 0.069, 198.85)
Note("F2", 0.069, 198.92)
Note("C#4", 0.42, 198.92)
Note("C#5", 0.42, 198.92)
Note("C#2", 0.069, 199.00)
Note("B1", 0.069, 199.08)
Note("G#1", 0.1, 199.15)
Note("F1", 0.1, 199.27)
Note("E1", 0.19, 199.38)
Note("E0", 0.21, 199.38)
Note("B3", 0.42, 199.38)
Note("D#4", 0.42, 199.38)
Note("G#3", 0.42, 199.38)
Note("G#4", 0.42, 199.38)
Note("E1", 0.1, 199.62)
Note("G#1", 0.1, 199.73)
Note("B1", 0.069, 199.85)
Note("G#3", 0.42, 199.85)
Note("G#4", 0.42, 199.85)
Note("D#2", 0.069, 199.92)
Note("E2", 0.069, 200.00)
Note("G#2", 0.069, 200.08)
Note("B2", 0.069, 200.15)
Note("D#3", 0.069, 200.23)
Note("E2", 0.12, 200.31)
Note("B3", 0.42, 200.31)
Note("B4", 0.42, 200.31)
Note("G#2", 0.1, 200.42)
Note("B2", 0.069, 200.54)
Note("D#3", 0.069, 200.62)
Note("E3", 0.069, 200.69)
Note("G#3", 0.069, 200.77)
Note("D#4", 0.12, 200.77)
Note("D#5", 0.4, 200.77)
Note("B3", 0.069, 200.85)
Note("D#4", 0.069, 200.92)
Note("E4", 0.069, 201.00)
Note("G#4", 0.069, 201.08)
Note("B4", 0.069, 201.15)
Note("G#5", 0.05, 201.17)
Note("D#5", 0.12, 201.23)
Note("A#5", 0.88, 201.23)
Note("B4", 0.1, 201.35)
Note("G#4", 0.069, 201.46)
Note("E4", 0.069, 201.54)
Note("B3", 0.069, 201.62)
Note("G#3", 0.069, 201.69)
Note("E3", 0.069, 201.77)
Note("D#3", 0.069, 201.85)
Note("B2", 0.069, 201.92)
Note("G#2", 0.069, 202.00)
Note("E2", 0.069, 202.08)
Note("D#3", 0.077, 202.15)
Note("A#4", 0.42, 202.15)
Note("A#5", 0.42, 202.15)
Note("B2", 0.069, 202.23)
Note("G#2", 0.069, 202.31)
Note("E2", 0.1, 202.38)
Note("D#2", 0.1, 202.50)
Note("B1", 0.1, 202.62)
Note("A#4", 0.19, 202.62)
Note("A#5", 0.19, 202.62)
Note("G#1", 0.1, 202.73)
Note("E1", 0.21, 202.85)
Note("A#4", 0.42, 202.85)
Note("A#5", 0.42, 202.85)
Note("C#0", 0.21, 203.08)
Note("C#1", 0.21, 203.08)
Note("C#2", 0.1, 203.31)
Note("G#4", 1.0, 203.31)
Note("G#5", 1.0, 203.31)
Note("F2", 0.1, 203.42)
Note("G#2", 0.1, 203.54)
Note("B2", 0.1, 203.65)
Note("C#3", 0.069, 203.77)
Note("F3", 0.069, 203.85)
Note("G#3", 0.069, 203.92)
Note("C#3", 0.12, 204.00)
Note("F3", 0.1, 204.12)
Note("G#3", 0.1, 204.23)
Note("B3", 0.1, 204.35)
Note("C#4", 0.069, 204.46)
Note("A#4", 0.42, 204.46)
Note("A#5", 0.42, 204.46)
Note("F4", 0.069, 204.54)
Note("G#4", 0.069, 204.62)
Note("B4", 0.069, 204.69)
Note("C#5", 0.069, 204.77)
Note("F5", 0.069, 204.85)
Note("D#5", 0.069, 204.92)
Note("G#5", 0.069, 204.92)
Note("D#6", 0.69, 204.92)
Note("F5", 0.069, 205.00)
Note("C#5", 0.069, 205.08)
Note("B4", 0.069, 205.15)
Note("G#4", 0.069, 205.23)
Note("F4", 0.069, 205.31)
Note("C#4", 0.077, 205.38)
Note("F4", 0.069, 205.46)
Note("G#4", 0.069, 205.54)
Note("B4", 0.19, 205.62)
Note("C#5", 0.069, 205.62)
Note("C#6", 0.069, 205.62)
Note("F5", 0.069, 205.69)
Note("G#5", 0.069, 205.77)
Note("F2", 0.21, 205.85)
Note("G#2", 0.21, 205.85)
Note("C#3", 0.21, 205.85)
Note("B4", 0.42, 205.85)
Note("B5", 0.42, 205.85)
Note("C#2", 0.21, 206.08)
Note("G#2", 0.21, 206.31)
Note("G#3", 0.21, 206.31)
Note("A#4", 0.19, 206.31)
Note("A#5", 0.19, 206.31)
Note("A#2", 0.21, 206.54)
Note("A#3", 0.21, 206.54)
Note("A#4", 0.21, 206.54)
Note("A#5", 0.21, 206.54)
Note("E0", 0.19, 206.77)
Note("E1", 0.19, 206.77)
Note("B3", 0.21, 206.77)
Note("B4", 0.21, 206.77)
Note("E0", 0.21, 207.00)
Note("E1", 0.21, 207.00)
Note("C#4", 0.21, 207.00)
Note("G#4", 0.21, 207.00)
Note("C#5", 0.21, 207.00)
Note("A#3", 0.21, 207.23)
Note("A#4", 0.21, 207.23)
Note("B3", 0.19, 207.46)
Note("B4", 0.19, 207.46)
Note("E2", 0.42, 207.69)
Note("G#2", 0.42, 207.69)
Note("B2", 0.42, 207.69)
Note("D#3", 0.42, 207.69)
Note("B3", 0.42, 207.69)
Note("B4", 0.42, 207.69)
Note("E0", 0.42, 208.15)
Note("E1", 0.42, 208.15)
Note("B3", 0.21, 208.15)
Note("B4", 0.21, 208.15)
Note("A#3", 0.21, 208.38)
Note("A#4", 0.21, 208.38)
Note("F#0", 0.19, 208.62)
Note("F#1", 0.19, 208.62)
Note("B3", 0.21, 208.62)
Note("B4", 0.21, 208.62)
Note("F#0", 0.21, 208.85)
Note("F#1", 0.21, 208.85)
Note("C#4", 0.21, 208.85)
Note("C#5", 0.21, 208.85)
Note("A#3", 0.21, 209.08)
Note("A#4", 0.21, 209.08)
Note("B3", 0.19, 209.31)
Note("B4", 0.19, 209.31)
Note("C#2", 0.42, 209.54)
Note("F#2", 0.42, 209.54)
Note("A#2", 0.42, 209.54)
Note("B3", 0.42, 209.54)
Note("B4", 0.42, 209.54)
Note("F#0", 0.42, 210.00)
Note("F#1", 0.42, 210.00)
Note("B3", 0.21, 210.00)
Note("B4", 0.21, 210.00)
Note("C#4", 0.21, 210.23)
Note("C#5", 0.21, 210.23)
Note("G#0", 0.19, 210.46)
Note("G#1", 0.19, 210.46)
Note("D#4", 0.21, 210.46)
Note("D#5", 0.21, 210.46)
Note("G#0", 0.21, 210.69)
Note("G#1", 0.21, 210.69)
Note("C#4", 0.21, 210.69)
Note("C#5", 0.21, 210.69)
Note("D#4", 0.21, 210.92)
Note("D#5", 0.21, 210.92)
Note("C#4", 0.21, 211.15)
Note("C#5", 0.21, 211.15)
Note("D#2", 0.31, 211.38)
Note("G#2", 0.31, 211.38)
Note("B2", 0.31, 211.38)
Note("D#4", 0.42, 211.38)
Note("D#5", 0.42, 211.38)
Note("G#0", 0.52, 211.73)
Note("G#1", 0.52, 211.73)
Note("D#4", 0.21, 211.85)
Note("D#5", 0.21, 211.85)
Note("C#4", 0.21, 212.08)
Note("C#5", 0.21, 212.08)
Note("F#0", 0.19, 212.31)
Note("F#1", 0.19, 212.31)
Note("D#4", 0.42, 212.31)
Note("D#5", 0.42, 212.31)
Note("F#0", 0.42, 212.54)
Note("F#1", 0.42, 212.54)
Note("F#4", 0.21, 212.77)
Note("B4", 0.21, 212.77)
Note("F#5", 0.21, 212.77)
Note("C#2", 0.21, 213.00)
Note("A#4", 0.21, 213.00)
Note("C#5", 0.21, 213.00)
Note("A#5", 0.21, 213.00)
Note("F#2", 0.21, 213.23)
Note("A#2", 0.21, 213.23)
Note("B4", 0.42, 213.23)
Note("D#5", 0.42, 213.23)
Note("B5", 0.42, 213.23)
Note("C#2", 0.21, 213.46)
Note("G#2", 0.21, 213.69)
Note("C#3", 0.21, 213.69)
Note("G#3", 0.21, 213.69)
Note("A#4", 0.19, 213.69)
Note("C#5", 0.19, 213.69)
Note("A#5", 0.19, 213.69)
Note("A#2", 0.21, 213.92)
Note("A#3", 0.21, 213.92)
Note("A#4", 0.21, 213.92)
Note("C#5", 0.21, 213.92)
Note("A#5", 0.21, 213.92)
Note("E0", 0.19, 214.15)
Note("E1", 0.19, 214.15)
Note("B3", 0.21, 214.15)
Note("B4", 0.21, 214.15)
Note("E0", 0.42, 214.38)
Note("E1", 0.42, 214.38)
Note("C#4", 0.21, 214.38)
Note("C#5", 0.21, 214.38)
Note("A#3", 0.21, 214.62)
Note("A#4", 0.21, 214.62)
Note("E2", 0.21, 214.85)
Note("B3", 0.19, 214.85)
Note("B4", 0.19, 214.85)
Note("G#2", 0.21, 215.08)
Note("B2", 0.21, 215.08)
Note("D#3", 0.21, 215.08)
Note("B3", 0.42, 215.08)
Note("B4", 0.42, 215.08)
Note("E2", 0.21, 215.31)
Note("E0", 0.19, 215.54)
Note("E1", 0.19, 215.54)
Note("B3", 0.21, 215.54)
Note("B4", 0.21, 215.54)
Note("E0", 0.21, 215.77)
Note("E1", 0.21, 215.77)
Note("A#3", 0.21, 215.77)
Note("A#4", 0.21, 215.77)
Note("F#0", 0.19, 216.00)
Note("F#1", 0.19, 216.00)
Note("B3", 0.21, 216.00)
Note("B4", 0.21, 216.00)
Note("F#0", 0.42, 216.23)
Note("F#1", 0.42, 216.23)
Note("C#4", 0.21, 216.23)
Note("C#5", 0.21, 216.23)
Note("A#3", 0.21, 216.46)
Note("A#4", 0.21, 216.46)
Note("C#2", 0.21, 216.69)
Note("B3", 0.19, 216.69)
Note("B4", 0.19, 216.69)
Note("F#2", 0.21, 216.92)
Note("A#2", 0.21, 216.92)
Note("B3", 0.42, 216.92)
Note("B4", 0.42, 216.92)
Note("C#2", 0.21, 217.15)
Note("F#0", 0.19, 217.38)
Note("F#1", 0.19, 217.38)
Note("B3", 0.21, 217.38)
Note("B4", 0.21, 217.38)
Note("F#0", 0.21, 217.62)
Note("F#1", 0.21, 217.62)
Note("C#4", 0.21, 217.62)
Note("C#5", 0.21, 217.62)
Note("G#0", 0.19, 217.85)
Note("G#1", 0.19, 217.85)
Note("D#4", 0.21, 217.85)
Note("D#5", 0.21, 217.85)
Note("G#0", 0.42, 218.08)
Note("G#1", 0.42, 218.08)
Note("C#4", 0.21, 218.08)
Note("C#5", 0.21, 218.08)
Note("D#4", 0.21, 218.31)
Note("D#5", 0.21, 218.31)
Note("D#2", 0.21, 218.54)
Note("C#4", 0.21, 218.54)
Note("C#5", 0.21, 218.54)
Note("G#2", 0.21, 218.77)
Note("B2", 0.21, 218.77)
Note("D#4", 0.42, 218.77)
Note("D#5", 0.42, 218.77)
Note("D#2", 0.21, 219.00)
Note("G#0", 0.19, 219.23)
Note("G#1", 0.19, 219.23)
Note("D#4", 0.21, 219.23)
Note("D#5", 0.21, 219.23)
Note("G#0", 0.21, 219.46)
Note("G#1", 0.21, 219.46)
Note("C#4", 0.21, 219.46)
Note("C#5", 0.21, 219.46)
Note("F#0", 0.19, 219.69)
Note("F#1", 0.19, 219.69)
Note("D#4", 0.21, 219.69)
Note("D#5", 0.21, 219.69)
Note("F#0", 0.42, 219.92)
Note("F#1", 0.42, 219.92)
Note("F#3", 0.17, 219.92)
Note("F#4", 0.17, 219.92)
Note("D#5", 0.05, 220.10)
Note("F#4", 0.19, 220.15)
Note("F#5", 0.25, 220.15)
Note("C#2", 0.21, 220.38)
Note("F#3", 0.21, 220.38)
Note("F#4", 0.21, 220.38)
Note("F#2", 0.21, 220.62)
Note("A#2", 0.21, 220.62)
Note("D#4", 0.21, 220.62)
Note("D#5", 0.21, 220.62)
Note("C#2", 0.21, 220.85)
Note("F#4", 0.19, 220.85)
Note("F#3", 0.21, 220.85)
Note("F#0", 0.19, 221.08)
Note("F#1", 0.19, 221.08)
Note("F#4", 0.19, 221.08)
Note("F#5", 0.21, 221.08)
Note("F#0", 0.21, 221.31)
Note("F#1", 0.21, 221.31)
Note("F#3", 0.21, 221.31)
Note("F#4", 0.21, 221.31)
Note("E0", 0.19, 221.54)
Note("E1", 0.21, 221.54)
Note("D#4", 0.21, 221.54)
Note("D#5", 0.21, 221.54)
Note("E0", 0.1, 221.77)
Note("F#5", 0.21, 221.77)
Note("B0", 0.1, 221.88)
Note("E1", 0.069, 222.00)
Note("D#5", 0.21, 222.00)
Note("G#1", 0.069, 222.08)
Note("B1", 0.069, 222.15)
Note("D#2", 0.069, 222.23)
Note("F#3", 0.21, 222.23)
Note("F#4", 0.21, 222.23)
Note("E2", 0.069, 222.31)
Note("G#2", 0.069, 222.38)
Note("B2", 0.069, 222.46)
Note("D#3", 0.069, 222.46)
Note("D#4", 0.21, 222.46)
Note("E2", 0.069, 222.54)
Note("G#2", 0.069, 222.62)
Note("B2", 0.069, 222.69)
Note("F#5", 0.21, 222.69)
Note("D#3", 0.069, 222.77)
Note("E3", 0.069, 222.85)
Note("G#3", 0.12, 222.92)
Note("D#4", 0.21, 222.92)
Note("D#5", 0.21, 222.92)
Note("D#3", 0.1, 223.04)
Note("B2", 0.1, 223.15)
Note("F#4", 0.21, 223.15)
Note("G#2", 0.1, 223.27)
Note("F#0", 0.19, 223.38)
Note("F#1", 0.21, 223.38)
Note("B3", 0.21, 223.38)
Note("D#4", 0.21, 223.38)
Note("F#0", 0.1, 223.62)
Note("C#4", 0.21, 223.62)
Note("F#4", 0.21, 223.62)
Note("C#1", 0.1, 223.73)
Note("F#1", 0.069, 223.85)
Note("D#4", 0.19, 223.85)
Note("G#4", 0.21, 223.85)
Note("D#5", 0.21, 223.85)
Note("A#1", 0.069, 223.92)
Note("C#2", 0.069, 224.00)
Note("F#2", 0.069, 224.08)
Note("D#4", 0.21, 224.08)
Note("A#2", 0.069, 224.15)
Note("C#3", 0.069, 224.23)
Note("F#3", 0.077, 224.31)
Note("C#4", 0.42, 224.31)
Note("F#4", 0.42, 224.31)
Note("C#5", 0.42, 224.31)
Note("F#2", 0.069, 224.38)
Note("A#2", 0.069, 224.46)
Note("C#3", 0.069, 224.54)
Note("F#3", 0.069, 224.62)
Note("A#3", 0.069, 224.69)
Note("C#4", 0.12, 224.77)
Note("F#4", 0.42, 224.77)
Note("C#5", 0.42, 224.77)
Note("F#5", 0.42, 224.77)
Note("A#3", 0.1, 224.88)
Note("F#3", 0.1, 225.00)
Note("C#3", 0.1, 225.12)
Note("G#0", 0.19, 225.23)
Note("G#1", 0.21, 225.23)
Note("D#4", 0.21, 225.23)
Note("D#5", 0.21, 225.23)
Note("G#0", 0.1, 225.46)
Note("F#5", 0.21, 225.46)
Note("F#6", 0.21, 225.46)
Note("D#1", 0.1, 225.58)
Note("G#1", 0.069, 225.69)
Note("D#5", 0.21, 225.69)
Note("D#6", 0.21, 225.69)
Note("B1", 0.069, 225.77)
Note("D#2", 0.069, 225.85)
Note("G#2", 0.069, 225.92)
Note("F#4", 0.21, 225.92)
Note("F#5", 0.21, 225.92)
Note("A#2", 0.069, 226.00)
Note("B2", 0.069, 226.08)
Note("D#3", 0.12, 226.15)
Note("D#4", 0.21, 226.15)
Note("D#5", 0.21, 226.15)
Note("G#2", 0.1, 226.27)
Note("A#2", 0.069, 226.38)
Note("F#5", 0.21, 226.38)
Note("F#6", 0.21, 226.38)
Note("B2", 0.069, 226.46)
Note("D#3", 0.069, 226.54)
Note("G#3", 0.12, 226.62)
Note("D#5", 0.21, 226.62)
Note("D#6", 0.21, 226.62)
Note("D#3", 0.1, 226.73)
Note("B2", 0.1, 226.85)
Note("F#4", 0.21, 226.85)
Note("F#5", 0.21, 226.85)
Note("G#2", 0.1, 226.96)
Note("F#0", 0.19, 227.08)
Note("F#1", 0.21, 227.08)
Note("D#4", 0.21, 227.08)
Note("A#4", 0.21, 227.08)
Note("D#5", 0.21, 227.08)
Note("F#0", 0.1, 227.31)
Note("F#4", 0.21, 227.31)
Note("F#5", 0.21, 227.31)
Note("C#1", 0.1, 227.42)
Note("F#1", 0.069, 227.54)
Note("D#5", 0.19, 227.54)
Note("G#4", 0.21, 227.54)
Note("G#5", 0.21, 227.54)
Note("A#1", 0.069, 227.62)
Note("C#2", 0.069, 227.69)
Note("F#2", 0.069, 227.77)
Note("D#4", 0.21, 227.77)
Note("D#5", 0.21, 227.77)
Note("A#2", 0.069, 227.85)
Note("C#3", 0.038, 227.92)
Note("C#3", 0.069, 228.00)
Note("F#3", 0.069, 228.00)
Note("F#4", 0.42, 228.00)
Note("C#5", 0.42, 228.00)
Note("F#5", 0.42, 228.00)
Note("F#2", 0.069, 228.08)
Note("A#2", 0.069, 228.15)
Note("C#3", 0.069, 228.23)
Note("F#3", 0.069, 228.31)
Note("A#3", 0.069, 228.38)
Note("C#4", 0.12, 228.46)
Note("F#4", 0.19, 228.46)
Note("C#5", 0.19, 228.46)
Note("F#5", 0.19, 228.46)
Note("A#3", 0.1, 228.58)
Note("F#3", 0.1, 228.69)
Note("F#4", 0.21, 228.69)
Note("C#5", 0.21, 228.69)
Note("F#5", 0.21, 228.69)
Note("C#3", 0.1, 228.81)
Note("E0", 0.21, 228.92)
Note("E1", 0.21, 228.92)
Note("D#4", 0.42, 228.92)
Note("B4", 0.42, 228.92)
Note("D#5", 0.42, 228.92)
Note("D#2", 0.21, 229.15)
Note("B2", 0.21, 229.38)
Note("C#4", 0.42, 229.38)
Note("A#4", 0.42, 229.38)
Note("C#5", 0.42, 229.38)
Note("D#2", 0.21, 229.62)
Note("A#2", 0.21, 229.85)
Note("C#4", 0.42, 229.85)
Note("A#4", 0.42, 229.85)
Note("C#5", 0.42, 229.85)
Note("D#2", 0.21, 230.08)
Note("C#3", 0.21, 230.31)
Note("B4", 0.19, 230.31)
Note("B3", 0.21, 230.31)
Note("D#2", 0.21, 230.54)
Note("D#4", 0.62, 230.54)
Note("B4", 0.62, 230.54)
Note("D#5", 0.62, 230.54)
Note("F#0", 0.21, 230.77)
Note("F#1", 0.21, 230.77)
Note("C#2", 0.21, 231.00)
Note("B2", 0.21, 231.23)
Note("C#4", 0.42, 231.23)
Note("A#4", 0.42, 231.23)
Note("C#5", 0.42, 231.23)
Note("C#2", 0.21, 231.46)
Note("A#2", 0.21, 231.69)
Note("C#4", 0.42, 231.69)
Note("A#4", 0.42, 231.69)
Note("C#5", 0.42, 231.69)
Note("C#2", 0.21, 231.92)
Note("C#3", 0.21, 232.15)
Note("B3", 0.19, 232.15)
Note("G#4", 0.19, 232.15)
Note("B4", 0.19, 232.15)
Note("C#2", 0.21, 232.38)
Note("B3", 0.42, 232.38)
Note("B4", 0.42, 232.38)
Note("G#4", 0.42, 232.38)
Note("G#0", 0.21, 232.62)
Note("G#1", 0.21, 232.62)
Note("D#2", 0.21, 232.85)
Note("G#3", 0.21, 232.85)
Note("G#4", 0.21, 232.85)
Note("B2", 0.21, 233.08)
Note("D#4", 0.4, 233.08)
Note("D#5", 0.4, 233.08)
Note("D#2", 0.21, 233.31)
Note("A#5", 0.05, 233.48)
Note("A#2", 0.21, 233.54)
Note("B4", 0.48, 233.54)
Note("B5", 0.48, 233.54)
Note("D#2", 0.21, 233.77)
Note("C#3", 0.21, 234.00)
Note("A#4", 0.42, 234.00)
Note("A#5", 0.42, 234.00)
Note("D#2", 0.21, 234.23)
Note("F#0", 0.21, 234.46)
Note("F#1", 0.21, 234.46)
Note("G#4", 0.73, 234.46)
Note("G#5", 0.73, 234.46)
Note("C#2", 0.21, 234.69)
Note("B2", 0.21, 234.92)
Note("C#2", 0.21, 235.15)
Note("A#4", 0.05, 235.27)
Note("G#4", 0.05, 235.33)
Note("F#2", 0.19, 235.38)
Note("A#2", 0.21, 235.38)
Note("F#5", 0.42, 235.38)
Note("F#4", 0.42, 235.38)
Note("F#2", 0.21, 235.62)
Note("C#3", 0.19, 235.85)
Note("F#4", 0.19, 235.85)
Note("C#3", 0.21, 236.08)
Note("F#4", 0.19, 236.08)
Note("E2", 1.7, 236.23)
Note("B2", 1.7, 236.27)
Note("B3", 0.45, 236.27)
Note("D#3", 1.8, 236.31)
Note("D#4", 0.46, 236.31)
Note("A#3", 0.42, 236.77)
Note("C#4", 0.42, 236.77)
Note("A#3", 0.42, 237.23)
Note("C#4", 0.42, 237.23)
Note("B3", 0.19, 237.69)
Note("G#3", 0.21, 237.69)
Note("B3", 0.62, 237.92)
Note("D#4", 0.62, 237.92)
Note("F#2", 1.7, 238.15)
Note("A#2", 1.7, 238.15)
Note("C#3", 1.7, 238.15)
Note("D#3", 1.7, 238.15)
Note("A#3", 0.42, 238.62)
Note("C#4", 0.42, 238.62)
Note("A#3", 0.42, 239.08)
Note("C#4", 0.42, 239.08)
Note("B3", 0.19, 239.54)
Note("B3", 0.21, 239.77)
Note("E1", 3.3, 240.00)
Note("B1", 3.3, 240.00)
Note("E2", 3.3, 240.00)
Note("C#4", 0.21, 240.00)
Note("G#3", 0.21, 240.23)
Note("A#3", 0.42, 240.46)
Note("B3", 0.42, 240.92)
Note("G#3", 0.42, 241.38)
Note("C#4", 0.42, 241.85)
Note("A#3", 0.42, 242.31)
Note("B3", 0.42, 242.77)
Note("G#3", 0.42, 243.23)
Note("C#2", 3.3, 243.69)
Note("F2", 3.3, 243.69)
Note("G#2", 3.3, 243.69)
Note("D#3", 0.42, 243.69)
Note("C#4", 0.42, 243.69)
Note("A#3", 0.42, 244.15)
Note("B3", 0.42, 244.62)
Note("G#3", 0.42, 245.08)
Note("C#4", 0.42, 245.54)
Note("A#3", 0.42, 246.00)
Note("B3", 0.42, 246.46)
Note("G#3", 0.42, 246.92)
Note("E2", 1.7, 247.38)
Note("G#2", 1.7, 247.38)
Note("B2", 1.7, 247.38)
Note("D#3", 1.7, 247.38)
Note("C#4", 0.42, 247.38)
Note("A#3", 0.42, 247.85)
Note("B3", 0.42, 248.31)
Note("G#3", 0.42, 248.77)
Note("C#3", 1.7, 249.15)
Note("D#3", 1.7, 249.19)
Note("G#3", 1.3, 249.23)
Note("C#4", 0.42, 249.23)
Note("A#3", 0.42, 249.69)
Note("B3", 0.42, 250.15)
Note("G#3", 0.42, 250.62)
Note("C#2", 0.42, 251.08)
Note("F2", 0.42, 251.08)
Note("G#2", 0.42, 251.08)
Note("D#3", 0.42, 251.08)
Note("C#4", 0.42, 251.08)
Note("A#2", 0.42, 251.54)
Note("A#3", 0.42, 251.54)
Note("B2", 0.42, 252.00)
Note("B3", 0.42, 252.00)
Note("G#2", 0.42, 252.46)
Note("G#3", 0.42, 252.46)
Note("C#3", 0.42, 252.92)
Note("C#4", 0.42, 252.92)
Note("A#2", 0.42, 253.38)
Note("A#3", 0.42, 253.38)
Note("B2", 0.42, 253.85)
Note("B3", 0.42, 253.85)
Note("G#2", 0.42, 254.31)
Note("G#3", 0.42, 254.31)

pgzrun.go()
