/*
 * node-crisp-api
 *
 * Copyright 2022, Crisp IM SAS
 * Author: Baptiste Jamin <baptiste@crisp.chat>
 */


"use strict";


/**
 * Crisp WebsiteSettings Resource
 * @class
 * @classdesc This is the Crisp Website Settings Resource
 */
function WebsiteSettings(service, crisp) {
  /**
   * Get Website Settings
   * @memberof WebsiteSettings
   * @public
   * @method getWebsiteSettings
   * @param {string} websiteID
   * @return {Promise}
   */
  service.getWebsiteSettings = function(websiteID) {
    return crisp.get(
      crisp._prepareRestUrl(["website", websiteID, "settings"])
    );
  };

  /**
   * Update Website Settings
   * @memberof WebsiteSettings
   * @public
   * @method updateWebsiteSettings
   * @param {string} websiteID
   * @param {object} settings
   * @return {Promise}
   */
  service.updateWebsiteSettings = function(websiteID, settings) {
    return crisp.patch(
      crisp._prepareRestUrl(["website", websiteID, "settings"]), null, settings
    );
  };
}


module.exports = WebsiteSettings;

