## Buttons

To use the custom button you don't need to import the custom made component, you can easily use it like this:

```html
<md-button> Button </md-button>
```

### Colors

We has changed the predefined button styles from vuematerial.io, each serving its own semantic purpose, with a few extras thrown in for more control.

<md-button>Default</md-button>
<md-button class="md-primary">Primary</md-button>
<md-button class="md-info">Info</md-button>
<md-button class="md-success">Success</md-button>
<md-button class="md-warning">Warning</md-button>
<md-button class="md-danger">Danger</md-button>
<md-button class="md-simple">Simple</md-button>

```html
<md-button>Default</md-button>
<md-button class="md-primary">Primary</md-button>
<md-button class="md-info">Info</md-button>
<md-button class="md-success">Success</md-button>
<md-button class="md-warning">Warning</md-button>
<md-button class="md-danger">Danger</md-button>
<md-button class="md-simple">Simple</md-button>
```

### Style Buttons

<md-button class="md-primary">Default</md-button>
<md-button class="md-primary md-round">Round</md-button>
<md-button class="md-primary"><md-icon >favorite</md-icon> With Icon</md-button>
<md-button class="md-primary md-just-icon"><md-icon >favorite</md-icon></md-button>
<md-button class="md-primary md-simple">Simple</md-button>

```html
<md-button class="md-primary">Default</md-button>
<md-button class="md-primary md-round">Round</md-button>
<md-button class="md-primary"><md-icon>favorite</md-icon> With Icon</md-button>
<md-button class="md-primary md-just-icon"
  ><md-icon>favorite</md-icon></md-button
>
<md-button class="md-primary md-simple">Simple</md-button>
```

### Sizes

Fancy larger or smaller buttons? Add the classes `md-lg` or `md-sm` for additional sizes.

<md-button class="md-primary md-lg">Large</md-button>
<md-button class="md-primary">Normal</md-button>
<md-button class="md-primary md-sm">Small</md-button>

```html
<md-button class="md-primary md-lg">Large</md-button>
<md-button class="md-primary">Normal</md-button>
<md-button class="md-primary md-sm">Small</md-button>
```

### Extra Mile

We added extra classes that can help you better customise the look. Please see the examples:

<md-button class="md-primary md-block">md-block</md-button>
<md-button class="md-primary md-wd">md-wd</md-button>

```html
<md-button class="md-primary md-block">md-block</md-button>
<md-button class="md-primary md-wd">md-wd</md-button>
```

> Note: for more details about the buttons props and attributes please see the **Button** section from [vuematerial.io](https://vuematerial.io/components/button)
