[← Примеры Razor Pages](/README.md)  

# Русская кодировка в razor pages  
При просмотре кода страницы, вы можете обнаружить, что хотя браузер всё отображает правильно, внутри файла HTML вместо русских букв отображается кракозябра.
Давайте последовательно проверим, всё ли сделано правильно, в оформлении html документа, настройках Visual Studio, настройках проекта.

## HTML
 В разметке лучше прописать язык `html lang="ru"`, а первым тегом поставить ` <meta charset="utf-8">` - это важно, чтобы браузер смог правильно обработать метатеги заголовка и описания, которые написаны на русском языке.
 ```
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="utf-8">
 
 ```
 
 ## Настройка Visual Studio
 Можно столкнуться с тем, что сами файла проекта студия сохраняет не в кодировке UTF-8, а в другой. Тогда надо настроить саму студию:  
 * через главное меню откройте окно параметров: `Средства/Параметры`
 * найдите вкладку `Окружение > Документы`
 * установите флажок `Сохранять документы в формате Юникод, если данные невозможно сохранить в выбранной кодировке`
 
 ## Настройка проекта
 Если предыдущие настройки помогли не полностью, вы видите по русски ту часть текста, которую вы вручную набирали в HTML файле, а вот текст из классов проекта по прежнему выводится кодами, то помогает настройка в _Startup.cs_,
 в метод `ConfigureServices` вставьте код:
 ```
//предотвращение кодирования русских символов
services.AddSingleton(HtmlEncoder.Create(allowedRanges: new[] { UnicodeRanges.BasicLatin, UnicodeRanges.Cyrillic }));
 ```

<br /><br />
<p align="center">
  Практические консультации вы можете получить на наших <a  href="http://creativcode.ru/learn" target="_blank" >веб курсах в Сочи, Адлер</a>:<br /><br />
   <a  href="http://creativcode.ru/learn/webnet" target="_blank" title="Курс веб программирования .Net C#" >
  <img src="http://creativcode.ru/img/learn/net-frontend.jpg" width="400" alt="">
   </a>
</p>
