# Примеры Razor Pages ASP.NET Core
Несколько проектов, в которых показывается, как применять Razor Pages для разработки веб приложений

## [Учебник. Создание веб-приложения Razor Pages →](tutorial/RazorPagesMovie.md)  
В учебнике  создается проект `RazorPagesMovie` в котором приводятся основные сведения о веб-приложении Razor Pages в ASP.NET Core, Рассматривается подключение к базе данных SQL.

## [Дизайн, информационные материалы →](design/bookmarks.md)
Системы дизайна, атомарный дизайн, обработка картинок, наборы иконок и символов.

# Настройки проекта
Различные настройки для домена, установка внешних компонентов, Код представлен в проекте `FrontendSamples`

## [Канонический адрес страницы  →](frontend/canonical-url.md)
Устранение дубликатов страниц и доменов сайта, добавление канонического адреса страницы `link rel="canonical"`

## [Частичное представление  →](frontend/partial.md)   

## [Кеширование  →](frontend/caching.md)  

## [Маршрутизация и перенаправление →](frontend/routing.md)   

## [Обработка ошибок →](frontend/errors.md)  



# Оптимизация

## [Русская кодировка →](frontend/cyrillic.md)   

## [Микроразметка →](frontend/microdata.md)  

## [Разметка для социальных сетей Open Graph →](frontend/opengraph.md)  



# Работа с базой данных  
загрузка иподключение к БД, запросы.

## [EF Core Database First →](https://github.com/creativcode-ru/EF-Core/blob/master/doc/ConsotoDbFirst.md)
Для обновления существующего веб проекта, данные которого хранятся в Azure SQl, мы можем скопировать БД из Azure на свой сервер и работать с локальной копией. Или, по другому, подключится напрямую к Azure SQL, и работать с ней. Зависит от размера базы, и степени её модернизации.

## [Запросы в EF Core →](backend/querying.md)  

# Публикация

## [Azure хостинг  →](backend/azurehost.md) 


<br /><br />
<p align="center">
  Практические консультации вы можете получить на наших <a  href="http://creativcode.ru/learn" target="_blank" >веб курсах в Сочи, Адлер</a>:<br /><br />
   <a  href="http://creativcode.ru/learn/webnet" target="_blank" title="Курс веб программирования .Net C#" >
  <img src="http://creativcode.ru/img/learn/net-learn.jpg" width="400" alt="">
   </a>
</p>


