<?xml version="1.0"?>
<!--
The MIT License (MIT)

Copyright (c) 2017-2024 Yegor Bugayenko

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml" version="2.0">
  <xsl:template match="/">
    <html lang="en">
      <head>
        <meta charset="UTF-8"/>
        <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
        <meta name="description" content="jpeek metrics"/>
        <meta name="keywords" content="code quality metrics"/>
        <meta name="author" content="jpeek.org"/>
        <link rel="shortcut icon" href="https://www.jpeek.org/logo.png"/>
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/yegor256/tacit@gh-pages/tacit-css.min.css"/>
        <link rel="stylesheet" href="jpeek.css"/>
        <script type="text/javascript" src="http://cdnjs.cloudflare.com/ajax/libs/sortable/0.8.0/js/sortable.min.js">&#xA0;</script>
        <title>
          <xsl:text>matrix</xsl:text>
        </title>
      </head>
      <body>
        <xsl:apply-templates select="matrix"/>
        <footer style="color:gray;font-size:75%;">
          <p>
            <xsl:text>This report was generated by </xsl:text>
            <a href="https://www.jpeek.org">
              <xsl:text>jpeek </xsl:text>
              <xsl:value-of select="matrix/@version"/>
            </a>
            <xsl:text> on </xsl:text>
            <xsl:value-of select="matrix/@date"/>
            <xsl:text>.</xsl:text>
          </p>
        </footer>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="matrix">
    <p>
      <a href="https://i.jpeek.org">
        <img alt="logo" src="https://www.jpeek.org/logo.svg" style="height:60px"/>
      </a>
    </p>
    <p>
      <a href="index.html">
        <xsl:text>Back to index</xsl:text>
      </a>
    </p>
    <xsl:apply-templates select="classes"/>
  </xsl:template>
  <xsl:template match="classes">
    <p>
      <xsl:text>There are </xsl:text>
      <xsl:value-of select="count(class)"/>
      <xsl:text> classes:</xsl:text>
    </p>
    <table data-sortable="true">
      <thead>
        <tr>
          <th>
            <xsl:text>Class</xsl:text>
          </th>
          <th style="cursor:pointer">
            <xsl:text>Rank</xsl:text>
          </th>
          <th style="cursor:pointer">
            <xsl:text>Trust</xsl:text>
          </th>
          <xsl:for-each select="class[1]/metric">
            <th class="sorttable_nosort">
              <a href="{@name}.xml">
                <xsl:value-of select="@name"/>
              </a>
            </th>
          </xsl:for-each>
        </tr>
      </thead>
      <tbody>
        <xsl:apply-templates select="class">
          <xsl:sort select="@short_id" order="ascending" data-type="text"/>
        </xsl:apply-templates>
      </tbody>
    </table>
  </xsl:template>
  <xsl:template match="class">
    <tr>
      <td>
        <code title="{@id}">
          <xsl:value-of select="@short_id"/>
        </code>
      </td>
      <td style="text-align:right;">
        <xsl:value-of select="format-number(@rank,'0.00')"/>
      </td>
      <td style="text-align:right;">
        <xsl:value-of select="format-number(@trust,'0.0')"/>
      </td>
      <xsl:apply-templates select="metric">
        <xsl:sort select="@name" order="ascending" data-type="text"/>
      </xsl:apply-templates>
    </tr>
  </xsl:template>
  <xsl:template match="metric">
    <td>
      <xsl:attribute name="style">
        <xsl:text>background-color:</xsl:text>
        <xsl:choose>
          <xsl:when test="@color='red'">
            <xsl:text>red</xsl:text>
          </xsl:when>
          <xsl:when test="@color='green'">
            <xsl:text>green</xsl:text>
          </xsl:when>
          <xsl:when test="@color='yellow'">
            <xsl:text>orange</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>inherit</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text>;</xsl:text>
      </xsl:attribute>
      <xsl:text>&#xA0;</xsl:text>
    </td>
  </xsl:template>
</xsl:stylesheet>
